// Code generated by go generate; DO NOT EDIT.
/*
Copyright 2019 HAProxy Technologies

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package parsers

import (
	"fmt"
	"strings"

	"github.com/haproxytech/client-native/v6/config-parser/common"
	"github.com/haproxytech/client-native/v6/config-parser/errors"
	"github.com/haproxytech/client-native/v6/config-parser/types"
)

type HTTPFailCodes struct {
	// Mode string
	data        []types.HTTPFailCodes
	preComments []string // comments that appear before the actual line
}

func (h *HTTPFailCodes) parse(line string, parts []string, comment string) (*types.HTTPFailCodes, error) {
	if len(parts) < 2 {
		return nil, &errors.ParseError{Parser: "HTTPFailCodes", Line: line}
	}
	if parts[0] == "http-fail-codes" {
		value := strings.Join(parts[1:], " ")
		data := &types.HTTPFailCodes{
			StringC: types.StringC{
				Value:   value,
				Comment: comment,
			},
		}
		return data, nil
	}
	return nil, &errors.ParseError{Parser: "HTTPFailCodes", Line: line}
}

func (h *HTTPFailCodes) Result() ([]common.ReturnResultLine, error) {
	if len(h.data) == 0 {
		return nil, errors.ErrFetch
	}

	result := make([]common.ReturnResultLine, len(h.data))
	for index, req := range h.data {
		result[index] = common.ReturnResultLine{
			Data:    fmt.Sprintf("http-fail-codes %s", req.Value),
			Comment: req.Comment,
		}
	}
	return result, nil
}
