package audits

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"

	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/network"
	"github.com/chromedp/cdproto/runtime"
	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jlexer"
	"github.com/mailru/easyjson/jwriter"
)

// AffectedCookie information about a cookie that is affected by an inspector
// issue.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-AffectedCookie
type AffectedCookie struct {
	Name   string `json:"name"` // The following three properties uniquely identify a cookie
	Path   string `json:"path"`
	Domain string `json:"domain"`
}

// AffectedRequest information about a request that is affected by an
// inspector issue.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-AffectedRequest
type AffectedRequest struct {
	RequestID network.RequestID `json:"requestId"` // The unique request id.
	URL       string            `json:"url,omitempty"`
}

// AffectedFrame information about the frame affected by an inspector issue.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-AffectedFrame
type AffectedFrame struct {
	FrameID cdp.FrameID `json:"frameId"`
}

// CookieExclusionReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-CookieExclusionReason
type CookieExclusionReason string

// String returns the CookieExclusionReason as string value.
func (t CookieExclusionReason) String() string {
	return string(t)
}

// CookieExclusionReason values.
const (
	CookieExclusionReasonExcludeSameSiteUnspecifiedTreatedAsLax        CookieExclusionReason = "ExcludeSameSiteUnspecifiedTreatedAsLax"
	CookieExclusionReasonExcludeSameSiteNoneInsecure                   CookieExclusionReason = "ExcludeSameSiteNoneInsecure"
	CookieExclusionReasonExcludeSameSiteLax                            CookieExclusionReason = "ExcludeSameSiteLax"
	CookieExclusionReasonExcludeSameSiteStrict                         CookieExclusionReason = "ExcludeSameSiteStrict"
	CookieExclusionReasonExcludeInvalidSameParty                       CookieExclusionReason = "ExcludeInvalidSameParty"
	CookieExclusionReasonExcludeSamePartyCrossPartyContext             CookieExclusionReason = "ExcludeSamePartyCrossPartyContext"
	CookieExclusionReasonExcludeDomainNonASCII                         CookieExclusionReason = "ExcludeDomainNonASCII"
	CookieExclusionReasonExcludeThirdPartyCookieBlockedInFirstPartySet CookieExclusionReason = "ExcludeThirdPartyCookieBlockedInFirstPartySet"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t CookieExclusionReason) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t CookieExclusionReason) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *CookieExclusionReason) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch CookieExclusionReason(v) {
	case CookieExclusionReasonExcludeSameSiteUnspecifiedTreatedAsLax:
		*t = CookieExclusionReasonExcludeSameSiteUnspecifiedTreatedAsLax
	case CookieExclusionReasonExcludeSameSiteNoneInsecure:
		*t = CookieExclusionReasonExcludeSameSiteNoneInsecure
	case CookieExclusionReasonExcludeSameSiteLax:
		*t = CookieExclusionReasonExcludeSameSiteLax
	case CookieExclusionReasonExcludeSameSiteStrict:
		*t = CookieExclusionReasonExcludeSameSiteStrict
	case CookieExclusionReasonExcludeInvalidSameParty:
		*t = CookieExclusionReasonExcludeInvalidSameParty
	case CookieExclusionReasonExcludeSamePartyCrossPartyContext:
		*t = CookieExclusionReasonExcludeSamePartyCrossPartyContext
	case CookieExclusionReasonExcludeDomainNonASCII:
		*t = CookieExclusionReasonExcludeDomainNonASCII
	case CookieExclusionReasonExcludeThirdPartyCookieBlockedInFirstPartySet:
		*t = CookieExclusionReasonExcludeThirdPartyCookieBlockedInFirstPartySet

	default:
		in.AddError(fmt.Errorf("unknown CookieExclusionReason value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *CookieExclusionReason) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// CookieWarningReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-CookieWarningReason
type CookieWarningReason string

// String returns the CookieWarningReason as string value.
func (t CookieWarningReason) String() string {
	return string(t)
}

// CookieWarningReason values.
const (
	CookieWarningReasonWarnSameSiteUnspecifiedCrossSiteContext CookieWarningReason = "WarnSameSiteUnspecifiedCrossSiteContext"
	CookieWarningReasonWarnSameSiteNoneInsecure                CookieWarningReason = "WarnSameSiteNoneInsecure"
	CookieWarningReasonWarnSameSiteUnspecifiedLaxAllowUnsafe   CookieWarningReason = "WarnSameSiteUnspecifiedLaxAllowUnsafe"
	CookieWarningReasonWarnSameSiteStrictLaxDowngradeStrict    CookieWarningReason = "WarnSameSiteStrictLaxDowngradeStrict"
	CookieWarningReasonWarnSameSiteStrictCrossDowngradeStrict  CookieWarningReason = "WarnSameSiteStrictCrossDowngradeStrict"
	CookieWarningReasonWarnSameSiteStrictCrossDowngradeLax     CookieWarningReason = "WarnSameSiteStrictCrossDowngradeLax"
	CookieWarningReasonWarnSameSiteLaxCrossDowngradeStrict     CookieWarningReason = "WarnSameSiteLaxCrossDowngradeStrict"
	CookieWarningReasonWarnSameSiteLaxCrossDowngradeLax        CookieWarningReason = "WarnSameSiteLaxCrossDowngradeLax"
	CookieWarningReasonWarnAttributeValueExceedsMaxSize        CookieWarningReason = "WarnAttributeValueExceedsMaxSize"
	CookieWarningReasonWarnDomainNonASCII                      CookieWarningReason = "WarnDomainNonASCII"
	CookieWarningReasonWarnThirdPartyPhaseout                  CookieWarningReason = "WarnThirdPartyPhaseout"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t CookieWarningReason) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t CookieWarningReason) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *CookieWarningReason) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch CookieWarningReason(v) {
	case CookieWarningReasonWarnSameSiteUnspecifiedCrossSiteContext:
		*t = CookieWarningReasonWarnSameSiteUnspecifiedCrossSiteContext
	case CookieWarningReasonWarnSameSiteNoneInsecure:
		*t = CookieWarningReasonWarnSameSiteNoneInsecure
	case CookieWarningReasonWarnSameSiteUnspecifiedLaxAllowUnsafe:
		*t = CookieWarningReasonWarnSameSiteUnspecifiedLaxAllowUnsafe
	case CookieWarningReasonWarnSameSiteStrictLaxDowngradeStrict:
		*t = CookieWarningReasonWarnSameSiteStrictLaxDowngradeStrict
	case CookieWarningReasonWarnSameSiteStrictCrossDowngradeStrict:
		*t = CookieWarningReasonWarnSameSiteStrictCrossDowngradeStrict
	case CookieWarningReasonWarnSameSiteStrictCrossDowngradeLax:
		*t = CookieWarningReasonWarnSameSiteStrictCrossDowngradeLax
	case CookieWarningReasonWarnSameSiteLaxCrossDowngradeStrict:
		*t = CookieWarningReasonWarnSameSiteLaxCrossDowngradeStrict
	case CookieWarningReasonWarnSameSiteLaxCrossDowngradeLax:
		*t = CookieWarningReasonWarnSameSiteLaxCrossDowngradeLax
	case CookieWarningReasonWarnAttributeValueExceedsMaxSize:
		*t = CookieWarningReasonWarnAttributeValueExceedsMaxSize
	case CookieWarningReasonWarnDomainNonASCII:
		*t = CookieWarningReasonWarnDomainNonASCII
	case CookieWarningReasonWarnThirdPartyPhaseout:
		*t = CookieWarningReasonWarnThirdPartyPhaseout

	default:
		in.AddError(fmt.Errorf("unknown CookieWarningReason value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *CookieWarningReason) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// CookieOperation [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-CookieOperation
type CookieOperation string

// String returns the CookieOperation as string value.
func (t CookieOperation) String() string {
	return string(t)
}

// CookieOperation values.
const (
	CookieOperationSetCookie  CookieOperation = "SetCookie"
	CookieOperationReadCookie CookieOperation = "ReadCookie"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t CookieOperation) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t CookieOperation) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *CookieOperation) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch CookieOperation(v) {
	case CookieOperationSetCookie:
		*t = CookieOperationSetCookie
	case CookieOperationReadCookie:
		*t = CookieOperationReadCookie

	default:
		in.AddError(fmt.Errorf("unknown CookieOperation value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *CookieOperation) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// CookieIssueDetails this information is currently necessary, as the
// front-end has a difficult time finding a specific cookie. With this, we can
// convey specific error information without the cookie.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-CookieIssueDetails
type CookieIssueDetails struct {
	Cookie                 *AffectedCookie         `json:"cookie,omitempty"` // If AffectedCookie is not set then rawCookieLine contains the raw Set-Cookie header string. This hints at a problem where the cookie line is syntactically or semantically malformed in a way that no valid cookie could be created.
	RawCookieLine          string                  `json:"rawCookieLine,omitempty"`
	CookieWarningReasons   []CookieWarningReason   `json:"cookieWarningReasons"`
	CookieExclusionReasons []CookieExclusionReason `json:"cookieExclusionReasons"`
	Operation              CookieOperation         `json:"operation"` // Optionally identifies the site-for-cookies and the cookie url, which may be used by the front-end as additional context.
	SiteForCookies         string                  `json:"siteForCookies,omitempty"`
	CookieURL              string                  `json:"cookieUrl,omitempty"`
	Request                *AffectedRequest        `json:"request,omitempty"`
}

// MixedContentResolutionStatus [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-MixedContentResolutionStatus
type MixedContentResolutionStatus string

// String returns the MixedContentResolutionStatus as string value.
func (t MixedContentResolutionStatus) String() string {
	return string(t)
}

// MixedContentResolutionStatus values.
const (
	MixedContentResolutionStatusMixedContentBlocked               MixedContentResolutionStatus = "MixedContentBlocked"
	MixedContentResolutionStatusMixedContentAutomaticallyUpgraded MixedContentResolutionStatus = "MixedContentAutomaticallyUpgraded"
	MixedContentResolutionStatusMixedContentWarning               MixedContentResolutionStatus = "MixedContentWarning"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t MixedContentResolutionStatus) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t MixedContentResolutionStatus) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *MixedContentResolutionStatus) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch MixedContentResolutionStatus(v) {
	case MixedContentResolutionStatusMixedContentBlocked:
		*t = MixedContentResolutionStatusMixedContentBlocked
	case MixedContentResolutionStatusMixedContentAutomaticallyUpgraded:
		*t = MixedContentResolutionStatusMixedContentAutomaticallyUpgraded
	case MixedContentResolutionStatusMixedContentWarning:
		*t = MixedContentResolutionStatusMixedContentWarning

	default:
		in.AddError(fmt.Errorf("unknown MixedContentResolutionStatus value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *MixedContentResolutionStatus) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// MixedContentResourceType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-MixedContentResourceType
type MixedContentResourceType string

// String returns the MixedContentResourceType as string value.
func (t MixedContentResourceType) String() string {
	return string(t)
}

// MixedContentResourceType values.
const (
	MixedContentResourceTypeAttributionSrc MixedContentResourceType = "AttributionSrc"
	MixedContentResourceTypeAudio          MixedContentResourceType = "Audio"
	MixedContentResourceTypeBeacon         MixedContentResourceType = "Beacon"
	MixedContentResourceTypeCSPReport      MixedContentResourceType = "CSPReport"
	MixedContentResourceTypeDownload       MixedContentResourceType = "Download"
	MixedContentResourceTypeEventSource    MixedContentResourceType = "EventSource"
	MixedContentResourceTypeFavicon        MixedContentResourceType = "Favicon"
	MixedContentResourceTypeFont           MixedContentResourceType = "Font"
	MixedContentResourceTypeForm           MixedContentResourceType = "Form"
	MixedContentResourceTypeFrame          MixedContentResourceType = "Frame"
	MixedContentResourceTypeImage          MixedContentResourceType = "Image"
	MixedContentResourceTypeImport         MixedContentResourceType = "Import"
	MixedContentResourceTypeManifest       MixedContentResourceType = "Manifest"
	MixedContentResourceTypePing           MixedContentResourceType = "Ping"
	MixedContentResourceTypePluginData     MixedContentResourceType = "PluginData"
	MixedContentResourceTypePluginResource MixedContentResourceType = "PluginResource"
	MixedContentResourceTypePrefetch       MixedContentResourceType = "Prefetch"
	MixedContentResourceTypeResource       MixedContentResourceType = "Resource"
	MixedContentResourceTypeScript         MixedContentResourceType = "Script"
	MixedContentResourceTypeServiceWorker  MixedContentResourceType = "ServiceWorker"
	MixedContentResourceTypeSharedWorker   MixedContentResourceType = "SharedWorker"
	MixedContentResourceTypeStylesheet     MixedContentResourceType = "Stylesheet"
	MixedContentResourceTypeTrack          MixedContentResourceType = "Track"
	MixedContentResourceTypeVideo          MixedContentResourceType = "Video"
	MixedContentResourceTypeWorker         MixedContentResourceType = "Worker"
	MixedContentResourceTypeXMLHTTPRequest MixedContentResourceType = "XMLHttpRequest"
	MixedContentResourceTypeXSLT           MixedContentResourceType = "XSLT"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t MixedContentResourceType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t MixedContentResourceType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *MixedContentResourceType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch MixedContentResourceType(v) {
	case MixedContentResourceTypeAttributionSrc:
		*t = MixedContentResourceTypeAttributionSrc
	case MixedContentResourceTypeAudio:
		*t = MixedContentResourceTypeAudio
	case MixedContentResourceTypeBeacon:
		*t = MixedContentResourceTypeBeacon
	case MixedContentResourceTypeCSPReport:
		*t = MixedContentResourceTypeCSPReport
	case MixedContentResourceTypeDownload:
		*t = MixedContentResourceTypeDownload
	case MixedContentResourceTypeEventSource:
		*t = MixedContentResourceTypeEventSource
	case MixedContentResourceTypeFavicon:
		*t = MixedContentResourceTypeFavicon
	case MixedContentResourceTypeFont:
		*t = MixedContentResourceTypeFont
	case MixedContentResourceTypeForm:
		*t = MixedContentResourceTypeForm
	case MixedContentResourceTypeFrame:
		*t = MixedContentResourceTypeFrame
	case MixedContentResourceTypeImage:
		*t = MixedContentResourceTypeImage
	case MixedContentResourceTypeImport:
		*t = MixedContentResourceTypeImport
	case MixedContentResourceTypeManifest:
		*t = MixedContentResourceTypeManifest
	case MixedContentResourceTypePing:
		*t = MixedContentResourceTypePing
	case MixedContentResourceTypePluginData:
		*t = MixedContentResourceTypePluginData
	case MixedContentResourceTypePluginResource:
		*t = MixedContentResourceTypePluginResource
	case MixedContentResourceTypePrefetch:
		*t = MixedContentResourceTypePrefetch
	case MixedContentResourceTypeResource:
		*t = MixedContentResourceTypeResource
	case MixedContentResourceTypeScript:
		*t = MixedContentResourceTypeScript
	case MixedContentResourceTypeServiceWorker:
		*t = MixedContentResourceTypeServiceWorker
	case MixedContentResourceTypeSharedWorker:
		*t = MixedContentResourceTypeSharedWorker
	case MixedContentResourceTypeStylesheet:
		*t = MixedContentResourceTypeStylesheet
	case MixedContentResourceTypeTrack:
		*t = MixedContentResourceTypeTrack
	case MixedContentResourceTypeVideo:
		*t = MixedContentResourceTypeVideo
	case MixedContentResourceTypeWorker:
		*t = MixedContentResourceTypeWorker
	case MixedContentResourceTypeXMLHTTPRequest:
		*t = MixedContentResourceTypeXMLHTTPRequest
	case MixedContentResourceTypeXSLT:
		*t = MixedContentResourceTypeXSLT

	default:
		in.AddError(fmt.Errorf("unknown MixedContentResourceType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *MixedContentResourceType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// MixedContentIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-MixedContentIssueDetails
type MixedContentIssueDetails struct {
	ResourceType     MixedContentResourceType     `json:"resourceType,omitempty"` // The type of resource causing the mixed content issue (css, js, iframe, form,...). Marked as optional because it is mapped to from blink::mojom::RequestContextType, which will be replaced by network::mojom::RequestDestination
	ResolutionStatus MixedContentResolutionStatus `json:"resolutionStatus"`       // The way the mixed content issue is being resolved.
	InsecureURL      string                       `json:"insecureURL"`            // The unsafe http url causing the mixed content issue.
	MainResourceURL  string                       `json:"mainResourceURL"`        // The url responsible for the call to an unsafe url.
	Request          *AffectedRequest             `json:"request,omitempty"`      // The mixed content request. Does not always exist (e.g. for unsafe form submission urls).
	Frame            *AffectedFrame               `json:"frame,omitempty"`        // Optional because not every mixed content issue is necessarily linked to a frame.
}

// BlockedByResponseReason enum indicating the reason a response has been
// blocked. These reasons are refinements of the net error BLOCKED_BY_RESPONSE.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-BlockedByResponseReason
type BlockedByResponseReason string

// String returns the BlockedByResponseReason as string value.
func (t BlockedByResponseReason) String() string {
	return string(t)
}

// BlockedByResponseReason values.
const (
	BlockedByResponseReasonCoepFrameResourceNeedsCoepHeader                  BlockedByResponseReason = "CoepFrameResourceNeedsCoepHeader"
	BlockedByResponseReasonCoopSandboxedIFrameCannotNavigateToCoopPage       BlockedByResponseReason = "CoopSandboxedIFrameCannotNavigateToCoopPage"
	BlockedByResponseReasonCorpNotSameOrigin                                 BlockedByResponseReason = "CorpNotSameOrigin"
	BlockedByResponseReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoep BlockedByResponseReason = "CorpNotSameOriginAfterDefaultedToSameOriginByCoep"
	BlockedByResponseReasonCorpNotSameSite                                   BlockedByResponseReason = "CorpNotSameSite"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t BlockedByResponseReason) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t BlockedByResponseReason) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *BlockedByResponseReason) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch BlockedByResponseReason(v) {
	case BlockedByResponseReasonCoepFrameResourceNeedsCoepHeader:
		*t = BlockedByResponseReasonCoepFrameResourceNeedsCoepHeader
	case BlockedByResponseReasonCoopSandboxedIFrameCannotNavigateToCoopPage:
		*t = BlockedByResponseReasonCoopSandboxedIFrameCannotNavigateToCoopPage
	case BlockedByResponseReasonCorpNotSameOrigin:
		*t = BlockedByResponseReasonCorpNotSameOrigin
	case BlockedByResponseReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoep:
		*t = BlockedByResponseReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoep
	case BlockedByResponseReasonCorpNotSameSite:
		*t = BlockedByResponseReasonCorpNotSameSite

	default:
		in.AddError(fmt.Errorf("unknown BlockedByResponseReason value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *BlockedByResponseReason) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// BlockedByResponseIssueDetails details for a request that has been blocked
// with the BLOCKED_BY_RESPONSE code. Currently only used for COEP/COOP, but may
// be extended to include some CSP errors in the future.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-BlockedByResponseIssueDetails
type BlockedByResponseIssueDetails struct {
	Request      *AffectedRequest        `json:"request"`
	ParentFrame  *AffectedFrame          `json:"parentFrame,omitempty"`
	BlockedFrame *AffectedFrame          `json:"blockedFrame,omitempty"`
	Reason       BlockedByResponseReason `json:"reason"`
}

// HeavyAdResolutionStatus [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-HeavyAdResolutionStatus
type HeavyAdResolutionStatus string

// String returns the HeavyAdResolutionStatus as string value.
func (t HeavyAdResolutionStatus) String() string {
	return string(t)
}

// HeavyAdResolutionStatus values.
const (
	HeavyAdResolutionStatusHeavyAdBlocked HeavyAdResolutionStatus = "HeavyAdBlocked"
	HeavyAdResolutionStatusHeavyAdWarning HeavyAdResolutionStatus = "HeavyAdWarning"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t HeavyAdResolutionStatus) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t HeavyAdResolutionStatus) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *HeavyAdResolutionStatus) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch HeavyAdResolutionStatus(v) {
	case HeavyAdResolutionStatusHeavyAdBlocked:
		*t = HeavyAdResolutionStatusHeavyAdBlocked
	case HeavyAdResolutionStatusHeavyAdWarning:
		*t = HeavyAdResolutionStatusHeavyAdWarning

	default:
		in.AddError(fmt.Errorf("unknown HeavyAdResolutionStatus value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *HeavyAdResolutionStatus) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// HeavyAdReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-HeavyAdReason
type HeavyAdReason string

// String returns the HeavyAdReason as string value.
func (t HeavyAdReason) String() string {
	return string(t)
}

// HeavyAdReason values.
const (
	HeavyAdReasonNetworkTotalLimit HeavyAdReason = "NetworkTotalLimit"
	HeavyAdReasonCPUTotalLimit     HeavyAdReason = "CpuTotalLimit"
	HeavyAdReasonCPUPeakLimit      HeavyAdReason = "CpuPeakLimit"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t HeavyAdReason) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t HeavyAdReason) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *HeavyAdReason) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch HeavyAdReason(v) {
	case HeavyAdReasonNetworkTotalLimit:
		*t = HeavyAdReasonNetworkTotalLimit
	case HeavyAdReasonCPUTotalLimit:
		*t = HeavyAdReasonCPUTotalLimit
	case HeavyAdReasonCPUPeakLimit:
		*t = HeavyAdReasonCPUPeakLimit

	default:
		in.AddError(fmt.Errorf("unknown HeavyAdReason value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *HeavyAdReason) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// HeavyAdIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-HeavyAdIssueDetails
type HeavyAdIssueDetails struct {
	Resolution HeavyAdResolutionStatus `json:"resolution"` // The resolution status, either blocking the content or warning.
	Reason     HeavyAdReason           `json:"reason"`     // The reason the ad was blocked, total network or cpu or peak cpu.
	Frame      *AffectedFrame          `json:"frame"`      // The frame that was blocked.
}

// ContentSecurityPolicyViolationType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-ContentSecurityPolicyViolationType
type ContentSecurityPolicyViolationType string

// String returns the ContentSecurityPolicyViolationType as string value.
func (t ContentSecurityPolicyViolationType) String() string {
	return string(t)
}

// ContentSecurityPolicyViolationType values.
const (
	ContentSecurityPolicyViolationTypeKInlineViolation             ContentSecurityPolicyViolationType = "kInlineViolation"
	ContentSecurityPolicyViolationTypeKEvalViolation               ContentSecurityPolicyViolationType = "kEvalViolation"
	ContentSecurityPolicyViolationTypeKURLViolation                ContentSecurityPolicyViolationType = "kURLViolation"
	ContentSecurityPolicyViolationTypeKTrustedTypesSinkViolation   ContentSecurityPolicyViolationType = "kTrustedTypesSinkViolation"
	ContentSecurityPolicyViolationTypeKTrustedTypesPolicyViolation ContentSecurityPolicyViolationType = "kTrustedTypesPolicyViolation"
	ContentSecurityPolicyViolationTypeKWasmEvalViolation           ContentSecurityPolicyViolationType = "kWasmEvalViolation"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t ContentSecurityPolicyViolationType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t ContentSecurityPolicyViolationType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *ContentSecurityPolicyViolationType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch ContentSecurityPolicyViolationType(v) {
	case ContentSecurityPolicyViolationTypeKInlineViolation:
		*t = ContentSecurityPolicyViolationTypeKInlineViolation
	case ContentSecurityPolicyViolationTypeKEvalViolation:
		*t = ContentSecurityPolicyViolationTypeKEvalViolation
	case ContentSecurityPolicyViolationTypeKURLViolation:
		*t = ContentSecurityPolicyViolationTypeKURLViolation
	case ContentSecurityPolicyViolationTypeKTrustedTypesSinkViolation:
		*t = ContentSecurityPolicyViolationTypeKTrustedTypesSinkViolation
	case ContentSecurityPolicyViolationTypeKTrustedTypesPolicyViolation:
		*t = ContentSecurityPolicyViolationTypeKTrustedTypesPolicyViolation
	case ContentSecurityPolicyViolationTypeKWasmEvalViolation:
		*t = ContentSecurityPolicyViolationTypeKWasmEvalViolation

	default:
		in.AddError(fmt.Errorf("unknown ContentSecurityPolicyViolationType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *ContentSecurityPolicyViolationType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// SourceCodeLocation [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-SourceCodeLocation
type SourceCodeLocation struct {
	ScriptID     runtime.ScriptID `json:"scriptId,omitempty"`
	URL          string           `json:"url"`
	LineNumber   int64            `json:"lineNumber"`
	ColumnNumber int64            `json:"columnNumber"`
}

// ContentSecurityPolicyIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-ContentSecurityPolicyIssueDetails
type ContentSecurityPolicyIssueDetails struct {
	BlockedURL                         string                             `json:"blockedURL,omitempty"` // The url not included in allowed sources.
	ViolatedDirective                  string                             `json:"violatedDirective"`    // Specific directive that is violated, causing the CSP issue.
	IsReportOnly                       bool                               `json:"isReportOnly"`
	ContentSecurityPolicyViolationType ContentSecurityPolicyViolationType `json:"contentSecurityPolicyViolationType"`
	FrameAncestor                      *AffectedFrame                     `json:"frameAncestor,omitempty"`
	SourceCodeLocation                 *SourceCodeLocation                `json:"sourceCodeLocation,omitempty"`
	ViolatingNodeID                    cdp.BackendNodeID                  `json:"violatingNodeId,omitempty"`
}

// SharedArrayBufferIssueType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-SharedArrayBufferIssueType
type SharedArrayBufferIssueType string

// String returns the SharedArrayBufferIssueType as string value.
func (t SharedArrayBufferIssueType) String() string {
	return string(t)
}

// SharedArrayBufferIssueType values.
const (
	SharedArrayBufferIssueTypeTransferIssue SharedArrayBufferIssueType = "TransferIssue"
	SharedArrayBufferIssueTypeCreationIssue SharedArrayBufferIssueType = "CreationIssue"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t SharedArrayBufferIssueType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t SharedArrayBufferIssueType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *SharedArrayBufferIssueType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch SharedArrayBufferIssueType(v) {
	case SharedArrayBufferIssueTypeTransferIssue:
		*t = SharedArrayBufferIssueTypeTransferIssue
	case SharedArrayBufferIssueTypeCreationIssue:
		*t = SharedArrayBufferIssueTypeCreationIssue

	default:
		in.AddError(fmt.Errorf("unknown SharedArrayBufferIssueType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *SharedArrayBufferIssueType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// SharedArrayBufferIssueDetails details for a issue arising from an SAB
// being instantiated in, or transferred to a context that is not cross-origin
// isolated.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-SharedArrayBufferIssueDetails
type SharedArrayBufferIssueDetails struct {
	SourceCodeLocation *SourceCodeLocation        `json:"sourceCodeLocation"`
	IsWarning          bool                       `json:"isWarning"`
	Type               SharedArrayBufferIssueType `json:"type"`
}

// LowTextContrastIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-LowTextContrastIssueDetails
type LowTextContrastIssueDetails struct {
	ViolatingNodeID       cdp.BackendNodeID `json:"violatingNodeId"`
	ViolatingNodeSelector string            `json:"violatingNodeSelector"`
	ContrastRatio         float64           `json:"contrastRatio"`
	ThresholdAA           float64           `json:"thresholdAA"`
	ThresholdAAA          float64           `json:"thresholdAAA"`
	FontSize              string            `json:"fontSize"`
	FontWeight            string            `json:"fontWeight"`
}

// CorsIssueDetails details for a CORS related issue, e.g. a warning or error
// related to CORS RFC1918 enforcement.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-CorsIssueDetails
type CorsIssueDetails struct {
	CorsErrorStatus        *network.CorsErrorStatus     `json:"corsErrorStatus"`
	IsWarning              bool                         `json:"isWarning"`
	Request                *AffectedRequest             `json:"request"`
	Location               *SourceCodeLocation          `json:"location,omitempty"`
	InitiatorOrigin        string                       `json:"initiatorOrigin,omitempty"`
	ResourceIPAddressSpace network.IPAddressSpace       `json:"resourceIPAddressSpace,omitempty"`
	ClientSecurityState    *network.ClientSecurityState `json:"clientSecurityState,omitempty"`
}

// AttributionReportingIssueType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-AttributionReportingIssueType
type AttributionReportingIssueType string

// String returns the AttributionReportingIssueType as string value.
func (t AttributionReportingIssueType) String() string {
	return string(t)
}

// AttributionReportingIssueType values.
const (
	AttributionReportingIssueTypePermissionPolicyDisabled                             AttributionReportingIssueType = "PermissionPolicyDisabled"
	AttributionReportingIssueTypeUntrustworthyReportingOrigin                         AttributionReportingIssueType = "UntrustworthyReportingOrigin"
	AttributionReportingIssueTypeInsecureContext                                      AttributionReportingIssueType = "InsecureContext"
	AttributionReportingIssueTypeInvalidHeader                                        AttributionReportingIssueType = "InvalidHeader"
	AttributionReportingIssueTypeInvalidRegisterTriggerHeader                         AttributionReportingIssueType = "InvalidRegisterTriggerHeader"
	AttributionReportingIssueTypeSourceAndTriggerHeaders                              AttributionReportingIssueType = "SourceAndTriggerHeaders"
	AttributionReportingIssueTypeSourceIgnored                                        AttributionReportingIssueType = "SourceIgnored"
	AttributionReportingIssueTypeTriggerIgnored                                       AttributionReportingIssueType = "TriggerIgnored"
	AttributionReportingIssueTypeOsSourceIgnored                                      AttributionReportingIssueType = "OsSourceIgnored"
	AttributionReportingIssueTypeOsTriggerIgnored                                     AttributionReportingIssueType = "OsTriggerIgnored"
	AttributionReportingIssueTypeInvalidRegisterOsSourceHeader                        AttributionReportingIssueType = "InvalidRegisterOsSourceHeader"
	AttributionReportingIssueTypeInvalidRegisterOsTriggerHeader                       AttributionReportingIssueType = "InvalidRegisterOsTriggerHeader"
	AttributionReportingIssueTypeWebAndOsHeaders                                      AttributionReportingIssueType = "WebAndOsHeaders"
	AttributionReportingIssueTypeNoWebOrOsSupport                                     AttributionReportingIssueType = "NoWebOrOsSupport"
	AttributionReportingIssueTypeNavigationRegistrationWithoutTransientUserActivation AttributionReportingIssueType = "NavigationRegistrationWithoutTransientUserActivation"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t AttributionReportingIssueType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t AttributionReportingIssueType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *AttributionReportingIssueType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch AttributionReportingIssueType(v) {
	case AttributionReportingIssueTypePermissionPolicyDisabled:
		*t = AttributionReportingIssueTypePermissionPolicyDisabled
	case AttributionReportingIssueTypeUntrustworthyReportingOrigin:
		*t = AttributionReportingIssueTypeUntrustworthyReportingOrigin
	case AttributionReportingIssueTypeInsecureContext:
		*t = AttributionReportingIssueTypeInsecureContext
	case AttributionReportingIssueTypeInvalidHeader:
		*t = AttributionReportingIssueTypeInvalidHeader
	case AttributionReportingIssueTypeInvalidRegisterTriggerHeader:
		*t = AttributionReportingIssueTypeInvalidRegisterTriggerHeader
	case AttributionReportingIssueTypeSourceAndTriggerHeaders:
		*t = AttributionReportingIssueTypeSourceAndTriggerHeaders
	case AttributionReportingIssueTypeSourceIgnored:
		*t = AttributionReportingIssueTypeSourceIgnored
	case AttributionReportingIssueTypeTriggerIgnored:
		*t = AttributionReportingIssueTypeTriggerIgnored
	case AttributionReportingIssueTypeOsSourceIgnored:
		*t = AttributionReportingIssueTypeOsSourceIgnored
	case AttributionReportingIssueTypeOsTriggerIgnored:
		*t = AttributionReportingIssueTypeOsTriggerIgnored
	case AttributionReportingIssueTypeInvalidRegisterOsSourceHeader:
		*t = AttributionReportingIssueTypeInvalidRegisterOsSourceHeader
	case AttributionReportingIssueTypeInvalidRegisterOsTriggerHeader:
		*t = AttributionReportingIssueTypeInvalidRegisterOsTriggerHeader
	case AttributionReportingIssueTypeWebAndOsHeaders:
		*t = AttributionReportingIssueTypeWebAndOsHeaders
	case AttributionReportingIssueTypeNoWebOrOsSupport:
		*t = AttributionReportingIssueTypeNoWebOrOsSupport
	case AttributionReportingIssueTypeNavigationRegistrationWithoutTransientUserActivation:
		*t = AttributionReportingIssueTypeNavigationRegistrationWithoutTransientUserActivation

	default:
		in.AddError(fmt.Errorf("unknown AttributionReportingIssueType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *AttributionReportingIssueType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// AttributionReportingIssueDetails details for issues around "Attribution
// Reporting API" usage. Explainer:
// https://github.com/WICG/attribution-reporting-api.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-AttributionReportingIssueDetails
type AttributionReportingIssueDetails struct {
	ViolationType    AttributionReportingIssueType `json:"violationType"`
	Request          *AffectedRequest              `json:"request,omitempty"`
	ViolatingNodeID  cdp.BackendNodeID             `json:"violatingNodeId,omitempty"`
	InvalidParameter string                        `json:"invalidParameter,omitempty"`
}

// QuirksModeIssueDetails details for issues about documents in Quirks Mode
// or Limited Quirks Mode that affects page layouting.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-QuirksModeIssueDetails
type QuirksModeIssueDetails struct {
	IsLimitedQuirksMode bool              `json:"isLimitedQuirksMode"` // If false, it means the document's mode is "quirks" instead of "limited-quirks".
	DocumentNodeID      cdp.BackendNodeID `json:"documentNodeId"`
	URL                 string            `json:"url"`
	FrameID             cdp.FrameID       `json:"frameId"`
	LoaderID            cdp.LoaderID      `json:"loaderId"`
}

// GenericIssueErrorType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-GenericIssueErrorType
type GenericIssueErrorType string

// String returns the GenericIssueErrorType as string value.
func (t GenericIssueErrorType) String() string {
	return string(t)
}

// GenericIssueErrorType values.
const (
	GenericIssueErrorTypeCrossOriginPortalPostMessageError                          GenericIssueErrorType = "CrossOriginPortalPostMessageError"
	GenericIssueErrorTypeFormLabelForNameError                                      GenericIssueErrorType = "FormLabelForNameError"
	GenericIssueErrorTypeFormDuplicateIDForInputError                               GenericIssueErrorType = "FormDuplicateIdForInputError"
	GenericIssueErrorTypeFormInputWithNoLabelError                                  GenericIssueErrorType = "FormInputWithNoLabelError"
	GenericIssueErrorTypeFormAutocompleteAttributeEmptyError                        GenericIssueErrorType = "FormAutocompleteAttributeEmptyError"
	GenericIssueErrorTypeFormEmptyIDAndNameAttributesForInputError                  GenericIssueErrorType = "FormEmptyIdAndNameAttributesForInputError"
	GenericIssueErrorTypeFormAriaLabelledByToNonExistingID                          GenericIssueErrorType = "FormAriaLabelledByToNonExistingId"
	GenericIssueErrorTypeFormInputAssignedAutocompleteValueToIDOrNameAttributeError GenericIssueErrorType = "FormInputAssignedAutocompleteValueToIdOrNameAttributeError"
	GenericIssueErrorTypeFormLabelHasNeitherForNorNestedInput                       GenericIssueErrorType = "FormLabelHasNeitherForNorNestedInput"
	GenericIssueErrorTypeFormLabelForMatchesNonExistingIDError                      GenericIssueErrorType = "FormLabelForMatchesNonExistingIdError"
	GenericIssueErrorTypeFormInputHasWrongButWellIntendedAutocompleteValueError     GenericIssueErrorType = "FormInputHasWrongButWellIntendedAutocompleteValueError"
	GenericIssueErrorTypeResponseWasBlockedByORB                                    GenericIssueErrorType = "ResponseWasBlockedByORB"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t GenericIssueErrorType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t GenericIssueErrorType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *GenericIssueErrorType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch GenericIssueErrorType(v) {
	case GenericIssueErrorTypeCrossOriginPortalPostMessageError:
		*t = GenericIssueErrorTypeCrossOriginPortalPostMessageError
	case GenericIssueErrorTypeFormLabelForNameError:
		*t = GenericIssueErrorTypeFormLabelForNameError
	case GenericIssueErrorTypeFormDuplicateIDForInputError:
		*t = GenericIssueErrorTypeFormDuplicateIDForInputError
	case GenericIssueErrorTypeFormInputWithNoLabelError:
		*t = GenericIssueErrorTypeFormInputWithNoLabelError
	case GenericIssueErrorTypeFormAutocompleteAttributeEmptyError:
		*t = GenericIssueErrorTypeFormAutocompleteAttributeEmptyError
	case GenericIssueErrorTypeFormEmptyIDAndNameAttributesForInputError:
		*t = GenericIssueErrorTypeFormEmptyIDAndNameAttributesForInputError
	case GenericIssueErrorTypeFormAriaLabelledByToNonExistingID:
		*t = GenericIssueErrorTypeFormAriaLabelledByToNonExistingID
	case GenericIssueErrorTypeFormInputAssignedAutocompleteValueToIDOrNameAttributeError:
		*t = GenericIssueErrorTypeFormInputAssignedAutocompleteValueToIDOrNameAttributeError
	case GenericIssueErrorTypeFormLabelHasNeitherForNorNestedInput:
		*t = GenericIssueErrorTypeFormLabelHasNeitherForNorNestedInput
	case GenericIssueErrorTypeFormLabelForMatchesNonExistingIDError:
		*t = GenericIssueErrorTypeFormLabelForMatchesNonExistingIDError
	case GenericIssueErrorTypeFormInputHasWrongButWellIntendedAutocompleteValueError:
		*t = GenericIssueErrorTypeFormInputHasWrongButWellIntendedAutocompleteValueError
	case GenericIssueErrorTypeResponseWasBlockedByORB:
		*t = GenericIssueErrorTypeResponseWasBlockedByORB

	default:
		in.AddError(fmt.Errorf("unknown GenericIssueErrorType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *GenericIssueErrorType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// GenericIssueDetails depending on the concrete errorType, different
// properties are set.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-GenericIssueDetails
type GenericIssueDetails struct {
	ErrorType              GenericIssueErrorType `json:"errorType"` // Issues with the same errorType are aggregated in the frontend.
	FrameID                cdp.FrameID           `json:"frameId,omitempty"`
	ViolatingNodeID        cdp.BackendNodeID     `json:"violatingNodeId,omitempty"`
	ViolatingNodeAttribute string                `json:"violatingNodeAttribute,omitempty"`
	Request                *AffectedRequest      `json:"request,omitempty"`
}

// DeprecationIssueDetails this issue tracks information needed to print a
// deprecation message.
// https://source.chromium.org/chromium/chromium/src/+/main:third_party/blink/renderer/core/frame/third_party/blink/renderer/core/frame/deprecation/README.md.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-DeprecationIssueDetails
type DeprecationIssueDetails struct {
	AffectedFrame      *AffectedFrame      `json:"affectedFrame,omitempty"`
	SourceCodeLocation *SourceCodeLocation `json:"sourceCodeLocation"`
	Type               string              `json:"type"` // One of the deprecation names from third_party/blink/renderer/core/frame/deprecation/deprecation.json5
}

// BounceTrackingIssueDetails this issue warns about sites in the redirect
// chain of a finished navigation that may be flagged as trackers and have their
// state cleared if they don't receive a user interaction. Note that in this
// context 'site' means eTLD+1. For example, if the URL
// https://example.test:80/bounce was in the redirect chain, the site reported
// would be example.test.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-BounceTrackingIssueDetails
type BounceTrackingIssueDetails struct {
	TrackingSites []string `json:"trackingSites"`
}

// ClientHintIssueReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-ClientHintIssueReason
type ClientHintIssueReason string

// String returns the ClientHintIssueReason as string value.
func (t ClientHintIssueReason) String() string {
	return string(t)
}

// ClientHintIssueReason values.
const (
	ClientHintIssueReasonMetaTagAllowListInvalidOrigin ClientHintIssueReason = "MetaTagAllowListInvalidOrigin"
	ClientHintIssueReasonMetaTagModifiedHTML           ClientHintIssueReason = "MetaTagModifiedHTML"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t ClientHintIssueReason) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t ClientHintIssueReason) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *ClientHintIssueReason) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch ClientHintIssueReason(v) {
	case ClientHintIssueReasonMetaTagAllowListInvalidOrigin:
		*t = ClientHintIssueReasonMetaTagAllowListInvalidOrigin
	case ClientHintIssueReasonMetaTagModifiedHTML:
		*t = ClientHintIssueReasonMetaTagModifiedHTML

	default:
		in.AddError(fmt.Errorf("unknown ClientHintIssueReason value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *ClientHintIssueReason) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// FederatedAuthRequestIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-FederatedAuthRequestIssueDetails
type FederatedAuthRequestIssueDetails struct {
	FederatedAuthRequestIssueReason FederatedAuthRequestIssueReason `json:"federatedAuthRequestIssueReason"`
}

// FederatedAuthRequestIssueReason represents the failure reason when a
// federated authentication reason fails. Should be updated alongside
// RequestIdTokenStatus in
// third_party/blink/public/mojom/devtools/inspector_issue.mojom to include all
// cases except for success.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-FederatedAuthRequestIssueReason
type FederatedAuthRequestIssueReason string

// String returns the FederatedAuthRequestIssueReason as string value.
func (t FederatedAuthRequestIssueReason) String() string {
	return string(t)
}

// FederatedAuthRequestIssueReason values.
const (
	FederatedAuthRequestIssueReasonShouldEmbargo                    FederatedAuthRequestIssueReason = "ShouldEmbargo"
	FederatedAuthRequestIssueReasonTooManyRequests                  FederatedAuthRequestIssueReason = "TooManyRequests"
	FederatedAuthRequestIssueReasonWellKnownHTTPNotFound            FederatedAuthRequestIssueReason = "WellKnownHttpNotFound"
	FederatedAuthRequestIssueReasonWellKnownNoResponse              FederatedAuthRequestIssueReason = "WellKnownNoResponse"
	FederatedAuthRequestIssueReasonWellKnownInvalidResponse         FederatedAuthRequestIssueReason = "WellKnownInvalidResponse"
	FederatedAuthRequestIssueReasonWellKnownListEmpty               FederatedAuthRequestIssueReason = "WellKnownListEmpty"
	FederatedAuthRequestIssueReasonWellKnownInvalidContentType      FederatedAuthRequestIssueReason = "WellKnownInvalidContentType"
	FederatedAuthRequestIssueReasonConfigNotInWellKnown             FederatedAuthRequestIssueReason = "ConfigNotInWellKnown"
	FederatedAuthRequestIssueReasonWellKnownTooBig                  FederatedAuthRequestIssueReason = "WellKnownTooBig"
	FederatedAuthRequestIssueReasonConfigHTTPNotFound               FederatedAuthRequestIssueReason = "ConfigHttpNotFound"
	FederatedAuthRequestIssueReasonConfigNoResponse                 FederatedAuthRequestIssueReason = "ConfigNoResponse"
	FederatedAuthRequestIssueReasonConfigInvalidResponse            FederatedAuthRequestIssueReason = "ConfigInvalidResponse"
	FederatedAuthRequestIssueReasonConfigInvalidContentType         FederatedAuthRequestIssueReason = "ConfigInvalidContentType"
	FederatedAuthRequestIssueReasonClientMetadataHTTPNotFound       FederatedAuthRequestIssueReason = "ClientMetadataHttpNotFound"
	FederatedAuthRequestIssueReasonClientMetadataNoResponse         FederatedAuthRequestIssueReason = "ClientMetadataNoResponse"
	FederatedAuthRequestIssueReasonClientMetadataInvalidResponse    FederatedAuthRequestIssueReason = "ClientMetadataInvalidResponse"
	FederatedAuthRequestIssueReasonClientMetadataInvalidContentType FederatedAuthRequestIssueReason = "ClientMetadataInvalidContentType"
	FederatedAuthRequestIssueReasonDisabledInSettings               FederatedAuthRequestIssueReason = "DisabledInSettings"
	FederatedAuthRequestIssueReasonErrorFetchingSignin              FederatedAuthRequestIssueReason = "ErrorFetchingSignin"
	FederatedAuthRequestIssueReasonInvalidSigninResponse            FederatedAuthRequestIssueReason = "InvalidSigninResponse"
	FederatedAuthRequestIssueReasonAccountsHTTPNotFound             FederatedAuthRequestIssueReason = "AccountsHttpNotFound"
	FederatedAuthRequestIssueReasonAccountsNoResponse               FederatedAuthRequestIssueReason = "AccountsNoResponse"
	FederatedAuthRequestIssueReasonAccountsInvalidResponse          FederatedAuthRequestIssueReason = "AccountsInvalidResponse"
	FederatedAuthRequestIssueReasonAccountsListEmpty                FederatedAuthRequestIssueReason = "AccountsListEmpty"
	FederatedAuthRequestIssueReasonAccountsInvalidContentType       FederatedAuthRequestIssueReason = "AccountsInvalidContentType"
	FederatedAuthRequestIssueReasonIDTokenHTTPNotFound              FederatedAuthRequestIssueReason = "IdTokenHttpNotFound"
	FederatedAuthRequestIssueReasonIDTokenNoResponse                FederatedAuthRequestIssueReason = "IdTokenNoResponse"
	FederatedAuthRequestIssueReasonIDTokenInvalidResponse           FederatedAuthRequestIssueReason = "IdTokenInvalidResponse"
	FederatedAuthRequestIssueReasonIDTokenInvalidRequest            FederatedAuthRequestIssueReason = "IdTokenInvalidRequest"
	FederatedAuthRequestIssueReasonIDTokenInvalidContentType        FederatedAuthRequestIssueReason = "IdTokenInvalidContentType"
	FederatedAuthRequestIssueReasonErrorIDToken                     FederatedAuthRequestIssueReason = "ErrorIdToken"
	FederatedAuthRequestIssueReasonCanceled                         FederatedAuthRequestIssueReason = "Canceled"
	FederatedAuthRequestIssueReasonRpPageNotVisible                 FederatedAuthRequestIssueReason = "RpPageNotVisible"
	FederatedAuthRequestIssueReasonSilentMediationFailure           FederatedAuthRequestIssueReason = "SilentMediationFailure"
	FederatedAuthRequestIssueReasonThirdPartyCookiesBlocked         FederatedAuthRequestIssueReason = "ThirdPartyCookiesBlocked"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t FederatedAuthRequestIssueReason) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t FederatedAuthRequestIssueReason) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *FederatedAuthRequestIssueReason) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch FederatedAuthRequestIssueReason(v) {
	case FederatedAuthRequestIssueReasonShouldEmbargo:
		*t = FederatedAuthRequestIssueReasonShouldEmbargo
	case FederatedAuthRequestIssueReasonTooManyRequests:
		*t = FederatedAuthRequestIssueReasonTooManyRequests
	case FederatedAuthRequestIssueReasonWellKnownHTTPNotFound:
		*t = FederatedAuthRequestIssueReasonWellKnownHTTPNotFound
	case FederatedAuthRequestIssueReasonWellKnownNoResponse:
		*t = FederatedAuthRequestIssueReasonWellKnownNoResponse
	case FederatedAuthRequestIssueReasonWellKnownInvalidResponse:
		*t = FederatedAuthRequestIssueReasonWellKnownInvalidResponse
	case FederatedAuthRequestIssueReasonWellKnownListEmpty:
		*t = FederatedAuthRequestIssueReasonWellKnownListEmpty
	case FederatedAuthRequestIssueReasonWellKnownInvalidContentType:
		*t = FederatedAuthRequestIssueReasonWellKnownInvalidContentType
	case FederatedAuthRequestIssueReasonConfigNotInWellKnown:
		*t = FederatedAuthRequestIssueReasonConfigNotInWellKnown
	case FederatedAuthRequestIssueReasonWellKnownTooBig:
		*t = FederatedAuthRequestIssueReasonWellKnownTooBig
	case FederatedAuthRequestIssueReasonConfigHTTPNotFound:
		*t = FederatedAuthRequestIssueReasonConfigHTTPNotFound
	case FederatedAuthRequestIssueReasonConfigNoResponse:
		*t = FederatedAuthRequestIssueReasonConfigNoResponse
	case FederatedAuthRequestIssueReasonConfigInvalidResponse:
		*t = FederatedAuthRequestIssueReasonConfigInvalidResponse
	case FederatedAuthRequestIssueReasonConfigInvalidContentType:
		*t = FederatedAuthRequestIssueReasonConfigInvalidContentType
	case FederatedAuthRequestIssueReasonClientMetadataHTTPNotFound:
		*t = FederatedAuthRequestIssueReasonClientMetadataHTTPNotFound
	case FederatedAuthRequestIssueReasonClientMetadataNoResponse:
		*t = FederatedAuthRequestIssueReasonClientMetadataNoResponse
	case FederatedAuthRequestIssueReasonClientMetadataInvalidResponse:
		*t = FederatedAuthRequestIssueReasonClientMetadataInvalidResponse
	case FederatedAuthRequestIssueReasonClientMetadataInvalidContentType:
		*t = FederatedAuthRequestIssueReasonClientMetadataInvalidContentType
	case FederatedAuthRequestIssueReasonDisabledInSettings:
		*t = FederatedAuthRequestIssueReasonDisabledInSettings
	case FederatedAuthRequestIssueReasonErrorFetchingSignin:
		*t = FederatedAuthRequestIssueReasonErrorFetchingSignin
	case FederatedAuthRequestIssueReasonInvalidSigninResponse:
		*t = FederatedAuthRequestIssueReasonInvalidSigninResponse
	case FederatedAuthRequestIssueReasonAccountsHTTPNotFound:
		*t = FederatedAuthRequestIssueReasonAccountsHTTPNotFound
	case FederatedAuthRequestIssueReasonAccountsNoResponse:
		*t = FederatedAuthRequestIssueReasonAccountsNoResponse
	case FederatedAuthRequestIssueReasonAccountsInvalidResponse:
		*t = FederatedAuthRequestIssueReasonAccountsInvalidResponse
	case FederatedAuthRequestIssueReasonAccountsListEmpty:
		*t = FederatedAuthRequestIssueReasonAccountsListEmpty
	case FederatedAuthRequestIssueReasonAccountsInvalidContentType:
		*t = FederatedAuthRequestIssueReasonAccountsInvalidContentType
	case FederatedAuthRequestIssueReasonIDTokenHTTPNotFound:
		*t = FederatedAuthRequestIssueReasonIDTokenHTTPNotFound
	case FederatedAuthRequestIssueReasonIDTokenNoResponse:
		*t = FederatedAuthRequestIssueReasonIDTokenNoResponse
	case FederatedAuthRequestIssueReasonIDTokenInvalidResponse:
		*t = FederatedAuthRequestIssueReasonIDTokenInvalidResponse
	case FederatedAuthRequestIssueReasonIDTokenInvalidRequest:
		*t = FederatedAuthRequestIssueReasonIDTokenInvalidRequest
	case FederatedAuthRequestIssueReasonIDTokenInvalidContentType:
		*t = FederatedAuthRequestIssueReasonIDTokenInvalidContentType
	case FederatedAuthRequestIssueReasonErrorIDToken:
		*t = FederatedAuthRequestIssueReasonErrorIDToken
	case FederatedAuthRequestIssueReasonCanceled:
		*t = FederatedAuthRequestIssueReasonCanceled
	case FederatedAuthRequestIssueReasonRpPageNotVisible:
		*t = FederatedAuthRequestIssueReasonRpPageNotVisible
	case FederatedAuthRequestIssueReasonSilentMediationFailure:
		*t = FederatedAuthRequestIssueReasonSilentMediationFailure
	case FederatedAuthRequestIssueReasonThirdPartyCookiesBlocked:
		*t = FederatedAuthRequestIssueReasonThirdPartyCookiesBlocked

	default:
		in.AddError(fmt.Errorf("unknown FederatedAuthRequestIssueReason value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *FederatedAuthRequestIssueReason) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// FederatedAuthUserInfoRequestIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-FederatedAuthUserInfoRequestIssueDetails
type FederatedAuthUserInfoRequestIssueDetails struct {
	FederatedAuthUserInfoRequestIssueReason FederatedAuthUserInfoRequestIssueReason `json:"federatedAuthUserInfoRequestIssueReason"`
}

// FederatedAuthUserInfoRequestIssueReason represents the failure reason when
// a getUserInfo() call fails. Should be updated alongside
// FederatedAuthUserInfoRequestResult in
// third_party/blink/public/mojom/devtools/inspector_issue.mojom.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-FederatedAuthUserInfoRequestIssueReason
type FederatedAuthUserInfoRequestIssueReason string

// String returns the FederatedAuthUserInfoRequestIssueReason as string value.
func (t FederatedAuthUserInfoRequestIssueReason) String() string {
	return string(t)
}

// FederatedAuthUserInfoRequestIssueReason values.
const (
	FederatedAuthUserInfoRequestIssueReasonNotSameOrigin                      FederatedAuthUserInfoRequestIssueReason = "NotSameOrigin"
	FederatedAuthUserInfoRequestIssueReasonNotIframe                          FederatedAuthUserInfoRequestIssueReason = "NotIframe"
	FederatedAuthUserInfoRequestIssueReasonNotPotentiallyTrustworthy          FederatedAuthUserInfoRequestIssueReason = "NotPotentiallyTrustworthy"
	FederatedAuthUserInfoRequestIssueReasonNoAPIPermission                    FederatedAuthUserInfoRequestIssueReason = "NoApiPermission"
	FederatedAuthUserInfoRequestIssueReasonNotSignedInWithIdp                 FederatedAuthUserInfoRequestIssueReason = "NotSignedInWithIdp"
	FederatedAuthUserInfoRequestIssueReasonNoAccountSharingPermission         FederatedAuthUserInfoRequestIssueReason = "NoAccountSharingPermission"
	FederatedAuthUserInfoRequestIssueReasonInvalidConfigOrWellKnown           FederatedAuthUserInfoRequestIssueReason = "InvalidConfigOrWellKnown"
	FederatedAuthUserInfoRequestIssueReasonInvalidAccountsResponse            FederatedAuthUserInfoRequestIssueReason = "InvalidAccountsResponse"
	FederatedAuthUserInfoRequestIssueReasonNoReturningUserFromFetchedAccounts FederatedAuthUserInfoRequestIssueReason = "NoReturningUserFromFetchedAccounts"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t FederatedAuthUserInfoRequestIssueReason) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t FederatedAuthUserInfoRequestIssueReason) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *FederatedAuthUserInfoRequestIssueReason) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch FederatedAuthUserInfoRequestIssueReason(v) {
	case FederatedAuthUserInfoRequestIssueReasonNotSameOrigin:
		*t = FederatedAuthUserInfoRequestIssueReasonNotSameOrigin
	case FederatedAuthUserInfoRequestIssueReasonNotIframe:
		*t = FederatedAuthUserInfoRequestIssueReasonNotIframe
	case FederatedAuthUserInfoRequestIssueReasonNotPotentiallyTrustworthy:
		*t = FederatedAuthUserInfoRequestIssueReasonNotPotentiallyTrustworthy
	case FederatedAuthUserInfoRequestIssueReasonNoAPIPermission:
		*t = FederatedAuthUserInfoRequestIssueReasonNoAPIPermission
	case FederatedAuthUserInfoRequestIssueReasonNotSignedInWithIdp:
		*t = FederatedAuthUserInfoRequestIssueReasonNotSignedInWithIdp
	case FederatedAuthUserInfoRequestIssueReasonNoAccountSharingPermission:
		*t = FederatedAuthUserInfoRequestIssueReasonNoAccountSharingPermission
	case FederatedAuthUserInfoRequestIssueReasonInvalidConfigOrWellKnown:
		*t = FederatedAuthUserInfoRequestIssueReasonInvalidConfigOrWellKnown
	case FederatedAuthUserInfoRequestIssueReasonInvalidAccountsResponse:
		*t = FederatedAuthUserInfoRequestIssueReasonInvalidAccountsResponse
	case FederatedAuthUserInfoRequestIssueReasonNoReturningUserFromFetchedAccounts:
		*t = FederatedAuthUserInfoRequestIssueReasonNoReturningUserFromFetchedAccounts

	default:
		in.AddError(fmt.Errorf("unknown FederatedAuthUserInfoRequestIssueReason value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *FederatedAuthUserInfoRequestIssueReason) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// ClientHintIssueDetails this issue tracks client hints related issues. It's
// used to deprecate old features, encourage the use of new ones, and provide
// general guidance.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-ClientHintIssueDetails
type ClientHintIssueDetails struct {
	SourceCodeLocation    *SourceCodeLocation   `json:"sourceCodeLocation"`
	ClientHintIssueReason ClientHintIssueReason `json:"clientHintIssueReason"`
}

// FailedRequestInfo [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-FailedRequestInfo
type FailedRequestInfo struct {
	URL            string            `json:"url"`            // The URL that failed to load.
	FailureMessage string            `json:"failureMessage"` // The failure message for the failed request.
	RequestID      network.RequestID `json:"requestId,omitempty"`
}

// StyleSheetLoadingIssueReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-StyleSheetLoadingIssueReason
type StyleSheetLoadingIssueReason string

// String returns the StyleSheetLoadingIssueReason as string value.
func (t StyleSheetLoadingIssueReason) String() string {
	return string(t)
}

// StyleSheetLoadingIssueReason values.
const (
	StyleSheetLoadingIssueReasonLateImportRule StyleSheetLoadingIssueReason = "LateImportRule"
	StyleSheetLoadingIssueReasonRequestFailed  StyleSheetLoadingIssueReason = "RequestFailed"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t StyleSheetLoadingIssueReason) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t StyleSheetLoadingIssueReason) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *StyleSheetLoadingIssueReason) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch StyleSheetLoadingIssueReason(v) {
	case StyleSheetLoadingIssueReasonLateImportRule:
		*t = StyleSheetLoadingIssueReasonLateImportRule
	case StyleSheetLoadingIssueReasonRequestFailed:
		*t = StyleSheetLoadingIssueReasonRequestFailed

	default:
		in.AddError(fmt.Errorf("unknown StyleSheetLoadingIssueReason value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *StyleSheetLoadingIssueReason) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// StylesheetLoadingIssueDetails this issue warns when a referenced
// stylesheet couldn't be loaded.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-StylesheetLoadingIssueDetails
type StylesheetLoadingIssueDetails struct {
	SourceCodeLocation           *SourceCodeLocation          `json:"sourceCodeLocation"`           // Source code position that referenced the failing stylesheet.
	StyleSheetLoadingIssueReason StyleSheetLoadingIssueReason `json:"styleSheetLoadingIssueReason"` // Reason why the stylesheet couldn't be loaded.
	FailedRequestInfo            *FailedRequestInfo           `json:"failedRequestInfo,omitempty"`  // Contains additional info when the failure was due to a request.
}

// InspectorIssueCode a unique identifier for the type of issue. Each type
// may use one of the optional fields in InspectorIssueDetails to convey more
// specific information about the kind of issue.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-InspectorIssueCode
type InspectorIssueCode string

// String returns the InspectorIssueCode as string value.
func (t InspectorIssueCode) String() string {
	return string(t)
}

// InspectorIssueCode values.
const (
	InspectorIssueCodeCookieIssue                       InspectorIssueCode = "CookieIssue"
	InspectorIssueCodeMixedContentIssue                 InspectorIssueCode = "MixedContentIssue"
	InspectorIssueCodeBlockedByResponseIssue            InspectorIssueCode = "BlockedByResponseIssue"
	InspectorIssueCodeHeavyAdIssue                      InspectorIssueCode = "HeavyAdIssue"
	InspectorIssueCodeContentSecurityPolicyIssue        InspectorIssueCode = "ContentSecurityPolicyIssue"
	InspectorIssueCodeSharedArrayBufferIssue            InspectorIssueCode = "SharedArrayBufferIssue"
	InspectorIssueCodeLowTextContrastIssue              InspectorIssueCode = "LowTextContrastIssue"
	InspectorIssueCodeCorsIssue                         InspectorIssueCode = "CorsIssue"
	InspectorIssueCodeAttributionReportingIssue         InspectorIssueCode = "AttributionReportingIssue"
	InspectorIssueCodeQuirksModeIssue                   InspectorIssueCode = "QuirksModeIssue"
	InspectorIssueCodeNavigatorUserAgentIssue           InspectorIssueCode = "NavigatorUserAgentIssue"
	InspectorIssueCodeGenericIssue                      InspectorIssueCode = "GenericIssue"
	InspectorIssueCodeDeprecationIssue                  InspectorIssueCode = "DeprecationIssue"
	InspectorIssueCodeClientHintIssue                   InspectorIssueCode = "ClientHintIssue"
	InspectorIssueCodeFederatedAuthRequestIssue         InspectorIssueCode = "FederatedAuthRequestIssue"
	InspectorIssueCodeBounceTrackingIssue               InspectorIssueCode = "BounceTrackingIssue"
	InspectorIssueCodeStylesheetLoadingIssue            InspectorIssueCode = "StylesheetLoadingIssue"
	InspectorIssueCodeFederatedAuthUserInfoRequestIssue InspectorIssueCode = "FederatedAuthUserInfoRequestIssue"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t InspectorIssueCode) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t InspectorIssueCode) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *InspectorIssueCode) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch InspectorIssueCode(v) {
	case InspectorIssueCodeCookieIssue:
		*t = InspectorIssueCodeCookieIssue
	case InspectorIssueCodeMixedContentIssue:
		*t = InspectorIssueCodeMixedContentIssue
	case InspectorIssueCodeBlockedByResponseIssue:
		*t = InspectorIssueCodeBlockedByResponseIssue
	case InspectorIssueCodeHeavyAdIssue:
		*t = InspectorIssueCodeHeavyAdIssue
	case InspectorIssueCodeContentSecurityPolicyIssue:
		*t = InspectorIssueCodeContentSecurityPolicyIssue
	case InspectorIssueCodeSharedArrayBufferIssue:
		*t = InspectorIssueCodeSharedArrayBufferIssue
	case InspectorIssueCodeLowTextContrastIssue:
		*t = InspectorIssueCodeLowTextContrastIssue
	case InspectorIssueCodeCorsIssue:
		*t = InspectorIssueCodeCorsIssue
	case InspectorIssueCodeAttributionReportingIssue:
		*t = InspectorIssueCodeAttributionReportingIssue
	case InspectorIssueCodeQuirksModeIssue:
		*t = InspectorIssueCodeQuirksModeIssue
	case InspectorIssueCodeNavigatorUserAgentIssue:
		*t = InspectorIssueCodeNavigatorUserAgentIssue
	case InspectorIssueCodeGenericIssue:
		*t = InspectorIssueCodeGenericIssue
	case InspectorIssueCodeDeprecationIssue:
		*t = InspectorIssueCodeDeprecationIssue
	case InspectorIssueCodeClientHintIssue:
		*t = InspectorIssueCodeClientHintIssue
	case InspectorIssueCodeFederatedAuthRequestIssue:
		*t = InspectorIssueCodeFederatedAuthRequestIssue
	case InspectorIssueCodeBounceTrackingIssue:
		*t = InspectorIssueCodeBounceTrackingIssue
	case InspectorIssueCodeStylesheetLoadingIssue:
		*t = InspectorIssueCodeStylesheetLoadingIssue
	case InspectorIssueCodeFederatedAuthUserInfoRequestIssue:
		*t = InspectorIssueCodeFederatedAuthUserInfoRequestIssue

	default:
		in.AddError(fmt.Errorf("unknown InspectorIssueCode value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *InspectorIssueCode) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// InspectorIssueDetails this struct holds a list of optional fields with
// additional information specific to the kind of issue. When adding a new issue
// code, please also add a new optional field to this type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-InspectorIssueDetails
type InspectorIssueDetails struct {
	CookieIssueDetails                       *CookieIssueDetails                       `json:"cookieIssueDetails,omitempty"`
	MixedContentIssueDetails                 *MixedContentIssueDetails                 `json:"mixedContentIssueDetails,omitempty"`
	BlockedByResponseIssueDetails            *BlockedByResponseIssueDetails            `json:"blockedByResponseIssueDetails,omitempty"`
	HeavyAdIssueDetails                      *HeavyAdIssueDetails                      `json:"heavyAdIssueDetails,omitempty"`
	ContentSecurityPolicyIssueDetails        *ContentSecurityPolicyIssueDetails        `json:"contentSecurityPolicyIssueDetails,omitempty"`
	SharedArrayBufferIssueDetails            *SharedArrayBufferIssueDetails            `json:"sharedArrayBufferIssueDetails,omitempty"`
	LowTextContrastIssueDetails              *LowTextContrastIssueDetails              `json:"lowTextContrastIssueDetails,omitempty"`
	CorsIssueDetails                         *CorsIssueDetails                         `json:"corsIssueDetails,omitempty"`
	AttributionReportingIssueDetails         *AttributionReportingIssueDetails         `json:"attributionReportingIssueDetails,omitempty"`
	QuirksModeIssueDetails                   *QuirksModeIssueDetails                   `json:"quirksModeIssueDetails,omitempty"`
	GenericIssueDetails                      *GenericIssueDetails                      `json:"genericIssueDetails,omitempty"`
	DeprecationIssueDetails                  *DeprecationIssueDetails                  `json:"deprecationIssueDetails,omitempty"`
	ClientHintIssueDetails                   *ClientHintIssueDetails                   `json:"clientHintIssueDetails,omitempty"`
	FederatedAuthRequestIssueDetails         *FederatedAuthRequestIssueDetails         `json:"federatedAuthRequestIssueDetails,omitempty"`
	BounceTrackingIssueDetails               *BounceTrackingIssueDetails               `json:"bounceTrackingIssueDetails,omitempty"`
	StylesheetLoadingIssueDetails            *StylesheetLoadingIssueDetails            `json:"stylesheetLoadingIssueDetails,omitempty"`
	FederatedAuthUserInfoRequestIssueDetails *FederatedAuthUserInfoRequestIssueDetails `json:"federatedAuthUserInfoRequestIssueDetails,omitempty"`
}

// IssueID a unique id for a DevTools inspector issue. Allows other entities
// (e.g. exceptions, CDP message, console messages, etc.) to reference an issue.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-IssueId
type IssueID string

// String returns the IssueID as string value.
func (t IssueID) String() string {
	return string(t)
}

// InspectorIssue an inspector issue reported from the back-end.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-InspectorIssue
type InspectorIssue struct {
	Code    InspectorIssueCode     `json:"code"`
	Details *InspectorIssueDetails `json:"details"`
	IssueID IssueID                `json:"issueId,omitempty"` // A unique id for this issue. May be omitted if no other entity (e.g. exception, CDP message, etc.) is referencing this issue.
}

// GetEncodedResponseEncoding the encoding to use.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#method-getEncodedResponse
type GetEncodedResponseEncoding string

// String returns the GetEncodedResponseEncoding as string value.
func (t GetEncodedResponseEncoding) String() string {
	return string(t)
}

// GetEncodedResponseEncoding values.
const (
	GetEncodedResponseEncodingWebp GetEncodedResponseEncoding = "webp"
	GetEncodedResponseEncodingJpeg GetEncodedResponseEncoding = "jpeg"
	GetEncodedResponseEncodingPng  GetEncodedResponseEncoding = "png"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t GetEncodedResponseEncoding) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t GetEncodedResponseEncoding) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *GetEncodedResponseEncoding) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch GetEncodedResponseEncoding(v) {
	case GetEncodedResponseEncodingWebp:
		*t = GetEncodedResponseEncodingWebp
	case GetEncodedResponseEncodingJpeg:
		*t = GetEncodedResponseEncodingJpeg
	case GetEncodedResponseEncodingPng:
		*t = GetEncodedResponseEncodingPng

	default:
		in.AddError(fmt.Errorf("unknown GetEncodedResponseEncoding value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *GetEncodedResponseEncoding) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}
