// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/cloud/dataproc/v1/clusters.proto

package dataprocpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	interval "google.golang.org/genproto/googleapis/type/interval"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	_ "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// `PrivateIpv6GoogleAccess` controls whether and how Dataproc cluster nodes
// can communicate with Google Services through gRPC over IPv6.
// These values are directly mapped to corresponding values in the
// [Compute Engine Instance
// fields](https://cloud.google.com/compute/docs/reference/rest/v1/instances).
type GceClusterConfig_PrivateIpv6GoogleAccess int32

const (
	// If unspecified, Compute Engine default behavior will apply, which
	// is the same as
	// [INHERIT_FROM_SUBNETWORK][google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess.INHERIT_FROM_SUBNETWORK].
	GceClusterConfig_PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED GceClusterConfig_PrivateIpv6GoogleAccess = 0
	// Private access to and from Google Services configuration
	// inherited from the subnetwork configuration. This is the
	// default Compute Engine behavior.
	GceClusterConfig_INHERIT_FROM_SUBNETWORK GceClusterConfig_PrivateIpv6GoogleAccess = 1
	// Enables outbound private IPv6 access to Google Services from the Dataproc
	// cluster.
	GceClusterConfig_OUTBOUND GceClusterConfig_PrivateIpv6GoogleAccess = 2
	// Enables bidirectional private IPv6 access between Google Services and the
	// Dataproc cluster.
	GceClusterConfig_BIDIRECTIONAL GceClusterConfig_PrivateIpv6GoogleAccess = 3
)

// Enum value maps for GceClusterConfig_PrivateIpv6GoogleAccess.
var (
	GceClusterConfig_PrivateIpv6GoogleAccess_name = map[int32]string{
		0: "PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED",
		1: "INHERIT_FROM_SUBNETWORK",
		2: "OUTBOUND",
		3: "BIDIRECTIONAL",
	}
	GceClusterConfig_PrivateIpv6GoogleAccess_value = map[string]int32{
		"PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED": 0,
		"INHERIT_FROM_SUBNETWORK":                1,
		"OUTBOUND":                               2,
		"BIDIRECTIONAL":                          3,
	}
)

func (x GceClusterConfig_PrivateIpv6GoogleAccess) Enum() *GceClusterConfig_PrivateIpv6GoogleAccess {
	p := new(GceClusterConfig_PrivateIpv6GoogleAccess)
	*p = x
	return p
}

func (x GceClusterConfig_PrivateIpv6GoogleAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GceClusterConfig_PrivateIpv6GoogleAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_v1_clusters_proto_enumTypes[0].Descriptor()
}

func (GceClusterConfig_PrivateIpv6GoogleAccess) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_v1_clusters_proto_enumTypes[0]
}

func (x GceClusterConfig_PrivateIpv6GoogleAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GceClusterConfig_PrivateIpv6GoogleAccess.Descriptor instead.
func (GceClusterConfig_PrivateIpv6GoogleAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{7, 0}
}

// Controls the use of preemptible instances within the group.
type InstanceGroupConfig_Preemptibility int32

const (
	// Preemptibility is unspecified, the system will choose the
	// appropriate setting for each instance group.
	InstanceGroupConfig_PREEMPTIBILITY_UNSPECIFIED InstanceGroupConfig_Preemptibility = 0
	// Instances are non-preemptible.
	//
	// This option is allowed for all instance groups and is the only valid
	// value for Master and Worker instance groups.
	InstanceGroupConfig_NON_PREEMPTIBLE InstanceGroupConfig_Preemptibility = 1
	// Instances are [preemptible]
	// (https://cloud.google.com/compute/docs/instances/preemptible).
	//
	// This option is allowed only for [secondary worker]
	// (https://cloud.google.com/dataproc/docs/concepts/compute/secondary-vms)
	// groups.
	InstanceGroupConfig_PREEMPTIBLE InstanceGroupConfig_Preemptibility = 2
	// Instances are [Spot VMs]
	// (https://cloud.google.com/compute/docs/instances/spot).
	//
	// This option is allowed only for [secondary worker]
	// (https://cloud.google.com/dataproc/docs/concepts/compute/secondary-vms)
	// groups. Spot VMs are the latest version of [preemptible VMs]
	// (https://cloud.google.com/compute/docs/instances/preemptible), and
	// provide additional features.
	InstanceGroupConfig_SPOT InstanceGroupConfig_Preemptibility = 3
)

// Enum value maps for InstanceGroupConfig_Preemptibility.
var (
	InstanceGroupConfig_Preemptibility_name = map[int32]string{
		0: "PREEMPTIBILITY_UNSPECIFIED",
		1: "NON_PREEMPTIBLE",
		2: "PREEMPTIBLE",
		3: "SPOT",
	}
	InstanceGroupConfig_Preemptibility_value = map[string]int32{
		"PREEMPTIBILITY_UNSPECIFIED": 0,
		"NON_PREEMPTIBLE":            1,
		"PREEMPTIBLE":                2,
		"SPOT":                       3,
	}
)

func (x InstanceGroupConfig_Preemptibility) Enum() *InstanceGroupConfig_Preemptibility {
	p := new(InstanceGroupConfig_Preemptibility)
	*p = x
	return p
}

func (x InstanceGroupConfig_Preemptibility) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupConfig_Preemptibility) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_v1_clusters_proto_enumTypes[1].Descriptor()
}

func (InstanceGroupConfig_Preemptibility) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_v1_clusters_proto_enumTypes[1]
}

func (x InstanceGroupConfig_Preemptibility) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupConfig_Preemptibility.Descriptor instead.
func (InstanceGroupConfig_Preemptibility) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{11, 0}
}

// Node pool roles.
type NodeGroup_Role int32

const (
	// Required unspecified role.
	NodeGroup_ROLE_UNSPECIFIED NodeGroup_Role = 0
	// Job drivers run on the node pool.
	NodeGroup_DRIVER NodeGroup_Role = 1
)

// Enum value maps for NodeGroup_Role.
var (
	NodeGroup_Role_name = map[int32]string{
		0: "ROLE_UNSPECIFIED",
		1: "DRIVER",
	}
	NodeGroup_Role_value = map[string]int32{
		"ROLE_UNSPECIFIED": 0,
		"DRIVER":           1,
	}
)

func (x NodeGroup_Role) Enum() *NodeGroup_Role {
	p := new(NodeGroup_Role)
	*p = x
	return p
}

func (x NodeGroup_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroup_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_v1_clusters_proto_enumTypes[2].Descriptor()
}

func (NodeGroup_Role) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_v1_clusters_proto_enumTypes[2]
}

func (x NodeGroup_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroup_Role.Descriptor instead.
func (NodeGroup_Role) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{19, 0}
}

// The cluster state.
type ClusterStatus_State int32

const (
	// The cluster state is unknown.
	ClusterStatus_UNKNOWN ClusterStatus_State = 0
	// The cluster is being created and set up. It is not ready for use.
	ClusterStatus_CREATING ClusterStatus_State = 1
	// The cluster is currently running and healthy. It is ready for use.
	//
	// **Note:** The cluster state changes from "creating" to "running" status
	// after the master node(s), first two primary worker nodes (and the last
	// primary worker node if primary workers > 2) are running.
	ClusterStatus_RUNNING ClusterStatus_State = 2
	// The cluster encountered an error. It is not ready for use.
	ClusterStatus_ERROR ClusterStatus_State = 3
	// The cluster has encountered an error while being updated. Jobs can
	// be submitted to the cluster, but the cluster cannot be updated.
	ClusterStatus_ERROR_DUE_TO_UPDATE ClusterStatus_State = 9
	// The cluster is being deleted. It cannot be used.
	ClusterStatus_DELETING ClusterStatus_State = 4
	// The cluster is being updated. It continues to accept and process jobs.
	ClusterStatus_UPDATING ClusterStatus_State = 5
	// The cluster is being stopped. It cannot be used.
	ClusterStatus_STOPPING ClusterStatus_State = 6
	// The cluster is currently stopped. It is not ready for use.
	ClusterStatus_STOPPED ClusterStatus_State = 7
	// The cluster is being started. It is not ready for use.
	ClusterStatus_STARTING ClusterStatus_State = 8
	// The cluster is being repaired. It is not ready for use.
	ClusterStatus_REPAIRING ClusterStatus_State = 10
)

// Enum value maps for ClusterStatus_State.
var (
	ClusterStatus_State_name = map[int32]string{
		0:  "UNKNOWN",
		1:  "CREATING",
		2:  "RUNNING",
		3:  "ERROR",
		9:  "ERROR_DUE_TO_UPDATE",
		4:  "DELETING",
		5:  "UPDATING",
		6:  "STOPPING",
		7:  "STOPPED",
		8:  "STARTING",
		10: "REPAIRING",
	}
	ClusterStatus_State_value = map[string]int32{
		"UNKNOWN":             0,
		"CREATING":            1,
		"RUNNING":             2,
		"ERROR":               3,
		"ERROR_DUE_TO_UPDATE": 9,
		"DELETING":            4,
		"UPDATING":            5,
		"STOPPING":            6,
		"STOPPED":             7,
		"STARTING":            8,
		"REPAIRING":           10,
	}
)

func (x ClusterStatus_State) Enum() *ClusterStatus_State {
	p := new(ClusterStatus_State)
	*p = x
	return p
}

func (x ClusterStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClusterStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_v1_clusters_proto_enumTypes[3].Descriptor()
}

func (ClusterStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_v1_clusters_proto_enumTypes[3]
}

func (x ClusterStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClusterStatus_State.Descriptor instead.
func (ClusterStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{21, 0}
}

// The cluster substate.
type ClusterStatus_Substate int32

const (
	// The cluster substate is unknown.
	ClusterStatus_UNSPECIFIED ClusterStatus_Substate = 0
	// The cluster is known to be in an unhealthy state
	// (for example, critical daemons are not running or HDFS capacity is
	// exhausted).
	//
	// Applies to RUNNING state.
	ClusterStatus_UNHEALTHY ClusterStatus_Substate = 1
	// The agent-reported status is out of date (may occur if
	// Dataproc loses communication with Agent).
	//
	// Applies to RUNNING state.
	ClusterStatus_STALE_STATUS ClusterStatus_Substate = 2
)

// Enum value maps for ClusterStatus_Substate.
var (
	ClusterStatus_Substate_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "UNHEALTHY",
		2: "STALE_STATUS",
	}
	ClusterStatus_Substate_value = map[string]int32{
		"UNSPECIFIED":  0,
		"UNHEALTHY":    1,
		"STALE_STATUS": 2,
	}
)

func (x ClusterStatus_Substate) Enum() *ClusterStatus_Substate {
	p := new(ClusterStatus_Substate)
	*p = x
	return p
}

func (x ClusterStatus_Substate) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClusterStatus_Substate) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_v1_clusters_proto_enumTypes[4].Descriptor()
}

func (ClusterStatus_Substate) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_v1_clusters_proto_enumTypes[4]
}

func (x ClusterStatus_Substate) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClusterStatus_Substate.Descriptor instead.
func (ClusterStatus_Substate) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{21, 1}
}

// A source for the collection of Dataproc custom metrics (see [Custom
// metrics]
// (https://cloud.google.com//dataproc/docs/guides/dataproc-metrics#custom_metrics)).
type DataprocMetricConfig_MetricSource int32

const (
	// Required unspecified metric source.
	DataprocMetricConfig_METRIC_SOURCE_UNSPECIFIED DataprocMetricConfig_MetricSource = 0
	// Monitoring agent metrics. If this source is enabled,
	// Dataproc enables the monitoring agent in Compute Engine,
	// and collects monitoring agent metrics, which are published
	// with an `agent.googleapis.com` prefix.
	DataprocMetricConfig_MONITORING_AGENT_DEFAULTS DataprocMetricConfig_MetricSource = 1
	// HDFS metric source.
	DataprocMetricConfig_HDFS DataprocMetricConfig_MetricSource = 2
	// Spark metric source.
	DataprocMetricConfig_SPARK DataprocMetricConfig_MetricSource = 3
	// YARN metric source.
	DataprocMetricConfig_YARN DataprocMetricConfig_MetricSource = 4
	// Spark History Server metric source.
	DataprocMetricConfig_SPARK_HISTORY_SERVER DataprocMetricConfig_MetricSource = 5
	// Hiveserver2 metric source.
	DataprocMetricConfig_HIVESERVER2 DataprocMetricConfig_MetricSource = 6
	// hivemetastore metric source
	DataprocMetricConfig_HIVEMETASTORE DataprocMetricConfig_MetricSource = 7
)

// Enum value maps for DataprocMetricConfig_MetricSource.
var (
	DataprocMetricConfig_MetricSource_name = map[int32]string{
		0: "METRIC_SOURCE_UNSPECIFIED",
		1: "MONITORING_AGENT_DEFAULTS",
		2: "HDFS",
		3: "SPARK",
		4: "YARN",
		5: "SPARK_HISTORY_SERVER",
		6: "HIVESERVER2",
		7: "HIVEMETASTORE",
	}
	DataprocMetricConfig_MetricSource_value = map[string]int32{
		"METRIC_SOURCE_UNSPECIFIED": 0,
		"MONITORING_AGENT_DEFAULTS": 1,
		"HDFS":                      2,
		"SPARK":                     3,
		"YARN":                      4,
		"SPARK_HISTORY_SERVER":      5,
		"HIVESERVER2":               6,
		"HIVEMETASTORE":             7,
	}
)

func (x DataprocMetricConfig_MetricSource) Enum() *DataprocMetricConfig_MetricSource {
	p := new(DataprocMetricConfig_MetricSource)
	*p = x
	return p
}

func (x DataprocMetricConfig_MetricSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataprocMetricConfig_MetricSource) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_v1_clusters_proto_enumTypes[5].Descriptor()
}

func (DataprocMetricConfig_MetricSource) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_v1_clusters_proto_enumTypes[5]
}

func (x DataprocMetricConfig_MetricSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataprocMetricConfig_MetricSource.Descriptor instead.
func (DataprocMetricConfig_MetricSource) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{29, 0}
}

// Indicates whether to consume capacity from an reservation or not.
type ReservationAffinity_Type int32

const (
	ReservationAffinity_TYPE_UNSPECIFIED ReservationAffinity_Type = 0
	// Do not consume from any allocated capacity.
	ReservationAffinity_NO_RESERVATION ReservationAffinity_Type = 1
	// Consume any reservation available.
	ReservationAffinity_ANY_RESERVATION ReservationAffinity_Type = 2
	// Must consume from a specific reservation. Must specify key value fields
	// for specifying the reservations.
	ReservationAffinity_SPECIFIC_RESERVATION ReservationAffinity_Type = 3
)

// Enum value maps for ReservationAffinity_Type.
var (
	ReservationAffinity_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "NO_RESERVATION",
		2: "ANY_RESERVATION",
		3: "SPECIFIC_RESERVATION",
	}
	ReservationAffinity_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":     0,
		"NO_RESERVATION":       1,
		"ANY_RESERVATION":      2,
		"SPECIFIC_RESERVATION": 3,
	}
)

func (x ReservationAffinity_Type) Enum() *ReservationAffinity_Type {
	p := new(ReservationAffinity_Type)
	*p = x
	return p
}

func (x ReservationAffinity_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationAffinity_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_v1_clusters_proto_enumTypes[6].Descriptor()
}

func (ReservationAffinity_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_v1_clusters_proto_enumTypes[6]
}

func (x ReservationAffinity_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationAffinity_Type.Descriptor instead.
func (ReservationAffinity_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{40, 0}
}

// Describes the identifying information, config, and status of
// a Dataproc cluster
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Google Cloud Platform project ID that the cluster belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The cluster name, which must be unique within a project.
	// The name must start with a lowercase letter, and can contain
	// up to 51 lowercase letters, numbers, and hyphens. It cannot end
	// with a hyphen. The name of a deleted cluster can be reused.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Optional. The cluster config for a cluster of Compute Engine Instances.
	// Note that Dataproc may set default values, and values may change
	// when clusters are updated.
	//
	// Exactly one of ClusterConfig or VirtualClusterConfig must be specified.
	Config *ClusterConfig `protobuf:"bytes,3,opt,name=config,proto3" json:"config,omitempty"`
	// Optional. The virtual cluster config is used when creating a Dataproc
	// cluster that does not directly control the underlying compute resources,
	// for example, when creating a [Dataproc-on-GKE
	// cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
	// Dataproc may set default values, and values may change when
	// clusters are updated. Exactly one of
	// [config][google.cloud.dataproc.v1.Cluster.config] or
	// [virtual_cluster_config][google.cloud.dataproc.v1.Cluster.virtual_cluster_config]
	// must be specified.
	VirtualClusterConfig *VirtualClusterConfig `protobuf:"bytes,10,opt,name=virtual_cluster_config,json=virtualClusterConfig,proto3" json:"virtual_cluster_config,omitempty"`
	// Optional. The labels to associate with this cluster.
	// Label **keys** must contain 1 to 63 characters, and must conform to
	// [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	// Label **values** may be empty, but, if present, must contain 1 to 63
	// characters, and must conform to [RFC
	// 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
	// associated with a cluster.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Cluster status.
	Status *ClusterStatus `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
	// Output only. The previous cluster status.
	StatusHistory []*ClusterStatus `protobuf:"bytes,7,rep,name=status_history,json=statusHistory,proto3" json:"status_history,omitempty"`
	// Output only. A cluster UUID (Unique Universal Identifier). Dataproc
	// generates this value when it creates the cluster.
	ClusterUuid string `protobuf:"bytes,6,opt,name=cluster_uuid,json=clusterUuid,proto3" json:"cluster_uuid,omitempty"`
	// Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
	//
	// **Beta Feature**: This report is available for testing purposes only. It
	// may be changed before final release.
	Metrics *ClusterMetrics `protobuf:"bytes,9,opt,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *Cluster) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *Cluster) GetConfig() *ClusterConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Cluster) GetVirtualClusterConfig() *VirtualClusterConfig {
	if x != nil {
		return x.VirtualClusterConfig
	}
	return nil
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetStatus() *ClusterStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *Cluster) GetStatusHistory() []*ClusterStatus {
	if x != nil {
		return x.StatusHistory
	}
	return nil
}

func (x *Cluster) GetClusterUuid() string {
	if x != nil {
		return x.ClusterUuid
	}
	return ""
}

func (x *Cluster) GetMetrics() *ClusterMetrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// The cluster config.
type ClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A Cloud Storage bucket used to stage job
	// dependencies, config files, and job driver console output.
	// If you do not specify a staging bucket, Cloud
	// Dataproc will determine a Cloud Storage location (US,
	// ASIA, or EU) for your cluster's staging bucket according to the
	// Compute Engine zone where your cluster is deployed, and then create
	// and manage this project-level, per-location bucket (see
	// [Dataproc staging and temp
	// buckets](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
	// **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
	// a Cloud Storage bucket.**
	ConfigBucket string `protobuf:"bytes,1,opt,name=config_bucket,json=configBucket,proto3" json:"config_bucket,omitempty"`
	// Optional. A Cloud Storage bucket used to store ephemeral cluster and jobs
	// data, such as Spark and MapReduce history files. If you do not specify a
	// temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or
	// EU) for your cluster's temp bucket according to the Compute Engine zone
	// where your cluster is deployed, and then create and manage this
	// project-level, per-location bucket. The default bucket has a TTL of 90
	// days, but you can use any TTL (or none) if you specify a bucket (see
	// [Dataproc staging and temp
	// buckets](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
	// **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
	// a Cloud Storage bucket.**
	TempBucket string `protobuf:"bytes,2,opt,name=temp_bucket,json=tempBucket,proto3" json:"temp_bucket,omitempty"`
	// Optional. The shared Compute Engine config settings for
	// all instances in a cluster.
	GceClusterConfig *GceClusterConfig `protobuf:"bytes,8,opt,name=gce_cluster_config,json=gceClusterConfig,proto3" json:"gce_cluster_config,omitempty"`
	// Optional. The Compute Engine config settings for
	// the cluster's master instance.
	MasterConfig *InstanceGroupConfig `protobuf:"bytes,9,opt,name=master_config,json=masterConfig,proto3" json:"master_config,omitempty"`
	// Optional. The Compute Engine config settings for
	// the cluster's worker instances.
	WorkerConfig *InstanceGroupConfig `protobuf:"bytes,10,opt,name=worker_config,json=workerConfig,proto3" json:"worker_config,omitempty"`
	// Optional. The Compute Engine config settings for
	// a cluster's secondary worker instances
	SecondaryWorkerConfig *InstanceGroupConfig `protobuf:"bytes,12,opt,name=secondary_worker_config,json=secondaryWorkerConfig,proto3" json:"secondary_worker_config,omitempty"`
	// Optional. The config settings for cluster software.
	SoftwareConfig *SoftwareConfig `protobuf:"bytes,13,opt,name=software_config,json=softwareConfig,proto3" json:"software_config,omitempty"`
	// Optional. Commands to execute on each node after config is
	// completed. By default, executables are run on master and all worker nodes.
	// You can test a node's `role` metadata to run an executable on
	// a master or worker node, as shown below using `curl` (you can also use
	// `wget`):
	//
	//	ROLE=$(curl -H Metadata-Flavor:Google
	//	http://metadata/computeMetadata/v1/instance/attributes/dataproc-role)
	//	if [[ "${ROLE}" == 'Master' ]]; then
	//	  ... master specific actions ...
	//	else
	//	  ... worker specific actions ...
	//	fi
	InitializationActions []*NodeInitializationAction `protobuf:"bytes,11,rep,name=initialization_actions,json=initializationActions,proto3" json:"initialization_actions,omitempty"`
	// Optional. Encryption settings for the cluster.
	EncryptionConfig *EncryptionConfig `protobuf:"bytes,15,opt,name=encryption_config,json=encryptionConfig,proto3" json:"encryption_config,omitempty"`
	// Optional. Autoscaling config for the policy associated with the cluster.
	// Cluster does not autoscale if this field is unset.
	AutoscalingConfig *AutoscalingConfig `protobuf:"bytes,18,opt,name=autoscaling_config,json=autoscalingConfig,proto3" json:"autoscaling_config,omitempty"`
	// Optional. Security settings for the cluster.
	SecurityConfig *SecurityConfig `protobuf:"bytes,16,opt,name=security_config,json=securityConfig,proto3" json:"security_config,omitempty"`
	// Optional. Lifecycle setting for the cluster.
	LifecycleConfig *LifecycleConfig `protobuf:"bytes,17,opt,name=lifecycle_config,json=lifecycleConfig,proto3" json:"lifecycle_config,omitempty"`
	// Optional. Port/endpoint configuration for this cluster
	EndpointConfig *EndpointConfig `protobuf:"bytes,19,opt,name=endpoint_config,json=endpointConfig,proto3" json:"endpoint_config,omitempty"`
	// Optional. Metastore configuration.
	MetastoreConfig *MetastoreConfig `protobuf:"bytes,20,opt,name=metastore_config,json=metastoreConfig,proto3" json:"metastore_config,omitempty"`
	// Optional. The config for Dataproc metrics.
	DataprocMetricConfig *DataprocMetricConfig `protobuf:"bytes,23,opt,name=dataproc_metric_config,json=dataprocMetricConfig,proto3" json:"dataproc_metric_config,omitempty"`
	// Optional. The node group settings.
	AuxiliaryNodeGroups []*AuxiliaryNodeGroup `protobuf:"bytes,25,rep,name=auxiliary_node_groups,json=auxiliaryNodeGroups,proto3" json:"auxiliary_node_groups,omitempty"`
}

func (x *ClusterConfig) Reset() {
	*x = ClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfig) ProtoMessage() {}

func (x *ClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfig.ProtoReflect.Descriptor instead.
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{1}
}

func (x *ClusterConfig) GetConfigBucket() string {
	if x != nil {
		return x.ConfigBucket
	}
	return ""
}

func (x *ClusterConfig) GetTempBucket() string {
	if x != nil {
		return x.TempBucket
	}
	return ""
}

func (x *ClusterConfig) GetGceClusterConfig() *GceClusterConfig {
	if x != nil {
		return x.GceClusterConfig
	}
	return nil
}

func (x *ClusterConfig) GetMasterConfig() *InstanceGroupConfig {
	if x != nil {
		return x.MasterConfig
	}
	return nil
}

func (x *ClusterConfig) GetWorkerConfig() *InstanceGroupConfig {
	if x != nil {
		return x.WorkerConfig
	}
	return nil
}

func (x *ClusterConfig) GetSecondaryWorkerConfig() *InstanceGroupConfig {
	if x != nil {
		return x.SecondaryWorkerConfig
	}
	return nil
}

func (x *ClusterConfig) GetSoftwareConfig() *SoftwareConfig {
	if x != nil {
		return x.SoftwareConfig
	}
	return nil
}

func (x *ClusterConfig) GetInitializationActions() []*NodeInitializationAction {
	if x != nil {
		return x.InitializationActions
	}
	return nil
}

func (x *ClusterConfig) GetEncryptionConfig() *EncryptionConfig {
	if x != nil {
		return x.EncryptionConfig
	}
	return nil
}

func (x *ClusterConfig) GetAutoscalingConfig() *AutoscalingConfig {
	if x != nil {
		return x.AutoscalingConfig
	}
	return nil
}

func (x *ClusterConfig) GetSecurityConfig() *SecurityConfig {
	if x != nil {
		return x.SecurityConfig
	}
	return nil
}

func (x *ClusterConfig) GetLifecycleConfig() *LifecycleConfig {
	if x != nil {
		return x.LifecycleConfig
	}
	return nil
}

func (x *ClusterConfig) GetEndpointConfig() *EndpointConfig {
	if x != nil {
		return x.EndpointConfig
	}
	return nil
}

func (x *ClusterConfig) GetMetastoreConfig() *MetastoreConfig {
	if x != nil {
		return x.MetastoreConfig
	}
	return nil
}

func (x *ClusterConfig) GetDataprocMetricConfig() *DataprocMetricConfig {
	if x != nil {
		return x.DataprocMetricConfig
	}
	return nil
}

func (x *ClusterConfig) GetAuxiliaryNodeGroups() []*AuxiliaryNodeGroup {
	if x != nil {
		return x.AuxiliaryNodeGroups
	}
	return nil
}

// The Dataproc cluster config for a cluster that does not directly control the
// underlying compute resources, such as a [Dataproc-on-GKE
// cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
type VirtualClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A Cloud Storage bucket used to stage job
	// dependencies, config files, and job driver console output.
	// If you do not specify a staging bucket, Cloud
	// Dataproc will determine a Cloud Storage location (US,
	// ASIA, or EU) for your cluster's staging bucket according to the
	// Compute Engine zone where your cluster is deployed, and then create
	// and manage this project-level, per-location bucket (see
	// [Dataproc staging and temp
	// buckets](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
	// **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
	// a Cloud Storage bucket.**
	StagingBucket string `protobuf:"bytes,1,opt,name=staging_bucket,json=stagingBucket,proto3" json:"staging_bucket,omitempty"`
	// Types that are assignable to InfrastructureConfig:
	//
	//	*VirtualClusterConfig_KubernetesClusterConfig
	InfrastructureConfig isVirtualClusterConfig_InfrastructureConfig `protobuf_oneof:"infrastructure_config"`
	// Optional. Configuration of auxiliary services used by this cluster.
	AuxiliaryServicesConfig *AuxiliaryServicesConfig `protobuf:"bytes,7,opt,name=auxiliary_services_config,json=auxiliaryServicesConfig,proto3" json:"auxiliary_services_config,omitempty"`
}

func (x *VirtualClusterConfig) Reset() {
	*x = VirtualClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VirtualClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VirtualClusterConfig) ProtoMessage() {}

func (x *VirtualClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VirtualClusterConfig.ProtoReflect.Descriptor instead.
func (*VirtualClusterConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{2}
}

func (x *VirtualClusterConfig) GetStagingBucket() string {
	if x != nil {
		return x.StagingBucket
	}
	return ""
}

func (m *VirtualClusterConfig) GetInfrastructureConfig() isVirtualClusterConfig_InfrastructureConfig {
	if m != nil {
		return m.InfrastructureConfig
	}
	return nil
}

func (x *VirtualClusterConfig) GetKubernetesClusterConfig() *KubernetesClusterConfig {
	if x, ok := x.GetInfrastructureConfig().(*VirtualClusterConfig_KubernetesClusterConfig); ok {
		return x.KubernetesClusterConfig
	}
	return nil
}

func (x *VirtualClusterConfig) GetAuxiliaryServicesConfig() *AuxiliaryServicesConfig {
	if x != nil {
		return x.AuxiliaryServicesConfig
	}
	return nil
}

type isVirtualClusterConfig_InfrastructureConfig interface {
	isVirtualClusterConfig_InfrastructureConfig()
}

type VirtualClusterConfig_KubernetesClusterConfig struct {
	// Required. The configuration for running the Dataproc cluster on
	// Kubernetes.
	KubernetesClusterConfig *KubernetesClusterConfig `protobuf:"bytes,6,opt,name=kubernetes_cluster_config,json=kubernetesClusterConfig,proto3,oneof"`
}

func (*VirtualClusterConfig_KubernetesClusterConfig) isVirtualClusterConfig_InfrastructureConfig() {}

// Auxiliary services configuration for a Cluster.
type AuxiliaryServicesConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The Hive Metastore configuration for this workload.
	MetastoreConfig *MetastoreConfig `protobuf:"bytes,1,opt,name=metastore_config,json=metastoreConfig,proto3" json:"metastore_config,omitempty"`
	// Optional. The Spark History Server configuration for the workload.
	SparkHistoryServerConfig *SparkHistoryServerConfig `protobuf:"bytes,2,opt,name=spark_history_server_config,json=sparkHistoryServerConfig,proto3" json:"spark_history_server_config,omitempty"`
}

func (x *AuxiliaryServicesConfig) Reset() {
	*x = AuxiliaryServicesConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuxiliaryServicesConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuxiliaryServicesConfig) ProtoMessage() {}

func (x *AuxiliaryServicesConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuxiliaryServicesConfig.ProtoReflect.Descriptor instead.
func (*AuxiliaryServicesConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{3}
}

func (x *AuxiliaryServicesConfig) GetMetastoreConfig() *MetastoreConfig {
	if x != nil {
		return x.MetastoreConfig
	}
	return nil
}

func (x *AuxiliaryServicesConfig) GetSparkHistoryServerConfig() *SparkHistoryServerConfig {
	if x != nil {
		return x.SparkHistoryServerConfig
	}
	return nil
}

// Endpoint config for this cluster
type EndpointConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The map of port descriptions to URLs. Will only be populated
	// if enable_http_port_access is true.
	HttpPorts map[string]string `protobuf:"bytes,1,rep,name=http_ports,json=httpPorts,proto3" json:"http_ports,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. If true, enable http access to specific ports on the cluster
	// from external sources. Defaults to false.
	EnableHttpPortAccess bool `protobuf:"varint,2,opt,name=enable_http_port_access,json=enableHttpPortAccess,proto3" json:"enable_http_port_access,omitempty"`
}

func (x *EndpointConfig) Reset() {
	*x = EndpointConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndpointConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndpointConfig) ProtoMessage() {}

func (x *EndpointConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndpointConfig.ProtoReflect.Descriptor instead.
func (*EndpointConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{4}
}

func (x *EndpointConfig) GetHttpPorts() map[string]string {
	if x != nil {
		return x.HttpPorts
	}
	return nil
}

func (x *EndpointConfig) GetEnableHttpPortAccess() bool {
	if x != nil {
		return x.EnableHttpPortAccess
	}
	return false
}

// Autoscaling Policy config associated with the cluster.
type AutoscalingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The autoscaling policy used by the cluster.
	//
	// Only resource names including projectid and location (region) are valid.
	// Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]`
	// * `projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]`
	//
	// Note that the policy must be in the same project and Dataproc region.
	PolicyUri string `protobuf:"bytes,1,opt,name=policy_uri,json=policyUri,proto3" json:"policy_uri,omitempty"`
}

func (x *AutoscalingConfig) Reset() {
	*x = AutoscalingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingConfig) ProtoMessage() {}

func (x *AutoscalingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingConfig.ProtoReflect.Descriptor instead.
func (*AutoscalingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{5}
}

func (x *AutoscalingConfig) GetPolicyUri() string {
	if x != nil {
		return x.PolicyUri
	}
	return ""
}

// Encryption settings for the cluster.
type EncryptionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The Cloud KMS key name to use for PD disk encryption for all
	// instances in the cluster.
	GcePdKmsKeyName string `protobuf:"bytes,1,opt,name=gce_pd_kms_key_name,json=gcePdKmsKeyName,proto3" json:"gce_pd_kms_key_name,omitempty"`
}

func (x *EncryptionConfig) Reset() {
	*x = EncryptionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EncryptionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptionConfig) ProtoMessage() {}

func (x *EncryptionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptionConfig.ProtoReflect.Descriptor instead.
func (*EncryptionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{6}
}

func (x *EncryptionConfig) GetGcePdKmsKeyName() string {
	if x != nil {
		return x.GcePdKmsKeyName
	}
	return ""
}

// Common config settings for resources of Compute Engine cluster
// instances, applicable to all instances in the cluster.
type GceClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The Compute Engine zone where the Dataproc cluster will be
	// located. If omitted, the service will pick a zone in the cluster's Compute
	// Engine region. On a get request, zone will always be present.
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]`
	// * `projects/[project_id]/zones/[zone]`
	// * `[zone]`
	ZoneUri string `protobuf:"bytes,1,opt,name=zone_uri,json=zoneUri,proto3" json:"zone_uri,omitempty"`
	// Optional. The Compute Engine network to be used for machine
	// communications. Cannot be specified with subnetwork_uri. If neither
	// `network_uri` nor `subnetwork_uri` is specified, the "default" network of
	// the project is used, if it exists. Cannot be a "Custom Subnet Network" (see
	// [Using Subnetworks](https://cloud.google.com/compute/docs/subnetworks) for
	// more information).
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default`
	// * `projects/[project_id]/global/networks/default`
	// * `default`
	NetworkUri string `protobuf:"bytes,2,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// Optional. The Compute Engine subnetwork to be used for machine
	// communications. Cannot be specified with network_uri.
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/[region]/subnetworks/sub0`
	// * `projects/[project_id]/regions/[region]/subnetworks/sub0`
	// * `sub0`
	SubnetworkUri string `protobuf:"bytes,6,opt,name=subnetwork_uri,json=subnetworkUri,proto3" json:"subnetwork_uri,omitempty"`
	// Optional. If true, all instances in the cluster will only have internal IP
	// addresses. By default, clusters are not restricted to internal IP
	// addresses, and will have ephemeral external IP addresses assigned to each
	// instance. This `internal_ip_only` restriction can only be enabled for
	// subnetwork enabled networks, and all off-cluster dependencies must be
	// configured to be accessible without external IP addresses.
	InternalIpOnly *bool `protobuf:"varint,7,opt,name=internal_ip_only,json=internalIpOnly,proto3,oneof" json:"internal_ip_only,omitempty"`
	// Optional. The type of IPv6 access for a cluster.
	PrivateIpv6GoogleAccess GceClusterConfig_PrivateIpv6GoogleAccess `protobuf:"varint,12,opt,name=private_ipv6_google_access,json=privateIpv6GoogleAccess,proto3,enum=google.cloud.dataproc.v1.GceClusterConfig_PrivateIpv6GoogleAccess" json:"private_ipv6_google_access,omitempty"`
	// Optional. The [Dataproc service
	// account](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc)
	// (also see [VM Data Plane
	// identity](https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity))
	// used by Dataproc cluster VM instances to access Google Cloud Platform
	// services.
	//
	// If not specified, the
	// [Compute Engine default service
	// account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
	// is used.
	ServiceAccount string `protobuf:"bytes,8,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. The URIs of service account scopes to be included in
	// Compute Engine instances. The following base set of scopes is always
	// included:
	//
	// * https://www.googleapis.com/auth/cloud.useraccounts.readonly
	// * https://www.googleapis.com/auth/devstorage.read_write
	// * https://www.googleapis.com/auth/logging.write
	//
	// If no scopes are specified, the following defaults are also provided:
	//
	// * https://www.googleapis.com/auth/bigquery
	// * https://www.googleapis.com/auth/bigtable.admin.table
	// * https://www.googleapis.com/auth/bigtable.data
	// * https://www.googleapis.com/auth/devstorage.full_control
	ServiceAccountScopes []string `protobuf:"bytes,3,rep,name=service_account_scopes,json=serviceAccountScopes,proto3" json:"service_account_scopes,omitempty"`
	// The Compute Engine tags to add to all instances (see [Tagging
	// instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
	Tags []string `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
	// Optional. The Compute Engine metadata entries to add to all instances (see
	// [Project and instance
	// metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Reservation Affinity for consuming Zonal reservation.
	ReservationAffinity *ReservationAffinity `protobuf:"bytes,11,opt,name=reservation_affinity,json=reservationAffinity,proto3" json:"reservation_affinity,omitempty"`
	// Optional. Node Group Affinity for sole-tenant clusters.
	NodeGroupAffinity *NodeGroupAffinity `protobuf:"bytes,13,opt,name=node_group_affinity,json=nodeGroupAffinity,proto3" json:"node_group_affinity,omitempty"`
	// Optional. Shielded Instance Config for clusters using [Compute Engine
	// Shielded
	// VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
	ShieldedInstanceConfig *ShieldedInstanceConfig `protobuf:"bytes,14,opt,name=shielded_instance_config,json=shieldedInstanceConfig,proto3" json:"shielded_instance_config,omitempty"`
	// Optional. Confidential Instance Config for clusters using [Confidential
	// VMs](https://cloud.google.com/compute/confidential-vm/docs).
	ConfidentialInstanceConfig *ConfidentialInstanceConfig `protobuf:"bytes,15,opt,name=confidential_instance_config,json=confidentialInstanceConfig,proto3" json:"confidential_instance_config,omitempty"`
}

func (x *GceClusterConfig) Reset() {
	*x = GceClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GceClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GceClusterConfig) ProtoMessage() {}

func (x *GceClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GceClusterConfig.ProtoReflect.Descriptor instead.
func (*GceClusterConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{7}
}

func (x *GceClusterConfig) GetZoneUri() string {
	if x != nil {
		return x.ZoneUri
	}
	return ""
}

func (x *GceClusterConfig) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *GceClusterConfig) GetSubnetworkUri() string {
	if x != nil {
		return x.SubnetworkUri
	}
	return ""
}

func (x *GceClusterConfig) GetInternalIpOnly() bool {
	if x != nil && x.InternalIpOnly != nil {
		return *x.InternalIpOnly
	}
	return false
}

func (x *GceClusterConfig) GetPrivateIpv6GoogleAccess() GceClusterConfig_PrivateIpv6GoogleAccess {
	if x != nil {
		return x.PrivateIpv6GoogleAccess
	}
	return GceClusterConfig_PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED
}

func (x *GceClusterConfig) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *GceClusterConfig) GetServiceAccountScopes() []string {
	if x != nil {
		return x.ServiceAccountScopes
	}
	return nil
}

func (x *GceClusterConfig) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *GceClusterConfig) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *GceClusterConfig) GetReservationAffinity() *ReservationAffinity {
	if x != nil {
		return x.ReservationAffinity
	}
	return nil
}

func (x *GceClusterConfig) GetNodeGroupAffinity() *NodeGroupAffinity {
	if x != nil {
		return x.NodeGroupAffinity
	}
	return nil
}

func (x *GceClusterConfig) GetShieldedInstanceConfig() *ShieldedInstanceConfig {
	if x != nil {
		return x.ShieldedInstanceConfig
	}
	return nil
}

func (x *GceClusterConfig) GetConfidentialInstanceConfig() *ConfidentialInstanceConfig {
	if x != nil {
		return x.ConfidentialInstanceConfig
	}
	return nil
}

// Node Group Affinity for clusters using sole-tenant node groups.
// **The Dataproc `NodeGroupAffinity` resource is not related to the
// Dataproc [NodeGroup][google.cloud.dataproc.v1.NodeGroup] resource.**
type NodeGroupAffinity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URI of a
	// sole-tenant [node group
	// resource](https://cloud.google.com/compute/docs/reference/rest/v1/nodeGroups)
	// that the cluster will be created on.
	//
	// A full URL, partial URI, or node group name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]/nodeGroups/node-group-1`
	// * `projects/[project_id]/zones/[zone]/nodeGroups/node-group-1`
	// * `node-group-1`
	NodeGroupUri string `protobuf:"bytes,1,opt,name=node_group_uri,json=nodeGroupUri,proto3" json:"node_group_uri,omitempty"`
}

func (x *NodeGroupAffinity) Reset() {
	*x = NodeGroupAffinity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeGroupAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeGroupAffinity) ProtoMessage() {}

func (x *NodeGroupAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeGroupAffinity.ProtoReflect.Descriptor instead.
func (*NodeGroupAffinity) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{8}
}

func (x *NodeGroupAffinity) GetNodeGroupUri() string {
	if x != nil {
		return x.NodeGroupUri
	}
	return ""
}

// Shielded Instance Config for clusters using [Compute Engine Shielded
// VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
type ShieldedInstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Defines whether instances have Secure Boot enabled.
	EnableSecureBoot *bool `protobuf:"varint,1,opt,name=enable_secure_boot,json=enableSecureBoot,proto3,oneof" json:"enable_secure_boot,omitempty"`
	// Optional. Defines whether instances have the vTPM enabled.
	EnableVtpm *bool `protobuf:"varint,2,opt,name=enable_vtpm,json=enableVtpm,proto3,oneof" json:"enable_vtpm,omitempty"`
	// Optional. Defines whether instances have integrity monitoring enabled.
	EnableIntegrityMonitoring *bool `protobuf:"varint,3,opt,name=enable_integrity_monitoring,json=enableIntegrityMonitoring,proto3,oneof" json:"enable_integrity_monitoring,omitempty"`
}

func (x *ShieldedInstanceConfig) Reset() {
	*x = ShieldedInstanceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShieldedInstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShieldedInstanceConfig) ProtoMessage() {}

func (x *ShieldedInstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShieldedInstanceConfig.ProtoReflect.Descriptor instead.
func (*ShieldedInstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{9}
}

func (x *ShieldedInstanceConfig) GetEnableSecureBoot() bool {
	if x != nil && x.EnableSecureBoot != nil {
		return *x.EnableSecureBoot
	}
	return false
}

func (x *ShieldedInstanceConfig) GetEnableVtpm() bool {
	if x != nil && x.EnableVtpm != nil {
		return *x.EnableVtpm
	}
	return false
}

func (x *ShieldedInstanceConfig) GetEnableIntegrityMonitoring() bool {
	if x != nil && x.EnableIntegrityMonitoring != nil {
		return *x.EnableIntegrityMonitoring
	}
	return false
}

// Confidential Instance Config for clusters using [Confidential
// VMs](https://cloud.google.com/compute/confidential-vm/docs)
type ConfidentialInstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Defines whether the instance should have confidential compute
	// enabled.
	EnableConfidentialCompute bool `protobuf:"varint,1,opt,name=enable_confidential_compute,json=enableConfidentialCompute,proto3" json:"enable_confidential_compute,omitempty"`
}

func (x *ConfidentialInstanceConfig) Reset() {
	*x = ConfidentialInstanceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfidentialInstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfidentialInstanceConfig) ProtoMessage() {}

func (x *ConfidentialInstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfidentialInstanceConfig.ProtoReflect.Descriptor instead.
func (*ConfidentialInstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{10}
}

func (x *ConfidentialInstanceConfig) GetEnableConfidentialCompute() bool {
	if x != nil {
		return x.EnableConfidentialCompute
	}
	return false
}

// The config settings for Compute Engine resources in
// an instance group, such as a master or worker group.
type InstanceGroupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The number of VM instances in the instance group.
	// For [HA
	// cluster](/dataproc/docs/concepts/configuring-clusters/high-availability)
	// [master_config](#FIELDS.master_config) groups, **must be set to 3**.
	// For standard cluster [master_config](#FIELDS.master_config) groups,
	// **must be set to 1**.
	NumInstances int32 `protobuf:"varint,1,opt,name=num_instances,json=numInstances,proto3" json:"num_instances,omitempty"`
	// Output only. The list of instance names. Dataproc derives the names
	// from `cluster_name`, `num_instances`, and the instance group.
	InstanceNames []string `protobuf:"bytes,2,rep,name=instance_names,json=instanceNames,proto3" json:"instance_names,omitempty"`
	// Output only. List of references to Compute Engine instances.
	InstanceReferences []*InstanceReference `protobuf:"bytes,11,rep,name=instance_references,json=instanceReferences,proto3" json:"instance_references,omitempty"`
	// Optional. The Compute Engine image resource used for cluster instances.
	//
	// The URI can represent an image or image family.
	//
	// Image examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/images/[image-id]`
	// * `projects/[project_id]/global/images/[image-id]`
	// * `image-id`
	//
	// Image family examples. Dataproc will use the most recent
	// image from the family:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/images/family/[custom-image-family-name]`
	// * `projects/[project_id]/global/images/family/[custom-image-family-name]`
	//
	// If the URI is unspecified, it will be inferred from
	// `SoftwareConfig.image_version` or the system default.
	ImageUri string `protobuf:"bytes,3,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// Optional. The Compute Engine machine type used for cluster instances.
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]/machineTypes/n1-standard-2`
	// * `projects/[project_id]/zones/[zone]/machineTypes/n1-standard-2`
	// * `n1-standard-2`
	//
	// **Auto Zone Exception**: If you are using the Dataproc
	// [Auto Zone
	// Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
	// feature, you must use the short name of the machine type
	// resource, for example, `n1-standard-2`.
	MachineTypeUri string `protobuf:"bytes,4,opt,name=machine_type_uri,json=machineTypeUri,proto3" json:"machine_type_uri,omitempty"`
	// Optional. Disk option config settings.
	DiskConfig *DiskConfig `protobuf:"bytes,5,opt,name=disk_config,json=diskConfig,proto3" json:"disk_config,omitempty"`
	// Output only. Specifies that this instance group contains preemptible
	// instances.
	IsPreemptible bool `protobuf:"varint,6,opt,name=is_preemptible,json=isPreemptible,proto3" json:"is_preemptible,omitempty"`
	// Optional. Specifies the preemptibility of the instance group.
	//
	// The default value for master and worker groups is
	// `NON_PREEMPTIBLE`. This default cannot be changed.
	//
	// The default value for secondary instances is
	// `PREEMPTIBLE`.
	Preemptibility InstanceGroupConfig_Preemptibility `protobuf:"varint,10,opt,name=preemptibility,proto3,enum=google.cloud.dataproc.v1.InstanceGroupConfig_Preemptibility" json:"preemptibility,omitempty"`
	// Output only. The config for Compute Engine Instance Group
	// Manager that manages this group.
	// This is only used for preemptible instance groups.
	ManagedGroupConfig *ManagedGroupConfig `protobuf:"bytes,7,opt,name=managed_group_config,json=managedGroupConfig,proto3" json:"managed_group_config,omitempty"`
	// Optional. The Compute Engine accelerator configuration for these
	// instances.
	Accelerators []*AcceleratorConfig `protobuf:"bytes,8,rep,name=accelerators,proto3" json:"accelerators,omitempty"`
	// Optional. Specifies the minimum cpu platform for the Instance Group.
	// See [Dataproc -> Minimum CPU
	// Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
	MinCpuPlatform string `protobuf:"bytes,9,opt,name=min_cpu_platform,json=minCpuPlatform,proto3" json:"min_cpu_platform,omitempty"`
	// Optional. The minimum number of primary worker instances to create.
	// If `min_num_instances` is set, cluster creation will succeed if
	// the number of primary workers created is at least equal to the
	// `min_num_instances` number.
	//
	// Example: Cluster creation request with `num_instances` = `5` and
	// `min_num_instances` = `3`:
	//
	//   - If 4 VMs are created and 1 instance fails,
	//     the failed VM is deleted. The cluster is
	//     resized to 4 instances and placed in a `RUNNING` state.
	//   - If 2 instances are created and 3 instances fail,
	//     the cluster in placed in an `ERROR` state. The failed VMs
	//     are not deleted.
	MinNumInstances int32 `protobuf:"varint,12,opt,name=min_num_instances,json=minNumInstances,proto3" json:"min_num_instances,omitempty"`
	// Optional. Instance flexibility Policy allowing a mixture of VM shapes and
	// provisioning models.
	InstanceFlexibilityPolicy *InstanceFlexibilityPolicy `protobuf:"bytes,13,opt,name=instance_flexibility_policy,json=instanceFlexibilityPolicy,proto3" json:"instance_flexibility_policy,omitempty"`
	// Optional. Configuration to handle the startup of instances during cluster
	// create and update process.
	StartupConfig *StartupConfig `protobuf:"bytes,14,opt,name=startup_config,json=startupConfig,proto3" json:"startup_config,omitempty"`
}

func (x *InstanceGroupConfig) Reset() {
	*x = InstanceGroupConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceGroupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceGroupConfig) ProtoMessage() {}

func (x *InstanceGroupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceGroupConfig.ProtoReflect.Descriptor instead.
func (*InstanceGroupConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{11}
}

func (x *InstanceGroupConfig) GetNumInstances() int32 {
	if x != nil {
		return x.NumInstances
	}
	return 0
}

func (x *InstanceGroupConfig) GetInstanceNames() []string {
	if x != nil {
		return x.InstanceNames
	}
	return nil
}

func (x *InstanceGroupConfig) GetInstanceReferences() []*InstanceReference {
	if x != nil {
		return x.InstanceReferences
	}
	return nil
}

func (x *InstanceGroupConfig) GetImageUri() string {
	if x != nil {
		return x.ImageUri
	}
	return ""
}

func (x *InstanceGroupConfig) GetMachineTypeUri() string {
	if x != nil {
		return x.MachineTypeUri
	}
	return ""
}

func (x *InstanceGroupConfig) GetDiskConfig() *DiskConfig {
	if x != nil {
		return x.DiskConfig
	}
	return nil
}

func (x *InstanceGroupConfig) GetIsPreemptible() bool {
	if x != nil {
		return x.IsPreemptible
	}
	return false
}

func (x *InstanceGroupConfig) GetPreemptibility() InstanceGroupConfig_Preemptibility {
	if x != nil {
		return x.Preemptibility
	}
	return InstanceGroupConfig_PREEMPTIBILITY_UNSPECIFIED
}

func (x *InstanceGroupConfig) GetManagedGroupConfig() *ManagedGroupConfig {
	if x != nil {
		return x.ManagedGroupConfig
	}
	return nil
}

func (x *InstanceGroupConfig) GetAccelerators() []*AcceleratorConfig {
	if x != nil {
		return x.Accelerators
	}
	return nil
}

func (x *InstanceGroupConfig) GetMinCpuPlatform() string {
	if x != nil {
		return x.MinCpuPlatform
	}
	return ""
}

func (x *InstanceGroupConfig) GetMinNumInstances() int32 {
	if x != nil {
		return x.MinNumInstances
	}
	return 0
}

func (x *InstanceGroupConfig) GetInstanceFlexibilityPolicy() *InstanceFlexibilityPolicy {
	if x != nil {
		return x.InstanceFlexibilityPolicy
	}
	return nil
}

func (x *InstanceGroupConfig) GetStartupConfig() *StartupConfig {
	if x != nil {
		return x.StartupConfig
	}
	return nil
}

// Configuration to handle the startup of instances during cluster create and
// update process.
type StartupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The config setting to enable cluster creation/ updation to be
	// successful only after required_registration_fraction of instances are up
	// and running. This configuration is applicable to only secondary workers for
	// now. The cluster will fail if required_registration_fraction of instances
	// are not available. This will include instance creation, agent registration,
	// and service registration (if enabled).
	RequiredRegistrationFraction *float64 `protobuf:"fixed64,1,opt,name=required_registration_fraction,json=requiredRegistrationFraction,proto3,oneof" json:"required_registration_fraction,omitempty"`
}

func (x *StartupConfig) Reset() {
	*x = StartupConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartupConfig) ProtoMessage() {}

func (x *StartupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartupConfig.ProtoReflect.Descriptor instead.
func (*StartupConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{12}
}

func (x *StartupConfig) GetRequiredRegistrationFraction() float64 {
	if x != nil && x.RequiredRegistrationFraction != nil {
		return *x.RequiredRegistrationFraction
	}
	return 0
}

// A reference to a Compute Engine instance.
type InstanceReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user-friendly name of the Compute Engine instance.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The unique identifier of the Compute Engine instance.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// The public RSA key used for sharing data with this instance.
	PublicKey string `protobuf:"bytes,3,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// The public ECIES key used for sharing data with this instance.
	PublicEciesKey string `protobuf:"bytes,4,opt,name=public_ecies_key,json=publicEciesKey,proto3" json:"public_ecies_key,omitempty"`
}

func (x *InstanceReference) Reset() {
	*x = InstanceReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceReference) ProtoMessage() {}

func (x *InstanceReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceReference.ProtoReflect.Descriptor instead.
func (*InstanceReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{13}
}

func (x *InstanceReference) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *InstanceReference) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *InstanceReference) GetPublicKey() string {
	if x != nil {
		return x.PublicKey
	}
	return ""
}

func (x *InstanceReference) GetPublicEciesKey() string {
	if x != nil {
		return x.PublicEciesKey
	}
	return ""
}

// Specifies the resources used to actively manage an instance group.
type ManagedGroupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the Instance Template used for the Managed
	// Instance Group.
	InstanceTemplateName string `protobuf:"bytes,1,opt,name=instance_template_name,json=instanceTemplateName,proto3" json:"instance_template_name,omitempty"`
	// Output only. The name of the Instance Group Manager for this group.
	InstanceGroupManagerName string `protobuf:"bytes,2,opt,name=instance_group_manager_name,json=instanceGroupManagerName,proto3" json:"instance_group_manager_name,omitempty"`
	// Output only. The partial URI to the instance group manager for this group.
	// E.g. projects/my-project/regions/us-central1/instanceGroupManagers/my-igm.
	InstanceGroupManagerUri string `protobuf:"bytes,3,opt,name=instance_group_manager_uri,json=instanceGroupManagerUri,proto3" json:"instance_group_manager_uri,omitempty"`
}

func (x *ManagedGroupConfig) Reset() {
	*x = ManagedGroupConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGroupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGroupConfig) ProtoMessage() {}

func (x *ManagedGroupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGroupConfig.ProtoReflect.Descriptor instead.
func (*ManagedGroupConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{14}
}

func (x *ManagedGroupConfig) GetInstanceTemplateName() string {
	if x != nil {
		return x.InstanceTemplateName
	}
	return ""
}

func (x *ManagedGroupConfig) GetInstanceGroupManagerName() string {
	if x != nil {
		return x.InstanceGroupManagerName
	}
	return ""
}

func (x *ManagedGroupConfig) GetInstanceGroupManagerUri() string {
	if x != nil {
		return x.InstanceGroupManagerUri
	}
	return ""
}

// Instance flexibility Policy allowing a mixture of VM shapes and provisioning
// models.
type InstanceFlexibilityPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. List of instance selection options that the group will use when
	// creating new VMs.
	InstanceSelectionList []*InstanceFlexibilityPolicy_InstanceSelection `protobuf:"bytes,2,rep,name=instance_selection_list,json=instanceSelectionList,proto3" json:"instance_selection_list,omitempty"`
	// Output only. A list of instance selection results in the group.
	InstanceSelectionResults []*InstanceFlexibilityPolicy_InstanceSelectionResult `protobuf:"bytes,3,rep,name=instance_selection_results,json=instanceSelectionResults,proto3" json:"instance_selection_results,omitempty"`
}

func (x *InstanceFlexibilityPolicy) Reset() {
	*x = InstanceFlexibilityPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceFlexibilityPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceFlexibilityPolicy) ProtoMessage() {}

func (x *InstanceFlexibilityPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceFlexibilityPolicy.ProtoReflect.Descriptor instead.
func (*InstanceFlexibilityPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{15}
}

func (x *InstanceFlexibilityPolicy) GetInstanceSelectionList() []*InstanceFlexibilityPolicy_InstanceSelection {
	if x != nil {
		return x.InstanceSelectionList
	}
	return nil
}

func (x *InstanceFlexibilityPolicy) GetInstanceSelectionResults() []*InstanceFlexibilityPolicy_InstanceSelectionResult {
	if x != nil {
		return x.InstanceSelectionResults
	}
	return nil
}

// Specifies the type and number of accelerator cards attached to the instances
// of an instance. See [GPUs on Compute
// Engine](https://cloud.google.com/compute/docs/gpus/).
type AcceleratorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full URL, partial URI, or short name of the accelerator type resource to
	// expose to this instance. See
	// [Compute Engine
	// AcceleratorTypes](https://cloud.google.com/compute/docs/reference/v1/acceleratorTypes).
	//
	// Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]/acceleratorTypes/nvidia-tesla-k80`
	// * `projects/[project_id]/zones/[zone]/acceleratorTypes/nvidia-tesla-k80`
	// * `nvidia-tesla-k80`
	//
	// **Auto Zone Exception**: If you are using the Dataproc
	// [Auto Zone
	// Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
	// feature, you must use the short name of the accelerator type
	// resource, for example, `nvidia-tesla-k80`.
	AcceleratorTypeUri string `protobuf:"bytes,1,opt,name=accelerator_type_uri,json=acceleratorTypeUri,proto3" json:"accelerator_type_uri,omitempty"`
	// The number of the accelerator cards of this type exposed to this instance.
	AcceleratorCount int32 `protobuf:"varint,2,opt,name=accelerator_count,json=acceleratorCount,proto3" json:"accelerator_count,omitempty"`
}

func (x *AcceleratorConfig) Reset() {
	*x = AcceleratorConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceleratorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorConfig) ProtoMessage() {}

func (x *AcceleratorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorConfig.ProtoReflect.Descriptor instead.
func (*AcceleratorConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{16}
}

func (x *AcceleratorConfig) GetAcceleratorTypeUri() string {
	if x != nil {
		return x.AcceleratorTypeUri
	}
	return ""
}

func (x *AcceleratorConfig) GetAcceleratorCount() int32 {
	if x != nil {
		return x.AcceleratorCount
	}
	return 0
}

// Specifies the config of disk options for a group of VM instances.
type DiskConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Type of the boot disk (default is "pd-standard").
	// Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive),
	// "pd-ssd" (Persistent Disk Solid State Drive),
	// or "pd-standard" (Persistent Disk Hard Disk Drive).
	// See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
	BootDiskType string `protobuf:"bytes,3,opt,name=boot_disk_type,json=bootDiskType,proto3" json:"boot_disk_type,omitempty"`
	// Optional. Size in GB of the boot disk (default is 500GB).
	BootDiskSizeGb int32 `protobuf:"varint,1,opt,name=boot_disk_size_gb,json=bootDiskSizeGb,proto3" json:"boot_disk_size_gb,omitempty"`
	// Optional. Number of attached SSDs, from 0 to 8 (default is 0).
	// If SSDs are not attached, the boot disk is used to store runtime logs and
	// [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data.
	// If one or more SSDs are attached, this runtime bulk
	// data is spread across them, and the boot disk contains only basic
	// config and installed binaries.
	//
	// Note: Local SSD options may vary by machine type and number of vCPUs
	// selected.
	NumLocalSsds int32 `protobuf:"varint,2,opt,name=num_local_ssds,json=numLocalSsds,proto3" json:"num_local_ssds,omitempty"`
	// Optional. Interface type of local SSDs (default is "scsi").
	// Valid values: "scsi" (Small Computer System Interface),
	// "nvme" (Non-Volatile Memory Express).
	// See [local SSD
	// performance](https://cloud.google.com/compute/docs/disks/local-ssd#performance).
	LocalSsdInterface string `protobuf:"bytes,4,opt,name=local_ssd_interface,json=localSsdInterface,proto3" json:"local_ssd_interface,omitempty"`
}

func (x *DiskConfig) Reset() {
	*x = DiskConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskConfig) ProtoMessage() {}

func (x *DiskConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskConfig.ProtoReflect.Descriptor instead.
func (*DiskConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{17}
}

func (x *DiskConfig) GetBootDiskType() string {
	if x != nil {
		return x.BootDiskType
	}
	return ""
}

func (x *DiskConfig) GetBootDiskSizeGb() int32 {
	if x != nil {
		return x.BootDiskSizeGb
	}
	return 0
}

func (x *DiskConfig) GetNumLocalSsds() int32 {
	if x != nil {
		return x.NumLocalSsds
	}
	return 0
}

func (x *DiskConfig) GetLocalSsdInterface() string {
	if x != nil {
		return x.LocalSsdInterface
	}
	return ""
}

// Node group identification and configuration information.
type AuxiliaryNodeGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Node group configuration.
	NodeGroup *NodeGroup `protobuf:"bytes,1,opt,name=node_group,json=nodeGroup,proto3" json:"node_group,omitempty"`
	// Optional. A node group ID. Generated if not specified.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). Cannot begin or end with underscore
	// or hyphen. Must consist of from 3 to 33 characters.
	NodeGroupId string `protobuf:"bytes,2,opt,name=node_group_id,json=nodeGroupId,proto3" json:"node_group_id,omitempty"`
}

func (x *AuxiliaryNodeGroup) Reset() {
	*x = AuxiliaryNodeGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuxiliaryNodeGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuxiliaryNodeGroup) ProtoMessage() {}

func (x *AuxiliaryNodeGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuxiliaryNodeGroup.ProtoReflect.Descriptor instead.
func (*AuxiliaryNodeGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{18}
}

func (x *AuxiliaryNodeGroup) GetNodeGroup() *NodeGroup {
	if x != nil {
		return x.NodeGroup
	}
	return nil
}

func (x *AuxiliaryNodeGroup) GetNodeGroupId() string {
	if x != nil {
		return x.NodeGroupId
	}
	return ""
}

// Dataproc Node Group.
// **The Dataproc `NodeGroup` resource is not related to the
// Dataproc [NodeGroupAffinity][google.cloud.dataproc.v1.NodeGroupAffinity]
// resource.**
type NodeGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Node group [resource name](https://aip.dev/122).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Node group roles.
	Roles []NodeGroup_Role `protobuf:"varint,2,rep,packed,name=roles,proto3,enum=google.cloud.dataproc.v1.NodeGroup_Role" json:"roles,omitempty"`
	// Optional. The node group instance group configuration.
	NodeGroupConfig *InstanceGroupConfig `protobuf:"bytes,3,opt,name=node_group_config,json=nodeGroupConfig,proto3" json:"node_group_config,omitempty"`
	// Optional. Node group labels.
	//
	//   - Label **keys** must consist of from 1 to 63 characters and conform to
	//     [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	//   - Label **values** can be empty. If specified, they must consist of from
	//     1 to 63 characters and conform to [RFC 1035]
	//     (https://www.ietf.org/rfc/rfc1035.txt).
	//   - The node group must have no more than 32 labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *NodeGroup) Reset() {
	*x = NodeGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeGroup) ProtoMessage() {}

func (x *NodeGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeGroup.ProtoReflect.Descriptor instead.
func (*NodeGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{19}
}

func (x *NodeGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NodeGroup) GetRoles() []NodeGroup_Role {
	if x != nil {
		return x.Roles
	}
	return nil
}

func (x *NodeGroup) GetNodeGroupConfig() *InstanceGroupConfig {
	if x != nil {
		return x.NodeGroupConfig
	}
	return nil
}

func (x *NodeGroup) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Specifies an executable to run on a fully configured node and a
// timeout period for executable completion.
type NodeInitializationAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Cloud Storage URI of executable file.
	ExecutableFile string `protobuf:"bytes,1,opt,name=executable_file,json=executableFile,proto3" json:"executable_file,omitempty"`
	// Optional. Amount of time executable has to complete. Default is
	// 10 minutes (see JSON representation of
	// [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
	//
	// Cluster creation fails with an explanatory error message (the
	// name of the executable that caused the error and the exceeded timeout
	// period) if the executable is not completed at end of the timeout period.
	ExecutionTimeout *durationpb.Duration `protobuf:"bytes,2,opt,name=execution_timeout,json=executionTimeout,proto3" json:"execution_timeout,omitempty"`
}

func (x *NodeInitializationAction) Reset() {
	*x = NodeInitializationAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeInitializationAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeInitializationAction) ProtoMessage() {}

func (x *NodeInitializationAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeInitializationAction.ProtoReflect.Descriptor instead.
func (*NodeInitializationAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{20}
}

func (x *NodeInitializationAction) GetExecutableFile() string {
	if x != nil {
		return x.ExecutableFile
	}
	return ""
}

func (x *NodeInitializationAction) GetExecutionTimeout() *durationpb.Duration {
	if x != nil {
		return x.ExecutionTimeout
	}
	return nil
}

// The status of a cluster and its instances.
type ClusterStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The cluster's state.
	State ClusterStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.dataproc.v1.ClusterStatus_State" json:"state,omitempty"`
	// Optional. Output only. Details of cluster's state.
	Detail string `protobuf:"bytes,2,opt,name=detail,proto3" json:"detail,omitempty"`
	// Output only. Time when this state was entered (see JSON representation of
	// [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
	StateStartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=state_start_time,json=stateStartTime,proto3" json:"state_start_time,omitempty"`
	// Output only. Additional state information that includes
	// status reported by the agent.
	Substate ClusterStatus_Substate `protobuf:"varint,4,opt,name=substate,proto3,enum=google.cloud.dataproc.v1.ClusterStatus_Substate" json:"substate,omitempty"`
}

func (x *ClusterStatus) Reset() {
	*x = ClusterStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterStatus) ProtoMessage() {}

func (x *ClusterStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterStatus.ProtoReflect.Descriptor instead.
func (*ClusterStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{21}
}

func (x *ClusterStatus) GetState() ClusterStatus_State {
	if x != nil {
		return x.State
	}
	return ClusterStatus_UNKNOWN
}

func (x *ClusterStatus) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

func (x *ClusterStatus) GetStateStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StateStartTime
	}
	return nil
}

func (x *ClusterStatus) GetSubstate() ClusterStatus_Substate {
	if x != nil {
		return x.Substate
	}
	return ClusterStatus_UNSPECIFIED
}

// Security related configuration, including encryption, Kerberos, etc.
type SecurityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Kerberos related configuration.
	KerberosConfig *KerberosConfig `protobuf:"bytes,1,opt,name=kerberos_config,json=kerberosConfig,proto3" json:"kerberos_config,omitempty"`
	// Optional. Identity related configuration, including service account based
	// secure multi-tenancy user mappings.
	IdentityConfig *IdentityConfig `protobuf:"bytes,2,opt,name=identity_config,json=identityConfig,proto3" json:"identity_config,omitempty"`
}

func (x *SecurityConfig) Reset() {
	*x = SecurityConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecurityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityConfig) ProtoMessage() {}

func (x *SecurityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityConfig.ProtoReflect.Descriptor instead.
func (*SecurityConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{22}
}

func (x *SecurityConfig) GetKerberosConfig() *KerberosConfig {
	if x != nil {
		return x.KerberosConfig
	}
	return nil
}

func (x *SecurityConfig) GetIdentityConfig() *IdentityConfig {
	if x != nil {
		return x.IdentityConfig
	}
	return nil
}

// Specifies Kerberos related configuration.
type KerberosConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Flag to indicate whether to Kerberize the cluster (default:
	// false). Set this field to true to enable Kerberos on a cluster.
	EnableKerberos bool `protobuf:"varint,1,opt,name=enable_kerberos,json=enableKerberos,proto3" json:"enable_kerberos,omitempty"`
	// Optional. The Cloud Storage URI of a KMS encrypted file containing the root
	// principal password.
	RootPrincipalPasswordUri string `protobuf:"bytes,2,opt,name=root_principal_password_uri,json=rootPrincipalPasswordUri,proto3" json:"root_principal_password_uri,omitempty"`
	// Optional. The uri of the KMS key used to encrypt various sensitive
	// files.
	KmsKeyUri string `protobuf:"bytes,3,opt,name=kms_key_uri,json=kmsKeyUri,proto3" json:"kms_key_uri,omitempty"`
	// Optional. The Cloud Storage URI of the keystore file used for SSL
	// encryption. If not provided, Dataproc will provide a self-signed
	// certificate.
	KeystoreUri string `protobuf:"bytes,4,opt,name=keystore_uri,json=keystoreUri,proto3" json:"keystore_uri,omitempty"`
	// Optional. The Cloud Storage URI of the truststore file used for SSL
	// encryption. If not provided, Dataproc will provide a self-signed
	// certificate.
	TruststoreUri string `protobuf:"bytes,5,opt,name=truststore_uri,json=truststoreUri,proto3" json:"truststore_uri,omitempty"`
	// Optional. The Cloud Storage URI of a KMS encrypted file containing the
	// password to the user provided keystore. For the self-signed certificate,
	// this password is generated by Dataproc.
	KeystorePasswordUri string `protobuf:"bytes,6,opt,name=keystore_password_uri,json=keystorePasswordUri,proto3" json:"keystore_password_uri,omitempty"`
	// Optional. The Cloud Storage URI of a KMS encrypted file containing the
	// password to the user provided key. For the self-signed certificate, this
	// password is generated by Dataproc.
	KeyPasswordUri string `protobuf:"bytes,7,opt,name=key_password_uri,json=keyPasswordUri,proto3" json:"key_password_uri,omitempty"`
	// Optional. The Cloud Storage URI of a KMS encrypted file containing the
	// password to the user provided truststore. For the self-signed certificate,
	// this password is generated by Dataproc.
	TruststorePasswordUri string `protobuf:"bytes,8,opt,name=truststore_password_uri,json=truststorePasswordUri,proto3" json:"truststore_password_uri,omitempty"`
	// Optional. The remote realm the Dataproc on-cluster KDC will trust, should
	// the user enable cross realm trust.
	CrossRealmTrustRealm string `protobuf:"bytes,9,opt,name=cross_realm_trust_realm,json=crossRealmTrustRealm,proto3" json:"cross_realm_trust_realm,omitempty"`
	// Optional. The KDC (IP or hostname) for the remote trusted realm in a cross
	// realm trust relationship.
	CrossRealmTrustKdc string `protobuf:"bytes,10,opt,name=cross_realm_trust_kdc,json=crossRealmTrustKdc,proto3" json:"cross_realm_trust_kdc,omitempty"`
	// Optional. The admin server (IP or hostname) for the remote trusted realm in
	// a cross realm trust relationship.
	CrossRealmTrustAdminServer string `protobuf:"bytes,11,opt,name=cross_realm_trust_admin_server,json=crossRealmTrustAdminServer,proto3" json:"cross_realm_trust_admin_server,omitempty"`
	// Optional. The Cloud Storage URI of a KMS encrypted file containing the
	// shared password between the on-cluster Kerberos realm and the remote
	// trusted realm, in a cross realm trust relationship.
	CrossRealmTrustSharedPasswordUri string `protobuf:"bytes,12,opt,name=cross_realm_trust_shared_password_uri,json=crossRealmTrustSharedPasswordUri,proto3" json:"cross_realm_trust_shared_password_uri,omitempty"`
	// Optional. The Cloud Storage URI of a KMS encrypted file containing the
	// master key of the KDC database.
	KdcDbKeyUri string `protobuf:"bytes,13,opt,name=kdc_db_key_uri,json=kdcDbKeyUri,proto3" json:"kdc_db_key_uri,omitempty"`
	// Optional. The lifetime of the ticket granting ticket, in hours.
	// If not specified, or user specifies 0, then default value 10
	// will be used.
	TgtLifetimeHours int32 `protobuf:"varint,14,opt,name=tgt_lifetime_hours,json=tgtLifetimeHours,proto3" json:"tgt_lifetime_hours,omitempty"`
	// Optional. The name of the on-cluster Kerberos realm.
	// If not specified, the uppercased domain of hostnames will be the realm.
	Realm string `protobuf:"bytes,15,opt,name=realm,proto3" json:"realm,omitempty"`
}

func (x *KerberosConfig) Reset() {
	*x = KerberosConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KerberosConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KerberosConfig) ProtoMessage() {}

func (x *KerberosConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KerberosConfig.ProtoReflect.Descriptor instead.
func (*KerberosConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{23}
}

func (x *KerberosConfig) GetEnableKerberos() bool {
	if x != nil {
		return x.EnableKerberos
	}
	return false
}

func (x *KerberosConfig) GetRootPrincipalPasswordUri() string {
	if x != nil {
		return x.RootPrincipalPasswordUri
	}
	return ""
}

func (x *KerberosConfig) GetKmsKeyUri() string {
	if x != nil {
		return x.KmsKeyUri
	}
	return ""
}

func (x *KerberosConfig) GetKeystoreUri() string {
	if x != nil {
		return x.KeystoreUri
	}
	return ""
}

func (x *KerberosConfig) GetTruststoreUri() string {
	if x != nil {
		return x.TruststoreUri
	}
	return ""
}

func (x *KerberosConfig) GetKeystorePasswordUri() string {
	if x != nil {
		return x.KeystorePasswordUri
	}
	return ""
}

func (x *KerberosConfig) GetKeyPasswordUri() string {
	if x != nil {
		return x.KeyPasswordUri
	}
	return ""
}

func (x *KerberosConfig) GetTruststorePasswordUri() string {
	if x != nil {
		return x.TruststorePasswordUri
	}
	return ""
}

func (x *KerberosConfig) GetCrossRealmTrustRealm() string {
	if x != nil {
		return x.CrossRealmTrustRealm
	}
	return ""
}

func (x *KerberosConfig) GetCrossRealmTrustKdc() string {
	if x != nil {
		return x.CrossRealmTrustKdc
	}
	return ""
}

func (x *KerberosConfig) GetCrossRealmTrustAdminServer() string {
	if x != nil {
		return x.CrossRealmTrustAdminServer
	}
	return ""
}

func (x *KerberosConfig) GetCrossRealmTrustSharedPasswordUri() string {
	if x != nil {
		return x.CrossRealmTrustSharedPasswordUri
	}
	return ""
}

func (x *KerberosConfig) GetKdcDbKeyUri() string {
	if x != nil {
		return x.KdcDbKeyUri
	}
	return ""
}

func (x *KerberosConfig) GetTgtLifetimeHours() int32 {
	if x != nil {
		return x.TgtLifetimeHours
	}
	return 0
}

func (x *KerberosConfig) GetRealm() string {
	if x != nil {
		return x.Realm
	}
	return ""
}

// Identity related configuration, including service account based
// secure multi-tenancy user mappings.
type IdentityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Map of user to service account.
	UserServiceAccountMapping map[string]string `protobuf:"bytes,1,rep,name=user_service_account_mapping,json=userServiceAccountMapping,proto3" json:"user_service_account_mapping,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *IdentityConfig) Reset() {
	*x = IdentityConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IdentityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IdentityConfig) ProtoMessage() {}

func (x *IdentityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IdentityConfig.ProtoReflect.Descriptor instead.
func (*IdentityConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{24}
}

func (x *IdentityConfig) GetUserServiceAccountMapping() map[string]string {
	if x != nil {
		return x.UserServiceAccountMapping
	}
	return nil
}

// Specifies the selection and config of software inside the cluster.
type SoftwareConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The version of software inside the cluster. It must be one of the
	// supported [Dataproc
	// Versions](https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#supported_dataproc_versions),
	// such as "1.2" (including a subminor version, such as "1.2.29"), or the
	// ["preview"
	// version](https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions).
	// If unspecified, it defaults to the latest Debian version.
	ImageVersion string `protobuf:"bytes,1,opt,name=image_version,json=imageVersion,proto3" json:"image_version,omitempty"`
	// Optional. The properties to set on daemon config files.
	//
	// Property keys are specified in `prefix:property` format, for example
	// `core:hadoop.tmp.dir`. The following are supported prefixes
	// and their mappings:
	//
	// * capacity-scheduler: `capacity-scheduler.xml`
	// * core:   `core-site.xml`
	// * distcp: `distcp-default.xml`
	// * hdfs:   `hdfs-site.xml`
	// * hive:   `hive-site.xml`
	// * mapred: `mapred-site.xml`
	// * pig:    `pig.properties`
	// * spark:  `spark-defaults.conf`
	// * yarn:   `yarn-site.xml`
	//
	// For more information, see [Cluster
	// properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
	Properties map[string]string `protobuf:"bytes,2,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The set of components to activate on the cluster.
	OptionalComponents []Component `protobuf:"varint,3,rep,packed,name=optional_components,json=optionalComponents,proto3,enum=google.cloud.dataproc.v1.Component" json:"optional_components,omitempty"`
}

func (x *SoftwareConfig) Reset() {
	*x = SoftwareConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoftwareConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoftwareConfig) ProtoMessage() {}

func (x *SoftwareConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoftwareConfig.ProtoReflect.Descriptor instead.
func (*SoftwareConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{25}
}

func (x *SoftwareConfig) GetImageVersion() string {
	if x != nil {
		return x.ImageVersion
	}
	return ""
}

func (x *SoftwareConfig) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *SoftwareConfig) GetOptionalComponents() []Component {
	if x != nil {
		return x.OptionalComponents
	}
	return nil
}

// Specifies the cluster auto-delete schedule configuration.
type LifecycleConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The duration to keep the cluster alive while idling (when no jobs
	// are running). Passing this threshold will cause the cluster to be
	// deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON
	// representation of
	// [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
	IdleDeleteTtl *durationpb.Duration `protobuf:"bytes,1,opt,name=idle_delete_ttl,json=idleDeleteTtl,proto3" json:"idle_delete_ttl,omitempty"`
	// Either the exact time the cluster should be deleted at or
	// the cluster maximum age.
	//
	// Types that are assignable to Ttl:
	//
	//	*LifecycleConfig_AutoDeleteTime
	//	*LifecycleConfig_AutoDeleteTtl
	Ttl isLifecycleConfig_Ttl `protobuf_oneof:"ttl"`
	// Output only. The time when cluster became idle (most recent job finished)
	// and became eligible for deletion due to idleness (see JSON representation
	// of
	// [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
	IdleStartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=idle_start_time,json=idleStartTime,proto3" json:"idle_start_time,omitempty"`
}

func (x *LifecycleConfig) Reset() {
	*x = LifecycleConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LifecycleConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleConfig) ProtoMessage() {}

func (x *LifecycleConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleConfig.ProtoReflect.Descriptor instead.
func (*LifecycleConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{26}
}

func (x *LifecycleConfig) GetIdleDeleteTtl() *durationpb.Duration {
	if x != nil {
		return x.IdleDeleteTtl
	}
	return nil
}

func (m *LifecycleConfig) GetTtl() isLifecycleConfig_Ttl {
	if m != nil {
		return m.Ttl
	}
	return nil
}

func (x *LifecycleConfig) GetAutoDeleteTime() *timestamppb.Timestamp {
	if x, ok := x.GetTtl().(*LifecycleConfig_AutoDeleteTime); ok {
		return x.AutoDeleteTime
	}
	return nil
}

func (x *LifecycleConfig) GetAutoDeleteTtl() *durationpb.Duration {
	if x, ok := x.GetTtl().(*LifecycleConfig_AutoDeleteTtl); ok {
		return x.AutoDeleteTtl
	}
	return nil
}

func (x *LifecycleConfig) GetIdleStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.IdleStartTime
	}
	return nil
}

type isLifecycleConfig_Ttl interface {
	isLifecycleConfig_Ttl()
}

type LifecycleConfig_AutoDeleteTime struct {
	// Optional. The time when cluster will be auto-deleted (see JSON
	// representation of
	// [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
	AutoDeleteTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=auto_delete_time,json=autoDeleteTime,proto3,oneof"`
}

type LifecycleConfig_AutoDeleteTtl struct {
	// Optional. The lifetime duration of cluster. The cluster will be
	// auto-deleted at the end of this period. Minimum value is 10 minutes;
	// maximum value is 14 days (see JSON representation of
	// [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
	AutoDeleteTtl *durationpb.Duration `protobuf:"bytes,3,opt,name=auto_delete_ttl,json=autoDeleteTtl,proto3,oneof"`
}

func (*LifecycleConfig_AutoDeleteTime) isLifecycleConfig_Ttl() {}

func (*LifecycleConfig_AutoDeleteTtl) isLifecycleConfig_Ttl() {}

// Specifies a Metastore configuration.
type MetastoreConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of an existing Dataproc Metastore service.
	//
	// Example:
	//
	// * `projects/[project_id]/locations/[dataproc_region]/services/[service-name]`
	DataprocMetastoreService string `protobuf:"bytes,1,opt,name=dataproc_metastore_service,json=dataprocMetastoreService,proto3" json:"dataproc_metastore_service,omitempty"`
}

func (x *MetastoreConfig) Reset() {
	*x = MetastoreConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetastoreConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetastoreConfig) ProtoMessage() {}

func (x *MetastoreConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetastoreConfig.ProtoReflect.Descriptor instead.
func (*MetastoreConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{27}
}

func (x *MetastoreConfig) GetDataprocMetastoreService() string {
	if x != nil {
		return x.DataprocMetastoreService
	}
	return ""
}

// Contains cluster daemon metrics, such as HDFS and YARN stats.
//
// **Beta Feature**: This report is available for testing purposes only. It may
// be changed before final release.
type ClusterMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The HDFS metrics.
	HdfsMetrics map[string]int64 `protobuf:"bytes,1,rep,name=hdfs_metrics,json=hdfsMetrics,proto3" json:"hdfs_metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// YARN metrics.
	YarnMetrics map[string]int64 `protobuf:"bytes,2,rep,name=yarn_metrics,json=yarnMetrics,proto3" json:"yarn_metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (x *ClusterMetrics) Reset() {
	*x = ClusterMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterMetrics) ProtoMessage() {}

func (x *ClusterMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterMetrics.ProtoReflect.Descriptor instead.
func (*ClusterMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{28}
}

func (x *ClusterMetrics) GetHdfsMetrics() map[string]int64 {
	if x != nil {
		return x.HdfsMetrics
	}
	return nil
}

func (x *ClusterMetrics) GetYarnMetrics() map[string]int64 {
	if x != nil {
		return x.YarnMetrics
	}
	return nil
}

// Dataproc metric config.
type DataprocMetricConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Metrics sources to enable.
	Metrics []*DataprocMetricConfig_Metric `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *DataprocMetricConfig) Reset() {
	*x = DataprocMetricConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataprocMetricConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataprocMetricConfig) ProtoMessage() {}

func (x *DataprocMetricConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataprocMetricConfig.ProtoReflect.Descriptor instead.
func (*DataprocMetricConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{29}
}

func (x *DataprocMetricConfig) GetMetrics() []*DataprocMetricConfig_Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// A request to create a cluster.
type CreateClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The cluster to create.
	Cluster *Cluster `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Optional. A unique ID used to identify the request. If the server receives
	// two
	// [CreateClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateClusterRequest)s
	// with the same id, then the second request will be ignored and the
	// first [google.longrunning.Operation][google.longrunning.Operation] created
	// and stored in the backend is returned.
	//
	// It is recommended to always set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. Failure action when primary worker creation fails.
	ActionOnFailedPrimaryWorkers FailureAction `protobuf:"varint,5,opt,name=action_on_failed_primary_workers,json=actionOnFailedPrimaryWorkers,proto3,enum=google.cloud.dataproc.v1.FailureAction" json:"action_on_failed_primary_workers,omitempty"`
}

func (x *CreateClusterRequest) Reset() {
	*x = CreateClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateClusterRequest) ProtoMessage() {}

func (x *CreateClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{30}
}

func (x *CreateClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CreateClusterRequest) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *CreateClusterRequest) GetCluster() *Cluster {
	if x != nil {
		return x.Cluster
	}
	return nil
}

func (x *CreateClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateClusterRequest) GetActionOnFailedPrimaryWorkers() FailureAction {
	if x != nil {
		return x.ActionOnFailedPrimaryWorkers
	}
	return FailureAction_FAILURE_ACTION_UNSPECIFIED
}

// A request to update a cluster.
type UpdateClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Google Cloud Platform project the
	// cluster belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,5,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Required. The changes to the cluster.
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Optional. Timeout for graceful YARN decommissioning. Graceful
	// decommissioning allows removing nodes from the cluster without
	// interrupting jobs in progress. Timeout specifies how long to wait for jobs
	// in progress to finish before forcefully removing nodes (and potentially
	// interrupting jobs). Default timeout is 0 (for forceful decommission), and
	// the maximum allowed timeout is 1 day. (see JSON representation of
	// [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
	//
	// Only supported on Dataproc image versions 1.2 and higher.
	GracefulDecommissionTimeout *durationpb.Duration `protobuf:"bytes,6,opt,name=graceful_decommission_timeout,json=gracefulDecommissionTimeout,proto3" json:"graceful_decommission_timeout,omitempty"`
	// Required. Specifies the path, relative to `Cluster`, of
	// the field to update. For example, to change the number of workers
	// in a cluster to 5, the `update_mask` parameter would be
	// specified as `config.worker_config.num_instances`,
	// and the `PATCH` request body would specify the new value, as follows:
	//
	//	{
	//	  "config":{
	//	    "workerConfig":{
	//	      "numInstances":"5"
	//	    }
	//	  }
	//	}
	//
	// Similarly, to change the number of preemptible workers in a cluster to 5,
	// the `update_mask` parameter would be
	// `config.secondary_worker_config.num_instances`, and the `PATCH` request
	// body would be set as follows:
	//
	//	{
	//	  "config":{
	//	    "secondaryWorkerConfig":{
	//	      "numInstances":"5"
	//	    }
	//	  }
	//	}
	//
	// <strong>Note:</strong> Currently, only the following fields can be updated:
	//
	//	<table>
	//	<tbody>
	//	<tr>
	//	<td><strong>Mask</strong></td>
	//	<td><strong>Purpose</strong></td>
	//	</tr>
	//	<tr>
	//	<td><strong><em>labels</em></strong></td>
	//	<td>Update labels</td>
	//	</tr>
	//	<tr>
	//	<td><strong><em>config.worker_config.num_instances</em></strong></td>
	//	<td>Resize primary worker group</td>
	//	</tr>
	//	<tr>
	//	<td><strong><em>config.secondary_worker_config.num_instances</em></strong></td>
	//	<td>Resize secondary worker group</td>
	//	</tr>
	//	<tr>
	//	<td>config.autoscaling_config.policy_uri</td><td>Use, stop using, or
	//	change autoscaling policies</td>
	//	</tr>
	//	</tbody>
	//	</table>
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. A unique ID used to identify the request. If the server
	// receives two
	// [UpdateClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.UpdateClusterRequest)s
	// with the same id, then the second request will be ignored and the
	// first [google.longrunning.Operation][google.longrunning.Operation] created
	// and stored in the backend is returned.
	//
	// It is recommended to always set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,7,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateClusterRequest) Reset() {
	*x = UpdateClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateClusterRequest) ProtoMessage() {}

func (x *UpdateClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateClusterRequest.ProtoReflect.Descriptor instead.
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{31}
}

func (x *UpdateClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *UpdateClusterRequest) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *UpdateClusterRequest) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *UpdateClusterRequest) GetCluster() *Cluster {
	if x != nil {
		return x.Cluster
	}
	return nil
}

func (x *UpdateClusterRequest) GetGracefulDecommissionTimeout() *durationpb.Duration {
	if x != nil {
		return x.GracefulDecommissionTimeout
	}
	return nil
}

func (x *UpdateClusterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to stop a cluster.
type StopClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Google Cloud Platform project the
	// cluster belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,2,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,3,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Optional. Specifying the `cluster_uuid` means the RPC will fail
	// (with error NOT_FOUND) if a cluster with the specified UUID does not exist.
	ClusterUuid string `protobuf:"bytes,4,opt,name=cluster_uuid,json=clusterUuid,proto3" json:"cluster_uuid,omitempty"`
	// Optional. A unique ID used to identify the request. If the server
	// receives two
	// [StopClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.StopClusterRequest)s
	// with the same id, then the second request will be ignored and the
	// first [google.longrunning.Operation][google.longrunning.Operation] created
	// and stored in the backend is returned.
	//
	// Recommendation: Set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *StopClusterRequest) Reset() {
	*x = StopClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopClusterRequest) ProtoMessage() {}

func (x *StopClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopClusterRequest.ProtoReflect.Descriptor instead.
func (*StopClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{32}
}

func (x *StopClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *StopClusterRequest) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *StopClusterRequest) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *StopClusterRequest) GetClusterUuid() string {
	if x != nil {
		return x.ClusterUuid
	}
	return ""
}

func (x *StopClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to start a cluster.
type StartClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Google Cloud Platform project the
	// cluster belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,2,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,3,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Optional. Specifying the `cluster_uuid` means the RPC will fail
	// (with error NOT_FOUND) if a cluster with the specified UUID does not exist.
	ClusterUuid string `protobuf:"bytes,4,opt,name=cluster_uuid,json=clusterUuid,proto3" json:"cluster_uuid,omitempty"`
	// Optional. A unique ID used to identify the request. If the server
	// receives two
	// [StartClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.StartClusterRequest)s
	// with the same id, then the second request will be ignored and the
	// first [google.longrunning.Operation][google.longrunning.Operation] created
	// and stored in the backend is returned.
	//
	// Recommendation: Set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *StartClusterRequest) Reset() {
	*x = StartClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartClusterRequest) ProtoMessage() {}

func (x *StartClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartClusterRequest.ProtoReflect.Descriptor instead.
func (*StartClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{33}
}

func (x *StartClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *StartClusterRequest) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *StartClusterRequest) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *StartClusterRequest) GetClusterUuid() string {
	if x != nil {
		return x.ClusterUuid
	}
	return ""
}

func (x *StartClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to delete a cluster.
type DeleteClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Optional. Specifying the `cluster_uuid` means the RPC should fail
	// (with error NOT_FOUND) if cluster with specified UUID does not exist.
	ClusterUuid string `protobuf:"bytes,4,opt,name=cluster_uuid,json=clusterUuid,proto3" json:"cluster_uuid,omitempty"`
	// Optional. A unique ID used to identify the request. If the server
	// receives two
	// [DeleteClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.DeleteClusterRequest)s
	// with the same id, then the second request will be ignored and the
	// first [google.longrunning.Operation][google.longrunning.Operation] created
	// and stored in the backend is returned.
	//
	// It is recommended to always set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteClusterRequest) Reset() {
	*x = DeleteClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteClusterRequest) ProtoMessage() {}

func (x *DeleteClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{34}
}

func (x *DeleteClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *DeleteClusterRequest) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *DeleteClusterRequest) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *DeleteClusterRequest) GetClusterUuid() string {
	if x != nil {
		return x.ClusterUuid
	}
	return ""
}

func (x *DeleteClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request to get the resource representation for a cluster in a project.
type GetClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
}

func (x *GetClusterRequest) Reset() {
	*x = GetClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterRequest) ProtoMessage() {}

func (x *GetClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClusterRequest.ProtoReflect.Descriptor instead.
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{35}
}

func (x *GetClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetClusterRequest) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *GetClusterRequest) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

// A request to list the clusters in a project.
type ListClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,4,opt,name=region,proto3" json:"region,omitempty"`
	// Optional. A filter constraining the clusters to list. Filters are
	// case-sensitive and have the following syntax:
	//
	// field = value [AND [field = value]] ...
	//
	// where **field** is one of `status.state`, `clusterName`, or `labels.[KEY]`,
	// and `[KEY]` is a label key. **value** can be `*` to match all values.
	// `status.state` can be one of the following: `ACTIVE`, `INACTIVE`,
	// `CREATING`, `RUNNING`, `ERROR`, `DELETING`, or `UPDATING`. `ACTIVE`
	// contains the `CREATING`, `UPDATING`, and `RUNNING` states. `INACTIVE`
	// contains the `DELETING` and `ERROR` states.
	// `clusterName` is the name of the cluster provided at creation time.
	// Only the logical `AND` operator is supported; space-separated items are
	// treated as having an implicit `AND` operator.
	//
	// Example filter:
	//
	// status.state = ACTIVE AND clusterName = mycluster
	// AND labels.env = staging AND labels.starred = *
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The standard List page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The standard List page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListClustersRequest) Reset() {
	*x = ListClustersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClustersRequest) ProtoMessage() {}

func (x *ListClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClustersRequest.ProtoReflect.Descriptor instead.
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{36}
}

func (x *ListClustersRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListClustersRequest) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *ListClustersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListClustersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListClustersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The list of all clusters in a project.
type ListClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The clusters in the project.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// Output only. This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// `page_token` in a subsequent `ListClustersRequest`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListClustersResponse) Reset() {
	*x = ListClustersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClustersResponse) ProtoMessage() {}

func (x *ListClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClustersResponse.ProtoReflect.Descriptor instead.
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{37}
}

func (x *ListClustersResponse) GetClusters() []*Cluster {
	if x != nil {
		return x.Clusters
	}
	return nil
}

func (x *ListClustersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request to collect cluster diagnostic information.
type DiagnoseClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Optional. The output Cloud Storage directory for the diagnostic
	// tarball. If not specified, a task-specific directory in the cluster's
	// staging bucket will be used.
	TarballGcsDir string `protobuf:"bytes,4,opt,name=tarball_gcs_dir,json=tarballGcsDir,proto3" json:"tarball_gcs_dir,omitempty"`
	// Optional. Time interval in which diagnosis should be carried out on the
	// cluster.
	DiagnosisInterval *interval.Interval `protobuf:"bytes,6,opt,name=diagnosis_interval,json=diagnosisInterval,proto3" json:"diagnosis_interval,omitempty"`
	// Optional. Specifies a list of jobs on which diagnosis is to be performed.
	// Format: projects/{project}/regions/{region}/jobs/{job}
	Jobs []string `protobuf:"bytes,10,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// Optional. Specifies a list of yarn applications on which diagnosis is to be
	// performed.
	YarnApplicationIds []string `protobuf:"bytes,11,rep,name=yarn_application_ids,json=yarnApplicationIds,proto3" json:"yarn_application_ids,omitempty"`
}

func (x *DiagnoseClusterRequest) Reset() {
	*x = DiagnoseClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiagnoseClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiagnoseClusterRequest) ProtoMessage() {}

func (x *DiagnoseClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiagnoseClusterRequest.ProtoReflect.Descriptor instead.
func (*DiagnoseClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{38}
}

func (x *DiagnoseClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *DiagnoseClusterRequest) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *DiagnoseClusterRequest) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *DiagnoseClusterRequest) GetTarballGcsDir() string {
	if x != nil {
		return x.TarballGcsDir
	}
	return ""
}

func (x *DiagnoseClusterRequest) GetDiagnosisInterval() *interval.Interval {
	if x != nil {
		return x.DiagnosisInterval
	}
	return nil
}

func (x *DiagnoseClusterRequest) GetJobs() []string {
	if x != nil {
		return x.Jobs
	}
	return nil
}

func (x *DiagnoseClusterRequest) GetYarnApplicationIds() []string {
	if x != nil {
		return x.YarnApplicationIds
	}
	return nil
}

// The location of diagnostic output.
type DiagnoseClusterResults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The Cloud Storage URI of the diagnostic output.
	// The output report is a plain text file with a summary of collected
	// diagnostics.
	OutputUri string `protobuf:"bytes,1,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
}

func (x *DiagnoseClusterResults) Reset() {
	*x = DiagnoseClusterResults{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiagnoseClusterResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiagnoseClusterResults) ProtoMessage() {}

func (x *DiagnoseClusterResults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiagnoseClusterResults.ProtoReflect.Descriptor instead.
func (*DiagnoseClusterResults) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{39}
}

func (x *DiagnoseClusterResults) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

// Reservation Affinity for consuming Zonal reservation.
type ReservationAffinity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Type of reservation to consume
	ConsumeReservationType ReservationAffinity_Type `protobuf:"varint,1,opt,name=consume_reservation_type,json=consumeReservationType,proto3,enum=google.cloud.dataproc.v1.ReservationAffinity_Type" json:"consume_reservation_type,omitempty"`
	// Optional. Corresponds to the label key of reservation resource.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// Optional. Corresponds to the label values of reservation resource.
	Values []string `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *ReservationAffinity) Reset() {
	*x = ReservationAffinity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReservationAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReservationAffinity) ProtoMessage() {}

func (x *ReservationAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReservationAffinity.ProtoReflect.Descriptor instead.
func (*ReservationAffinity) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{40}
}

func (x *ReservationAffinity) GetConsumeReservationType() ReservationAffinity_Type {
	if x != nil {
		return x.ConsumeReservationType
	}
	return ReservationAffinity_TYPE_UNSPECIFIED
}

func (x *ReservationAffinity) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *ReservationAffinity) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// Defines machines types and a rank to which the machines types belong.
type InstanceFlexibilityPolicy_InstanceSelection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Full machine-type names, e.g. "n1-standard-16".
	MachineTypes []string `protobuf:"bytes,1,rep,name=machine_types,json=machineTypes,proto3" json:"machine_types,omitempty"`
	// Optional. Preference of this instance selection. Lower number means
	// higher preference. Dataproc will first try to create a VM based on the
	// machine-type with priority rank and fallback to next rank based on
	// availability. Machine types and instance selections with the same
	// priority have the same preference.
	Rank int32 `protobuf:"varint,2,opt,name=rank,proto3" json:"rank,omitempty"`
}

func (x *InstanceFlexibilityPolicy_InstanceSelection) Reset() {
	*x = InstanceFlexibilityPolicy_InstanceSelection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceFlexibilityPolicy_InstanceSelection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceFlexibilityPolicy_InstanceSelection) ProtoMessage() {}

func (x *InstanceFlexibilityPolicy_InstanceSelection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceFlexibilityPolicy_InstanceSelection.ProtoReflect.Descriptor instead.
func (*InstanceFlexibilityPolicy_InstanceSelection) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{15, 0}
}

func (x *InstanceFlexibilityPolicy_InstanceSelection) GetMachineTypes() []string {
	if x != nil {
		return x.MachineTypes
	}
	return nil
}

func (x *InstanceFlexibilityPolicy_InstanceSelection) GetRank() int32 {
	if x != nil {
		return x.Rank
	}
	return 0
}

// Defines a mapping from machine types to the number of VMs that are created
// with each machine type.
type InstanceFlexibilityPolicy_InstanceSelectionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Full machine-type names, e.g. "n1-standard-16".
	MachineType *string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3,oneof" json:"machine_type,omitempty"`
	// Output only. Number of VM provisioned with the machine_type.
	VmCount *int32 `protobuf:"varint,2,opt,name=vm_count,json=vmCount,proto3,oneof" json:"vm_count,omitempty"`
}

func (x *InstanceFlexibilityPolicy_InstanceSelectionResult) Reset() {
	*x = InstanceFlexibilityPolicy_InstanceSelectionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceFlexibilityPolicy_InstanceSelectionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceFlexibilityPolicy_InstanceSelectionResult) ProtoMessage() {}

func (x *InstanceFlexibilityPolicy_InstanceSelectionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceFlexibilityPolicy_InstanceSelectionResult.ProtoReflect.Descriptor instead.
func (*InstanceFlexibilityPolicy_InstanceSelectionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{15, 1}
}

func (x *InstanceFlexibilityPolicy_InstanceSelectionResult) GetMachineType() string {
	if x != nil && x.MachineType != nil {
		return *x.MachineType
	}
	return ""
}

func (x *InstanceFlexibilityPolicy_InstanceSelectionResult) GetVmCount() int32 {
	if x != nil && x.VmCount != nil {
		return *x.VmCount
	}
	return 0
}

// A Dataproc custom metric.
type DataprocMetricConfig_Metric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A standard set of metrics is collected unless `metricOverrides`
	// are specified for the metric source (see [Custom metrics]
	// (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
	// for more information).
	MetricSource DataprocMetricConfig_MetricSource `protobuf:"varint,1,opt,name=metric_source,json=metricSource,proto3,enum=google.cloud.dataproc.v1.DataprocMetricConfig_MetricSource" json:"metric_source,omitempty"`
	// Optional. Specify one or more [Custom metrics]
	// (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
	// to collect for the metric course (for the `SPARK` metric source (any
	// [Spark metric]
	// (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
	// specified).
	//
	// Provide metrics in the following format:
	// <code><var>METRIC_SOURCE</var>:<var>INSTANCE</var>:<var>GROUP</var>:<var>METRIC</var></code>
	// Use camelcase as appropriate.
	//
	// Examples:
	//
	// ```
	// yarn:ResourceManager:QueueMetrics:AppsCompleted
	// spark:driver:DAGScheduler:job.allJobs
	// sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
	// hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
	// ```
	//
	// Notes:
	//
	//   - Only the specified overridden metrics are collected for the
	//     metric source. For example, if one or more `spark:executive` metrics
	//     are listed as metric overrides, other `SPARK` metrics are not
	//     collected. The collection of the metrics for other enabled custom
	//     metric sources is unaffected. For example, if both `SPARK` andd `YARN`
	//     metric sources are enabled, and overrides are provided for Spark
	//     metrics only, all YARN metrics are collected.
	MetricOverrides []string `protobuf:"bytes,2,rep,name=metric_overrides,json=metricOverrides,proto3" json:"metric_overrides,omitempty"`
}

func (x *DataprocMetricConfig_Metric) Reset() {
	*x = DataprocMetricConfig_Metric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataprocMetricConfig_Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataprocMetricConfig_Metric) ProtoMessage() {}

func (x *DataprocMetricConfig_Metric) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_clusters_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataprocMetricConfig_Metric.ProtoReflect.Descriptor instead.
func (*DataprocMetricConfig_Metric) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP(), []int{29, 0}
}

func (x *DataprocMetricConfig_Metric) GetMetricSource() DataprocMetricConfig_MetricSource {
	if x != nil {
		return x.MetricSource
	}
	return DataprocMetricConfig_METRIC_SOURCE_UNSPECIFIED
}

func (x *DataprocMetricConfig_Metric) GetMetricOverrides() []string {
	if x != nil {
		return x.MetricOverrides
	}
	return nil
}

var File_google_cloud_dataproc_v1_clusters_proto protoreflect.FileDescriptor

var file_google_cloud_dataproc_v1_clusters_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x31,
	0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77,
	0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x99, 0x05, 0x0a, 0x07, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x44, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x69, 0x0a, 0x16, 0x76, 0x69, 0x72, 0x74, 0x75,
	0x61, 0x6c, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x76, 0x69,
	0x72, 0x74, 0x75, 0x61, 0x6c, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x4a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x44,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x53, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x68,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x55, 0x75, 0x69,
	0x64, 0x12, 0x47, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x9b, 0x0b, 0x0a, 0x0d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x12, 0x24, 0x0a, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x74, 0x65, 0x6d,
	0x70, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x5d, 0x0a, 0x12, 0x67, 0x63, 0x65, 0x5f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x63, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x67, 0x63, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x0d, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x57, 0x0a, 0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6a, 0x0a, 0x17, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x73,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x0f, 0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x6f,
	0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6e, 0x0a, 0x16,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5c, 0x0a, 0x11,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a, 0x12, 0x61, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x0f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x59, 0x0a, 0x10, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63,
	0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6c,
	0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56,
	0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x59, 0x0a, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x69, 0x0a, 0x16, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x17, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a, 0x15,
	0x61, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x19, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79,
	0x4e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13,
	0x61, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x4e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x22, 0xc5, 0x02, 0x0a, 0x14, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a, 0x0e,
	0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x67, 0x69,
	0x6e, 0x67, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x74, 0x0a, 0x19, 0x6b, 0x75, 0x62, 0x65,
	0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65,
	0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x17, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65,
	0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x72,
	0x0a, 0x19, 0x61, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x78,
	0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x61, 0x75, 0x78, 0x69, 0x6c,
	0x69, 0x61, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x17, 0x0a, 0x15, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xec, 0x01, 0x0a, 0x17,
	0x41, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x59, 0x0a, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x76, 0x0a, 0x1b, 0x73, 0x70, 0x61, 0x72, 0x6b, 0x5f, 0x68, 0x69, 0x73, 0x74,
	0x6f, 0x72, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x72, 0x6b, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x18, 0x73, 0x70, 0x61, 0x72, 0x6b, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xe7, 0x01, 0x0a, 0x0e, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5b, 0x0a,
	0x0a, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x48, 0x74, 0x74, 0x70,
	0x50, 0x6f, 0x72, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x09, 0x68, 0x74, 0x74, 0x70, 0x50, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x3a, 0x0a, 0x17, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x74, 0x74, 0x70, 0x50, 0x6f, 0x72, 0x74,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x1a, 0x3c, 0x0a, 0x0e, 0x48, 0x74, 0x74, 0x70, 0x50, 0x6f,
	0x72, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x37, 0x0a, 0x11, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x55, 0x72, 0x69, 0x22, 0x45, 0x0a,
	0x10, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x31, 0x0a, 0x13, 0x67, 0x63, 0x65, 0x5f, 0x70, 0x64, 0x5f, 0x6b, 0x6d, 0x73, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0f, 0x67, 0x63, 0x65, 0x50, 0x64, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x22, 0xa6, 0x09, 0x0a, 0x10, 0x47, 0x63, 0x65, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1e, 0x0a, 0x08, 0x7a, 0x6f, 0x6e,
	0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x7a, 0x6f, 0x6e, 0x65, 0x55, 0x72, 0x69, 0x12, 0x24, 0x0a, 0x0b, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12,
	0x2a, 0x0a, 0x0e, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x32, 0x0a, 0x10, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x4f, 0x6e, 0x6c, 0x79, 0x88, 0x01, 0x01, 0x12,
	0x84, 0x01, 0x0a, 0x1a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x70, 0x76, 0x36,
	0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x63, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x49, 0x70, 0x76, 0x36, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x49, 0x70, 0x76, 0x36, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x61, 0x67, 0x73, 0x12, 0x59, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x63, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x65,
	0x0a, 0x14, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x66,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x13, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x79, 0x12, 0x60, 0x0a, 0x13, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f,
	0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41,
	0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x12, 0x6f, 0x0a, 0x18, 0x73, 0x68, 0x69, 0x65, 0x6c,
	0x64, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x16, 0x73, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7b, 0x0a, 0x1c, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x83, 0x01, 0x0a, 0x17, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x49, 0x70,
	0x76, 0x36, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x2a,
	0x0a, 0x26, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x49, 0x50, 0x56, 0x36, 0x5f, 0x47,
	0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x49, 0x4e,
	0x48, 0x45, 0x52, 0x49, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45,
	0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x55, 0x54, 0x42, 0x4f,
	0x55, 0x4e, 0x44, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x42, 0x49, 0x44, 0x49, 0x52, 0x45, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x03, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x22, 0x3e, 0x0a,
	0x11, 0x4e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x79, 0x12, 0x29, 0x0a, 0x0e, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x55, 0x72, 0x69, 0x22, 0x8c, 0x02,
	0x0a, 0x16, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x12, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6f, 0x6f, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x6f, 0x6f, 0x74, 0x88, 0x01, 0x01,
	0x12, 0x29, 0x0a, 0x0b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x74, 0x70, 0x6d, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0a, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x56, 0x74, 0x70, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x48, 0x0a, 0x1b, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49,
	0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x88, 0x01, 0x01, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6f, 0x6f, 0x74, 0x42, 0x0e, 0x0a, 0x0c,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x74, 0x70, 0x6d, 0x42, 0x1e, 0x0a, 0x1c,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74,
	0x79, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x22, 0x61, 0x0a, 0x1a,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x43, 0x0a, 0x1b, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x22,
	0xce, 0x08, 0x0a, 0x13, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x6e, 0x75, 0x6d, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6e, 0x75, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x2a, 0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x61, 0x0a,
	0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72,
	0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x12, 0x20, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x55,
	0x72, 0x69, 0x12, 0x2d, 0x0a, 0x10, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x55, 0x72,
	0x69, 0x12, 0x4a, 0x0a, 0x0b, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a,
	0x0e, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x69, 0x73, 0x50, 0x72,
	0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x12, 0x69, 0x0a, 0x0e, 0x70, 0x72, 0x65,
	0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x50, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x12, 0x63, 0x0a, 0x14, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x0c, 0x61, 0x63, 0x63,
	0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12,
	0x2d, 0x0a, 0x10, 0x6d, 0x69, 0x6e, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x6d, 0x69, 0x6e, 0x43, 0x70, 0x75, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x2f,
	0x0a, 0x11, 0x6d, 0x69, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f,
	0x6d, 0x69, 0x6e, 0x4e, 0x75, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12,
	0x78, 0x0a, 0x1b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x66, 0x6c, 0x65, 0x78,
	0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x46, 0x6c, 0x65, 0x78, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x46, 0x6c, 0x65, 0x78, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x53, 0x0a, 0x0e, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0d, 0x73, 0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x60,
	0x0a, 0x0e, 0x50, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x52, 0x45, 0x45, 0x4d, 0x50, 0x54, 0x49, 0x42, 0x49, 0x4c, 0x49,
	0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x13, 0x0a, 0x0f, 0x4e, 0x4f, 0x4e, 0x5f, 0x50, 0x52, 0x45, 0x45, 0x4d, 0x50, 0x54, 0x49,
	0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52, 0x45, 0x45, 0x4d, 0x50, 0x54,
	0x49, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x50, 0x4f, 0x54, 0x10, 0x03,
	0x22, 0x82, 0x01, 0x0a, 0x0d, 0x53, 0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x4e, 0x0a, 0x1e, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x1c, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88,
	0x01, 0x01, 0x42, 0x21, 0x0a, 0x1f, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa2, 0x01, 0x0a, 0x11, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79,
	0x12, 0x28, 0x0a, 0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x65, 0x63, 0x69, 0x65, 0x73,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x45, 0x63, 0x69, 0x65, 0x73, 0x4b, 0x65, 0x79, 0x22, 0xd5, 0x01, 0x0a, 0x12, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x39, 0x0a, 0x16, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x1b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x1a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x55,
	0x72, 0x69, 0x22, 0x95, 0x04, 0x0a, 0x19, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x46,
	0x6c, 0x65, 0x78, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x82, 0x01, 0x0a, 0x17, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x46, 0x6c, 0x65, 0x78, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x8e, 0x01, 0x0a, 0x1a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72,
	0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x46, 0x6c,
	0x65, 0x78, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x1a, 0x56, 0x0a, 0x11, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x6d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x72, 0x61, 0x6e, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x72, 0x61, 0x6e, 0x6b, 0x1a, 0x89,
	0x01, 0x0a, 0x17, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2b, 0x0a, 0x0c, 0x6d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x23, 0x0a, 0x08, 0x76, 0x6d, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01,
	0x52, 0x07, 0x76, 0x6d, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x42, 0x0f, 0x0a, 0x0d,
	0x5f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0b, 0x0a,
	0x09, 0x5f, 0x76, 0x6d, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x72, 0x0a, 0x11, 0x41, 0x63,
	0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x30, 0x0a, 0x14, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61,
	0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x55, 0x72,
	0x69, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x61, 0x63,
	0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xc7,
	0x01, 0x0a, 0x0a, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x0a,
	0x0e, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x62, 0x6f, 0x6f, 0x74,
	0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2e, 0x0a, 0x11, 0x62, 0x6f, 0x6f, 0x74,
	0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x6f, 0x6f, 0x74, 0x44, 0x69,
	0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x29, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x5f,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x73, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6e, 0x75, 0x6d, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x53,
	0x73, 0x64, 0x73, 0x12, 0x33, 0x0a, 0x13, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x73, 0x64,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x53, 0x73, 0x64, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x22, 0x86, 0x01, 0x0a, 0x12, 0x41, 0x75, 0x78,
	0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x4e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x47, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6e,
	0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x27, 0x0a, 0x0d, 0x6e, 0x6f, 0x64, 0x65,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49,
	0x64, 0x22, 0xef, 0x03, 0x0a, 0x09, 0x4e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f,
	0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x5e, 0x0a, 0x11, 0x6e, 0x6f, 0x64, 0x65,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x28, 0x0a, 0x04, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x4f, 0x4c,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x44, 0x52, 0x49, 0x56, 0x45, 0x52, 0x10, 0x01, 0x3a, 0x76, 0xea, 0x41, 0x73,
	0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x64, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x4e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x7d, 0x22, 0x95, 0x01, 0x0a, 0x18, 0x4e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66,
	0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x4b,
	0x0a, 0x11, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0xff, 0x03, 0x0a, 0x0d,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x48, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x49, 0x0a, 0x10, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x51, 0x0a, 0x08, 0x73, 0x75, 0x62, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x75,
	0x62, 0x73, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0xa7, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55,
	0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x44, 0x55, 0x45, 0x5f,
	0x54, 0x4f, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x09, 0x12, 0x0c, 0x0a, 0x08, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50,
	0x49, 0x4e, 0x47, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44,
	0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x08,
	0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x50, 0x41, 0x49, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x0a, 0x22,
	0x3c, 0x0a, 0x08, 0x53, 0x75, 0x62, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x55, 0x4e, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x59, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x53,
	0x54, 0x41, 0x4c, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x10, 0x02, 0x22, 0xc0, 0x01,
	0x0a, 0x0e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x56, 0x0a, 0x0f, 0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6b, 0x65, 0x72, 0x62, 0x65, 0x72,
	0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x0f, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xab, 0x06, 0x0a, 0x0e, 0x4b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6b, 0x65,
	0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f,
	0x73, 0x12, 0x42, 0x0a, 0x1b, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x72, 0x6f, 0x6f,
	0x74, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x55, 0x72, 0x69, 0x12, 0x23, 0x0a, 0x0b, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x55, 0x72, 0x69, 0x12, 0x26, 0x0a, 0x0c, 0x6b, 0x65,
	0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6b, 0x65, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x55,
	0x72, 0x69, 0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0d, 0x74, 0x72, 0x75, 0x73, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x55, 0x72, 0x69, 0x12, 0x37,
	0x0a, 0x15, 0x6b, 0x65, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x13, 0x6b, 0x65, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x73, 0x73,
	0x77, 0x6f, 0x72, 0x64, 0x55, 0x72, 0x69, 0x12, 0x2d, 0x0a, 0x10, 0x6b, 0x65, 0x79, 0x5f, 0x70,
	0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6b, 0x65, 0x79, 0x50, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x55, 0x72, 0x69, 0x12, 0x3b, 0x0a, 0x17, 0x74, 0x72, 0x75, 0x73, 0x74, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x74, 0x72,
	0x75, 0x73, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x55, 0x72, 0x69, 0x12, 0x3a, 0x0a, 0x17, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x61,
	0x6c, 0x6d, 0x5f, 0x74, 0x72, 0x75, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x61, 0x6c, 0x6d, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x63, 0x72, 0x6f, 0x73, 0x73,
	0x52, 0x65, 0x61, 0x6c, 0x6d, 0x54, 0x72, 0x75, 0x73, 0x74, 0x52, 0x65, 0x61, 0x6c, 0x6d, 0x12,
	0x36, 0x0a, 0x15, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x61, 0x6c, 0x6d, 0x5f, 0x74,
	0x72, 0x75, 0x73, 0x74, 0x5f, 0x6b, 0x64, 0x63, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x12, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x52, 0x65, 0x61, 0x6c, 0x6d, 0x54,
	0x72, 0x75, 0x73, 0x74, 0x4b, 0x64, 0x63, 0x12, 0x47, 0x0a, 0x1e, 0x63, 0x72, 0x6f, 0x73, 0x73,
	0x5f, 0x72, 0x65, 0x61, 0x6c, 0x6d, 0x5f, 0x74, 0x72, 0x75, 0x73, 0x74, 0x5f, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x52, 0x65, 0x61, 0x6c, 0x6d,
	0x54, 0x72, 0x75, 0x73, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x12, 0x54, 0x0a, 0x25, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x61, 0x6c, 0x6d, 0x5f,
	0x74, 0x72, 0x75, 0x73, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x20, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x52, 0x65, 0x61, 0x6c, 0x6d,
	0x54, 0x72, 0x75, 0x73, 0x74, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x50, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x55, 0x72, 0x69, 0x12, 0x28, 0x0a, 0x0e, 0x6b, 0x64, 0x63, 0x5f, 0x64, 0x62,
	0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6b, 0x64, 0x63, 0x44, 0x62, 0x4b, 0x65, 0x79, 0x55, 0x72, 0x69,
	0x12, 0x31, 0x0a, 0x12, 0x74, 0x67, 0x74, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x10, 0x74, 0x67, 0x74, 0x4c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x48, 0x6f,
	0x75, 0x72, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x72, 0x65, 0x61, 0x6c, 0x6d, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x72, 0x65, 0x61, 0x6c, 0x6d, 0x22, 0xee,
	0x01, 0x0a, 0x0e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x8d, 0x01, 0x0a, 0x1c, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x19, 0x75, 0x73, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x1a, 0x4c, 0x0a, 0x1e, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0xb3, 0x02, 0x0a, 0x0e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x66, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x13, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x12, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xc0, 0x02, 0x0a, 0x0f, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79,
	0x63, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x46, 0x0a, 0x0f, 0x69, 0x64, 0x6c,
	0x65, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x74, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0d, 0x69, 0x64, 0x6c, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x74,
	0x6c, 0x12, 0x4b, 0x0a, 0x10, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e,
	0x61, 0x75, 0x74, 0x6f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48,
	0x0a, 0x0f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x74,
	0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x75, 0x74, 0x6f, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x74, 0x6c, 0x12, 0x47, 0x0a, 0x0f, 0x69, 0x64, 0x6c, 0x65,
	0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x69, 0x64, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x42, 0x05, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x22, 0x79, 0x0a, 0x0f, 0x4d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x66, 0x0a, 0x1a, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x18, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x72, 0x6f, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x22, 0xcc, 0x02, 0x0a, 0x0e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x5c, 0x0a, 0x0c, 0x68, 0x64, 0x66, 0x73, 0x5f, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x48, 0x64, 0x66, 0x73, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x68, 0x64, 0x66, 0x73, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x5c, 0x0a, 0x0c, 0x79, 0x61, 0x72, 0x6e, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72,
	0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x2e, 0x59, 0x61, 0x72, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x79, 0x61, 0x72, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x1a, 0x3e, 0x0a, 0x10, 0x48, 0x64, 0x66, 0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x59, 0x61, 0x72, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xba, 0x03, 0x0a, 0x14, 0x44, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x07, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x1a, 0x9f, 0x01, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x65, 0x0a, 0x0d,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x2e, 0x0a, 0x10, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69,
	0x64, 0x65, 0x73, 0x22, 0xa9, 0x01, 0x0a, 0x0c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x49, 0x4e,
	0x47, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x53,
	0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x44, 0x46, 0x53, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05,
	0x53, 0x50, 0x41, 0x52, 0x4b, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x59, 0x41, 0x52, 0x4e, 0x10,
	0x04, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x50, 0x41, 0x52, 0x4b, 0x5f, 0x48, 0x49, 0x53, 0x54, 0x4f,
	0x52, 0x59, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x48,
	0x49, 0x56, 0x45, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x32, 0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d,
	0x48, 0x49, 0x56, 0x45, 0x4d, 0x45, 0x54, 0x41, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x10, 0x07, 0x22,
	0xb3, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x06,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x07, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72,
	0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12,
	0x74, 0x0a, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x69,
	0x6c, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1c, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x6e, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x57, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x73, 0x22, 0x8b, 0x03, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x49, 0x64, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12,
	0x26, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x62, 0x0a, 0x1d, 0x67, 0x72, 0x61,
	0x63, 0x65, 0x66, 0x75, 0x6c, 0x5f, 0x64, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x1b, 0x67, 0x72, 0x61, 0x63, 0x65, 0x66, 0x75, 0x6c, 0x44, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xc9, 0x01, 0x0a, 0x12, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1b,
	0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x75,
	0x75, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x55, 0x75, 0x69, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0xca, 0x01, 0x0a, 0x13, 0x53, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x06, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x75, 0x75, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x55, 0x75, 0x69, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xcb, 0x01, 0x0a,
	0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26,
	0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x55, 0x75, 0x69, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x7c, 0x0a, 0x11, 0x47, 0x65,
	0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xb9, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x87, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a,
	0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc9,
	0x02, 0x0a, 0x16, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a,
	0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x62, 0x61, 0x6c, 0x6c, 0x5f, 0x67, 0x63,
	0x73, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x74, 0x61, 0x72, 0x62, 0x61, 0x6c, 0x6c, 0x47, 0x63, 0x73, 0x44, 0x69, 0x72, 0x12,
	0x49, 0x0a, 0x12, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x69, 0x73, 0x5f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73,
	0x69, 0x73, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x6a, 0x6f,
	0x62, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6a,
	0x6f, 0x62, 0x73, 0x12, 0x35, 0x0a, 0x14, 0x79, 0x61, 0x72, 0x6e, 0x5f, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x79, 0x61, 0x72, 0x6e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x22, 0x3c, 0x0a, 0x16, 0x44, 0x69,
	0x61, 0x67, 0x6e, 0x6f, 0x73, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x22, 0x9d, 0x02, 0x0a, 0x13, 0x52, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79,
	0x12, 0x71, 0x0a, 0x18, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1b, 0x0a, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x5f, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x5f, 0x52, 0x45, 0x53, 0x45,
	0x52, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x4e, 0x59,
	0x5f, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x18,
	0x0a, 0x14, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x52,
	0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x32, 0xe4, 0x10, 0x0a, 0x11, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x12, 0x80,
	0x02, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x9f, 0x01, 0xca, 0x41, 0x3c, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x31,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x19, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3e, 0x3a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x33, 0x2f, 0x76,
	0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x12, 0xa8, 0x02, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xc7, 0x01, 0xca, 0x41, 0x3c, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x32, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x2c, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a,
	0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x32, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x12, 0xee, 0x01, 0x0a,
	0x0b, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x91, 0x01, 0xca, 0x41, 0x3c, 0x0a,
	0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4c, 0x3a, 0x01, 0x2a, 0x22, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x3a, 0x73, 0x74, 0x6f, 0x70, 0x12, 0xf1, 0x01,
	0x0a, 0x0c, 0x53, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x92, 0x01, 0xca,
	0x41, 0x3c, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x31, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72,
	0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x01, 0x2a, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x3a, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x12, 0x99, 0x02, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xb8, 0x01, 0xca, 0x41, 0x4a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x1e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x2a, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x12, 0xc9, 0x01,
	0x0a, 0x0a, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x6b, 0xda, 0x41,
	0x1e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x12, 0xd9, 0x01, 0x0a, 0x0c, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72,
	0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6a, 0xda, 0x41, 0x11, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0xda,
	0x41, 0x18, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35,
	0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0xaa, 0x02, 0x0a, 0x0f, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f,
	0x73, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc5, 0x01, 0xca, 0x41, 0x4b,
	0x0a, 0x16, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1e, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x2c,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x50, 0x3a, 0x01, 0x2a, 0x22, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x3a, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f,
	0x73, 0x65, 0x1a, 0x4b, 0xca, 0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0x6c, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x42,
	0x0d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76,
	0x32, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x70, 0x62, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataproc_v1_clusters_proto_rawDescOnce sync.Once
	file_google_cloud_dataproc_v1_clusters_proto_rawDescData = file_google_cloud_dataproc_v1_clusters_proto_rawDesc
)

func file_google_cloud_dataproc_v1_clusters_proto_rawDescGZIP() []byte {
	file_google_cloud_dataproc_v1_clusters_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataproc_v1_clusters_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataproc_v1_clusters_proto_rawDescData)
	})
	return file_google_cloud_dataproc_v1_clusters_proto_rawDescData
}

var file_google_cloud_dataproc_v1_clusters_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_dataproc_v1_clusters_proto_msgTypes = make([]protoimpl.MessageInfo, 52)
var file_google_cloud_dataproc_v1_clusters_proto_goTypes = []interface{}{
	(GceClusterConfig_PrivateIpv6GoogleAccess)(0),             // 0: google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess
	(InstanceGroupConfig_Preemptibility)(0),                   // 1: google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility
	(NodeGroup_Role)(0),                                       // 2: google.cloud.dataproc.v1.NodeGroup.Role
	(ClusterStatus_State)(0),                                  // 3: google.cloud.dataproc.v1.ClusterStatus.State
	(ClusterStatus_Substate)(0),                               // 4: google.cloud.dataproc.v1.ClusterStatus.Substate
	(DataprocMetricConfig_MetricSource)(0),                    // 5: google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource
	(ReservationAffinity_Type)(0),                             // 6: google.cloud.dataproc.v1.ReservationAffinity.Type
	(*Cluster)(nil),                                           // 7: google.cloud.dataproc.v1.Cluster
	(*ClusterConfig)(nil),                                     // 8: google.cloud.dataproc.v1.ClusterConfig
	(*VirtualClusterConfig)(nil),                              // 9: google.cloud.dataproc.v1.VirtualClusterConfig
	(*AuxiliaryServicesConfig)(nil),                           // 10: google.cloud.dataproc.v1.AuxiliaryServicesConfig
	(*EndpointConfig)(nil),                                    // 11: google.cloud.dataproc.v1.EndpointConfig
	(*AutoscalingConfig)(nil),                                 // 12: google.cloud.dataproc.v1.AutoscalingConfig
	(*EncryptionConfig)(nil),                                  // 13: google.cloud.dataproc.v1.EncryptionConfig
	(*GceClusterConfig)(nil),                                  // 14: google.cloud.dataproc.v1.GceClusterConfig
	(*NodeGroupAffinity)(nil),                                 // 15: google.cloud.dataproc.v1.NodeGroupAffinity
	(*ShieldedInstanceConfig)(nil),                            // 16: google.cloud.dataproc.v1.ShieldedInstanceConfig
	(*ConfidentialInstanceConfig)(nil),                        // 17: google.cloud.dataproc.v1.ConfidentialInstanceConfig
	(*InstanceGroupConfig)(nil),                               // 18: google.cloud.dataproc.v1.InstanceGroupConfig
	(*StartupConfig)(nil),                                     // 19: google.cloud.dataproc.v1.StartupConfig
	(*InstanceReference)(nil),                                 // 20: google.cloud.dataproc.v1.InstanceReference
	(*ManagedGroupConfig)(nil),                                // 21: google.cloud.dataproc.v1.ManagedGroupConfig
	(*InstanceFlexibilityPolicy)(nil),                         // 22: google.cloud.dataproc.v1.InstanceFlexibilityPolicy
	(*AcceleratorConfig)(nil),                                 // 23: google.cloud.dataproc.v1.AcceleratorConfig
	(*DiskConfig)(nil),                                        // 24: google.cloud.dataproc.v1.DiskConfig
	(*AuxiliaryNodeGroup)(nil),                                // 25: google.cloud.dataproc.v1.AuxiliaryNodeGroup
	(*NodeGroup)(nil),                                         // 26: google.cloud.dataproc.v1.NodeGroup
	(*NodeInitializationAction)(nil),                          // 27: google.cloud.dataproc.v1.NodeInitializationAction
	(*ClusterStatus)(nil),                                     // 28: google.cloud.dataproc.v1.ClusterStatus
	(*SecurityConfig)(nil),                                    // 29: google.cloud.dataproc.v1.SecurityConfig
	(*KerberosConfig)(nil),                                    // 30: google.cloud.dataproc.v1.KerberosConfig
	(*IdentityConfig)(nil),                                    // 31: google.cloud.dataproc.v1.IdentityConfig
	(*SoftwareConfig)(nil),                                    // 32: google.cloud.dataproc.v1.SoftwareConfig
	(*LifecycleConfig)(nil),                                   // 33: google.cloud.dataproc.v1.LifecycleConfig
	(*MetastoreConfig)(nil),                                   // 34: google.cloud.dataproc.v1.MetastoreConfig
	(*ClusterMetrics)(nil),                                    // 35: google.cloud.dataproc.v1.ClusterMetrics
	(*DataprocMetricConfig)(nil),                              // 36: google.cloud.dataproc.v1.DataprocMetricConfig
	(*CreateClusterRequest)(nil),                              // 37: google.cloud.dataproc.v1.CreateClusterRequest
	(*UpdateClusterRequest)(nil),                              // 38: google.cloud.dataproc.v1.UpdateClusterRequest
	(*StopClusterRequest)(nil),                                // 39: google.cloud.dataproc.v1.StopClusterRequest
	(*StartClusterRequest)(nil),                               // 40: google.cloud.dataproc.v1.StartClusterRequest
	(*DeleteClusterRequest)(nil),                              // 41: google.cloud.dataproc.v1.DeleteClusterRequest
	(*GetClusterRequest)(nil),                                 // 42: google.cloud.dataproc.v1.GetClusterRequest
	(*ListClustersRequest)(nil),                               // 43: google.cloud.dataproc.v1.ListClustersRequest
	(*ListClustersResponse)(nil),                              // 44: google.cloud.dataproc.v1.ListClustersResponse
	(*DiagnoseClusterRequest)(nil),                            // 45: google.cloud.dataproc.v1.DiagnoseClusterRequest
	(*DiagnoseClusterResults)(nil),                            // 46: google.cloud.dataproc.v1.DiagnoseClusterResults
	(*ReservationAffinity)(nil),                               // 47: google.cloud.dataproc.v1.ReservationAffinity
	nil,                                                       // 48: google.cloud.dataproc.v1.Cluster.LabelsEntry
	nil,                                                       // 49: google.cloud.dataproc.v1.EndpointConfig.HttpPortsEntry
	nil,                                                       // 50: google.cloud.dataproc.v1.GceClusterConfig.MetadataEntry
	(*InstanceFlexibilityPolicy_InstanceSelection)(nil),       // 51: google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
	(*InstanceFlexibilityPolicy_InstanceSelectionResult)(nil), // 52: google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
	nil,                                 // 53: google.cloud.dataproc.v1.NodeGroup.LabelsEntry
	nil,                                 // 54: google.cloud.dataproc.v1.IdentityConfig.UserServiceAccountMappingEntry
	nil,                                 // 55: google.cloud.dataproc.v1.SoftwareConfig.PropertiesEntry
	nil,                                 // 56: google.cloud.dataproc.v1.ClusterMetrics.HdfsMetricsEntry
	nil,                                 // 57: google.cloud.dataproc.v1.ClusterMetrics.YarnMetricsEntry
	(*DataprocMetricConfig_Metric)(nil), // 58: google.cloud.dataproc.v1.DataprocMetricConfig.Metric
	(*KubernetesClusterConfig)(nil),     // 59: google.cloud.dataproc.v1.KubernetesClusterConfig
	(*SparkHistoryServerConfig)(nil),    // 60: google.cloud.dataproc.v1.SparkHistoryServerConfig
	(*durationpb.Duration)(nil),         // 61: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),       // 62: google.protobuf.Timestamp
	(Component)(0),                      // 63: google.cloud.dataproc.v1.Component
	(FailureAction)(0),                  // 64: google.cloud.dataproc.v1.FailureAction
	(*fieldmaskpb.FieldMask)(nil),       // 65: google.protobuf.FieldMask
	(*interval.Interval)(nil),           // 66: google.type.Interval
	(*longrunningpb.Operation)(nil),     // 67: google.longrunning.Operation
}
var file_google_cloud_dataproc_v1_clusters_proto_depIdxs = []int32{
	8,  // 0: google.cloud.dataproc.v1.Cluster.config:type_name -> google.cloud.dataproc.v1.ClusterConfig
	9,  // 1: google.cloud.dataproc.v1.Cluster.virtual_cluster_config:type_name -> google.cloud.dataproc.v1.VirtualClusterConfig
	48, // 2: google.cloud.dataproc.v1.Cluster.labels:type_name -> google.cloud.dataproc.v1.Cluster.LabelsEntry
	28, // 3: google.cloud.dataproc.v1.Cluster.status:type_name -> google.cloud.dataproc.v1.ClusterStatus
	28, // 4: google.cloud.dataproc.v1.Cluster.status_history:type_name -> google.cloud.dataproc.v1.ClusterStatus
	35, // 5: google.cloud.dataproc.v1.Cluster.metrics:type_name -> google.cloud.dataproc.v1.ClusterMetrics
	14, // 6: google.cloud.dataproc.v1.ClusterConfig.gce_cluster_config:type_name -> google.cloud.dataproc.v1.GceClusterConfig
	18, // 7: google.cloud.dataproc.v1.ClusterConfig.master_config:type_name -> google.cloud.dataproc.v1.InstanceGroupConfig
	18, // 8: google.cloud.dataproc.v1.ClusterConfig.worker_config:type_name -> google.cloud.dataproc.v1.InstanceGroupConfig
	18, // 9: google.cloud.dataproc.v1.ClusterConfig.secondary_worker_config:type_name -> google.cloud.dataproc.v1.InstanceGroupConfig
	32, // 10: google.cloud.dataproc.v1.ClusterConfig.software_config:type_name -> google.cloud.dataproc.v1.SoftwareConfig
	27, // 11: google.cloud.dataproc.v1.ClusterConfig.initialization_actions:type_name -> google.cloud.dataproc.v1.NodeInitializationAction
	13, // 12: google.cloud.dataproc.v1.ClusterConfig.encryption_config:type_name -> google.cloud.dataproc.v1.EncryptionConfig
	12, // 13: google.cloud.dataproc.v1.ClusterConfig.autoscaling_config:type_name -> google.cloud.dataproc.v1.AutoscalingConfig
	29, // 14: google.cloud.dataproc.v1.ClusterConfig.security_config:type_name -> google.cloud.dataproc.v1.SecurityConfig
	33, // 15: google.cloud.dataproc.v1.ClusterConfig.lifecycle_config:type_name -> google.cloud.dataproc.v1.LifecycleConfig
	11, // 16: google.cloud.dataproc.v1.ClusterConfig.endpoint_config:type_name -> google.cloud.dataproc.v1.EndpointConfig
	34, // 17: google.cloud.dataproc.v1.ClusterConfig.metastore_config:type_name -> google.cloud.dataproc.v1.MetastoreConfig
	36, // 18: google.cloud.dataproc.v1.ClusterConfig.dataproc_metric_config:type_name -> google.cloud.dataproc.v1.DataprocMetricConfig
	25, // 19: google.cloud.dataproc.v1.ClusterConfig.auxiliary_node_groups:type_name -> google.cloud.dataproc.v1.AuxiliaryNodeGroup
	59, // 20: google.cloud.dataproc.v1.VirtualClusterConfig.kubernetes_cluster_config:type_name -> google.cloud.dataproc.v1.KubernetesClusterConfig
	10, // 21: google.cloud.dataproc.v1.VirtualClusterConfig.auxiliary_services_config:type_name -> google.cloud.dataproc.v1.AuxiliaryServicesConfig
	34, // 22: google.cloud.dataproc.v1.AuxiliaryServicesConfig.metastore_config:type_name -> google.cloud.dataproc.v1.MetastoreConfig
	60, // 23: google.cloud.dataproc.v1.AuxiliaryServicesConfig.spark_history_server_config:type_name -> google.cloud.dataproc.v1.SparkHistoryServerConfig
	49, // 24: google.cloud.dataproc.v1.EndpointConfig.http_ports:type_name -> google.cloud.dataproc.v1.EndpointConfig.HttpPortsEntry
	0,  // 25: google.cloud.dataproc.v1.GceClusterConfig.private_ipv6_google_access:type_name -> google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess
	50, // 26: google.cloud.dataproc.v1.GceClusterConfig.metadata:type_name -> google.cloud.dataproc.v1.GceClusterConfig.MetadataEntry
	47, // 27: google.cloud.dataproc.v1.GceClusterConfig.reservation_affinity:type_name -> google.cloud.dataproc.v1.ReservationAffinity
	15, // 28: google.cloud.dataproc.v1.GceClusterConfig.node_group_affinity:type_name -> google.cloud.dataproc.v1.NodeGroupAffinity
	16, // 29: google.cloud.dataproc.v1.GceClusterConfig.shielded_instance_config:type_name -> google.cloud.dataproc.v1.ShieldedInstanceConfig
	17, // 30: google.cloud.dataproc.v1.GceClusterConfig.confidential_instance_config:type_name -> google.cloud.dataproc.v1.ConfidentialInstanceConfig
	20, // 31: google.cloud.dataproc.v1.InstanceGroupConfig.instance_references:type_name -> google.cloud.dataproc.v1.InstanceReference
	24, // 32: google.cloud.dataproc.v1.InstanceGroupConfig.disk_config:type_name -> google.cloud.dataproc.v1.DiskConfig
	1,  // 33: google.cloud.dataproc.v1.InstanceGroupConfig.preemptibility:type_name -> google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility
	21, // 34: google.cloud.dataproc.v1.InstanceGroupConfig.managed_group_config:type_name -> google.cloud.dataproc.v1.ManagedGroupConfig
	23, // 35: google.cloud.dataproc.v1.InstanceGroupConfig.accelerators:type_name -> google.cloud.dataproc.v1.AcceleratorConfig
	22, // 36: google.cloud.dataproc.v1.InstanceGroupConfig.instance_flexibility_policy:type_name -> google.cloud.dataproc.v1.InstanceFlexibilityPolicy
	19, // 37: google.cloud.dataproc.v1.InstanceGroupConfig.startup_config:type_name -> google.cloud.dataproc.v1.StartupConfig
	51, // 38: google.cloud.dataproc.v1.InstanceFlexibilityPolicy.instance_selection_list:type_name -> google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
	52, // 39: google.cloud.dataproc.v1.InstanceFlexibilityPolicy.instance_selection_results:type_name -> google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
	26, // 40: google.cloud.dataproc.v1.AuxiliaryNodeGroup.node_group:type_name -> google.cloud.dataproc.v1.NodeGroup
	2,  // 41: google.cloud.dataproc.v1.NodeGroup.roles:type_name -> google.cloud.dataproc.v1.NodeGroup.Role
	18, // 42: google.cloud.dataproc.v1.NodeGroup.node_group_config:type_name -> google.cloud.dataproc.v1.InstanceGroupConfig
	53, // 43: google.cloud.dataproc.v1.NodeGroup.labels:type_name -> google.cloud.dataproc.v1.NodeGroup.LabelsEntry
	61, // 44: google.cloud.dataproc.v1.NodeInitializationAction.execution_timeout:type_name -> google.protobuf.Duration
	3,  // 45: google.cloud.dataproc.v1.ClusterStatus.state:type_name -> google.cloud.dataproc.v1.ClusterStatus.State
	62, // 46: google.cloud.dataproc.v1.ClusterStatus.state_start_time:type_name -> google.protobuf.Timestamp
	4,  // 47: google.cloud.dataproc.v1.ClusterStatus.substate:type_name -> google.cloud.dataproc.v1.ClusterStatus.Substate
	30, // 48: google.cloud.dataproc.v1.SecurityConfig.kerberos_config:type_name -> google.cloud.dataproc.v1.KerberosConfig
	31, // 49: google.cloud.dataproc.v1.SecurityConfig.identity_config:type_name -> google.cloud.dataproc.v1.IdentityConfig
	54, // 50: google.cloud.dataproc.v1.IdentityConfig.user_service_account_mapping:type_name -> google.cloud.dataproc.v1.IdentityConfig.UserServiceAccountMappingEntry
	55, // 51: google.cloud.dataproc.v1.SoftwareConfig.properties:type_name -> google.cloud.dataproc.v1.SoftwareConfig.PropertiesEntry
	63, // 52: google.cloud.dataproc.v1.SoftwareConfig.optional_components:type_name -> google.cloud.dataproc.v1.Component
	61, // 53: google.cloud.dataproc.v1.LifecycleConfig.idle_delete_ttl:type_name -> google.protobuf.Duration
	62, // 54: google.cloud.dataproc.v1.LifecycleConfig.auto_delete_time:type_name -> google.protobuf.Timestamp
	61, // 55: google.cloud.dataproc.v1.LifecycleConfig.auto_delete_ttl:type_name -> google.protobuf.Duration
	62, // 56: google.cloud.dataproc.v1.LifecycleConfig.idle_start_time:type_name -> google.protobuf.Timestamp
	56, // 57: google.cloud.dataproc.v1.ClusterMetrics.hdfs_metrics:type_name -> google.cloud.dataproc.v1.ClusterMetrics.HdfsMetricsEntry
	57, // 58: google.cloud.dataproc.v1.ClusterMetrics.yarn_metrics:type_name -> google.cloud.dataproc.v1.ClusterMetrics.YarnMetricsEntry
	58, // 59: google.cloud.dataproc.v1.DataprocMetricConfig.metrics:type_name -> google.cloud.dataproc.v1.DataprocMetricConfig.Metric
	7,  // 60: google.cloud.dataproc.v1.CreateClusterRequest.cluster:type_name -> google.cloud.dataproc.v1.Cluster
	64, // 61: google.cloud.dataproc.v1.CreateClusterRequest.action_on_failed_primary_workers:type_name -> google.cloud.dataproc.v1.FailureAction
	7,  // 62: google.cloud.dataproc.v1.UpdateClusterRequest.cluster:type_name -> google.cloud.dataproc.v1.Cluster
	61, // 63: google.cloud.dataproc.v1.UpdateClusterRequest.graceful_decommission_timeout:type_name -> google.protobuf.Duration
	65, // 64: google.cloud.dataproc.v1.UpdateClusterRequest.update_mask:type_name -> google.protobuf.FieldMask
	7,  // 65: google.cloud.dataproc.v1.ListClustersResponse.clusters:type_name -> google.cloud.dataproc.v1.Cluster
	66, // 66: google.cloud.dataproc.v1.DiagnoseClusterRequest.diagnosis_interval:type_name -> google.type.Interval
	6,  // 67: google.cloud.dataproc.v1.ReservationAffinity.consume_reservation_type:type_name -> google.cloud.dataproc.v1.ReservationAffinity.Type
	5,  // 68: google.cloud.dataproc.v1.DataprocMetricConfig.Metric.metric_source:type_name -> google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource
	37, // 69: google.cloud.dataproc.v1.ClusterController.CreateCluster:input_type -> google.cloud.dataproc.v1.CreateClusterRequest
	38, // 70: google.cloud.dataproc.v1.ClusterController.UpdateCluster:input_type -> google.cloud.dataproc.v1.UpdateClusterRequest
	39, // 71: google.cloud.dataproc.v1.ClusterController.StopCluster:input_type -> google.cloud.dataproc.v1.StopClusterRequest
	40, // 72: google.cloud.dataproc.v1.ClusterController.StartCluster:input_type -> google.cloud.dataproc.v1.StartClusterRequest
	41, // 73: google.cloud.dataproc.v1.ClusterController.DeleteCluster:input_type -> google.cloud.dataproc.v1.DeleteClusterRequest
	42, // 74: google.cloud.dataproc.v1.ClusterController.GetCluster:input_type -> google.cloud.dataproc.v1.GetClusterRequest
	43, // 75: google.cloud.dataproc.v1.ClusterController.ListClusters:input_type -> google.cloud.dataproc.v1.ListClustersRequest
	45, // 76: google.cloud.dataproc.v1.ClusterController.DiagnoseCluster:input_type -> google.cloud.dataproc.v1.DiagnoseClusterRequest
	67, // 77: google.cloud.dataproc.v1.ClusterController.CreateCluster:output_type -> google.longrunning.Operation
	67, // 78: google.cloud.dataproc.v1.ClusterController.UpdateCluster:output_type -> google.longrunning.Operation
	67, // 79: google.cloud.dataproc.v1.ClusterController.StopCluster:output_type -> google.longrunning.Operation
	67, // 80: google.cloud.dataproc.v1.ClusterController.StartCluster:output_type -> google.longrunning.Operation
	67, // 81: google.cloud.dataproc.v1.ClusterController.DeleteCluster:output_type -> google.longrunning.Operation
	7,  // 82: google.cloud.dataproc.v1.ClusterController.GetCluster:output_type -> google.cloud.dataproc.v1.Cluster
	44, // 83: google.cloud.dataproc.v1.ClusterController.ListClusters:output_type -> google.cloud.dataproc.v1.ListClustersResponse
	67, // 84: google.cloud.dataproc.v1.ClusterController.DiagnoseCluster:output_type -> google.longrunning.Operation
	77, // [77:85] is the sub-list for method output_type
	69, // [69:77] is the sub-list for method input_type
	69, // [69:69] is the sub-list for extension type_name
	69, // [69:69] is the sub-list for extension extendee
	0,  // [0:69] is the sub-list for field type_name
}

func init() { file_google_cloud_dataproc_v1_clusters_proto_init() }
func file_google_cloud_dataproc_v1_clusters_proto_init() {
	if File_google_cloud_dataproc_v1_clusters_proto != nil {
		return
	}
	file_google_cloud_dataproc_v1_operations_proto_init()
	file_google_cloud_dataproc_v1_shared_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VirtualClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuxiliaryServicesConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndpointConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoscalingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EncryptionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GceClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeGroupAffinity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShieldedInstanceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfidentialInstanceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceGroupConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartupConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGroupConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceFlexibilityPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AcceleratorConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuxiliaryNodeGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeInitializationAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClusterStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecurityConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KerberosConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IdentityConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoftwareConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LifecycleConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetastoreConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClusterMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataprocMetricConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListClustersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListClustersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiagnoseClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiagnoseClusterResults); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReservationAffinity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceFlexibilityPolicy_InstanceSelection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceFlexibilityPolicy_InstanceSelectionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_clusters_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataprocMetricConfig_Metric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dataproc_v1_clusters_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*VirtualClusterConfig_KubernetesClusterConfig)(nil),
	}
	file_google_cloud_dataproc_v1_clusters_proto_msgTypes[7].OneofWrappers = []interface{}{}
	file_google_cloud_dataproc_v1_clusters_proto_msgTypes[9].OneofWrappers = []interface{}{}
	file_google_cloud_dataproc_v1_clusters_proto_msgTypes[12].OneofWrappers = []interface{}{}
	file_google_cloud_dataproc_v1_clusters_proto_msgTypes[26].OneofWrappers = []interface{}{
		(*LifecycleConfig_AutoDeleteTime)(nil),
		(*LifecycleConfig_AutoDeleteTtl)(nil),
	}
	file_google_cloud_dataproc_v1_clusters_proto_msgTypes[45].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataproc_v1_clusters_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   52,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dataproc_v1_clusters_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataproc_v1_clusters_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataproc_v1_clusters_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataproc_v1_clusters_proto_msgTypes,
	}.Build()
	File_google_cloud_dataproc_v1_clusters_proto = out.File
	file_google_cloud_dataproc_v1_clusters_proto_rawDesc = nil
	file_google_cloud_dataproc_v1_clusters_proto_goTypes = nil
	file_google_cloud_dataproc_v1_clusters_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ClusterControllerClient is the client API for ClusterController service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ClusterControllerClient interface {
	// Creates a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	// The cluster must be in a
	// [`RUNNING`][google.cloud.dataproc.v1.ClusterStatus.State] state or an error
	// is returned.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stops a cluster in a project.
	StopCluster(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts a cluster in a project.
	StartCluster(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the resource representation for a cluster in a project.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Lists all regions/{region}/clusters in a project alphabetically.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets cluster diagnostic information. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	// After the operation completes,
	// [Operation.response][google.longrunning.Operation.response]
	// contains
	// [DiagnoseClusterResults](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#diagnoseclusterresults).
	DiagnoseCluster(ctx context.Context, in *DiagnoseClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type clusterControllerClient struct {
	cc grpc.ClientConnInterface
}

func NewClusterControllerClient(cc grpc.ClientConnInterface) ClusterControllerClient {
	return &clusterControllerClient{cc}
}

func (c *clusterControllerClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/CreateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/UpdateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) StopCluster(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/StopCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) StartCluster(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/StartCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/DeleteCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/GetCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/ListClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) DiagnoseCluster(ctx context.Context, in *DiagnoseClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/DiagnoseCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterControllerServer is the server API for ClusterController service.
type ClusterControllerServer interface {
	// Creates a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error)
	// Updates a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	// The cluster must be in a
	// [`RUNNING`][google.cloud.dataproc.v1.ClusterStatus.State] state or an error
	// is returned.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error)
	// Stops a cluster in a project.
	StopCluster(context.Context, *StopClusterRequest) (*longrunningpb.Operation, error)
	// Starts a cluster in a project.
	StartCluster(context.Context, *StartClusterRequest) (*longrunningpb.Operation, error)
	// Deletes a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error)
	// Gets the resource representation for a cluster in a project.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Lists all regions/{region}/clusters in a project alphabetically.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets cluster diagnostic information. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	// After the operation completes,
	// [Operation.response][google.longrunning.Operation.response]
	// contains
	// [DiagnoseClusterResults](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#diagnoseclusterresults).
	DiagnoseCluster(context.Context, *DiagnoseClusterRequest) (*longrunningpb.Operation, error)
}

// UnimplementedClusterControllerServer can be embedded to have forward compatible implementations.
type UnimplementedClusterControllerServer struct {
}

func (*UnimplementedClusterControllerServer) CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (*UnimplementedClusterControllerServer) UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (*UnimplementedClusterControllerServer) StopCluster(context.Context, *StopClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopCluster not implemented")
}
func (*UnimplementedClusterControllerServer) StartCluster(context.Context, *StartClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartCluster not implemented")
}
func (*UnimplementedClusterControllerServer) DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (*UnimplementedClusterControllerServer) GetCluster(context.Context, *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (*UnimplementedClusterControllerServer) ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (*UnimplementedClusterControllerServer) DiagnoseCluster(context.Context, *DiagnoseClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DiagnoseCluster not implemented")
}

func RegisterClusterControllerServer(s *grpc.Server, srv ClusterControllerServer) {
	s.RegisterService(&_ClusterController_serviceDesc, srv)
}

func _ClusterController_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_StopCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).StopCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/StopCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).StopCluster(ctx, req.(*StopClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_StartCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).StartCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/StartCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).StartCluster(ctx, req.(*StartClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_DiagnoseCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiagnoseClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).DiagnoseCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/DiagnoseCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).DiagnoseCluster(ctx, req.(*DiagnoseClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.ClusterController",
	HandlerType: (*ClusterControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCluster",
			Handler:    _ClusterController_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _ClusterController_UpdateCluster_Handler,
		},
		{
			MethodName: "StopCluster",
			Handler:    _ClusterController_StopCluster_Handler,
		},
		{
			MethodName: "StartCluster",
			Handler:    _ClusterController_StartCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _ClusterController_DeleteCluster_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _ClusterController_GetCluster_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _ClusterController_ListClusters_Handler,
		},
		{
			MethodName: "DiagnoseCluster",
			Handler:    _ClusterController_DiagnoseCluster_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/clusters.proto",
}
