// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/cloud/channel/v1/offers.proto

package channelpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	money "google.golang.org/genproto/googleapis/type/money"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Constraints type for Promotional offers.
type PromotionalOrderType int32

const (
	// Not used.
	PromotionalOrderType_PROMOTIONAL_TYPE_UNSPECIFIED PromotionalOrderType = 0
	// Order used for new customers, trial conversions and upgrades.
	PromotionalOrderType_NEW_UPGRADE PromotionalOrderType = 1
	// All orders for transferring an existing customer.
	PromotionalOrderType_TRANSFER PromotionalOrderType = 2
	// Orders for modifying an existing customer's promotion on the same SKU.
	PromotionalOrderType_PROMOTION_SWITCH PromotionalOrderType = 3
)

// Enum value maps for PromotionalOrderType.
var (
	PromotionalOrderType_name = map[int32]string{
		0: "PROMOTIONAL_TYPE_UNSPECIFIED",
		1: "NEW_UPGRADE",
		2: "TRANSFER",
		3: "PROMOTION_SWITCH",
	}
	PromotionalOrderType_value = map[string]int32{
		"PROMOTIONAL_TYPE_UNSPECIFIED": 0,
		"NEW_UPGRADE":                  1,
		"TRANSFER":                     2,
		"PROMOTION_SWITCH":             3,
	}
)

func (x PromotionalOrderType) Enum() *PromotionalOrderType {
	p := new(PromotionalOrderType)
	*p = x
	return p
}

func (x PromotionalOrderType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PromotionalOrderType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_offers_proto_enumTypes[0].Descriptor()
}

func (PromotionalOrderType) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_offers_proto_enumTypes[0]
}

func (x PromotionalOrderType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PromotionalOrderType.Descriptor instead.
func (PromotionalOrderType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{0}
}

// Describes how the reseller will be billed.
type PaymentPlan int32

const (
	// Not used.
	PaymentPlan_PAYMENT_PLAN_UNSPECIFIED PaymentPlan = 0
	// Commitment.
	PaymentPlan_COMMITMENT PaymentPlan = 1
	// No commitment.
	PaymentPlan_FLEXIBLE PaymentPlan = 2
	// Free.
	PaymentPlan_FREE PaymentPlan = 3
	// Trial.
	PaymentPlan_TRIAL PaymentPlan = 4
	// Price and ordering not available through API.
	PaymentPlan_OFFLINE PaymentPlan = 5
)

// Enum value maps for PaymentPlan.
var (
	PaymentPlan_name = map[int32]string{
		0: "PAYMENT_PLAN_UNSPECIFIED",
		1: "COMMITMENT",
		2: "FLEXIBLE",
		3: "FREE",
		4: "TRIAL",
		5: "OFFLINE",
	}
	PaymentPlan_value = map[string]int32{
		"PAYMENT_PLAN_UNSPECIFIED": 0,
		"COMMITMENT":               1,
		"FLEXIBLE":                 2,
		"FREE":                     3,
		"TRIAL":                    4,
		"OFFLINE":                  5,
	}
)

func (x PaymentPlan) Enum() *PaymentPlan {
	p := new(PaymentPlan)
	*p = x
	return p
}

func (x PaymentPlan) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PaymentPlan) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_offers_proto_enumTypes[1].Descriptor()
}

func (PaymentPlan) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_offers_proto_enumTypes[1]
}

func (x PaymentPlan) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PaymentPlan.Descriptor instead.
func (PaymentPlan) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{1}
}

// Specifies when the payment needs to happen.
type PaymentType int32

const (
	// Not used.
	PaymentType_PAYMENT_TYPE_UNSPECIFIED PaymentType = 0
	// Prepay. Amount has to be paid before service is rendered.
	PaymentType_PREPAY PaymentType = 1
	// Postpay. Reseller is charged at the end of the Payment cycle.
	PaymentType_POSTPAY PaymentType = 2
)

// Enum value maps for PaymentType.
var (
	PaymentType_name = map[int32]string{
		0: "PAYMENT_TYPE_UNSPECIFIED",
		1: "PREPAY",
		2: "POSTPAY",
	}
	PaymentType_value = map[string]int32{
		"PAYMENT_TYPE_UNSPECIFIED": 0,
		"PREPAY":                   1,
		"POSTPAY":                  2,
	}
)

func (x PaymentType) Enum() *PaymentType {
	p := new(PaymentType)
	*p = x
	return p
}

func (x PaymentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PaymentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_offers_proto_enumTypes[2].Descriptor()
}

func (PaymentType) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_offers_proto_enumTypes[2]
}

func (x PaymentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PaymentType.Descriptor instead.
func (PaymentType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{2}
}

// Represents the type for a monetizable resource(any entity on which billing
// happens). For example, this could be MINUTES for Google Voice and GB for
// Google Drive. One SKU can map to multiple monetizable resources.
type ResourceType int32

const (
	// Not used.
	ResourceType_RESOURCE_TYPE_UNSPECIFIED ResourceType = 0
	// Seat.
	ResourceType_SEAT ResourceType = 1
	// Monthly active user.
	ResourceType_MAU ResourceType = 2
	// GB (used for storage SKUs).
	ResourceType_GB ResourceType = 3
	// Active licensed users(for Voice SKUs).
	ResourceType_LICENSED_USER ResourceType = 4
	// Voice usage.
	ResourceType_MINUTES ResourceType = 5
	// For IaaS SKUs like Google Cloud, monetization is based on usage accrued on
	// your billing account irrespective of the type of monetizable resource. This
	// enum represents an aggregated resource/container for all usage SKUs on a
	// billing account. Currently, only applicable to Google Cloud.
	ResourceType_IAAS_USAGE ResourceType = 6
	// For Google Cloud subscriptions like Anthos or SAP.
	ResourceType_SUBSCRIPTION ResourceType = 7
)

// Enum value maps for ResourceType.
var (
	ResourceType_name = map[int32]string{
		0: "RESOURCE_TYPE_UNSPECIFIED",
		1: "SEAT",
		2: "MAU",
		3: "GB",
		4: "LICENSED_USER",
		5: "MINUTES",
		6: "IAAS_USAGE",
		7: "SUBSCRIPTION",
	}
	ResourceType_value = map[string]int32{
		"RESOURCE_TYPE_UNSPECIFIED": 0,
		"SEAT":                      1,
		"MAU":                       2,
		"GB":                        3,
		"LICENSED_USER":             4,
		"MINUTES":                   5,
		"IAAS_USAGE":                6,
		"SUBSCRIPTION":              7,
	}
)

func (x ResourceType) Enum() *ResourceType {
	p := new(ResourceType)
	*p = x
	return p
}

func (x ResourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_offers_proto_enumTypes[3].Descriptor()
}

func (ResourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_offers_proto_enumTypes[3]
}

func (x ResourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourceType.Descriptor instead.
func (ResourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{3}
}

// Period Type.
type PeriodType int32

const (
	// Not used.
	PeriodType_PERIOD_TYPE_UNSPECIFIED PeriodType = 0
	// Day.
	PeriodType_DAY PeriodType = 1
	// Month.
	PeriodType_MONTH PeriodType = 2
	// Year.
	PeriodType_YEAR PeriodType = 3
)

// Enum value maps for PeriodType.
var (
	PeriodType_name = map[int32]string{
		0: "PERIOD_TYPE_UNSPECIFIED",
		1: "DAY",
		2: "MONTH",
		3: "YEAR",
	}
	PeriodType_value = map[string]int32{
		"PERIOD_TYPE_UNSPECIFIED": 0,
		"DAY":                     1,
		"MONTH":                   2,
		"YEAR":                    3,
	}
)

func (x PeriodType) Enum() *PeriodType {
	p := new(PeriodType)
	*p = x
	return p
}

func (x PeriodType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PeriodType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_offers_proto_enumTypes[4].Descriptor()
}

func (PeriodType) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_offers_proto_enumTypes[4]
}

func (x PeriodType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PeriodType.Descriptor instead.
func (PeriodType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{4}
}

// Data type of the parameter.
type ParameterDefinition_ParameterType int32

const (
	// Not used.
	ParameterDefinition_PARAMETER_TYPE_UNSPECIFIED ParameterDefinition_ParameterType = 0
	// Int64 type.
	ParameterDefinition_INT64 ParameterDefinition_ParameterType = 1
	// String type.
	ParameterDefinition_STRING ParameterDefinition_ParameterType = 2
	// Double type.
	ParameterDefinition_DOUBLE ParameterDefinition_ParameterType = 3
	// Boolean type.
	ParameterDefinition_BOOLEAN ParameterDefinition_ParameterType = 4
)

// Enum value maps for ParameterDefinition_ParameterType.
var (
	ParameterDefinition_ParameterType_name = map[int32]string{
		0: "PARAMETER_TYPE_UNSPECIFIED",
		1: "INT64",
		2: "STRING",
		3: "DOUBLE",
		4: "BOOLEAN",
	}
	ParameterDefinition_ParameterType_value = map[string]int32{
		"PARAMETER_TYPE_UNSPECIFIED": 0,
		"INT64":                      1,
		"STRING":                     2,
		"DOUBLE":                     3,
		"BOOLEAN":                    4,
	}
)

func (x ParameterDefinition_ParameterType) Enum() *ParameterDefinition_ParameterType {
	p := new(ParameterDefinition_ParameterType)
	*p = x
	return p
}

func (x ParameterDefinition_ParameterType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ParameterDefinition_ParameterType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_offers_proto_enumTypes[5].Descriptor()
}

func (ParameterDefinition_ParameterType) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_offers_proto_enumTypes[5]
}

func (x ParameterDefinition_ParameterType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ParameterDefinition_ParameterType.Descriptor instead.
func (ParameterDefinition_ParameterType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{1, 0}
}

// Represents an offer made to resellers for purchase.
// An offer is associated with a [Sku][google.cloud.channel.v1.Sku], has a plan
// for payment, a price, and defines the constraints for buying.
type Offer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource Name of the Offer.
	// Format: accounts/{account_id}/offers/{offer_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Marketing information for the Offer.
	MarketingInfo *MarketingInfo `protobuf:"bytes,2,opt,name=marketing_info,json=marketingInfo,proto3" json:"marketing_info,omitempty"`
	// SKU the offer is associated with.
	Sku *Sku `protobuf:"bytes,3,opt,name=sku,proto3" json:"sku,omitempty"`
	// Describes the payment plan for the Offer.
	Plan *Plan `protobuf:"bytes,4,opt,name=plan,proto3" json:"plan,omitempty"`
	// Constraints on transacting the Offer.
	Constraints *Constraints `protobuf:"bytes,5,opt,name=constraints,proto3" json:"constraints,omitempty"`
	// Price for each monetizable resource type.
	PriceByResources []*PriceByResource `protobuf:"bytes,6,rep,name=price_by_resources,json=priceByResources,proto3" json:"price_by_resources,omitempty"`
	// Start of the Offer validity time.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. End of the Offer validity time.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Parameters required to use current Offer to purchase.
	ParameterDefinitions []*ParameterDefinition `protobuf:"bytes,9,rep,name=parameter_definitions,json=parameterDefinitions,proto3" json:"parameter_definitions,omitempty"`
	// The deal code of the offer to get a special promotion or discount.
	DealCode string `protobuf:"bytes,12,opt,name=deal_code,json=dealCode,proto3" json:"deal_code,omitempty"`
}

func (x *Offer) Reset() {
	*x = Offer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Offer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Offer) ProtoMessage() {}

func (x *Offer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Offer.ProtoReflect.Descriptor instead.
func (*Offer) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{0}
}

func (x *Offer) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Offer) GetMarketingInfo() *MarketingInfo {
	if x != nil {
		return x.MarketingInfo
	}
	return nil
}

func (x *Offer) GetSku() *Sku {
	if x != nil {
		return x.Sku
	}
	return nil
}

func (x *Offer) GetPlan() *Plan {
	if x != nil {
		return x.Plan
	}
	return nil
}

func (x *Offer) GetConstraints() *Constraints {
	if x != nil {
		return x.Constraints
	}
	return nil
}

func (x *Offer) GetPriceByResources() []*PriceByResource {
	if x != nil {
		return x.PriceByResources
	}
	return nil
}

func (x *Offer) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Offer) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Offer) GetParameterDefinitions() []*ParameterDefinition {
	if x != nil {
		return x.ParameterDefinitions
	}
	return nil
}

func (x *Offer) GetDealCode() string {
	if x != nil {
		return x.DealCode
	}
	return ""
}

// Parameter's definition. Specifies what parameter is required to use the
// current Offer to purchase.
type ParameterDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the parameter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Data type of the parameter. Minimal value, Maximum value and allowed values
	// will use specified data type here.
	ParameterType ParameterDefinition_ParameterType `protobuf:"varint,2,opt,name=parameter_type,json=parameterType,proto3,enum=google.cloud.channel.v1.ParameterDefinition_ParameterType" json:"parameter_type,omitempty"`
	// Minimal value of the parameter, if applicable. Inclusive. For example,
	// minimal commitment when purchasing Anthos is 0.01.
	// Applicable to INT64 and DOUBLE parameter types.
	MinValue *Value `protobuf:"bytes,3,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Maximum value of the parameter, if applicable. Inclusive. For example,
	// maximum seats when purchasing Google Workspace Business Standard.
	// Applicable to INT64 and DOUBLE parameter types.
	MaxValue *Value `protobuf:"bytes,4,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// If not empty, parameter values must be drawn from this list.
	// For example, [us-west1, us-west2, ...]
	// Applicable to STRING parameter type.
	AllowedValues []*Value `protobuf:"bytes,5,rep,name=allowed_values,json=allowedValues,proto3" json:"allowed_values,omitempty"`
	// If set to true, parameter is optional to purchase this Offer.
	Optional bool `protobuf:"varint,6,opt,name=optional,proto3" json:"optional,omitempty"`
}

func (x *ParameterDefinition) Reset() {
	*x = ParameterDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ParameterDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParameterDefinition) ProtoMessage() {}

func (x *ParameterDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParameterDefinition.ProtoReflect.Descriptor instead.
func (*ParameterDefinition) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{1}
}

func (x *ParameterDefinition) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ParameterDefinition) GetParameterType() ParameterDefinition_ParameterType {
	if x != nil {
		return x.ParameterType
	}
	return ParameterDefinition_PARAMETER_TYPE_UNSPECIFIED
}

func (x *ParameterDefinition) GetMinValue() *Value {
	if x != nil {
		return x.MinValue
	}
	return nil
}

func (x *ParameterDefinition) GetMaxValue() *Value {
	if x != nil {
		return x.MaxValue
	}
	return nil
}

func (x *ParameterDefinition) GetAllowedValues() []*Value {
	if x != nil {
		return x.AllowedValues
	}
	return nil
}

func (x *ParameterDefinition) GetOptional() bool {
	if x != nil {
		return x.Optional
	}
	return false
}

// Represents the constraints for buying the Offer.
type Constraints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Represents constraints required to purchase the Offer for a customer.
	CustomerConstraints *CustomerConstraints `protobuf:"bytes,1,opt,name=customer_constraints,json=customerConstraints,proto3" json:"customer_constraints,omitempty"`
}

func (x *Constraints) Reset() {
	*x = Constraints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Constraints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Constraints) ProtoMessage() {}

func (x *Constraints) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Constraints.ProtoReflect.Descriptor instead.
func (*Constraints) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{2}
}

func (x *Constraints) GetCustomerConstraints() *CustomerConstraints {
	if x != nil {
		return x.CustomerConstraints
	}
	return nil
}

// Represents constraints required to purchase the Offer for a customer.
type CustomerConstraints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Allowed geographical regions of the customer.
	AllowedRegions []string `protobuf:"bytes,1,rep,name=allowed_regions,json=allowedRegions,proto3" json:"allowed_regions,omitempty"`
	// Allowed Customer Type.
	AllowedCustomerTypes []CloudIdentityInfo_CustomerType `protobuf:"varint,2,rep,packed,name=allowed_customer_types,json=allowedCustomerTypes,proto3,enum=google.cloud.channel.v1.CloudIdentityInfo_CustomerType" json:"allowed_customer_types,omitempty"`
	// Allowed Promotional Order Type. Present for Promotional offers.
	PromotionalOrderTypes []PromotionalOrderType `protobuf:"varint,3,rep,packed,name=promotional_order_types,json=promotionalOrderTypes,proto3,enum=google.cloud.channel.v1.PromotionalOrderType" json:"promotional_order_types,omitempty"`
}

func (x *CustomerConstraints) Reset() {
	*x = CustomerConstraints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomerConstraints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomerConstraints) ProtoMessage() {}

func (x *CustomerConstraints) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomerConstraints.ProtoReflect.Descriptor instead.
func (*CustomerConstraints) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{3}
}

func (x *CustomerConstraints) GetAllowedRegions() []string {
	if x != nil {
		return x.AllowedRegions
	}
	return nil
}

func (x *CustomerConstraints) GetAllowedCustomerTypes() []CloudIdentityInfo_CustomerType {
	if x != nil {
		return x.AllowedCustomerTypes
	}
	return nil
}

func (x *CustomerConstraints) GetPromotionalOrderTypes() []PromotionalOrderType {
	if x != nil {
		return x.PromotionalOrderTypes
	}
	return nil
}

// The payment plan for the Offer. Describes how to make a payment.
type Plan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes how a reseller will be billed.
	PaymentPlan PaymentPlan `protobuf:"varint,1,opt,name=payment_plan,json=paymentPlan,proto3,enum=google.cloud.channel.v1.PaymentPlan" json:"payment_plan,omitempty"`
	// Specifies when the payment needs to happen.
	PaymentType PaymentType `protobuf:"varint,2,opt,name=payment_type,json=paymentType,proto3,enum=google.cloud.channel.v1.PaymentType" json:"payment_type,omitempty"`
	// Describes how frequently the reseller will be billed, such as
	// once per month.
	PaymentCycle *Period `protobuf:"bytes,3,opt,name=payment_cycle,json=paymentCycle,proto3" json:"payment_cycle,omitempty"`
	// Present for Offers with a trial period.
	// For trial-only Offers, a paid service needs to start before the trial
	// period ends for continued service.
	// For Regular Offers with a trial period, the regular pricing goes into
	// effect when trial period ends, or if paid service is started before the end
	// of the trial period.
	TrialPeriod *Period `protobuf:"bytes,4,opt,name=trial_period,json=trialPeriod,proto3" json:"trial_period,omitempty"`
	// Reseller Billing account to charge after an offer transaction.
	// Only present for Google Cloud offers.
	BillingAccount string `protobuf:"bytes,5,opt,name=billing_account,json=billingAccount,proto3" json:"billing_account,omitempty"`
}

func (x *Plan) Reset() {
	*x = Plan{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Plan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Plan) ProtoMessage() {}

func (x *Plan) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Plan.ProtoReflect.Descriptor instead.
func (*Plan) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{4}
}

func (x *Plan) GetPaymentPlan() PaymentPlan {
	if x != nil {
		return x.PaymentPlan
	}
	return PaymentPlan_PAYMENT_PLAN_UNSPECIFIED
}

func (x *Plan) GetPaymentType() PaymentType {
	if x != nil {
		return x.PaymentType
	}
	return PaymentType_PAYMENT_TYPE_UNSPECIFIED
}

func (x *Plan) GetPaymentCycle() *Period {
	if x != nil {
		return x.PaymentCycle
	}
	return nil
}

func (x *Plan) GetTrialPeriod() *Period {
	if x != nil {
		return x.TrialPeriod
	}
	return nil
}

func (x *Plan) GetBillingAccount() string {
	if x != nil {
		return x.BillingAccount
	}
	return ""
}

// Represents price by resource type.
type PriceByResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource Type. Example: SEAT
	ResourceType ResourceType `protobuf:"varint,1,opt,name=resource_type,json=resourceType,proto3,enum=google.cloud.channel.v1.ResourceType" json:"resource_type,omitempty"`
	// Price of the Offer. Present if there are no price phases.
	Price *Price `protobuf:"bytes,2,opt,name=price,proto3" json:"price,omitempty"`
	// Specifies the price by time range.
	PricePhases []*PricePhase `protobuf:"bytes,3,rep,name=price_phases,json=pricePhases,proto3" json:"price_phases,omitempty"`
}

func (x *PriceByResource) Reset() {
	*x = PriceByResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PriceByResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PriceByResource) ProtoMessage() {}

func (x *PriceByResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PriceByResource.ProtoReflect.Descriptor instead.
func (*PriceByResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{5}
}

func (x *PriceByResource) GetResourceType() ResourceType {
	if x != nil {
		return x.ResourceType
	}
	return ResourceType_RESOURCE_TYPE_UNSPECIFIED
}

func (x *PriceByResource) GetPrice() *Price {
	if x != nil {
		return x.Price
	}
	return nil
}

func (x *PriceByResource) GetPricePhases() []*PricePhase {
	if x != nil {
		return x.PricePhases
	}
	return nil
}

// Represents the price of the Offer.
type Price struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Base price.
	BasePrice *money.Money `protobuf:"bytes,1,opt,name=base_price,json=basePrice,proto3" json:"base_price,omitempty"`
	// Discount percentage, represented as decimal.
	// For example, a 20% discount will be represent as 0.2.
	Discount float64 `protobuf:"fixed64,2,opt,name=discount,proto3" json:"discount,omitempty"`
	// Effective Price after applying the discounts.
	EffectivePrice *money.Money `protobuf:"bytes,3,opt,name=effective_price,json=effectivePrice,proto3" json:"effective_price,omitempty"`
	// Link to external price list, such as link to Google Voice rate card.
	ExternalPriceUri string `protobuf:"bytes,4,opt,name=external_price_uri,json=externalPriceUri,proto3" json:"external_price_uri,omitempty"`
}

func (x *Price) Reset() {
	*x = Price{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Price) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Price) ProtoMessage() {}

func (x *Price) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Price.ProtoReflect.Descriptor instead.
func (*Price) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{6}
}

func (x *Price) GetBasePrice() *money.Money {
	if x != nil {
		return x.BasePrice
	}
	return nil
}

func (x *Price) GetDiscount() float64 {
	if x != nil {
		return x.Discount
	}
	return 0
}

func (x *Price) GetEffectivePrice() *money.Money {
	if x != nil {
		return x.EffectivePrice
	}
	return nil
}

func (x *Price) GetExternalPriceUri() string {
	if x != nil {
		return x.ExternalPriceUri
	}
	return ""
}

// Specifies the price by the duration of months.
// For example, a 20% discount for the first six months, then a 10% discount
// starting on the seventh month.
type PricePhase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines the phase period type.
	PeriodType PeriodType `protobuf:"varint,1,opt,name=period_type,json=periodType,proto3,enum=google.cloud.channel.v1.PeriodType" json:"period_type,omitempty"`
	// Defines first period for the phase.
	FirstPeriod int32 `protobuf:"varint,2,opt,name=first_period,json=firstPeriod,proto3" json:"first_period,omitempty"`
	// Defines first period for the phase.
	LastPeriod int32 `protobuf:"varint,3,opt,name=last_period,json=lastPeriod,proto3" json:"last_period,omitempty"`
	// Price of the phase. Present if there are no price tiers.
	Price *Price `protobuf:"bytes,4,opt,name=price,proto3" json:"price,omitempty"`
	// Price by the resource tiers.
	PriceTiers []*PriceTier `protobuf:"bytes,5,rep,name=price_tiers,json=priceTiers,proto3" json:"price_tiers,omitempty"`
}

func (x *PricePhase) Reset() {
	*x = PricePhase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PricePhase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PricePhase) ProtoMessage() {}

func (x *PricePhase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PricePhase.ProtoReflect.Descriptor instead.
func (*PricePhase) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{7}
}

func (x *PricePhase) GetPeriodType() PeriodType {
	if x != nil {
		return x.PeriodType
	}
	return PeriodType_PERIOD_TYPE_UNSPECIFIED
}

func (x *PricePhase) GetFirstPeriod() int32 {
	if x != nil {
		return x.FirstPeriod
	}
	return 0
}

func (x *PricePhase) GetLastPeriod() int32 {
	if x != nil {
		return x.LastPeriod
	}
	return 0
}

func (x *PricePhase) GetPrice() *Price {
	if x != nil {
		return x.Price
	}
	return nil
}

func (x *PricePhase) GetPriceTiers() []*PriceTier {
	if x != nil {
		return x.PriceTiers
	}
	return nil
}

// Defines price at resource tier level.
// For example, an offer with following definition :
//
// * Tier 1: Provide 25% discount for all seats between 1 and 25.
// * Tier 2: Provide 10% discount for all seats between 26 and 100.
// * Tier 3: Provide flat 15% discount for all seats above 100.
//
// Each of these tiers is represented as a PriceTier.
type PriceTier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// First resource for which the tier price applies.
	FirstResource int32 `protobuf:"varint,1,opt,name=first_resource,json=firstResource,proto3" json:"first_resource,omitempty"`
	// Last resource for which the tier price applies.
	LastResource int32 `protobuf:"varint,2,opt,name=last_resource,json=lastResource,proto3" json:"last_resource,omitempty"`
	// Price of the tier.
	Price *Price `protobuf:"bytes,3,opt,name=price,proto3" json:"price,omitempty"`
}

func (x *PriceTier) Reset() {
	*x = PriceTier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PriceTier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PriceTier) ProtoMessage() {}

func (x *PriceTier) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PriceTier.ProtoReflect.Descriptor instead.
func (*PriceTier) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{8}
}

func (x *PriceTier) GetFirstResource() int32 {
	if x != nil {
		return x.FirstResource
	}
	return 0
}

func (x *PriceTier) GetLastResource() int32 {
	if x != nil {
		return x.LastResource
	}
	return 0
}

func (x *PriceTier) GetPrice() *Price {
	if x != nil {
		return x.Price
	}
	return nil
}

// Represents period in days/months/years.
type Period struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total duration of Period Type defined.
	Duration int32 `protobuf:"varint,1,opt,name=duration,proto3" json:"duration,omitempty"`
	// Period Type.
	PeriodType PeriodType `protobuf:"varint,2,opt,name=period_type,json=periodType,proto3,enum=google.cloud.channel.v1.PeriodType" json:"period_type,omitempty"`
}

func (x *Period) Reset() {
	*x = Period{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Period) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Period) ProtoMessage() {}

func (x *Period) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_offers_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Period.ProtoReflect.Descriptor instead.
func (*Period) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_offers_proto_rawDescGZIP(), []int{9}
}

func (x *Period) GetDuration() int32 {
	if x != nil {
		return x.Duration
	}
	return 0
}

func (x *Period) GetPeriodType() PeriodType {
	if x != nil {
		return x.PeriodType
	}
	return PeriodType_PERIOD_TYPE_UNSPECIFIED
}

var File_google_cloud_channel_v1_offers_proto protoreflect.FileDescriptor

var file_google_cloud_channel_v1_offers_proto_rawDesc = []byte{
	0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xaf, 0x05, 0x0a, 0x05, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x4d, 0x0a, 0x0e, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x0d, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x2e, 0x0a, 0x03, 0x73, 0x6b, 0x75, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x75, 0x52, 0x03, 0x73, 0x6b, 0x75,
	0x12, 0x31, 0x0a, 0x04, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x04, 0x70,
	0x6c, 0x61, 0x6e, 0x12, 0x46, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x0b,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x56, 0x0a, 0x12, 0x70,
	0x72, 0x69, 0x63, 0x65, 0x5f, 0x62, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x42, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x10, 0x70, 0x72, 0x69, 0x63, 0x65, 0x42, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x15, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x44, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1b, 0x0a,
	0x09, 0x64, 0x65, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x64, 0x65, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x3a, 0x49, 0xea, 0x41, 0x46, 0x0a,
	0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x66, 0x66,
	0x65, 0x72, 0x12, 0x21, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x6f,
	0x66, 0x66, 0x65, 0x72, 0x7d, 0x22, 0xca, 0x03, 0x0a, 0x13, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x61, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x44, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x3b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x45,
	0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x22, 0x5f, 0x0a, 0x0d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x45, 0x54, 0x45, 0x52, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4e, 0x54, 0x36, 0x34, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x4f, 0x55,
	0x42, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e,
	0x10, 0x04, 0x22, 0x6e, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x73, 0x12, 0x5f, 0x0a, 0x14, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x63, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x13, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x73, 0x22, 0x94, 0x02, 0x0a, 0x13, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x52, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x6d, 0x0a, 0x16, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x14, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x12, 0x65, 0x0a, 0x17, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x15, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4f,
	0x72, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0xcb, 0x02, 0x0a, 0x04, 0x50, 0x6c,
	0x61, 0x6e, 0x12, 0x47, 0x0a, 0x0c, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6c,
	0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0b,
	0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x47, 0x0a, 0x0c, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x44, 0x0a, 0x0d, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x52, 0x0c, 0x70, 0x61,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x42, 0x0a, 0x0c, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x52, 0x0b, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x27,
	0x0a, 0x0f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xdb, 0x01, 0x0a, 0x0f, 0x50, 0x72, 0x69, 0x63,
	0x65, 0x42, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4a, 0x0a, 0x0d, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x34, 0x0a, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x12, 0x46, 0x0a,
	0x0c, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x68, 0x61, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x69, 0x63, 0x65, 0x50, 0x68, 0x61, 0x73, 0x65, 0x52, 0x0b, 0x70, 0x72, 0x69, 0x63, 0x65, 0x50,
	0x68, 0x61, 0x73, 0x65, 0x73, 0x22, 0xc1, 0x01, 0x0a, 0x05, 0x50, 0x72, 0x69, 0x63, 0x65, 0x12,
	0x31, 0x0a, 0x0a, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x09, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x69,
	0x63, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3b,
	0x0a, 0x0f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x63,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x0e, 0x65, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x50, 0x72, 0x69, 0x63, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x50, 0x72, 0x69, 0x63, 0x65, 0x55, 0x72, 0x69, 0x22, 0x91, 0x02, 0x0a, 0x0a, 0x50, 0x72,
	0x69, 0x63, 0x65, 0x50, 0x68, 0x61, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x66, 0x69, 0x72, 0x73, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x50, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x12, 0x34, 0x0a, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x63,
	0x65, 0x52, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x12, 0x43, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x63,
	0x65, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x54, 0x69, 0x65,
	0x72, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x63, 0x65, 0x54, 0x69, 0x65, 0x72, 0x73, 0x22, 0x8d, 0x01,
	0x0a, 0x09, 0x50, 0x72, 0x69, 0x63, 0x65, 0x54, 0x69, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x66,
	0x69, 0x72, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0d, 0x66, 0x69, 0x72, 0x73, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x34, 0x0a, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x22, 0x6a, 0x0a,
	0x06, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x70,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x2a, 0x6d, 0x0a, 0x14, 0x50, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x20, 0x0a, 0x1c, 0x50, 0x52, 0x4f, 0x4d, 0x4f, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x45, 0x57, 0x5f, 0x55, 0x50, 0x47, 0x52, 0x41,
	0x44, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52,
	0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x52, 0x4f, 0x4d, 0x4f, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x53, 0x57, 0x49, 0x54, 0x43, 0x48, 0x10, 0x03, 0x2a, 0x6b, 0x0a, 0x0b, 0x50, 0x61, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x41, 0x59, 0x4d, 0x45,
	0x4e, 0x54, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x4d,
	0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x4c, 0x45, 0x58, 0x49, 0x42, 0x4c,
	0x45, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x52, 0x45, 0x45, 0x10, 0x03, 0x12, 0x09, 0x0a,
	0x05, 0x54, 0x52, 0x49, 0x41, 0x4c, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x46, 0x46, 0x4c,
	0x49, 0x4e, 0x45, 0x10, 0x05, 0x2a, 0x44, 0x0a, 0x0b, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x41, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x52, 0x45, 0x50, 0x41, 0x59, 0x10, 0x01, 0x12, 0x0b,
	0x0a, 0x07, 0x50, 0x4f, 0x53, 0x54, 0x50, 0x41, 0x59, 0x10, 0x02, 0x2a, 0x8a, 0x01, 0x0a, 0x0c,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19,
	0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x53,
	0x45, 0x41, 0x54, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x41, 0x55, 0x10, 0x02, 0x12, 0x06,
	0x0a, 0x02, 0x47, 0x42, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53,
	0x45, 0x44, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x49, 0x4e,
	0x55, 0x54, 0x45, 0x53, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x41, 0x41, 0x53, 0x5f, 0x55,
	0x53, 0x41, 0x47, 0x45, 0x10, 0x06, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x55, 0x42, 0x53, 0x43, 0x52,
	0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x07, 0x2a, 0x47, 0x0a, 0x0a, 0x50, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x44, 0x41, 0x59, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05,
	0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x59, 0x45, 0x41, 0x52, 0x10,
	0x03, 0x42, 0x63, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x42, 0x0b, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x35, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x70, 0x62, 0x3b, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_channel_v1_offers_proto_rawDescOnce sync.Once
	file_google_cloud_channel_v1_offers_proto_rawDescData = file_google_cloud_channel_v1_offers_proto_rawDesc
)

func file_google_cloud_channel_v1_offers_proto_rawDescGZIP() []byte {
	file_google_cloud_channel_v1_offers_proto_rawDescOnce.Do(func() {
		file_google_cloud_channel_v1_offers_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_channel_v1_offers_proto_rawDescData)
	})
	return file_google_cloud_channel_v1_offers_proto_rawDescData
}

var file_google_cloud_channel_v1_offers_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_channel_v1_offers_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_channel_v1_offers_proto_goTypes = []interface{}{
	(PromotionalOrderType)(0),              // 0: google.cloud.channel.v1.PromotionalOrderType
	(PaymentPlan)(0),                       // 1: google.cloud.channel.v1.PaymentPlan
	(PaymentType)(0),                       // 2: google.cloud.channel.v1.PaymentType
	(ResourceType)(0),                      // 3: google.cloud.channel.v1.ResourceType
	(PeriodType)(0),                        // 4: google.cloud.channel.v1.PeriodType
	(ParameterDefinition_ParameterType)(0), // 5: google.cloud.channel.v1.ParameterDefinition.ParameterType
	(*Offer)(nil),                          // 6: google.cloud.channel.v1.Offer
	(*ParameterDefinition)(nil),            // 7: google.cloud.channel.v1.ParameterDefinition
	(*Constraints)(nil),                    // 8: google.cloud.channel.v1.Constraints
	(*CustomerConstraints)(nil),            // 9: google.cloud.channel.v1.CustomerConstraints
	(*Plan)(nil),                           // 10: google.cloud.channel.v1.Plan
	(*PriceByResource)(nil),                // 11: google.cloud.channel.v1.PriceByResource
	(*Price)(nil),                          // 12: google.cloud.channel.v1.Price
	(*PricePhase)(nil),                     // 13: google.cloud.channel.v1.PricePhase
	(*PriceTier)(nil),                      // 14: google.cloud.channel.v1.PriceTier
	(*Period)(nil),                         // 15: google.cloud.channel.v1.Period
	(*MarketingInfo)(nil),                  // 16: google.cloud.channel.v1.MarketingInfo
	(*Sku)(nil),                            // 17: google.cloud.channel.v1.Sku
	(*timestamppb.Timestamp)(nil),          // 18: google.protobuf.Timestamp
	(*Value)(nil),                          // 19: google.cloud.channel.v1.Value
	(CloudIdentityInfo_CustomerType)(0),    // 20: google.cloud.channel.v1.CloudIdentityInfo.CustomerType
	(*money.Money)(nil),                    // 21: google.type.Money
}
var file_google_cloud_channel_v1_offers_proto_depIdxs = []int32{
	16, // 0: google.cloud.channel.v1.Offer.marketing_info:type_name -> google.cloud.channel.v1.MarketingInfo
	17, // 1: google.cloud.channel.v1.Offer.sku:type_name -> google.cloud.channel.v1.Sku
	10, // 2: google.cloud.channel.v1.Offer.plan:type_name -> google.cloud.channel.v1.Plan
	8,  // 3: google.cloud.channel.v1.Offer.constraints:type_name -> google.cloud.channel.v1.Constraints
	11, // 4: google.cloud.channel.v1.Offer.price_by_resources:type_name -> google.cloud.channel.v1.PriceByResource
	18, // 5: google.cloud.channel.v1.Offer.start_time:type_name -> google.protobuf.Timestamp
	18, // 6: google.cloud.channel.v1.Offer.end_time:type_name -> google.protobuf.Timestamp
	7,  // 7: google.cloud.channel.v1.Offer.parameter_definitions:type_name -> google.cloud.channel.v1.ParameterDefinition
	5,  // 8: google.cloud.channel.v1.ParameterDefinition.parameter_type:type_name -> google.cloud.channel.v1.ParameterDefinition.ParameterType
	19, // 9: google.cloud.channel.v1.ParameterDefinition.min_value:type_name -> google.cloud.channel.v1.Value
	19, // 10: google.cloud.channel.v1.ParameterDefinition.max_value:type_name -> google.cloud.channel.v1.Value
	19, // 11: google.cloud.channel.v1.ParameterDefinition.allowed_values:type_name -> google.cloud.channel.v1.Value
	9,  // 12: google.cloud.channel.v1.Constraints.customer_constraints:type_name -> google.cloud.channel.v1.CustomerConstraints
	20, // 13: google.cloud.channel.v1.CustomerConstraints.allowed_customer_types:type_name -> google.cloud.channel.v1.CloudIdentityInfo.CustomerType
	0,  // 14: google.cloud.channel.v1.CustomerConstraints.promotional_order_types:type_name -> google.cloud.channel.v1.PromotionalOrderType
	1,  // 15: google.cloud.channel.v1.Plan.payment_plan:type_name -> google.cloud.channel.v1.PaymentPlan
	2,  // 16: google.cloud.channel.v1.Plan.payment_type:type_name -> google.cloud.channel.v1.PaymentType
	15, // 17: google.cloud.channel.v1.Plan.payment_cycle:type_name -> google.cloud.channel.v1.Period
	15, // 18: google.cloud.channel.v1.Plan.trial_period:type_name -> google.cloud.channel.v1.Period
	3,  // 19: google.cloud.channel.v1.PriceByResource.resource_type:type_name -> google.cloud.channel.v1.ResourceType
	12, // 20: google.cloud.channel.v1.PriceByResource.price:type_name -> google.cloud.channel.v1.Price
	13, // 21: google.cloud.channel.v1.PriceByResource.price_phases:type_name -> google.cloud.channel.v1.PricePhase
	21, // 22: google.cloud.channel.v1.Price.base_price:type_name -> google.type.Money
	21, // 23: google.cloud.channel.v1.Price.effective_price:type_name -> google.type.Money
	4,  // 24: google.cloud.channel.v1.PricePhase.period_type:type_name -> google.cloud.channel.v1.PeriodType
	12, // 25: google.cloud.channel.v1.PricePhase.price:type_name -> google.cloud.channel.v1.Price
	14, // 26: google.cloud.channel.v1.PricePhase.price_tiers:type_name -> google.cloud.channel.v1.PriceTier
	12, // 27: google.cloud.channel.v1.PriceTier.price:type_name -> google.cloud.channel.v1.Price
	4,  // 28: google.cloud.channel.v1.Period.period_type:type_name -> google.cloud.channel.v1.PeriodType
	29, // [29:29] is the sub-list for method output_type
	29, // [29:29] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_google_cloud_channel_v1_offers_proto_init() }
func file_google_cloud_channel_v1_offers_proto_init() {
	if File_google_cloud_channel_v1_offers_proto != nil {
		return
	}
	file_google_cloud_channel_v1_common_proto_init()
	file_google_cloud_channel_v1_products_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_channel_v1_offers_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Offer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_offers_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ParameterDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_offers_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Constraints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_offers_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomerConstraints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_offers_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Plan); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_offers_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PriceByResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_offers_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Price); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_offers_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PricePhase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_offers_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PriceTier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_offers_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Period); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_channel_v1_offers_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_channel_v1_offers_proto_goTypes,
		DependencyIndexes: file_google_cloud_channel_v1_offers_proto_depIdxs,
		EnumInfos:         file_google_cloud_channel_v1_offers_proto_enumTypes,
		MessageInfos:      file_google_cloud_channel_v1_offers_proto_msgTypes,
	}.Build()
	File_google_cloud_channel_v1_offers_proto = out.File
	file_google_cloud_channel_v1_offers_proto_rawDesc = nil
	file_google_cloud_channel_v1_offers_proto_goTypes = nil
	file_google_cloud_channel_v1_offers_proto_depIdxs = nil
}
