
asm2plan9s
==========

Tool to generate BYTE sequences for Go assembly as generated by YASM/GAS (for Intel) or GAS (for ARM).

Installation
------------

Make sure either YASM or GAS is installed on your platform. Note that YASM takes precedence over GAS if both are installed. 

##### GAS (Intel/AMD64 or ARM):

Typically `as` or `gas` (GNU Assembler) will already be installed as it is part of binutils, but if need be, you can eg. do as follows:
```
sudo apt-get install build-essential
```

##### YASM (Intel/AMD64):

```
$ yasm --version
yasm 1.2.0
Compiled on Sep 30 2013.
Copyright (c) 2001-2011 Peter Johnson and other Yasm developers.
Run yasm --license for licensing overview and summary.
```

### asm2plan9s

 `go get -u github.com/minio/asm2plan9s`

### AVX512 support

Note that AVX512 support is currently only available for GAS.

Example
-------

```
$ more example.s
                                 // VPADDQ  XMM0,XMM1,XMM8
$ asm2plan9s example.s
$ echo example.s
    LONG $0xd471c1c4; BYTE $0xc0 // VPADDQ  XMM0,XMM1,XMM8
```

The instruction to be assembled needs to start with a `//` preceded by either a single space or a tab character.
The preceding characters will be overwitten by the correct sequence (irrespective of its contents) so when changing the instruction, rerunning `asm2plan9s` will update the BYTE sequence generated.

Starting position of instruction
--------------------------------

The starting position of the `//` comment needs to follow the (imaginary) sequence with either a single space or a space followed by a back slash plus another space (see support for defines below).
Upon first entering an instruction you can also type eg `LONG $0x00000000; BYTE $0x00 // VZEROUPPER` to trigger the assembler. 

Support for defines
-------------------

If you are using #define for 'macros' with the back-slash delimiter to continue on the next line, this will be preserved.

For instance:
```
                                 \ // VPADDQ  XMM0,XMM1,XMM8
```

will be assembled into

```
    LONG $0xd471c1c4; BYTE $0xc0 \ // VPADDQ  XMM0,XMM1,XMM8
```

asmfmt
------

asm2plan9s works nicely together with [asmfmt](https://github.com/klauspost/asmfmt) in order to format the assembly code (in a similar style to `go fmt`). 

Extensive example
-----------------

For a more extensive example see (for Intel) [compressAvx_amd64.s](https://github.com/minio/blake2b-simd/blob/master/compressAvx_amd64.s) or (for ARM) [highwayhash_arm64.s](https://github.com/minio/highwayhash/blob/master/highwayhash_arm64.s).

License
-------

Released under the Apache License v2.0. You can find the complete text in the file LICENSE.

Contributing
------------

Contributions are welcome, please send PRs for any enhancements.