// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/cloud/beyondcorp/clientconnectorservices/v1/client_connector_services_service.proto

package clientconnectorservicespb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the different states of a ClientConnectorService.
type ClientConnectorService_State int32

const (
	// Default value. This value is unused.
	ClientConnectorService_STATE_UNSPECIFIED ClientConnectorService_State = 0
	// ClientConnectorService is being created.
	ClientConnectorService_CREATING ClientConnectorService_State = 1
	// ClientConnectorService is being updated.
	ClientConnectorService_UPDATING ClientConnectorService_State = 2
	// ClientConnectorService is being deleted.
	ClientConnectorService_DELETING ClientConnectorService_State = 3
	// ClientConnectorService is running.
	ClientConnectorService_RUNNING ClientConnectorService_State = 4
	// ClientConnectorService is down and may be restored in the future.
	// This happens when CCFE sends ProjectState = OFF.
	ClientConnectorService_DOWN ClientConnectorService_State = 5
	// ClientConnectorService encountered an error and is in an indeterministic
	// state.
	ClientConnectorService_ERROR ClientConnectorService_State = 6
)

// Enum value maps for ClientConnectorService_State.
var (
	ClientConnectorService_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "UPDATING",
		3: "DELETING",
		4: "RUNNING",
		5: "DOWN",
		6: "ERROR",
	}
	ClientConnectorService_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"UPDATING":          2,
		"DELETING":          3,
		"RUNNING":           4,
		"DOWN":              5,
		"ERROR":             6,
	}
)

func (x ClientConnectorService_State) Enum() *ClientConnectorService_State {
	p := new(ClientConnectorService_State)
	*p = x
	return p
}

func (x ClientConnectorService_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClientConnectorService_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_enumTypes[0].Descriptor()
}

func (ClientConnectorService_State) Type() protoreflect.EnumType {
	return &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_enumTypes[0]
}

func (x ClientConnectorService_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClientConnectorService_State.Descriptor instead.
func (ClientConnectorService_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{0, 0}
}

// The protocol used to connect to the server.
type ClientConnectorService_Ingress_Config_TransportProtocol int32

const (
	// Default value. This value is unused.
	ClientConnectorService_Ingress_Config_TRANSPORT_PROTOCOL_UNSPECIFIED ClientConnectorService_Ingress_Config_TransportProtocol = 0
	// TCP protocol.
	ClientConnectorService_Ingress_Config_TCP ClientConnectorService_Ingress_Config_TransportProtocol = 1
)

// Enum value maps for ClientConnectorService_Ingress_Config_TransportProtocol.
var (
	ClientConnectorService_Ingress_Config_TransportProtocol_name = map[int32]string{
		0: "TRANSPORT_PROTOCOL_UNSPECIFIED",
		1: "TCP",
	}
	ClientConnectorService_Ingress_Config_TransportProtocol_value = map[string]int32{
		"TRANSPORT_PROTOCOL_UNSPECIFIED": 0,
		"TCP":                            1,
	}
)

func (x ClientConnectorService_Ingress_Config_TransportProtocol) Enum() *ClientConnectorService_Ingress_Config_TransportProtocol {
	p := new(ClientConnectorService_Ingress_Config_TransportProtocol)
	*p = x
	return p
}

func (x ClientConnectorService_Ingress_Config_TransportProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClientConnectorService_Ingress_Config_TransportProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_enumTypes[1].Descriptor()
}

func (ClientConnectorService_Ingress_Config_TransportProtocol) Type() protoreflect.EnumType {
	return &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_enumTypes[1]
}

func (x ClientConnectorService_Ingress_Config_TransportProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClientConnectorService_Ingress_Config_TransportProtocol.Descriptor instead.
func (ClientConnectorService_Ingress_Config_TransportProtocol) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{0, 0, 0, 0}
}

// Message describing ClientConnectorService object.
type ClientConnectorService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of resource. The name is ignored during creation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. [Output only] Create time stamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. [Output only] Update time stamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User-provided name.
	// The display name should follow certain format.
	// * Must be 6 to 30 characters in length.
	// * Can only contain lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The details of the ingress settings.
	Ingress *ClientConnectorService_Ingress `protobuf:"bytes,6,opt,name=ingress,proto3" json:"ingress,omitempty"`
	// Required. The details of the egress settings.
	Egress *ClientConnectorService_Egress `protobuf:"bytes,7,opt,name=egress,proto3" json:"egress,omitempty"`
	// Output only. The operational state of the ClientConnectorService.
	State ClientConnectorService_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService_State" json:"state,omitempty"`
}

func (x *ClientConnectorService) Reset() {
	*x = ClientConnectorService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientConnectorService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientConnectorService) ProtoMessage() {}

func (x *ClientConnectorService) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientConnectorService.ProtoReflect.Descriptor instead.
func (*ClientConnectorService) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{0}
}

func (x *ClientConnectorService) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ClientConnectorService) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ClientConnectorService) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ClientConnectorService) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ClientConnectorService) GetIngress() *ClientConnectorService_Ingress {
	if x != nil {
		return x.Ingress
	}
	return nil
}

func (x *ClientConnectorService) GetEgress() *ClientConnectorService_Egress {
	if x != nil {
		return x.Egress
	}
	return nil
}

func (x *ClientConnectorService) GetState() ClientConnectorService_State {
	if x != nil {
		return x.State
	}
	return ClientConnectorService_STATE_UNSPECIFIED
}

// Message for requesting list of ClientConnectorServices.
type ListClientConnectorServicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListClientConnectorServicesRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListClientConnectorServicesRequest) Reset() {
	*x = ListClientConnectorServicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListClientConnectorServicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClientConnectorServicesRequest) ProtoMessage() {}

func (x *ListClientConnectorServicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClientConnectorServicesRequest.ProtoReflect.Descriptor instead.
func (*ListClientConnectorServicesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListClientConnectorServicesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListClientConnectorServicesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListClientConnectorServicesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListClientConnectorServicesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListClientConnectorServicesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing ClientConnectorServices.
type ListClientConnectorServicesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of ClientConnectorService.
	ClientConnectorServices []*ClientConnectorService `protobuf:"bytes,1,rep,name=client_connector_services,json=clientConnectorServices,proto3" json:"client_connector_services,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListClientConnectorServicesResponse) Reset() {
	*x = ListClientConnectorServicesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListClientConnectorServicesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClientConnectorServicesResponse) ProtoMessage() {}

func (x *ListClientConnectorServicesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClientConnectorServicesResponse.ProtoReflect.Descriptor instead.
func (*ListClientConnectorServicesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListClientConnectorServicesResponse) GetClientConnectorServices() []*ClientConnectorService {
	if x != nil {
		return x.ClientConnectorServices
	}
	return nil
}

func (x *ListClientConnectorServicesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListClientConnectorServicesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a ClientConnectorService.
type GetClientConnectorServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetClientConnectorServiceRequest) Reset() {
	*x = GetClientConnectorServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetClientConnectorServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClientConnectorServiceRequest) ProtoMessage() {}

func (x *GetClientConnectorServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClientConnectorServiceRequest.ProtoReflect.Descriptor instead.
func (*GetClientConnectorServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{3}
}

func (x *GetClientConnectorServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a ClientConnectorService.
type CreateClientConnectorServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. User-settable client connector service resource ID.
	//   - Must start with a letter.
	//   - Must contain between 4-63 characters from `/[a-z][0-9]-/`.
	//   - Must end with a number or a letter.
	//
	// A random system generated name will be assigned
	// if not specified by the user.
	ClientConnectorServiceId string `protobuf:"bytes,2,opt,name=client_connector_service_id,json=clientConnectorServiceId,proto3" json:"client_connector_service_id,omitempty"`
	// Required. The resource being created.
	ClientConnectorService *ClientConnectorService `protobuf:"bytes,3,opt,name=client_connector_service,json=clientConnectorService,proto3" json:"client_connector_service,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set, validates request by executing a dry-run which would not
	// alter the resource in any way.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateClientConnectorServiceRequest) Reset() {
	*x = CreateClientConnectorServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateClientConnectorServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateClientConnectorServiceRequest) ProtoMessage() {}

func (x *CreateClientConnectorServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateClientConnectorServiceRequest.ProtoReflect.Descriptor instead.
func (*CreateClientConnectorServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateClientConnectorServiceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateClientConnectorServiceRequest) GetClientConnectorServiceId() string {
	if x != nil {
		return x.ClientConnectorServiceId
	}
	return ""
}

func (x *CreateClientConnectorServiceRequest) GetClientConnectorService() *ClientConnectorService {
	if x != nil {
		return x.ClientConnectorService
	}
	return nil
}

func (x *CreateClientConnectorServiceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateClientConnectorServiceRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Message for updating a ClientConnectorService
type UpdateClientConnectorServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// ClientConnectorService resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	//
	// Mutable fields: display_name.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated.
	ClientConnectorService *ClientConnectorService `protobuf:"bytes,2,opt,name=client_connector_service,json=clientConnectorService,proto3" json:"client_connector_service,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set, validates request by executing a dry-run which would not
	// alter the resource in any way.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. If set as true, will create the resource if it is not found.
	AllowMissing bool `protobuf:"varint,5,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateClientConnectorServiceRequest) Reset() {
	*x = UpdateClientConnectorServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateClientConnectorServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateClientConnectorServiceRequest) ProtoMessage() {}

func (x *UpdateClientConnectorServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateClientConnectorServiceRequest.ProtoReflect.Descriptor instead.
func (*UpdateClientConnectorServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateClientConnectorServiceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateClientConnectorServiceRequest) GetClientConnectorService() *ClientConnectorService {
	if x != nil {
		return x.ClientConnectorService
	}
	return nil
}

func (x *UpdateClientConnectorServiceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateClientConnectorServiceRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateClientConnectorServiceRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Message for deleting a ClientConnectorService.
type DeleteClientConnectorServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set, validates request by executing a dry-run which would not
	// alter the resource in any way.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *DeleteClientConnectorServiceRequest) Reset() {
	*x = DeleteClientConnectorServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteClientConnectorServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteClientConnectorServiceRequest) ProtoMessage() {}

func (x *DeleteClientConnectorServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteClientConnectorServiceRequest.ProtoReflect.Descriptor instead.
func (*DeleteClientConnectorServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteClientConnectorServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteClientConnectorServiceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteClientConnectorServiceRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Represents the metadata of the long-running operation.
type ClientConnectorServiceOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *ClientConnectorServiceOperationMetadata) Reset() {
	*x = ClientConnectorServiceOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientConnectorServiceOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientConnectorServiceOperationMetadata) ProtoMessage() {}

func (x *ClientConnectorServiceOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientConnectorServiceOperationMetadata.ProtoReflect.Descriptor instead.
func (*ClientConnectorServiceOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{7}
}

func (x *ClientConnectorServiceOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ClientConnectorServiceOperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ClientConnectorServiceOperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *ClientConnectorServiceOperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *ClientConnectorServiceOperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *ClientConnectorServiceOperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *ClientConnectorServiceOperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Settings of how to connect to the ClientGateway.
// One of the following options should be set.
type ClientConnectorService_Ingress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to IngressConfig:
	//
	//	*ClientConnectorService_Ingress_Config_
	IngressConfig isClientConnectorService_Ingress_IngressConfig `protobuf_oneof:"ingress_config"`
}

func (x *ClientConnectorService_Ingress) Reset() {
	*x = ClientConnectorService_Ingress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientConnectorService_Ingress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientConnectorService_Ingress) ProtoMessage() {}

func (x *ClientConnectorService_Ingress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientConnectorService_Ingress.ProtoReflect.Descriptor instead.
func (*ClientConnectorService_Ingress) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{0, 0}
}

func (m *ClientConnectorService_Ingress) GetIngressConfig() isClientConnectorService_Ingress_IngressConfig {
	if m != nil {
		return m.IngressConfig
	}
	return nil
}

func (x *ClientConnectorService_Ingress) GetConfig() *ClientConnectorService_Ingress_Config {
	if x, ok := x.GetIngressConfig().(*ClientConnectorService_Ingress_Config_); ok {
		return x.Config
	}
	return nil
}

type isClientConnectorService_Ingress_IngressConfig interface {
	isClientConnectorService_Ingress_IngressConfig()
}

type ClientConnectorService_Ingress_Config_ struct {
	// The basic ingress config for ClientGateways.
	Config *ClientConnectorService_Ingress_Config `protobuf:"bytes,1,opt,name=config,proto3,oneof"`
}

func (*ClientConnectorService_Ingress_Config_) isClientConnectorService_Ingress_IngressConfig() {}

// The details of the egress info. One of the following options should be set.
type ClientConnectorService_Egress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to DestinationType:
	//
	//	*ClientConnectorService_Egress_PeeredVpc_
	DestinationType isClientConnectorService_Egress_DestinationType `protobuf_oneof:"destination_type"`
}

func (x *ClientConnectorService_Egress) Reset() {
	*x = ClientConnectorService_Egress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientConnectorService_Egress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientConnectorService_Egress) ProtoMessage() {}

func (x *ClientConnectorService_Egress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientConnectorService_Egress.ProtoReflect.Descriptor instead.
func (*ClientConnectorService_Egress) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{0, 1}
}

func (m *ClientConnectorService_Egress) GetDestinationType() isClientConnectorService_Egress_DestinationType {
	if m != nil {
		return m.DestinationType
	}
	return nil
}

func (x *ClientConnectorService_Egress) GetPeeredVpc() *ClientConnectorService_Egress_PeeredVpc {
	if x, ok := x.GetDestinationType().(*ClientConnectorService_Egress_PeeredVpc_); ok {
		return x.PeeredVpc
	}
	return nil
}

type isClientConnectorService_Egress_DestinationType interface {
	isClientConnectorService_Egress_DestinationType()
}

type ClientConnectorService_Egress_PeeredVpc_ struct {
	// A VPC from the consumer project.
	PeeredVpc *ClientConnectorService_Egress_PeeredVpc `protobuf:"bytes,1,opt,name=peered_vpc,json=peeredVpc,proto3,oneof"`
}

func (*ClientConnectorService_Egress_PeeredVpc_) isClientConnectorService_Egress_DestinationType() {}

// The basic ingress config for ClientGateways.
type ClientConnectorService_Ingress_Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The transport protocol used between the client and
	// the server.
	TransportProtocol ClientConnectorService_Ingress_Config_TransportProtocol `protobuf:"varint,1,opt,name=transport_protocol,json=transportProtocol,proto3,enum=google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService_Ingress_Config_TransportProtocol" json:"transport_protocol,omitempty"`
	// Required. The settings used to configure basic ClientGateways.
	DestinationRoutes []*ClientConnectorService_Ingress_Config_DestinationRoute `protobuf:"bytes,2,rep,name=destination_routes,json=destinationRoutes,proto3" json:"destination_routes,omitempty"`
}

func (x *ClientConnectorService_Ingress_Config) Reset() {
	*x = ClientConnectorService_Ingress_Config{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientConnectorService_Ingress_Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientConnectorService_Ingress_Config) ProtoMessage() {}

func (x *ClientConnectorService_Ingress_Config) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientConnectorService_Ingress_Config.ProtoReflect.Descriptor instead.
func (*ClientConnectorService_Ingress_Config) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *ClientConnectorService_Ingress_Config) GetTransportProtocol() ClientConnectorService_Ingress_Config_TransportProtocol {
	if x != nil {
		return x.TransportProtocol
	}
	return ClientConnectorService_Ingress_Config_TRANSPORT_PROTOCOL_UNSPECIFIED
}

func (x *ClientConnectorService_Ingress_Config) GetDestinationRoutes() []*ClientConnectorService_Ingress_Config_DestinationRoute {
	if x != nil {
		return x.DestinationRoutes
	}
	return nil
}

// The setting used to configure ClientGateways.
// It is adding routes to the client's routing table
// after the connection is established.
type ClientConnectorService_Ingress_Config_DestinationRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The network address of the subnet
	// for which the packet is routed to the ClientGateway.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Required. The network mask of the subnet
	// for which the packet is routed to the ClientGateway.
	Netmask string `protobuf:"bytes,2,opt,name=netmask,proto3" json:"netmask,omitempty"`
}

func (x *ClientConnectorService_Ingress_Config_DestinationRoute) Reset() {
	*x = ClientConnectorService_Ingress_Config_DestinationRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientConnectorService_Ingress_Config_DestinationRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientConnectorService_Ingress_Config_DestinationRoute) ProtoMessage() {}

func (x *ClientConnectorService_Ingress_Config_DestinationRoute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientConnectorService_Ingress_Config_DestinationRoute.ProtoReflect.Descriptor instead.
func (*ClientConnectorService_Ingress_Config_DestinationRoute) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{0, 0, 0, 0}
}

func (x *ClientConnectorService_Ingress_Config_DestinationRoute) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *ClientConnectorService_Ingress_Config_DestinationRoute) GetNetmask() string {
	if x != nil {
		return x.Netmask
	}
	return ""
}

// The peered VPC owned by the consumer project.
type ClientConnectorService_Egress_PeeredVpc struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the peered VPC owned by the consumer project.
	NetworkVpc string `protobuf:"bytes,1,opt,name=network_vpc,json=networkVpc,proto3" json:"network_vpc,omitempty"`
}

func (x *ClientConnectorService_Egress_PeeredVpc) Reset() {
	*x = ClientConnectorService_Egress_PeeredVpc{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientConnectorService_Egress_PeeredVpc) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientConnectorService_Egress_PeeredVpc) ProtoMessage() {}

func (x *ClientConnectorService_Egress_PeeredVpc) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientConnectorService_Egress_PeeredVpc.ProtoReflect.Descriptor instead.
func (*ClientConnectorService_Egress_PeeredVpc) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *ClientConnectorService_Egress_PeeredVpc) GetNetworkVpc() string {
	if x != nil {
		return x.NetworkVpc
	}
	return ""
}

var File_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto protoreflect.FileDescriptor

var file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDesc = []byte{
	0x0a, 0x5a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x32, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e,
	0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf6, 0x0c, 0x0a, 0x16,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x71, 0x0a, 0x07, 0x69,
	0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f,
	0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x6e,
	0x0a, 0x06, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65,
	0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x6b,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79,
	0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0xf5, 0x04, 0x0a, 0x07,
	0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x73, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xe2, 0x03, 0x0a,
	0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xa2, 0x01, 0x0a, 0x12, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x6b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x9e, 0x01, 0x0a,
	0x12, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x6f, 0x75,
	0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x6a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x1a, 0x50, 0x0a,
	0x10, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x1d, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x6d, 0x61, 0x73, 0x6b, 0x22,
	0x40, 0x0a, 0x11, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x22, 0x0a, 0x1e, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x50, 0x4f, 0x52,
	0x54, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x43, 0x50, 0x10,
	0x01, 0x42, 0x10, 0x0a, 0x0e, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x1a, 0xcd, 0x01, 0x0a, 0x06, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x7c,
	0x0a, 0x0a, 0x70, 0x65, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x76, 0x70, 0x63, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x45,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x65, 0x64, 0x56, 0x70, 0x63, 0x48,
	0x00, 0x52, 0x09, 0x70, 0x65, 0x65, 0x72, 0x65, 0x64, 0x56, 0x70, 0x63, 0x1a, 0x31, 0x0a, 0x09,
	0x50, 0x65, 0x65, 0x72, 0x65, 0x64, 0x56, 0x70, 0x63, 0x12, 0x24, 0x0a, 0x0b, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x76, 0x70, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x56, 0x70, 0x63, 0x42,
	0x12, 0x0a, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x22, 0x6a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0b, 0x0a,
	0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x4f,
	0x57, 0x4e, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x06, 0x3a,
	0x92, 0x01, 0xea, 0x41, 0x8e, 0x01, 0x0a, 0x30, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x5a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x7d, 0x22, 0xf9, 0x01, 0x0a, 0x22, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x32, 0x12, 0x30, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x22, 0xf8, 0x01, 0x0a, 0x23, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x86, 0x01, 0x0a, 0x19, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f,
	0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x17, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x70, 0x0a, 0x20, 0x47,
	0x65, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x95, 0x03,
	0x0a, 0x23, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x62,
	0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x42, 0x0a, 0x1b, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x18, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x89, 0x01, 0x0a, 0x18,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65,
	0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x16, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xeb, 0x02, 0x0a, 0x23, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12,
	0x89, 0x01, 0x0a, 0x18, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x16, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12,
	0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x22, 0xc1, 0x01, 0x0a, 0x23, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x32, 0x0a, 0x30, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a,
	0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xeb, 0x02, 0x0a, 0x27, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x32, 0xbb, 0x0d, 0x0a, 0x1e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x9c, 0x02, 0x0a, 0x1b, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x89, 0x02, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e,
	0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xf8, 0x02, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdf, 0x01, 0xca,
	0x41, 0x41, 0x0a, 0x16, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x27, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x3b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x3a, 0x18, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0xfa,
	0x02, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe1, 0x01, 0xca, 0x41, 0x41, 0x0a, 0x16, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x27, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x24, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x70, 0x3a, 0x18, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x32, 0x54, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa6, 0x02, 0x0a, 0x1c,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x57, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f,
	0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8d, 0x01, 0xca, 0x41, 0x40, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x27, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x2a, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x42, 0xf4, 0x02, 0x0a, 0x36, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x23,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x70, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x65, 0x79, 0x6f, 0x6e,
	0x64, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x32, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x43, 0x6f, 0x72,
	0x70, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x32, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x65, 0x79, 0x6f,
	0x6e, 0x64, 0x43, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5c, 0x56,
	0x31, 0xea, 0x02, 0x36, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x42, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x43, 0x6f, 0x72, 0x70, 0x3a, 0x3a, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescOnce sync.Once
	file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescData = file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDesc
)

func file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescGZIP() []byte {
	file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescData)
	})
	return file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDescData
}

var file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_goTypes = []interface{}{
	(ClientConnectorService_State)(0),                              // 0: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.State
	(ClientConnectorService_Ingress_Config_TransportProtocol)(0),   // 1: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Ingress.Config.TransportProtocol
	(*ClientConnectorService)(nil),                                 // 2: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService
	(*ListClientConnectorServicesRequest)(nil),                     // 3: google.cloud.beyondcorp.clientconnectorservices.v1.ListClientConnectorServicesRequest
	(*ListClientConnectorServicesResponse)(nil),                    // 4: google.cloud.beyondcorp.clientconnectorservices.v1.ListClientConnectorServicesResponse
	(*GetClientConnectorServiceRequest)(nil),                       // 5: google.cloud.beyondcorp.clientconnectorservices.v1.GetClientConnectorServiceRequest
	(*CreateClientConnectorServiceRequest)(nil),                    // 6: google.cloud.beyondcorp.clientconnectorservices.v1.CreateClientConnectorServiceRequest
	(*UpdateClientConnectorServiceRequest)(nil),                    // 7: google.cloud.beyondcorp.clientconnectorservices.v1.UpdateClientConnectorServiceRequest
	(*DeleteClientConnectorServiceRequest)(nil),                    // 8: google.cloud.beyondcorp.clientconnectorservices.v1.DeleteClientConnectorServiceRequest
	(*ClientConnectorServiceOperationMetadata)(nil),                // 9: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServiceOperationMetadata
	(*ClientConnectorService_Ingress)(nil),                         // 10: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Ingress
	(*ClientConnectorService_Egress)(nil),                          // 11: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Egress
	(*ClientConnectorService_Ingress_Config)(nil),                  // 12: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Ingress.Config
	(*ClientConnectorService_Ingress_Config_DestinationRoute)(nil), // 13: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Ingress.Config.DestinationRoute
	(*ClientConnectorService_Egress_PeeredVpc)(nil),                // 14: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Egress.PeeredVpc
	(*timestamppb.Timestamp)(nil),                                  // 15: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                                  // 16: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),                                // 17: google.longrunning.Operation
}
var file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_depIdxs = []int32{
	15, // 0: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.create_time:type_name -> google.protobuf.Timestamp
	15, // 1: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.update_time:type_name -> google.protobuf.Timestamp
	10, // 2: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.ingress:type_name -> google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Ingress
	11, // 3: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.egress:type_name -> google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Egress
	0,  // 4: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.state:type_name -> google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.State
	2,  // 5: google.cloud.beyondcorp.clientconnectorservices.v1.ListClientConnectorServicesResponse.client_connector_services:type_name -> google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService
	2,  // 6: google.cloud.beyondcorp.clientconnectorservices.v1.CreateClientConnectorServiceRequest.client_connector_service:type_name -> google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService
	16, // 7: google.cloud.beyondcorp.clientconnectorservices.v1.UpdateClientConnectorServiceRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 8: google.cloud.beyondcorp.clientconnectorservices.v1.UpdateClientConnectorServiceRequest.client_connector_service:type_name -> google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService
	15, // 9: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServiceOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	15, // 10: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServiceOperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	12, // 11: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Ingress.config:type_name -> google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Ingress.Config
	14, // 12: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Egress.peered_vpc:type_name -> google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Egress.PeeredVpc
	1,  // 13: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Ingress.Config.transport_protocol:type_name -> google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Ingress.Config.TransportProtocol
	13, // 14: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Ingress.Config.destination_routes:type_name -> google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService.Ingress.Config.DestinationRoute
	3,  // 15: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService.ListClientConnectorServices:input_type -> google.cloud.beyondcorp.clientconnectorservices.v1.ListClientConnectorServicesRequest
	5,  // 16: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService.GetClientConnectorService:input_type -> google.cloud.beyondcorp.clientconnectorservices.v1.GetClientConnectorServiceRequest
	6,  // 17: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService.CreateClientConnectorService:input_type -> google.cloud.beyondcorp.clientconnectorservices.v1.CreateClientConnectorServiceRequest
	7,  // 18: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService.UpdateClientConnectorService:input_type -> google.cloud.beyondcorp.clientconnectorservices.v1.UpdateClientConnectorServiceRequest
	8,  // 19: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService.DeleteClientConnectorService:input_type -> google.cloud.beyondcorp.clientconnectorservices.v1.DeleteClientConnectorServiceRequest
	4,  // 20: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService.ListClientConnectorServices:output_type -> google.cloud.beyondcorp.clientconnectorservices.v1.ListClientConnectorServicesResponse
	2,  // 21: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService.GetClientConnectorService:output_type -> google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorService
	17, // 22: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService.CreateClientConnectorService:output_type -> google.longrunning.Operation
	17, // 23: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService.UpdateClientConnectorService:output_type -> google.longrunning.Operation
	17, // 24: google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService.DeleteClientConnectorService:output_type -> google.longrunning.Operation
	20, // [20:25] is the sub-list for method output_type
	15, // [15:20] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() {
	file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_init()
}
func file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_init() {
	if File_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientConnectorService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListClientConnectorServicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListClientConnectorServicesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetClientConnectorServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateClientConnectorServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateClientConnectorServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteClientConnectorServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientConnectorServiceOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientConnectorService_Ingress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientConnectorService_Egress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientConnectorService_Ingress_Config); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientConnectorService_Ingress_Config_DestinationRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientConnectorService_Egress_PeeredVpc); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*ClientConnectorService_Ingress_Config_)(nil),
	}
	file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*ClientConnectorService_Egress_PeeredVpc_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_msgTypes,
	}.Build()
	File_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto = out.File
	file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_rawDesc = nil
	file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_goTypes = nil
	file_google_cloud_beyondcorp_clientconnectorservices_v1_client_connector_services_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ClientConnectorServicesServiceClient is the client API for ClientConnectorServicesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ClientConnectorServicesServiceClient interface {
	// Lists ClientConnectorServices in a given project and location.
	ListClientConnectorServices(ctx context.Context, in *ListClientConnectorServicesRequest, opts ...grpc.CallOption) (*ListClientConnectorServicesResponse, error)
	// Gets details of a single ClientConnectorService.
	GetClientConnectorService(ctx context.Context, in *GetClientConnectorServiceRequest, opts ...grpc.CallOption) (*ClientConnectorService, error)
	// Creates a new ClientConnectorService in a given project and location.
	CreateClientConnectorService(ctx context.Context, in *CreateClientConnectorServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ClientConnectorService.
	UpdateClientConnectorService(ctx context.Context, in *UpdateClientConnectorServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ClientConnectorService.
	DeleteClientConnectorService(ctx context.Context, in *DeleteClientConnectorServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type clientConnectorServicesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewClientConnectorServicesServiceClient(cc grpc.ClientConnInterface) ClientConnectorServicesServiceClient {
	return &clientConnectorServicesServiceClient{cc}
}

func (c *clientConnectorServicesServiceClient) ListClientConnectorServices(ctx context.Context, in *ListClientConnectorServicesRequest, opts ...grpc.CallOption) (*ListClientConnectorServicesResponse, error) {
	out := new(ListClientConnectorServicesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/ListClientConnectorServices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientConnectorServicesServiceClient) GetClientConnectorService(ctx context.Context, in *GetClientConnectorServiceRequest, opts ...grpc.CallOption) (*ClientConnectorService, error) {
	out := new(ClientConnectorService)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/GetClientConnectorService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientConnectorServicesServiceClient) CreateClientConnectorService(ctx context.Context, in *CreateClientConnectorServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/CreateClientConnectorService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientConnectorServicesServiceClient) UpdateClientConnectorService(ctx context.Context, in *UpdateClientConnectorServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/UpdateClientConnectorService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clientConnectorServicesServiceClient) DeleteClientConnectorService(ctx context.Context, in *DeleteClientConnectorServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/DeleteClientConnectorService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClientConnectorServicesServiceServer is the server API for ClientConnectorServicesService service.
type ClientConnectorServicesServiceServer interface {
	// Lists ClientConnectorServices in a given project and location.
	ListClientConnectorServices(context.Context, *ListClientConnectorServicesRequest) (*ListClientConnectorServicesResponse, error)
	// Gets details of a single ClientConnectorService.
	GetClientConnectorService(context.Context, *GetClientConnectorServiceRequest) (*ClientConnectorService, error)
	// Creates a new ClientConnectorService in a given project and location.
	CreateClientConnectorService(context.Context, *CreateClientConnectorServiceRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ClientConnectorService.
	UpdateClientConnectorService(context.Context, *UpdateClientConnectorServiceRequest) (*longrunningpb.Operation, error)
	// Deletes a single ClientConnectorService.
	DeleteClientConnectorService(context.Context, *DeleteClientConnectorServiceRequest) (*longrunningpb.Operation, error)
}

// UnimplementedClientConnectorServicesServiceServer can be embedded to have forward compatible implementations.
type UnimplementedClientConnectorServicesServiceServer struct {
}

func (*UnimplementedClientConnectorServicesServiceServer) ListClientConnectorServices(context.Context, *ListClientConnectorServicesRequest) (*ListClientConnectorServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClientConnectorServices not implemented")
}
func (*UnimplementedClientConnectorServicesServiceServer) GetClientConnectorService(context.Context, *GetClientConnectorServiceRequest) (*ClientConnectorService, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetClientConnectorService not implemented")
}
func (*UnimplementedClientConnectorServicesServiceServer) CreateClientConnectorService(context.Context, *CreateClientConnectorServiceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateClientConnectorService not implemented")
}
func (*UnimplementedClientConnectorServicesServiceServer) UpdateClientConnectorService(context.Context, *UpdateClientConnectorServiceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateClientConnectorService not implemented")
}
func (*UnimplementedClientConnectorServicesServiceServer) DeleteClientConnectorService(context.Context, *DeleteClientConnectorServiceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteClientConnectorService not implemented")
}

func RegisterClientConnectorServicesServiceServer(s *grpc.Server, srv ClientConnectorServicesServiceServer) {
	s.RegisterService(&_ClientConnectorServicesService_serviceDesc, srv)
}

func _ClientConnectorServicesService_ListClientConnectorServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClientConnectorServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientConnectorServicesServiceServer).ListClientConnectorServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/ListClientConnectorServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientConnectorServicesServiceServer).ListClientConnectorServices(ctx, req.(*ListClientConnectorServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientConnectorServicesService_GetClientConnectorService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClientConnectorServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientConnectorServicesServiceServer).GetClientConnectorService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/GetClientConnectorService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientConnectorServicesServiceServer).GetClientConnectorService(ctx, req.(*GetClientConnectorServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientConnectorServicesService_CreateClientConnectorService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClientConnectorServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientConnectorServicesServiceServer).CreateClientConnectorService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/CreateClientConnectorService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientConnectorServicesServiceServer).CreateClientConnectorService(ctx, req.(*CreateClientConnectorServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientConnectorServicesService_UpdateClientConnectorService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClientConnectorServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientConnectorServicesServiceServer).UpdateClientConnectorService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/UpdateClientConnectorService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientConnectorServicesServiceServer).UpdateClientConnectorService(ctx, req.(*UpdateClientConnectorServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClientConnectorServicesService_DeleteClientConnectorService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClientConnectorServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClientConnectorServicesServiceServer).DeleteClientConnectorService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService/DeleteClientConnectorService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClientConnectorServicesServiceServer).DeleteClientConnectorService(ctx, req.(*DeleteClientConnectorServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClientConnectorServicesService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.beyondcorp.clientconnectorservices.v1.ClientConnectorServicesService",
	HandlerType: (*ClientConnectorServicesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListClientConnectorServices",
			Handler:    _ClientConnectorServicesService_ListClientConnectorServices_Handler,
		},
		{
			MethodName: "GetClientConnectorService",
			Handler:    _ClientConnectorServicesService_GetClientConnectorService_Handler,
		},
		{
			MethodName: "CreateClientConnectorService",
			Handler:    _ClientConnectorServicesService_CreateClientConnectorService_Handler,
		},
		{
			MethodName: "UpdateClientConnectorService",
			Handler:    _ClientConnectorServicesService_UpdateClientConnectorService_Handler,
		},
		{
			MethodName: "DeleteClientConnectorService",
			Handler:    _ClientConnectorServicesService_DeleteClientConnectorService_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/beyondcorp/clientconnectorservices/v1/client_connector_services_service.proto",
}
