﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/awstransfer/Transfer_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Transfer {
namespace Model {
class TestIdentityProviderResult {
 public:
  AWS_TRANSFER_API TestIdentityProviderResult() = default;
  AWS_TRANSFER_API TestIdentityProviderResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_TRANSFER_API TestIdentityProviderResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The response that is returned from your API Gateway or your Lambda
   * function.</p>
   */
  inline const Aws::String& GetResponse() const { return m_response; }
  template <typename ResponseT = Aws::String>
  void SetResponse(ResponseT&& value) {
    m_responseHasBeenSet = true;
    m_response = std::forward<ResponseT>(value);
  }
  template <typename ResponseT = Aws::String>
  TestIdentityProviderResult& WithResponse(ResponseT&& value) {
    SetResponse(std::forward<ResponseT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The HTTP status code that is the response from your API Gateway or your
   * Lambda function.</p>
   */
  inline int GetStatusCode() const { return m_statusCode; }
  inline void SetStatusCode(int value) {
    m_statusCodeHasBeenSet = true;
    m_statusCode = value;
  }
  inline TestIdentityProviderResult& WithStatusCode(int value) {
    SetStatusCode(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A message that indicates whether the test was successful or not.</p>
   * <p>If an empty string is returned, the most likely cause is that the
   * authentication failed due to an incorrect username or password.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  TestIdentityProviderResult& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The endpoint of the service used to authenticate a user.</p>
   */
  inline const Aws::String& GetUrl() const { return m_url; }
  template <typename UrlT = Aws::String>
  void SetUrl(UrlT&& value) {
    m_urlHasBeenSet = true;
    m_url = std::forward<UrlT>(value);
  }
  template <typename UrlT = Aws::String>
  TestIdentityProviderResult& WithUrl(UrlT&& value) {
    SetUrl(std::forward<UrlT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  TestIdentityProviderResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_response;
  bool m_responseHasBeenSet = false;

  int m_statusCode{0};
  bool m_statusCodeHasBeenSet = false;

  Aws::String m_message;
  bool m_messageHasBeenSet = false;

  Aws::String m_url;
  bool m_urlHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Transfer
}  // namespace Aws
