﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/autoscaling/model/EnterStandbyResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/logging/LogMacros.h>
#include <aws/core/utils/xml/XmlSerializer.h>

#include <utility>

using namespace Aws::AutoScaling::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils::Logging;
using namespace Aws::Utils;
using namespace Aws;

EnterStandbyResult::EnterStandbyResult(const Aws::AmazonWebServiceResult<XmlDocument>& result) { *this = result; }

EnterStandbyResult& EnterStandbyResult::operator=(const Aws::AmazonWebServiceResult<XmlDocument>& result) {
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode rootNode = xmlDocument.GetRootElement();
  XmlNode resultNode = rootNode;
  if (!rootNode.IsNull() && (rootNode.GetName() != "EnterStandbyResult")) {
    resultNode = rootNode.FirstChild("EnterStandbyResult");
  }

  if (!resultNode.IsNull()) {
    XmlNode activitiesNode = resultNode.FirstChild("Activities");
    if (!activitiesNode.IsNull()) {
      XmlNode activitiesMember = activitiesNode.FirstChild("member");
      m_activitiesHasBeenSet = !activitiesMember.IsNull();
      while (!activitiesMember.IsNull()) {
        m_activities.push_back(activitiesMember);
        activitiesMember = activitiesMember.NextNode("member");
      }

      m_activitiesHasBeenSet = true;
    }
  }

  if (!rootNode.IsNull()) {
    XmlNode responseMetadataNode = rootNode.FirstChild("ResponseMetadata");
    m_responseMetadata = responseMetadataNode;
    m_responseMetadataHasBeenSet = true;
    AWS_LOGSTREAM_DEBUG("Aws::AutoScaling::Model::EnterStandbyResult", "x-amzn-request-id: " << m_responseMetadata.GetRequestId());
  }
  return *this;
}
