﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/accessanalyzer/model/ListFindingsV2Request.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::AccessAnalyzer::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String ListFindingsV2Request::SerializePayload() const {
  JsonValue payload;

  if (m_analyzerArnHasBeenSet) {
    payload.WithString("analyzerArn", m_analyzerArn);
  }

  if (m_filterHasBeenSet) {
    JsonValue filterJsonMap;
    for (auto& filterItem : m_filter) {
      filterJsonMap.WithObject(filterItem.first, filterItem.second.Jsonize());
    }
    payload.WithObject("filter", std::move(filterJsonMap));
  }

  if (m_maxResultsHasBeenSet) {
    payload.WithInteger("maxResults", m_maxResults);
  }

  if (m_nextTokenHasBeenSet) {
    payload.WithString("nextToken", m_nextToken);
  }

  if (m_sortHasBeenSet) {
    payload.WithObject("sort", m_sort.Jsonize());
  }

  return payload.View().WriteReadable();
}
