/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.conversion;

import java.util.HashMap;
import java.util.Map;
import org.mvel.ConversionException;
import org.mvel.ConversionHandler;
import org.mvel.conversion.Converter;

public class BooleanCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();

    @Override
    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + Boolean.class.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    @Override
    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }

    static {
        CNV.put(String.class, new Converter(){

            @Override
            public Object convert(Object o) {
                return !((String)o).equalsIgnoreCase("false") && !((String)o).equalsIgnoreCase("no") && !((String)o).equalsIgnoreCase("off") && !"0".equals(o) && !"".equals(o);
            }
        });
        CNV.put(Object.class, new Converter(){

            @Override
            public Object convert(Object o) {
                return ((Converter)CNV.get(String.class)).convert(String.valueOf(o));
            }
        });
        CNV.put(Boolean.class, new Converter(){

            @Override
            public Object convert(Object o) {
                return o;
            }
        });
        CNV.put(Integer.class, new Converter(){

            @Override
            public Boolean convert(Object o) {
                return (Integer)o > 0;
            }
        });
        CNV.put(Float.class, new Converter(){

            @Override
            public Boolean convert(Object o) {
                return ((Float)o).floatValue() > 0.0f;
            }
        });
        CNV.put(Double.class, new Converter(){

            @Override
            public Boolean convert(Object o) {
                return (Double)o > 0.0;
            }
        });
        CNV.put(Short.class, new Converter(){

            @Override
            public Boolean convert(Object o) {
                return (Short)o > 0;
            }
        });
        CNV.put(Long.class, new Converter(){

            @Override
            public Boolean convert(Object o) {
                return (Long)o > 0L;
            }
        });
        CNV.put(Boolean.TYPE, new Converter(){

            @Override
            public Boolean convert(Object o) {
                return (boolean)((Boolean)o);
            }
        });
    }
}

