// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature
// RUN: %clang_cc1 -triple arm64-none-linux-gnu -target-feature +neon \
// RUN:  -disable-O0-optnone -emit-llvm -o - %s | opt -S -passes=mem2reg | FileCheck %s

// REQUIRES: aarch64-registered-target || arm-registered-target

#include <arm_neon.h>

// CHECK-LABEL: define {{[^@]+}}@test_vcvtxd_f32_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTXD_F32_F64_I:%.*]] = call float @llvm.aarch64.sisd.fcvtxn(double [[A]])
// CHECK-NEXT:    ret float [[VCVTXD_F32_F64_I]]
//
float32_t test_vcvtxd_f32_f64(float64_t a) {
  return (float32_t)vcvtxd_f32_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtas_s32_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTAS_S32_F32_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtas.i32.f32(float [[A]])
// CHECK-NEXT:    ret i32 [[VCVTAS_S32_F32_I]]
//
int32_t test_vcvtas_s32_f32(float32_t a) {
  return (int32_t)vcvtas_s32_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtad_s64_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTAD_S64_F64_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtas.i64.f64(double [[A]])
// CHECK-NEXT:    ret i64 [[VCVTAD_S64_F64_I]]
//
int64_t test_vcvtad_s64_f64(float64_t a) {
  return (int64_t)vcvtad_s64_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtas_s64_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTAS_S64_F32_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtas.i64.f32(float [[A]])
// CHECK-NEXT:    ret i64 [[VCVTAS_S64_F32_I]]
//
int64_t test_vcvtas_s64_f32(float32_t a) {
  return (int64_t)vcvtas_s64_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtad_s32_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTAD_S32_F64_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtas.i32.f64(double [[A]])
// CHECK-NEXT:    ret i32 [[VCVTAD_S32_F64_I]]
//
int32_t test_vcvtad_s32_f64(float64_t a) {
  return (int32_t)vcvtad_s32_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtas_u32_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTAS_U32_F32_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtau.i32.f32(float [[A]])
// CHECK-NEXT:    ret i32 [[VCVTAS_U32_F32_I]]
//
uint32_t test_vcvtas_u32_f32(float32_t a) {
  return (uint32_t)vcvtas_u32_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtad_u64_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTAD_U64_F64_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtau.i64.f64(double [[A]])
// CHECK-NEXT:    ret i64 [[VCVTAD_U64_F64_I]]
//
uint64_t test_vcvtad_u64_f64(float64_t a) {
  return (uint64_t)vcvtad_u64_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtas_u64_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTAS_U64_F32_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtau.i64.f32(float [[A]])
// CHECK-NEXT:    ret i64 [[VCVTAS_U64_F32_I]]
//
uint64_t test_vcvtas_u64_f32(float32_t a) {
  return (uint64_t)vcvtas_u64_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtad_u32_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTAD_U32_F64_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtau.i32.f64(double [[A]])
// CHECK-NEXT:    ret i32 [[VCVTAD_U32_F64_I]]
//
uint32_t test_vcvtad_u32_f64(float64_t a) {
  return (uint32_t)vcvtad_u32_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtms_s32_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTMS_S32_F32_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtms.i32.f32(float [[A]])
// CHECK-NEXT:    ret i32 [[VCVTMS_S32_F32_I]]
//
int32_t test_vcvtms_s32_f32(float32_t a) {
  return (int32_t)vcvtms_s32_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtmd_s64_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTMD_S64_F64_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtms.i64.f64(double [[A]])
// CHECK-NEXT:    ret i64 [[VCVTMD_S64_F64_I]]
//
int64_t test_vcvtmd_s64_f64(float64_t a) {
  return (int64_t)vcvtmd_s64_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtms_s64_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTMS_S64_F32_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtms.i64.f32(float [[A]])
// CHECK-NEXT:    ret i64 [[VCVTMS_S64_F32_I]]
//
int64_t test_vcvtms_s64_f32(float32_t a) {
  return (int64_t)vcvtms_s64_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtmd_s32_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTMD_S32_F64_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtms.i32.f64(double [[A]])
// CHECK-NEXT:    ret i32 [[VCVTMD_S32_F64_I]]
//
int32_t test_vcvtmd_s32_f64(float64_t a) {
  return (int32_t)vcvtmd_s32_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtms_u32_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTMS_U32_F32_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtmu.i32.f32(float [[A]])
// CHECK-NEXT:    ret i32 [[VCVTMS_U32_F32_I]]
//
uint32_t test_vcvtms_u32_f32(float32_t a) {
  return (uint32_t)vcvtms_u32_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtmd_u64_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTMD_U64_F64_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtmu.i64.f64(double [[A]])
// CHECK-NEXT:    ret i64 [[VCVTMD_U64_F64_I]]
//
uint64_t test_vcvtmd_u64_f64(float64_t a) {
  return (uint64_t)vcvtmd_u64_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtms_u64_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTMS_U64_F32_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtmu.i64.f32(float [[A]])
// CHECK-NEXT:    ret i64 [[VCVTMS_U64_F32_I]]
//
uint64_t test_vcvtms_u64_f32(float32_t a) {
  return (uint64_t)vcvtms_u64_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtmd_u32_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTMD_U32_F64_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtmu.i32.f64(double [[A]])
// CHECK-NEXT:    ret i32 [[VCVTMD_U32_F64_I]]
//
uint32_t test_vcvtmd_u32_f64(float64_t a) {
  return (uint32_t)vcvtmd_u32_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtns_s32_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTNS_S32_F32_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtns.i32.f32(float [[A]])
// CHECK-NEXT:    ret i32 [[VCVTNS_S32_F32_I]]
//
int32_t test_vcvtns_s32_f32(float32_t a) {
  return (int32_t)vcvtns_s32_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtnd_s64_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTND_S64_F64_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtns.i64.f64(double [[A]])
// CHECK-NEXT:    ret i64 [[VCVTND_S64_F64_I]]
//
int64_t test_vcvtnd_s64_f64(float64_t a) {
  return (int64_t)vcvtnd_s64_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtns_s64_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTNS_S64_F32_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtns.i64.f32(float [[A]])
// CHECK-NEXT:    ret i64 [[VCVTNS_S64_F32_I]]
//
int64_t test_vcvtns_s64_f32(float32_t a) {
  return (int64_t)vcvtns_s64_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtnd_s32_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTND_S32_F64_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtns.i32.f64(double [[A]])
// CHECK-NEXT:    ret i32 [[VCVTND_S32_F64_I]]
//
int32_t test_vcvtnd_s32_f64(float64_t a) {
  return (int32_t)vcvtnd_s32_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtns_u32_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTNS_U32_F32_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtnu.i32.f32(float [[A]])
// CHECK-NEXT:    ret i32 [[VCVTNS_U32_F32_I]]
//
uint32_t test_vcvtns_u32_f32(float32_t a) {
  return (uint32_t)vcvtns_u32_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtnd_u64_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTND_U64_F64_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtnu.i64.f64(double [[A]])
// CHECK-NEXT:    ret i64 [[VCVTND_U64_F64_I]]
//
uint64_t test_vcvtnd_u64_f64(float64_t a) {
  return (uint64_t)vcvtnd_u64_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtns_u64_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTNS_U64_F32_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtnu.i64.f32(float [[A]])
// CHECK-NEXT:    ret i64 [[VCVTNS_U64_F32_I]]
//
uint64_t test_vcvtns_u64_f32(float32_t a) {
  return (uint64_t)vcvtns_u64_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtnd_u32_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTND_U32_F64_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtnu.i32.f64(double [[A]])
// CHECK-NEXT:    ret i32 [[VCVTND_U32_F64_I]]
//
uint32_t test_vcvtnd_u32_f64(float64_t a) {
  return (uint32_t)vcvtnd_u32_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtps_s32_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTPS_S32_F32_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtps.i32.f32(float [[A]])
// CHECK-NEXT:    ret i32 [[VCVTPS_S32_F32_I]]
//
int32_t test_vcvtps_s32_f32(float32_t a) {
  return (int32_t)vcvtps_s32_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtpd_s64_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTPD_S64_F64_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtps.i64.f64(double [[A]])
// CHECK-NEXT:    ret i64 [[VCVTPD_S64_F64_I]]
//
int64_t test_vcvtpd_s64_f64(float64_t a) {
  return (int64_t)vcvtpd_s64_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtps_s64_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTPS_S64_F32_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtps.i64.f32(float [[A]])
// CHECK-NEXT:    ret i64 [[VCVTPS_S64_F32_I]]
//
int64_t test_vcvtps_s64_f32(float32_t a) {
  return (int64_t)vcvtps_s64_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtpd_s32_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTPD_S32_F64_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtps.i32.f64(double [[A]])
// CHECK-NEXT:    ret i32 [[VCVTPD_S32_F64_I]]
//
int32_t test_vcvtpd_s32_f64(float64_t a) {
  return (int32_t)vcvtpd_s32_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtps_u32_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTPS_U32_F32_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtpu.i32.f32(float [[A]])
// CHECK-NEXT:    ret i32 [[VCVTPS_U32_F32_I]]
//
uint32_t test_vcvtps_u32_f32(float32_t a) {
  return (uint32_t)vcvtps_u32_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtpd_u64_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTPD_U64_F64_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtpu.i64.f64(double [[A]])
// CHECK-NEXT:    ret i64 [[VCVTPD_U64_F64_I]]
//
uint64_t test_vcvtpd_u64_f64(float64_t a) {
  return (uint64_t)vcvtpd_u64_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtps_u64_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTPS_U64_F32_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtpu.i64.f32(float [[A]])
// CHECK-NEXT:    ret i64 [[VCVTPS_U64_F32_I]]
//
uint64_t test_vcvtps_u64_f32(float32_t a) {
  return (uint64_t)vcvtps_u64_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtpd_u32_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTPD_U32_F64_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtpu.i32.f64(double [[A]])
// CHECK-NEXT:    ret i32 [[VCVTPD_U32_F64_I]]
//
uint32_t test_vcvtpd_u32_f64(float64_t a) {
  return (uint32_t)vcvtpd_u32_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvts_s32_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTS_S32_F32_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtzs.i32.f32(float [[A]])
// CHECK-NEXT:    ret i32 [[VCVTS_S32_F32_I]]
//
int32_t test_vcvts_s32_f32(float32_t a) {
  return (int32_t)vcvts_s32_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtd_s64_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTD_S64_F64_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtzs.i64.f64(double [[A]])
// CHECK-NEXT:    ret i64 [[VCVTD_S64_F64_I]]
//
int64_t test_vcvtd_s64_f64(float64_t a) {
  return (int64_t)vcvtd_s64_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvts_s64_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTS_S64_F32_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtzs.i64.f32(float [[A]])
// CHECK-NEXT:    ret i64 [[VCVTS_S64_F32_I]]
//
int64_t test_vcvts_s64_f32(float32_t a) {
  return (int64_t)vcvts_s64_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtd_s32_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTD_S32_F64_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtzs.i32.f64(double [[A]])
// CHECK-NEXT:    ret i32 [[VCVTD_S32_F64_I]]
//
int32_t test_vcvtd_s32_f64(float64_t a) {
  return (int32_t)vcvtd_s32_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvts_u32_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTS_U32_F32_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtzu.i32.f32(float [[A]])
// CHECK-NEXT:    ret i32 [[VCVTS_U32_F32_I]]
//
uint32_t test_vcvts_u32_f32(float32_t a) {
  return (uint32_t)vcvts_u32_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtd_u64_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTD_U64_F64_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtzu.i64.f64(double [[A]])
// CHECK-NEXT:    ret i64 [[VCVTD_U64_F64_I]]
//
uint64_t test_vcvtd_u64_f64(float64_t a) {
  return (uint64_t)vcvtd_u64_f64(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvts_u64_f32
// CHECK-SAME: (float noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTS_U64_F32_I:%.*]] = call i64 @llvm.aarch64.neon.fcvtzu.i64.f32(float [[A]])
// CHECK-NEXT:    ret i64 [[VCVTS_U64_F32_I]]
//
uint64_t test_vcvts_u64_f32(float32_t a) {
  return (uint64_t)vcvts_u64_f32(a);
}

// CHECK-LABEL: define {{[^@]+}}@test_vcvtd_u32_f64
// CHECK-SAME: (double noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VCVTD_U32_F64_I:%.*]] = call i32 @llvm.aarch64.neon.fcvtzu.i32.f64(double [[A]])
// CHECK-NEXT:    ret i32 [[VCVTD_U32_F64_I]]
//
uint32_t test_vcvtd_u32_f64(float64_t a) {
  return (uint32_t)vcvtd_u32_f64(a);
}

