/*  This file is part of FreeDoko.
    FreeDoko is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version (see <http://www.gnu.org/licenses/>).

    Diese Datei ist Teil von FreeDoko.
    FreeDoko ist Freie Software: Sie können es unter den Bedingungen der GNU General Public License, wie von der Free Software Foundation, Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren veröffentlichten Version, weiter verteilen und/oder modifizieren (siehe <https://www.gnu.org/licenses/>).
    */

#ifdef USE_UI_GTKMM

#pragma once

#include "constants.h"

#include "base.h"
#include "widgets/sticky_dialog.h"
namespace Gtk {
class TextView;
} // namespace Gtk

namespace UI_GTKMM_NS {

/**
 ** the support dialog
 **/
class Support : public Base, public Gtk::StickyDialog {
  public:
    explicit Support(Base* parent);
    ~Support() override;

  private:
    void init();

  private:
    Gtk::TextView* text = nullptr;

  private: // unused
    Support() = delete;
    Support(Support const&) = delete;
    Support& operator=(Support const&) = delete;
}; // class Support : public Base, public Gtk::StickyDialog

} // namespace UI_GTKMM_NS

#endif // #ifdef USE_UI_GTKMM
