//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//

#include "globals.hh"
#include "G4SystemOfUnits.hh"
#include "G4BaryonWidth.hh"
#include "G4PhysicsVector.hh"
#include "G4PhysicsFreeVector.hh"


const G4double G4BaryonWidth::baryonEnergyTable[120] =
{ 
  0.100,   0.162,   0.224,   0.285,   0.347,   0.409,   0.471,   0.532,
  0.594,   0.656,   0.718,   0.779,   0.841,   0.903,   0.965,   1.026,
  1.088,   1.150,   1.212,   1.274,   1.335,   1.397,   1.459,   1.521,
  1.582,   1.644,   1.706,   1.768,   1.829,   1.891,   1.953,   2.015,
  2.076,   2.138,   2.200,   2.262,   2.324,   2.385,   2.447,   2.509,
  2.571,   2.632,   2.694,   2.756,   2.818,   2.879,   2.941,   3.003,
  3.065,   3.126,   3.188,   3.250,   3.312,   3.374,   3.435,   3.497,
  3.559,   3.621,   3.682,   3.744,   3.806,   3.868,   3.929,   3.991,
  4.053,   4.115,   4.176,   4.238,   4.300,   4.362,   4.424,   4.485,
  4.547,   4.609,   4.671,   4.732,   4.794,   4.856,   4.918,   4.979,
  5.000,   6.134,   7.269,   8.403,   9.538,  10.672,  11.807,  12.941,
  14.076,  15.210,  16.345,  17.479,  18.613,  19.748,  20.882,  22.017,
  23.151,  24.286,  25.420,  26.555,  27.689,  28.824,  29.958,  31.092,
  32.227,  33.361,  34.496,  35.630,  36.765,  37.899,  39.034,  40.168,
  41.303,  42.437,  43.571,  44.706,  45.840,  46.975,  48.109,  49.244
};

const G4double G4BaryonWidth::wN1440[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6.98204, 45.8544, 87.6071, 135.614, 187.179, 267.659, 390.159, 527.746, 666.031, 805.253, 941.075, 1072.42, 1196.74, 1317.9, 1433.77, 1544.44, 1648.43, 1749.32, 1845.62, 1937.55, 2025.36, 2107.95, 2188.25, 2265.1, 2338.7, 2408.12, 2475.83, 2540.82, 2603.25, 2662.32, 2720.11, 2775.75, 2829.36, 2880.24, 2930.15, 2978.34, 3024.91, 3069.93, 3112.79, 3154.97, 3195.83, 3235.42, 3273.21, 3310.48, 3346.65, 3381.79, 3415.39, 3448.59, 3480.89, 3512.31, 3542.4, 3572.19, 3601.22, 3629.5, 3657.09, 3683.58, 3709.87, 3735.53, 3760.58, 3784.64, 3808.53, 3831.85, 3854.63, 3876.55, 3883.98, 4218.19, 4465.3, 4636.36, 4766.8, 4933.96, 5086.11, 5129.96, 5100.71, 5086.74, 5108.52, 5136.7, 5149.42, 5155.08, 5178.35, 5240.62, 5352.7, 5516.85, 5728.73, 5979.98, 6256.97, 6542.52, 6814.75, 7050.92, 7230.03, 7336.36, 7363.36, 7313.75, 7198.01, 7031.58, 6830.7, 6610.88, 6384.13, 6160.01, 5944.53, 5741.27, 5552.55, 5378.72, 5219.94, 5075.29
};
const G4double G4BaryonWidth::wN1520[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.208063, 3.69544, 10.234, 21.9762, 39.4847, 64.8455, 93.8126, 122.796, 151.119, 179.673, 207.896, 235.674, 262.467, 289.065, 314.954, 340.082, 364.026, 387.548, 410.239, 432.096, 453.124, 473.017, 492.442, 511.087, 528.974, 545.857, 562.314, 578.089, 593.209, 607.471, 621.369, 634.69, 647.459, 659.508, 671.255, 682.522, 693.331, 703.702, 713.499, 723.062, 732.245, 741.068, 749.411, 757.565, 765.406, 772.947, 780.089, 787.077, 793.806, 800.287, 806.431, 812.452, 818.256, 823.854, 829.255, 834.385, 839.42, 844.283, 848.98, 853.446, 857.834, 862.076, 866.178, 870.083, 871.399, 925.319, 957.826, 978.064, 991.567, 1003.37, 1012.71, 1016.77, 1017.28, 1017.82, 1019.33, 1020.81, 1021.53, 1021.84, 1022.72, 1024.99, 1029.06, 1035.04, 1042.77, 1051.94, 1062.07, 1072.5, 1082.44, 1091.03, 1097.49, 1101.24, 1102.04, 1099.99, 1095.48, 1089.08, 1081.4, 1073.02, 1064.38, 1055.85, 1047.64, 1039.89, 1032.69, 1026.05, 1019.97, 1014.43
};
const G4double G4BaryonWidth::wN1535[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.012071, 0.0361725, 12.3692, 31.6588, 43.6167, 55.3459, 63.7718, 70.8314, 76.8132, 118.769, 145.509, 164.174, 178.773, 190.796, 200.831, 209.642, 217.345, 224.146, 230.108, 235.541, 240.435, 244.866, 248.894, 252.513, 255.883, 258.979, 261.83, 264.422, 266.862, 269.125, 271.229, 273.159, 274.989, 276.701, 278.303, 279.782, 281.194, 282.522, 283.773, 284.952, 286.048, 287.1, 288.097, 289.04, 289.92, 290.769, 291.576, 292.343, 293.062, 293.757, 294.42, 295.053, 295.647, 296.224, 296.776, 297.304, 297.809, 298.285, 298.749, 299.195, 299.622, 300.025, 300.42, 300.799, 301.163, 301.508, 301.624, 306.203, 308.795, 310.402, 311.469, 312.212, 312.752, 313.155, 313.465, 313.707, 313.902, 314.059, 314.188, 314.296, 314.387, 314.464, 314.53, 314.587, 314.636, 314.679, 314.717, 314.751, 314.781, 314.808, 314.832, 314.853, 314.873, 314.89, 314.906, 314.921, 314.934, 314.946, 314.957, 314.968, 314.977, 314.986, 314.994, 315.002, 315.009, 315.016
};
const G4double G4BaryonWidth::wN1650[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14.4948, 37.1813, 51.1584, 64.5471, 74.5917, 83.6109, 92.8888, 106.8, 120.114, 147.556, 170.039, 189.411, 206.912, 223.527, 239.13, 253.813, 267.42, 280.443, 292.696, 304.219, 315.053, 325.079, 334.664, 343.677, 352.155, 360.008, 367.525, 374.607, 381.282, 387.48, 393.428, 399.047, 404.358, 409.304, 414.065, 418.576, 422.853, 426.912, 430.706, 434.372, 437.859, 441.177, 444.288, 447.302, 450.177, 452.921, 455.5, 458.006, 460.403, 462.696, 464.856, 466.96, 468.976, 470.91, 472.767, 474.522, 476.237, 477.886, 479.471, 480.971, 482.437, 483.848, 485.205, 486.491, 486.923, 504.235, 514.717, 520.061, 523.187, 530.053, 536.475, 535.168, 528.788, 524.079, 522.508, 521.734, 520.03, 518.037, 517.65, 520.484, 527.327, 538.284, 552.961, 570.655, 590.292, 610.555, 629.798, 646.327, 658.581, 665.397, 666.292, 661.477, 651.74, 638.241, 622.199, 604.779, 586.884, 569.238, 552.297, 536.337, 521.54, 507.94, 495.557, 484.327
};
const G4double G4BaryonWidth::wN1675[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.104352, 1.86366, 5.19128, 9.89594, 15.7618, 23.9471, 38.1417, 59.6899, 87.4394, 121.292, 159.702, 201.53, 245.002, 290.639, 336.977, 383.397, 428.676, 473.931, 518.14, 561.109, 602.704, 642.207, 680.871, 718.02, 753.662, 787.28, 820.012, 851.338, 881.307, 909.519, 936.951, 963.186, 988.278, 1011.9, 1034.88, 1056.88, 1077.93, 1098.1, 1117.11, 1135.63, 1153.38, 1170.41, 1186.49, 1202.18, 1217.24, 1231.71, 1245.4, 1258.77, 1271.64, 1284.01, 1295.73, 1307.21, 1318.26, 1328.91, 1339.18, 1348.93, 1358.49, 1367.73, 1376.64, 1385.11, 1393.41, 1401.43, 1409.18, 1416.55, 1419.03, 1520.6, 1583.68, 1617.98, 1639.05, 1676.87, 1711.42, 1707.4, 1678.01, 1656.34, 1649.76, 1647.04, 1639.74, 1630.85, 1629.47, 1643.43, 1676.64, 1729.81, 1801.23, 1887.71, 1984.14, 2084.11, 2179.49, 2261.85, 2323.38, 2358.25, 2364, 2341.61, 2294.94, 2229.69, 2151.84, 2067.14, 1980.02, 1894.01, 1811.33, 1733.3, 1660.78, 1593.88, 1532.66, 1476.78
};
const G4double G4BaryonWidth::wN1680[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0125742, 0.588859, 2.37658, 6.13829, 12.6173, 23.112, 38.3012, 57.3481, 79.2689, 104.334, 131.76, 161.092, 191.372, 223.163, 255.574, 288.235, 320.301, 352.55, 384.224, 415.138, 445.149, 473.689, 501.622, 528.422, 554.066, 578.163, 601.511, 623.726, 644.839, 664.571, 683.608, 701.663, 718.781, 734.753, 750.148, 764.743, 778.581, 791.707, 803.964, 815.793, 827.026, 837.698, 847.682, 857.337, 866.525, 875.273, 883.477, 891.43, 899.016, 906.257, 913.064, 919.679, 926.005, 932.058, 937.856, 943.324, 948.655, 953.77, 958.679, 963.319, 967.852, 972.21, 976.401, 980.371, 981.704, 1034.85, 1066.45, 1085.85, 1099.1, 1113.92, 1126.86, 1130.49, 1127.8, 1126.22, 1127.54, 1129.37, 1129.9, 1129.85, 1131.29, 1136.03, 1145.01, 1158.44, 1175.98, 1196.94, 1220.15, 1244.15, 1267.07, 1286.97, 1302.03, 1310.89, 1313, 1308.57, 1298.49, 1284.08, 1266.73, 1247.77, 1228.22, 1208.9, 1190.32, 1172.8, 1156.52, 1141.53, 1127.82, 1115.33
};
const G4double G4BaryonWidth::wN1700[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0169982, 0.303937, 0.866717, 4.62262, 12.4739, 26.0292, 42.1235, 58.4389, 75.3252, 93.1975, 112.263, 132.344, 151.745, 170.73, 189.044, 206.76, 223.651, 240.298, 256.439, 272.085, 287.247, 301.703, 315.934, 329.711, 343.043, 355.736, 368.217, 380.284, 391.95, 403.047, 413.951, 424.487, 434.669, 444.351, 453.861, 463.051, 471.931, 480.511, 488.672, 496.69, 504.44, 511.932, 519.06, 526.067, 532.843, 539.397, 545.637, 551.774, 557.713, 563.461, 568.937, 574.327, 579.547, 584.603, 589.501, 594.173, 598.776, 603.238, 607.565, 611.693, 615.764, 619.713, 623.544, 627.203, 628.438, 680.21, 712.515, 733.19, 747.205, 759.152, 768.705, 773.043, 774.284, 776.786, 777.701, 778.418, 779.61, 782.045, 785.121, 786.088, 786.984, 790.875, 797.519, 805.081, 812.857, 821.517, 831.336, 841.728, 851.349, 858.149, 860.118, 856.697, 849.24, 839.791, 829.869, 820.349, 811.641, 803.966, 797.409, 791.978, 787.612, 784.12, 781.187, 778.363
};
const G4double G4BaryonWidth::wN1710[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.258418, 1.71929, 3.40223, 7.97923, 12.7292, 18.6296, 26.4714, 39.755, 56.6156, 79.4137, 107.994, 141.172, 175.5, 209.663, 242.487, 273.881, 303.407, 332.096, 359.527, 385.772, 410.901, 434.601, 457.709, 479.887, 501.188, 521.34, 541.051, 560.026, 578.308, 595.655, 612.671, 629.101, 644.974, 660.077, 674.931, 689.31, 703.237, 716.735, 729.617, 742.323, 754.658, 766.639, 778.096, 789.42, 800.435, 811.155, 821.425, 831.594, 841.504, 851.163, 860.433, 869.625, 878.596, 887.355, 895.91, 904.135, 912.307, 920.297, 928.109, 935.628, 943.107, 950.425, 957.588, 964.489, 966.832, 1073.25, 1151.99, 1211.06, 1257.55, 1301.84, 1341.32, 1363.78, 1377.07, 1399.14, 1408.08, 1415.48, 1427.83, 1449.38, 1473.66, 1480.23, 1481.32, 1496.77, 1525.12, 1554.81, 1582.39, 1614.05, 1654.02, 1701, 1748.52, 1784.82, 1797.41, 1782.34, 1747.52, 1704.88, 1662.75, 1625.29, 1593.94, 1569.18, 1550.96, 1539.03, 1532.79, 1531.02, 1531.65, 1531.87
};
const G4double G4BaryonWidth::wN1720[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.346639, 2.30696, 4.72305, 15.7079, 26.8062, 38.6052, 51.4629, 65.0523, 79.5782, 100.736, 137.807, 201.663, 275.889, 349.626, 418.604, 482.598, 541.063, 596.379, 647.999, 696.317, 741.674, 783.698, 824.018, 862.149, 898.283, 932.053, 964.714, 995.832, 1025.53, 1053.46, 1080.63, 1106.67, 1131.64, 1155.25, 1178.33, 1200.54, 1221.93, 1242.56, 1262.15, 1281.39, 1299.98, 1317.97, 1335.11, 1351.98, 1368.34, 1384.21, 1399.37, 1414.33, 1428.87, 1443, 1456.53, 1469.92, 1482.95, 1495.64, 1508.01, 1519.88, 1531.65, 1543.13, 1554.34, 1565.11, 1575.81, 1586.26, 1596.47, 1606.3, 1609.63, 1759.39, 1868.08, 1949.59, 2012.47, 2070.64, 2126.77, 2150.49, 2168.78, 2243.17, 2225.86, 2203.89, 2227.83, 2316.91, 2415.49, 2384.19, 2292.7, 2263.4, 2291.17, 2310.49, 2308.5, 2332.86, 2420.83, 2575.37, 2766.33, 2928.23, 2986.31, 2914.31, 2755.39, 2574.98, 2416.12, 2296.22, 2217.75, 2178.33, 2174.29, 2201.7, 2255.28, 2326.79, 2403.06, 2466.79
};
const G4double G4BaryonWidth::wN1900[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.22722, 14.8739, 28.6939, 43.1901, 57.8705, 73.6495, 90.699, 108.338, 125.974, 144.405, 165.205, 299.46, 451.183, 595.565, 727.215, 865.263, 956.954, 1063.29, 1216.4, 1339.63, 1327.97, 1530.31, 1645.73, 1559.95, 1615.41, 1724.34, 2077.66, 1782.77, 1831.06, 1882.93, 1894.37, 2065.78, 2876.49, 2073.76, 2200.43, 2741.68, 2077.91, 2068.34, 2575.44, 2145.86, 2584.54, 2122.71, 2129.57, 3186.04, 2831.28, 3263.18, 2311.2, 2796.11, 3412.19, 2593.86, 3157.83, 2229.33, 5577.28, 2161.79, 3414.82, 2242.77, 6233.2, 2446.53, 2950.77, 2590.57, 2605.31, 7065.21, 2638.46, 2385.63, 3065.71, 2471.38, 2023.25, 1988.68, 18558.9, 5234.89, 20347.9, 2016.46, 2505.15, 2441.35, 10103.5, 1994.97, 2157.65, 22319.4, 2299.21, 1974.61, 2092.56, 3014.82, 16625.2, 9799.51, 2963.88, 2267.74, 2143.54, 2163.52, 2243.64, 2361.01, 2548.26, 3040.22, 5357.31, 33817.4, 9508.94, 3552.7, 2533.83, 2206.04, 2068.98, 2007, 1982.35, 1978.55, 1985.53, 1995.11
};
const G4double G4BaryonWidth::wN1990[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00176227, 0.0826059, 0.335752, 1.54792, 4.65793, 10.1342, 18.9898, 32.8124, 52.7674, 81.9469, 125.787, 190.605, 282.317, 406.021, 557.934, 733.267, 923.093, 1127.95, 1339.58, 1553.47, 1766.03, 1971.18, 2173.68, 2368.79, 2555.66, 2731.01, 2900.44, 3061.01, 3212.92, 3354.18, 3489.76, 3617.64, 3738.24, 3850.16, 3957.47, 4058.66, 4154.12, 4244.18, 4327.87, 4408.24, 4484.18, 4555.97, 4622.82, 4687.15, 4748.08, 4805.82, 4859.71, 4911.7, 4961.06, 5007.95, 5051.82, 5094.24, 5134.61, 5173.07, 5209.71, 5244.11, 5277.48, 5309.34, 5339.76, 5368.37, 5396.18, 5422.77, 5448.2, 5472.17, 5480.19, 5785.86, 5950.54, 6037.65, 6088.13, 6158.88, 6225.56, 6215.42, 6168.25, 6178.58, 6139.32, 6102.45, 6095.93, 6139.88, 6204.12, 6190.61, 6159.16, 6205.62, 6322.15, 6451.52, 6575.7, 6722.92, 6911.57, 7133.07, 7353.91, 7515.59, 7556.82, 7458.71, 7260.37, 7020.75, 6781.57, 6564.23, 6376.68, 6221.99, 6100.41, 6010.87, 5950.65, 5913.7, 5890.02, 5865.79
};
const G4double G4BaryonWidth::wN2090[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.161627, 2.90013, 8.13379, 16.4319, 27.8324, 43.0753, 61.01, 81.2556, 104.383, 132.014, 166.735, 207.911, 247.946, 286.39, 323.067, 358.466, 392.35, 426.014, 459.014, 491.419, 523.274, 554.102, 584.928, 615.25, 645.072, 673.923, 702.749, 731.071, 758.887, 785.758, 812.564, 838.861, 864.647, 889.521, 914.3, 938.574, 962.347, 985.621, 1008.04, 1030.34, 1052.16, 1073.5, 1094.04, 1114.46, 1134.42, 1153.93, 1172.7, 1191.34, 1209.56, 1227.37, 1244.48, 1261.49, 1278.1, 1294.32, 1310.17, 1325.41, 1340.54, 1355.33, 1369.76, 1383.64, 1397.43, 1410.89, 1424.05, 1436.69, 1440.98, 1629.31, 1755.39, 1842.04, 1903.49, 1949.42, 1984.99, 2009.24, 2027.75, 2049.83, 2057.61, 2062.8, 2072.29, 2088.87, 2105.73, 2105.39, 2096.87, 2095.84, 2101.73, 2106.26, 2107.85, 2112.57, 2125.16, 2145.99, 2171.22, 2192.56, 2200.54, 2191.84, 2171.97, 2149.26, 2129.19, 2114, 2104.01, 2098.94, 2098.35, 2101.72, 2108.42, 2117.38, 2126.94, 2134.9
};
const G4double G4BaryonWidth::wN2190[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0004401, 0.0530579, 0.309625, 1.00785, 2.49327, 5.35195, 10.5432, 18.7426, 30.1544, 45.6179, 66.2785, 96.2159, 137.227, 189.537, 251.257, 321.451, 398.053, 482.847, 573.827, 670.076, 770.577, 872.574, 978.364, 1085.3, 1192.48, 1297.4, 1402.85, 1506.58, 1608.13, 1705.6, 1801.94, 1895.32, 1985.64, 2071.41, 2155.43, 2236.26, 2313.91, 2388.44, 2458.78, 2527.31, 2592.96, 2655.8, 2715, 2772.6, 2827.72, 2880.46, 2930.14, 2978.48, 3024.76, 3069.07, 3110.84, 3151.54, 3190.53, 3227.93, 3263.79, 3297.67, 3330.73, 3362.49, 3393, 3421.86, 3450.07, 3477.2, 3503.31, 3528.05, 3536.36, 3866.01, 4055.47, 4169.34, 4242.18, 4311.19, 4373.67, 4381.22, 4372.08, 4430.63, 4392.91, 4352.62, 4362.68, 4445.52, 4542.68, 4503.28, 4406.51, 4387.92, 4440.55, 4489.95, 4519.61, 4579.51, 4707.37, 4902.86, 5129.48, 5313.2, 5371.44, 5276.12, 5076.15, 4845.44, 4633.53, 4461.89, 4335.08, 4251.99, 4209.47, 4203.76, 4229.39, 4277.37, 4333.31, 4378.19
};
const G4double G4BaryonWidth::wN2220[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.49404e-05, 0.00764588, 0.0641514, 0.263009, 0.782704, 1.9362, 4.26892, 8.53924, 15.4035, 25.9001, 40.9065, 62.3784, 92.5859, 134.209, 187.566, 252.875, 328.659, 416.968, 515.946, 624.648, 741.931, 864.428, 994.762, 1129.5, 1267.17, 1404.07, 1543.37, 1681.59, 1817.65, 1948.51, 2077.73, 2202.53, 2322.49, 2435.48, 2545.05, 2649.23, 2748.03, 2841.53, 2928.48, 3011.9, 3090.53, 3164.59, 3233.22, 3298.89, 3360.69, 3418.83, 3472.7, 3524.27, 3572.83, 3618.58, 3661.02, 3701.72, 3740.12, 3776.37, 3810.63, 3842.51, 3873.19, 3902.23, 3929.73, 3955.39, 3980.14, 4003.62, 4025.92, 4046.77, 4053.72, 4304.64, 4427.14, 4488.88, 4522.65, 4566.99, 4610.73, 4599.89, 4569.68, 4601.58, 4558.89, 4516.82, 4517.24, 4580.05, 4658.29, 4625.15, 4549.48, 4547.59, 4613.27, 4682.04, 4738.17, 4822.32, 4964.02, 5160.11, 5376.52, 5547.31, 5600.18, 5511.07, 5323.4, 5102.87, 4894.24, 4717.93, 4579.31, 4478.61, 4413.83, 4382.16, 4379.19, 4397.17, 4423.69, 4442.16
};
const G4double G4BaryonWidth::wN2250[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.000265834, 0.0320445, 0.187025, 0.623477, 1.59286, 3.39994, 6.34513, 10.8171, 17.1442, 26.0267, 37.943, 53.7791, 74.7806, 103.463, 141.1, 188.885, 246.557, 316.318, 397.153, 488.441, 589.15, 696.116, 811.299, 931.336, 1054.55, 1177.35, 1302.33, 1426.24, 1548.03, 1664.96, 1780.21, 1891.37, 1998.08, 2098.52, 2195.89, 2288.47, 2376.3, 2459.48, 2536.9, 2611.25, 2681.4, 2747.54, 2808.9, 2867.66, 2923.01, 2975.12, 3023.43, 3069.68, 3113.24, 3154.28, 3192.34, 3228.82, 3263.21, 3295.67, 3326.3, 3354.77, 3382.13, 3407.99, 3432.44, 3455.22, 3477.14, 3497.9, 3517.58, 3535.94, 3542.04, 3758.33, 3859.27, 3908.42, 3934.48, 3969.63, 4004.84, 3995.07, 3969.25, 3995.29, 3959.45, 3923.98, 3923.75, 3975.66, 4040.88, 4013.66, 3951.39, 3950.98, 4006.98, 4065.28, 4112.54, 4182.62, 4300.26, 4462.98, 4642.48, 4783.79, 4826.55, 4750.68, 4592.52, 4407, 4231.54, 4083.19, 3966.45, 3881.51, 3826.75, 3799.88, 3797.24, 3812.42, 3835.11, 3851.47
};
const G4double G4BaryonWidth::wDelta[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0179216, 0.16395, 8.68303, 53.5584, 99.9409, 146.527, 191.66, 236.264, 279.276, 320.539, 359.373, 397.057, 432.984, 467.22, 499.331, 530.452, 560.13, 588.451, 615.069, 640.934, 665.674, 689.358, 712.051, 733.468, 754.368, 774.445, 793.746, 812.023, 829.916, 847.159, 863.787, 879.579, 895.085, 910.069, 924.558, 938.355, 951.936, 965.092, 977.845, 990.213, 1002.02, 1013.68, 1025, 1036.01, 1046.53, 1056.94, 1067.08, 1076.94, 1086.39, 1095.75, 1104.88, 1113.77, 1122.31, 1130.78, 1139.05, 1147.13, 1155.01, 1162.59, 1170.12, 1177.49, 1184.69, 1191.62, 1198.51, 1205.25, 1211.86, 1218.22, 1220.38, 1318.24, 1389.66, 1444.18, 1487.32, 1522.29, 1551.29, 1575.7, 1596.57, 1614.59, 1630.34, 1644.21, 1656.52, 1667.53, 1677.42, 1686.38, 1694.5, 1701.93, 1708.72, 1714.98, 1720.74, 1726.08, 1731.04, 1735.65, 1739.96, 1743.99, 1747.77, 1751.31, 1754.65, 1757.79, 1760.77, 1763.58, 1766.24, 1768.77, 1771.16, 1773.45, 1775.62, 1777.69, 1779.67, 1781.56
};
const G4double G4BaryonWidth::wD1600[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.902724, 5.6193, 10.7485, 16.2079, 23.1947, 40.5647, 76.6014, 126.422, 188.867, 267.379, 359.389, 460.962, 566.56, 676.87, 788.231, 899.28, 1007.31, 1115.23, 1220.81, 1323.74, 1423.86, 1519.51, 1613.79, 1705.11, 1793.5, 1877.66, 1960.42, 2040.47, 2117.88, 2191.56, 2264.02, 2334.12, 2401.97, 2466.6, 2530.23, 2591.87, 2651.59, 2709.49, 2764.73, 2819.22, 2872.1, 2923.43, 2972.5, 3020.95, 3068.05, 3113.84, 3157.68, 3201.04, 3243.24, 3284.33, 3323.71, 3362.72, 3400.74, 3437.82, 3473.98, 3508.71, 3543.17, 3576.82, 3609.67, 3641.25, 3672.59, 3703.22, 3733.14, 3761.93, 3771.7, 4209.82, 4528.96, 4756.26, 4930.42, 5122.23, 5293.15, 5364.81, 5368.29, 5381.47, 5421.78, 5462.53, 5485.52, 5501.1, 5533.82, 5603.88, 5720.36, 5883.37, 6086.27, 6318.93, 6567.48, 6816.46, 7047.73, 7243.29, 7386.85, 7466.51, 7477.81, 7423.8, 7313.84, 7161.32, 6980.14, 6783.65, 6582.21, 6384.28, 6195.39, 6019.14, 5858.12, 5713.24, 5585.21, 5473.74
};
const G4double G4BaryonWidth::wD1620[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6.09438, 15.1009, 20.5609, 25.2959, 29.8547, 36.023, 48.9969, 71.0644, 101.192, 138.98, 182.126, 228.889, 277.077, 327.195, 377.61, 427.654, 476.036, 523.974, 570.403, 615.145, 658.094, 698.549, 737.824, 775.256, 810.884, 844.23, 876.45, 907.054, 936.117, 963.28, 989.508, 1014.42, 1038.08, 1060.22, 1081.62, 1101.97, 1121.33, 1139.77, 1157.05, 1173.79, 1189.76, 1204.99, 1219.3, 1233.19, 1246.47, 1259.16, 1271.11, 1282.74, 1293.88, 1304.55, 1314.62, 1324.43, 1333.85, 1342.9, 1351.59, 1359.81, 1367.86, 1375.6, 1383.05, 1390.1, 1397, 1403.64, 1410.03, 1416.08, 1418.12, 1500.03, 1550.58, 1574.78, 1588.2, 1626.29, 1662.76, 1652.52, 1611.74, 1581.61, 1571, 1565.5, 1554.49, 1541.76, 1538.8, 1555.41, 1596.4, 1662.51, 1751.47, 1859.15, 1979.07, 2103.19, 2221.4, 2323.21, 2398.92, 2441.32, 2447.39, 2418.41, 2359.22, 2276.98, 2179.14, 2072.88, 1963.71, 1856.04, 1752.63, 1655.13, 1564.64, 1481.31, 1405.24, 1336.01
};
const G4double G4BaryonWidth::wD1700[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.105048, 1.70825, 4.7302, 12.6502, 30.4128, 67.6989, 112.537, 154.064, 194.657, 241.323, 300.067, 371.626, 447.358, 526.334, 605.86, 684.693, 760.579, 835.265, 906.997, 975.494, 1040.64, 1101.46, 1160.02, 1215.41, 1267.78, 1316.52, 1363.38, 1407.72, 1449.7, 1488.83, 1526.55, 1562.34, 1596.32, 1628.1, 1658.84, 1688.1, 1715.96, 1742.53, 1767.48, 1791.7, 1814.85, 1836.97, 1857.81, 1878.1, 1897.54, 1916.17, 1933.76, 1950.93, 1967.42, 1983.27, 1998.26, 2012.92, 2027.04, 2040.62, 2053.72, 2066.14, 2078.32, 2090.07, 2101.41, 2112.18, 2122.76, 2132.97, 2142.85, 2152.25, 2155.41, 2285.1, 2364.04, 2412.91, 2445.43, 2477.3, 2504.41, 2511.53, 2507.94, 2512.94, 2511.02, 2508.62, 2508.83, 2516.35, 2528.34, 2531.61, 2536.32, 2556.22, 2588.39, 2622.55, 2654.87, 2688.79, 2726.34, 2765.71, 2801.37, 2824.17, 2824.93, 2801.51, 2760.73, 2712.28, 2663.06, 2616.86, 2575.35, 2539.48, 2509.64, 2486.01, 2468.45, 2456.24, 2448, 2441.73
};
const G4double G4BaryonWidth::wD1900[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10.9537, 27.1407, 36.953, 45.508, 53.7455, 62.8976, 75.1602, 92.0545, 113.802, 141.418, 175.471, 214.621, 253.189, 291.004, 327.552, 363.001, 396.884, 430.338, 462.799, 494.256, 524.698, 553.65, 582.059, 609.446, 635.82, 660.794, 685.206, 708.662, 731.188, 752.47, 773.235, 793.158, 812.27, 830.315, 847.913, 864.794, 880.99, 896.529, 911.205, 925.527, 939.276, 952.478, 964.959, 977.149, 988.865, 1000.13, 1010.79, 1021.21, 1031.24, 1040.9, 1050.04, 1059, 1067.63, 1075.95, 1083.97, 1091.59, 1099.06, 1106.28, 1113.24, 1119.86, 1126.35, 1132.61, 1138.66, 1144.42, 1146.35, 1225.58, 1274.74, 1301.1, 1317.03, 1347.24, 1375.59, 1370.8, 1346.09, 1332.66, 1323.87, 1318.07, 1312.46, 1311.22, 1316.8, 1324.14, 1342.45, 1382.02, 1440.55, 1509.85, 1584.93, 1664.67, 1745.75, 1821.76, 1884.09, 1922.75, 1929.79, 1904.14, 1852.63, 1785.11, 1709.74, 1632.37, 1556.65, 1485.16, 1419.34, 1359.93, 1307.18, 1260.52, 1218.93, 1180.69
};
const G4double G4BaryonWidth::wD1905[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00636486, 0.26456, 1.05845, 2.58182, 5.06931, 9.59161, 17.0462, 26.9577, 39.5727, 58.4388, 95.5365, 168.449, 263.536, 369.086, 478.325, 588.876, 697.32, 805.891, 911.768, 1014.22, 1112.8, 1205.81, 1296.24, 1382.6, 1465.02, 1542.44, 1617.59, 1689.36, 1757.96, 1822.53, 1885.37, 1945.57, 2003.28, 2057.78, 2110.98, 2162.1, 2211.26, 2258.57, 2303.41, 2347.33, 2389.69, 2430.57, 2469.41, 2507.56, 2544.45, 2580.13, 2614.11, 2647.57, 2680, 2711.43, 2741.44, 2771.04, 2799.79, 2827.72, 2854.87, 2880.84, 2906.54, 2931.54, 2955.89, 2979.23, 3002.35, 3024.89, 3046.87, 3067.96, 3075.11, 3390.78, 3613.61, 3778.11, 3902.97, 4016.77, 4130.34, 4170.68, 4206.77, 4367.58, 4316.39, 4260.89, 4310.43, 4512.14, 4728.57, 4642.67, 4427.02, 4357.77, 4414.99, 4447.31, 4431.1, 4478.83, 4675.31, 5026.22, 5459.58, 5820.65, 5936.71, 5753.52, 5376.91, 4958.4, 4594.75, 4323.64, 4149.38, 4065.87, 4064.36, 4135.73, 4267.51, 4440.08, 4622.05, 4772.66
};
const G4double G4BaryonWidth::wD1910[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.12809, 7.05827, 13.5492, 20.3734, 27.4001, 35.6787, 45.9548, 57.705, 70.8737, 87.1426, 110.946, 148.992, 194.747, 243.01, 290.772, 337.319, 381.7, 425.307, 467.408, 508.043, 547.264, 584.533, 621.131, 656.499, 690.696, 723.254, 755.295, 786.329, 816.405, 845.104, 873.413, 900.893, 927.584, 953.11, 978.341, 1002.88, 1026.77, 1050.03, 1072.33, 1094.42, 1115.96, 1136.97, 1157.15, 1177.17, 1196.73, 1215.83, 1234.2, 1252.46, 1270.32, 1287.79, 1304.61, 1321.35, 1337.74, 1353.79, 1369.53, 1384.7, 1399.82, 1414.65, 1429.19, 1443.22, 1457.22, 1470.97, 1484.45, 1497.48, 1501.91, 1707.37, 1864.4, 1986.37, 2083.67, 2174.78, 2261.65, 2305.16, 2339.09, 2428.15, 2422.68, 2414.09, 2450.22, 2553.26, 2663.41, 2639.61, 2560.47, 2550.61, 2600.69, 2641.83, 2662.32, 2711.59, 2826.29, 3007.41, 3221.05, 3396.29, 3454.78, 3372.27, 3197.34, 2999.53, 2823.75, 2688.15, 2595.6, 2544.09, 2530.13, 2549.94, 2598.1, 2665.83, 2739.03, 2799.24
};
const G4double G4BaryonWidth::wD1920[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.377455, 2.36263, 4.53662, 6.83577, 9.39258, 13.6752, 21.0491, 30.7513, 42.6809, 58.1145, 79.3063, 109.573, 144.849, 182.35, 220.037, 257.344, 293.419, 329.311, 364.349, 398.494, 431.731, 463.545, 494.987, 525.545, 555.239, 583.633, 611.684, 638.944, 665.442, 690.794, 715.857, 740.237, 763.959, 786.68, 809.17, 831.073, 852.412, 873.209, 893.16, 912.941, 932.238, 951.069, 969.159, 987.116, 1004.66, 1021.8, 1038.28, 1054.66, 1070.69, 1086.36, 1101.46, 1116.47, 1131.17, 1145.57, 1159.68, 1173.28, 1186.84, 1200.12, 1213.15, 1225.72, 1238.25, 1250.55, 1262.61, 1274.26, 1278.22, 1461.3, 1600.74, 1707.12, 1791.54, 1874.62, 1952.03, 1990.04, 2012.31, 2067.16, 2071.88, 2074.59, 2099.95, 2162.28, 2231.25, 2229.39, 2202.93, 2223, 2283.19, 2342.59, 2392.34, 2458.34, 2558.84, 2691.78, 2835.43, 2947.52, 2982.59, 2927.26, 2810.71, 2674.72, 2547.05, 2440.09, 2357, 2297.93, 2261.74, 2246.82, 2250.48, 2267.89, 2291.11, 2309.55
};
const G4double G4BaryonWidth::wD1930[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0638218, 1.04091, 2.89195, 5.53395, 8.85559, 13.2229, 19.7519, 29.206, 42.067, 60.1702, 86.0322, 125.42, 179.927, 248.454, 327.043, 413.151, 503.208, 598.489, 696.145, 795.009, 894.127, 991.145, 1088.64, 1184.53, 1278.44, 1368.64, 1457.9, 1544.58, 1628.59, 1708.6, 1787.23, 1863.16, 1936.42, 2005.94, 2074.07, 2139.71, 2202.94, 2263.84, 2321.56, 2378.07, 2432.49, 2484.91, 2534.6, 2583.27, 2630.17, 2675.37, 2718.25, 2760.29, 2800.83, 2839.94, 2877.08, 2913.52, 2948.71, 2982.69, 3015.51, 3046.74, 3077.42, 3107.09, 3135.79, 3163.1, 3189.97, 3215.98, 3241.14, 3265.13, 3273.21, 3607.41, 3812.52, 3940.24, 4024.63, 4105.83, 4177.83, 4191.47, 4183.68, 4225.22, 4200.2, 4174.92, 4182.58, 4242.72, 4314.15, 4292.37, 4240.44, 4254.26, 4324.1, 4393.37, 4449.5, 4527.07, 4650.42, 4816.38, 4995.54, 5131.66, 5164.59, 5076.96, 4907.74, 4712.65, 4528.78, 4372.91, 4249.47, 4158.82, 4099.52, 4069.45, 4065.07, 4079.92, 4103.5, 4121.84
};
const G4double G4BaryonWidth::wD1950[120] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.16591e-05, 0.0011297, 0.0182602, 0.45055, 1.76006, 4.25407, 8.10734, 13.6701, 21.3338, 31.7288, 45.2589, 63.2603, 87.0226, 119.655, 164.42, 224.558, 299.163, 386.75, 483.47, 590.001, 702.266, 817.863, 934.695, 1049.17, 1163.7, 1275.39, 1383.53, 1485.99, 1585.85, 1681.27, 1772.22, 1857.37, 1939.64, 2017.72, 2091.79, 2160.9, 2227.52, 2290.65, 2350.5, 2407.22, 2460.16, 2511.22, 2559.65, 2605.61, 2648.56, 2690.03, 2729.44, 2766.89, 2801.95, 2835.87, 2868.16, 2898.9, 2927.74, 2955.68, 2982.33, 3007.75, 3032.03, 3054.85, 3077.03, 3098.23, 3118.5, 3137.59, 3156.17, 3173.96, 3191, 3207.07, 3212.45, 3418.43, 3528.71, 3589.22, 3625.21, 3664.73, 3700.96, 3699.72, 3683.61, 3698.17, 3678.02, 3658.97, 3658.59, 3688.65, 3727.05, 3714.78, 3688.72, 3704.14, 3755.05, 3808.21, 3855.4, 3915.48, 4001.18, 4109.36, 4221.83, 4305.12, 4324, 4268.54, 4161.95, 4037.45, 3917.47, 3812.66, 3726.28, 3659.12, 3610.73, 3580.12, 3565.41, 3562.91, 3566.58, 3568.26
};
  
const G4double G4BaryonWidth::wL1405[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9.39894, 46.389, 66.0136, 81.3803, 94.0398, 105.12, 114.805, 123.359, 130.859, 137.694, 143.849, 149.415, 154.391, 159.002, 163.216, 167.079, 170.629, 173.849, 176.874, 179.673, 182.268, 184.642, 186.89, 188.985, 190.942, 192.745, 194.461, 196.072, 197.585, 198.986, 200.327, 201.592, 202.786, 203.914, 204.965, 205.977, 206.936, 207.846, 208.696, 209.518, 210.3, 211.044, 211.743, 212.42, 213.066, 213.683, 214.263, 214.827, 215.367, 215.884, 216.379, 216.846, 217.302, 217.739, 218.16, 218.557, 218.945, 219.319, 219.678, 220.019, 220.133, 224.67, 227.254, 228.862, 229.932, 230.678, 231.22, 231.625, 231.937, 232.181, 232.377, 232.535, 232.665, 232.774, 232.865, 232.943, 233.01, 233.067, 233.117, 233.16, 233.199, 233.233, 233.263, 233.29, 233.314, 233.336, 233.355, 233.373, 233.389, 233.404, 233.417, 233.43, 233.441, 233.451, 233.461, 233.47, 233.478, 233.486, 233.493, 233.5
}; 

const G4double G4BaryonWidth::wL1520[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0203936, 0.0529432, 0.0808573, 0.127773, 1.36541, 5.10966, 15.0213, 27.4029, 40.0984, 52.5624, 64.5632, 75.7918, 86.5553, 96.6459, 106.072, 114.72, 122.907, 130.524, 137.609, 144.201, 150.242, 155.965, 161.302, 166.282, 170.862, 175.218, 179.296, 183.119, 186.645, 190.025, 193.191, 196.168, 198.95, 201.61, 204.097, 206.459, 208.725, 210.837, 212.834, 214.705, 216.501, 218.222, 219.916, 221.514, 222.984, 224.318, 225.606, 226.865, 228.114, 229.335, 230.555, 231.721, 232.791, 233.745, 234.588, 235.388, 236.169, 236.95, 237.723, 238.512, 239.309, 240.122, 240.936, 241.216, 249.796, 254.999, 257.566, 261.729, 266.127, 261.245, 261.17, 264.738, 266.091, 263.033, 261.08, 260.61, 261.07, 262.283, 264.354, 267.6, 272.546, 279.673, 288.437, 295.381, 295.694, 289.784, 282.262, 275.929, 271.275, 267.961, 265.595, 263.872, 262.591, 261.616, 260.861, 260.264, 259.785, 259.395, 259.073, 258.805, 258.579, 258.387, 258.222
}; 

const G4double G4BaryonWidth::wL1600[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.37425, 21.4182, 52.499, 96.2422, 137.937, 179.019, 218.753, 257.106, 293.485, 329.096, 363.361, 396.32, 427.521, 458.037, 487.399, 515.664, 542.883, 568.694, 593.993, 618.396, 641.949, 664.334, 686.327, 707.592, 728.166, 747.766, 767.067, 785.774, 803.914, 821.233, 838.326, 854.928, 871.06, 886.743, 901.755, 916.606, 931.064, 945.146, 958.648, 972.028, 985.076, 997.804, 1010.03, 1022.16, 1034, 1045.58, 1056.71, 1067.77, 1078.58, 1089.16, 1099.51, 1109.48, 1119.4, 1129.12, 1138.64, 1147.81, 1156.95, 1165.91, 1174.7, 1183.18, 1186.06, 1318.27, 1417.02, 1493.84, 1555.61, 1606.36, 1648.92, 1685.1, 1716.31, 1743.47, 1767.37, 1788.53, 1807.41, 1824.39, 1839.71, 1853.63, 1866.31, 1877.94, 1888.61, 1898.46, 1907.57, 1916.03, 1923.9, 1931.23, 1938.1, 1944.53, 1950.57, 1956.25, 1961.61, 1966.66, 1971.45, 1975.98, 1980.28, 1984.35, 1988.23, 1991.93, 1995.45, 1998.82, 2002.03, 2005.1
}; 

const G4double G4BaryonWidth::wL1670[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.52932, 7.42962, 13.0258, 17.5344, 20.7914, 23.4961, 51.4448, 66.9742, 77.7327, 86.3899, 93.5718, 99.6964, 104.934, 109.62, 113.782, 117.507, 120.861, 123.852, 126.62, 129.149, 131.466, 133.565, 135.533, 137.354, 139.042, 140.585, 142.047, 143.411, 144.685, 145.859, 146.979, 148.031, 149.02, 149.951, 150.816, 151.646, 152.43, 153.173, 153.865, 154.532, 155.166, 155.768, 156.331, 156.877, 157.396, 157.891, 158.357, 158.808, 159.24, 159.652, 160.047, 160.419, 160.782, 161.129, 161.462, 161.777, 162.085, 162.38, 162.665, 162.934, 163.024, 166.586, 168.599, 169.845, 170.672, 171.248, 171.665, 171.977, 172.217, 172.405, 172.555, 172.677, 172.777, 172.86, 172.93, 172.99, 173.041, 173.085, 173.123, 173.157, 173.186, 173.212, 173.235, 173.256, 173.274, 173.291, 173.306, 173.32, 173.332, 173.343, 173.354, 173.363, 173.372, 173.38, 173.387, 173.394, 173.4, 173.406, 173.411, 173.417
}; 
  
const G4double G4BaryonWidth::wL1690[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0280814, 1.53124, 5.49554, 15.3262, 31.875, 47.9896, 64.2033, 80.5884, 96.7701, 113.148, 129.336, 145.233, 160.515, 175.623, 190.262, 204.402, 218.028, 230.923, 243.512, 255.582, 267.143, 278.038, 288.624, 298.762, 308.431, 317.543, 326.404, 334.823, 342.918, 350.566, 357.911, 364.909, 371.717, 378.29, 384.369, 390.149, 395.71, 401.208, 406.541, 411.718, 416.486, 420.85, 424.911, 428.985, 433.106, 437.287, 441.384, 445.37, 449.002, 452.196, 455.016, 457.587, 460.151, 462.761, 465.453, 468.192, 471.085, 474.089, 477.164, 480.159, 481.158, 510.39, 526.249, 535.189, 560.141, 568.37, 545.771, 549.389, 567.329, 565.603, 550.06, 542.234, 541.315, 545.043, 553.052, 566.376, 587.14, 618.093, 659.348, 700.645, 718.937, 702.598, 666.973, 631.461, 603.651, 583.568, 569.234, 558.899, 551.281, 545.551, 541.141, 537.687, 534.93, 532.699, 530.868, 529.346, 528.069, 526.986, 526.061, 525.263
}; 

const G4double G4BaryonWidth::wL1800[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.50627, 21.8634, 66.615, 103.564, 131.182, 159.803, 190.2, 222.588, 256.119, 291.406, 327.37, 363.506, 398.807, 434.085, 468.49, 501.828, 533.965, 564.331, 593.886, 622.101, 648.952, 674.186, 698.418, 721.685, 743.428, 764.029, 784.051, 802.228, 820.308, 837.77, 853.13, 867.294, 882.695, 898.371, 911.166, 921.232, 931.248, 943.659, 957.782, 971.143, 980.596, 986.084, 990.222, 996.058, 1005.1, 1017.42, 1031.37, 1044.65, 1054.02, 1058.02, 1057.68, 1055.65, 1054.41, 1055.49, 1059.38, 1066.09, 1075.99, 1088.97, 1104.3, 1119.99, 1125.1, 1149.64, 1142.81, 1121.24, 1398.67, 1449.16, 1047.68, 1062.36, 1304.93, 1254.01, 997.261, 861.464, 834.422, 880.78, 993.782, 1188.06, 1495.16, 1956.2, 2572.84, 3190.68, 3462.68, 3213.35, 2673.5, 2135.4, 1713.51, 1408.28, 1189.89, 1031.97, 915.174, 826.991, 758.855, 705.271, 662.317, 627.414, 598.639, 574.611, 554.371, 537.13, 522.348, 509.558
};

const G4double G4BaryonWidth::wL1810[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.163031, 2.57372, 9.47523, 22.346, 35.4578, 48.6868, 61.6074, 74.1844, 86.2066, 98.0613, 109.548, 120.673, 131.271, 141.703, 151.802, 161.581, 171.054, 180.088, 188.991, 197.626, 206.003, 214.012, 221.909, 229.601, 237.056, 244.212, 251.302, 258.148, 264.876, 271.369, 277.695, 283.835, 289.972, 296.041, 301.73, 307.201, 312.583, 318.073, 323.554, 328.978, 334.017, 338.66, 343.053, 347.583, 352.315, 357.264, 362.236, 367.165, 371.703, 375.719, 379.294, 382.604, 385.982, 389.509, 393.236, 397.114, 401.291, 405.71, 410.312, 414.868, 416.403, 469.056, 508.301, 538.576, 596.661, 625.963, 600.344, 619.114, 662.2, 669.757, 651.923, 647.055, 653.488, 667.381, 688.395, 718.701, 762.386, 824.631, 905.697, 986.687, 1025.05, 999.278, 937.648, 875.998, 828.368, 794.811, 771.688, 755.77, 744.703, 736.96, 731.509, 727.681, 725.012, 723.191, 721.995, 721.266, 720.89, 720.781, 720.877, 721.131
};
  
const G4double G4BaryonWidth::wL1820[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.000612464, 0.113736, 0.784473, 4.69403, 13.3748, 26.223, 42.5452, 61.8637, 83.2929, 107.01, 132.16, 158.257, 184.429, 211.158, 237.697, 263.787, 289.222, 313.46, 337.19, 359.933, 381.646, 401.995, 421.632, 440.261, 457.864, 474.264, 490.027, 504.84, 518.885, 531.976, 544.413, 556.113, 567.319, 577.993, 587.757, 596.938, 605.652, 614.152, 622.302, 630.131, 637.254, 643.68, 649.58, 655.444, 661.344, 667.315, 673.148, 678.783, 683.833, 688.158, 691.861, 695.16, 698.43, 701.78, 705.273, 708.876, 712.737, 716.81, 721.033, 725.166, 726.54, 761.111, 777.813, 786.063, 828.972, 841.588, 793.509, 798.558, 833.365, 828.899, 796.558, 780.287, 777.991, 785.122, 801.207, 828.648, 872.094, 937.436, 1024.93, 1112.76, 1151.88, 1117.48, 1042.09, 966.953, 908.211, 865.908, 835.827, 814.237, 798.406, 786.568, 777.515, 770.472, 764.889, 760.404, 756.749, 753.732, 751.22, 749.104, 747.31, 745.775
};

const G4double G4BaryonWidth::wL1830[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0374798, 2.04587, 6.47239, 13.6992, 23.9469, 37.7787, 54.5429, 73.773, 94.6442, 117.395, 141.284, 165.943, 190.648, 215.949, 241.225, 266.298, 291.028, 314.92, 338.678, 361.841, 384.358, 405.888, 427.046, 447.589, 467.335, 486.182, 504.707, 522.319, 539.537, 556.028, 571.722, 586.705, 601.713, 616.465, 629.872, 642.297, 654.395, 666.909, 679.511, 691.741, 702.522, 711.844, 720.386, 729.313, 738.969, 749.384, 759.965, 770.24, 779.132, 786.212, 791.79, 796.587, 801.536, 807.016, 813.183, 819.966, 827.639, 836.095, 845.12, 854.052, 857.012, 923.246, 957.111, 973.913, 1073.15, 1099.57, 987.357, 998.048, 1075.68, 1064.24, 990.312, 952.068, 946.032, 961.687, 997.042, 1056.51, 1149.57, 1288.55, 1473.98, 1659.67, 1741.73, 1667.64, 1506.48, 1345.78, 1219.83, 1128.77, 1063.68, 1016.66, 981.929, 955.746, 935.547, 919.688, 906.997, 896.704, 888.234, 881.174, 875.24, 870.195, 865.878, 862.151
};

const G4double G4BaryonWidth::wL1890[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0668762, 1.05886, 4.65994, 12.0381, 22.1384, 33.3915, 44.912, 56.6453, 70.6079, 100.53, 132.617, 162.666, 190.338, 216.77, 241.694, 265.275, 287.646, 308.585, 328.876, 348.248, 366.766, 384.24, 401.245, 417.629, 433.305, 448.218, 462.861, 476.792, 490.435, 503.53, 516.056, 528.071, 540.151, 552.208, 563.105, 573.401, 583.382, 593.846, 604.773, 614.994, 624.436, 632.827, 639.829, 647.653, 657.043, 666.503, 675.498, 685.222, 694.774, 701.899, 706.096, 709.668, 715.007, 722.176, 729.42, 735.352, 741.177, 748.789, 759.061, 770.98, 775.125, 853.009, 925.456, 922.113, 1092.28, 1102.95, 1115.14, 1023.92, 1095.36, 1114.19, 935.047, 1016.69, 1349.72, 1386.46, 1122.73, 1037.21, 1120.34, 1345.82, 1711.63, 2154.37, 2429.06, 2273.29, 1870.1, 1501.91, 1239.04, 1063.73, 948.542, 874.032, 827.684, 802.189, 793.339, 799.167, 819.34, 854.91, 908.458, 984.363, 1088.97, 1231.61, 1423.9, 1679.18
}; 

const G4double G4BaryonWidth::wL2100[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.80338e-06, 0.00549659, 0.0547254, 0.55108, 2.82651, 7.89883, 15.9637, 27.2754, 41.8755, 63.8877, 96.2154, 136.409, 181.176, 230.714, 281.605, 335.948, 392.157, 443.629, 499.096, 564.4, 615.333, 672.089, 728.797, 761.306, 837.632, 860.157, 900.464, 944.374, 986.003, 1025.68, 1055.14, 1133.69, 1161.67, 1168.78, 1204.28, 1230.24, 1242.59, 1346.05, 1305.6, 1388.65, 1337.3, 1362.13, 1408.03, 1425.93, 1531.18, 1423.86, 1470.78, 1599.15, 1492.77, 1569.5, 1518.76, 1699.12, 1513, 1596.01, 1553.22, 1807.76, 1564.71, 1651.51, 1603.19, 1661.68, 1761.9, 1900.68, 1952.58, 1781.9, 2132.59, 2342.41, 2036.19, 1717.02, 1966.55, 1848.73, 2793.25, 1606.12, 1890.04, 2534.61, 1745.04, 1679.07, 1843.63, 2219.26, 3113.64, 3914.83, 3639.84, 3366.09, 2825.67, 2327.53, 1962.49, 1714.25, 1552.09, 1460.35, 1474.49, 2347.32, 1798.88, 1347.18, 1285.03, 1283.47, 1311.78, 1366.37, 1450.31, 1570.78, 1737.62, 1962.53
}; 

const G4double G4BaryonWidth::wL2110[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.000866016, 0.160576, 0.811784, 2.79391, 6.3706, 11.7848, 19.0821, 28.3948, 41.5491, 71.7472, 107.301, 143.627, 179.748, 216.727, 253.878, 291.099, 328.278, 364.709, 401.473, 437.865, 473.782, 508.567, 543.281, 577.278, 610.5, 642.383, 673.938, 704.611, 734.38, 762.758, 790.722, 817.776, 843.868, 869.196, 893.079, 916.733, 939.366, 961.199, 982.285, 1002.22, 1022.05, 1041.45, 1058.72, 1076.22, 1094.27, 1110.54, 1124.8, 1140.16, 1156.62, 1171.44, 1183.42, 1194.86, 1208.51, 1223.69, 1237.38, 1247.27, 1255.2, 1264.15, 1275.87, 1289.73, 1294.66, 1432.97, 1558.49, 1553.36, 1645.56, 1606.26, 1913.61, 1716.01, 1648.3, 1708.91, 1558.93, 1808.07, 2470.06, 2497.8, 1881.49, 1549.05, 1445.66, 1481.65, 1653.98, 1977.38, 2274.49, 2178.21, 1848.53, 1588.18, 1434.37, 1350.69, 1308.88, 1293.8, 1297.95, 1318.11, 1353.71, 1405.89, 1477.58, 1573.31, 1700.02, 1867.76, 2090.12, 2386.48, 2780.57, 3299.5
};
  
const G4double G4BaryonWidth::wS1385[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.43483, 19.8083, 40.3323, 61.0499, 81.5715, 101.296, 120.7, 139.361, 157.234, 174.038, 190.333, 205.859, 220.647, 234.509, 247.935, 260.73, 272.929, 284.567, 295.503, 306.127, 316.285, 326.005, 335.166, 344.093, 352.655, 360.874, 368.645, 376.24, 383.546, 390.581, 397.25, 403.788, 410.094, 416.182, 422.062, 427.655, 433.154, 438.475, 443.627, 448.539, 453.378, 458.07, 462.623, 466.971, 471.264, 475.435, 479.489, 483.368, 487.204, 490.938, 494.572, 498.112, 501.505, 504.868, 508.146, 511.343, 514.413, 517.458, 520.432, 523.335, 526.126, 527.072, 569.149, 598.909, 621.108, 638.366, 652.164, 663.476, 672.91, 680.913, 687.78, 693.748, 698.975, 703.595, 707.712, 711.399, 714.725, 717.736, 720.479, 722.984, 725.286, 727.404, 729.363, 731.177, 732.863, 734.436, 735.904, 737.279, 738.568, 739.781, 740.923, 742.001, 743.019, 743.983, 744.896, 745.763, 746.588, 747.372, 748.12, 748.833, 749.515
};

const G4double G4BaryonWidth::wS1660[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.34523, 6.65594, 17.6488, 33.1233, 54.3656, 74.7316, 94.8904, 114.471, 133.448, 151.522, 169.283, 186.441, 203.009, 218.752, 234.207, 249.132, 263.551, 277.486, 290.746, 303.786, 316.406, 328.626, 340.278, 351.76, 362.897, 373.704, 384.03, 394.227, 404.138, 413.775, 423.001, 432.131, 441.021, 449.681, 458.122, 466.222, 474.253, 482.091, 489.742, 497.095, 504.397, 511.534, 518.511, 525.225, 531.902, 538.436, 544.833, 550.995, 557.131, 563.143, 569.034, 574.809, 580.381, 585.936, 591.385, 596.732, 601.896, 607.049, 612.108, 617.077, 621.88, 623.514, 699.424, 757.381, 803.259, 840.66, 871.747, 898.072, 920.636, 940.234, 957.395, 972.578, 986.086, 998.195, 1009.12, 1019.02, 1028.04, 1036.28, 1043.85, 1050.82, 1057.27, 1063.24, 1068.8, 1073.98, 1078.81, 1083.35, 1087.6, 1091.6, 1095.37, 1098.93, 1102.29, 1105.47, 1108.49, 1111.35, 1114.07, 1116.67, 1119.14, 1121.49, 1123.75, 1125.9, 1127.96
};

const G4double G4BaryonWidth::wS1670[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0540702, 0.631535, 4.23922, 11.2488, 22.4509, 36.3456, 52.6497, 70.5776, 89.6448, 109.122, 129.318, 149.646, 169.887, 189.555, 209.164, 228.294, 246.876, 264.86, 281.943, 298.668, 314.744, 330.174, 344.733, 358.912, 372.484, 385.469, 397.692, 409.576, 420.937, 431.8, 442.021, 451.959, 461.462, 470.553, 479.251, 487.445, 495.42, 503.057, 510.373, 517.274, 524, 530.45, 536.639, 542.484, 548.191, 553.672, 558.938, 563.921, 568.792, 573.478, 577.988, 582.33, 586.446, 590.478, 594.364, 598.11, 601.667, 605.156, 608.524, 611.776, 614.868, 615.908, 658.062, 682.84, 698.539, 709.102, 716.527, 721.95, 726.022, 729.162, 731.629, 733.605, 735.21, 736.532, 737.635, 738.564, 739.353, 740.029, 740.614, 741.121, 741.566, 741.957, 742.303, 742.61, 742.885, 743.131, 743.352, 743.552, 743.733, 743.898, 744.048, 744.185, 744.311, 744.427, 744.533, 744.631, 744.722, 744.806, 744.885, 744.957, 745.025
}; 
  
const G4double G4BaryonWidth::wS1750[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.508819, 1.76035, 13.4629, 23.5792, 29.7383, 34.4445, 38.2189, 116.784, 170.863, 207.052, 234.924, 257.727, 276.713, 293.383, 307.978, 320.895, 332.428, 342.637, 352.027, 360.561, 368.35, 375.376, 381.944, 388.001, 393.602, 398.712, 403.542, 408.038, 412.234, 416.094, 419.769, 423.217, 426.455, 429.501, 432.325, 435.034, 437.593, 440.012, 442.266, 444.437, 446.497, 448.453, 450.283, 452.053, 453.738, 455.344, 456.852, 458.314, 459.712, 461.047, 462.325, 463.528, 464.7, 465.823, 466.901, 467.918, 468.911, 469.865, 470.783, 471.651, 471.942, 483.418, 489.886, 493.887, 496.539, 498.384, 499.722, 500.722, 501.489, 502.091, 502.571, 502.961, 503.281, 503.548, 503.773, 503.963, 504.127, 504.268, 504.39, 504.497, 504.591, 504.674, 504.748, 504.814, 504.874, 504.927, 504.975, 505.018, 505.058, 505.094, 505.127, 505.157, 505.185, 505.211, 505.234, 505.256, 505.276, 505.295, 505.312, 505.329
};

const G4double G4BaryonWidth::wS1775[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.109395, 1.12574, 3.17371, 7.17576, 16.9941, 33.5385, 57.7761, 85.8023, 116.419, 148.274, 181.77, 215.874, 250.171, 283.788, 317.579, 350.804, 383.321, 415.032, 445.379, 475.312, 504.303, 532.338, 559.001, 585.148, 610.401, 634.706, 657.785, 680.452, 702.128, 723.109, 743.175, 762.602, 781.149, 799.32, 817.085, 833.659, 849.44, 864.678, 879.954, 895.034, 909.865, 923.54, 935.882, 947.169, 958.461, 970.056, 982.104, 994.238, 1006.4, 1017.8, 1028.02, 1037.08, 1045.25, 1053.31, 1061.45, 1069.79, 1078.18, 1086.9, 1095.83, 1104.89, 1113.72, 1116.68, 1216.13, 1289.75, 1286.8, 1365.07, 1391.54, 1312.12, 1356.95, 1495.87, 1611.1, 1678.08, 1726.23, 1724.13, 1672.59, 1603.63, 1548.55, 1527.56, 1552.59, 1624.89, 1715.35, 1752.74, 1687.41, 1555.7, 1421.55, 1313.83, 1234.04, 1175.55, 1132.2, 1099.35, 1073.95, 1053.91, 1037.84, 1024.75, 1013.98, 1005, 997.467, 991.102, 985.689, 981.073, 977.118
};

const G4double G4BaryonWidth::wS1915[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0138455, 0.320438, 1.50127, 4.23235, 9.50349, 18.1414, 30.2739, 45.7144, 64.3582, 85.6283, 109.936, 136.604, 165.241, 194.941, 226.276, 258.381, 290.896, 323.499, 355.386, 387.367, 418.719, 449.284, 478.469, 507.137, 534.749, 561.251, 586.235, 610.525, 633.668, 655.736, 676.438, 696.401, 715.331, 733.374, 750.565, 766.562, 781.882, 796.403, 810.299, 823.411, 836.087, 847.993, 859.115, 869.422, 879.437, 889.123, 898.53, 907.488, 916.191, 924.353, 931.884, 938.812, 945.17, 951.333, 957.319, 963.191, 968.885, 974.608, 980.284, 985.903, 991.313, 993.129, 1051.6, 1081.72, 1097.55, 1127.23, 1142.79, 1117.03, 1120.73, 1142.41, 1143.58, 1125.62, 1116.24, 1115.03, 1119.19, 1128.36, 1143.85, 1168.3, 1205.2, 1255.47, 1308.58, 1337.35, 1322.99, 1280.41, 1235.27, 1199.27, 1173.24, 1154.79, 1141.61, 1132, 1124.87, 1119.44, 1115.25, 1111.95, 1109.31, 1107.18, 1105.42, 1103.97, 1102.75, 1101.73, 1100.85
};

const G4double G4BaryonWidth::wS1940[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0789079, 0.833069, 2.92385, 6.95982, 16.0306, 33.5919, 54.272, 78.8874, 109.593, 144.898, 189.352, 227.639, 262.184, 293.948, 324.598, 353.928, 382.135, 409.341, 435.215, 460.664, 485.303, 509.169, 531.929, 554.349, 576.089, 597.149, 617.249, 637.077, 656.244, 674.858, 692.674, 710.176, 727.089, 743.563, 759.621, 774.831, 789.731, 804.194, 818.423, 832.266, 845.8, 858.778, 871.113, 882.539, 893.927, 905.395, 916.677, 927.537, 938.589, 949.535, 959.845, 969.306, 978.217, 987.358, 996.609, 1005.57, 1013.77, 1021.65, 1029.51, 1037.61, 1045.72, 1048.48, 1156.81, 1241.58, 1248.4, 1302.91, 1315.21, 1328.75, 1349.47, 1434.02, 1541.93, 1613.02, 1697.08, 1765.39, 1720.37, 1587.43, 1486.35, 1427.78, 1408.9, 1428.79, 1476.77, 1509.39, 1471.56, 1389.12, 1313.42, 1257.61, 1217.96, 1188.88, 1166.54, 1148.63, 1134.04, 1122.29, 1113.34, 1107.38, 1104.83, 1106.3, 1112.66, 1125.17, 1145.59, 1176.12, 1219.32
};

const G4double G4BaryonWidth::wS2030[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00689107, 0.158875, 0.672308, 1.8109, 4.35018, 8.83354, 16.5499, 27.7235, 42.7971, 63.0194, 90.6356, 126.187, 168.787, 216.237, 268.657, 323.948, 380.924, 438.601, 495.267, 552.181, 607.949, 662.235, 713.986, 764.709, 813.512, 860.257, 904.311, 947.176, 987.877, 1026.8, 1063.49, 1098.73, 1132.06, 1164.11, 1194.93, 1223.41, 1250.44, 1276.14, 1301.26, 1325.51, 1348.9, 1370.53, 1390.21, 1407.97, 1425.48, 1443.13, 1460.74, 1477.8, 1494.81, 1510.91, 1525.25, 1537.69, 1548.87, 1560.07, 1571.45, 1582.71, 1593.36, 1603.95, 1614.76, 1626, 1637.2, 1640.97, 1751.61, 1823.25, 1807.74, 1881.02, 1898.13, 1846.76, 1855.93, 1953.37, 2033.63, 2046.58, 2093.49, 2145.89, 2103.09, 1988.62, 1921.38, 1916.59, 1977.71, 2105.08, 2269.01, 2377.76, 2342.77, 2213.38, 2082.54, 1981.47, 1906.18, 1846.08, 1793.53, 1744.3, 1697, 1651.59, 1608.92, 1569.94, 1535.75, 1507.36, 1485.83, 1472.51, 1469.03, 1477.51, 1500.25
};
  
const G4double G4BaryonWidth::wX1530[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00237721, 0.0342598, 0.574924, 7.68701, 15.0598, 22.6625, 30.2129, 37.6029, 44.6523, 51.5544, 58.1718, 64.4977, 70.438, 76.1939, 81.6753, 86.8938, 91.8619, 96.5183, 101.028, 105.327, 109.425, 113.275, 117.011, 120.582, 123.996, 127.211, 130.34, 133.339, 136.215, 138.931, 141.583, 144.131, 146.581, 148.938, 151.172, 153.36, 155.469, 157.504, 159.437, 161.334, 163.168, 164.941, 166.628, 168.289, 169.897, 171.454, 172.94, 174.405, 175.826, 177.205, 178.544, 179.824, 181.089, 182.318, 183.514, 184.658, 185.791, 186.894, 187.968, 188.998, 189.346, 204.531, 214.89, 222.405, 228.12, 232.609, 236.236, 239.224, 241.733, 243.867, 245.707, 247.307, 248.713, 249.96, 251.071, 252.069, 252.969, 253.786, 254.53, 255.211, 255.837, 256.413, 256.946, 257.441, 257.901, 258.33, 258.731, 259.106, 259.458, 259.79, 260.102, 260.397, 260.675, 260.939, 261.189, 261.427, 261.653, 261.868, 262.072, 262.268
}; 

const G4double G4BaryonWidth::wX1690[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0763157, 1.19538, 2.43041, 17.1344, 56.614, 115.797, 165.003, 209.344, 249.404, 286.017, 319.219, 350.503, 379.618, 406.817, 432.307, 455.887, 478.475, 499.801, 519.976, 538.797, 556.964, 574.239, 590.688, 606.125, 621.111, 635.436, 649.145, 662.071, 674.675, 686.775, 698.401, 709.581, 720.173, 730.546, 740.547, 750.195, 759.363, 768.368, 777.073, 785.495, 793.518, 801.418, 809.073, 816.496, 823.583, 830.577, 837.368, 843.966, 850.38, 856.518, 862.589, 868.498, 874.251, 879.765, 885.229, 890.554, 895.747, 900.732, 902.421, 976.795, 1028.66, 1067.02, 1096.67, 1120.3, 1139.62, 1155.7, 1169.33, 1181.01, 1191.16, 1200.04, 1207.89, 1214.88, 1221.14, 1226.79, 1231.9, 1236.56, 1240.81, 1244.72, 1248.31, 1251.64, 1254.72, 1257.58, 1260.25, 1262.74, 1265.08, 1267.27, 1269.33, 1271.27, 1273.1, 1274.83, 1276.47, 1278.02, 1279.49, 1280.89, 1282.22, 1283.49, 1284.71, 1285.86
};

const G4double G4BaryonWidth::wX1820[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00396219, 0.187158, 0.570095, 2.21304, 7.48292, 15.6029, 24.9587, 35.1774, 45.7246, 56.3498, 66.7173, 77.0552, 87.1167, 96.8526, 106.233, 115.098, 123.733, 131.99, 139.875, 147.278, 154.453, 161.289, 167.801, 173.905, 179.816, 185.445, 190.808, 195.837, 200.71, 205.356, 209.787, 214.015, 217.987, 221.844, 225.528, 229.049, 232.363, 235.587, 238.672, 241.626, 244.412, 247.126, 249.729, 252.227, 254.586, 256.889, 259.102, 261.228, 263.273, 265.209, 267.103, 268.926, 270.683, 272.348, 273.98, 275.554, 277.073, 278.515, 279, 298.538, 309.919, 317.091, 321.9, 325.273, 327.733, 329.577, 330.998, 332.113, 333.007, 333.732, 334.329, 334.827, 335.246, 335.602, 335.907, 336.171, 336.4, 336.6, 336.777, 336.933, 337.071, 337.195, 337.306, 337.406, 337.496, 337.577, 337.652, 337.719, 337.781, 337.838, 337.89, 337.938, 337.982, 338.023, 338.061, 338.096, 338.129, 338.16
}; 

const G4double G4BaryonWidth::wX1950[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.100617, 1.59133, 3.2792, 8.34497, 17.6234, 29.1125, 39.8892, 50.3908, 60.4791, 70.1831, 79.3785, 88.3872, 97.0743, 105.457, 113.553, 121.251, 128.819, 136.143, 143.233, 149.994, 156.658, 163.123, 169.398, 175.395, 181.321, 187.082, 192.687, 198.056, 203.372, 208.551, 213.6, 218.524, 223.251, 227.942, 232.523, 236.998, 241.302, 245.579, 249.762, 253.855, 257.796, 261.719, 265.561, 269.324, 272.952, 276.568, 280.113, 283.59, 287.001, 290.295, 293.581, 296.807, 299.975, 303.036, 306.094, 309.099, 312.052, 314.908, 315.88, 361.355, 396.526, 424.689, 447.879, 467.326, 483.922, 498.244, 510.761, 521.781, 531.578, 540.333, 548.213, 555.349, 561.833, 567.761, 573.192, 578.196, 582.813, 587.095, 591.069, 594.774, 598.232, 601.468, 604.506, 607.359, 610.048, 612.582, 614.979, 617.245, 619.395, 621.434, 623.373, 625.217, 626.974, 628.651, 630.251, 631.782, 633.246, 634.649
}; 
  
const G4double G4BaryonWidth::wX2030[120] =
{ 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.05812e-05, 0.0112536, 0.0516028, 0.159053, 0.54036, 1.94631, 4.55324, 8.37141, 13.2405, 18.9996, 25.3629, 32.3631, 39.7317, 47.316, 54.9838, 62.5026, 70.0316, 77.3782, 84.4916, 91.2278, 97.7845, 104.036, 109.976, 115.517, 120.847, 125.88, 130.628, 135.032, 139.25, 143.222, 146.961, 150.481, 153.743, 156.868, 159.811, 162.585, 165.16, 167.63, 169.962, 172.164, 174.212, 176.182, 178.046, 179.811, 181.458, 183.045, 184.551, 185.98, 187.338, 188.609, 189.839, 191.009, 192.123, 193.169, 194.183, 195.15, 196.074, 196.942, 197.233, 208.093, 213.639, 216.816, 218.798, 220.111, 221.025, 221.686, 222.179, 222.555, 222.85, 223.084, 223.274, 223.43, 223.559, 223.667, 223.759, 223.837, 223.905, 223.963, 224.014, 224.059, 224.099, 224.134, 224.165, 224.193, 224.218, 224.241, 224.261, 224.28, 224.297, 224.312, 224.326, 224.339, 224.351, 224.362, 224.372, 224.382, 224.391, 224.399
}; 
  

G4BaryonWidth::G4BaryonWidth(): wSize(120)
{ 
  wMap["N(1440)"] = (G4double*) wN1440;
  wMap["N(1520)"] = (G4double*) wN1520;
  wMap["N(1535)"] = (G4double*) wN1535;
  wMap["N(1650)"] = (G4double*) wN1650;
  wMap["N(1675)"] = (G4double*) wN1675;
  wMap["N(1680)"] = (G4double*) wN1680;
  wMap["N(1700)"] = (G4double*) wN1700;
  wMap["N(1710)"] = (G4double*) wN1710;
  wMap["N(1720)"] = (G4double*) wN1720;
  wMap["N(1900)"] = (G4double*) wN1900;
  wMap["N(1990)"] = (G4double*) wN1990;
  wMap["N(2090)"] = (G4double*) wN2090;
  wMap["N(2190)"] = (G4double*) wN2190;
  wMap["N(2220)"] = (G4double*) wN2220;

  wMap["delta"] = (G4double*) wDelta;

  wMap["delta(1600)"] = (G4double*) wD1600;
  wMap["delta(1620)"] = (G4double*) wD1620;
  wMap["delta(1700)"] = (G4double*) wD1700;
  wMap["delta(1900)"] = (G4double*) wD1900;
  wMap["delta(1905)"] = (G4double*) wD1905;
  wMap["delta(1910)"] = (G4double*) wD1910;
  wMap["delta(1920)"] = (G4double*) wD1920;
  wMap["delta(1930)"] = (G4double*) wD1930;
  wMap["delta(1950)"] = (G4double*) wD1950;

  wMap["lambda(1405)"] = (G4double*) wL1405;
  wMap["lambda(1520)"] = (G4double*) wL1520;
  wMap["lambda(1600)"] = (G4double*) wL1600;
  wMap["lambda(1670)"] = (G4double*) wL1670;
  wMap["lambda(1690)"] = (G4double*) wL1690;
  wMap["lambda(1800)"] = (G4double*) wL1800;
  wMap["lambda(1810)"] = (G4double*) wL1810;
  wMap["lambda(1820)"] = (G4double*) wL1820;
  wMap["lambda(1830)"] = (G4double*) wL1830;
  wMap["lambda(1890)"] = (G4double*) wL1890;
  wMap["lambda(2100)"] = (G4double*) wL2100;
  wMap["lambda(2110)"] = (G4double*) wL2110;

  wMap["sigma(1385)"] = (G4double*) wS1385;
  wMap["sigma(1660)"] = (G4double*) wS1660;
  wMap["sigma(1670)"] = (G4double*) wS1670;
  wMap["sigma(1750)"] = (G4double*) wS1750;
  wMap["sigma(1775)"] = (G4double*) wS1775;
  wMap["sigma(1915)"] = (G4double*) wS1915;
  wMap["sigma(1940)"] = (G4double*) wS1940;
  wMap["sigma(2030)"] = (G4double*) wS2030;

  wMap["xi(1530)"] = (G4double*) wX1530;
  wMap["xi(1690)"] = (G4double*) wX1690;
  wMap["xi(1820)"] = (G4double*) wX1820;
  wMap["xi(1950)"] = (G4double*) wX1950;
  wMap["xi(2030)"] = (G4double*) wX2030;


}


G4BaryonWidth::~G4BaryonWidth()
{ }


G4bool G4BaryonWidth::operator==(const G4BaryonWidth &right) const
{
  return (this == (G4BaryonWidth*) &right);
}


G4bool G4BaryonWidth::operator!=(const G4BaryonWidth &right) const
{
  return (this != (G4BaryonWidth*) &right);
}


G4PhysicsVector* G4BaryonWidth::MassDependentWidth(const G4String& name) const
{
  // NOTE: the returned pointer is owned by the client

  if (wMap.find(name) != wMap.end())
    {
      // width of the requested particle available in the Map
      G4PhysicsFreeVector* wVector = new G4PhysicsFreeVector(wSize);
      G4String key = name;
      std::map <G4String, G4double*, std::less<G4String> >::const_iterator iter;
      G4double* wPointer=0;
      for (iter = wMap.begin(); iter != wMap.end(); ++iter)
	{
	  G4String str = (*iter).first;
          if (str == key)
	    {
	      wPointer = (*iter).second; 
	    }
	}
      //     G4double* wPointer = wMap[key];
      G4int i;
      for (i=0; i<wSize; i++)
	{
	  G4double value = *(wPointer + i);
	  G4double energy = baryonEnergyTable[i] * GeV;
	  wVector->PutValue(i,energy,value);
	}	          
      return wVector;
    }
  else
    {
      return 0;
    }
}
