//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//

#include "G4CascadeKminusNChannel.hh"
#include "G4InuclParticleNames.hh"
using namespace G4InuclParticleNames;

namespace {
  // Outgoing particle types of a given multiplicity

  static const G4int kmn2bfs[5][2] =
    {{kmi,neu}, {pim,lam}, {pim,s0}, {pi0,sm}, {k0,xim}}; 

  static const G4int kmn3bfs[15][3] =
    {{kmi,pro,pim}, {kmi,neu,pi0}, {k0b,neu,pim}, {pim,pi0,lam}, {pim,pim,sp},
     {pim,pi0,s0},  {pi0,pi0,sm},  {pip,pim,sm},  {kmi,k0,lam},  {kmi,k0,s0},
     {k0,k0b,sm},   {kpl,kmi,sm},  {k0,pim,xi0},  {k0,pi0,xim},  {kpl,pim,xim}};

  static const G4int kmn4bfs[34][4] =
    {{pro,pim,pi0,kmi}, {pro,pim,pim,k0b}, {neu,pi0,pi0,kmi}, {neu,pip,pim,kmi},
     {neu,pim,pi0,k0b}, {pim,pi0,pi0,lam}, {pip,pim,pim,lam}, {pim,pim,pi0,sp},
     {pim,pi0,pi0,s0},  {pip,pim,pim,s0},  {pi0,pi0,pi0,sm},  {pip,pim,pi0,sm}, 
     {pim,pi0,k0,xi0},  {pim,pim,kpl,xi0}, {pi0,pi0,k0,xim},  {pip,pim,k0,xim},
     {pim,pi0,kpl,xim}, {pro,kmi,kmi,k0},  {neu,kpl,kmi,kmi}, {neu,kmi,k0,k0b},
     {pim,kpl,kmi,lam}, {pim,k0,k0b,lam},  {pi0,kmi,k0,lam},  {pim,kmi,k0,sp}, 
     {pim,kpl,kmi,s0},  {pim,k0,k0b,s0},   {pi0,kmi,k0,s0},   {pip,kmi,k0,sm},
     {pim,kpl,k0b,sm},  {pi0,k0,k0b,sm},   {pi0,kpl,kmi,sm},  {xi0,kmi,k0,k0},
     {xim,k0,k0,k0b},   {xim,kpl,kmi,k0}};

  static const G4int kmn5bfs[58][5] =
    {{pro,pim,pi0,pi0,kmi}, {pro,pip,pim,pim,kmi}, {pro,pim,pim,pi0,k0b},
     {neu,pi0,pi0,pi0,kmi}, {neu,pip,pim,pi0,kmi}, {neu,pim,pi0,pi0,k0b},
     {neu,pip,pim,pim,k0b}, {pro,pim,kmi,k0,k0b},  {pro,pim,kpl,kmi,kmi},
     {pro,pi0,kmi,kmi,k0},  {neu,pim,kpl,kmi,k0b}, {neu,pi0,kmi,k0,k0b},
     {neu,pi0,kpl,kmi,kmi}, {neu,pip,kmi,kmi,k0},  {neu,pim,k0,k0b,k0b}, 
     {pim,pi0,pi0,pi0,lam}, {pip,pim,pim,pi0,lam}, {pi0,pi0,kmi,k0,lam},
     {pip,pim,kmi,k0,lam},  {pim,pi0,k0,k0b,lam},  {pim,pi0,kpl,kmi,lam},
     {pim,pim,kpl,k0b,lam}, {pim,pim,pi0,pi0,sp},  {pip,pim,pim,pim,sp},
     {pim,pi0,kmi,k0,sp},   {pim,pim,kpl,kmi,sp},  {pim,pim,k0,k0b,sp},
     {pim,pi0,pi0,pi0,s0},  {pip,pim,pim,pi0,s0},  {pi0,pi0,kmi,k0,s0},
     {pip,pim,kmi,k0,s0},   {pim,pi0,k0,k0b,s0},   {pim,pi0,kpl,kmi,s0},
     {pim,pim,kpl,k0b,s0},  {pi0,pi0,pi0,pi0,sm},  {pip,pim,pi0,pi0,sm},
     {pip,pip,pim,pim,sm},  {pi0,pi0,k0,k0b,sm},   {pip,pim,k0,k0b,sm},
     {pi0,pi0,kpl,kmi,sm},  {pip,pim,kpl,kmi,sm},  {pim,pi0,kpl,k0b,sm},
     {pip,pi0,kmi,k0,sm},   {pim,pi0,pi0,k0,xi0},  {pip,pim,pim,k0,xi0},
     {pim,pim,pi0,kpl,xi0}, {pi0,pi0,pi0,k0,xim},  {pip,pim,pi0,k0,xim},
     {pim,pi0,pi0,kpl,xim}, {pip,pim,pim,kpl,xim}, {pim,kpl,kmi,k0,xi0}, 
     {pi0,kpl,kmi,k0,xim},  {pim,kpl,k0,k0b,xim},  {pim,k0,k0,k0b,xi0}, 
     {pi0,k0,k0,k0b,xim},   {pim,kpl,kpl,kmi,xim}, {pi0,kmi,k0,k0,xi0}, 
     {pip,kmi,k0,k0,xim}};

  static const G4int kmn6bfs[70][6] =
    {{pro,pip,pim,pim,pi0,kmi}, {pro,pim,pim,pi0,pi0,k0b},
     {pro,pim,pi0,pi0,pi0,kmi}, {pro,pip,pim,pim,pim,k0b},
     {neu,pip,pim,pi0,pi0,kmi}, {neu,pip,pim,pim,pi0,k0b},
     {neu,pip,pip,pim,pim,kmi}, {neu,pim,pi0,pi0,pi0,k0b},
     {neu,pi0,pi0,pi0,pi0,kmi}, {pro,pim,pi0,kmi,k0,k0b},  
     {pro,pim,pim,kpl,kmi,k0b}, {pro,pim,pi0,kpl,kmi,kmi}, 
     {pro,pip,pim,kmi,kmi,k0},  {pro,pim,pim,k0,k0b,k0b},
     {pro,pi0,pi0,kmi,kmi,k0},  {neu,pim,pi0,kpl,kmi,k0b},
     {neu,pip,pim,kmi,k0,k0b},  {neu,pip,pim,kpl,kmi,kmi},
     {neu,pim,pi0,k0,k0b,k0b},  {neu,pi0,pi0,kmi,k0,k0b},
     {neu,pip,pi0,kmi,kmi,k0},  {neu,pim,pim,kpl,k0b,k0b},
     {neu,pi0,pi0,kpl,kmi,kmi}, {pip,pim,pim,pi0,pi0,lam},
     {pip,pip,pim,pim,pim,lam}, {pim,pi0,pi0,pi0,pi0,lam},
     {pip,pim,pi0,kmi,k0,lam},  {pim,pim,pi0,kpl,k0b,lam},
     {pim,pi0,pi0,kpl,kmi,lam}, {pip,pim,pim,kpl,kmi,lam},
     {pim,pi0,pi0,k0,k0b,lam},  {pip,pim,pim,k0,k0b,lam},
     {pi0,pi0,pi0,kmi,k0,lam},  {pim,pim,pi0,pi0,pi0,sp},
     {pip,pim,pim,pim,pi0,sp},  {pim,pim,pi0,kpl,kmi,sp},
     {pim,pim,pi0,k0,k0b,sp},   {pim,pi0,pi0,kmi,k0,sp},
     {pip,pim,pim,kmi,k0,sp},   {pim,pim,pim,kpl,k0b,sp},
     {pip,pim,pim,pi0,pi0,s0},  {pip,pip,pim,pim,pim,s0},
     {pim,pi0,pi0,pi0,pi0,s0},  {pip,pim,pi0,kmi,k0,s0},
     {pim,pim,pi0,kpl,k0b,s0},  {pim,pi0,pi0,kpl,kmi,s0},
     {pip,pim,pim,kpl,kmi,s0},  {pim,pi0,pi0,k0,k0b,s0},
     {pip,pim,pim,k0,k0b,s0},   {pi0,pi0,pi0,kmi,k0,s0},
     {pip,pip,pim,pim,pi0,sm},  {pip,pim,pi0,pi0,pi0,sm},
     {pi0,pi0,pi0,pi0,pi0,sm},  {pip,pim,pi0,kpl,kmi,sm},
     {pip,pim,pi0,k0,k0b,sm},   {pim,pi0,pi0,kpl,k0b,sm},
     {pip,pim,pim,kpl,k0b,sm},  {pip,pi0,pi0,kmi,k0,sm},
     {pip,pip,pim,kmi,k0,sm},   {pi0,pi0,pi0,kpl,kmi,sm},
     {pi0,pi0,pi0,k0,k0b,sm},   {pip,pim,pim,pi0,kpl,xim},
     {pip,pim,pim,pi0,k0,xi0},  {pip,pim,pi0,pi0,k0,xim},
     {pip,pip,pim,pim,k0,xim},  {pim,pim,pi0,pi0,kpl,xi0},
     {pim,pi0,pi0,pi0,k0,xi0},  {pip,pim,pim,pim,kpl,xi0},
     {pim,pi0,pi0,pi0,kpl,xim}, {pi0,pi0,pi0,pi0,k0,xim}};

  static const G4int kmn7bfs[89][7] =
    {{pro,pip,pim,pim,pim,pi0,k0b}, {pro,pip,pim,pim,pi0,pi0,kmi},
     {pro,pim,pi0,pi0,pi0,pi0,kmi}, {pro,pim,pim,pi0,pi0,pi0,k0b},
     {pro,pip,pip,pim,pim,pim,kmi}, {neu,pi0,pi0,pi0,pi0,pi0,kmi},
     {neu,pip,pim,pi0,pi0,pi0,kmi}, {neu,pip,pim,pim,pi0,pi0,k0b},
     {neu,pip,pip,pim,pim,pi0,kmi}, {neu,pim,pi0,pi0,pi0,pi0,k0b},
     {neu,pip,pip,pim,pim,pim,k0b}, {pro,pim,pi0,pi0,kpl,kmi,kmi},
     {pro,pip,pim,pim,kpl,kmi,kmi}, {pro,pim,pim,pi0,k0,k0b,k0b},
     {pro,pim,pim,pi0,kpl,kmi,k0b}, {pro,pim,pi0,pi0,kmi,k0,k0b},
     {pro,pip,pim,pim,kmi,k0,k0b},  {pro,pip,pim,pi0,kmi,kmi,k0},
     {pro,pim,pim,pim,kpl,k0b,k0b}, {pro,pi0,pi0,pi0,kmi,kmi,k0},
     {neu,pim,pim,pi0,kpl,k0b,k0b}, {neu,pim,pi0,pi0,k0,k0b,k0b},
     {neu,pip,pim,pim,k0,k0b,k0b},  {neu,pip,pi0,pi0,kmi,kmi,k0},
     {neu,pip,pip,pim,kmi,kmi,k0},  {neu,pim,pi0,pi0,kpl,kmi,k0b},
     {neu,pip,pim,pim,kpl,kmi,k0b}, {neu,pip,pim,pi0,kpl,kmi,kmi},
     {neu,pi0,pi0,pi0,kpl,kmi,kmi}, {neu,pi0,pi0,pi0,kmi,k0,k0b},
     {neu,pip,pim,pi0,kmi,k0,k0b},  {pim,pi0,pi0,pi0,pi0,pi0,lam},
     {pip,pim,pim,pi0,pi0,pi0,lam}, {pip,pip,pim,pim,pim,pi0,lam},
     {pip,pim,pim,pi0,kpl,kmi,lam}, {pip,pim,pim,pi0,k0,k0b,lam},
     {pip,pim,pi0,pi0,kmi,k0,lam},  {pip,pim,pim,pim,kpl,k0b,lam},
     {pim,pi0,pi0,pi0,kpl,kmi,lam}, {pim,pi0,pi0,pi0,k0,k0b,lam}, 
     {pim,pim,pi0,pi0,kpl,k0b,lam}, {pip,pip,pim,pim,kmi,k0,lam},
     {pi0,pi0,pi0,pi0,kmi,k0,lam},  {pim,pim,pi0,pi0,pi0,pi0,sp},
     {pip,pip,pim,pim,pim,pim,sp},  {pip,pim,pim,pim,pi0,pi0,sp}, 
     {pip,pim,pim,pi0,kmi,k0,sp},   {pim,pim,pim,pi0,kpl,k0b,sp},
     {pip,pim,pim,pim,kpl,kmi,sp},  {pip,pim,pim,pim,k0,k0b,sp},
     {pim,pi0,pi0,pi0,kmi,k0,sp},   {pim,pim,pi0,pi0,kpl,kmi,sp},
     {pim,pim,pi0,pi0,k0,k0b,sp},   {pim,pi0,pi0,pi0,pi0,pi0,s0},
     {pip,pim,pim,pi0,pi0,pi0,s0},  {pip,pip,pim,pim,pim,pi0,s0},
     {pip,pim,pim,pi0,kpl,kmi,s0},  {pip,pim,pim,pi0,k0,k0b,s0},
     {pip,pim,pi0,pi0,kmi,k0,s0},   {pip,pim,pim,pim,kpl,k0b,s0},
     {pim,pi0,pi0,pi0,kpl,kmi,s0},  {pim,pi0,pi0,pi0,k0,k0b,s0},
     {pim,pim,pi0,pi0,kpl,k0b,s0},  {pip,pip,pim,pim,kmi,k0,s0},
     {pi0,pi0,pi0,pi0,kmi,k0,s0},   {pi0,pi0,pi0,pi0,pi0,pi0,sm},
     {pip,pim,pi0,pi0,pi0,pi0,sm},  {pip,pip,pim,pim,pi0,pi0,sm},
     {pip,pip,pip,pim,pim,pim,sm},  {pip,pim,pim,pi0,kpl,k0b,sm},
     {pip,pim,pi0,pi0,kpl,kmi,sm},  {pip,pim,pi0,pi0,k0,k0b,sm},
     {pip,pip,pim,pi0,kmi,k0,sm},   {pip,pip,pim,pim,kpl,kmi,sm},
     {pip,pip,pim,pim,k0,k0b,sm},   {pim,pi0,pi0,pi0,kpl,k0b,sm},
     {pip,pi0,pi0,pi0,kmi,k0,sm},   {pi0,pi0,pi0,pi0,kpl,kmi,sm},
     {pi0,pi0,pi0,pi0,k0,k0b,sm},   {pim,pi0,pi0,pi0,pi0,kpl,xim},
     {pim,pi0,pi0,pi0,pi0,k0,xi0},  {pip,pim,pim,pi0,pi0,kpl,xim},
     {pip,pip,pim,pim,pi0,k0,xim},  {pip,pim,pim,pi0,pi0,k0,xi0},
     {pip,pim,pi0,pi0,pi0,k0,xim},  {pip,pim,pim,pim,pi0,kpl,xi0},
     {pip,pip,pim,pim,pim,kpl,xim}, {pim,pim,pi0,pi0,pi0,kpl,xi0},
     {pip,pip,pim,pim,pim,k0,xi0}};

  static const G4int kmn8bfs[39][8] =
    {{pro,pim,pi0,pi0,pi0,pi0,pi0,kmi}, {pro,pip,pim,pim,pim,pi0,pi0,k0b},
     {pro,pip,pip,pim,pim,pim,pi0,kmi}, {pro,pip,pim,pim,pi0,pi0,pi0,kmi},
     {pro,pim,pim,pi0,pi0,pi0,pi0,k0b}, {pro,pip,pip,pim,pim,pim,pim,k0b},
     {neu,pip,pim,pi0,pi0,pi0,pi0,kmi}, {neu,pip,pip,pim,pim,pi0,pi0,kmi},
     {neu,pip,pip,pip,pim,pim,pim,kmi}, {neu,pim,pi0,pi0,pi0,pi0,pi0,k0b},
     {neu,pip,pim,pim,pi0,pi0,pi0,k0b}, {neu,pip,pip,pim,pim,pim,pi0,k0b},
     {neu,pi0,pi0,pi0,pi0,pi0,pi0,kmi}, {pip,pim,pim,pi0,pi0,pi0,pi0,lam},
     {pip,pip,pim,pim,pim,pi0,pi0,lam}, {pip,pip,pip,pim,pim,pim,pim,lam},
     {pim,pi0,pi0,pi0,pi0,pi0,pi0,lam}, {pim,pim,pi0,pi0,pi0,pi0,pi0,sp},
     {pip,pip,pim,pim,pim,pim,pi0,sp},  {pip,pim,pim,pim,pi0,pi0,pi0,sp},
     {pip,pim,pim,pi0,pi0,pi0,pi0,s0},  {pip,pip,pim,pim,pim,pi0,pi0,s0},
     {pip,pip,pip,pim,pim,pim,pim,s0},  {pim,pi0,pi0,pi0,pi0,pi0,pi0,s0},
     {pip,pim,pi0,pi0,pi0,pi0,pi0,sm},  {pip,pip,pim,pim,pi0,pi0,pi0,sm},
     {pip,pip,pip,pim,pim,pim,pi0,sm},  {pip,pim,pim,pim,pi0,pi0,kpl,xi0},
     {pip,pim,pim,pi0,pi0,pi0,k0,xi0},  {pip,pip,pim,pim,pim,pi0,k0,xi0},
     {pip,pip,pim,pim,pim,pi0,kpl,xim}, {pip,pim,pim,pi0,pi0,pi0,kpl,xim},
     {pip,pip,pim,pim,pi0,pi0,k0,xim},  {pip,pip,pip,pim,pim,pim,k0,xim},
     {pim,pim,pi0,pi0,pi0,pi0,kpl,xi0}, {pip,pip,pim,pim,pim,pim,kpl,xi0},
     {pip,pim,pi0,pi0,pi0,pi0,k0,xim},  {pim,pi0,pi0,pi0,pi0,pi0,k0,xi0},
     {pim,pi0,pi0,pi0,pi0,pi0,kpl,xim}};

  static const G4int kmn9bfs[42][9] =
    {{pro,pip,pip,pim,pim,pim,pi0,pi0,kmi}, {pro,pip,pim,pim,pim,pi0,pi0,pi0,k0b},
     {pro,pip,pip,pim,pim,pim,pim,pi0,k0b}, {pro,pip,pim,pim,pi0,pi0,pi0,pi0,kmi},
     {pro,pip,pip,pip,pim,pim,pim,pim,kmi}, {pro,pim,pi0,pi0,pi0,pi0,pi0,pi0,kmi},
     {pro,pim,pim,pi0,pi0,pi0,pi0,pi0,k0b}, {neu,pip,pip,pim,pim,pim,pi0,pi0,k0b},
     {neu,pip,pip,pim,pim,pi0,pi0,pi0,kmi}, {neu,pip,pip,pip,pim,pim,pim,pi0,kmi},
     {neu,pip,pim,pim,pi0,pi0,pi0,pi0,k0b}, {neu,pip,pip,pip,pim,pim,pim,pim,k0b},
     {neu,pip,pim,pi0,pi0,pi0,pi0,pi0,kmi}, {neu,pim,pi0,pi0,pi0,pi0,pi0,pi0,k0b},
     {neu,pi0,pi0,pi0,pi0,pi0,pi0,pi0,kmi}, {pip,pim,pim,pi0,pi0,pi0,pi0,pi0,lam},
     {pip,pip,pip,pim,pim,pim,pim,pi0,lam}, {pip,pip,pim,pim,pim,pi0,pi0,pi0,lam},
     {pim,pi0,pi0,pi0,pi0,pi0,pi0,pi0,lam}, {pip,pip,pip,pim,pim,pim,pim,pim,sp},
     {pip,pip,pim,pim,pim,pim,pi0,pi0,sp},  {pip,pim,pim,pim,pi0,pi0,pi0,pi0,sp},
     {pim,pim,pi0,pi0,pi0,pi0,pi0,pi0,sp},  {pip,pim,pim,pi0,pi0,pi0,pi0,pi0,s0},
     {pip,pip,pip,pim,pim,pim,pim,pi0,s0},  {pip,pip,pim,pim,pim,pi0,pi0,pi0,s0},
     {pip,pim,pi0,pi0,pi0,pi0,pi0,pi0,sm},  {pip,pip,pip,pim,pim,pim,pi0,pi0,sm},
     {pip,pip,pim,pim,pi0,pi0,pi0,pi0,sm},  {pip,pip,pip,pip,pim,pim,pim,pim,sm},
     {pip,pip,pim,pim,pim,pi0,pi0,k0,xi0},  {pip,pip,pim,pim,pi0,pi0,pi0,k0,xim},
     {pip,pip,pim,pim,pim,pi0,pi0,kpl,xim}, {pip,pim,pim,pim,pi0,pi0,pi0,kpl,xi0},
     {pip,pip,pip,pim,pim,pim,pi0,k0,xim},  {pip,pip,pim,pim,pim,pim,pi0,kpl,xi0},
     {pip,pim,pim,pi0,pi0,pi0,pi0,k0,xi0},  {pip,pim,pim,pi0,pi0,pi0,pi0,kpl,xim},
     {pip,pip,pip,pim,pim,pim,pim,k0,xi0},  {pip,pip,pip,pim,pim,pim,pim,kpl,xim},
     {pim,pim,pi0,pi0,pi0,pi0,pi0,kpl,xi0}, {pip,pim,pi0,pi0,pi0,pi0,pi0,k0,xim}};

  // Cross sections for K- n -> 2-9 body final states
  // 
  // first index:    0-4: channels for mult = 2
  //                5-19: channels for mult = 3 
  //               20-53: channels for mult = 4
  //              54-111: channels for mult = 5
  //             112-181: channels for mult = 6
  //             182-270: channels for mult = 7
  //             271-309: channels for mult = 8
  //             310-351: channels for mult = 9
  //
  // second index: kinetic energy
  // 
  static const G4double kmnCrossSections[352][30] = {
    //
    // multiplicity 2 (5 channels)
    //  
    // K- n
    {  0.0, 0.49,  0.69, 0.97, 1.38, 1.94, 2.75, 3.89, 5.5,  8.0,
      11.0, 14.0, 18.0, 17.0, 13.0, 11.0,  9.2,  6.0,  5.0,  4.2,
       3.6,  3.2,  2.84, 2.48, 2.17, 1.90, 1.68, 1.44, 1.25, 1.09},

    // L pi-
    { 0.5,  0.61, 0.88,  1.31,  1.67,  1.97,  2.34,  2.8,   3.6, 4.4,
      5.2,  6.0,  5.4,   3.6,   2.4,   2.0,   2.0,   1.6,   1.0, 0.59,
      0.32, 0.15, 0.072, 0.032, 0.014, 0.006, 0.003, 0.001, 0.0, 0.0},  

    // S0 pi-
    { 0.16, 0.20, 0.25, 0.32,  0.42,  0.52,  0.67,  0.87, 1.24, 1.80,
      2.20, 1.90, 1.27, 0.97,  0.71,  0.60,  0.50,  0.50, 0.40, 0.26,
      0.14, 0.06, 0.03, 0.013, 0.006, 0.002, 0.001, 0.0,  0.0,  0.0},

    // S- pi0
    { 0.14,  0.18,  0.24,  0.33,  0.46,  0.57, 0.71,  0.90,  1.24,  1.70,
       2.1,  1.9,   1.40,  1.01,  0.76,  0.68, 0.55,  0.40,  0.35,  0.24,
       0.16, 0.092, 0.055, 0.031, 0.017, 0.01, 0.006, 0.003, 0.002, 0.001},

    // X- K0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,
      0.0,   0.0,   0.0,   0.0,   0.036, 0.132, 0.19, 0.22, 0.13, 0.10,
      0.047, 0.019, 0.007, 0.002, 0.001, 0.0,   0.0,  0.0,  0.0,  0.0}, 

    //
    //  multiplicity 3 (15 channels)
    //
    // p K- pi-
    { 0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.02,
      0.10, 0.46,  1.10, 1.00,  0.82,  1.00,  1.23, 1.80,  1.60,  1.23,
      1.06, 0.792, 0.58, 0.417, 0.295, 0.202, 0.14, 0.093, 0.065, 0.046},

    // n K- pi0
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.016,
      0.09, 0.44,  1.20,  1.40,  1.46,  1.65,  1.92, 2.1,   1.9,   1.76,
      1.44, 1.024, 0.714, 0.485, 0.317, 0.212, 0.14, 0.087, 0.058, 0.039},

    // n K0b pi-
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.012,
      0.08, 0.42,  1.30,  1.80,  2.10,  2.4,   2.6,  3.1,   3.1,   2.3,
      1.84, 1.246, 0.837, 0.552, 0.339, 0.212, 0.13, 0.081, 0.051, 0.032},

    // L pi- pi0
    { 0.10, 0.15,  0.23,  0.35,  0.46, 0.54, 0.66,  0.8,   1.05,  1.3,
      2.00, 3.50,  3.90,  4.0,   3.9,  3.8,  3.6,   2.8,   1.97,  1.17,
      0.79, 0.425, 0.234, 0.124, 0.06, 0.03, 0.015, 0.007, 0.003, 0.002}, 

    // S+ 2pi-
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.019, 0.034, 0.062, 0.14,  0.27,
      0.48, 0.8,   1.2,   1.3,   0.9,   0.95,  0.97,  0.74,  0.57,  0.38,
      0.29, 0.174, 0.112, 0.071, 0.042, 0.023, 0.014, 0.008, 0.005, 0.003},

    // S0 pi- pi0
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.006, 0.012, 0.023, 0.06,  0.13,
      0.25, 0.45,  0.72,  0.7,   0.58,   0.7,  0.77,  0.7,  0.56,  0.4,
      0.32, 0.222, 0.145, 0.099, 0.062, 0.039, 0.025, 0.015, 0.01, 0.006},

    // S- 2pi0
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.019, 0.034, 0.062, 0.14,  0.27,
      0.48, 0.8,   1.2,   1.3,   0.9,   0.95,  0.97,  0.74,  0.57,  0.38,
      0.29, 0.174, 0.112, 0.071, 0.042, 0.023, 0.014, 0.008, 0.005, 0.003},

    // S- pi+ pi-
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.006, 0.012, 0.023, 0.06,  0.13,
      0.25, 0.45,  0.72,  0.7,   0.58,   0.7,  0.77,  0.7,  0.56,  0.4,
      0.32, 0.222, 0.145, 0.099, 0.062, 0.039, 0.025, 0.015, 0.01, 0.006},

    // L K- K0 
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.005, 0.012,
      0.042, 0.068, 0.078, 0.072, 0.044, 0.02, 0.008, 0.004, 0.002, 0.001},

    // S0 K- K0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.006,
      0.021, 0.034, 0.039, 0.036, 0.022, 0.01, 0.004, 0.002, 0.001, 0.0},

    // S- K0 K0b
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.006,
      0.021, 0.034, 0.039, 0.036, 0.022, 0.01, 0.004, 0.002, 0.001, 0.0},

    // S- K+ K-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.006,
      0.021, 0.034, 0.039, 0.036, 0.022, 0.01, 0.004, 0.002, 0.001, 0.0},

    // X0 K0 pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.004, 0.014, 0.037,
      0.045, 0.026, 0.015, 0.008, 0.004, 0.002, 0.001, 0.0,   0.0,   0.0},

    // X- K0 pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.004, 0.014, 0.037,
      0.045, 0.026, 0.015, 0.008, 0.004, 0.002, 0.001, 0.0,   0.0,   0.0},

    // X- K+ pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.004, 0.014, 0.037,
      0.045, 0.026, 0.015, 0.008, 0.004, 0.002, 0.001, 0.0,   0.0,   0.0},

    //
    //  multiplicity 4 (34 channels)
    //
    // p K- pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0,   0.001, 0.005, 0.02,  0.05,  0.088, 0.15, 0.3,  0.56,
      0.7, 0.715, 0.658, 0.586, 0.508, 0.446, 0.38,  0.34, 0.30, 0.27},

    // p K0bar 2pi-
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,   0.0,   0.003, 0.012, 0.03,  0.05, 0.14, 0.23, 0.35,
      0.44, 0.444, 0.402, 0.361, 0.32,  0.276, 0.23, 0.21, 0.19, 0.17},

    // n K- 2pi0
    { 0.0,  0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,
      0.0,  0.0, 0.001, 0.006, 0.025, 0.06,  0.11, 0.2,  0.37, 0.7,
      0.88, 0.9, 0.815, 0.721, 0.64,  0.552, 0.47, 0.42, 0.38, 0.34},

    // n K- pi+ pi-
    { 0.0,  0.0,  0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.002, 0.013, 0.05, 0.12,  0.22, 0.41, 0.75, 1.40,
      1.77, 1.80, 1.64,  1.454, 1.27, 1.104, 0.94, 0.85, 0.76, 0.68},

    // n K0bar pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0,   0.001, 0.005, 0.02,  0.05,  0.088, 0.15, 0.3,  0.56,
      0.7, 0.715, 0.658, 0.586, 0.508, 0.446, 0.38,  0.34, 0.30, 0.27},

    // L pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.005, 0.017,
      0.046, 0.12,  0.21,  0.30,  0.29,  0.32,  0.40,  0.60,  0.60,  0.64,
      0.52,  0.336, 0.223, 0.143, 0.087, 0.052, 0.032, 0.019, 0.011, 0.007},

    // L pi+ 2pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.005, 0.017,
      0.046, 0.12,  0.21,  0.30,  0.29,  0.32,  0.40,  0.60,  0.60,  0.64,
      0.52,  0.336, 0.223, 0.143, 0.087, 0.052, 0.032, 0.019, 0.011, 0.007},

    // S+ 2pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.015, 0.05,  0.064, 0.083, 0.09,  0.10,  0.12,  0.17,  0.22,  0.20,
      0.18,  0.128, 0.094, 0.069, 0.047, 0.033, 0.022, 0.015, 0.011, 0.008},

    // S0 pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.002, 0.008,
      0.023, 0.06,  0.105, 0.15,  0.15,  0.16,  0.20,  0.30, 0.30,  0.32,
      0.25,  0.168, 0.112, 0.071, 0.044, 0.027, 0.016, 0.01, 0.005, 0.003},

    // S0 pi+ 2pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.002, 0.008,
      0.023, 0.06,  0.105, 0.15,  0.15,  0.16,  0.20,  0.30, 0.30,  0.32,
      0.25,  0.168, 0.112, 0.071, 0.044, 0.027, 0.016, 0.01, 0.005, 0.003},

    // S- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.003, 0.012, 0.035, 0.04,  0.028, 0.032, 0.037, 0.083, 0.102, 0.103,
      0.086, 0.056, 0.037, 0.024, 0.014, 0.008, 0.005, 0.003, 0.002, 0.001},

    // S- pi+ pi- pi0
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.02, 0.08,  0.21,  0.24,  0.17,  0.19,  0.22,  0.50,  0.55,  0.62,
      0.52, 0.336, 0.223, 0.143, 0.087, 0.052, 0.032, 0.019, 0.011, 0.007},

    // Xi0 K0 pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.002, 0.012,
      0.022, 0.034, 0.036, 0.022, 0.013, 0.008, 0.004, 0.003, 0.002, 0.001},

    // Xi0 K+ 2pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.006,
      0.011, 0.016, 0.018, 0.011, 0.007, 0.004, 0.002, 0.001, 0.001, 0.0},

    // Xi- K0 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.006,
      0.011, 0.016, 0.018, 0.011, 0.007, 0.004, 0.002, 0.001, 0.001, 0.0},

    // Xi- K0 pi+ pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.002, 0.012,
      0.022, 0.034, 0.036, 0.022, 0.013, 0.008, 0.004, 0.003, 0.002, 0.001},

    // Xi- K+ pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.008,
      0.015, 0.022, 0.023, 0.015, 0.009, 0.005, 0.003, 0.002, 0.001, 0.001},

    // p K- K- K0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.003, 0.007, 0.017, 0.028, 0.026, 0.027, 0.027, 0.027},

    // n K+ K- K-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.003, 0.007, 0.017, 0.028, 0.026, 0.027, 0.027, 0.027},

    // n K- K0 K0b
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.009, 0.013, 0.013, 0.013, 0.013, 0.013},

    // L K+ K- pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.003, 0.078, 0.077, 0.068, 0.061, 0.051, 0.046, 0.04, 0.037, 0.032},

    // L K0 K0bar pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.038, 0.038, 0.033, 0.029, 0.024, 0.022, 0.019, 0.018, 0.016},

    // L K- K0 pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.038, 0.038, 0.033, 0.029, 0.024, 0.022, 0.019, 0.018, 0.016},

    // S+ K0 K- pi-
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.004, 0.026, 0.036, 0.03, 0.022, 0.016, 0.013, 0.009, 0.007, 0.005},

    // S0 K+ K- pi-
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.001, 0.039, 0.038, 0.034, 0.03, 0.025, 0.023, 0.02, 0.018, 0.016},

    // S0 K0 K0bar pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.018, 0.019, 0.017, 0.014, 0.012, 0.011, 0.010, 0.009, 0.008},

    // S0 K- K0 pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.018, 0.019, 0.017, 0.014, 0.012, 0.011, 0.010, 0.009, 0.008},

    // S- K0 K- pi+
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.003, 0.016, 0.023, 0.02, 0.014, 0.012, 0.009, 0.006, 0.005, 0.003},

    // S- K0bar K+ pi-
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.003, 0.016, 0.023, 0.02, 0.014, 0.012, 0.009, 0.006, 0.005, 0.003},

    // S- K0 K0bar pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.008, 0.012, 0.01, 0.008, 0.005, 0.004, 0.003, 0.002, 0.001},

    // S- K+ K- pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.008, 0.012, 0.01, 0.008, 0.005, 0.004, 0.003, 0.002, 0.001},

    // Xi0 K- K0 K0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.001, 0.003, 0.002, 0.001, 0.0, 0.0, 0.0, 0.0},

    // Xi- K0 K0 K0b
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.001, 0.003, 0.002, 0.001, 0.0, 0.0, 0.0, 0.0},

    // Xi- K+ K- K0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0, 0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0, 0.0,
      0.0, 0.0, 0.002, 0.008, 0.004, 0.003, 0.001, 0.001, 0.0, 0.0},

    //
    //  multiplicity 5 (58 channels)
    // 
    // p K- pi- 2pi0 
    { 0.0,  0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0, 0.0,   0.0,   0.0,   0.001, 0.003, 0.009, 0.02,  0.05,
      0.13, 0.3, 0.357, 0.361, 0.388, 0.344, 0.332, 0.292, 0.266, 0.24},

    // p K- pi+ 2pi-
    { 0.0,  0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0, 0.0,   0.0,   0.0,   0.001, 0.003, 0.009, 0.02,  0.05,
      0.13, 0.3, 0.357, 0.361, 0.388, 0.344, 0.332, 0.292, 0.266, 0.24},

    // p K0b 2pi- pi0
    { 0.0,  0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0, 0.0,   0.0,   0.0,   0.001, 0.003, 0.009, 0.02,  0.05,
      0.13, 0.3, 0.357, 0.361, 0.388, 0.344, 0.332, 0.292, 0.266, 0.24},

    // n K- 3pi0
    { 0.0,   0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0, 0.0,   0.0,   0.0,   0.0,   0.001, 0.003, 0.006, 0.016,
      0.066, 0.1, 0.123, 0.124, 0.125, 0.119, 0.115, 0.097, 0.089, 0.08},

    // n K- pi+ pi- pi0
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.001, 0.002, 0.006, 0.018, 0.04,  0.1,
      0.26, 0.605, 0.714, 0.721, 0.776, 0.688, 0.663, 0.584, 0.533, 0.48},

    // n K0b pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0, 0.001, 0.002, 0.004, 0.014, 0.025, 0.05,
      0.205, 0.377, 0.463, 0.5, 0.538, 0.508, 0.483, 0.454, 0.426, 0.4},

    // n K0b pi+ 2pi-
    { 0.0,   0.0,   0.0,   0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0, 0.001, 0.002, 0.004, 0.014, 0.025, 0.05,
      0.205, 0.377, 0.463, 0.5, 0.538, 0.508, 0.483, 0.454, 0.426, 0.4},

    // p K- K0 K0b pi-
    { 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,   0.0,   0.0,
      0.0, 0.002, 0.011, 0.02, 0.023, 0.02, 0.02, 0.018, 0.016, 0.014},

    // p K+ K- K- pi-
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.006, 0.01, 0.011, 0.011, 0.01, 0.008, 0.007, 0.006},

    // p K- K- K0 pi0
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.006, 0.01, 0.011, 0.011, 0.01, 0.008, 0.007, 0.006},

    // n K+ K- K0b pi-
    { 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.011, 0.02, 0.023, 0.02, 0.02, 0.018, 0.016, 0.014},

    // n K- K0 K0b pi0
    { 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.011, 0.02, 0.023, 0.02, 0.02, 0.018, 0.016, 0.014},

    // n K+ K- K- pi0
    { 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.006, 0.01, 0.011, 0.011, 0.01, 0.008, 0.007, 0.006},

    // n K- K- K0 pi+
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.006, 0.01, 0.011, 0.011, 0.01, 0.008, 0.007, 0.006},

    // n K0 K0b K0b pi-
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.006, 0.01, 0.011, 0.011, 0.01, 0.008, 0.007, 0.006},

    // L pi- 3pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,  0.001, 0.002, 0.005, 0.009, 0.017, 0.04,  0.08, 0.12,
      0.14, 0.124, 0.10,  0.079, 0.063, 0.04,  0.035, 0.026, 0.02, 0.014},

    // L pi+ 2pi- pi0
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.001, 0.002, 0.006, 0.016, 0.028, 0.05,  0.12,  0.25,  0.36,
      0.44, 0.377, 0.308, 0.239, 0.183, 0.132, 0.104, 0.078, 0.057, 0.044},

    // L K- K0 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.004, 0.011, 0.013, 0.012, 0.012, 0.011, 0.011, 0.011},

    // L K- K0 pi+ pi-
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.01, 0.021, 0.024, 0.023, 0.023, 0.023, 0.023, 0.023},

    // L K0 K0b pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.002, 0.01, 0.021, 0.024, 0.023, 0.023, 0.023, 0.023, 0.023},

    // L K+ K- pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.01, 0.021, 0.024, 0.023, 0.023, 0.023, 0.023, 0.023},

    // L K+ K0b 2pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.001, 0.004, 0.011, 0.013, 0.012, 0.012, 0.011, 0.011, 0.011},

    // S+ 2pi- 2pi0
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.001, 0.002, 0.003, 0.008, 0.019, 0.047,
      0.07, 0.083, 0.078, 0.068, 0.05,  0.037, 0.03,  0.021, 0.016, 0.012},

    // S+ pi+ 3pi-
    { 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,   0.001, 0.002, 0.007, 0.017, 0.04,
      0.062, 0.07, 0.067, 0.057, 0.044, 0.032, 0.026, 0.019, 0.014, 0.01},

    // S+ K- K0 pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.002, 0.005, 0.011, 0.015, 0.013, 0.014, 0.014, 0.014, 0.014},

    // S+ K+ K- 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.004, 0.006, 0.008, 0.007, 0.007, 0.006, 0.006, 0.006},

    // S+ K0 K0b 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.004, 0.006, 0.008, 0.007, 0.007, 0.006, 0.006, 0.006},

    // S0 pi- 3pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,   0.001, 0.002, 0.007, 0.017, 0.04,
      0.062, 0.07, 0.067, 0.057, 0.044, 0.032, 0.026, 0.019, 0.014, 0.01},

    // S0 pi+ 2pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.001, 0.002, 0.004, 0.006, 0.016, 0.038, 0.094,
      0.141, 0.166, 0.156, 0.135, 0.10,  0.074, 0.061, 0.042, 0.032, 0.024},

    // S0 K- K0 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.006, 0.005, 0.006, 0.005, 0.005, 0.005},

    // S0 K- K0 pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.004, 0.011, 0.013, 0.012, 0.012, 0.011, 0.011, 0.011},

    // S0 K0 K0b pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.004, 0.011, 0.013, 0.012, 0.012, 0.011, 0.011, 0.011},

    // S0 K+ K- pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.004, 0.011, 0.013, 0.012, 0.012, 0.011, 0.011, 0.011},

    // S0 K+ K0b 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.006, 0.005, 0.006, 0.005, 0.005, 0.005},

    // S- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.002, 0.004, 0.01,
      0.015, 0.017, 0.017, 0.015, 0.025, 0.018, 0.016, 0.013, 0.007, 0.006},

    // S- pi+ pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.001, 0.002, 0.004, 0.006, 0.016, 0.038, 0.094,
      0.141, 0.166, 0.156, 0.135, 0.10,  0.074, 0.061, 0.042, 0.032, 0.024},

    // S- 2pi+ 2pi-
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.001, 0.002, 0.003, 0.008, 0.019, 0.047,
      0.07, 0.083, 0.078, 0.068, 0.05,  0.037, 0.03,  0.021, 0.016, 0.012},

    // S- K0 K0b 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.003, 0.006, 0.006, 0.005, 0.005, 0.005, 0.005, 0.005, 0.005},

    // S- K0 K0b pi+ pi-
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.002, 0.005, 0.009, 0.01, 0.013, 0.013, 0.013, 0.013, 0.012, 0.012},

    // S- K+ K- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.003, 0.006, 0.006, 0.005, 0.005, 0.005, 0.005, 0.005, 0.005},

    // S- K+ K- pi+ pi- 
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.002, 0.005, 0.009, 0.01, 0.013, 0.013, 0.013, 0.013, 0.012, 0.012},

    // S- K+ K0b pi- pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.002, 0.005, 0.009, 0.01, 0.013, 0.013, 0.013, 0.013, 0.012, 0.012},

    // S- K- K0 pi+ pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.002, 0.005, 0.009, 0.01, 0.013, 0.013, 0.013, 0.013, 0.012, 0.012},

    // Xi0 K0 pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,
      0.002, 0.007, 0.011, 0.018, 0.02, 0.02, 0.014, 0.014, 0.014, 0.012},

    // Xi0 K0 pi+ 2pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.002, 0.009, 0.016, 0.028, 0.031, 0.026, 0.022, 0.019, 0.018, 0.014},

    // Xi0 K+ 2pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.002, 0.009, 0.016, 0.028, 0.031, 0.026, 0.022, 0.019, 0.018, 0.014},

    // Xi- K0 3pi0 
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.003, 0.005, 0.009, 0.01, 0.009, 0.009, 0.008, 0.007, 0.006},

    // Xi- K0 pi+ pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.001,
      0.005, 0.018, 0.032, 0.056, 0.063, 0.053, 0.043, 0.04, 0.036, 0.03},

    // Xi- K+ pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,
      0.002, 0.007, 0.011, 0.018, 0.02, 0.02, 0.014, 0.014, 0.014, 0.012},

    // Xi- K+ pi+ 2pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.002, 0.009, 0.016, 0.028, 0.031, 0.026, 0.022, 0.019, 0.018, 0.014},

    // Xi0 K+ K- K0 pi- 
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.006, 0.008, 0.007, 0.005, 0.004, 0.002},

    // Xi- K+ K- K0 pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.006, 0.008, 0.007, 0.005, 0.004, 0.002},

    // Xi- K+ K0 K0b pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.006, 0.008, 0.007, 0.005, 0.004, 0.002},

    // Xi0 K0 K0 K0b pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.003, 0.002, 0.002, 0.001},

    // Xi- K0 K0 K0b pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.003, 0.002, 0.002, 0.001},

    // Xi- K+ K+ K- pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.003, 0.002, 0.002, 0.001},

    // Xi0 K- K0 K0 pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.003, 0.002, 0.002, 0.001},

    // Xi- K- K0 K0 pi+
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.003, 0.002, 0.002, 0.001},

    //
    //  multiplicity 6 (70 channels)
    // 
    // p K- pi+ 2pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.002,
      0.011, 0.123, 0.287, 0.425, 0.474, 0.55, 0.591, 0.546, 0.488, 0.446},

    // p K0b 2pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.001,
      0.005, 0.062, 0.143, 0.212, 0.238, 0.275, 0.29, 0.273, 0.236, 0.223},

    // p K- pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.003, 0.041, 0.096, 0.141, 0.158, 0.179, 0.198, 0.182, 0.158, 0.149},

    // p K0b pi+ 3pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.003, 0.041, 0.096, 0.141, 0.158, 0.179, 0.198, 0.182, 0.158, 0.149},

    // n K- pi+ pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.002,
      0.011, 0.123, 0.287, 0.425, 0.474, 0.55, 0.591, 0.546, 0.488, 0.446},

    // n K0b pi+ 2pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.002,
      0.011, 0.123, 0.287, 0.425, 0.474, 0.55, 0.591, 0.546, 0.488, 0.446},

    // n K- 2pi+ 2pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.001,
      0.005, 0.062, 0.143, 0.212, 0.238, 0.275, 0.29, 0.273, 0.236, 0.223},
 
    // n K0b pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.003, 0.041, 0.096, 0.141, 0.158, 0.179, 0.198, 0.182, 0.158, 0.149},

    // n K- 4pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.01, 0.025, 0.035, 0.04, 0.045, 0.049, 0.046, 0.041, 0.038},

    // p K- K0 K0b pi- pi0 
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.009, 0.023, 0.038, 0.045, 0.048, 0.042, 0.038, 0.034},

    // p K+ K- K0b 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.011, 0.018, 0.023, 0.024, 0.022, 0.019, 0.017},

    // p K+ K- K- pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.011, 0.018, 0.023, 0.024, 0.022, 0.019, 0.017},

    // p K- K- K0 pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.011, 0.018, 0.023, 0.024, 0.022, 0.019, 0.017},

    // p K0 K0b K0b 2pi- 
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.009, 0.011, 0.012, 0.01, 0.009, 0.009},

    // p K- K- K0 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.009, 0.011, 0.012, 0.01, 0.009, 0.009},

    // n K+ K- K0b pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.009, 0.023, 0.038, 0.045, 0.048, 0.042, 0.038, 0.034},

    // n K- K0 K0b pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.009, 0.023, 0.038, 0.045, 0.048, 0.042, 0.038, 0.034},

    // n K+ K- K- pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.011, 0.018, 0.023, 0.024, 0.022, 0.019, 0.017},

    // n K0 K0b K0b pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.011, 0.018, 0.023, 0.024, 0.022, 0.019, 0.017},

    // n K- K0 K0b 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.011, 0.018, 0.023, 0.024, 0.022, 0.019, 0.017},

    // n K- K- K0 pi+ pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.011, 0.018, 0.023, 0.024, 0.022, 0.019, 0.017},

    // n K+ K0b K0b 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.009, 0.011, 0.012, 0.01, 0.009, 0.009},

    // n K+ K- K- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.009, 0.011, 0.012, 0.01, 0.009, 0.009},

    // L pi+ 2pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.002, 0.003, 0.004, 0.011, 0.024, 0.075,
      0.187, 0.302, 0.364, 0.348, 0.247, 0.217, 0.211, 0.182, 0.15,  0.129},

    // L 2pi+ 3pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.002, 0.004, 0.008, 0.025,
      0.063, 0.101, 0.122, 0.116, 0.082, 0.072, 0.071, 0.061, 0.05,  0.043},

    // L pi- 4pi0
    { 0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.001, 0.002, 0.004, 0.012,
      0.031, 0.05, 0.06, 0.059, 0.041, 0.036, 0.035, 0.03,  0.025, 0.021},

    // L K- K0 pi+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.003, 0.009, 0.015, 0.034, 0.028, 0.029, 0.024, 0.019, 0.017},

    // L K+ K0b 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.007, 0.016, 0.014, 0.015, 0.012, 0.009, 0.009},

    // L K+ K- pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.007, 0.016, 0.014, 0.015, 0.012, 0.009, 0.009},

    // L K+ K- pi+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.007, 0.016, 0.014, 0.015, 0.012, 0.009, 0.009},

    // L K0 K0b pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.007, 0.016, 0.014, 0.015, 0.012, 0.009, 0.009},

    // L K0 K0b pi+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.007, 0.016, 0.014, 0.015, 0.012, 0.009, 0.009},

    // L K- K0 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.005, 0.004, 0.004, 0.004, 0.003, 0.003},

    // S+ 2pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.002, 0.004, 0.006,
      0.015, 0.028, 0.056, 0.056, 0.041, 0.036, 0.036, 0.03,  0.025, 0.021},

    // S+ pi+ 3pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.002, 0.004, 0.008, 0.012,
      0.031, 0.056, 0.112, 0.113, 0.082, 0.072, 0.072, 0.061, 0.05,  0.041},

    // S+ K+ K- 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.008, 0.007, 0.006, 0.005, 0.003},

    // S+ K0 K0b 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.008, 0.007, 0.006, 0.005, 0.003},

    // S+ K- K0 pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.008, 0.007, 0.006, 0.005, 0.003},

    // S+ K- K0 pi+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.008, 0.007, 0.006, 0.005, 0.003},

    // S+ K+ K0b 3pi- 
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.002, 0.002, 0.001},

    // S0 pi+ 2pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.001, 0.002, 0.003, 0.005, 0.012, 0.037,
      0.094, 0.151, 0.182, 0.174, 0.123, 0.108, 0.106, 0.091, 0.072, 0.06},

    // S0 2pi+ 3pi-
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.001, 0.002, 0.004, 0.012,
      0.031, 0.05, 0.06,  0.057, 0.041, 0.036, 0.035, 0.03,  0.025, 0.021},

    // S0 pi- 4pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.001, 0.003, 0.006,
      0.015, 0.025, 0.03, 0.029, 0.02, 0.018, 0.017, 0.014, 0.013, 0.01},

    // S0 K- K0 pi+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.007, 0.016, 0.014, 0.015, 0.012, 0.009, 0.009},

    // S0 K+ K0b 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.008, 0.007, 0.007, 0.006, 0.005, 0.003},

    // S0 K+ K- pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.008, 0.007, 0.007, 0.006, 0.005, 0.003},

    // S0 K+ K- pi+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.008, 0.007, 0.007, 0.006, 0.005, 0.003},

    // S0 K0 K0b pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.008, 0.007, 0.007, 0.006, 0.005, 0.003},

    // S0 K0 K0b pi+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.008, 0.007, 0.007, 0.006, 0.005, 0.003},

    // S0 K- K0 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.001, 0.001, 0.002, 0.002},

    // S- 2pi+ 2pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,    0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.002, 0.004,  0.009, 0.018,
      0.041, 0.073, 0.144, 0.136, 0.098, 0.085, 0.084, 0.072,  0.06,  0.048},

    // S- pi+ pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.003, 0.006, 0.012,
      0.026, 0.049, 0.096, 0.09, 0.066, 0.056, 0.056,  0.048, 0.039, 0.033},

    // S- 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001,
      0.002, 0.003, 0.004, 0.004, 0.003, 0.002, 0.002, 0.002, 0.002, 0.002},

    // S- K+ K- pi+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.009, 0.015, 0.015, 0.013, 0.012, 0.009, 0.007},

    // S- K0 K0b pi+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.009, 0.015, 0.015, 0.013, 0.012, 0.009, 0.007},

    // S- K+ K0b pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.008, 0.007, 0.006, 0.005, 0.003},

    // S- K+ K0b pi+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.008, 0.007, 0.006, 0.005, 0.003},

    // S- K- K0 pi+ 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.008, 0.007, 0.006, 0.005, 0.003},

    // S- K- K0 2pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.008, 0.007, 0.006, 0.005, 0.003},

    // S- K+ K- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.002, 0.002, 0.001},

    // S- K0 K0b 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.002, 0.002, 0.001},

    // Xi- K+ pi+ 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.006, 0.015, 0.015, 0.017, 0.019, 0.019, 0.016, 0.014},

    // Xi0 K0 pi+ 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.006, 0.015, 0.015, 0.017, 0.019, 0.019, 0.016, 0.014},

    // Xi- K0 pi+ pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.006, 0.015, 0.015, 0.017, 0.019, 0.019, 0.016, 0.014},

    // Xi- K0 2pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.008, 0.008, 0.009, 0.009, 0.009, 0.008, 0.007},

    // Xi0 K+ 2pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.008, 0.008, 0.009, 0.009, 0.009, 0.008, 0.007},

    // Xi0 K0 pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.005, 0.006, 0.004, 0.004, 0.005, 0.005},

    // Xi0 K+ pi+ 3pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.005, 0.006, 0.004, 0.004, 0.005, 0.005},

    // Xi- K+ pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.005, 0.006, 0.004, 0.004, 0.005, 0.005},

    // Xi- K0 4pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001},

    //
    //  multiplicity 7 (89 channels)
    // 
    // p K0b pi+ 3pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001,
      0.003, 0.015, 0.046, 0.116, 0.219, 0.313, 0.327, 0.307, 0.272, 0.241},

    // p K- pi+ 2pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.002,
      0.005, 0.022, 0.069, 0.175, 0.327, 0.469, 0.489, 0.46, 0.408, 0.361},

    // p K- pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.003, 0.011, 0.028, 0.055, 0.079, 0.081, 0.077, 0.068, 0.06},

    // p K0b 2pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.005, 0.016, 0.039, 0.075, 0.108, 0.112, 0.106, 0.094, 0.083},

    // p K- 2pi+ 3pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.005, 0.016, 0.039, 0.075, 0.108, 0.112, 0.106, 0.094, 0.083},

    // n K- 5pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.007, 0.011, 0.015, 0.017, 0.015, 0.014, 0.012},

    // n K- pi+ pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001,
      0.003, 0.015, 0.046, 0.116, 0.219, 0.313, 0.327, 0.307, 0.272, 0.241},

    // n K0b pi+ 2pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.002,
      0.005, 0.022, 0.069, 0.175, 0.327, 0.469, 0.489, 0.46, 0.408, 0.361},

    // n K- 2pi+ 2pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.002,
      0.005, 0.022, 0.069, 0.175, 0.327, 0.469, 0.489, 0.46, 0.408, 0.361},

    // n K0b pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.003, 0.011, 0.028, 0.055, 0.079, 0.081, 0.077, 0.068, 0.06},

    // n K0b 2pi+ 3pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.005, 0.016, 0.039, 0.075, 0.108, 0.112, 0.106, 0.094, 0.083},

    // p K+ K- K- pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.005, 0.008, 0.009, 0.008, 0.007, 0.006},

    // p K+ K- K- pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.005, 0.008, 0.009, 0.008, 0.007, 0.006},

    // p K0 K0b K0b 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.005, 0.008, 0.009, 0.008, 0.007, 0.006},

    // p K+ K- K0b 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.011, 0.015, 0.017, 0.015, 0.014, 0.012},

    // p K- K0 K0b pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.011, 0.015, 0.017, 0.015, 0.014, 0.012},

    // p K- K0 K0b pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.011, 0.015, 0.017, 0.015, 0.014, 0.012},

    // p K- K- K0 pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.011, 0.015, 0.017, 0.015, 0.014, 0.012},

    // p K+ K0b K0b 3pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.002, 0.002},

    // p K- K- K0 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.002, 0.002},

    // n K+ K0b K0b 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.006, 0.011, 0.011, 0.01, 0.008, 0.007},

    // n K0 K0b K0b pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.006, 0.011, 0.011, 0.01, 0.008, 0.007},

    // n K0 K0b K0b pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.006, 0.011, 0.011, 0.01, 0.008, 0.007},

    // n K- K- K0 pi+ 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.006, 0.011, 0.011, 0.01, 0.008, 0.007},

    // n K- K- K0 2pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.006, 0.011, 0.011, 0.01, 0.008, 0.007},

    // n K+ K- K0b pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.003, 0.007, 0.014, 0.019, 0.021, 0.019, 0.017, 0.015},

    // n K+ K- K0b pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.003, 0.007, 0.014, 0.019, 0.021, 0.019, 0.017, 0.015},

    // n K+ K- K- pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.003, 0.007, 0.014, 0.019, 0.021, 0.019, 0.017, 0.015},

    // n K+ K- K- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.003, 0.002},

    // n K- K0 K0b 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.006, 0.006, 0.005},

    // n K- K0 K0b pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.007, 0.015, 0.027, 0.038, 0.041, 0.038, 0.034, 0.03},

    // L pi- 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.003,
      0.007, 0.011, 0.013, 0.012, 0.01,  0.007, 0.006, 0.005, 0.004, 0.003},

    // L pi+ 2pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.006, 0.012, 0.027,
      0.069, 0.114, 0.137, 0.123, 0.098, 0.076, 0.059, 0.045, 0.036, 0.027},

    // L 2pi+ 3pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.006, 0.012, 0.027,
      0.069, 0.114, 0.137, 0.123, 0.098, 0.076, 0.059, 0.045, 0.036, 0.027},

    // L K+ K- pi+ 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.01, 0.019, 0.024, 0.027, 0.027, 0.026, 0.024},

    // L K0 K0b pi+ 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.01, 0.019, 0.024, 0.027, 0.027, 0.026, 0.024},

    // L K- K0 pi+ pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.01, 0.019, 0.024, 0.027, 0.027, 0.026, 0.024},

    // L K+ K0b pi+ 3pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.001, 0.003, 0.007, 0.008, 0.009, 0.009, 0.009, 0.008},

    // L K+ K- pi- 3pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.001, 0.003, 0.007, 0.008, 0.009, 0.009, 0.009, 0.008},

    // L K0 K0b pi- 3pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.001, 0.003, 0.007, 0.008, 0.009, 0.009, 0.009, 0.008},

    // L K+ K0b 2pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.006, 0.01, 0.013, 0.014, 0.014, 0.013, 0.012},

    // L K- K0 2pi+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.006, 0.01, 0.013, 0.014, 0.014, 0.013, 0.012},

    // L K0 K- 4pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002, 0.002},

    // S+ 2pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.001, 0.002, 0.003,
      0.008, 0.015, 0.017, 0.016, 0.012, 0.01, 0.007, 0.005, 0.004, 0.003},

    // S+ 2pi+ 4pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.001, 0.002, 0.003,
      0.008, 0.015, 0.017, 0.016, 0.012, 0.01, 0.007, 0.005, 0.004, 0.003},

    // S+ pi+ 3pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.003, 0.006, 0.012,
      0.033, 0.057, 0.067, 0.062, 0.047, 0.037, 0.03, 0.021, 0.018, 0.012},

    // S+ K- K0 pi+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.01, 0.013, 0.014, 0.014, 0.013, 0.012},

    // S+ K+ K0b 3pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S+ K+ K- pi+ 3pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S+ K0 K0b pi+ 3pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S+ K- K0 pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S+ K+ K- 2pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S+ K0 K0b 2pi- 2pi0 
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S0 pi- 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.002,
      0.003, 0.006, 0.007, 0.006, 0.004, 0.004, 0.003, 0.002, 0.002, 0.001},

    // S0 pi+ 2pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.003, 0.006, 0.013,
      0.034, 0.057, 0.068, 0.061, 0.049, 0.038, 0.03, 0.022, 0.018, 0.013},

    // S0 2pi+ 3pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.003, 0.006, 0.013,
      0.034, 0.057, 0.068, 0.061, 0.049, 0.038, 0.03, 0.022, 0.018, 0.013},

    // S0 K+ K- pi+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.01, 0.013, 0.014, 0.014, 0.013, 0.012},

    // S0 K0 K0b pi+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.01, 0.013, 0.014, 0.014, 0.013, 0.012},

    // S0 K- K0 pi+ pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.01, 0.013, 0.014, 0.014, 0.013, 0.012},

    // S0 K+ K0b pi+ 3pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S0 K+ K- pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S0 K0 K0b pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S0 K+ K0b 2pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S0 K- K0 2pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S0 K- K0 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001},

    // S- 6pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0, 0.0, 0.0, 0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0, 0.0, 0.0, 0.0,
      0.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.0, 0.0, 0.0, 0.0},

    // S- pi+ pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.003, 0.006,
      0.016, 0.029, 0.033, 0.032, 0.024, 0.018, 0.015, 0.01,  0.009, 0.006},

    // S- 2pi+ 2pi- 2i0
    { 0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.004, 0.009, 0.018,
      0.05, 0.086, 0.10, 0.094, 0.071, 0.055, 0.045, 0.031, 0.027, 0.018},

    // S- 3pi+ 3pi-
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,  0.001, 0.002, 0.004,
      0.011, 0.019, 0.022, 0.02, 0.015, 0.013, 0.01, 0.007, 0.006, 0.004},

    // S- K+ K0b pi+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.01, 0.013, 0.014, 0.014, 0.013, 0.012},

    // S- K+ K- pi+ pi- 2pi0 
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.01, 0.013, 0.014, 0.014, 0.013, 0.012},

    // S- K0 K0b pi+ pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.01, 0.013, 0.014, 0.014, 0.013, 0.012},

    // S- K- K0 2pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.01, 0.013, 0.014, 0.014, 0.013, 0.012},

    // S- K+ K- 2pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S- K0 K0b 2pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S- K+ K0b pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S- K- K0 pi+ 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S- K+ K- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001},

    // S- K0 K0b 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001},

    // Xi- K+ pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002},

    // Xi0 K0 pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002},

    // Xi- K+ pi+ 2pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.005, 0.008, 0.01, 0.011, 0.011, 0.01},

    // Xi- K0 2pi+ 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.005, 0.008, 0.01, 0.011, 0.011, 0.01},

    // Xi0 K0 pi+ 2pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.005, 0.008, 0.01, 0.011, 0.011, 0.01},

    // Xi- K0 pi+ pi- 3pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.001, 0.002, 0.002, 0.005, 0.006, 0.007, 0.007, 0.006},

    // Xi0 K+ pi+ 3pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.001, 0.002, 0.002, 0.005, 0.006, 0.007, 0.007, 0.006},

    // Xi- K+ 2pi+ 3pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.003, 0.004, 0.004, 0.003},

    // Xi0 K+ 2pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.003, 0.004, 0.004, 0.003},

    // Xi0 K0 2pi+ 3pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.003, 0.004, 0.004, 0.003},

    //
    //  multiplicity 8 (39 channels)
    //
    // p K- pi- 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.003, 0.006, 0.008, 0.01, 0.013, 0.016, 0.022, 0.026, 0.031},

    // p K0b pi+ 3pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.003,
      0.014, 0.038, 0.064, 0.08, 0.102, 0.13, 0.157, 0.218, 0.263, 0.306},

    // p K- 2pi+ 3pi- pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.003,
      0.014, 0.038, 0.064, 0.08, 0.102, 0.13, 0.157, 0.218, 0.263, 0.306},

    // p K- pi+ 2pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.003,
      0.014, 0.038, 0.064, 0.08, 0.102, 0.13, 0.157, 0.218, 0.263, 0.306},

    // p K0b 2pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.001,
      0.007, 0.019, 0.031, 0.039, 0.05, 0.065, 0.078, 0.109, 0.131, 0.153},

    // p K0b 2pi+ 4pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.001,
      0.007, 0.019, 0.031, 0.039, 0.05, 0.065, 0.078, 0.109, 0.131, 0.153},

    // n K- pi+ pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.002,
      0.007, 0.019, 0.031, 0.041, 0.05, 0.066, 0.079, 0.109, 0.132, 0.153},

    // n K- 2pi+ 2pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.004,
      0.022, 0.056, 0.096, 0.121, 0.153, 0.195, 0.236, 0.327, 0.394, 0.459},

    // n K- 3pi+ 3pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.007, 0.012, 0.021, 0.027, 0.034, 0.044, 0.052, 0.073, 0.087, 0.102},

    // n K0b pi- 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.003, 0.006, 0.008, 0.01, 0.013, 0.016, 0.022, 0.026, 0.031},

     // n K0b pi+ 2pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.003,
      0.014, 0.038, 0.064, 0.08, 0.102, 0.13, 0.157, 0.218, 0.263, 0.306},

    // n K0b 2pi+ 3pi- pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.003,
      0.014, 0.038, 0.064, 0.08, 0.102, 0.13, 0.157, 0.218, 0.263, 0.306},

    // n K- 6pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.003, 0.004, 0.004},

    // L pi+ 2pi- 4pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.003, 0.007,
      0.011, 0.013, 0.03, 0.038, 0.045, 0.052, 0.059, 0.066, 0.071, 0.075},

    // L 2pi+ 3pi- 2pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.007, 0.015,
      0.021, 0.027, 0.06, 0.077, 0.091, 0.104, 0.118, 0.131, 0.143, 0.151},

    // L 3pi+ 4pi-
    { 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.001, 0.002,
      0.003, 0.004, 0.01, 0.012, 0.015, 0.017, 0.02, 0.022, 0.024, 0.025},

    // L pi- 6pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.001, 0.002, 0.002, 0.003, 0.003, 0.004, 0.004, 0.005, 0.005},

    // S+ 2pi- 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001,
      0.001, 0.001, 0.002, 0.002, 0.003, 0.004, 0.005, 0.005, 0.005, 0.006},

    // S+ 2pi+ 4pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.004,
      0.005, 0.008, 0.011, 0.013, 0.016, 0.019, 0.022, 0.023, 0.027, 0.029},

    // S+ pi+ 3pi- 3pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.005,
      0.008, 0.01, 0.014, 0.018, 0.022, 0.025, 0.029, 0.031, 0.036, 0.03},

    // S0 pi+ 2pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.003,
      0.005, 0.006, 0.011, 0.014, 0.016, 0.019, 0.022, 0.024, 0.026, 0.027},

    // S0 2pi+ 3pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.003, 0.007,
      0.011, 0.013, 0.022, 0.028, 0.033, 0.039, 0.044, 0.048, 0.053, 0.055},

    // S0 3pi+ 4pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001,
      0.002, 0.002, 0.003, 0.004, 0.005, 0.006, 0.007, 0.008, 0.009, 0.009},

    // S0 pi- 6pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.002, 0.002, 0.002},

    // S- pi+ pi- 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.001,
      0.002, 0.003, 0.004, 0.006, 0.007, 0.007, 0.009, 0.010, 0.011, 0.011},

    // S- 2pi+ 2pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.003, 0.007,
      0.011, 0.013, 0.022, 0.028, 0.033, 0.039, 0.044, 0.048, 0.053, 0.055},

    // S- 3pi+ 3pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.002, 0.004,
      0.007, 0.009, 0.014, 0.019, 0.022, 0.025, 0.03, 0.032, 0.036, 0.038},

    // Xi0 K+ pi+ 3pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.001, 0.001, 0.002, 0.003, 0.004, 0.006, 0.01, 0.012, 0.013},

    // Xi0 K0 pi+ 2pi- 3pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.001, 0.002, 0.003, 0.004, 0.006, 0.01, 0.012, 0.013},

    // Xi0 K0 2pi+ 3pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.001, 0.001, 0.002, 0.003, 0.004, 0.006, 0.01, 0.012, 0.013},

    // Xi- K+ 2pi+ 3pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.001, 0.001, 0.002, 0.003, 0.004, 0.006, 0.01, 0.012, 0.013},

    // Xi- K+ pi+ 2pi- 3pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.001, 0.001, 0.002, 0.003, 0.004, 0.006, 0.01, 0.012, 0.013},

    // Xi- K0 2pi+ 2pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.005, 0.007, 0.01, 0.015, 0.018, 0.02},

    // Xi- K0 3pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.003, 0.004, 0.004},

    // Xi0 K+ 2pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.003, 0.003},

    // Xi0 K+ 2pi+ 4pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.003, 0.003},

    // Xi- K0 pi+ pi- 4pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.004, 0.005, 0.006, 0.007},

    // Xi0 K0 pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001},

    // Xi- K+ pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001},

    //
    //  multiplicity 9 (42 channels)
    //
    // p K- 2pi+ 3pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.004, 0.011, 0.034, 0.077, 0.134, 0.214, 0.363, 0.536, 0.675},

    // p K0b pi+ 3pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.003, 0.008, 0.023, 0.051, 0.089, 0.143, 0.242, 0.358, 0.45},

    // p K0b 2pi+ 4pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.002, 0.006, 0.017, 0.038, 0.067, 0.107, 0.181, 0.268, 0.338},

    // p K- pi+ 2pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.002, 0.006, 0.017, 0.038, 0.067, 0.107, 0.181, 0.268, 0.338},

    // p K- 3pi+ 4pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.001, 0.002, 0.006, 0.013, 0.022, 0.036, 0.06, 0.09, 0.113},

    // p K- pi- 6pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.005, 0.007, 0.012, 0.018, 0.022},

    // p K0b 2pi- 5pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.008, 0.013, 0.021, 0.037, 0.054, 0.067},

    // n K0b 2pi+ 3pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.004, 0.011, 0.034, 0.077, 0.134, 0.214, 0.363, 0.536, 0.675},

    // n K- 2pi+ 2pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.004, 0.011, 0.034, 0.077, 0.134, 0.214, 0.363, 0.536, 0.675},

    // n K- 3pi+ 3pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.003, 0.008, 0.023, 0.051, 0.089, 0.143, 0.242, 0.358, 0.45},

    // n K0b pi+ 2pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.002, 0.006, 0.017, 0.038, 0.067, 0.107, 0.181, 0.268, 0.338},

    // n K0b 3pi+ 4pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.001, 0.002, 0.006, 0.013, 0.022, 0.036, 0.06, 0.09, 0.113},

    // n K- pi+ pi- 5pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.007, 0.015, 0.027, 0.042, 0.075, 0.109, 0.135},

    // n K0b pi- 6pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.005, 0.007, 0.012, 0.018, 0.022},

    // n K- 7pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.003},

    // L pi+ 2pi- 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,
      0.001, 0.002, 0.003, 0.007, 0.013, 0.016, 0.02, 0.03, 0.039, 0.044},

    // L 3pi+ 4pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.001, 0.002, 0.006, 0.008, 0.022, 0.027, 0.032, 0.05, 0.065, 0.074},

    // L 2pi+ 3pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.001,
      0.002, 0.004, 0.011, 0.023, 0.044, 0.053, 0.065, 0.101, 0.13, 0.148},

    // L pi- 7pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.002, 0.002},

    // S+ 3pi+ 5pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.007, 0.008},

    // S+ 2pi+ 4pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.001, 0.002, 0.003, 0.008, 0.016, 0.021, 0.024, 0.038, 0.05, 0.057},

    // S+ pi+ 3pi- 4pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.006, 0.011, 0.014, 0.016, 0.025, 0.033, 0.038},

    // S+ 2pi- 6pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.003, 0.004},

    // S0 pi+ 2pi- 5pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,
      0.0, 0.001, 0.002, 0.003, 0.007, 0.008, 0.01, 0.015, 0.02, 0.022},

    // S0 3pi+ 4pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.006, 0.011, 0.013, 0.016, 0.025, 0.032, 0.037},

    // S0 2pi+ 3pi- 3pi0 
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,    0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,    0.0,   0.0,  0.0,   0.0,
      0.001, 0.002, 0.005, 0.011, 0.022, 0.027, 0.033, 0.05, 0.065, 0.075},

    // S- pi+ pi- 6pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.006, 0.007},

    // S- 3pi+ 3pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.001, 0.002, 0.006, 0.011, 0.022, 0.027, 0.033, 0.05, 0.065, 0.075},

    // S- 2pi+ 2pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.001, 0.002, 0.004, 0.009, 0.016, 0.02, 0.025, 0.038, 0.049, 0.056},

    // S- 4pi+ 4pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.004, 0.006, 0.008, 0.009},

    // Xi0 K0 2pi+ 3pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.007, 0.007, 0.008, 0.01, 0.013, 0.015},

    // Xi- K0 2pi+ 2pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.007, 0.007, 0.008, 0.01, 0.013, 0.015},

    // Xi- K+ 2pi+ 3pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.007, 0.007, 0.008, 0.01, 0.013, 0.015},

    // Xi0 K+ pi+ 3pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.006, 0.007, 0.009, 0.011},

    // Xi- K0 3pi+ 3pi- pi0 
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.006, 0.007, 0.009, 0.011},

    // Xi0 K+ 2pi+ 4pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.004, 0.005, 0.006, 0.007},

    // Xi0 K0 pi+ 2pi- 4pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.004, 0.005, 0.006, 0.007},

    // Xi- K+ pi+ 2pi- 4pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.004, 0.005, 0.006, 0.007},

    // Xi0 K0 3pi+ 4pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.003, 0.003},

    // Xi- K+ 3pi+ 4pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.003, 0.003},

    // Xi0 K+ 2pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.003, 0.003},

    // Xi- K0 pi+ pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.003, 0.003}};

}

const G4CascadeKminusNChannelData::data_t
G4CascadeKminusNChannelData::data(kmn2bfs, kmn3bfs, kmn4bfs, kmn5bfs,
                                  kmn6bfs, kmn7bfs, kmn8bfs, kmn9bfs,
				  kmnCrossSections, kmi*neu, "KminusN");
