# glossaries-extra package
# Matthew Bertucci 2025/10/17 for v1.8

#include:glossaries

### 2 Package Options ###
# load-time only options
#keyvals:\usepackage/glossaries-extra#c
nowarn
nolangwarn
noredefwarn
translate=#true,false,babel
notranslate
languages=%<language(s)%>
locales=%<language(s)%>
nolong
nosuper
nolist
notree
nostyles
makeindex
xindy
xindy={%<options%>}
xindygloss
xindynoglsnumbers
acronym#true,false
acronyms
#endkeyvals

\glossariesextrasetup{options%keyvals}

#keyvals:\usepackage/glossaries-extra#c,\glossariesextrasetup
## options passed to glossaries.sty
debug=#false,true,showtargets,showaccsupp,showwrgloss,all
savewrites#true,false
hyperfirst#true,false
writeglslabels
writeglslabelnames
toc#true,false
numberline#true,false
section=%<section unit%>
ucmark#true,false
numberedsection=#false,nolabel,autolabel
savenumberlist#true,false
entrycounter#true,false
counterwithin=%<counter%>
subentrycounter#true,false
style=%<style-name%>
nonumberlist
seeautonumberlist
counter=%<counter%>
nopostdot#true,false
nogroupskip#true,false
seenoindex=#error,warn,ignore
esclocations#true,false
indexonlyfirst#true,false
sanitizesort#true,false
sort=#none,clear,def,use,standard
order=#word,letter
automake=#false,delayed,immediate,makegloss,lite
automakegloss
automakeglosslite
disablemakegloss
restoremakegloss
nohypertypes={%<list%>}
nomain
symbols
numbers
index
noglossaryindex
acronymlists={%<label-list%>}
shortcuts=#acronyms,acro,ac,abbreviations,abbr,acother,abother,other,all,true,none,false
mfirstuc=#expanded,unexpanded
kernelglossredefs={%<value%>}
## options unique to glossaries-extra
nomissingglstext#true,false
abbreviations
postdot
postpunc=#comma,dot,none
stylemods
stylemods=#default,all,inline,list,tree,mcols,long,longragged,longbooktabs,super,superragged,bookindex,longextra,topic,table
prefix
accsupp
undefaction=#warn,error
docdef=#false,true,restricted,atom
indexcrossrefs#true,false
autoseeindex#true,false
record=#off,only,nameref,hybrid
bibglsaux=%<basename%>
equations#true,false
floats#true,false
indexcounter
showtargets=#left,right,innerleft,innerright,annoteleft,annoteright
#endkeyvals

#ifOption:abbreviations
\printabbreviations
\printabbreviations[options%keyvals]
\printunsrtabbreviations#*
\printunsrtabbreviations[options%keyvals]#*
\abbreviationsname#*
#endif

#ifOption:symbols
\printsymbols
\printsymbols[options%keyvals]
\glsxtrnewsymbol{gls-label%specialDef}{symbol}#s#%gls-label
\glsxtrnewsymbol[options%keyvals]{gls-label%specialDef}{symbol}#s#%gls-label
\printunsrtsymbols#*
\printunsrtsymbols[options%keyvals]#*
\glsxtrpostdescsymbol#*
#endif

#ifOption:numbers
\printnumbers
\printnumbers[options%keyvals]
\glsxtrnewnumber{gls-label%specialDef}{number}#s#%gls-label
\glsxtrnewnumber[options%keyvals]{gls-label%specialDef}{number}#s#%gls-label
\printunsrtnumbers#*
\printunsrtnumbers[options%keyvals]#*
\glsxtrpostdescnumber#*
#endif

#ifOption:index
\newterm{gls-label%specialDef}#s#%gls-label
\newterm[options%keyvals]{gls-label%specialDef}#s#%gls-label
\printindex
\printindex[options%keyvals]
\printunsrtindex
\printunsrtindex[options%keyvals]
\glsxtrpostdescindex#*
#endif

#ifOption:acronym
\printacronyms
\printacronyms[options%keyvals]
\printunsrtacronyms
\printunsrtacronyms[options%keyvals]
#endif
#ifOption:acronym=true
\printacronyms
\printacronyms[options%keyvals]
\printunsrtacronyms
\printunsrtacronyms[options%keyvals]
#endif
#ifOption:acronyms
\printacronyms
\printacronyms[options%keyvals]
\printunsrtacronyms
\printunsrtacronyms[options%keyvals]
#endif

#ifOption:stylemods
#include:glossaries-extra-stylemods
#endif
#ifOption:stylemods=default
#include:glossaries-extra-stylemods
#endif
#ifOption:stylemods=all
#include:glossaries-extra-stylemods
#include:glossary-inline
#include:glossary-mcols
#include:glossary-longragged
#include:glossary-longbooktabs
#include:glossary-superragged
#include:glossary-bookindex
#include:glossary-longextra
#include:glossary-topic
#include:glossary-table
#endif
#ifOption:stylemods=inline
#include:glossaries-extra-stylemods
#include:glossary-inline
#endif
#ifOption:stylemods=list
#include:glossaries-extra-stylemods
# glossary-list already loaded by glossaries.cwl
#endif
#ifOption:stylemods=tree
#include:glossaries-extra-stylemods
# glossary-tree already loaded by glossaries.cwl
#endif
#ifOption:stylemods=mcols
#include:glossaries-extra-stylemods
#include:glossary-mcols
#endif
#ifOption:stylemods=long
#include:glossaries-extra-stylemods
# glossary-long already loaded by glossaries.cwl
#endif
#ifOption:stylemods=longragged
#include:glossaries-extra-stylemods
#include:glossary-longragged
#endif
#ifOption:stylemods=longbooktabs
#include:glossaries-extra-stylemods
#include:glossary-longbooktabs
#endif
#ifOption:stylemods=super
#include:glossaries-extra-stylemods
# glossary-super already loaded by glossaries.cwl
#endif
#ifOption:stylemods=superragged
#include:glossaries-extra-stylemods
#include:glossary-superragged
#endif
#ifOption:stylemods=bookindex
#include:glossaries-extra-stylemods
#include:glossary-bookindex
#endif
#ifOption:stylemods=longextra
#include:glossaries-extra-stylemods
#include:glossary-longextra
#endif
#ifOption:stylemods=topic
#include:glossaries-extra-stylemods
#include:glossary-topic
#endif
#ifOption:stylemods=table
#include:glossaries-extra-stylemods
#include:glossary-table
#endif

#ifOption:prefix
#include:glossaries-prefix
\pglsxtrshort{gls-label%special}
\pglsxtrshort[options%keyvals]{gls-label%special}
\pglsxtrshort{gls-label%special}[insert]#*
\pglsxtrshort[options%keyvals]{gls-label%special}[insert]#*
\Pglsxtrshort{gls-label%special}
\Pglsxtrshort[options%keyvals]{gls-label%special}
\Pglsxtrshort{gls-label%special}[insert]#*
\Pglsxtrshort[options%keyvals]{gls-label%special}[insert]#*
\PGLSxtrshort{gls-label%special}
\PGLSxtrshort[options%keyvals]{gls-label%special}
\PGLSxtrshort{gls-label%special}[insert]#*
\PGLSxtrshort[options%keyvals]{gls-label%special}[insert]#*
\pglsxtrshortpl{gls-label%special}
\pglsxtrshortpl[options%keyvals]{gls-label%special}
\pglsxtrshortpl{gls-label%special}[insert]#*
\pglsxtrshortpl[options%keyvals]{gls-label%special}[insert]#*
\Pglsxtrshortpl{gls-label%special}
\Pglsxtrshortpl[options%keyvals]{gls-label%special}
\Pglsxtrshortpl{gls-label%special}[insert]#*
\Pglsxtrshortpl[options%keyvals]{gls-label%special}[insert]#*
\PGLSxtrshortpl{gls-label%special}
\PGLSxtrshortpl[options%keyvals]{gls-label%special}
\PGLSxtrshortpl{gls-label%special}[insert]#*
\PGLSxtrshortpl[options%keyvals]{gls-label%special}[insert]#*
\pglsxtrlong{gls-label%special}
\pglsxtrlong[options%keyvals]{gls-label%special}
\pglsxtrlong{gls-label%special}[insert]#*
\pglsxtrlong[options%keyvals]{gls-label%special}[insert]#*
\Pglsxtrlong{gls-label%special}
\Pglsxtrlong[options%keyvals]{gls-label%special}
\Pglsxtrlong{gls-label%special}[insert]#*
\Pglsxtrlong[options%keyvals]{gls-label%special}[insert]#*
\PGLSxtrlong{gls-label%special}
\PGLSxtrlong[options%keyvals]{gls-label%special}
\PGLSxtrlong{gls-label%special}[insert]#*
\PGLSxtrlong[options%keyvals]{gls-label%special}[insert]#*
\pglsxtrlongpl{gls-label%special}
\pglsxtrlongpl[options%keyvals]{gls-label%special}
\pglsxtrlongpl{gls-label%special}[insert]#*
\pglsxtrlongpl[options%keyvals]{gls-label%special}[insert]#*
\Pglsxtrlongpl{gls-label%special}
\Pglsxtrlongpl[options%keyvals]{gls-label%special}
\Pglsxtrlongpl{gls-label%special}[insert]#*
\Pglsxtrlongpl[options%keyvals]{gls-label%special}[insert]#*
\PGLSxtrlongpl{gls-label%special}
\PGLSxtrlongpl[options%keyvals]{gls-label%special}
\PGLSxtrlongpl{gls-label%special}[insert]#*
\PGLSxtrlongpl[options%keyvals]{gls-label%special}[insert]#*
\pglsfmtshort{gls-label%special}#*
\Pglsfmtshort{gls-label%special}#*
\PGLSfmtshort{gls-label%special}#*
\pglsfmtshortpl{gls-label%special}#*
\Pglsfmtshortpl{gls-label%special}#*
\PGLSfmtshortpl{gls-label%special}#*
\pglsfmtlong{gls-label%special}#*
\Pglsfmtlong{gls-label%special}#*
\PGLSfmtlong{gls-label%special}#*
\pglsfmtlongpl{gls-label%special}#*
\Pglsfmtlongpl{gls-label%special}#*
\PGLSfmtlongpl{gls-label%special}#*
\Pglsxtrtitleshort{gls-label%special}#*
\Pglsxtrtitleshortpl{gls-label%special}#*
\Pglsxtrtitlelong{gls-label%special}#*
\Pglsxtrtitlelongpl{gls-label%special}#*
\mpgls{multi-label}
\mpgls[options%keyvals]{multi-label}
\mpgls{multi-label}[insert]#*
\mpgls[options%keyvals]{multi-label}[insert]#*
\mpglspl{multi-label}
\mpglspl[options%keyvals]{multi-label}
\mpglspl{multi-label}[insert]#*
\mpglspl[options%keyvals]{multi-label}[insert]#*
\mpglsmainpl{multi-label}
\mpglsmainpl[options%keyvals]{multi-label}
\mpglsmainpl{multi-label}[insert]#*
\mpglsmainpl[options%keyvals]{multi-label}[insert]#*
\Mpgls{multi-label}
\Mpgls[options%keyvals]{multi-label}
\Mpgls{multi-label}[insert]#*
\Mpgls[options%keyvals]{multi-label}[insert]#*
\Mpglspl{multi-label}
\Mpglspl[options%keyvals]{multi-label}
\Mpglspl{multi-label}[insert]#*
\Mpglspl[options%keyvals]{multi-label}[insert]#*
\Mpglsmainpl{multi-label}
\Mpglsmainpl[options%keyvals]{multi-label}
\Mpglsmainpl{multi-label}[insert]#*
\Mpglsmainpl[options%keyvals]{multi-label}[insert]#*
\MPGls{multi-label}
\MPGls[options%keyvals]{multi-label}
\MPGls{multi-label}[insert]#*
\MPGls[options%keyvals]{multi-label}[insert]#*
\MPGlspl{multi-label}
\MPGlspl[options%keyvals]{multi-label}
\MPGlspl{multi-label}[insert]#*
\MPGlspl[options%keyvals]{multi-label}[insert]#*
\MPGlsmainpl{multi-label}
\MPGlsmainpl[options%keyvals]{multi-label}
\MPGlsmainpl{multi-label}[insert]#*
\MPGlsmainpl[options%keyvals]{multi-label}[insert]#*
\MPGLS{multi-label}
\MPGLS[options%keyvals]{multi-label}
\MPGLS{multi-label}[insert]#*
\MPGLS[options%keyvals]{multi-label}[insert]#*
\MPGLSpl{multi-label}
\MPGLSpl[options%keyvals]{multi-label}
\MPGLSpl{multi-label}[insert]#*
\MPGLSpl[options%keyvals]{multi-label}[insert]#*
\MPGLSmainpl{multi-label}
\MPGLSmainpl[options%keyvals]{multi-label}
\MPGLSmainpl{multi-label}[insert]#*
\MPGLSmainpl[options%keyvals]{multi-label}[insert]#*
\pglsprefix{arg1}{arg2}#S
\Pglsprefix{arg1}{arg2}#S
\PGLSprefix{arg1}{arg2}#S
#endif

#ifOption:accsupp
#include:glossaries-accsupp
#endif

## options shortcuts=ac,acother,all,acronyms,acro,true provide these
\acs{gls-label%special}#*
\acs[options%keyvals]{gls-label%special}#*
\acs{gls-label%special}[insert]#*
\acs[options%keyvals]{gls-label%special}[insert]#*
\acs*{gls-label%special}#S
\acs*[options%keyvals]{gls-label%special}#S
\acs*{gls-label%special}[insert]#S
\acs*[options%keyvals]{gls-label%special}[insert]#S
\acs+{gls-label%special}#S
\acs+[options%keyvals]{gls-label%special}#S
\acs+{gls-label%special}[insert]#S
\acs+[options%keyvals]{gls-label%special}[insert]#S
\Acs{gls-label%special}#*
\Acs[options%keyvals]{gls-label%special}#*
\Acs{gls-label%special}[insert]#*
\Acs[options%keyvals]{gls-label%special}[insert]#*
\Acs*{gls-label%special}#S
\Acs*[options%keyvals]{gls-label%special}#S
\Acs*{gls-label%special}[insert]#S
\Acs*[options%keyvals]{gls-label%special}[insert]#S
\Acs+{gls-label%special}#S
\Acs+[options%keyvals]{gls-label%special}#S
\Acs+{gls-label%special}[insert]#S
\Acs+[options%keyvals]{gls-label%special}[insert]#S
\ACS{gls-label%special}#*
\ACS[options%keyvals]{gls-label%special}#*
\ACS{gls-label%special}[insert]#*
\ACS[options%keyvals]{gls-label%special}[insert]#*
\ACS*{gls-label%special}#S
\ACS*[options%keyvals]{gls-label%special}#S
\ACS*{gls-label%special}[insert]#S
\ACS*[options%keyvals]{gls-label%special}[insert]#S
\ACS+{gls-label%special}#S
\ACS+[options%keyvals]{gls-label%special}#S
\ACS+{gls-label%special}[insert]#S
\ACS+[options%keyvals]{gls-label%special}[insert]#S
\acsp{gls-label%special}#*
\acsp[options%keyvals]{gls-label%special}#*
\acsp{gls-label%special}[insert]#*
\acsp[options%keyvals]{gls-label%special}[insert]#*
\acsp*{gls-label%special}#S
\acsp*[options%keyvals]{gls-label%special}#S
\acsp*{gls-label%special}[insert]#S
\acsp*[options%keyvals]{gls-label%special}[insert]#S
\acsp+{gls-label%special}#S
\acsp+[options%keyvals]{gls-label%special}#S
\acsp+{gls-label%special}[insert]#S
\acsp+[options%keyvals]{gls-label%special}[insert]#S
\Acsp{gls-label%special}#*
\Acsp[options%keyvals]{gls-label%special}#*
\Acsp{gls-label%special}[insert]#*
\Acsp[options%keyvals]{gls-label%special}[insert]#*
\Acsp*{gls-label%special}#S
\Acsp*[options%keyvals]{gls-label%special}#S
\Acsp*{gls-label%special}[insert]#S
\Acsp*[options%keyvals]{gls-label%special}[insert]#S
\Acsp+{gls-label%special}#S
\Acsp+[options%keyvals]{gls-label%special}#S
\Acsp+{gls-label%special}[insert]#S
\Acsp+[options%keyvals]{gls-label%special}[insert]#S
\ACSP{gls-label%special}#*
\ACSP[options%keyvals]{gls-label%special}#*
\ACSP{gls-label%special}[insert]#*
\ACSP[options%keyvals]{gls-label%special}[insert]#*
\ACSP*{gls-label%special}#S
\ACSP*[options%keyvals]{gls-label%special}#S
\ACSP*{gls-label%special}[insert]#S
\ACSP*[options%keyvals]{gls-label%special}[insert]#S
\ACSP+{gls-label%special}#S
\ACSP+[options%keyvals]{gls-label%special}#S
\ACSP+{gls-label%special}[insert]#S
\ACSP+[options%keyvals]{gls-label%special}[insert]#S
\acl{gls-label%special}#*
\acl[options%keyvals]{gls-label%special}#*
\acl{gls-label%special}[insert]#*
\acl[options%keyvals]{gls-label%special}[insert]#*
\acl*{gls-label%special}#S
\acl*[options%keyvals]{gls-label%special}#S
\acl*{gls-label%special}[insert]#S
\acl*[options%keyvals]{gls-label%special}[insert]#S
\acl+{gls-label%special}#S
\acl+[options%keyvals]{gls-label%special}#S
\acl+{gls-label%special}[insert]#S
\acl+[options%keyvals]{gls-label%special}[insert]#S
\Acl{gls-label%special}#*
\Acl[options%keyvals]{gls-label%special}#*
\Acl{gls-label%special}[insert]#*
\Acl[options%keyvals]{gls-label%special}[insert]#*
\Acl*{gls-label%special}#S
\Acl*[options%keyvals]{gls-label%special}#S
\Acl*{gls-label%special}[insert]#S
\Acl*[options%keyvals]{gls-label%special}[insert]#S
\Acl+{gls-label%special}#S
\Acl+[options%keyvals]{gls-label%special}#S
\Acl+{gls-label%special}[insert]#S
\Acl+[options%keyvals]{gls-label%special}[insert]#S
\ACL{gls-label%special}#*
\ACL[options%keyvals]{gls-label%special}#*
\ACL{gls-label%special}[insert]#*
\ACL[options%keyvals]{gls-label%special}[insert]#*
\ACL*{gls-label%special}#S
\ACL*[options%keyvals]{gls-label%special}#S
\ACL*{gls-label%special}[insert]#S
\ACL*[options%keyvals]{gls-label%special}[insert]#S
\ACL+{gls-label%special}#S
\ACL+[options%keyvals]{gls-label%special}#S
\ACL+{gls-label%special}[insert]#S
\ACL+[options%keyvals]{gls-label%special}[insert]#S
\aclp{gls-label%special}#*
\aclp[options%keyvals]{gls-label%special}#*
\aclp{gls-label%special}[insert]#*
\aclp[options%keyvals]{gls-label%special}[insert]#*
\aclp*{gls-label%special}#S
\aclp*[options%keyvals]{gls-label%special}#S
\aclp*{gls-label%special}[insert]#S
\aclp*[options%keyvals]{gls-label%special}[insert]#S
\aclp+{gls-label%special}#S
\aclp+[options%keyvals]{gls-label%special}#S
\aclp+{gls-label%special}[insert]#S
\aclp+[options%keyvals]{gls-label%special}[insert]#S
\Aclp{gls-label%special}#*
\Aclp[options%keyvals]{gls-label%special}#*
\Aclp{gls-label%special}[insert]#*
\Aclp[options%keyvals]{gls-label%special}[insert]#*
\Aclp*{gls-label%special}#S
\Aclp*[options%keyvals]{gls-label%special}#S
\Aclp*{gls-label%special}[insert]#S
\Aclp*[options%keyvals]{gls-label%special}[insert]#S
\Aclp+{gls-label%special}#S
\Aclp+[options%keyvals]{gls-label%special}#S
\Aclp+{gls-label%special}[insert]#S
\Aclp+[options%keyvals]{gls-label%special}[insert]#S
\ACLP{gls-label%special}#*
\ACLP[options%keyvals]{gls-label%special}#*
\ACLP{gls-label%special}[insert]#*
\ACLP[options%keyvals]{gls-label%special}[insert]#*
\ACLP*{gls-label%special}#S
\ACLP*[options%keyvals]{gls-label%special}#S
\ACLP*{gls-label%special}[insert]#S
\ACLP*[options%keyvals]{gls-label%special}[insert]#S
\ACLP+{gls-label%special}#S
\ACLP+[options%keyvals]{gls-label%special}#S
\ACLP+{gls-label%special}[insert]#S
\ACLP+[options%keyvals]{gls-label%special}[insert]#S
\acf{gls-label%special}#*
\acf[options%keyvals]{gls-label%special}#*
\acf{gls-label%special}[insert]#*
\acf[options%keyvals]{gls-label%special}[insert]#*
\acf*{gls-label%special}#S
\acf*[options%keyvals]{gls-label%special}#S
\acf*{gls-label%special}[insert]#S
\acf*[options%keyvals]{gls-label%special}[insert]#S
\acf+{gls-label%special}#S
\acf+[options%keyvals]{gls-label%special}#S
\acf+{gls-label%special}[insert]#S
\acf+[options%keyvals]{gls-label%special}[insert]#S
\Acf{gls-label%special}#*
\Acf[options%keyvals]{gls-label%special}#*
\Acf{gls-label%special}[insert]#*
\Acf[options%keyvals]{gls-label%special}[insert]#*
\Acf*{gls-label%special}#S
\Acf*[options%keyvals]{gls-label%special}#S
\Acf*{gls-label%special}[insert]#S
\Acf*[options%keyvals]{gls-label%special}[insert]#S
\Acf+{gls-label%special}#S
\Acf+[options%keyvals]{gls-label%special}#S
\Acf+{gls-label%special}[insert]#S
\Acf+[options%keyvals]{gls-label%special}[insert]#S
\ACF{gls-label%special}#*
\ACF[options%keyvals]{gls-label%special}#*
\ACF{gls-label%special}[insert]#*
\ACF[options%keyvals]{gls-label%special}[insert]#*
\ACF*{gls-label%special}#S
\ACF*[options%keyvals]{gls-label%special}#S
\ACF*{gls-label%special}[insert]#S
\ACF*[options%keyvals]{gls-label%special}[insert]#S
\ACF+{gls-label%special}#S
\ACF+[options%keyvals]{gls-label%special}#S
\ACF+{gls-label%special}[insert]#S
\ACF+[options%keyvals]{gls-label%special}[insert]#S
\acfp{gls-label%special}#*
\acfp[options%keyvals]{gls-label%special}#*
\acfp{gls-label%special}[insert]#*
\acfp[options%keyvals]{gls-label%special}[insert]#*
\acfp*{gls-label%special}#S
\acfp*[options%keyvals]{gls-label%special}#S
\acfp*{gls-label%special}[insert]#S
\acfp*[options%keyvals]{gls-label%special}[insert]#S
\acfp+{gls-label%special}#S
\acfp+[options%keyvals]{gls-label%special}#S
\acfp+{gls-label%special}[insert]#S
\acfp+[options%keyvals]{gls-label%special}[insert]#S
\Acfp{gls-label%special}#*
\Acfp[options%keyvals]{gls-label%special}#*
\Acfp{gls-label%special}[insert]#*
\Acfp[options%keyvals]{gls-label%special}[insert]#*
\Acfp*{gls-label%special}#S
\Acfp*[options%keyvals]{gls-label%special}#S
\Acfp*{gls-label%special}[insert]#S
\Acfp*[options%keyvals]{gls-label%special}[insert]#S
\Acfp+{gls-label%special}#S
\Acfp+[options%keyvals]{gls-label%special}#S
\Acfp+{gls-label%special}[insert]#S
\Acfp+[options%keyvals]{gls-label%special}[insert]#S
\ACFP{gls-label%special}#*
\ACFP[options%keyvals]{gls-label%special}#*
\ACFP{gls-label%special}[insert]#*
\ACFP[options%keyvals]{gls-label%special}[insert]#*
\ACFP*{gls-label%special}#S
\ACFP*[options%keyvals]{gls-label%special}#S
\ACFP*{gls-label%special}[insert]#S
\ACFP*[options%keyvals]{gls-label%special}[insert]#S
\ACFP+{gls-label%special}#S
\ACFP+[options%keyvals]{gls-label%special}#S
\ACFP+{gls-label%special}[insert]#S
\ACFP+[options%keyvals]{gls-label%special}[insert]#S
\ac{gls-label%special}#*
\ac[options%keyvals]{gls-label%special}#*
\ac{gls-label%special}[insert]#*
\ac[options%keyvals]{gls-label%special}[insert]#*
\Ac{gls-label%special}#*
\Ac[options%keyvals]{gls-label%special}#*
\Ac{gls-label%special}[insert]#*
\Ac[options%keyvals]{gls-label%special}[insert]#*
\ac*{gls-label%special}#S
\ac*[options%keyvals]{gls-label%special}#S
\ac*{gls-label%special}[insert]#S
\ac*[options%keyvals]{gls-label%special}[insert]#S
\Ac*{gls-label%special}#S
\Ac*[options%keyvals]{gls-label%special}#S
\Ac*{gls-label%special}[insert]#S
\Ac*[options%keyvals]{gls-label%special}[insert]#S
\ac+{gls-label%special}#S
\ac+[options%keyvals]{gls-label%special}#S
\ac+{gls-label%special}[insert]#S
\ac+[options%keyvals]{gls-label%special}[insert]#S
\Ac+{gls-label%special}#S
\Ac+[options%keyvals]{gls-label%special}#S
\Ac+{gls-label%special}[insert]#S
\Ac+[options%keyvals]{gls-label%special}[insert]#S
\AC{gls-label%special}#*
\AC[options%keyvals]{gls-label%special}#*
\AC{gls-label%special}[insert]#*
\AC[options%keyvals]{gls-label%special}[insert]#*
\AC*{gls-label%special}#S
\AC*[options%keyvals]{gls-label%special}#S
\AC*{gls-label%special}[insert]#S
\AC*[options%keyvals]{gls-label%special}[insert]#S
\AC+{gls-label%special}#S
\AC+[options%keyvals]{gls-label%special}#S
\AC+{gls-label%special}[insert]#S
\AC+[options%keyvals]{gls-label%special}[insert]#S
\acp{gls-label%special}#*
\acp[options%keyvals]{gls-label%special}#*
\acp{gls-label%special}[insert]#*
\acp[options%keyvals]{gls-label%special}[insert]#*
\Acp{gls-label%special}#*
\Acp[options%keyvals]{gls-label%special}#*
\Acp{gls-label%special}[insert]#*
\Acp[options%keyvals]{gls-label%special}[insert]#*
\acp*{gls-label%special}#S
\acp*[options%keyvals]{gls-label%special}#S
\acp*{gls-label%special}[insert]#S
\acp*[options%keyvals]{gls-label%special}[insert]#S
\Acp*{gls-label%special}#S
\Acp*[options%keyvals]{gls-label%special}#S
\Acp*{gls-label%special}[insert]#S
\Acp*[options%keyvals]{gls-label%special}[insert]#S
\acp+{gls-label%special}#S
\acp+[options%keyvals]{gls-label%special}#S
\acp+{gls-label%special}[insert]#S
\acp+[options%keyvals]{gls-label%special}[insert]#S
\Acp+{gls-label%special}#S
\Acp+[options%keyvals]{gls-label%special}#S
\Acp+{gls-label%special}[insert]#S
\Acp+[options%keyvals]{gls-label%special}[insert]#S
\ACP{gls-label%special}#*
\ACP[options%keyvals]{gls-label%special}#*
\ACP{gls-label%special}[insert]#*
\ACP[options%keyvals]{gls-label%special}[insert]#*
\ACP*{gls-label%special}#S
\ACP*[options%keyvals]{gls-label%special}#S
\ACP*{gls-label%special}[insert]#S
\ACP*[options%keyvals]{gls-label%special}[insert]#S
\ACP+{gls-label%special}#S
\ACP+[options%keyvals]{gls-label%special}#S
\ACP+{gls-label%special}[insert]#S
\ACP+[options%keyvals]{gls-label%special}[insert]#S

## options shortcuts=abbreviations,abbr,abother,all,true provide these
\ab{gls-label%special}#*
\ab[options%keyvals]{gls-label%special}#*
\ab{gls-label%special}[insert]#*
\ab[options%keyvals]{gls-label%special}[insert]#*
\ab*{gls-label%special}#S
\ab*[options%keyvals]{gls-label%special}#S
\ab*{gls-label%special}[insert]#S
\ab*[options%keyvals]{gls-label%special}[insert]#S
\ab+{gls-label%special}#S
\ab+[options%keyvals]{gls-label%special}#S
\ab+{gls-label%special}[insert]#S
\ab+[options%keyvals]{gls-label%special}[insert]#S
\abp{gls-label%special}#*
\abp[options%keyvals]{gls-label%special}#*
\abp{gls-label%special}[insert]#*
\abp[options%keyvals]{gls-label%special}[insert]#*
\abp*{gls-label%special}#S
\abp*[options%keyvals]{gls-label%special}#S
\abp*{gls-label%special}[insert]#S
\abp*[options%keyvals]{gls-label%special}[insert]#S
\abp+{gls-label%special}#S
\abp+[options%keyvals]{gls-label%special}#S
\abp+{gls-label%special}[insert]#S
\abp+[options%keyvals]{gls-label%special}[insert]#S
\as{gls-label%special}#*
\as[options%keyvals]{gls-label%special}#*
\as{gls-label%special}[insert]#*
\as[options%keyvals]{gls-label%special}[insert]#*
\as*{gls-label%special}#S
\as*[options%keyvals]{gls-label%special}#S
\as*{gls-label%special}[insert]#S
\as*[options%keyvals]{gls-label%special}[insert]#S
\as+{gls-label%special}#S
\as+[options%keyvals]{gls-label%special}#S
\as+{gls-label%special}[insert]#S
\as+[options%keyvals]{gls-label%special}[insert]#S
\asp{gls-label%special}#*
\asp[options%keyvals]{gls-label%special}#*
\asp{gls-label%special}[insert]#*
\asp[options%keyvals]{gls-label%special}[insert]#*
\asp*{gls-label%special}#S
\asp*[options%keyvals]{gls-label%special}#S
\asp*{gls-label%special}[insert]#S
\asp*[options%keyvals]{gls-label%special}[insert]#S
\asp+{gls-label%special}#S
\asp+[options%keyvals]{gls-label%special}#S
\asp+{gls-label%special}[insert]#S
\asp+[options%keyvals]{gls-label%special}[insert]#S
\al{gls-label%special}#*
\al[options%keyvals]{gls-label%special}#*
\al{gls-label%special}[insert]#*
\al[options%keyvals]{gls-label%special}[insert]#*
\al*{gls-label%special}#S
\al*[options%keyvals]{gls-label%special}#S
\al*{gls-label%special}[insert]#S
\al*[options%keyvals]{gls-label%special}[insert]#S
\al+{gls-label%special}#S
\al+[options%keyvals]{gls-label%special}#S
\al+{gls-label%special}[insert]#S
\al+[options%keyvals]{gls-label%special}[insert]#S
\alp{gls-label%special}#*
\alp[options%keyvals]{gls-label%special}#*
\alp{gls-label%special}[insert]#*
\alp[options%keyvals]{gls-label%special}[insert]#*
\alp*{gls-label%special}#S
\alp*[options%keyvals]{gls-label%special}#S
\alp*{gls-label%special}[insert]#S
\alp*[options%keyvals]{gls-label%special}[insert]#S
\alp+{gls-label%special}#S
\alp+[options%keyvals]{gls-label%special}#S
\alp+{gls-label%special}[insert]#S
\alp+[options%keyvals]{gls-label%special}[insert]#S
\af{gls-label%special}#*
\af[options%keyvals]{gls-label%special}#*
\af{gls-label%special}[insert]#*
\af[options%keyvals]{gls-label%special}[insert]#*
\af*{gls-label%special}#S
\af*[options%keyvals]{gls-label%special}#S
\af*{gls-label%special}[insert]#S
\af*[options%keyvals]{gls-label%special}[insert]#S
\af+{gls-label%special}#S
\af+[options%keyvals]{gls-label%special}#S
\af+{gls-label%special}[insert]#S
\af+[options%keyvals]{gls-label%special}[insert]#S
\afp{gls-label%special}#*
\afp[options%keyvals]{gls-label%special}#*
\afp{gls-label%special}[insert]#*
\afp[options%keyvals]{gls-label%special}[insert]#*
\afp*{gls-label%special}#S
\afp*[options%keyvals]{gls-label%special}#S
\afp*{gls-label%special}[insert]#S
\afp*[options%keyvals]{gls-label%special}[insert]#S
\afp+{gls-label%special}#S
\afp+[options%keyvals]{gls-label%special}#S
\afp+{gls-label%special}[insert]#S
\afp+[options%keyvals]{gls-label%special}[insert]#S
\Ab{gls-label%special}#*
\Ab[options%keyvals]{gls-label%special}#*
\Ab{gls-label%special}[insert]#*
\Ab[options%keyvals]{gls-label%special}[insert]#*
\Ab*{gls-label%special}#S
\Ab*[options%keyvals]{gls-label%special}#S
\Ab*{gls-label%special}[insert]#S
\Ab*[options%keyvals]{gls-label%special}[insert]#S
\Ab+{gls-label%special}#S
\Ab+[options%keyvals]{gls-label%special}#S
\Ab+{gls-label%special}[insert]#S
\Ab+[options%keyvals]{gls-label%special}[insert]#S
\Abp{gls-label%special}#*
\Abp[options%keyvals]{gls-label%special}#*
\Abp{gls-label%special}[insert]#*
\Abp[options%keyvals]{gls-label%special}[insert]#*
\Abp*{gls-label%special}#S
\Abp*[options%keyvals]{gls-label%special}#S
\Abp*{gls-label%special}[insert]#S
\Abp*[options%keyvals]{gls-label%special}[insert]#S
\Abp+{gls-label%special}#S
\Abp+[options%keyvals]{gls-label%special}#S
\Abp+{gls-label%special}[insert]#S
\Abp+[options%keyvals]{gls-label%special}[insert]#S
\As{gls-label%special}#*
\As[options%keyvals]{gls-label%special}#*
\As{gls-label%special}[insert]#*
\As[options%keyvals]{gls-label%special}[insert]#*
\As*{gls-label%special}#S
\As*[options%keyvals]{gls-label%special}#S
\As*{gls-label%special}[insert]#S
\As*[options%keyvals]{gls-label%special}[insert]#S
\As+{gls-label%special}#S
\As+[options%keyvals]{gls-label%special}#S
\As+{gls-label%special}[insert]#S
\As+[options%keyvals]{gls-label%special}[insert]#S
\Asp{gls-label%special}#*
\Asp[options%keyvals]{gls-label%special}#*
\Asp{gls-label%special}[insert]#*
\Asp[options%keyvals]{gls-label%special}[insert]#*
\Asp*{gls-label%special}#S
\Asp*[options%keyvals]{gls-label%special}#S
\Asp*{gls-label%special}[insert]#S
\Asp*[options%keyvals]{gls-label%special}[insert]#S
\Asp+{gls-label%special}#S
\Asp+[options%keyvals]{gls-label%special}#S
\Asp+{gls-label%special}[insert]#S
\Asp+[options%keyvals]{gls-label%special}[insert]#S
\Al{gls-label%special}#*
\Al[options%keyvals]{gls-label%special}#*
\Al{gls-label%special}[insert]#*
\Al[options%keyvals]{gls-label%special}[insert]#*
\Al*{gls-label%special}#S
\Al*[options%keyvals]{gls-label%special}#S
\Al*{gls-label%special}[insert]#S
\Al*[options%keyvals]{gls-label%special}[insert]#S
\Al+{gls-label%special}#S
\Al+[options%keyvals]{gls-label%special}#S
\Al+{gls-label%special}[insert]#S
\Al+[options%keyvals]{gls-label%special}[insert]#S
\Alp{gls-label%special}#*
\Alp[options%keyvals]{gls-label%special}#*
\Alp{gls-label%special}[insert]#*
\Alp[options%keyvals]{gls-label%special}[insert]#*
\Alp*{gls-label%special}#S
\Alp*[options%keyvals]{gls-label%special}#S
\Alp*{gls-label%special}[insert]#S
\Alp*[options%keyvals]{gls-label%special}[insert]#S
\Alp+{gls-label%special}#S
\Alp+[options%keyvals]{gls-label%special}#S
\Alp+{gls-label%special}[insert]#S
\Alp+[options%keyvals]{gls-label%special}[insert]#S
\Af{gls-label%special}#*
\Af[options%keyvals]{gls-label%special}#*
\Af{gls-label%special}[insert]#*
\Af[options%keyvals]{gls-label%special}[insert]#*
\Af*{gls-label%special}#S
\Af*[options%keyvals]{gls-label%special}#S
\Af*{gls-label%special}[insert]#S
\Af*[options%keyvals]{gls-label%special}[insert]#S
\Af+{gls-label%special}#S
\Af+[options%keyvals]{gls-label%special}#S
\Af+{gls-label%special}[insert]#S
\Af+[options%keyvals]{gls-label%special}[insert]#S
\Afp{gls-label%special}#*
\Afp[options%keyvals]{gls-label%special}#*
\Afp{gls-label%special}[insert]#*
\Afp[options%keyvals]{gls-label%special}[insert]#*
\Afp*{gls-label%special}#S
\Afp*[options%keyvals]{gls-label%special}#S
\Afp*{gls-label%special}[insert]#S
\Afp*[options%keyvals]{gls-label%special}[insert]#S
\Afp+{gls-label%special}#S
\Afp+[options%keyvals]{gls-label%special}#S
\Afp+{gls-label%special}[insert]#S
\Afp+[options%keyvals]{gls-label%special}[insert]#S
\AB{gls-label%special}#*
\AB[options%keyvals]{gls-label%special}#*
\AB{gls-label%special}[insert]#*
\AB[options%keyvals]{gls-label%special}[insert]#*
\AB*{gls-label%special}#S
\AB*[options%keyvals]{gls-label%special}#S
\AB*{gls-label%special}[insert]#S
\AB*[options%keyvals]{gls-label%special}[insert]#S
\AB+{gls-label%special}#S
\AB+[options%keyvals]{gls-label%special}#S
\AB+{gls-label%special}[insert]#S
\AB+[options%keyvals]{gls-label%special}[insert]#S
\ABP{gls-label%special}#*
\ABP[options%keyvals]{gls-label%special}#*
\ABP{gls-label%special}[insert]#*
\ABP[options%keyvals]{gls-label%special}[insert]#*
\ABP*{gls-label%special}#S
\ABP*[options%keyvals]{gls-label%special}#S
\ABP*{gls-label%special}[insert]#S
\ABP*[options%keyvals]{gls-label%special}[insert]#S
\ABP+{gls-label%special}#S
\ABP+[options%keyvals]{gls-label%special}#S
\ABP+{gls-label%special}[insert]#S
\ABP+[options%keyvals]{gls-label%special}[insert]#S
\AS{gls-label%special}#*
\AS[options%keyvals]{gls-label%special}#*
\AS{gls-label%special}[insert]#*
\AS[options%keyvals]{gls-label%special}[insert]#*
\AS*{gls-label%special}#S
\AS*[options%keyvals]{gls-label%special}#S
\AS*{gls-label%special}[insert]#S
\AS*[options%keyvals]{gls-label%special}[insert]#S
\AS+{gls-label%special}#S
\AS+[options%keyvals]{gls-label%special}#S
\AS+{gls-label%special}[insert]#S
\AS+[options%keyvals]{gls-label%special}[insert]#S
\ASP{gls-label%special}#*
\ASP[options%keyvals]{gls-label%special}#*
\ASP{gls-label%special}[insert]#*
\ASP[options%keyvals]{gls-label%special}[insert]#*
\ASP*{gls-label%special}#S
\ASP*[options%keyvals]{gls-label%special}#S
\ASP*{gls-label%special}[insert]#S
\ASP*[options%keyvals]{gls-label%special}[insert]#S
\ASP+{gls-label%special}#S
\ASP+[options%keyvals]{gls-label%special}#S
\ASP+{gls-label%special}[insert]#S
\ASP+[options%keyvals]{gls-label%special}[insert]#S
\AL{gls-label%special}#*
\AL[options%keyvals]{gls-label%special}#*
\AL{gls-label%special}[insert]#*
\AL[options%keyvals]{gls-label%special}[insert]#*
\AL*{gls-label%special}#S
\AL*[options%keyvals]{gls-label%special}#S
\AL*{gls-label%special}[insert]#S
\AL*[options%keyvals]{gls-label%special}[insert]#S
\AL+{gls-label%special}#S
\AL+[options%keyvals]{gls-label%special}#S
\AL+{gls-label%special}[insert]#S
\AL+[options%keyvals]{gls-label%special}[insert]#S
\ALP{gls-label%special}#*
\ALP[options%keyvals]{gls-label%special}#*
\ALP{gls-label%special}[insert]#*
\ALP[options%keyvals]{gls-label%special}[insert]#*
\ALP*{gls-label%special}#S
\ALP*[options%keyvals]{gls-label%special}#S
\ALP*{gls-label%special}[insert]#S
\ALP*[options%keyvals]{gls-label%special}[insert]#S
\ALP+{gls-label%special}#S
\ALP+[options%keyvals]{gls-label%special}#S
\ALP+{gls-label%special}[insert]#S
\ALP+[options%keyvals]{gls-label%special}[insert]#S
\AF{gls-label%special}#*
\AF[options%keyvals]{gls-label%special}#*
\AF{gls-label%special}[insert]#*
\AF[options%keyvals]{gls-label%special}[insert]#*
\AF*{gls-label%special}#S
\AF*[options%keyvals]{gls-label%special}#S
\AF*{gls-label%special}[insert]#S
\AF*[options%keyvals]{gls-label%special}[insert]#S
\AF+{gls-label%special}#S
\AF+[options%keyvals]{gls-label%special}#S
\AF+{gls-label%special}[insert]#S
\AF+[options%keyvals]{gls-label%special}[insert]#S
\AFP{gls-label%special}#*
\AFP[options%keyvals]{gls-label%special}#*
\AFP{gls-label%special}[insert]#*
\AFP[options%keyvals]{gls-label%special}[insert]#*
\AFP*{gls-label%special}#S
\AFP*[options%keyvals]{gls-label%special}#S
\AFP*{gls-label%special}[insert]#S
\AFP*[options%keyvals]{gls-label%special}[insert]#S
\AFP+{gls-label%special}#S
\AFP+[options%keyvals]{gls-label%special}#S
\AFP+{gls-label%special}[insert]#S
\AFP+[options%keyvals]{gls-label%special}[insert]#S

#ifOption:shortcuts=abbreviations
\newabbr{gls-label%specialDef}{short}{long}#s#%gls-label
\newabbr[options%keyvals]{gls-label%specialDef}{short}{long}#s#%gls-label
#endif
#ifOption:shortcuts=abbr
\newabbr{gls-label%specialDef}{short}{long}#s#%gls-label
\newabbr[options%keyvals]{gls-label%specialDef}{short}{long}#s#%gls-label
#endif
#ifOption:shortcuts=other
\newentry{gls-label%specialDef}{keyvals}#s#%gls-label
\newsym{gls-label%specialDef}{symbol}#s#%gls-label
\newsym[options%keyvals]{gls-label%specialDef}{symbol}#s#%gls-label
\newnum{gls-label%specialDef}{number}#s#%gls-label
\newnum[options%keyvals]{gls-label%specialDef}{number}#s#%gls-label
#endif
#ifOption:shortcuts=acother
\newentry{gls-label%specialDef}{keyvals}#s#%gls-label
\newsym{gls-label%specialDef}{symbol}#s#%gls-label
\newsym[options%keyvals]{gls-label%specialDef}{symbol}#s#%gls-label
\newnum{gls-label%specialDef}{number}#s#%gls-label
\newnum[options%keyvals]{gls-label%specialDef}{number}#s#%gls-label
#endif
#ifOption:shortcuts=abother
\newabbr{gls-label%specialDef}{short}{long}#s#%gls-label
\newabbr[options%keyvals]{gls-label%specialDef}{short}{long}#s#%gls-label
\newentry{gls-label%specialDef}{keyvals}#s#%gls-label
\newsym{gls-label%specialDef}{symbol}#s#%gls-label
\newsym[options%keyvals]{gls-label%specialDef}{symbol}#s#%gls-label
\newnum{gls-label%specialDef}{number}#s#%gls-label
\newnum[options%keyvals]{gls-label%specialDef}{number}#s#%gls-label
#endif
#ifOption:shortcuts=all
\newabbr{gls-label%specialDef}{short}{long}#s#%gls-label
\newabbr[options%keyvals]{gls-label%specialDef}{short}{long}#s#%gls-label
\newentry{gls-label%specialDef}{keyvals}#s#%gls-label
\newsym{gls-label%specialDef}{symbol}#s#%gls-label
\newsym[options%keyvals]{gls-label%specialDef}{symbol}#s#%gls-label
\newnum{gls-label%specialDef}{number}#s#%gls-label
\newnum[options%keyvals]{gls-label%specialDef}{number}#s#%gls-label
#endif
#ifOption:shortcuts=true
\newabbr{gls-label%specialDef}{short}{long}#s#%gls-label
\newabbr[options%keyvals]{gls-label%specialDef}{short}{long}#s#%gls-label
\newentry{gls-label%specialDef}{keyvals}#s#%gls-label
\newsym{gls-label%specialDef}{symbol}#s#%gls-label
\newsym[options%keyvals]{gls-label%specialDef}{symbol}#s#%gls-label
\newnum{gls-label%specialDef}{number}#s#%gls-label
\newnum[options%keyvals]{gls-label%specialDef}{number}#s#%gls-label
#endif

#ifOption:record
#include:glossaries-extra-bib2gls
#endif
#ifOption:record=only
#include:glossaries-extra-bib2gls
#endif
#ifOption:record=nameref
#include:glossaries-extra-bib2gls
#endif

# from options inherited from glossaries.sty
#ifOption:translate
#include:translator
#include:tracklang
#endif
#ifOption:translate=true
#include:translator
#include:tracklang
#endif
#ifOption:translate=babel
#include:glossaries-babel
#endif

#ifOption:xindy
## Required Styles ##
\GlsAddXdyStyle{style-name}
\GlsSetXdyStyles{style name list}
## Language and Encodings ##
\GlsSetXdyLanguage{language}
\GlsSetXdyLanguage[glossary-type]{language}
\GlsSetXdyCodePage{codepage}
## Locations and Number lists ##
\GlsAddXdyCounters{counter list}
\GlsAddXdyAttribute{name}
\GlsAddXdyLocation{name}{definition}
\GlsAddXdyLocation[H-prefix]{name}{definition}
\GlsSetXdyLocationClassOrder{location names}
\GlsSetXdyMinRangeLength{integer}
## Glossary Groups ##
\GlsSetXdyFirstLetterAfterDigits{letter}
\GlsSetXdyNumberGroupOrder{relative location}
## other
\GlsAddLetterGroup{name}{xindy code}#*
\GlsAddSortRule{arg1}{arg2}#*
\GlsAddXdyAlphabet{name}{definition}#*
#endif

\glsxtrundeftag#*
\glsxtrundefaction{message}{additional help}#*
\glsxtrsetbibglsaux{basename}#*
\thewrglossary#*
\glsxtrwrglossmark#*
\glsxtrwrglosscountermark{number}#*
\glsxtrshowtargetouter{target-name}#*
\glsxtrshowtargetinner{target-name}#*
\glsshowtargetinnersymleft{name}#*
\glsxtrshowtargetsymbolleft#*
\glsshowtargetinnersymright{name}#*
\glsxtrshowtargetsymbolright#*

### 3 Defining Entries ###
\longnewglossaryentry*{gls-label%specialDef}{keyvals}{long description}#s#%gls-label

# keys provided by glossaries.sty
#keyvals:\longnewglossaryentry*#c,\newentry#c,\newabbr#c,\newsym#c,\newnum#c,\glsxtrnewsymbol#c,\glsxtrnewnumber#c,\newabbreviation#c
name=%<text%>
description=%<text%>
parent=%<parent-label%>
descriptionplural=%<text%>
text=%<text%>
first=%<text%>
plural=%<text%>
firstplural=%<text%>
symbol=%<symbol%>
symbolplural=%<symbol%>
sort=%<entry%>
type=%<glossary-label%>
user1=%<text%>
user2=%<text%>
user3=%<text%>
user4=%<text%>
user5=%<text%>
user6=%<text%>
nonumberlist#true,false
see={%<xr-list%>}
see={[%<tag%>]%<xr-list%>}
#endkeyvals

# keys provided by glossaries-extra.sty
#keyvals:\newglossaryentry#c,\longnewglossaryentry#c,\provideglossaryentry#c,\longprovideglossaryentry#c,\newacronym#c,\newterm#c,\longnewglossaryentry*#c,\newentry#c,\newabbr#c,\newsym#c,\newnum#c,\glsxtrnewsymbol#c,\glsxtrnewnumber#c,\newabbreviation#c
category=%<category-label%>
seealso={%<xr-list%>}
alias={%<xr-label%>}
#endkeyvals

\glsxtrpostlongdescription#*
\glsxtrprovidestoragekey{key%plain}{default value}{no link cs%cmd}#*d
\glsxtrifkeydefined{key%plain}{true}{false}#*
\glsxtraliashook{gls-label}#*
\glsxtrdeffield{gls-label%special}{field}{value}#*
\glsxtredeffield{gls-label%special}{field}{value}#*
\glsxtrapptocsvfield{gls-label%special}{field}{value}#*
\glsxtrfieldlistadd{gls-label%special}{field}{value}#*
\glsxtrfieldlistgadd{gls-label%special}{field}{value}#*
\glsxtrfieldlisteadd{gls-label%special}{field}{value}#*
\glsxtrfieldlistxadd{gls-label%special}{field}{value}#*
\glsxtrsetfieldifexists{gls-label%special}{field}{code}#*
\GlsXtrSetField{gls-label%special}{field}{value}#*
\gGlsXtrSetField{gls-label%special}{field}{value}#*
\eGlsXtrSetField{gls-label%special}{field}{value}#*
\xGlsXtrSetField{gls-label%special}{field}{value}#*
\GlsXtrLetField{gls-label%special}{field}{value}#*
\csGlsXtrLetField{gls-label%special}{field}{csname}#*
\GlsXtrLetFieldToField{gls-label%special}{field1}{gls-label%special}{field2}#*

### 4 Abbreviations ###
## Defining Abbreviations ##
\newabbreviation{gls-label%specialDef}{short}{long}#s#%gls-label
\newabbreviation[options%keyvals]{gls-label%specialDef}{short}{long}#s#%gls-label
\glsxtrabbrvpluralsuffix#*
\glsxtrabbrvtype#*
\glsxtrnewabbrevpresetkeyhook{options}{gls-label}{short}#*
\newabbreviationhook#*

## Referencing (Using) Abbreviations ##
\glsxtrshort{gls-label%special}
\glsxtrshort[options%keyvals]{gls-label%special}
\glsxtrshort{gls-label%special}[insert]#*
\glsxtrshort[options%keyvals]{gls-label%special}[insert]#*
\Glsxtrshort{gls-label%special}
\Glsxtrshort[options%keyvals]{gls-label%special}
\Glsxtrshort{gls-label%special}[insert]#*
\Glsxtrshort[options%keyvals]{gls-label%special}[insert]#*
\GLSxtrshort{gls-label%special}
\GLSxtrshort[options%keyvals]{gls-label%special}
\GLSxtrshort{gls-label%special}[insert]#*
\GLSxtrshort[options%keyvals]{gls-label%special}[insert]#*

\glsxtrshortpl{gls-label%special}#*
\glsxtrshortpl[options%keyvals]{gls-label%special}#*
\glsxtrshortpl{gls-label%special}[insert]#*
\glsxtrshortpl[options%keyvals]{gls-label%special}[insert]#*
\Glsxtrshortpl{gls-label%special}#*
\Glsxtrshortpl[options%keyvals]{gls-label%special}#*
\Glsxtrshortpl{gls-label%special}[insert]#*
\Glsxtrshortpl[options%keyvals]{gls-label%special}[insert]#*
\GLSxtrshortpl{gls-label%special}#*
\GLSxtrshortpl[options%keyvals]{gls-label%special}#*
\GLSxtrshortpl{gls-label%special}[insert]#*
\GLSxtrshortpl[options%keyvals]{gls-label%special}[insert]#*

\glsxtrlong{gls-label%special}
\glsxtrlong[options%keyvals]{gls-label%special}
\glsxtrlong{gls-label%special}[insert]#*
\glsxtrlong[options%keyvals]{gls-label%special}[insert]#*
\Glsxtrlong{gls-label%special}
\Glsxtrlong[options%keyvals]{gls-label%special}
\Glsxtrlong{gls-label%special}[insert]#*
\Glsxtrlong[options%keyvals]{gls-label%special}[insert]#*
\GLSxtrlong{gls-label%special}
\GLSxtrlong[options%keyvals]{gls-label%special}
\GLSxtrlong{gls-label%special}[insert]#*
\GLSxtrlong[options%keyvals]{gls-label%special}[insert]#*

\glsxtrlongpl{gls-label%special}#*
\glsxtrlongpl[options%keyvals]{gls-label%special}#*
\glsxtrlongpl{gls-label%special}[insert]#*
\glsxtrlongpl[options%keyvals]{gls-label%special}[insert]#*
\Glsxtrlongpl{gls-label%special}#*
\Glsxtrlongpl[options%keyvals]{gls-label%special}#*
\Glsxtrlongpl{gls-label%special}[insert]#*
\Glsxtrlongpl[options%keyvals]{gls-label%special}[insert]#*
\GLSxtrlongpl{gls-label%special}#*
\GLSxtrlongpl[options%keyvals]{gls-label%special}#*
\GLSxtrlongpl{gls-label%special}[insert]#*
\GLSxtrlongpl[options%keyvals]{gls-label%special}[insert]#*

\glsxtrfull{gls-label%special}
\glsxtrfull[options%keyvals]{gls-label%special}
\glsxtrfull{gls-label%special}[insert]#*
\glsxtrfull[options%keyvals]{gls-label%special}[insert]#*
\Glsxtrfull{gls-label%special}
\Glsxtrfull[options%keyvals]{gls-label%special}
\Glsxtrfull{gls-label%special}[insert]#*
\Glsxtrfull[options%keyvals]{gls-label%special}[insert]#*
\GLSxtrfull{gls-label%special}
\GLSxtrfull[options%keyvals]{gls-label%special}
\GLSxtrfull{gls-label%special}[insert]#*
\GLSxtrfull[options%keyvals]{gls-label%special}[insert]#*

\glsxtrfullpl{gls-label%special}#*
\glsxtrfullpl[options%keyvals]{gls-label%special}#*
\glsxtrfullpl{gls-label%special}[insert]#*
\glsxtrfullpl[options%keyvals]{gls-label%special}[insert]#*
\Glsxtrfullpl{gls-label%special}#*
\Glsxtrfullpl[options%keyvals]{gls-label%special}#*
\Glsxtrfullpl{gls-label%special}[insert]#*
\Glsxtrfullpl[options%keyvals]{gls-label%special}[insert]#*
\GLSxtrfullpl{gls-label%special}#*
\GLSxtrfullpl[options%keyvals]{gls-label%special}#*
\GLSxtrfullpl{gls-label%special}[insert]#*
\GLSxtrfullpl[options%keyvals]{gls-label%special}[insert]#*

\glsxtrsetlongfirstuse{gls-label}#*
\glsxtrsetupfulldefs#*
\glsxtrfullsaveinsert{gls-label}{insert}#*

## Tagging Initials ##
\GlsXtrEnableInitialTagging{categories}{cmd}#d
\GlsXtrEnableInitialTagging*{categories}{cmd}#d
\glsxtrtagfont{text}#*

## Abbreviation Styles ##
\setabbreviationstyle{style-name%keyvals}
\setabbreviationstyle[category]{style-name%keyvals}

#keyvals:\setabbreviationstyle#c
short-nolong
short
short-nolong-desc
short-desc
nolong-short
short-sc-nolong
short-sc
short-sc-nolong-desc
short-sc-desc
short-sm-nolong
short-sm
short-sm-nolong-desc
short-sm-desc
nolong-short-sm
short-em-nolong
short-em
short-em-nolong-desc
short-em-desc
nolong-short-em
long-noshort-desc
long-desc
long-noshort
long
long-noshort-sc
long-noshort-sc-desc
long-noshort-sm
long-noshort-sm-desc
long-noshort-em
long-noshort-em-desc
long-em-noshort-em
long-em-noshort-em-desc
long-short
long-short-desc
long-short-sc
long-short-sc-desc
long-short-sm
long-short-sm-desc
long-short-em
long-short-em-desc
long-em-short-em
long-em-short-em-desc
long-short-user
long-short-user-desc
long-postshort-user
long-postshort-user-desc
long-postshort-sc-user
long-postshort-sc-user-desc
short-long
short-long-desc
short-sc-long
short-sc-long-desc
short-sm-long
short-sm-long-desc
short-em-long
short-em-long-desc
short-em-long-em
short-em-long-em-desc
short-long-user
short-long-user-desc
short-postlong-user
short-postlong-user-desc
long-hyphen-short-hyphen
long-hyphen-postshort-hyphen
long-hyphen-short-hyphen-desc
long-hyphen-postshort-hyphen-desc
long-hyphen-noshort-desc-noreg
long-hyphen-noshort-noreg
short-hyphen-long-hyphen
short-hyphen-postlong-hyphen
short-hyphen-long-hyphen-desc
short-hyphen-postlong-hyphen-desc
long-only-short-only
long-only-short-only-desc
long-only-short-sc-only
long-only-short-sc-only-desc
short-footnote
footnote
short-footnote-desc
footnote-desc
short-postfootnote
postfootnote
short-postfootnote-desc
postfootnote-desc
short-sc-footnote
short-sc-footnote-desc
short-sc-postfootnote
short-sc-postfootnote-desc
short-sm-footnote
short-sm-footnote-desc
short-sm-postfootnote
short-sm-postfootnote-desc
short-em-footnote
short-em-footnote-desc
short-em-postfootnote
short-em-postfootnote-desc
short-nolong-noreg
short-nolong-desc-noreg
nolong-short-noreg
long-noshort-desc-noreg
long-noshort-noreg
long-em-noshort-em-noreg
long-em-noshort-em-desc-noreg
%abbreviationstyle
#endkeyvals

\ifglsxtrinsertinside#*
\glsxtrinsertinsidetrue#*
\glsxtrinsertinsidefalse#*
\glsxtrparen{text}#*
\glsxtrfullsep{gls-label}#*
\glsabbrvdefaultfont{text}#*
\glsfirstabbrvdefaultfont{text}#*
\glsxtrdefaultrevert{text}#*
\glslongdefaultfont{text}#*
\glsfirstlongdefaultfont{text}#*
\glsxtrlongshortname#*
\glsxtrlongshortdescsort#*
\glsxtrlongshortdescname#*
\glsxtrshortlongname#*
\glsxtrshortlongdescsort#*
\glsxtrshortlongdescname#*
\glsxtruserfield#*
\glsxtruserparensep#*
\glsxtruserfieldfmt{text}#*
\glsabbrvuserfont{text}#*
\glsfirstabbrvuserfont{text}#*
\glsxtrusersuffix#*
\glslonguserfont{text}#*
\glsfirstlonguserfont{text}#*
\glsabbrvscuserfont{text}#*
\glsfirstabbrvscuserfont{text}#*
\glsxtrscuserrevert{text}#*
\glsxtrscusersuffix#*
\glsuserdescription{long}{gls-label}#*
\glsxtruserparen{text}{gls-label}#*
\GLSxtruserparen{text}{gls-label}#*
\glsxtrlongshortuserdescname#*
\glsxtrlongshortscusername#*
\glsxtrlongshortscuserdescname#*
\glsxtrshortlonguserdescname#*
\glsxtruserlongshortformat{gls-label}{insert}{long-cs}{short-cs}#*
\Glsxtruserlongshortformat{gls-label}{insert}{long-cs}{short-cs}#*
\GLSxtruserlongshortformat{gls-label}{insert}{long-cs}{short-cs}#*
\glsxtruserlongshortplformat{gls-label}{insert}{long-cs}{short-cs}#*
\Glsxtruserlongshortplformat{gls-label}{insert}{long-cs}{short-cs}#*
\GLSxtruserlongshortplformat{gls-label}{insert}{long-cs}{short-cs}#*
\glsxtrusershortlongformat{gls-label}{insert}{long-cs}{short-cs}#*
\Glsxtrusershortlongformat{gls-label}{insert}{long-cs}{short-cs}#*
\GLSxtrusershortlongformat{gls-label}{insert}{long-cs}{short-cs}#*
\glsxtrusershortlongplformat{gls-label}{insert}{long-cs}{short-cs}#*
\Glsxtrusershortlongplformat{gls-label}{insert}{long-cs}{short-cs}#*
\GLSxtrusershortlongplformat{gls-label}{insert}{long-cs}{short-cs}#*
\glsxtrusershortformat{gls-label}{fmt-cs}#*
\glsxtrusershortplformat{gls-label}{fmt-cs}#*
\GLSxtrusershortformat{gls-label}{fmt-cs}#*
\GLSxtrusershortplformat{gls-label}{fmt-cs}#*
\glsxtrpostusershortformat{gls-label}{fmt-cs}#*
\glsxtruserlongformat{gls-label}{fmt-cs}#*
\GLSxtruserlongformat{gls-label}{fmt-cs}#*
\glsxtruserlongplformat{gls-label}{fmt-cs}#*
\GLSxtruserlongplformat{gls-label}{fmt-cs}#*
\glsxtrpostuserlongformat{gls-label}{fmt-cs}#*
\glsxtrfootnotename#*
\glsxtrfootnotedescname#*
\glsxtrfootnotedescsort#*
\glslongfootnotefont{text}#*
\glsfirstlongfootnotefont{text}#*
\glsxtrabbrvfootnote{gls-label}{text}#*
\glsxtrfootnotelongformat{gls-label}{fmt-cs}#*
\glsxtrfootnotelongplformat{gls-label}{fmt-cs}#*
\glsxtrpostfootnotelongformat{gls-label}{fmt-cs}#*
\glsxtrshortnolongname#*
\glsxtrshortdescname#*
\glsxtrlongnoshortdescname#*
\glsxtrlongnoshortname#*
\glsabbrvhyphenfont{text}#*
\glsfirstabbrvhyphenfont{text}#*
\glslonghyphenfont{text}#*
\glsfirstlonghyphenfont{text}#*
\glsxtrhyphensuffix#*
\glsxtrlonghyphenshortsort#*
\glsxtrshorthyphenlongsort#*
\glsxtrlonghyphennoshortsort#*
\glsxtrlonghyphennoshortdescsort#*
\glsxtrlonghyphenshort{gls-label%special}{long}{short}{insert}#*
\GLSxtrlonghyphenshort{gls-label%special}{long}{short}{insert}#*
\glsxtrlonghyphennoshort{gls-label%special}{long}{insert}#*
\GLSxtrlonghyphennoshort{gls-label%special}{long}{insert}#*
\glsxtrlonghyphen{gls-label%special}{long}{insert}#*
\xpglsxtrposthyphenshort#*
\glsxtrposthyphenshort{gls-label%special}{insert}#*
\GLSxtrposthyphenshort{gls-label%special}{insert}#*
\glsxtrposthyphenshortpl{gls-label%special}{insert}#*
\GLSxtrposthyphenshortpl{gls-label%special}{insert}#*
\xpglsxtrposthyphensubsequent#*
\glsxtrposthyphensubsequent{gls-label%special}{insert}#*
\GLSxtrposthyphensubsequent{gls-label%special}{insert}#*
\glsxtrshorthyphenlong{gls-label%special}{long}{short}{insert}#*
\GLSxtrshorthyphenlong{gls-label%special}{long}{short}{insert}#*
\glsxtrshorthyphen{gls-label%special}{short}{insert}#*
\xpglsxtrposthyphenlong#*
\glsxtrposthyphenlong{gls-label%special}{insert}#*
\GLSxtrposthyphenlong{gls-label%special}{insert}#*
\glsxtrposthyphenlongpl{gls-label%special}{insert}#*
\GLSxtrposthyphenlongpl{gls-label%special}{insert}#*
\glsabbrvonlyfont{text}#*
\glsfirstabbrvonlyfont{text}#*
\glslongonlyfont{text}#*
\glsfirstlongonlyfont{text}#*
\glsxtronlysuffix#*
\glsabbrvsconlyfont{text}#*
\glsfirstabbrvsconlyfont{text}#*
\glsxtrsconlyrevert{text}#*
\glsxtrsconlysuffix#*
\glsxtronlyname#*
\glsxtronlydescname#*
\glsxtronlydescsort#*
\glsxtrsconlyname#*
\glsxtrsconlydescname#*
\glsxtrsconlydescsort#*
\glsabbrvscfont{text}#*
\glsfirstabbrvscfont{text}#*
\glsxtrscrevert{text}#*
\glsxtrscsuffix#*
\glsabbrvsmfont{text}#*
\glsfirstabbrvsmfont{text}#*
\glsxtrsmrevert{text}#*
\glsxtrsmsuffix#*
\glsabbrvemfont{text}#*
\glsfirstabbrvemfont{text}#*
\glsxtremrevert{text}#*
\glsxtremsuffix#*
\glslongemfont{text}#*
\glsfirstlongemfont{text}#*
\glssetabbrvfmt{category}#*
\glsuseabbrvfont{style-name}{text}#*
\glsuselongfont{style-name}{text}#*
\GlsXtrUseAbbrStyleSetup{style-name}#*
\GlsXtrUseAbbrStyleFmts{style-name}#*
\xpglsxtrpostabbrvfootnote#*
\glsxtrpostabbrvfootnote{gls-label}{fmt-code}#*
\glsxtrifhyphenstart{string}{true}{false}#*
\GlsXtrWarnDeprecatedAbbrStyle{old name}{new name}#*
\newabbreviationstyle{name%specialDef}{setup}{definitions}#*s#%abbreviationstyle
\renewabbreviationstyle{name}{setup}{definitions}#*
\letabbreviationstyle{new-style%specialDef}{existing-style}#*s#%abbreviationstyle
\glscategorylabel#*
\glsxtrorgkeylist#*
\glsxtrorgshort#*
\glsshortpltok#*
\glsxtrorglong#*
\glslongpltok#*
\ExtraCustomAbbreviationFields#*
\CustomAbbreviationFields#*
\GlsXtrPostNewAbbreviation#*
\glsxtrsetcomplexstyle{gls-label}{n}#*
\glsfirstinnerfmtabbrvfont{text}#*
\glsfirstxpabbrvfont{text}{category}#*
\glsinnerfmtabbrvfont{text}#*
\glsxpabbrvfont{text}{category}#*
\glsfirstinnerfmtlongfont{text}#*
\glsfirstxplongfont{text}{category}#*
\glsinnerfmtlongfont{text}#*
\glsxplongfont{text}{category}#*
\glsxtrAccSuppAbbrSetNoLongAttrs{category}#*
\glsxtrAccSuppAbbrSetNameLongAttrs{category}#*
\glsxtrAccSuppAbbrSetFirstLongAttrs{category}#*
\glsxtrAccSuppAbbrSetTextShortAttrs{category}#*
\glsxtrAccSuppAbbrSetNameShortAttrs{category}#*
\abbrvpluralsuffix#*
\glsfirstabbrvfont{text}#*
\glsabbrvfont{text}#*
\glsxtrrevert{text}#*
\glsfirstlongfont{text}#*
\glslongfont{text}#*
\glsxtrfullformat{gls-label%special}{insert}#*
\glsxtrfullplformat{gls-label%special}{insert}#*
\Glsxtrfullformat{gls-label%special}{insert}#*
\Glsxtrfullplformat{gls-label%special}{insert}#*
\GLSxtrfullformat{gls-label%special}{insert}#*
\GLSxtrfullplformat{gls-label%special}{insert}#*
\glsxtrsubsequentfmt{gls-label%special}{insert}#*
\glsxtrsubsequentplfmt{gls-label%special}{insert}#*
\Glsxtrsubsequentfmt{gls-label%special}{insert}#*
\Glsxtrsubsequentplfmt{gls-label%special}{insert}#*
\GLSxtrsubsequentfmt{gls-label%special}{insert}#*
\GLSxtrsubsequentplfmt{gls-label%special}{insert}#*
\glsxtrdefaultsubsequentfmt{gls-label%special}{insert}#*
\glsxtrdefaultsubsequentplfmt{gls-label%special}{insert}#*
\Glsxtrdefaultsubsequentfmt{gls-label%special}{insert}#*
\Glsxtrdefaultsubsequentplfmt{gls-label%special}{insert}#*
\GLSxtrdefaultsubsequentfmt{gls-label%special}{insert}#*
\GLSxtrdefaultsubsequentplfmt{gls-label%special}{insert}#*
\glsxtrinlinefullformat{gls-label%special}{insert}#*
\glsxtrinlinefullplformat{gls-label%special}{insert}#*
\Glsxtrinlinefullformat{gls-label%special}{insert}#*
\Glsxtrinlinefullplformat{gls-label%special}{insert}#*
\GLSxtrinlinefullformat{gls-label%special}{insert}#*
\GLSxtrinlinefullplformat{gls-label%special}{insert}#*
\glsxtrlongformat{gls-label%special}{insert}{format-cs}#*
\Glsxtrlongformat{gls-label%special}{insert}{format-cs}#*
\GLSxtrlongformat{gls-label%special}{insert}{format-cs}#*
\glsxtrlongplformat{gls-label%special}{insert}{format-cs}#*
\Glsxtrlongplformat{gls-label%special}{insert}{format-cs}#*
\GLSxtrlongplformat{gls-label%special}{insert}{format-cs}#*
\glsxtrlongformatgrp{gls-label%special}{insert}{format-cs}#*
\Glsxtrlongformatgrp{gls-label%special}{insert}{format-cs}#*
\GLSxtrlongformatgrp{gls-label%special}{insert}{format-cs}#*
\glsxtrlongplformatgrp{gls-label%special}{insert}{format-cs}#*
\Glsxtrlongplformatgrp{gls-label%special}{insert}{format-cs}#*
\GLSxtrlongplformatgrp{gls-label%special}{insert}{format-cs}#*
\glsxtrshortformat{gls-label%special}{insert}{format-cs}#*
\Glsxtrshortformat{gls-label%special}{insert}{format-cs}#*
\GLSxtrshortformat{gls-label%special}{insert}{format-cs}#*
\glsxtrshortplformat{gls-label%special}{insert}{format-cs}#*
\Glsxtrshortplformat{gls-label%special}{insert}{format-cs}#*
\GLSxtrshortplformat{gls-label%special}{insert}{format-cs}#*
\glsxtrshortformatgrp{gls-label%special}{insert}{format-cs}#*
\Glsxtrshortformatgrp{gls-label%special}{insert}{format-cs}#*
\GLSxtrshortformatgrp{gls-label%special}{insert}{format-cs}#*
\glsxtrshortplformatgrp{gls-label%special}{insert}{format-cs}#*
\Glsxtrshortplformatgrp{gls-label%special}{insert}{format-cs}#*
\GLSxtrshortplformatgrp{gls-label%special}{insert}{format-cs}#*
\glsxtrlongshortformat{gls-label%special}{insert}{format-cs}#*
\Glsxtrlongshortformat{gls-label%special}{insert}{format-cs}#*
\GLSxtrlongshortformat{gls-label%special}{insert}{format-cs}#*
\glsxtrlongshortplformat{gls-label%special}{insert}{long-cs}{short-cs}#*
\Glsxtrlongshortplformat{gls-label%special}{insert}{long-cs}{short-cs}#*
\GLSxtrlongshortplformat{gls-label%special}{insert}{long-cs}{short-cs}#*
\glsxtrshortlongformat{gls-label%special}{insert}{long-cs}{short-cs}#*
\Glsxtrshortlongformat{gls-label%special}{insert}{long-cs}{short-cs}#*
\GLSxtrshortlongformat{gls-label%special}{insert}{long-cs}{short-cs}#*
\glsxtrshortlongplformat{gls-label%special}{insert}{long-cs}{short-cs}#*
\Glsxtrshortlongplformat{gls-label%special}{insert}{long-cs}{short-cs}#*
\GLSxtrshortlongplformat{gls-label%special}{insert}{long-cs}{short-cs}#*

## Restoring Base Acronym Mechanism ##
\RestoreAcronyms#*
\MakeAcronymsAbbreviations#*

### 5 Referencing (Using) Entries ###
\GlsXtrSetAltModifier{token}{options%keyvals}
\GlsXtrSetStarModifier{options%keyvals}
\GlsXtrSetPlusModifier{options%keyvals}
\glslinkwrcontent{code}#*

## Options ##
\GlsXtrSetDefaultGlsOpts{options%keyvals}
\GlsXtrAppToDefaultGlsOpts{options%keyvals}
\GlsXtrPreToDefaultGlsOpts{options%keyvals}
\GlsXtrSetDefaultNumberFormat{encap}
\GlsXtrFmtDefaultOptions#*
\glslinkpresetkeys#*
\glsaddpresetkeys#*
\glsaddpostsetkeys#*
\glsinitreunsets#*
\glsxtrchecknohyperfirst{gls-label%special}#*
\glsxtrinitwrgloss#*
\glsxtrinithyperoutside#*
\setupglslink{options%keyvals}
\setupglsadd{options%keyvals}

#keyvals:\gls#c,\Gls#c,\GLS#c,\glspl#c,\Glspl#c,\GLSpl#c,\glsdisp#c,\Glsdisp#c,\glslink#c,\Glslink#c,\glstext#c,\Glstext#c,\GLStext#c,\glsfirst#c,\Glsfirst#c,\GLSfirst#c,\glsplural#c,\Glsplural#c,\GLSplural#c,\glsfirstplural#c,\Glsfirstplural#c,\GLSfirstplural#c,\glsname#c,\Glsname#c,\GLSname#c,\glssymbol#c,\Glssymbol#c,\GLSsymbol#c,\glssymbolplural#c,\Glssymbolplural#c,\GLSsymbolplural#c,\glsdesc#c,\Glsdesc#c,\GLSdesc#c,\glsdescplural#c,\Glsdescplural#c,\GLSdescplural#c,\glsuseri#c,\Glsuseri#c,\GLSuseri#c,\glsuserii#c,\Glsuserii#c,\GLSuserii#c,\glsuseriii#c,\Glsuseriii#c,\GLSuseriii#c,\glsuseriv#c,\Glsuseriv#c,\GLSuseriv#c,\glsuserv#c,\Glsuserv#c,\GLSuserv#c,\glsuservi#c,\Glsuservi#c,\GLSuservi#c,\cgls#c,\cGls#c,\cglspl#c,\cGlspl#c,\acrshort#c,\Acrshort#c,\acrshortpl#c,\Acrshortpl#c,\acrlong#c,\Acrlong#c,\acrlongpl#c,\Acrlongpl#c,\acrfull#c,\Acrfull#c,\acrfullpl#c,\Acrfullpl#c,\acs#c,\Acs#c,\acsp#c,\Acsp#c,\acl#c,\Acl#c,\aclp#c,\Aclp#c,\acf#c,\Acf#c,\acfp#c,\Acfp#c,\ac#c,\Ac#c,\acp#c,\Acp#c,\acrfullfmt#c,\ACRfullfmt#c,\Acrfullfmt#c,\ACRfullplfmt#c,\Acrfullplfmt#c,\acrfullplfmt#c,\GlsXtrSetAltModifier#c,\GlsXtrSetStarModifier#c,\GlsXtrSetPlusModifier#c,\GlsXtrSetDefaultGlsOpts#c,\GlsXtrAppToDefaultGlsOpts#c,\GlsXtrPreToDefaultGlsOpts#c,\setupglslink#c,\glsxtrsetpopts#c,\glsxtrnewgls#c,\glsxtrnewglslike#c,\glsxtrnewGLSlike#c,\glsxtrnewglslink#c,\glsxtrnewglsdisp#c,\glsxtrnewrgls#c,\glsxtrnewrglslike#c,\glsxtrnewrGLSlike#c,\glsxtrfmt#c,\glsxtrfmt*#c,\Glsxtrfmt#c,\Glsxtrfmt*#c,\cGLS#c,\cGLS*#c,\cGLS+#c,\cGLSpl#c,\cGLSpl*#c,\cGLSpl+#c,\rgls#c,\rgls*#c,\rgls+#c,\rGls#c,\rGls*#c,\rGls+#c,\rGLS#c,\rGLS*#c,\rGLS+#c,\rglspl#c,\rglspl*#c,\rglspl+#c,\rGlspl#c,\rGlspl*#c,\rGlspl+#c,\rGLSpl#c,\rGLSpl*#c,\rGLSpl+#c,\glsxtr#c,\glsxtrpl#c,\Glsxtr#c,\Glsxtrpl#c
hyperoutside#true,false
textformat=%<csname%>
innertextformat=%<csname%>
postunset=#global,local,none
prereset
prereset=#global,local,none
preunset=#global,local,none
noindex#true,false
wrgloss=#before,after
thevalue=%<location%>
theHvalue=%<the-H-value%>
prefix=%<link-prefix%>
#endkeyvals

#keyvals:\GlsXtrSetAltModifier#c,\GlsXtrSetStarModifier#c,\GlsXtrSetPlusModifier#c,\GlsXtrSetDefaultGlsOpts#c,\GlsXtrAppToDefaultGlsOpts#c,\GlsXtrPreToDefaultGlsOpts#c,\setupglslink#c,\glsxtrsetpopts#c,\glsxtrnewgls#c,\glsxtrnewglslike#c,\glsxtrnewGLSlike#c,\glsxtrnewglslink#c,\glsxtrnewglsdisp#c,\glsxtrfmt#c,\glsxtrfmt*#c,\Glsxtrfmt#c,\Glsxtrfmt*#c,\cGLS#c,\cGLS*#c,\cGLS+#c,\cGLSpl#c,\cGLSpl*#c,\cGLSpl+#c,\rgls#c,\rgls*#c,\rgls+#c,\rGls#c,\rGls*#c,\rGls+#c,\rGLS#c,\rGLS*#c,\rGLS+#c,\rglspl#c,\rglspl*#c,\rglspl+#c,\rGlspl#c,\rGlspl*#c,\rGlspl+#c,\rGLSpl#c,\rGLSpl*#c,\rGLSpl+#c,\glsxtr#c,\glsxtrpl#c,\Glsxtr#c,\Glsxtrpl#c
hyper#true,false
format=%<csname%>
counter=%<counter%>
local#true,false
#endkeyvals

#keyvals:\setupglsadd#c,\glsaddeach#c,\glsstartrange#c,\glsendrange#c,\GlsXtrAutoAddOnFormat#c
format=%<csname%>
counter=%<counter%>
local#true,false
#endkeyvals

#keyvals:\glsadd#c,\glsaddall#c,\setupglsadd#c,\glsaddeach#c,\glsstartrange#c,\glsendrange#c,\GlsXtrAutoAddOnFormat#c
thevalue=%<location%>
theHvalue=%<<prefix><location>%>
#endkeyvals

\ifglsxtrinitwrgloss#*
\glsxtrinitwrglosstrue#*
\glsxtrinitwrglossfalse#*
\glsxtrsupphypernumber{location}#*
\glspdfsentencecase{text}#*

## Entries in Sectioning Titles, Headers, Captions and Contents ##
\glsxtrRevertMarks
\glsxtrRevertTocMarks
\glsxtrtitleopts#*
\glsfmtshort{gls-label%special}#*
\Glsfmtshort{gls-label%special}#*
\GLSfmtshort{gls-label%special}#*
\glsfmtshortpl{gls-label%special}#*
\Glsfmtshortpl{gls-label%special}#*
\GLSfmtshortpl{gls-label%special}#*
\glsfmtlong{gls-label%special}#*
\Glsfmtlong{gls-label%special}#*
\GLSfmtlong{gls-label%special}#*
\glsfmtlongpl{gls-label%special}#*
\Glsfmtlongpl{gls-label%special}#*
\GLSfmtlongpl{gls-label%special}#*
\glspdffmtfull{gls-label%special}#*
\glspdffmtfullpl{gls-label%special}#*
\glsfmtfull{gls-label%special}#*
\Glsfmtfull{gls-label%special}#*
\GLSfmtfull{gls-label%special}#*
\glsfmtfullpl{gls-label%special}#*
\Glsfmtfullpl{gls-label%special}#*
\GLSfmtfullpl{gls-label%special}#*
\glsfmtname{gls-label%special}#*
\Glsfmtname{gls-label%special}#*
\GLSfmtname{gls-label%special}#*
\glsfmttext{gls-label%special}#*
\Glsfmttext{gls-label%special}#*
\GLSfmttext{gls-label%special}#*
\glsfmtplural{gls-label%special}#*
\Glsfmtplural{gls-label%special}#*
\GLSfmtplural{gls-label%special}#*
\glsfmtfirst{gls-label%special}#*
\Glsfmtfirst{gls-label%special}#*
\GLSfmtfirst{gls-label%special}#*
\glsfmtfirstpl{gls-label%special}#*
\Glsfmtfirstpl{gls-label%special}#*
\GLSfmtfirstpl{gls-label%special}#*
\glsxtrifinmark{true}{false}#*
\glsxtrifintoc{true}{false}#*
\glsxtrtitleorpdforheading{title%text}{PDF bookmarks%text}{heading%text}
\glsxtrifheaduc{gls-label%special}{true}{false}#*
\glsxtrtitleshort{gls-label%special}#*
\glsxtrheadshort{gls-label%special}#*
\Glsxtrtitleshort{gls-label%special}#*
\Glsxtrheadshort{gls-label%special}#*
\GLSxtrtitleshort{gls-label%special}#*
\GLSxtrheadshort{gls-label%special}#*
\glsxtrtitleshortpl{gls-label%special}#*
\glsxtrheadshortpl{gls-label%special}#*
\Glsxtrtitleshortpl{gls-label%special}#*
\Glsxtrheadshortpl{gls-label%special}#*
\GLSxtrtitleshortpl{gls-label%special}#*
\GLSxtrheadshortpl{gls-label%special}#*
\glsxtrtitlelong{gls-label%special}#*
\glsxtrheadlong{gls-label%special}#*
\Glsxtrtitlelong{gls-label%special}#*
\Glsxtrheadlong{gls-label%special}#*
\GLSxtrtitlelong{gls-label%special}#*
\GLSxtrheadlong{gls-label%special}#*
\glsxtrtitlelongpl{gls-label%special}#*
\glsxtrheadlongpl{gls-label%special}#*
\Glsxtrtitlelongpl{gls-label%special}#*
\Glsxtrheadlongpl{gls-label%special}#*
\GLSxtrtitlelongpl{gls-label%special}#*
\GLSxtrheadlongpl{gls-label%special}#*
\glsxtrtitlefull{gls-label%special}#*
\glsxtrheadfull{gls-label%special}#*
\Glsxtrtitlefull{gls-label%special}#*
\Glsxtrheadfull{gls-label%special}#*
\GLSxtrtitlefull{gls-label%special}#*
\GLSxtrheadfull{gls-label%special}#*
\glsxtrtitlefullpl{gls-label%special}#*
\glsxtrheadfullpl{gls-label%special}#*
\Glsxtrtitlefullpl{gls-label%special}#*
\Glsxtrheadfullpl{gls-label%special}#*
\GLSxtrtitlefullpl{gls-label%special}#*
\GLSxtrheadfullpl{gls-label%special}#*
\glsxtrtitlename{gls-label%special}#*
\glsxtrheadname{gls-label%special}#*
\Glsxtrtitlename{gls-label%special}#*
\Glsxtrheadname{gls-label%special}#*
\GLSxtrtitlename{gls-label%special}#*
\GLSxtrheadname{gls-label%special}#*
\glsxtrtitletext{gls-label%special}#*
\glsxtrheadtext{gls-label%special}#*
\Glsxtrtitletext{gls-label%special}#*
\Glsxtrheadtext{gls-label%special}#*
\GLSxtrtitletext{gls-label%special}#*
\GLSxtrheadtext{gls-label%special}#*
\glsxtrtitleplural{gls-label%special}#*
\glsxtrheadplural{gls-label%special}#*
\Glsxtrtitleplural{gls-label%special}#*
\Glsxtrheadplural{gls-label%special}#*
\GLSxtrtitleplural{gls-label%special}#*
\GLSxtrheadplural{gls-label%special}#*
\glsxtrtitlefirst{gls-label%special}#*
\glsxtrheadfirst{gls-label%special}#*
\Glsxtrtitlefirst{gls-label%special}#*
\Glsxtrheadfirst{gls-label%special}#*
\GLSxtrtitlefirst{gls-label%special}#*
\GLSxtrheadfirst{gls-label%special}#*
\glsxtrtitlefirstplural{gls-label%special}#*
\glsxtrheadfirstplural{gls-label%special}#*
\Glsxtrtitlefirstplural{gls-label%special}#*
\Glsxtrheadfirstplural{gls-label%special}#*
\GLSxtrtitlefirstplural{gls-label%special}#*
\GLSxtrheadfirstplural{gls-label%special}#*
\glsxtrmarkhook#*
\glsxtrrestoremarkhook#*

## Nested Links ##
\glsxtrp{field}{gls-label%special}#*
\glsxtrpInit{csname}{gls-label%special}#*
\glsxtrsetpopts{options%keyvals}#*
\glossxtrsetpopts#*
\glsps{gls-label%special}#*
\glspt{gls-label%special}#*
\Glsps{gls-label%special}#*
\Glspt{gls-label%special}#*
\GLSps{gls-label%special}#*
\GLSpt{gls-label%special}#*
\Glsxtrp{field}{gls-label%special}#*
\GLSxtrp{field}{gls-label%special}#*

## Adjusting the Text Style ##
\GlsXtrExpandedFmt{cs}{text}#*
\glsxtrregularfont{text}#*
\glsxtrabbreviationfont{text}#*
\glsxtrassignfieldfont{text}#*
\glsxtrgenentrytextfmt#*
\glsxtrdefaultentrytextfmt{text}#*
\glsxtrattrentrytextfmt{text}#*
\glsifapplyinnerfmtfield{gls-label}{internal-field}{true}{false}#*
\glsexclapplyinnerfmtfield{gls-label}{internal-field}#*
\glsfmtfield{insert}{cs}{gls-label}{internal-field}#*
\Glsfmtfield{insert}{cs}{gls-label}{internal-field}#*
\GLSfmtfield{insert}{cs}{gls-label}{internal-field}#*
\glsxtrpostlinkhook#*
\glsxtrdiscardperiod{gls-label}{discarded}{no discard}#*
\glsxtrdiscardperiodretainfirstuse{gls-label}{discarded}{no discard}#*
\glsxtrifcustomdiscardperiod{true}{false}#*
\glsxtrpostlinkendsentence#*
\glsxtrifperiod{true}{false}#*
\glsxtrifnextpunc{true}{false}#*
\glsxtrdopostpunc{code}#*
\glsxtraddpunctuationmark{tokens}#*
\glsxtrsetpunctuationmarks{tokens}#*
\glsxtrpostlink#*
\glsdefpostlink{category}{definition}#*
\glspretopostlink{category}{code}#*
\glsapptopostlink{category}{code}#*
\glsxtrpostlinkAddDescOnFirstUse#*
\glsxtrpostlinkAddSymbolOnFirstUse#*
\glsxtrpostlinkAddSymbolDescOnFirstUse#*
\glsxtrpostlinkSymbolDescSep#*
\glsxtrcurrentfield#*
\glsxtrifwasglslike{true}{false}#*
\glsxtrifwasglslikeandfirstuse{true}{false}#*
\glsxtrifwassubsequentuse{true}{false}#*
\glsxtrifwassubsequentorshort{true}{false}#*
\glsxtrifallcaps{true}{false}#*
\glsxtrsaveinsert{gls-label}{insert}#*
\glsxtrassignlinktextfmt#*
\glsxtrgenabbrvfmt#*

## Hyperlinks ##
\glsxtrtarget{gls-label%special}{text}#*
\glsxtrtargetfield#*
\glsxtrtargetdup{gls-label%special}{text}#*

## Label Prefixes ##
\glsxtrnewgls{prefix}{cmd}#*d
\glsxtrnewgls[default-options%keyvals]{prefix}{cmd}#*d
\glsxtrnewglslike{prefix}{gls-cmd%cmd}{glspl-cmd%cmd}{Gls-cmd%cmd}{Glspl-cmd%cmd}#*d
\glsxtrnewglslike[default-options%keyvals]{prefix}{gls-cmd%cmd}{glspl-cmd%cmd}{Gls-cmd%cmd}{Glspl-cmd%cmd}#*d
\glsxtrnewGLSlike{prefix}{GLS-cmd%cmd}{GLSpl-cmd%cmd}#*d
\glsxtrnewGLSlike[default options%keyvals]{prefix}{GLS-cmd%cmd}{GLSpl-cmd%cmd}#*d
\glsxtrnewglslink{prefix}{cmd}#*d
\glsxtrnewglslink[default-options%keyvals]{prefix}{cmd}#*d
\glsxtrnewglsdisp{prefix}{cmd}#*d
\glsxtrnewglsdisp[default-options%keyvals]{prefix}{cmd}#*d
\glsxtridentifyglslike{prefix}{cmd}#*
\glsxtrnewrgls{prefix}{cmd}#*d
\glsxtrnewrgls[default-options%keyvals]{prefix}{cmd}#*d
\glsxtrnewrglslike{prefix}{rgls-cmd%cmd}{rglspl-cmd%cmd}{rGls-cmd%cmd}{rGlspl-cmd%cmd}#*d
\glsxtrnewrglslike[default-options%keyvals]{prefix}{rgls-cmd%cmd}{rglspl-cmd%cmd}{rGls-cmd%cmd}{rGlspl-cmd%cmd}#*d
\glsxtrnewrGLSlike{prefix}{rGLS-cmd%cmd}{rGLSpl-cmd%cmd}#*d
\glsxtrnewrGLSlike[default-options%keyvals]{prefix}{rGLS-cmd%cmd}{rGLSpl-cmd%cmd}#*d

## Indexing ##
\glsaddallunindexed
\glsaddallunindexed[glossary-types]
\glsaddeach{gls-labels}
\glsaddeach[options%keyvals]{gls-labels}
\glsstartrange{gls-labels}
\glsstartrange[options%keyvals]{gls-labels}
\glsendrange{gls-labels}
\glsendrange[options%keyvals]{gls-labels}
\GlsXtrSetDefaultRangeFormat{encap}
\GlsXtrAutoAddOnFormat{format list}{glsadd options%keyvals}
\GlsXtrAutoAddOnFormat[gls-label]{format list}{glsadd options%keyvals}
\GlsXtrClearAutoAddOnFormat
\glsxtrdowrglossaryhook{gls-label}#*
\glsentryindexcount{gls-label%special}#*
\glsifindexed{gls-label%special}{true}{false}#*
\glsxtrifindexing{true}{false}#*

## Cross-Referencing ##
\glsxtrseelists{gls-label%special}#*
\glsxtrseelistsencap{content}#*
\glsxtrseelistsdelim#*
\glsxtrusesee{gls-label%special}#*
\glsxtrusealias{gls-label%special}#*
\glsxtruseseealso{gls-label%special}#*
\glsxtralias{gls-label%special}#*
\glsxtrseealsolabels{gls-label%special}#*
\glsxtruseseealsoformat{xr-list}#*
\glsxtrindexseealso{gls-label%special}{xr-list}#*
\glsxtrsetaliasnoindex#*
\glsxtrindexaliased#*
\glsxtraddallcrossrefs#*
\glsxtraddunusedxrefs#*
\glsxtrunusedformat{location}#*

## First Use Flag ##
\glsxtrpostunset{gls-label%special}#*
\glsxtrpostlocalunset{gls-label%special}#*
\glsxtrpostreset{gls-label%special}#*
\glsxtrpostlocalreset{gls-label%special}#*
\glslocalunseteach{gls-labels}#*
\glslocalreseteach{gls-labels}#*
\glsxtrifwasfirstuse{true}{false}#*
\GlsXtrIfUnusedOrUndefined{gls-label}{true}{false}#*
\GlsXtrStartUnsetBuffering#*
\GlsXtrClearUnsetBuffer#*
\GlsXtrStopUnsetBuffering#*
\GlsXtrForUnsetBufferedList{handler-cs}#*
\GlsXtrDiscardUnsetBuffering#*
\GlsXtrUnsetBufferEnableRepeatLocal#*
\GlsXtrResetLocalBuffer#*
\GlsXtrUnsetBufferDisableRepeatLocal#*

## Accessing Fields ##
\glsxtrusefield{gls-label%special}{field}#*
\Glsxtrusefield{gls-label%special}{field}#*
\GLSxtrusefield{gls-label%special}{field}#*
\glsxtrfieldtitlecase{gls-label%special}{field}#*
\glsxtrfieldtitlecasecs{content}#*
\glsxtrentryparentname{entry-name}#*
\glsxtrhiername{gls-label%special}#*
\glsxtrhiernamesep#*
\Glsxtrhiername{gls-label%special}#*
\GlsXtrhiername{gls-label%special}#*
\GLSxtrhiername{gls-label%special}#*
\GLSXTRhiername{gls-label%special}#*
\GlsXtrForeignTextField#*
\GlsXtrForeignText{gls-label%special}{text}#*
\GlsXtrUnknownDialectWarning{locale}{language}#*
\GlsXtrFmtField#*
\glsxtrfmt{gls-label%special}{text}#*
\glsxtrfmt[options%keyvals]{gls-label%special}{text}#*
\glsxtrfmt*{gls-label%special}{text}#*
\glsxtrfmt*{gls-label%special}{text}[insert]#*
\glsxtrfmt*[options%keyvals]{gls-label%special}{text}#*
\glsxtrfmt*[options%keyvals]{gls-label%special}{text}[insert]#*
\glsxtrfmtdisplay{csname}{text}{insert}#*
\glsxtrentryfmt{gls-label%special}{text}#*
\glsxtrpdfentryfmt{gls-label%special}{text}#*
\Glsxtrfmt{gls-label%special}{text}#*
\Glsxtrfmt[options%keyvals]{gls-label%special}{text}#*
\Glsxtrfmt*{gls-label%special}{text}#*
\Glsxtrfmt*{gls-label%special}{text}[insert]#*
\Glsxtrfmt*[options%keyvals]{gls-label%special}{text}#*
\Glsxtrfmt*[options%keyvals]{gls-label%special}{text}[insert]#*
\Glsxtrentryfmt{gls-label%special}{text}#*
\Glsxtrpdfentryfmt{gls-label%special}{text}#*

## Comma-Separated Lists ##
\glsxtrseelist{xr-list}#*
\glsxtrtaggedlist{sing-tag}{plural-tag}{prefix}{xr-list}#*
\glsxtrtaggedlistsep#*
\glsseefirstitem{gls-label%special}#*
\glsseelastoxfordsep#*
\glsxtrforcsvfield{gls-label%special}{field}{handler}#*
\glsxtrendfor#*
\glsxtrfieldformatcsvlist{gls-label%special}{field}#*
\GlsXtrIfValueInFieldCsvList{gls-label%special}{field}{value}{true}{false}#*
\GlsXtrIfFieldValueInCsvList{gls-label%special}{field}{list}{true}{false}#*
\xGlsXtrIfValueInFieldCsvList{gls-label%special}{field}{value}{true}{false}#*

## List Fields ##
\glsxtrfieldformatlist{gls-label%special}{field}#*
\glsxtrfielddolistloop{gls-label%special}{field}#*
\glsxtrfieldforlistloop{gls-label%special}{field}{handler}#*
\glsxtrfieldifinlist{gls-label%special}{field}{item}{true}{false}#*
\glsxtrfieldxifinlist{gls-label%special}{field}{item}{true}{false}#*

## Field Conditionals ##
\GlsXtrIfFieldUndef{field}{gls-label%special}{true}{false}#*
\glsxtrifhasfield{field}{gls-label%special}{true}{false}#*
\glsxtrifhasfield*{field}{gls-label%special}{true}{false}#*
\GlsXtrIfFieldCmpNum{field}{gls-label%special}{comparison}{integer}{true}{false}#*
\GlsXtrIfFieldCmpNum*{field}{gls-label%special}{comparison}{integer}{true}{false}#*
\GlsXtrIfFieldEqNum{field}{gls-label%special}{integer}{true}{false}#*
\GlsXtrIfFieldEqNum*{field}{gls-label%special}{integer}{true}{false}#*
\GlsXtrIfFieldNonZero{field}{gls-label%special}{true}{false}#*
\GlsXtrIfFieldNonZero*{field}{gls-label%special}{true}{false}#*
\GlsXtrIfFieldEqStr{field}{gls-label%special}{text}{true}{false}#*
\GlsXtrIfFieldEqStr*{field}{gls-label%special}{text}{true}{false}#*
\GlsXtrIfFieldEqXpStr{field}{gls-label%special}{text}{true}{false}#*
\GlsXtrIfFieldEqXpStr*{field}{gls-label%special}{text}{true}{false}#*
\GlsXtrIfXpFieldEqXpStr{field}{gls-label%special}{text}{true}{false}#*
\GlsXtrIfXpFieldEqXpStr*{field}{gls-label%special}{text}{true}{false}#*

## LaTeX3 Commands ##
\glossaries_if_field_exists:nnTF {%<⟨entry label⟩%>} {%<⟨field label⟩%>} {%<⟨true code⟩%>} {%<⟨false code⟩%>}#/%expl3
\glossaries_if_field_exists:nnT {%<⟨entry label⟩%>} {%<⟨field label⟩%>} {%<⟨true code⟩%>}#/%expl3
\glossaries_if_field_exists:nnF {%<⟨entry label⟩%>} {%<⟨field label⟩%>} {%<⟨false code⟩%>}#/%expl3
\glossaries_if_field_exists_p:nn {%<⟨entry label⟩%>} {%<⟨field label⟩%>}#/%expl3
\glossaries_if_field_set:nnTF {%<⟨entry label⟩%>} {%<⟨field label⟩%>} {%<⟨true code⟩%>} {%<⟨false code⟩%>}#/%expl3
\glossaries_if_field_set:nnT {%<⟨entry label⟩%>} {%<⟨field label⟩%>} {%<⟨true code⟩%>}#/%expl3
\glossaries_if_field_set:nnF {%<⟨entry label⟩%>} {%<⟨field label⟩%>} {%<⟨false code⟩%>}#/%expl3
\glossaries_if_field_set_p:nn {%<⟨entry label⟩%>} {%<⟨field label⟩%>}#/%expl3
\glossaries_if_field_eq:nnNTF {%<⟨entry label⟩%>} {%<⟨field label⟩%>} %<⟨tl var⟩%> {%<⟨true code⟩%>} {%<⟨false code⟩%>}#/%expl3
\glossaries_if_field_eq:nnNT {%<⟨entry label⟩%>} {%<⟨field label⟩%>} %<⟨tl var⟩%> {%<⟨true code⟩%>}#/%expl3
\glossaries_if_field_eq:nnNF {%<⟨entry label⟩%>} {%<⟨field label⟩%>} %<⟨tl var⟩%> {%<⟨false code⟩%>}#/%expl3
\glossaries_if_field_eq_p:nnN {%<⟨entry label⟩%>} {%<⟨field label⟩%>} %<⟨tl var⟩%>#/%expl3
\glossaries_if_field_eq:nnnTF {%<⟨entry label⟩%>} {%<⟨field label⟩%>} {%<⟨tokens⟩%>} {%<⟨true code⟩%>} {%<⟨false code⟩%>}#/%expl3
\glossaries_if_field_eq:nnnT {%<⟨entry label⟩%>} {%<⟨field label⟩%>} {%<⟨tokens⟩%>} {%<⟨true code⟩%>}#/%expl3
\glossaries_if_field_eq:nnnF {%<⟨entry label⟩%>} {%<⟨field label⟩%>} {%<⟨tokens⟩%>} {%<⟨false code⟩%>}#/%expl3
\glossaries_if_field_eq_field:nnnTF {%<⟨entry label⟩%>} {%<⟨field1 label⟩%>} {%<⟨field2 label⟩%>} {%<⟨true code⟩%>} {%<⟨false code⟩%>}#/%expl3
\glossaries_if_field_eq_field:nnnT {%<⟨entry label⟩%>} {%<⟨field1 label⟩%>} {%<⟨field2 label⟩%>} {%<⟨true code⟩%>}#/%expl3
\glossaries_if_field_eq_field:nnnF {%<⟨entry label⟩%>} {%<⟨field1 label⟩%>} {%<⟨field2 label⟩%>} {%<⟨false code⟩%>}#/%expl3
\glossaries_if_field_eq_field_p:nnn {%<⟨entry label⟩%>} {%<⟨field1 label⟩%>} {%<⟨field2 label⟩%>}#/%expl3
\glossaries_if_field_eq_field:nnnnTF {%<⟨entry1 label⟩%>} {%<⟨field1 label⟩%>} {%<⟨entry2 label⟩%>} {%<⟨field2 label⟩%>} {%<⟨true code⟩%>} {%<⟨false code⟩%>}#/%expl3
\glossaries_if_field_eq_field:nnnnT {%<⟨entry1 label⟩%>} {%<⟨field1 label⟩%>} {%<⟨entry2 label⟩%>} {%<⟨field2 label⟩%>} {%<⟨true code⟩%>}#/%expl3
\glossaries_if_field_eq_field:nnnnF {%<⟨entry1 label⟩%>} {%<⟨field1 label⟩%>} {%<⟨entry2 label⟩%>} {%<⟨field2 label⟩%>} {%<⟨false code⟩%>}#/%expl3
\glossaries_if_field_eq_field_p:nnnn {%<⟨entry1 label⟩%>} {%<⟨field1 label⟩%>} {%<⟨entry2 label⟩%>} {%<⟨field2 label⟩%>}#/%expl3
\glossaries_use_field:nn {%<⟨entry label⟩%>} {%<⟨field label⟩%>}#/%expl3

### 6 Counting References ###
\GlsXtrEnableEntryCounting{category-list}{value}#*
\cGLS{gls-label%special}#*
\cGLS[options%keyvals]{gls-label%special}#*
\cGLS{gls-label%special}[insert]#*
\cGLS[options%keyvals]{gls-label%special}[insert]#*
\cGLS*{gls-label%special}#S
\cGLS*[options%keyvals]{gls-label%special}#S
\cGLS*{gls-label%special}[insert]#S
\cGLS*[options%keyvals]{gls-label%special}[insert]#S
\cGLS+{gls-label%special}#S
\cGLS+[options%keyvals]{gls-label%special}#S
\cGLS+{gls-label%special}[insert]#S
\cGLS+[options%keyvals]{gls-label%special}[insert]#S
\cGLSpl{gls-label%special}#*
\cGLSpl[options%keyvals]{gls-label%special}#*
\cGLSpl{gls-label%special}[insert]#*
\cGLSpl[options%keyvals]{gls-label%special}[insert]#*
\cGLSpl*{gls-label%special}#S
\cGLSpl*[options%keyvals]{gls-label%special}#S
\cGLSpl*{gls-label%special}[insert]#S
\cGLSpl*[options%keyvals]{gls-label%special}[insert]#S
\cGLSpl+{gls-label%special}#S
\cGLSpl+[options%keyvals]{gls-label%special}#S
\cGLSpl+{gls-label%special}[insert]#S
\cGLSpl+[options%keyvals]{gls-label%special}[insert]#S
\cGLSformat{gls-label%special}{insert}#*
\cGLSplformat{gls-label%special}{insert}#*
\glsxtrifcounttrigger{gls-label%special}{true}{false}#*
\glsenableentryunitcount#*
\GlsXtrEnableEntryUnitCounting{category-list}{value}{counter}#*
\glsentryprevtotalcount{gls-label%special}#*
\glsentryprevmaxcount{gls-label%special}#*

## Link Counting ##
\GlsXtrEnableLinkCounting{categories}#*
\GlsXtrEnableLinkCounting[parent-counter]{categories}#*
\glsxtrinclinkcounter{counter}#*
\GlsXtrLinkCounterValue{gls-label%special}#*
\GlsXtrTheLinkCounter{counter}#*
\GlsXtrIfLinkCounterDef{gls-label%special}{true}{false}#*
\GlsXtrLinkCounterName{gls-label%special}#*

### 7 Multi (or Compound) Entries ###
\multiglossaryentry{multi-label}{gls-labels}
\multiglossaryentry{multi-label}[main-label]{gls-labels}
\multiglossaryentry[options%keyvals]{multi-label}{gls-labels}
\multiglossaryentry[options%keyvals]{multi-label}[main-label]{gls-labels}
\mgls{multi-label}
\mgls[options%keyvals]{multi-label}
\mgls{multi-label}[insert]#*
\mgls[options%keyvals]{multi-label}[insert]#*
\mgls*{multi-label}#S
\mgls*[options%keyvals]{multi-label}#S
\mgls*{multi-label}[insert]#S
\mgls*[options%keyvals]{multi-label}[insert]#S
\mgls+{multi-label}#S
\mgls+[options%keyvals]{multi-label}#S
\mgls+{multi-label}[insert]#S
\mgls+[options%keyvals]{multi-label}[insert]#S
\providemultiglossaryentry{multi-label}{gls-labels}
\providemultiglossaryentry{multi-label}[main label]{gls-labels}
\providemultiglossaryentry[options%keyvals]{multi-label}{gls-labels}
\providemultiglossaryentry[options%keyvals]{multi-label}[main label]{gls-labels}
\multiglossaryentryglobaltrue
\multiglossaryentryglobalfalse
\ifmultiglossaryentryglobal#*
\mglsSetOptions{multi-label}{options%keyvals}
\mglsAddOptions{multi-label}{options%keyvals}
\GlsXtrMglsOrGls{mgls-cmd}{gls-cmd}{gls-label}#*
\GlsXtrMglsOrGls{mgls-cmd}{gls-cmd}[options%keyvals]{gls-label}#*
\GlsXtrMglsOrGls{mgls-cmd}{gls-cmd}[options%keyvals]{gls-label}[insert]#*

## Prefixes and Suffixes ##
\mglsprefix#*
\mglssuffix#*
\mglsdefcategoryprefix{category}{definition}#*
\mglsdefcategorysuffix{category}{definition}#*
\mglshascategoryprefix{category}{true}{false}#*
\mglsusecategoryprefix{category}#*
\mglshascategorysuffix{category}{true}{false}#*
\mglsusecategorysuffix{category}#*

## Separators ##
\glscombinedsep{gls-label%special}{gls-label%special}#*
\glscombinedfirstsep{gls-label%special}{gls-label%special}#*
\glscombinedsepfirst{gls-label%special}{gls-label%special}#*
\glscombinedfirstsepfirst{gls-label%special}{gls-label%special}#*
\glssetcombinedsepabbrvnbsp#*
\glssetcombinedsepabbrvnone#*
\glssetcombinedsepnarrow{width}{narrow sep%l}#*

## \mgls Element Hooks ##
\mglselementprehook#*
\mglselementposthook#*
\mglscurrentmultilabel#*
\mglscurrentmainlabel#*
\mglscurrentlist#*
\mglscurrentoptions#*
\mglscurrentcategory#*
\glsxtrcurrentmglscsname#*
\mglsisfirstuse{true}{false}#*
\mglscurrentlabel#*
\mglselementindex#*
\mglscurrentprefix#*
\mglscurrentsuffix#*
\mglsiflast{true}{false}#*

## Post-Link Hook ##
\mglscustompostlinkhook#*
\mglslastelementpostlinkhook#*
\mglslastmainpostlinkhook#*
\mglslastmultilabel#*
\mglslastcategory#*
\mglswasfirstuse{true}{false}#*
\mglslastelementlabel#*
\mglsiflastelementskipped{true}{false}#*
\mglsiflastelementwasfirstuse{true}{false}#*
\mglsiflastelementwasplural{true}{false}#*
\mglsiflastelementcapscase{no-change}{firstuc}{all caps}#*
\mglslastmainlabel#*
\mglsiflastmainskipped{true}{false}#*
\mglsiflastmainwasfirstuse{true}{false}#*
\mglsiflastmainwasplural{true}{false}#*
\mglsiflastmaincapscase{no-change}{firstuc}{all caps}#*

## Multi-Entry First Use ##
\ifmglsused{multi-label}{true}{false}#*
\mglsunset{multi-label}#*
\mglsreset{multi-label}#*
\mglslocalunset{multi-label}#*
\mglslocalreset{multi-label}#*
\mglsunsetall#*
\mglsresetall#*

## Multi-Entry Settings ##
\multiglossaryentrysetup{options%keyvals}

#keyvals:\multiglossaryentry#c,\providemultiglossaryentry#c,\multiglossaryentrysetup#c
indexmain=#false,true,first
indexothers=#false,true,first
encapmain=%<csname%>
encapothers=%<csname%>
postlinks=#none,all,notlast,mainnotlast,mainonly,othernotlast,otheronly
mpostlink=#false,true,firstonly,usedonly
mpostlinkelement=#last,main,custom
firstprefix=%<prefix%>
usedprefix=%<prefix%>
firstsuffix=%<suffix%>
usedsuffix=%<suffix%>
firstskipmain#true,false
firstskipothers#true,false
usedskipmain#true,false
usedskipothers#true,false
hyper=#none,allmain,mainonly,individual,otheronly,notmainfirst,nototherfirst,notfirst
textformat=%<csname%>
category=%<category%>
mglsopts={%<mgls options%>}
#endkeyvals

\glsxtrmglsWarnAllSkipped{message%text}{insert}{fmt-cs}#*

## \mgls Options ##
#keyvals:\mgls#c,\mgls*#c,\mgls+#c,\Mgls#c,\Mgls*#c,\Mgls+#c,\MGls#c,\MGls*#c,\MGls+#c,\MGLS#c,\MGLS*#c,\MGLS+#c,\mglspl#c,\mglspl*#c,\mglspl+#c,\Mglspl#c,\Mglspl*#c,\Mglspl+#c,\MGlspl#c,\MGlspl*#c,\MGlspl+#c,\MGLSpl#c,\MGLSpl*#c,\MGLSpl+#c,\mglsname#c,\mglsname*#c,\mglsname+#c,\Mglsname#c,\Mglsname*#c,\Mglsname+#c,\MGlsname#c,\MGlsname*#c,\MGlsname+#c,\MGLSname#c,\MGLSname*#c,\MGLSname+#c,\mglsmainpl#c,\mglsmainpl*#c,\mglsmainpl+#c,\Mglsmainpl#c,\Mglsmainpl*#c,\Mglsmainpl+#c,\MGlsmainpl#c,\MGlsmainpl*#c,\MGlsmainpl+#c,\MGLSmainpl#c,\MGLSmainpl*#c,\MGLSmainpl+#c,\mglsshort#c,\mglsshort*#c,\mglsshort+#c,\Mglsshort#c,\Mglsshort*#c,\Mglsshort+#c,\MGlsshort#c,\MGlsshort*#c,\MGlsshort+#c,\MGLSshort#c,\MGLSshort*#c,\MGLSshort+#c,\mglslong#c,\mglslong*#c,\mglslong+#c,\Mglslong#c,\Mglslong*#c,\Mglslong+#c,\MGlslong#c,\MGlslong*#c,\MGlslong+#c,\MGLSlong#c,\MGLSlong*#c,\MGLSlong+#c,\mglsfull#c,\mglsfull*#c,\mglsfull+#c,\Mglsfull#c,\Mglsfull*#c,\Mglsfull+#c,\MGlsfull#c,\MGlsfull*#c,\MGlsfull+#c,\MGLSfull#c,\MGLSfull*#c,\MGLSfull+#c,\mglssymbol#c,\mglssymbol*#c,\mglssymbol+#c,\Mglssymbol#c,\Mglssymbol*#c,\Mglssymbol+#c,\MGlssymbol#c,\MGlssymbol*#c,\MGlssymbol+#c,\MGLSsymbol#c,\MGLSsymbol*#c,\MGLSsymbol+#c,\mglsusefield#c,\mglsusefield*#c,\mglsusefield+#c,\Mglsusefield#c,\Mglsusefield*#c,\Mglsusefield+#c,\MGlsusefield#c,\MGlsusefield*#c,\MGlsusefield+#c,\MGLSusefield#c,\MGLSusefield*#c,\MGLSusefield+#c,\mpgls#c,\mpglspl#c,\mpglsmainpl#c,\Mpgls#c,\Mpglspl#c,\Mpglsmainpl#c,\MPGls#c,\MPGlspl#c,\MPGlsmainpl#c,\MPGLS#c,\MPGLSpl#c,\MPGLSmainpl#c,\mglsSetOptions#c,\mglsAddOptions#c,\GlsXtrMglsOrGls#c
setup={%<options%>}
all={%<gls options%>}
main={%<gls options%>}
others={%<gls options%>}
hyper#true,false
multiunset=#global,local,none
presetlocal#true,false
resetall#true,false
resetmain#true,false
resetothers#true,false
unsetall#true,false
unsetmain#true,false
unsetothers#true,false
#endkeyvals

\mglselementreset{gls-label%special}#*
\mglselementunset{gls-label%special}#*
\mglsunsetothers{multi-label}
\mglslocalunsetothers{multi-label}

## Variants of \mgls ##
\mglspl{multi-label}
\mglspl[options%keyvals]{multi-label}
\mglspl{multi-label}[insert]#*
\mglspl[options%keyvals]{multi-label}[insert]#*
\mglsmainpl{multi-label}
\mglsmainpl[options%keyvals]{multi-label}
\mglsmainpl{multi-label}[insert]#*
\mglsmainpl[options%keyvals]{multi-label}[insert]#*
\Mgls{multi-label}
\Mgls[options%keyvals]{multi-label}
\Mgls{multi-label}[insert]#*
\Mgls[options%keyvals]{multi-label}[insert]#*
\MGls{multi-label}
\MGls[options%keyvals]{multi-label}
\MGls{multi-label}[insert]#*
\MGls[options%keyvals]{multi-label}[insert]#*
\Mglspl{multi-label}
\Mglspl[options%keyvals]{multi-label}
\Mglspl{multi-label}[insert]#*
\Mglspl[options%keyvals]{multi-label}[insert]#*
\Mglsmainpl{multi-label}
\Mglsmainpl[options%keyvals]{multi-label}
\Mglsmainpl{multi-label}[insert]#*
\Mglsmainpl[options%keyvals]{multi-label}[insert]#*
\MGlspl{multi-label}
\MGlspl[options%keyvals]{multi-label}
\MGlspl{multi-label}[insert]#*
\MGlspl[options%keyvals]{multi-label}[insert]#*
\MGlsmainpl{multi-label}
\MGlsmainpl[options%keyvals]{multi-label}
\MGlsmainpl{multi-label}[insert]#*
\MGlsmainpl[options%keyvals]{multi-label}[insert]#*
\MGLS{multi-label}
\MGLS[options%keyvals]{multi-label}
\MGLS{multi-label}[insert]#*
\MGLS[options%keyvals]{multi-label}[insert]#*
\MGLSpl{multi-label}
\MGLSpl[options%keyvals]{multi-label}
\MGLSpl{multi-label}[insert]#*
\MGLSpl[options%keyvals]{multi-label}[insert]#*
\MGLSmainpl{multi-label}
\MGLSmainpl[options%keyvals]{multi-label}
\MGLSmainpl{multi-label}[insert]#*
\MGLSmainpl[options%keyvals]{multi-label}[insert]#*
\mglsshort{multi-label}
\mglsshort[options%keyvals]{multi-label}
\mglsshort{multi-label}[insert]#*
\mglsshort[options%keyvals]{multi-label}[insert]#*
\mglslong{multi-label}
\mglslong[options%keyvals]{multi-label}
\mglslong{multi-label}[insert]#*
\mglslong[options%keyvals]{multi-label}[insert]#*
\mglsfull{multi-label}
\mglsfull[options%keyvals]{multi-label}
\mglsfull{multi-label}[insert]#*
\mglsfull[options%keyvals]{multi-label}[insert]#*
\Mglsshort{multi-label}
\Mglsshort[options%keyvals]{multi-label}
\Mglsshort{multi-label}[insert]#*
\Mglsshort[options%keyvals]{multi-label}[insert]#*
\Mglslong{multi-label}
\Mglslong[options%keyvals]{multi-label}
\Mglslong{multi-label}[insert]#*
\Mglslong[options%keyvals]{multi-label}[insert]#*
\Mglsfull{multi-label}
\Mglsfull[options%keyvals]{multi-label}
\Mglsfull{multi-label}[insert]#*
\Mglsfull[options%keyvals]{multi-label}[insert]#*
\mglsname{multi-label}#*
\mglsname[options%keyvals]{multi-label}#*
\mglsname{multi-label}[insert]#*
\mglsname[options%keyvals]{multi-label}[insert]#*
\mglssymbol{multi-label}#*
\mglssymbol[options%keyvals]{multi-label}#*
\mglssymbol{multi-label}[insert]#*
\mglssymbol[options%keyvals]{multi-label}[insert]#*
\mglsusefield{multi-label}#*
\mglsusefield[options%keyvals]{multi-label}#*
\mglsusefield{multi-label}[insert]#*
\mglsusefield[options%keyvals]{multi-label}[insert]#*
\Mglsname{multi-label}#*
\Mglsname[options%keyvals]{multi-label}#*
\Mglsname{multi-label}[insert]#*
\Mglsname[options%keyvals]{multi-label}[insert]#*
\Mglssymbol{multi-label}#*
\Mglssymbol[options%keyvals]{multi-label}#*
\Mglssymbol{multi-label}[insert]#*
\Mglssymbol[options%keyvals]{multi-label}[insert]#*
\Mglsusefield{multi-label}#*
\Mglsusefield[options%keyvals]{multi-label}#*
\Mglsusefield{multi-label}[insert]#*
\Mglsusefield[options%keyvals]{multi-label}[insert]#*
\MGlsname{multi-label}#*
\MGlsname[options%keyvals]{multi-label}#*
\MGlsname{multi-label}[insert]#*
\MGlsname[options%keyvals]{multi-label}[insert]#*
\MGlssymbol{multi-label}#*
\MGlssymbol[options%keyvals]{multi-label}#*
\MGlssymbol{multi-label}[insert]#*
\MGlssymbol[options%keyvals]{multi-label}[insert]#*
\MGlsusefield{multi-label}#*
\MGlsusefield[options%keyvals]{multi-label}#*
\MGlsusefield{multi-label}[insert]#*
\MGlsusefield[options%keyvals]{multi-label}[insert]#*
\mglsfield#*
\mpglsWarning#*

## Cross-References ##
\mglsseefirstitem{multi-label}#*
\mglsseeitem{multi-label}#*

## Additional Commands ##
\glsxtrifmulti{multi-label}{true}{false}#*
\glsxtrmultimain{multi-label}#*
\glsxtrmultilist{multi-label}#*
\mglsforelements{multi-label}{cmd}{body}#*
\mglsforotherelements{multi-label}{cmd}{body}#*
\glsxtrmultitotalelements{multi-label}#*
\glsxtrmultimainindex{multi-label}#*
\glsxtrmultilastotherindex{multi-label}#*
\writemultiglossentry{options}{multi-label}{main-label}{list}#*

## bib2gls ##
# see glossaries-extra-bib2gls.cwl

### 8 Defining and Displaying Glossaries ###
\makeglossaries[types]
\newignoredglossary*{name}#*
\provideignoredglossary{name}#*
\glsxtrcopytoglossary{gls-label%special}{glossary-type}
\glsxtrcopytoglossary*{gls-label%special}{glossary-type}#*
\forallabbreviationlists{cmd}{body}#*

## Entry Page Reference ##
\glsxtrpageref{gls-label%special}

## Glossary Preamble ##
\apptoglossarypreamble{text}#*
\apptoglossarypreamble[type]{text}#*
\pretoglossarypreamble{text}#*
\pretoglossarypreamble[type]{text}#*

## Options ##
# options provided by glossaries.sty
#keyvals:\printabbreviations#c,\printunsrtabbreviations#c,\printunsrtsymbols#c,\printunsrtnumbers#c,\printunsrtindex#c,\printunsrtacronyms#c,\printunsrtglossary#c,\printunsrtglossary*#c,\begin{printunsrtglossarywrap}#c,\printunsrtglossaryunit#c
type=%<glossary-label%>
title=%<text%>
toctitle=%<text%>
style=%<style-name%>
numberedsection=#false,nolabel,autolabel
nonumberlist#true,false
nogroupskip#true,false
nopostdot#true,false
entrycounter#true,false
subentrycounter#true,false
sort=#use,def,nocase,case,word,letter,standard
#endkeyvals

# options provided by glossaries-extra.sty
#keyvals:\printnoidxglossary#c,\printglossary#c,\printsymbols#c,\printnumbers#c,\printindex#c,\printacronyms#c,\printabbreviations#c,\printunsrtabbreviations#c,\printunsrtsymbols#c,\printunsrtnumbers#c,\printunsrtindex#c,\printunsrtacronyms#c,\printunsrtglossary#c,\printunsrtglossary*#c,\begin{printunsrtglossarywrap}#c,\printunsrtglossaryunit#c
label=##l
prefix=%<prefix%>
targetnameprefix=%<prefix%>
target#true,false
preamble=%<text%>
postamble=%<text%>
#endkeyvals

# "unsrt"-only options
#keyvals:\printunsrtabbreviations#c,\printunsrtsymbols#c,\printunsrtnumbers#c,\printunsrtindex#c,\printunsrtacronyms#c,\printunsrtglossary#c,\printunsrtglossary*#c,\begin{printunsrtglossarywrap}#c,\printunsrtglossaryunit#c
leveloffset=%<<n> or ++<n>%>
flatten#true,false
groups#true,false
#endkeyvals

\glsxtrsetglossarylabel{gls-label%specialDef}#*s#%gls-label

## Displaying a Glossary Without Sorting or Indexing ##
\printunsrtglossary
\printunsrtglossary[options%keyvals]
\printunsrtglossary*{init-code}
\printunsrtglossary*[options%keyvals]{init-code}
\printunsrtglossaries
\glsxtrnoidxgroups#*
\glsxtrgroupfield#*
\glsxtraddgroup{gls-label}{code}#*
\printunsrtglossarygrouphook{internal cs}#*
\glssubgroupheading{prev-level}{level}{parent-label}{group-label}#*
\GlsXtrLocationField#*
\printunsrtglossarypostbegin{internal cs}#*
\printunsrtglossarypreend{internal cs}#*
\glscurrententrylevel#*
\glscurrenttoplevelentry#*
\glscurrentrootentry#*
\printunsrtglossaryentryprocesshook{gls-label}#*
\printunsrtglossaryskipentry#*
\printunsrtglossarypreentryprocesshook{internal cs}#*
\printunsrtglossarypostentryprocesshook{internal cs}#*
\printunsrtglossarypredoglossary#*
\printunsrtglossaryhandler{gls-label%special}#*
\glsxtrunsrtdo{gls-label%special}#*
\glsxtriflabelinlist{gls-label%special}{gls-labels}{true}{false}#*
\ifglsxtrprintglossflatten#*
\glsxtrprintglossflattentrue#*
\glsxtrprintglossflattenfalse#*

\printunsrtinnerglossary{pre-code}{post-code}
\printunsrtinnerglossary[options%keyvals]{pre-code}{post-code}

# can only use specific keys, hence separate listing here
#keyvals:\printunsrtinnerglossary#c
type=%<glossary-label%>
nonumberlist#true,false
nogroupskip#true,false
nopostdot#true,false
entrycounter#true,false
subentrycounter#true,false
target#true,false
targetnameprefix=%<prefix%>
prefix=%<prefix%>
groups#true,false
leveloffset=%<<n> or ++<n>%>
#endkeyvals

\begin{printunsrtglossarywrap}
\begin{printunsrtglossarywrap}[options%keyvals]
\end{printunsrtglossarywrap}
\GlsXtrRecordCounter{counter}#*
\glsxtrAddCounterRecordHook{gls-label}{counter}{value}#*
\printunsrtglossaryunit{counter}#*
\printunsrtglossaryunit[options%keyvals]{counter}#*
\printunsrtglossaryunitsetup{counter}#*
\printunsrtglossaryunitpostskip#*

## Standalone Entry Items ##
\glsxtrglossentry{gls-label%special}#*
\Glsxtrglossentry{gls-label%special}#*
\GlsXtrStandaloneGlossaryType#*
\GlsXtrStandaloneSubEntryItem{gls-label%special}#*
\GlsXtrStandaloneEntryName{gls-label%special}#*
\GlsXtrStandaloneEntryNameFirstUc{gls-label%special}#*
\glsxtractivatenopost#*
\glsxtrglossentryother{header}{gls-label%special}{field}#*
\Glsxtrglossentryother{header}{gls-label%special}{field}#*
\GlsXtrStandaloneEntryOther{gls-label%special}{field}#*
\GlsXtrStandaloneEntryOtherFirstUc{gls-label%special}{field}#*
\GlsXtrStandaloneEntryPdfName{gls-label%special}#*
\GlsXtrStandaloneEntryHeadName{gls-label%special}#*
\GlsXtrStandaloneEntryPdfNameFirstUc{gls-label%special}#*
\GlsXtrStandaloneEntryHeadNameFirstUc{gls-label%special}#*
\GlsXtrStandaloneEntryPdfOther{gls-label%special}{field}#*
\GlsXtrStandaloneEntryHeadOther{gls-label%special}{field}#*
\GlsXtrStandaloneEntryPdfOtherFirstUc{gls-label%special}{field}#*
\GlsXtrStandaloneEntryHeadOtherFirstUc{gls-label%special}{field}#*

## Glossary Style Modifications ##
\glsxtrpreglossarystyle#*
\glsentrypdfsymbol{gls-label%special}#*
\glossentrynameother{gls-label%special}{field}#*
\Glossentrynameother{gls-label%special}{field}#*
\GLOSSentrynameother{gls-label%special}{field}#*
\GlossEntryNameOther{gls-label%special}{field}#*
\glsxtrprenamehook{gls-label%special}#*
\glsxtrpostnamehook{gls-label%special}#*
\glsdefpostname{category}{definition}#*
\glsextrapostnamehook{gls-label%special}#*
\glsxtrpostdescription#*
\glsxtrpostdescgeneral#*
\glsxtrpostdescterm#*
\glsxtrpostdescacronym#*
\glsxtrpostdescabbreviation#*
\glsdefpostdesc{category}{definition}#*
\glsxtrnopostpunc#*
\glsxtrrestorepostpunc#*
\GlsXtrFormatLocationList{location list}#*
\GlsXtrEnablePreLocationTag{page tag}{pages tag}#*
\glsxtrdisplaysingleloc{format}{location}#*
\glsxtrdisplaystartloc{format}{location}#*
\glsxtrdisplayendloc{format}{location}#*
\glsxtrlocrangefmt#*
\glsxtrdisplayendlochook{format}{location}#*
\glsxtrsetgrouptitle{group-label}{group-title%text}#*
\glsxtrlocalsetgrouptitle{group-label}{group-title%text}#*
\glsxtrgetgrouptitle{group-label}{cmd}#*d

## New Glossary Styles ##
#keyvals:\setglossarystyle#c
abbr-long-short
abbr-short-long
bookindex
long-custom1-name
long-custom2-name
long-custom3-name
long-desc-custom1-name
long-desc-custom2-name
long-desc-custom3-name
long-desc-name
long-desc-sym-name
long-desc-sym
long-loc-desc-name
long-loc-desc-sym-name
long-loc-sym-desc-name
long-name-custom1
long-name-custom1-desc
long-name-custom2
long-name-custom2-desc
long-name-custom3
long-name-custom3-desc
long-name-desc-loc
long-name-desc-sym-loc
long-name-desc-sym
long-name-desc
long-name-sym-desc-loc
long-name-sym-desc
long-sym-desc-name
long-sym-desc
table
topic
topicmcols
#endkeyvals

### 9 Accessibility Support ###
## Abbreviations ##
\glsxtrassignactualsetup#*
\glsdefaultshortaccess{long}{short}#*

## Accessibility Wrappers ##
\glsaccessname{gls-label%special}#*
\Glsaccessname{gls-label%special}#*
\GLSaccessname{gls-label%special}#*
\glsaccesstext{gls-label%special}#*
\Glsaccesstext{gls-label%special}#*
\GLSaccesstext{gls-label%special}#*
\GLSaccessplural{gls-label%special}#*
\glsaccessplural{gls-label%special}#*
\Glsaccessplural{gls-label%special}#*
\glsaccessfirst{gls-label%special}#*
\Glsaccessfirst{gls-label%special}#*
\GLSaccessfirst{gls-label%special}#*
\glsaccessfirstplural{gls-label%special}#*
\Glsaccessfirstplural{gls-label%special}#*
\GLSaccessfirstplural{gls-label%special}#*
\glsaccesssymbol{gls-label%special}#*
\Glsaccesssymbol{gls-label%special}#*
\GLSaccesssymbol{gls-label%special}#*
\glsaccesssymbolplural{gls-label%special}#*
\Glsaccesssymbolplural{gls-label%special}#*
\GLSaccesssymbolplural{gls-label%special}#*
\glsaccessdesc{gls-label%special}#*
\Glsaccessdesc{gls-label%special}#*
\GLSaccessdesc{gls-label%special}#*
\glsaccessdescplural{gls-label%special}#*
\Glsaccessdescplural{gls-label%special}#*
\GLSaccessdescplural{gls-label%special}#*
\glsaccessshort{gls-label%special}#*
\Glsaccessshort{gls-label%special}#*
\GLSaccessshort{gls-label%special}#*
\glsaccessshortpl{gls-label%special}#*
\Glsaccessshortpl{gls-label%special}#*
\GLSaccessshortpl{gls-label%special}#*
\glsaccesslong{gls-label%special}#*
\Glsaccesslong{gls-label%special}#*
\GLSaccesslong{gls-label%special}#*
\glsaccesslongpl{gls-label%special}#*
\Glsaccesslongpl{gls-label%special}#*
\GLSaccesslongpl{gls-label%special}#*
\glsaccessuseri{gls-label%special}#*
\Glsaccessuseri{gls-label%special}#*
\GLSaccessuseri{gls-label%special}#*
\glsaccessuserii{gls-label%special}#*
\Glsaccessuserii{gls-label%special}#*
\GLSaccessuserii{gls-label%special}#*
\glsaccessuseriii{gls-label%special}#*
\Glsaccessuseriii{gls-label%special}#*
\GLSaccessuseriii{gls-label%special}#*
\glsaccessuseriv{gls-label%special}#*
\Glsaccessuseriv{gls-label%special}#*
\GLSaccessuseriv{gls-label%special}#*
\glsaccessuserv{gls-label%special}#*
\Glsaccessuserv{gls-label%special}#*
\GLSaccessuserv{gls-label%special}#*
\glsaccessuservi{gls-label%special}#*
\Glsaccessuservi{gls-label%special}#*
\GLSaccessuservi{gls-label%special}#*

## Inner Formatting Wrappers ##
\glsaccessfmtname{insert}{cmd}{gls-label}#*
\Glsaccessfmtname{insert}{cmd}{gls-label}#*
\GLSaccessfmtname{insert}{cmd}{gls-label}#*
\glsaccessfmttext{insert}{cmd}{gls-label}#*
\Glsaccessfmttext{insert}{cmd}{gls-label}#*
\GLSaccessfmttext{insert}{cmd}{gls-label}#*
\glsaccessfmtplural{insert}{cmd}{gls-label}#*
\Glsaccessfmtplural{insert}{cmd}{gls-label}#*
\GLSaccessfmtplural{insert}{cmd}{gls-label}#*
\glsaccessfmtfirst{insert}{cmd}{gls-label}#*
\Glsaccessfmtfirst{insert}{cmd}{gls-label}#*
\GLSaccessfmtfirst{insert}{cmd}{gls-label}#*
\glsaccessfmtfirstplural{insert}{cmd}{gls-label}#*
\Glsaccessfmtfirstplural{insert}{cmd}{gls-label}#*
\GLSaccessfmtfirstplural{insert}{cmd}{gls-label}#*
\glsaccessfmtsymbol{insert}{cmd}{gls-label}#*
\Glsaccessfmtsymbol{insert}{cmd}{gls-label}#*
\GLSaccessfmtsymbol{insert}{cmd}{gls-label}#*
\glsaccessfmtsymbolplural{insert}{cmd}{gls-label}#*
\Glsaccessfmtsymbolplural{insert}{cmd}{gls-label}#*
\GLSaccessfmtsymbolplural{insert}{cmd}{gls-label}#*
\glsaccessfmtdesc{insert}{cmd}{gls-label}#*
\Glsaccessfmtdesc{insert}{cmd}{gls-label}#*
\GLSaccessfmtdesc{insert}{cmd}{gls-label}#*
\glsaccessfmtdescplural{insert}{cmd}{gls-label}#*
\Glsaccessfmtdescplural{insert}{cmd}{gls-label}#*
\GLSaccessfmtdescplural{insert}{cmd}{gls-label}#*
\glsaccessfmtshort{insert}{cmd}{gls-label}#*
\Glsaccessfmtshort{insert}{cmd}{gls-label}#*
\GLSaccessfmtshort{insert}{cmd}{gls-label}#*
\glsaccessfmtshortpl{insert}{cmd}{gls-label}#*
\Glsaccessfmtshortpl{insert}{cmd}{gls-label}#*
\GLSaccessfmtshortpl{insert}{cmd}{gls-label}#*
\glsaccessfmtlong{insert}{cmd}{gls-label}#*
\Glsaccessfmtlong{insert}{cmd}{gls-label}#*
\GLSaccessfmtlong{insert}{cmd}{gls-label}#*
\glsaccessfmtlongpl{insert}{cmd}{gls-label}#*
\Glsaccessfmtlongpl{insert}{cmd}{gls-label}#*
\GLSaccessfmtlongpl{insert}{cmd}{gls-label}#*
\glsaccessfmtuseri{insert}{cmd}{gls-label}#*
\Glsaccessfmtuseri{insert}{cmd}{gls-label}#*
\GLSaccessfmtuseri{insert}{cmd}{gls-label}#*
\glsaccessfmtuserii{insert}{cmd}{gls-label}#*
\Glsaccessfmtuserii{insert}{cmd}{gls-label}#*
\GLSaccessfmtuserii{insert}{cmd}{gls-label}#*
\glsaccessfmtuseriii{insert}{cmd}{gls-label}#*
\Glsaccessfmtuseriii{insert}{cmd}{gls-label}#*
\GLSaccessfmtuseriii{insert}{cmd}{gls-label}#*
\glsaccessfmtuseriv{insert}{cmd}{gls-label}#*
\Glsaccessfmtuseriv{insert}{cmd}{gls-label}#*
\GLSaccessfmtuseriv{insert}{cmd}{gls-label}#*
\glsaccessfmtuserv{insert}{cmd}{gls-label}#*
\Glsaccessfmtuserv{insert}{cmd}{gls-label}#*
\GLSaccessfmtuserv{insert}{cmd}{gls-label}#*
\glsaccessfmtuservi{insert}{cmd}{gls-label}#*
\Glsaccessfmtuservi{insert}{cmd}{gls-label}#*
\GLSaccessfmtuservi{insert}{cmd}{gls-label}#*

### 10 Categories ###
\glscategory{gls-label%special}
\glsifcategory{gls-label%special}{category}{true}{false}#*
\glsxtrsetcategory{gls-labels}{category}#*
\glsxtrsetcategoryforall{glossary-labels}{category}#*
\glsforeachincategory{category}{glossary-cmd}{label-cmd}{body}#*
\glsforeachincategory[glossary-types]{category}{glossary-cmd}{label-cmd}{body}#*
\glsforeachwithattribute{attribute}{value}{glossary-cmd}{label-cmd}{body}#*
\glsforeachwithattribute[glossary-types]{attribute}{value}{glossary-cmd}{label-cmd}{body}#*

## Attributes ##
\glsxtrwordsep#*
\glsxtrword{word}#*
\glssetcategoryattribute{category}{attribute}{value}#*
\glssetcategoriesattribute{category list}{attribute}{value}#*
\glssetcategoryattributes{category}{attribute list}{value}#*
\glssetcategoriesattributes{category list}{attribute list}{value}#*
\glssetattribute{gls-label%special}{attribute}{value}#*
\glssetregularcategory{category}#*
\glsunsetcategoryattribute{category}{attribute}#*
\glsgetcategoryattribute{category}{attribute}#*
\glsgetattribute{gls-label%special}{attribute}#*
\glshascategoryattribute{category}{attribute}{true}{false}#*
\glshasattribute{gls-label%special}{attribute}{value}{true}{false}#*
\glsifcategoryattribute{category}{attribute}{value}{true}{false}#*
\glsifattribute{gls-label%special}{attribute}{value}{true}{false}#*
\glsifregularcategory{category}{true}{false}#*
\glsifnotregularcategory{category}{true}{false}#*
\glsifregular{gls-label%special}{true}{false}#*
\glsifnotregular{gls-label%special}{true}{false}#*
\glsifcategoryattributetrue{category}{attribute}{true}{false}#*
\glsifattributetrue{gls-label%special}{attribute}{true}{false}#*
\glsifcategoryattributehasitem{category}{attribute}{item}{true}{false}#*

### 11 bib2gls: Managing Reference Databases ###
\BibGlsOptions{options}
\GlsXtrLoadResources
\GlsXtrLoadResources[options%keyvals]
\glsbibdata{bib list}
\glsbibdata[options%keyvals]{bib list}

#keyvals:\GlsXtrLoadResources#c,\glsbibdata#c
charset=%<encoding name%>
locale=%<lang tag%>
interpret-preamble#true,false
write-preamble#true,false
set-widest#true,false
entry-type-aliases={%<keyvals%>}
unknown-entry-alias=%<value%>
action=#define,copy,define or copy
copy-to-glossary={%<list%>}
copy-to-glossary-missing-field-action=#skip,fallback,empty
src={%<list%>}
selection=#recorded and deps,recorded and deps and see,recorded and deps and see not also,recorded no deps,recorded and ancestors,deps but not recorded,ancestors but not recorded,selected before,all
match={%<keyvals%>}
match-op=#and,or
not-match={%<keyvals%>}
match-action=#filter,add
limit=%<number%>
save-child-count#true,false
save-sibling-count#true,false
save-root-ancestor#true,false
flatten#true,false
flatten-lonely=#false,presort,postsort
flatten-lonely-rule=#only unrecorded parents,discard unrecorded,no discard
flatten-lonely-condition=%<value%>
flatten-lonely-missing-field-action=#skip,fallback,empty
strip-missing-parents#true,false
missing-parents=#strip,warn,create
missing-parent-category=#same as child,same as base,no value,false,%<label%>
group-level=#{%<n%>},{>%<n%>},{>=%<n%>},{<%<n%>},{<=%<n%>},all
merge-small-groups
merge-small-groups=%<n%>
master=%<name%>
master-resources={%<list%>}
interpret-label-fields#true,false
labelify={%<list%>}
labelify-replace={%<list%>}
label-prefix=%<prefix%>
duplicate-label-suffix=%<suffix%>
record-label-prefix=%<tag%>
cs-label-prefix=%<tag%>
ext-prefixes={%<list%>}
prefix-only-existing#true,false
save-original-id=#false,true,%<field%>
save-original-id-action=#always,no override,changed override,changes,diff
save-definition-index#true,false
save-use-index#true,false
dependency-fields={%<list%>}
group=%<label%>
category=#false,same as entry,same as original entry,same as base,same as type,%<label%>
type=#false,same as entry,same as original entry,same as base,same as category,same as parent,%<label%>
trigger-type=%<type%>
progenitor-type=%<type%>
progeny-type=%<type%>
adopted-parent-field=%<field%>
abbreviation-name-fallback=%<field%>
abbreviation-text-fallback=%<field%>
ignore-fields={%<list%>}
field-aliases={%<keyvals%>}
replicate-fields={%<keyvals%>}
replicate-override#true,false
replicate-missing-field-action=#skip,fallback,empty
assign-fields={%<keyvals%>}
assign-override#true,false
assign-missing-field-action=#skip,fallback,empty
counter=%<value%>
copy-action-group-field=%<value%>
copy-alias-to-see#true,false
save-from-see=%<value%>
save-from-seealso=%<value%>
save-from-alias=%<value%>
save-crossref-tail=%<value%>
save-original-entrytype=%<value%>
save-original-entrytype-action=#always,no override,changed override,changed,diff,changed no override
post-description-dot=#none,all,check
strip-trailing-nopost=#true,false
check-end-punctuation={%<list%>}
sort-label-list={%<list%>}
prune-xr#true,false
prune-see-match={%<keyvals%>}
prune-see-op=#and,or
prune-seealso-match={%<keyvals%>}
prune-seealso-op=#and,or
prune-iterations=%<number%>
bibtex-contributor-fields={%<list%>}
contributor-order=#surname,von,forenames
encapsulate-fields={%<keyvals%>}
encapsulate-fields*={%<keyvals%>}
format-integer-fields={%<keyvals%>}
format-decimal-fields={%<keyvals%>}
interpret-fields={%<list%>}
interpret-fields-action=#replace,replace non empty
hex-unicode-fields={%<list%>}
date-time-fields={%<list%>}
date-fields={%<list%>}
time-fields={%<list%>}
date-time-field-format=%<value%>
date-field-format=%<value%>
time-field-format=%<value%>
date-time-field-locale=%<value%>
date-field-locale=%<value%>
time-field-locale=%<value%>
prefix-fields={%<list%>}
append-prefix-field=#none,space,space or nbsp
append-prefix-field-cs=%<cs%>
append-prefix-field-exceptions=%<sequence%>
append-prefix-field-cs-exceptions=%<sequence%>
append-prefix-field-nbsp-match=%<pattern%>
no-case-change-cs={%<list%>}
word-boundaries={%<list%>}
short-case-change=#white space,cs space,dash,nbsp
long-case-change=#white space,cs space,dash,nbsp
name-case-change=#white space,cs space,dash,nbsp
description-case-change=#white space,cs space,dash,nbsp
field-case-change={%<keyvals%>}
short-plural-suffix=%<suffix%>
dual-short-plural-suffix=%<suffix%>
save-locations=#false,true,see,see not also,alias only
save-loclist#true,false
save-primary-locations=#false,retain,default format,start,remove
save-principal-locations=#false,retain,default format,start,remove
primary-location-formats={%<list%>}
principal-location-formats={%<list%>}
primary-loc-counters=#combine,match,split
principal-loc-counters=#combine,match,split
merge-ranges#true,false
min-loc-range=%<value%>
max-loc-diff=%<integer%>
suffixF=%<value%>
suffixFF=%<value%>
compact-ranges=%<value%>
see=#omit,before,after
seealso=#omit,before,after
alias=#omit,before,after
alias-loc=#keep,transfer,omit
loc-prefix=%<value%>
loc-prefix-def=#global,local,individual
loc-suffix=%<value%>
loc-suffix-def=#global,local,individual
loc-counters={%<list%>}
save-index-counter=%<value%>
supplemental-locations=%<basename%>
supplemental-selection=%<value%>
supplemental-category=%<value%>
sort=%<value%>
shuffle=%<seed%>
sort-field=%<field%>
missing-sort-fallback=%<field%>
custom-sort-fallbacks={%<keyvals%>}
entry-sort-fallback=%<field%>
abbreviation-sort-fallback=%<field%>
symbol-sort-fallback=%<field%>
bibtexentry-sort-fallback=%<field%>
field-concat-sep=%<separator%>
trim-sort#true,false
sort-replace={%<list%>}
sort-rule=%<value%>
break-at=#word,character,sentence,upper-notlower,upper-upper,upper-notlower-word,upper-upper-word,none
break-marker=%<marker%>
break-at-match={%<keyvals%>}
break-at-match-op=#and,or
break-at-not-match={%<keyvals%>}
sort-number-pad=%<number%>
sort-pad-plus=%<marker%>
sort-pad-minus=%<marker%>
identical-sort-action=#none,def,use,id,original id,%<field%>
sort-suffix=#none,non-unique,%<field%>
sort-suffix-marker=%<marker%>
encapsulate-sort=%<csname%>
strength=#primary,secondary,tertiary,identical
decomposition=#canonical,full,none
letter-number-rule=#before letter,after letter,between,first,last
letter-number-punc-rule=#punc-space-first,punc-space-last,space-punc-first,space-punc-last,space-first-punc-last,punc-first-space-last,punc-first-space-zero,punc-last-space-zero,punc-first-space-zero-match-next,punc-last-space-zero-match-next
numeric-sort-pattern=%<value%>
numeric-locale=#locale,doc,%<lang-tag%>
date-sort-locale=#locale,doc,%<lang-tag%>
date-sort-format=#default,short,medium,long,full,%<pattern%>
group-formation=#default,codepoint,unicode category,unicode script,unicode category and script
secondary=%<value%>
secondary-match={%<keyvals%>}
secondary-not-match={%<keyvals%>}
secondary-match-op=#and,or
secondary-match-action=#filter,add
secondary-missing-sort-fallback=%<field%>
secondary-trim-sort#true,false
secondary-sort-replace={%<list%>}
secondary-sort-rule=%<value%>
secondary-break-at=#word,character,sentence,upper-notlower,upper-upper,upper-notlower-word,upper-upper-word,none
secondary-break-marker=%<marker%>
secondary-break-at-match={%<keyvals%>}
secondary-break-at-match-op=#and,or
secondary-break-at-not-match={%<keyvals%>}
secondary-sort-number-pad=%<number%>
secondary-sort-pad-plus=%<marker%>
secondary-sort-pad-minus=%<marker%>
secondary-identical-sort-action=#none,def,use,id,original id,%<field%>
secondary-sort-suffix=#none,non-unique,%<field%>
secondary-sort-suffix-marker=%<marker%>
secondary-strength=#primary,secondary,tertiary,identical
secondary-decomposition=#canonical,full,none
secondary-letter-number-rule=#before letter,after letter,between,first,last
secondary-letter-number-punc-rule=#punc-space-first,punc-space-last,space-punc-first,space-punc-last,space-first-punc-last,punc-first-space-last,punc-first-space-zero,punc-last-space-zero,punc-first-space-zero-match-next,punc-last-space-zero-match-next
secondary-numeric-sort-pattern=%<value%>
secondary-numeric-locale=#locale,doc,%<lang-tag%>
secondary-date-sort-locale=#locale,doc,%<lang-tag%>
secondary-date-sort-format=#default,short,medium,long,full,%<pattern%>
secondary-group-formation=#default,codepoint,unicode category,unicode script,unicode category and script
dual-prefix=%<prefix%>
primary-dual-dependency#true,false
combine-dual-locations=#false,both,dual,primary,dual retain principal,primary retain principal
dual-type=#false,same as entry,same as original entry,same as base,same as primary,same as parent,same as category,%<label%>
dual-category=#false,same as entry,same as original entry,same as base,same as primary,same as type,%<label%>
dual-counter=%<value%>
dual-short-case-change=#white space,cs space,dash,nbsp
dual-long-case-change=#white space,cs space,dash,nbsp
dual-field=%<value%>
dual-date-time-field-format=%<value%>
dual-date-field-format=%<value%>
dual-time-field-format=%<value%>
dual-date-time-field-locale=%<value%>
dual-date-field-locale=%<value%>
date-time-field-locale=%<value%>
dual-sort=%<value%>
dual-sort-field=%<value%>
dual-missing-sort-fallback=%<field%>
dual-trim-sort#true,false
dual-sort-replace={%<list%>}
dual-sort-rule=%<value%>
dual-break-at=#word,character,sentence,upper-notlower,upper-upper,upper-notlower-word,upper-upper-word,none
dual-break-marker=%<marker%>
dual-break-at-match={%<keyvals%>}
dual-break-at-match-op=#and,or
dual-break-at-not-match={%<keyvals%>}
dual-sort-number-pad=%<number%>
dual-sort-pad-plus=%<marker%>
dual-sort-pad-minus=%<marker%>
dual-identical-sort-action=#none,def,use,id,original id,%<field%>
dual-sort-suffix=#none,non-unique,%<field%>
dual-sort-suffix-marker=%<marker%>
dual-strength=#primary,secondary,tertiary,identical
dual-decomposition=#canonical,full,none
dual-letter-number-rule=#before letter,after letter,between,first,last
dual-letter-number-punc-rule=#punc-space-first,punc-space-last,space-punc-first,space-punc-last,space-first-punc-last,punc-first-space-last,punc-first-space-zero,punc-last-space-zero,punc-first-space-zero-match-next,punc-last-space-zero-match-next
dual-numeric-sort-pattern=%<value%>
dual-numeric-locale=#locale,doc,%<lang-tag%>
dual-date-sort-locale=#locale,doc,%<lang-tag%>
dual-date-sort-format=#default,short,medium,long,full,%<pattern%>
dual-group-formation=#default,codepoint,unicode category,unicode script,unicode category and script
dual-entry-map={{%<list1%>},{%<list2%>}}
dual-abbrv-map={{%<list1%>},{%<list2%>}}
dual-abbrventry-map={{%<list1%>},{%<list2%>}}
dual-symbol-map={{%<list1%>},{%<list2%>}}
dual-indexentry-map={{%<list1%>},{%<list2%>}}
dual-indexsymbol-map={{%<list1%>},{%<list2%>}}
dual-indexabbrv-map={{%<list1%>},{%<list2%>}}
dual-entry-backlink#true,false
dual-abbrv-backlink#true,false
dual-symbol-backlink#true,false
dual-abbrventry-backlink#true,false
dual-entryabbrv-backlink#true,false
dual-indexentry-backlink#true,false
dual-indexsymbol-backlink#true,false
dual-indexabbrv-backlink#true,false
dual-backlink#true,false
tertiary-prefix=%<prefix%>
tertiary-type=%<value%>
tertiary-category=%<value%>
compound-options-global#true,false
compound-dependent#true,false
compound-add-hierarchy#true,false
compound-has-records#true,false
compound-adjust-name=#false,unique,once
compound-main-type=#same as entry,same as original entry,same as base,same as category,same as parent,%<label%>
compound-other-type=#same as main,same as entry,same as original entry,same as base,same as category,same as parent,%<label%>
compound-type-override#true,false
compound-write-def=#none,all,ref
#endkeyvals

\glsxtrresourcecount#*
\glsxtrresourceinit#*
\glsxtrMFUsave#*
\GlsXtrDefaultResourceOptions#*

## Record Counting ##
\glsxtrdetoklocation{location}#*
\GlsXtrTotalRecordCount{gls-label%special}#*
\GlsXtrRecordCount{gls-label%special}{counter}#*
\GlsXtrLocationRecordCount{gls-label%special}{counter}{location}#*
\glsxtrifrecordtrigger{gls-label%special}{true}{false}#*
\glsxtrrecordtriggervalue{gls-label%special}#*
\GlsXtrSetRecordCountAttribute{category list}{value}#*
\glstriggerrecordformat{location}#*

\rgls{gls-label%special}#*
\rgls[options%keyvals]{gls-label%special}#*
\rgls{gls-label%special}[insert]#*
\rgls[options%keyvals]{gls-label%special}[insert]#*
\rgls*{gls-label%special}#S
\rgls*[options%keyvals]{gls-label%special}#S
\rgls*{gls-label%special}[insert]#S
\rgls*[options%keyvals]{gls-label%special}[insert]#S
\rgls+{gls-label%special}#S
\rgls+[options%keyvals]{gls-label%special}#S
\rgls+{gls-label%special}[insert]#S
\rgls+[options%keyvals]{gls-label%special}[insert]#S
\rGls{gls-label%special}#*
\rGls[options%keyvals]{gls-label%special}#*
\rGls{gls-label%special}[insert]#*
\rGls[options%keyvals]{gls-label%special}[insert]#*
\rGls*{gls-label%special}#S
\rGls*[options%keyvals]{gls-label%special}#S
\rGls*{gls-label%special}[insert]#S
\rGls*[options%keyvals]{gls-label%special}[insert]#S
\rGls+{gls-label%special}#S
\rGls+[options%keyvals]{gls-label%special}#S
\rGls+{gls-label%special}[insert]#S
\rGls+[options%keyvals]{gls-label%special}[insert]#S
\rGLS{gls-label%special}#*
\rGLS[options%keyvals]{gls-label%special}#*
\rGLS{gls-label%special}[insert]#*
\rGLS[options%keyvals]{gls-label%special}[insert]#*
\rGLS*{gls-label%special}#S
\rGLS*[options%keyvals]{gls-label%special}#S
\rGLS*{gls-label%special}[insert]#S
\rGLS*[options%keyvals]{gls-label%special}[insert]#S
\rGLS+{gls-label%special}#S
\rGLS+[options%keyvals]{gls-label%special}#S
\rGLS+{gls-label%special}[insert]#S
\rGLS+[options%keyvals]{gls-label%special}[insert]#S
\rglspl{gls-label%special}#*
\rglspl[options%keyvals]{gls-label%special}#*
\rglspl{gls-label%special}[insert]#*
\rglspl[options%keyvals]{gls-label%special}[insert]#*
\rglspl*{gls-label%special}#S
\rglspl*[options%keyvals]{gls-label%special}#S
\rglspl*{gls-label%special}[insert]#S
\rglspl*[options%keyvals]{gls-label%special}[insert]#S
\rglspl+{gls-label%special}#S
\rglspl+[options%keyvals]{gls-label%special}#S
\rglspl+{gls-label%special}[insert]#S
\rglspl+[options%keyvals]{gls-label%special}[insert]#S
\rGlspl{gls-label%special}#*
\rGlspl[options%keyvals]{gls-label%special}#*
\rGlspl{gls-label%special}[insert]#*
\rGlspl[options%keyvals]{gls-label%special}[insert]#*
\rGlspl*{gls-label%special}#S
\rGlspl*[options%keyvals]{gls-label%special}#S
\rGlspl*{gls-label%special}[insert]#S
\rGlspl*[options%keyvals]{gls-label%special}[insert]#S
\rGlspl+{gls-label%special}#S
\rGlspl+[options%keyvals]{gls-label%special}#S
\rGlspl+{gls-label%special}[insert]#S
\rGlspl+[options%keyvals]{gls-label%special}[insert]#S
\rGLSpl{gls-label%special}#*
\rGLSpl[options%keyvals]{gls-label%special}#*
\rGLSpl{gls-label%special}[insert]#*
\rGLSpl[options%keyvals]{gls-label%special}[insert]#*
\rGLSpl*{gls-label%special}#S
\rGLSpl*[options%keyvals]{gls-label%special}#S
\rGLSpl*{gls-label%special}[insert]#S
\rGLSpl*[options%keyvals]{gls-label%special}[insert]#S
\rGLSpl+{gls-label%special}#S
\rGLSpl+[options%keyvals]{gls-label%special}#S
\rGLSpl+{gls-label%special}[insert]#S
\rGLSpl+[options%keyvals]{gls-label%special}[insert]#S
\rglsformat{gls-label%special}{insert}#*
\rglsplformat{gls-label%special}{insert}#*
\rGlsformat{gls-label%special}{insert}#*
\rGlsplformat{gls-label%special}{insert}#*
\rGLSformat{gls-label%special}{insert}#*
\rGLSplformat{gls-label%special}{insert}#*
\glsxtrenablerecordcount#*

### 12 Auto-Indexing ###
\glsxtrdoautoindexname{gls-label%special}{attribute}#*
\glsxtrautoindexentry{gls-label%special}#*
\glsxtrautoindexassignsort{cmd}{gls-label%special}#*
\glsxtrautoindexesc#*
\glsxtrautoindex{text}#*
\GlsXtrEnableIndexFormatOverride#*
\GlsXtrSetActualChar{character}#*
\GlsXtrSetLevelChar{character}#*
\GlsXtrSetEscChar{character}#*
\GlsXtrSetEncapChar{character}#*

### 13 On-the-Fly Document Definitions ###
\GlsXtrEnableOnTheFly
\glsxtr{gls-label%specialDef}#s#%gls-label
\glsxtr[gls-options%keyvals]{gls-label%specialDef}#s#%gls-label
\glsxtr[gls-options%keyvals][dfn-options]{gls-label%specialDef}#s#%gls-label
\GlsXtrWarning{defn options}{gls-label}#*
\glsxtrpl{gls-label%specialDef}#s#%gls-label
\glsxtrpl[gls-options%keyvals]{gls-label%specialDef}#s#%gls-label
\glsxtrpl[gls-options%keyvals][dfn-options]{gls-label%specialDef}#s#%gls-label
\Glsxtr{gls-label%specialDef}#s#%gls-label
\Glsxtr[gls-options%keyvals]{gls-label%specialDef}#s#%gls-label
\Glsxtr[gls-options%keyvals][dfn-options]{gls-label%specialDef}#s#%gls-label
\Glsxtrpl{gls-label%specialDef}#s#%gls-label
\Glsxtrpl[gls-options%keyvals]{gls-label%specialDef}#s#%gls-label
\Glsxtrpl[gls-options%keyvals][dfn-options]{gls-label%specialDef}#s#%gls-label
\glsxtrcat#*

### 15 Multi-Lingual Support ###
\ProvidesGlossariesExtraLang{tag}#*
\GlsXtrNoGlsWarningHead{glossary-label}{file}#*
\GlsXtrNoGlsWarningEmptyStart#*
\GlsXtrNoGlsWarningEmptyMain#*
\GlsXtrNoGlsWarningEmptyNotMain{glossary-label}#*
\GlsXtrNoGlsWarningCheckFile{file}#*
\GlsXtrNoGlsWarningMisMatch#*
\GlsXtrNoGlsWarningNoOut{file}#*
\GlsXtrNoGlsWarningTail#*
\GlsXtrNoGlsWarningBuildInfo#*
\GlsXtrNoGlsWarningAutoMake{glossary-label}#*

### other commands ###
\GlossariesAbbrStyleTooComplexWarning{arg1}{arg2}#*
\GlossariesExtraInfo{message%text}#*
\GlossariesExtraWarning{message%text}#*
\GlossariesExtraWarningNoLine{message%text}#*
\glsabspace{gls-label%special}#*
\glsacspacemax#*
\glsfmtinsert#*
\GLSfmtinsert#*
\GlsXtrDefineAbbreviationShortcuts#*
\GlsXtrDefineAcShortcuts#*
\GlsXtrDefineOtherShortcuts#*
\glsxtrfirstscfont{text}#*
\glsxtrfirstsmfont{text}#*
\glsxtrifemptyglossary{type}{true}{false}#*
\GlsXtrIfInGlossary{gls-label%special}{glossary-type}{true}{false}#*
\glsxtrinitwrglossbeforefalse#*
\glsxtrinitwrglossbeforetrue#*
\GlsXtrInternalLocationHyperlink{counter}{prefix}{location}#*
\glsxtrlocationhyperlink{counter}{prefix}{location}#*
\glsxtrNoGlossaryWarning{type}#*
\glsxtrprovideaccsuppcmd{category}{field}#*
\GlsXtrRecordWarning{type}#*
\glsxtrscfont{text}#*
\glsxtrsmfont{text}#*
\glsxtrstarflywarn#*
\glsxtrsupplocationurl#*
\glsxtruseseeformat{tag}{xr-list}#*
\glsxtrwordsephyphen#*
\ifglsxtrinitwrglossbefore#*
\mglsSetMain{multi-label}{new-main-label}#*
\RequireGlossariesExtraLang{tag}#*
\seealsoname#*

### not in main documentation ###
\glsxtrcontinuedname#S
\glsxtrcounterprefix#S
\glsxtrdohyperlink#S
\glsxtrdoidentify{arg}#S
\glsxtrhyperlink{arg1}{arg2}#S
\glsxtridentifyglsfamily{arg1}{arg2}{arg3}{arg4}{arg5}{arg6}{arg7}{arg8}#S
\glsxtridentifyglslink{arg1}{arg2}#S
\glsxtrmglswrite{arg}#S
\glsxtrprotectlinks#S
\glsxtrshorthyphennoinsert{arg1}{arg2}{arg3}#S
\glsxtrshorthyphennolong{arg1}{arg2}{arg3}#S
\GLSxtrshorthyphennolong{arg1}{arg2}{arg3}#S
\glsxtrundefdebug{arg}#S
\mglsWriteSeparateRefsFalse#S
\mglsWriteSeparateRefsTrue#S

# deprecated
\glsxtrresourcefile{filename%file}#S
\glsxtrresourcefile[options%keyvals]{filename%file}#S
\preglossarypreamble{text}#S
\preglossarypreamble[type]{text}#S
