/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// StreamResultOfStreamedListObjectsResponse struct for StreamResultOfStreamedListObjectsResponse
type StreamResultOfStreamedListObjectsResponse struct {
	Result *StreamedListObjectsResponse `json:"result,omitempty" yaml:"result,omitempty"`
	Error  *Status                      `json:"error,omitempty" yaml:"error,omitempty"`
}

// NewStreamResultOfStreamedListObjectsResponse instantiates a new StreamResultOfStreamedListObjectsResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewStreamResultOfStreamedListObjectsResponse() *StreamResultOfStreamedListObjectsResponse {
	this := StreamResultOfStreamedListObjectsResponse{}
	return &this
}

// NewStreamResultOfStreamedListObjectsResponseWithDefaults instantiates a new StreamResultOfStreamedListObjectsResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewStreamResultOfStreamedListObjectsResponseWithDefaults() *StreamResultOfStreamedListObjectsResponse {
	this := StreamResultOfStreamedListObjectsResponse{}
	return &this
}

// GetResult returns the Result field value if set, zero value otherwise.
func (o *StreamResultOfStreamedListObjectsResponse) GetResult() StreamedListObjectsResponse {
	if o == nil || o.Result == nil {
		var ret StreamedListObjectsResponse
		return ret
	}
	return *o.Result
}

// GetResultOk returns a tuple with the Result field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *StreamResultOfStreamedListObjectsResponse) GetResultOk() (*StreamedListObjectsResponse, bool) {
	if o == nil || o.Result == nil {
		return nil, false
	}
	return o.Result, true
}

// HasResult returns a boolean if a field has been set.
func (o *StreamResultOfStreamedListObjectsResponse) HasResult() bool {
	if o != nil && o.Result != nil {
		return true
	}

	return false
}

// SetResult gets a reference to the given StreamedListObjectsResponse and assigns it to the Result field.
func (o *StreamResultOfStreamedListObjectsResponse) SetResult(v StreamedListObjectsResponse) {
	o.Result = &v
}

// GetError returns the Error field value if set, zero value otherwise.
func (o *StreamResultOfStreamedListObjectsResponse) GetError() Status {
	if o == nil || o.Error == nil {
		var ret Status
		return ret
	}
	return *o.Error
}

// GetErrorOk returns a tuple with the Error field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *StreamResultOfStreamedListObjectsResponse) GetErrorOk() (*Status, bool) {
	if o == nil || o.Error == nil {
		return nil, false
	}
	return o.Error, true
}

// HasError returns a boolean if a field has been set.
func (o *StreamResultOfStreamedListObjectsResponse) HasError() bool {
	if o != nil && o.Error != nil {
		return true
	}

	return false
}

// SetError gets a reference to the given Status and assigns it to the Error field.
func (o *StreamResultOfStreamedListObjectsResponse) SetError(v Status) {
	o.Error = &v
}

func (o StreamResultOfStreamedListObjectsResponse) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Result != nil {
		toSerialize["result"] = o.Result
	}
	if o.Error != nil {
		toSerialize["error"] = o.Error
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableStreamResultOfStreamedListObjectsResponse struct {
	value *StreamResultOfStreamedListObjectsResponse
	isSet bool
}

func (v NullableStreamResultOfStreamedListObjectsResponse) Get() *StreamResultOfStreamedListObjectsResponse {
	return v.value
}

func (v *NullableStreamResultOfStreamedListObjectsResponse) Set(val *StreamResultOfStreamedListObjectsResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableStreamResultOfStreamedListObjectsResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableStreamResultOfStreamedListObjectsResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableStreamResultOfStreamedListObjectsResponse(val *StreamResultOfStreamedListObjectsResponse) *NullableStreamResultOfStreamedListObjectsResponse {
	return &NullableStreamResultOfStreamedListObjectsResponse{value: val, isSet: true}
}

func (v NullableStreamResultOfStreamedListObjectsResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableStreamResultOfStreamedListObjectsResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
