package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInitializeVariable invokes the polardb.DescribeDBInitializeVariable API synchronously
func (client *Client) DescribeDBInitializeVariable(request *DescribeDBInitializeVariableRequest) (response *DescribeDBInitializeVariableResponse, err error) {
	response = CreateDescribeDBInitializeVariableResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInitializeVariableWithChan invokes the polardb.DescribeDBInitializeVariable API asynchronously
func (client *Client) DescribeDBInitializeVariableWithChan(request *DescribeDBInitializeVariableRequest) (<-chan *DescribeDBInitializeVariableResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInitializeVariableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInitializeVariable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInitializeVariableWithCallback invokes the polardb.DescribeDBInitializeVariable API asynchronously
func (client *Client) DescribeDBInitializeVariableWithCallback(request *DescribeDBInitializeVariableRequest, callback func(response *DescribeDBInitializeVariableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInitializeVariableResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInitializeVariable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInitializeVariableRequest is the request struct for api DescribeDBInitializeVariable
type DescribeDBInitializeVariableRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBInitializeVariableResponse is the response struct for api DescribeDBInitializeVariable
type DescribeDBInitializeVariableResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	DBType    string    `json:"DBType" xml:"DBType"`
	DBVersion string    `json:"DBVersion" xml:"DBVersion"`
	Variables Variables `json:"Variables" xml:"Variables"`
}

// CreateDescribeDBInitializeVariableRequest creates a request to invoke DescribeDBInitializeVariable API
func CreateDescribeDBInitializeVariableRequest() (request *DescribeDBInitializeVariableRequest) {
	request = &DescribeDBInitializeVariableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DescribeDBInitializeVariable", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInitializeVariableResponse creates a response to parse from DescribeDBInitializeVariable response
func CreateDescribeDBInitializeVariableResponse() (response *DescribeDBInitializeVariableResponse) {
	response = &DescribeDBInitializeVariableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
