package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFlowControls invokes the edas.ListFlowControls API synchronously
func (client *Client) ListFlowControls(request *ListFlowControlsRequest) (response *ListFlowControlsResponse, err error) {
	response = CreateListFlowControlsResponse()
	err = client.DoAction(request, response)
	return
}

// ListFlowControlsWithChan invokes the edas.ListFlowControls API asynchronously
func (client *Client) ListFlowControlsWithChan(request *ListFlowControlsRequest) (<-chan *ListFlowControlsResponse, <-chan error) {
	responseChan := make(chan *ListFlowControlsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFlowControls(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFlowControlsWithCallback invokes the edas.ListFlowControls API asynchronously
func (client *Client) ListFlowControlsWithCallback(request *ListFlowControlsRequest, callback func(response *ListFlowControlsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFlowControlsResponse
		var err error
		defer close(result)
		response, err = client.ListFlowControls(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFlowControlsRequest is the request struct for api ListFlowControls
type ListFlowControlsRequest struct {
	*requests.RoaRequest
	AppId string `position:"Query" name:"AppId"`
}

// ListFlowControlsResponse is the response struct for api ListFlowControls
type ListFlowControlsResponse struct {
	*responses.BaseResponse
	Code            int             `json:"Code" xml:"Code"`
	Message         string          `json:"Message" xml:"Message"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	FlowControlsMap FlowControlsMap `json:"FlowControlsMap" xml:"FlowControlsMap"`
}

// CreateListFlowControlsRequest creates a request to invoke ListFlowControls API
func CreateListFlowControlsRequest() (request *ListFlowControlsRequest) {
	request = &ListFlowControlsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListFlowControls", "/pop/v5/app/flowControls", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListFlowControlsResponse creates a response to parse from ListFlowControls response
func CreateListFlowControlsResponse() (response *ListFlowControlsResponse) {
	response = &ListFlowControlsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
