package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDefaultB invokes the dyplsapi.UpdateDefaultB API synchronously
func (client *Client) UpdateDefaultB(request *UpdateDefaultBRequest) (response *UpdateDefaultBResponse, err error) {
	response = CreateUpdateDefaultBResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDefaultBWithChan invokes the dyplsapi.UpdateDefaultB API asynchronously
func (client *Client) UpdateDefaultBWithChan(request *UpdateDefaultBRequest) (<-chan *UpdateDefaultBResponse, <-chan error) {
	responseChan := make(chan *UpdateDefaultBResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDefaultB(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDefaultBWithCallback invokes the dyplsapi.UpdateDefaultB API asynchronously
func (client *Client) UpdateDefaultBWithCallback(request *UpdateDefaultBRequest, callback func(response *UpdateDefaultBResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDefaultBResponse
		var err error
		defer close(result)
		response, err = client.UpdateDefaultB(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDefaultBRequest is the request struct for api UpdateDefaultB
type UpdateDefaultBRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SubsId               requests.Integer `position:"Query" name:"SubsId"`
	SecretNo             string           `position:"Query" name:"SecretNo"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Query" name:"ProdCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PhoneNo              string           `position:"Query" name:"PhoneNo"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
}

// UpdateDefaultBResponse is the response struct for api UpdateDefaultB
type UpdateDefaultBResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDefaultBRequest creates a request to invoke UpdateDefaultB API
func CreateUpdateDefaultBRequest() (request *UpdateDefaultBRequest) {
	request = &UpdateDefaultBRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "UpdateDefaultB", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateDefaultBResponse creates a response to parse from UpdateDefaultB response
func CreateUpdateDefaultBResponse() (response *UpdateDefaultBResponse) {
	response = &UpdateDefaultBResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
