package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableUser invokes the dms_enterprise.DisableUser API synchronously
func (client *Client) DisableUser(request *DisableUserRequest) (response *DisableUserResponse, err error) {
	response = CreateDisableUserResponse()
	err = client.DoAction(request, response)
	return
}

// DisableUserWithChan invokes the dms_enterprise.DisableUser API asynchronously
func (client *Client) DisableUserWithChan(request *DisableUserRequest) (<-chan *DisableUserResponse, <-chan error) {
	responseChan := make(chan *DisableUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableUserWithCallback invokes the dms_enterprise.DisableUser API asynchronously
func (client *Client) DisableUserWithCallback(request *DisableUserRequest, callback func(response *DisableUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableUserResponse
		var err error
		defer close(result)
		response, err = client.DisableUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableUserRequest is the request struct for api DisableUser
type DisableUserRequest struct {
	*requests.RpcRequest
	Uid string           `position:"Query" name:"Uid"`
	Tid requests.Integer `position:"Query" name:"Tid"`
}

// DisableUserResponse is the response struct for api DisableUser
type DisableUserResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateDisableUserRequest creates a request to invoke DisableUser API
func CreateDisableUserRequest() (request *DisableUserRequest) {
	request = &DisableUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "DisableUser", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableUserResponse creates a response to parse from DisableUser response
func CreateDisableUserResponse() (response *DisableUserResponse) {
	response = &DisableUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
