package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceRemark invokes the ddoscoo.ModifyInstanceRemark API synchronously
func (client *Client) ModifyInstanceRemark(request *ModifyInstanceRemarkRequest) (response *ModifyInstanceRemarkResponse, err error) {
	response = CreateModifyInstanceRemarkResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceRemarkWithChan invokes the ddoscoo.ModifyInstanceRemark API asynchronously
func (client *Client) ModifyInstanceRemarkWithChan(request *ModifyInstanceRemarkRequest) (<-chan *ModifyInstanceRemarkResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceRemarkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceRemark(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceRemarkWithCallback invokes the ddoscoo.ModifyInstanceRemark API asynchronously
func (client *Client) ModifyInstanceRemarkWithCallback(request *ModifyInstanceRemarkRequest, callback func(response *ModifyInstanceRemarkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceRemarkResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceRemark(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceRemarkRequest is the request struct for api ModifyInstanceRemark
type ModifyInstanceRemarkRequest struct {
	*requests.RpcRequest
	Remark     string `position:"Query" name:"Remark"`
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
}

// ModifyInstanceRemarkResponse is the response struct for api ModifyInstanceRemark
type ModifyInstanceRemarkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyInstanceRemarkRequest creates a request to invoke ModifyInstanceRemark API
func CreateModifyInstanceRemarkRequest() (request *ModifyInstanceRemarkRequest) {
	request = &ModifyInstanceRemarkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "ModifyInstanceRemark", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyInstanceRemarkResponse creates a response to parse from ModifyInstanceRemark response
func CreateModifyInstanceRemarkResponse() (response *ModifyInstanceRemarkResponse) {
	response = &ModifyInstanceRemarkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
