package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterNodePoolDetail invokes the cs.DescribeClusterNodePoolDetail API synchronously
func (client *Client) DescribeClusterNodePoolDetail(request *DescribeClusterNodePoolDetailRequest) (response *DescribeClusterNodePoolDetailResponse, err error) {
	response = CreateDescribeClusterNodePoolDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterNodePoolDetailWithChan invokes the cs.DescribeClusterNodePoolDetail API asynchronously
func (client *Client) DescribeClusterNodePoolDetailWithChan(request *DescribeClusterNodePoolDetailRequest) (<-chan *DescribeClusterNodePoolDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterNodePoolDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterNodePoolDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterNodePoolDetailWithCallback invokes the cs.DescribeClusterNodePoolDetail API asynchronously
func (client *Client) DescribeClusterNodePoolDetailWithCallback(request *DescribeClusterNodePoolDetailRequest, callback func(response *DescribeClusterNodePoolDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterNodePoolDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterNodePoolDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterNodePoolDetailRequest is the request struct for api DescribeClusterNodePoolDetail
type DescribeClusterNodePoolDetailRequest struct {
	*requests.RoaRequest
	ClusterId  string `position:"Path" name:"ClusterId"`
	NodepoolId string `position:"Path" name:"NodepoolId"`
}

// DescribeClusterNodePoolDetailResponse is the response struct for api DescribeClusterNodePoolDetail
type DescribeClusterNodePoolDetailResponse struct {
	*responses.BaseResponse
}

// CreateDescribeClusterNodePoolDetailRequest creates a request to invoke DescribeClusterNodePoolDetail API
func CreateDescribeClusterNodePoolDetailRequest() (request *DescribeClusterNodePoolDetailRequest) {
	request = &DescribeClusterNodePoolDetailRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeClusterNodePoolDetail", "/clusters/[ClusterId]/nodepools/[NodepoolId]", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeClusterNodePoolDetailResponse creates a response to parse from DescribeClusterNodePoolDetail response
func CreateDescribeClusterNodePoolDetailResponse() (response *DescribeClusterNodePoolDetailResponse) {
	response = &DescribeClusterNodePoolDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
