package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AreaCreate invokes the cloudwf.AreaCreate API synchronously
// api document: https://help.aliyun.com/api/cloudwf/areacreate.html
func (client *Client) AreaCreate(request *AreaCreateRequest) (response *AreaCreateResponse, err error) {
	response = CreateAreaCreateResponse()
	err = client.DoAction(request, response)
	return
}

// AreaCreateWithChan invokes the cloudwf.AreaCreate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/areacreate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AreaCreateWithChan(request *AreaCreateRequest) (<-chan *AreaCreateResponse, <-chan error) {
	responseChan := make(chan *AreaCreateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AreaCreate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AreaCreateWithCallback invokes the cloudwf.AreaCreate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/areacreate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AreaCreateWithCallback(request *AreaCreateRequest, callback func(response *AreaCreateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AreaCreateResponse
		var err error
		defer close(result)
		response, err = client.AreaCreate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AreaCreateRequest is the request struct for api AreaCreate
type AreaCreateRequest struct {
	*requests.RpcRequest
	Name string           `position:"Query" name:"Name"`
	Dids string           `position:"Query" name:"Dids"`
	Sid  requests.Integer `position:"Query" name:"Sid"`
}

// AreaCreateResponse is the response struct for api AreaCreate
type AreaCreateResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateAreaCreateRequest creates a request to invoke AreaCreate API
func CreateAreaCreateRequest() (request *AreaCreateRequest) {
	request = &AreaCreateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "AreaCreate", "cloudwf", "openAPI")
	return
}

// CreateAreaCreateResponse creates a response to parse from AreaCreate response
func CreateAreaCreateResponse() (response *AreaCreateResponse) {
	response = &AreaCreateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
