package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListStrategyTemplates invokes the cloudcallcenter.ListStrategyTemplates API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/liststrategytemplates.html
func (client *Client) ListStrategyTemplates(request *ListStrategyTemplatesRequest) (response *ListStrategyTemplatesResponse, err error) {
	response = CreateListStrategyTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// ListStrategyTemplatesWithChan invokes the cloudcallcenter.ListStrategyTemplates API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/liststrategytemplates.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListStrategyTemplatesWithChan(request *ListStrategyTemplatesRequest) (<-chan *ListStrategyTemplatesResponse, <-chan error) {
	responseChan := make(chan *ListStrategyTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListStrategyTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListStrategyTemplatesWithCallback invokes the cloudcallcenter.ListStrategyTemplates API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/liststrategytemplates.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListStrategyTemplatesWithCallback(request *ListStrategyTemplatesRequest, callback func(response *ListStrategyTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListStrategyTemplatesResponse
		var err error
		defer close(result)
		response, err = client.ListStrategyTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListStrategyTemplatesRequest is the request struct for api ListStrategyTemplates
type ListStrategyTemplatesRequest struct {
	*requests.RpcRequest
}

// ListStrategyTemplatesResponse is the response struct for api ListStrategyTemplates
type ListStrategyTemplatesResponse struct {
	*responses.BaseResponse
	RequestId         string     `json:"RequestId" xml:"RequestId"`
	Success           bool       `json:"Success" xml:"Success"`
	Code              string     `json:"Code" xml:"Code"`
	Message           string     `json:"Message" xml:"Message"`
	HttpStatusCode    int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	StrategyTemplates []Strategy `json:"StrategyTemplates" xml:"StrategyTemplates"`
}

// CreateListStrategyTemplatesRequest creates a request to invoke ListStrategyTemplates API
func CreateListStrategyTemplatesRequest() (request *ListStrategyTemplatesRequest) {
	request = &ListStrategyTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListStrategyTemplates", "", "")
	request.Method = requests.POST
	return
}

// CreateListStrategyTemplatesResponse creates a response to parse from ListStrategyTemplates response
func CreateListStrategyTemplatesResponse() (response *ListStrategyTemplatesResponse) {
	response = &ListStrategyTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
