package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateOverallStatisticsReport invokes the cloudcallcenter.GenerateOverallStatisticsReport API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/generateoverallstatisticsreport.html
func (client *Client) GenerateOverallStatisticsReport(request *GenerateOverallStatisticsReportRequest) (response *GenerateOverallStatisticsReportResponse, err error) {
	response = CreateGenerateOverallStatisticsReportResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateOverallStatisticsReportWithChan invokes the cloudcallcenter.GenerateOverallStatisticsReport API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/generateoverallstatisticsreport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GenerateOverallStatisticsReportWithChan(request *GenerateOverallStatisticsReportRequest) (<-chan *GenerateOverallStatisticsReportResponse, <-chan error) {
	responseChan := make(chan *GenerateOverallStatisticsReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateOverallStatisticsReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateOverallStatisticsReportWithCallback invokes the cloudcallcenter.GenerateOverallStatisticsReport API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/generateoverallstatisticsreport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GenerateOverallStatisticsReportWithCallback(request *GenerateOverallStatisticsReportRequest, callback func(response *GenerateOverallStatisticsReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateOverallStatisticsReportResponse
		var err error
		defer close(result)
		response, err = client.GenerateOverallStatisticsReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateOverallStatisticsReportRequest is the request struct for api GenerateOverallStatisticsReport
type GenerateOverallStatisticsReportRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	JobGroupId string `position:"Query" name:"JobGroupId"`
}

// GenerateOverallStatisticsReportResponse is the response struct for api GenerateOverallStatisticsReport
type GenerateOverallStatisticsReportResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Report         Report `json:"Report" xml:"Report"`
}

// CreateGenerateOverallStatisticsReportRequest creates a request to invoke GenerateOverallStatisticsReport API
func CreateGenerateOverallStatisticsReportRequest() (request *GenerateOverallStatisticsReportRequest) {
	request = &GenerateOverallStatisticsReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GenerateOverallStatisticsReport", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateOverallStatisticsReportResponse creates a response to parse from GenerateOverallStatisticsReport response
func CreateGenerateOverallStatisticsReportResponse() (response *GenerateOverallStatisticsReportResponse) {
	response = &GenerateOverallStatisticsReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
