package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteIntegration invokes the arms.DeleteIntegration API synchronously
func (client *Client) DeleteIntegration(request *DeleteIntegrationRequest) (response *DeleteIntegrationResponse, err error) {
	response = CreateDeleteIntegrationResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteIntegrationWithChan invokes the arms.DeleteIntegration API asynchronously
func (client *Client) DeleteIntegrationWithChan(request *DeleteIntegrationRequest) (<-chan *DeleteIntegrationResponse, <-chan error) {
	responseChan := make(chan *DeleteIntegrationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteIntegration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteIntegrationWithCallback invokes the arms.DeleteIntegration API asynchronously
func (client *Client) DeleteIntegrationWithCallback(request *DeleteIntegrationRequest, callback func(response *DeleteIntegrationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteIntegrationResponse
		var err error
		defer close(result)
		response, err = client.DeleteIntegration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteIntegrationRequest is the request struct for api DeleteIntegration
type DeleteIntegrationRequest struct {
	*requests.RpcRequest
	Integration string `position:"Query" name:"Integration"`
	ClusterId   string `position:"Query" name:"ClusterId"`
}

// DeleteIntegrationResponse is the response struct for api DeleteIntegration
type DeleteIntegrationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateDeleteIntegrationRequest creates a request to invoke DeleteIntegration API
func CreateDeleteIntegrationRequest() (request *DeleteIntegrationRequest) {
	request = &DeleteIntegrationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "DeleteIntegration", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteIntegrationResponse creates a response to parse from DeleteIntegration response
func CreateDeleteIntegrationResponse() (response *DeleteIntegrationResponse) {
	response = &DeleteIntegrationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
