//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by validation-gen. DO NOT EDIT.

package minimum

import (
	context "context"
	fmt "fmt"

	operation "k8s.io/apimachinery/pkg/api/operation"
	safe "k8s.io/apimachinery/pkg/api/safe"
	validate "k8s.io/apimachinery/pkg/api/validate"
	field "k8s.io/apimachinery/pkg/util/validation/field"
	testscheme "k8s.io/code-generator/cmd/validation-gen/testscheme"
)

func init() { localSchemeBuilder.Register(RegisterValidations) }

// RegisterValidations adds validation functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterValidations(scheme *testscheme.Scheme) error {
	scheme.AddValidationFunc((*Struct)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_Struct(ctx, op, nil /* fldPath */, obj.(*Struct), safe.Cast[*Struct](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	return nil
}

func Validate_IntType(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *IntType) (errs field.ErrorList) {
	// type IntType
	if op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
		return nil // no changes
	}
	errs = append(errs, validate.Minimum(ctx, op, fldPath, obj, oldObj, 1)...)

	return errs
}

func Validate_Struct(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *Struct) (errs field.ErrorList) {
	// field Struct.TypeMeta has no validation

	// field Struct.IntField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *int) (errs field.ErrorList) {
			if op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil // no changes
			}
			errs = append(errs, validate.Minimum(ctx, op, fldPath, obj, oldObj, 1)...)
			return
		}(fldPath.Child("intField"), &obj.IntField, safe.Field(oldObj, func(oldObj *Struct) *int { return &oldObj.IntField }))...)

	// field Struct.IntPtrField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *int) (errs field.ErrorList) {
			if op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil // no changes
			}
			errs = append(errs, validate.Minimum(ctx, op, fldPath, obj, oldObj, 1)...)
			return
		}(fldPath.Child("intPtrField"), obj.IntPtrField, safe.Field(oldObj, func(oldObj *Struct) *int { return oldObj.IntPtrField }))...)

	// field Struct.Int16Field
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *int16) (errs field.ErrorList) {
			if op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil // no changes
			}
			errs = append(errs, validate.Minimum(ctx, op, fldPath, obj, oldObj, 1)...)
			return
		}(fldPath.Child("int16Field"), &obj.Int16Field, safe.Field(oldObj, func(oldObj *Struct) *int16 { return &oldObj.Int16Field }))...)

	// field Struct.Int32Field
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *int32) (errs field.ErrorList) {
			if op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil // no changes
			}
			errs = append(errs, validate.Minimum(ctx, op, fldPath, obj, oldObj, 1)...)
			return
		}(fldPath.Child("int32Field"), &obj.Int32Field, safe.Field(oldObj, func(oldObj *Struct) *int32 { return &oldObj.Int32Field }))...)

	// field Struct.Int64Field
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *int64) (errs field.ErrorList) {
			if op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil // no changes
			}
			errs = append(errs, validate.Minimum(ctx, op, fldPath, obj, oldObj, 1)...)
			return
		}(fldPath.Child("int64Field"), &obj.Int64Field, safe.Field(oldObj, func(oldObj *Struct) *int64 { return &oldObj.Int64Field }))...)

	// field Struct.UintField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *uint) (errs field.ErrorList) {
			if op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil // no changes
			}
			errs = append(errs, validate.Minimum(ctx, op, fldPath, obj, oldObj, 1)...)
			return
		}(fldPath.Child("uintField"), &obj.UintField, safe.Field(oldObj, func(oldObj *Struct) *uint { return &oldObj.UintField }))...)

	// field Struct.UintPtrField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *uint) (errs field.ErrorList) {
			if op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil // no changes
			}
			errs = append(errs, validate.Minimum(ctx, op, fldPath, obj, oldObj, 1)...)
			return
		}(fldPath.Child("uintPtrField"), obj.UintPtrField, safe.Field(oldObj, func(oldObj *Struct) *uint { return oldObj.UintPtrField }))...)

	// field Struct.Uint16Field
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *uint16) (errs field.ErrorList) {
			if op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil // no changes
			}
			errs = append(errs, validate.Minimum(ctx, op, fldPath, obj, oldObj, 1)...)
			return
		}(fldPath.Child("uint16Field"), &obj.Uint16Field, safe.Field(oldObj, func(oldObj *Struct) *uint16 { return &oldObj.Uint16Field }))...)

	// field Struct.Uint32Field
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *uint32) (errs field.ErrorList) {
			if op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil // no changes
			}
			errs = append(errs, validate.Minimum(ctx, op, fldPath, obj, oldObj, 1)...)
			return
		}(fldPath.Child("uint32Field"), &obj.Uint32Field, safe.Field(oldObj, func(oldObj *Struct) *uint32 { return &oldObj.Uint32Field }))...)

	// field Struct.Uint64Field
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *uint64) (errs field.ErrorList) {
			if op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil // no changes
			}
			errs = append(errs, validate.Minimum(ctx, op, fldPath, obj, oldObj, 1)...)
			return
		}(fldPath.Child("uint64Field"), &obj.Uint64Field, safe.Field(oldObj, func(oldObj *Struct) *uint64 { return &oldObj.Uint64Field }))...)

	// field Struct.TypedefField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *IntType) (errs field.ErrorList) {
			if op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil // no changes
			}
			errs = append(errs, validate.Minimum(ctx, op, fldPath, obj, oldObj, 1)...)
			errs = append(errs, Validate_IntType(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("typedefField"), &obj.TypedefField, safe.Field(oldObj, func(oldObj *Struct) *IntType { return &oldObj.TypedefField }))...)

	// field Struct.TypedefPtrField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *IntType) (errs field.ErrorList) {
			if op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil // no changes
			}
			errs = append(errs, validate.Minimum(ctx, op, fldPath, obj, oldObj, 1)...)
			errs = append(errs, Validate_IntType(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("typedefPtrField"), obj.TypedefPtrField, safe.Field(oldObj, func(oldObj *Struct) *IntType { return oldObj.TypedefPtrField }))...)

	return errs
}
