/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.packaging.PyPackageVersion;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyPackageVersionNormalizer {
    @NotNull
    private static final String EPOCH_GROUP = "epoch";
    @NotNull
    private static final String RELEASE_GROUP = "release";
    @NotNull
    private static final String PRE_RELEASE_TYPE_GROUP = "pretype";
    @NotNull
    private static final String PRE_RELEASE_NUMBER_GROUP = "prenumber";
    @NotNull
    private static final String POST_RELEASE_TYPE_GROUP = "posttype";
    @NotNull
    private static final String POST_RELEASE_NUMBER_GROUP = "postnumber";
    @NotNull
    private static final String IMPLICIT_POST_RELEASE_NUMBER_GROUP = "implicitpostnumber";
    @NotNull
    private static final String DEV_RELEASE_TYPE_GROUP = "devtype";
    @NotNull
    private static final String DEV_RELEASE_NUMBER_GROUP = "devnumber";
    @NotNull
    private static final String LOCAL_VERSION_GROUP = "local";
    @NotNull
    private static final String SEP_REGEXP = "([\\.\\-_])?";
    @NotNull
    private static final String EPOCH_REGEXP = "(?<epoch>\\d+!)?";
    @NotNull
    private static final String RELEASE_REGEXP = "(?<release>(\\d+(\\.\\d+)*)|(\\d+\\.(\\d+\\.)*\\*))";
    @NotNull
    private static final String PRE_RELEASE_REGEXP = "(([\\.\\-_])?(?<pretype>a|alpha|b|beta|rc|c|pre|preview)(([\\.\\-_])?(?<prenumber>\\d+))?)?";
    @NotNull
    private static final String POST_RELEASE_REGEXP = "((([\\.\\-_])?(?<posttype>post|rev|r)(([\\.\\-_])?(?<postnumber>\\d+))?)|(-(?<implicitpostnumber>\\d+)))?";
    @NotNull
    private static final String DEV_RELEASE_REGEXP = "(([\\.\\-_])?(?<devtype>dev)(?<devnumber>\\d+)?)?";
    @NotNull
    private static final String LOCAL_VERSION_REGEXP = "(?<local>\\+[a-z0-9]([a-z0-9\\._-]*[a-z0-9])?)?";
    @NotNull
    private static final Pattern VERSION = Pattern.compile("^v?(?<epoch>\\d+!)?(?<release>(\\d+(\\.\\d+)*)|(\\d+\\.(\\d+\\.)*\\*))(([\\.\\-_])?(?<pretype>a|alpha|b|beta|rc|c|pre|preview)(([\\.\\-_])?(?<prenumber>\\d+))?)?((([\\.\\-_])?(?<posttype>post|rev|r)(([\\.\\-_])?(?<postnumber>\\d+))?)|(-(?<implicitpostnumber>\\d+)))?(([\\.\\-_])?(?<devtype>dev)(?<devnumber>\\d+)?)?(?<local>\\+[a-z0-9]([a-z0-9\\._-]*[a-z0-9])?)?$", 2);

    @Nullable
    public static PyPackageVersion normalize(@NotNull String version2) {
        Matcher matcher;
        if (version2 == null) {
            PyPackageVersionNormalizer.$$$reportNull$$$0(0);
        }
        if ((matcher = VERSION.matcher(version2)).matches()) {
            return new PyPackageVersion(PyPackageVersionNormalizer.normalizeEpoch(matcher), PyPackageVersionNormalizer.normalizeRelease(matcher), PyPackageVersionNormalizer.normalizePre(matcher), PyPackageVersionNormalizer.normalizePost(matcher), PyPackageVersionNormalizer.normalizeDev(matcher), PyPackageVersionNormalizer.normalizeLocal(matcher));
        }
        return null;
    }

    @Nullable
    private static String normalizeEpoch(@NotNull Matcher matcher) {
        String epoch;
        if (matcher == null) {
            PyPackageVersionNormalizer.$$$reportNull$$$0(1);
        }
        if ((epoch = matcher.group(EPOCH_GROUP)) != null) {
            return PyPackageVersionNormalizer.normalizeNumber(epoch.substring(0, epoch.length() - 1));
        }
        return null;
    }

    @NotNull
    private static String normalizeRelease(@NotNull Matcher matcher) {
        if (matcher == null) {
            PyPackageVersionNormalizer.$$$reportNull$$$0(2);
        }
        String string = StreamEx.of(StringUtil.tokenize((String)matcher.group(RELEASE_GROUP), (String)".").iterator()).map(releasePart -> releasePart.equals("*") ? "*" : PyPackageVersionNormalizer.normalizeNumber(releasePart)).joining((CharSequence)".");
        if (string == null) {
            PyPackageVersionNormalizer.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private static String normalizePre(@NotNull Matcher matcher) {
        String preReleaseType;
        if (matcher == null) {
            PyPackageVersionNormalizer.$$$reportNull$$$0(4);
        }
        if ((preReleaseType = matcher.group(PRE_RELEASE_TYPE_GROUP)) != null) {
            String preReleaseNumber = matcher.group(PRE_RELEASE_NUMBER_GROUP);
            String normalizedPreReleaseNumber = preReleaseNumber == null ? "0" : PyPackageVersionNormalizer.normalizeNumber(preReleaseNumber);
            return PyPackageVersionNormalizer.normalizePreReleaseType(preReleaseType) + normalizedPreReleaseNumber;
        }
        return null;
    }

    @Nullable
    private static String normalizePost(@NotNull Matcher matcher) {
        String postReleaseType;
        if (matcher == null) {
            PyPackageVersionNormalizer.$$$reportNull$$$0(5);
        }
        if ((postReleaseType = matcher.group(POST_RELEASE_TYPE_GROUP)) != null) {
            String postReleaseNumber = matcher.group(POST_RELEASE_NUMBER_GROUP);
            String normalizedPostReleaseNumber = postReleaseNumber == null ? "0" : PyPackageVersionNormalizer.normalizeNumber(postReleaseNumber);
            return "post" + PyPackageVersionNormalizer.normalizeNumber(normalizedPostReleaseNumber);
        }
        String implicitPostReleaseNumber = matcher.group(IMPLICIT_POST_RELEASE_NUMBER_GROUP);
        if (implicitPostReleaseNumber != null) {
            return "post" + PyPackageVersionNormalizer.normalizeNumber(implicitPostReleaseNumber);
        }
        return null;
    }

    @Nullable
    private static String normalizeDev(@NotNull Matcher matcher) {
        if (matcher == null) {
            PyPackageVersionNormalizer.$$$reportNull$$$0(6);
        }
        if (matcher.group(DEV_RELEASE_TYPE_GROUP) != null) {
            String devReleaseNumber = matcher.group(DEV_RELEASE_NUMBER_GROUP);
            String normalizedDevReleaseNumber = devReleaseNumber == null ? "0" : PyPackageVersionNormalizer.normalizeNumber(devReleaseNumber);
            return "dev" + normalizedDevReleaseNumber;
        }
        return null;
    }

    @Nullable
    private static String normalizeLocal(@NotNull Matcher matcher) {
        String localVersion;
        if (matcher == null) {
            PyPackageVersionNormalizer.$$$reportNull$$$0(7);
        }
        if ((localVersion = matcher.group(LOCAL_VERSION_GROUP)) != null) {
            return localVersion.substring(1).replaceAll("[-_]", ".");
        }
        return null;
    }

    @NotNull
    private static String normalizeNumber(@NotNull String number) {
        if (number == null) {
            PyPackageVersionNormalizer.$$$reportNull$$$0(8);
        }
        String string = new BigInteger(number).toString();
        if (string == null) {
            PyPackageVersionNormalizer.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String normalizePreReleaseType(@NotNull String preReleaseType) {
        if (preReleaseType == null) {
            PyPackageVersionNormalizer.$$$reportNull$$$0(10);
        }
        if (preReleaseType.equalsIgnoreCase("a") || preReleaseType.equalsIgnoreCase("alpha")) {
            return "a";
        }
        if (preReleaseType.equalsIgnoreCase("b") || preReleaseType.equalsIgnoreCase("beta")) {
            return "b";
        }
        return "rc";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPackageVersionNormalizer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preReleaseType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageVersionNormalizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeRelease";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "normalizeEpoch";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "normalizeRelease";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "normalizePre";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "normalizePost";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "normalizeDev";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "normalizeLocal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "normalizeNumber";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "normalizePreReleaseType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9 -> new IllegalStateException(string);
        };
    }
}

