/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl.layout;

import com.intellij.indexing.shared.platform.api.layout.SharedStubIndexLocation;
import com.intellij.indexing.shared.platform.impl.StubSharedIndexExtension;
import com.intellij.indexing.shared.platform.impl.layout.FileBasedSharedIndexLocation;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializationManagerImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.util.indexing.FileBasedIndexExtension;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0016J4\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u0001\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u0013H\u0016J\u0010\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0015H\u0016J\"\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\u00190\u000eH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/indexing/shared/platform/impl/layout/FileBasedSharedStubIndexLocation;", "Lcom/intellij/indexing/shared/platform/impl/layout/FileBasedSharedIndexLocation;", "", "Lcom/intellij/psi/stubs/SerializedStubTree;", "Lcom/intellij/indexing/shared/platform/api/layout/SharedStubIndexLocation;", "indexRoot", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "STUB_INDEX_IDS_FILENAME_LEGACY", "", "STUB_INDEX_IDS_FILENAME", "stubSerializerNamesStorageFile", "getStubIndexIds", "", "getIndex", "K", "V", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "tryLoadStubIndexKeyEnumerator", "Lcom/intellij/indexing/shared/platform/impl/StubSharedIndexExtension$UsageTrackingEnumerator;", "saveActuallyUsedStubIndexNames", "", "stubIndexKeyEnumerator", "Lkotlin/Pair;", "createSerializationManager", "Lcom/intellij/psi/stubs/SerializationManagerEx;", "readOnly", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "stubIndexIdsPath", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nFileBasedSharedStubIndexLocation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileBasedSharedStubIndexLocation.kt\ncom/intellij/indexing/shared/platform/impl/layout/FileBasedSharedStubIndexLocation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1563#2:97\n1634#2,3:98\n*S KotlinDebug\n*F\n+ 1 FileBasedSharedStubIndexLocation.kt\ncom/intellij/indexing/shared/platform/impl/layout/FileBasedSharedStubIndexLocation\n*L\n87#1:97\n87#1:98,3\n*E\n"})
public final class FileBasedSharedStubIndexLocation
extends FileBasedSharedIndexLocation<Integer, SerializedStubTree>
implements SharedStubIndexLocation {
    @NotNull
    private final String STUB_INDEX_IDS_FILENAME_LEGACY;
    @NotNull
    private final String STUB_INDEX_IDS_FILENAME;
    @NotNull
    private final Path stubSerializerNamesStorageFile;
    @NotNull
    private final Path stubIndexIdsPath;

    public FileBasedSharedStubIndexLocation(@NotNull Path indexRoot) {
        Intrinsics.checkNotNullParameter((Object)indexRoot, (String)"indexRoot");
        super(indexRoot);
        this.STUB_INDEX_IDS_FILENAME_LEGACY = "stubIndexIds.txt";
        this.STUB_INDEX_IDS_FILENAME = "stubIndexIds.csv";
        Path path = indexRoot.resolve("serializerNames").resolve("names");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.stubSerializerNamesStorageFile = path;
        Path path2 = indexRoot.resolve(this.STUB_INDEX_IDS_FILENAME);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        this.stubIndexIdsPath = path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<String> getStubIndexIds() {
        List<String> list;
        AutoCloseable autoCloseable = Files.list(this.getIndexRoot());
        Throwable throwable = null;
        try {
            Stream firs = (Stream)autoCloseable;
            boolean bl = false;
            List<String> list2 = firs.map(arg_0 -> FileBasedSharedStubIndexLocation.getStubIndexIds$lambda$2$lambda$1(FileBasedSharedStubIndexLocation::getStubIndexIds$lambda$2$lambda$0, arg_0)).toList();
            list = list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue(list, (String)"use(...)");
        return list;
    }

    @NotNull
    public <K, V> FileBasedSharedIndexLocation<K, V> getIndex(@NotNull FileBasedIndexExtension<K, V> extension) {
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        Path path = this.getIndexRoot().resolve(extension.getName().toString());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return new FileBasedSharedIndexLocation(path);
    }

    @Override
    @Nullable
    public StubSharedIndexExtension.UsageTrackingEnumerator<String> tryLoadStubIndexKeyEnumerator() {
        Path legacyStubIndexIdsPath = this.stubIndexIdsPath.getParent().resolve(this.STUB_INDEX_IDS_FILENAME_LEGACY);
        IOException legacyLoadException = null;
        if (Files.exists(legacyStubIndexIdsPath, new LinkOption[0])) {
            try {
                return StubSharedIndexExtension.UsageTrackingEnumerator.createFromLegacyTextFile(legacyStubIndexIdsPath);
            }
            catch (IOException e) {
                legacyLoadException = new IOException("Can't pre-initialize stubIndexIDs enumerator from " + legacyStubIndexIdsPath, e);
            }
        }
        if (Files.exists(this.stubIndexIdsPath, new LinkOption[0])) {
            try {
                return StubSharedIndexExtension.UsageTrackingEnumerator.createFromCsvFile(this.stubIndexIdsPath);
            }
            catch (IOException e) {
                UncheckedIOException exception = new UncheckedIOException("Can't pre-initialize stubIndexIDs enumerator from " + this.stubIndexIdsPath, e);
                if (legacyLoadException != null) {
                    ExceptionsKt.addSuppressed((Throwable)exception, (Throwable)legacyLoadException);
                }
                throw exception;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveActuallyUsedStubIndexNames(@NotNull List<Pair<Integer, String>> stubIndexKeyEnumerator) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(stubIndexKeyEnumerator, (String)"stubIndexKeyEnumerator");
        Iterable $this$map$iv = stubIndexKeyEnumerator;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int a = ((Number)pair.component1()).intValue();
            String b = (String)pair.component2();
            collection.add(a + "," + b);
        }
        List csvLines = (List)destination$iv$iv;
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE};
        Files.write(this.stubIndexIdsPath, (Iterable<? extends CharSequence>)csvLines, openOptionArray);
    }

    @Override
    @NotNull
    public SerializationManagerEx createSerializationManager(boolean readOnly, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        return (SerializationManagerEx)new SerializationManagerImpl(this.stubSerializerNamesStorageFile, readOnly, coroutineScope);
    }

    private static final String getStubIndexIds$lambda$2$lambda$0(Path dir) {
        return ((Object)dir.getFileName()).toString();
    }

    private static final String getStubIndexIds$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

