FIND_PATH(ILOG_ROOT_DIR
  NAMES cplex
  DOC "CPLEX STUDIO root directory"
  PATHS /opt/ibm/ILOG /usr/local/ibm/ILOG /usr/local/ILOG /usr/local/ilog
  PATHS "$ENV{HOME}/ILOG" "$ENV{HOME}/.local/ILOG"
  PATHS "$ENV{HOME}/ibm/ILOG" "$ENV{HOME}/.local/ibm/ILOG"
  PATHS "C:/Program Files/IBM/ILOG"
  PATH_SUFFIXES "CPLEX_Studio126" "CPLEX_Studio125"
  "CPLEX_Studio124" "CPLEX_Studio123" "CPLEX_Studio122"
  NO_DEFAULT_PATH
)

IF(WIN32)
  IF(MSVC_VERSION STREQUAL "1400")
    SET(ILOG_WIN_COMPILER "windows_vs2005")
  ELSEIF(MSVC_VERSION STREQUAL "1500")
    SET(ILOG_WIN_COMPILER "windows_vs2008")
  ELSEIF(MSVC_VERSION STREQUAL "1600")
    SET(ILOG_WIN_COMPILER "windows_vs2010")
  ELSE()
    SET(ILOG_WIN_COMPILER "windows_vs2008")
  ENDIF()
  IF(CMAKE_CL_64)
    SET(ILOG_WIN_COMPILER "x64_${ILOG_WIN_COMPILER}")
    SET(ILOG_WIN_PLATFORM "x64_win32")
  ELSE()
    SET(ILOG_WIN_COMPILER "x86_${ILOG_WIN_COMPILER}")
    SET(ILOG_WIN_PLATFORM "x86_win32")
  ENDIF()
ENDIF()

FIND_PATH(ILOG_CPLEX_ROOT_DIR
  NAMES include/ilcplex
  HINTS ${ILOG_ROOT_DIR}/cplex ${ILOG_ROOT_DIR}/cplex121
  ${ILOG_ROOT_DIR}/cplex122 ${ILOG_ROOT_DIR}/cplex123
  DOC "CPLEX root directory"
  NO_DEFAULT_PATH
)

FIND_PATH(ILOG_CONCERT_ROOT_DIR
  NAMES include/ilconcert
  HINTS ${ILOG_ROOT_DIR}/concert ${ILOG_ROOT_DIR}/concert29
  DOC "CONCERT root directory"
  NO_DEFAULT_PATH
)

FIND_PATH(ILOG_CPLEX_INCLUDE_DIR
  ilcplex/cplex.h
  HINTS ${ILOG_CPLEX_ROOT_DIR}/include
  NO_DEFAULT_PATH
)

FIND_PATH(ILOG_CONCERT_INCLUDE_DIR
  ilconcert/ilobasic.h
  HINTS ${ILOG_CONCERT_ROOT_DIR}/include
  NO_DEFAULT_PATH
)

FIND_LIBRARY(ILOG_CPLEX_LIBRARY
  cplex cplex121 cplex122 cplex123 cplex124
  HINTS ${ILOG_CPLEX_ROOT_DIR}/lib/x86_sles10_4.1/static_pic
  ${ILOG_CPLEX_ROOT_DIR}/lib/x86-64_sles10_4.1/static_pic
  ${ILOG_CPLEX_ROOT_DIR}/lib/x86_debian4.0_4.1/static_pic
  ${ILOG_CPLEX_ROOT_DIR}/lib/x86-64_debian4.0_4.1/static_pic
  ${ILOG_CPLEX_ROOT_DIR}/lib/${ILOG_WIN_COMPILER}/stat_mda
  NO_DEFAULT_PATH
  )

FIND_LIBRARY(ILOG_CONCERT_LIBRARY
  concert
  HINTS ${ILOG_CONCERT_ROOT_DIR}/lib/x86_sles10_4.1/static_pic
  ${ILOG_CONCERT_ROOT_DIR}/lib/x86-64_sles10_4.1/static_pic
  ${ILOG_CONCERT_ROOT_DIR}/lib/x86_debian4.0_4.1/static_pic
  ${ILOG_CONCERT_ROOT_DIR}/lib/x86-64_debian4.0_4.1/static_pic
  ${ILOG_CONCERT_ROOT_DIR}/lib/${ILOG_WIN_COMPILER}/stat_mda
  NO_DEFAULT_PATH
  )

FIND_FILE(ILOG_CPLEX_DLL
  cplex121.dll cplex122.dll cplex123.dll cplex124.dll
  HINTS ${ILOG_CPLEX_ROOT_DIR}/bin/${ILOG_WIN_PLATFORM}
  NO_DEFAULT_PATH
  )

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(ILOG
  DEFAULT_MSG ILOG_CPLEX_LIBRARY ILOG_CPLEX_INCLUDE_DIR
  )

IF(ILOG_FOUND)
  SET(ILOG_INCLUDE_DIRS ${ILOG_CPLEX_INCLUDE_DIR} ${ILOG_CONCERT_INCLUDE_DIR})
  SET(ILOG_LIBRARIES ${ILOG_CPLEX_LIBRARY} ${ILOG_CONCERT_LIBRARY})
  IF(CMAKE_SYSTEM_NAME STREQUAL "Linux")
    # SET(CPLEX_LIBRARIES "${CPLEX_LIBRARIES};m;pthread")
    SET(ILOG_LIBRARIES ${ILOG_LIBRARIES} "m" "pthread")
  ENDIF(CMAKE_SYSTEM_NAME STREQUAL "Linux")
ENDIF(ILOG_FOUND)

MARK_AS_ADVANCED(
  ILOG_CPLEX_LIBRARY ILOG_CPLEX_INCLUDE_DIR ILOG_CPLEX_DLL
  ILOG_CONCERT_LIBRARY ILOG_CONCERT_INCLUDE_DIR ILOG_CONCERT_DLL
  )
