/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.types;

import java.util.Arrays;
import java.util.Base64;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.types.PrimitiveType;
import org.openhab.core.types.State;

@NonNullByDefault
public class RawType
implements PrimitiveType,
State {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    protected byte[] bytes;
    protected String mimeType;

    public RawType(byte[] bytes, String mimeType) {
        if (mimeType.isEmpty()) {
            throw new IllegalArgumentException("mimeType argument must not be blank");
        }
        this.bytes = bytes;
        this.mimeType = mimeType;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static RawType valueOf(String value) {
        int idx;
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Argument must not be blank");
        }
        if (!value.startsWith("data:") || (idx = value.indexOf(",")) < 0) {
            throw new IllegalArgumentException("Invalid data URI syntax for argument " + value);
        }
        int idx2 = value.indexOf(";");
        if (idx2 <= 5) {
            throw new IllegalArgumentException("Missing MIME type in argument " + value);
        }
        return new RawType(Base64.getDecoder().decode(value.substring(idx + 1)), value.substring(5, idx2));
    }

    public String toString() {
        return String.format("raw type (%s): %d bytes", this.mimeType, this.bytes.length);
    }

    @Override
    public String toFullString() {
        return String.format("data:%s;base64,%s", this.mimeType, Base64.getEncoder().encodeToString(this.bytes));
    }

    @Override
    public String format(String pattern) {
        return this.toFullString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RawType other = (RawType)obj;
        if (!this.mimeType.equals(other.mimeType)) {
            return false;
        }
        return Arrays.equals(this.bytes, other.bytes);
    }
}

