/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.items;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.GenericItem;
import org.openhab.core.library.types.DateTimeType;
import org.openhab.core.library.types.StringType;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.TypeParser;
import org.openhab.core.types.UnDefType;

@NonNullByDefault
public class StringItem
extends GenericItem {
    private static final List<Class<? extends State>> ACCEPTED_DATA_TYPES = List.of(UnDefType.class, StringType.class, DateTimeType.class);
    private static final List<Class<? extends Command>> ACCEPTED_COMMAND_TYPES = List.of(StringType.class, RefreshType.class);

    public StringItem(String name) {
        super("String", name);
    }

    public void send(StringType command) {
        this.internalSend(command, null);
    }

    public void send(StringType command, @Nullable String source) {
        this.internalSend(command, source);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return ACCEPTED_DATA_TYPES;
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return ACCEPTED_COMMAND_TYPES;
    }

    @Override
    public <T extends State> @Nullable T getStateAs(Class<T> typeClass) {
        ArrayList<Class<? extends State>> list = new ArrayList<Class<? extends State>>();
        list.add(typeClass);
        State convertedState = TypeParser.parseState(list, this.state.toString());
        if (typeClass.isInstance(convertedState)) {
            return (T)((State)typeClass.cast(convertedState));
        }
        return super.getStateAs(typeClass);
    }

    @Override
    public void setState(State state, @Nullable String source) {
        if (this.isAcceptedState(ACCEPTED_DATA_TYPES, state)) {
            this.applyState(state, source);
        } else {
            this.logSetTypeError(state);
        }
    }

    @Override
    public void setTimeSeries(TimeSeries timeSeries) {
        if (timeSeries.getStates().allMatch(s -> s.state() instanceof StringType)) {
            this.applyTimeSeries(timeSeries);
        } else {
            this.logSetTypeError(timeSeries);
        }
    }
}

