/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.net.InetAddress;
import java.util.Set;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.HostInfo;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSConstants;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSQuestion
extends DNSEntry {
    protected final Logger logger = LoggerFactory.getLogger(DNSQuestion.class);

    boolean processHostMatch(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
        HostInfo hostInfo = jmDNSImpl.getLocalHost();
        String localHostName = hostInfo.getName();
        if (!localHostName.equalsIgnoreCase(this.getName())) {
            return false;
        }
        answers.addAll(hostInfo.answers(this.getRecordClass(), this.isUnique(), DNSConstants.DNS_TTL));
        return true;
    }

    DNSQuestion(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
        super(name, type, recordClass, unique);
    }

    public static DNSQuestion newQuestion(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
        switch (type) {
            case TYPE_A: {
                return new DNS4Address(name, type, recordClass, unique);
            }
            case TYPE_A6: 
            case TYPE_AAAA: {
                return new DNS6Address(name, type, recordClass, unique);
            }
            case TYPE_ANY: {
                return new AllRecords(name, type, recordClass, unique);
            }
            case TYPE_HINFO: {
                return new HostInformation(name, type, recordClass, unique);
            }
            case TYPE_PTR: {
                return new Pointer(name, type, recordClass, unique);
            }
            case TYPE_SRV: {
                return new Service(name, type, recordClass, unique);
            }
            case TYPE_TXT: {
                return new Text(name, type, recordClass, unique);
            }
        }
        return new DNSQuestion(name, type, recordClass, unique);
    }

    boolean answeredBy(DNSEntry rec) {
        return this.isSameRecordClass(rec) && this.isSameType(rec) && this.getName().equals(rec.getName());
    }

    public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
    }

    protected void addAnswersForServiceInfo(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers, ServiceInfoImpl info) {
        if (info != null && info.isAnnounced()) {
            if (this.getName().equalsIgnoreCase(info.getQualifiedName()) || this.getName().equalsIgnoreCase(info.getType()) || this.getName().equalsIgnoreCase(info.getTypeWithSubtype())) {
                answers.addAll(jmDNSImpl.getLocalHost().answers(this.getRecordClass(), true, DNSConstants.DNS_TTL));
                answers.addAll(info.answers(this.getRecordClass(), true, DNSConstants.DNS_TTL, jmDNSImpl.getLocalHost(), this.getSubtype()));
            }
            this.logger.debug("{} DNSQuestion({}).addAnswersForServiceInfo(): info: {}\n{}", new Object[]{jmDNSImpl.getName(), this.getName(), info, answers});
        }
    }

    @Override
    public boolean isStale(long now) {
        return false;
    }

    @Override
    public boolean isExpired(long now) {
        return false;
    }

    public boolean iAmTheOnlyOne(JmDNSImpl jmDNSImpl) {
        return false;
    }

    @Override
    public void toString(StringBuilder sb) {
    }

    private static class AllRecords
    extends DNSQuestion {
        AllRecords(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public boolean isSameType(DNSEntry entry) {
            return entry != null;
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
            if (this.processHostMatch(jmDNSImpl, answers)) {
                return;
            }
            String lowerCaseName = this.getName().toLowerCase();
            if (jmDNSImpl.getServiceTypes().containsKey(lowerCaseName)) {
                Pointer question = new Pointer(this.getName(), DNSRecordType.TYPE_PTR, this.getRecordClass(), this.isUnique());
                ((DNSQuestion)question).addAnswers(jmDNSImpl, answers);
                return;
            }
            for (ServiceInfo serviceInfo : jmDNSImpl.getServices().values()) {
                this.addAnswersForServiceInfo(jmDNSImpl, answers, (ServiceInfoImpl)serviceInfo);
            }
        }

        @Override
        public boolean iAmTheOnlyOne(JmDNSImpl jmDNSImpl) {
            String name = this.getName().toLowerCase();
            return jmDNSImpl.getLocalHost().getName().equals(name) || jmDNSImpl.getServices().containsKey(name);
        }
    }

    private static class Text
    extends DNSQuestion {
        Text(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
            this.addAnswersForServiceInfo(jmDNSImpl, answers, (ServiceInfoImpl)jmDNSImpl.getServices().get(this.getName().toLowerCase()));
        }

        @Override
        public boolean iAmTheOnlyOne(JmDNSImpl jmDNSImpl) {
            String name = this.getName().toLowerCase();
            return jmDNSImpl.getLocalHost().getName().equals(name) || jmDNSImpl.getServices().containsKey(name);
        }
    }

    private static class Service
    extends DNSQuestion {
        Service(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
            if (this.processHostMatch(jmDNSImpl, answers)) {
                return;
            }
            String lowerCaseName = this.getName().toLowerCase();
            if (jmDNSImpl.getServiceTypes().containsKey(lowerCaseName)) {
                Pointer question = new Pointer(this.getName(), DNSRecordType.TYPE_PTR, this.getRecordClass(), this.isUnique());
                ((DNSQuestion)question).addAnswers(jmDNSImpl, answers);
                return;
            }
            this.addAnswersForServiceInfo(jmDNSImpl, answers, (ServiceInfoImpl)jmDNSImpl.getServices().get(lowerCaseName));
        }

        @Override
        public boolean iAmTheOnlyOne(JmDNSImpl jmDNSImpl) {
            String name = this.getName().toLowerCase();
            return jmDNSImpl.getLocalHost().getName().equals(name) || jmDNSImpl.getServices().containsKey(name);
        }
    }

    private static class Pointer
    extends DNSQuestion {
        Pointer(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
            for (ServiceInfo serviceInfo : jmDNSImpl.getServices().values()) {
                this.addAnswersForServiceInfo(jmDNSImpl, answers, (ServiceInfoImpl)serviceInfo);
            }
            if (this.isServicesDiscoveryMetaQuery()) {
                for (JmDNSImpl.ServiceTypeEntry typeEntry : jmDNSImpl.getServiceTypes().values()) {
                    answers.add(new DNSRecord.Pointer("_services._dns-sd._udp.local.", DNSRecordClass.CLASS_IN, false, DNSConstants.DNS_TTL, typeEntry.getType()));
                }
            } else if (this.isReverseLookup()) {
                String ipValue = this.getQualifiedNameMap().get((Object)ServiceInfo.Fields.Instance);
                if (ipValue != null && !ipValue.isEmpty()) {
                    String hostIPAddress;
                    InetAddress address = jmDNSImpl.getLocalHost().getInetAddress();
                    String string = hostIPAddress = address != null ? address.getHostAddress() : "";
                    if (ipValue.equalsIgnoreCase(hostIPAddress)) {
                        if (this.isV4ReverseLookup()) {
                            answers.add(jmDNSImpl.getLocalHost().getDNSReverseAddressRecord(DNSRecordType.TYPE_A, false, DNSConstants.DNS_TTL));
                        }
                        if (this.isV6ReverseLookup()) {
                            answers.add(jmDNSImpl.getLocalHost().getDNSReverseAddressRecord(DNSRecordType.TYPE_AAAA, false, DNSConstants.DNS_TTL));
                        }
                    }
                }
            } else if (this.isDomainDiscoveryQuery()) {
                this.logger.debug("Domain Discovery Query not implemented yet");
            }
        }
    }

    private static class HostInformation
    extends DNSQuestion {
        HostInformation(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }
    }

    private static class DNS6Address
    extends DNSQuestion {
        DNS6Address(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
            if (this.processHostMatch(jmDNSImpl, answers)) {
                return;
            }
            DNSRecord.Address answer = jmDNSImpl.getLocalHost().getDNSAddressRecord(this.getRecordType(), true, DNSConstants.DNS_TTL);
            if (answer != null) {
                answers.add(answer);
            }
        }

        @Override
        public boolean iAmTheOnlyOne(JmDNSImpl jmDNSImpl) {
            String name = this.getName().toLowerCase();
            return jmDNSImpl.getLocalHost().getName().equals(name) || jmDNSImpl.getServices().containsKey(name);
        }
    }

    private static class DNS4Address
    extends DNSQuestion {
        DNS4Address(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> answers) {
            if (this.processHostMatch(jmDNSImpl, answers)) {
                return;
            }
            DNSRecord.Address answer = jmDNSImpl.getLocalHost().getDNSAddressRecord(this.getRecordType(), true, DNSConstants.DNS_TTL);
            if (answer != null) {
                answers.add(answer);
            }
        }

        @Override
        public boolean iAmTheOnlyOne(JmDNSImpl jmDNSImpl) {
            String name = this.getName().toLowerCase();
            return jmDNSImpl.getLocalHost().getName().equals(name) || jmDNSImpl.getServices().containsKey(name);
        }
    }
}

