/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.LocaleUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class ASN1GeneralizedTime
extends ASN1Primitive {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1GeneralizedTime.class, 24){

        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1GeneralizedTime.createPrimitive(dEROctetString.getOctets());
        }
    };
    final byte[] contents;

    public static ASN1GeneralizedTime getInstance(Object object) {
        ASN1Primitive aSN1Primitive;
        if (object == null || object instanceof ASN1GeneralizedTime) {
            return (ASN1GeneralizedTime)object;
        }
        if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1GeneralizedTime) {
            return (ASN1GeneralizedTime)aSN1Primitive;
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1GeneralizedTime)TYPE.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1GeneralizedTime getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1GeneralizedTime)TYPE.getContextInstance(aSN1TaggedObject, bl);
    }

    public ASN1GeneralizedTime(String string2) {
        this.contents = Strings.toByteArray(string2);
        try {
            this.getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("invalid date string: " + parseException.getMessage());
        }
    }

    public ASN1GeneralizedTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'", LocaleUtil.EN_Locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.contents = Strings.toByteArray(simpleDateFormat.format(date));
    }

    public ASN1GeneralizedTime(Date date, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'", locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.contents = Strings.toByteArray(simpleDateFormat.format(date));
    }

    ASN1GeneralizedTime(byte[] byArray) {
        if (byArray.length < 4) {
            throw new IllegalArgumentException("GeneralizedTime string too short");
        }
        this.contents = byArray;
        if (!(this.isDigit(0) && this.isDigit(1) && this.isDigit(2) && this.isDigit(3))) {
            throw new IllegalArgumentException("illegal characters in GeneralizedTime string");
        }
    }

    public String getTimeString() {
        return Strings.fromByteArray(this.contents);
    }

    public String getTime() {
        String string2 = Strings.fromByteArray(this.contents);
        if (string2.charAt(string2.length() - 1) == 'Z') {
            return string2.substring(0, string2.length() - 1) + "GMT+00:00";
        }
        int n = string2.length() - 6;
        char c = string2.charAt(n);
        if ((c == '-' || c == '+') && string2.indexOf("GMT") == n - 3) {
            return string2;
        }
        n = string2.length() - 5;
        c = string2.charAt(n);
        if (c == '-' || c == '+') {
            return string2.substring(0, n) + "GMT" + string2.substring(n, n + 3) + ":" + string2.substring(n + 3);
        }
        n = string2.length() - 3;
        c = string2.charAt(n);
        if (c == '-' || c == '+') {
            return string2.substring(0, n) + "GMT" + string2.substring(n) + ":00";
        }
        return string2 + this.calculateGMTOffset(string2);
    }

    private String calculateGMTOffset(String string2) {
        String string3 = "+";
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset();
        if (n < 0) {
            string3 = "-";
            n = -n;
        }
        int n2 = n / 3600000;
        int n3 = (n - n2 * 60 * 60 * 1000) / 60000;
        try {
            if (timeZone.useDaylightTime()) {
                SimpleDateFormat simpleDateFormat;
                if (this.hasFractionalSeconds()) {
                    string2 = this.pruneFractionalSeconds(string2);
                }
                if (timeZone.inDaylightTime((simpleDateFormat = this.calculateGMTDateFormat()).parse(string2 + "GMT" + string3 + this.convert(n2) + ":" + this.convert(n3)))) {
                    n2 += string3.equals("+") ? 1 : -1;
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return "GMT" + string3 + this.convert(n2) + ":" + this.convert(n3);
    }

    private SimpleDateFormat calculateGMTDateFormat() {
        SimpleDateFormat simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSSz") : (this.hasSeconds() ? new SimpleDateFormat("yyyyMMddHHmmssz") : (this.hasMinutes() ? new SimpleDateFormat("yyyyMMddHHmmz") : new SimpleDateFormat("yyyyMMddHHz")));
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        return simpleDateFormat;
    }

    private String pruneFractionalSeconds(String string2) {
        char c;
        int n;
        String string3 = string2.substring(14);
        for (n = 1; n < string3.length() && '0' <= (c = string3.charAt(n)) && c <= '9'; ++n) {
        }
        if (n - 1 > 3) {
            string3 = string3.substring(0, 4) + string3.substring(n);
            string2 = string2.substring(0, 14) + string3;
        } else if (n - 1 == 1) {
            string3 = string3.substring(0, n) + "00" + string3.substring(n);
            string2 = string2.substring(0, 14) + string3;
        } else if (n - 1 == 2) {
            string3 = string3.substring(0, n) + "0" + string3.substring(n);
            string2 = string2.substring(0, 14) + string3;
        }
        return string2;
    }

    private String convert(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return Integer.toString(n);
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat simpleDateFormat;
        String string2;
        String string3 = string2 = Strings.fromByteArray(this.contents);
        if (string2.endsWith("Z")) {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'", LocaleUtil.EN_Locale) : (this.hasSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss'Z'", LocaleUtil.EN_Locale) : (this.hasMinutes() ? new SimpleDateFormat("yyyyMMddHHmm'Z'", LocaleUtil.EN_Locale) : new SimpleDateFormat("yyyyMMddHH'Z'", LocaleUtil.EN_Locale)));
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else if (string2.indexOf(45) > 0 || string2.indexOf(43) > 0) {
            string3 = this.getTime();
            simpleDateFormat = this.calculateGMTDateFormat();
        } else {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS") : (this.hasSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss") : (this.hasMinutes() ? new SimpleDateFormat("yyyyMMddHHmm") : new SimpleDateFormat("yyyyMMddHH")));
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, TimeZone.getDefault().getID()));
        }
        if (this.hasFractionalSeconds()) {
            string3 = this.pruneFractionalSeconds(string3);
        }
        return simpleDateFormat.parse(string3);
    }

    protected boolean hasFractionalSeconds() {
        for (int i = 0; i != this.contents.length; ++i) {
            if (this.contents[i] != 46 || i != 14) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSeconds() {
        return this.isDigit(12) && this.isDigit(13);
    }

    protected boolean hasMinutes() {
        return this.isDigit(10) && this.isDigit(11);
    }

    private boolean isDigit(int n) {
        return this.contents.length > n && this.contents[n] >= 48 && this.contents[n] <= 57;
    }

    final boolean encodeConstructed() {
        return false;
    }

    int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 24, this.contents);
    }

    ASN1Primitive toDERObject() {
        return new DERGeneralizedTime(this.contents);
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1GeneralizedTime)) {
            return false;
        }
        return Arrays.areEqual(this.contents, ((ASN1GeneralizedTime)aSN1Primitive).contents);
    }

    public int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static ASN1GeneralizedTime createPrimitive(byte[] byArray) {
        return new ASN1GeneralizedTime(byArray);
    }
}

