// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// @generated by protoc-gen-es v2.6.0 with parameter "target=js+dts,import_extension=none,json_types=true"
// @generated from file buf/validate/validate.proto (package buf.validate, syntax proto2)
/* eslint-disable */

import type { GenEnum, GenExtension, GenFile, GenMessage } from "@bufbuild/protobuf/codegenv2";
import type { Message } from "@bufbuild/protobuf";
import type { Duration, DurationJson, FieldDescriptorProto_Type, FieldDescriptorProto_TypeJson, FieldOptions, MessageOptions, OneofOptions, Timestamp, TimestampJson } from "@bufbuild/protobuf/wkt";

/**
 * Describes the file buf/validate/validate.proto.
 */
export declare const file_buf_validate_validate: GenFile;

/**
 * `Rule` represents a validation rule written in the Common Expression
 * Language (CEL) syntax. Each Rule includes a unique identifier, an
 * optional error message, and the CEL expression to evaluate. For more
 * information, [see our documentation](https://buf.build/docs/protovalidate/schemas/custom-rules/).
 *
 * ```proto
 * message Foo {
 *   option (buf.validate.message).cel = {
 *     id: "foo.bar"
 *     message: "bar must be greater than 0"
 *     expression: "this.bar > 0"
 *   };
 *   int32 bar = 1;
 * }
 * ```
 *
 * @generated from message buf.validate.Rule
 */
export declare type Rule = Message<"buf.validate.Rule"> & {
  /**
   * `id` is a string that serves as a machine-readable name for this Rule.
   * It should be unique within its scope, which could be either a message or a field.
   *
   * @generated from field: optional string id = 1;
   */
  id: string;

  /**
   * `message` is an optional field that provides a human-readable error message
   * for this Rule when the CEL expression evaluates to false. If a
   * non-empty message is provided, any strings resulting from the CEL
   * expression evaluation are ignored.
   *
   * @generated from field: optional string message = 2;
   */
  message: string;

  /**
   * `expression` is the actual CEL expression that will be evaluated for
   * validation. This string must resolve to either a boolean or a string
   * value. If the expression evaluates to false or a non-empty string, the
   * validation is considered failed, and the message is rejected.
   *
   * @generated from field: optional string expression = 3;
   */
  expression: string;
};

/**
 * `Rule` represents a validation rule written in the Common Expression
 * Language (CEL) syntax. Each Rule includes a unique identifier, an
 * optional error message, and the CEL expression to evaluate. For more
 * information, [see our documentation](https://buf.build/docs/protovalidate/schemas/custom-rules/).
 *
 * ```proto
 * message Foo {
 *   option (buf.validate.message).cel = {
 *     id: "foo.bar"
 *     message: "bar must be greater than 0"
 *     expression: "this.bar > 0"
 *   };
 *   int32 bar = 1;
 * }
 * ```
 *
 * @generated from message buf.validate.Rule
 */
export declare type RuleJson = {
  /**
   * `id` is a string that serves as a machine-readable name for this Rule.
   * It should be unique within its scope, which could be either a message or a field.
   *
   * @generated from field: optional string id = 1;
   */
  id?: string;

  /**
   * `message` is an optional field that provides a human-readable error message
   * for this Rule when the CEL expression evaluates to false. If a
   * non-empty message is provided, any strings resulting from the CEL
   * expression evaluation are ignored.
   *
   * @generated from field: optional string message = 2;
   */
  message?: string;

  /**
   * `expression` is the actual CEL expression that will be evaluated for
   * validation. This string must resolve to either a boolean or a string
   * value. If the expression evaluates to false or a non-empty string, the
   * validation is considered failed, and the message is rejected.
   *
   * @generated from field: optional string expression = 3;
   */
  expression?: string;
};

/**
 * Describes the message buf.validate.Rule.
 * Use `create(RuleSchema)` to create a new message.
 */
export declare const RuleSchema: GenMessage<Rule, {jsonType: RuleJson}>;

/**
 * MessageRules represents validation rules that are applied to the entire message.
 * It includes disabling options and a list of Rule messages representing Common Expression Language (CEL) validation rules.
 *
 * @generated from message buf.validate.MessageRules
 */
export declare type MessageRules = Message<"buf.validate.MessageRules"> & {
  /**
   * `disabled` is a boolean flag that, when set to true, nullifies any validation rules for this message.
   * This includes any fields within the message that would otherwise support validation.
   *
   * ```proto
   * message MyMessage {
   *   // validation will be bypassed for this message
   *   option (buf.validate.message).disabled = true;
   * }
   * ```
   *
   * @generated from field: optional bool disabled = 1;
   */
  disabled: boolean;

  /**
   * `cel` is a repeated field of type Rule. Each Rule specifies a validation rule to be applied to this message.
   * These rules are written in Common Expression Language (CEL) syntax. For more information,
   * [see our documentation](https://buf.build/docs/protovalidate/schemas/custom-rules/).
   *
   *
   * ```proto
   * message MyMessage {
   *   // The field `foo` must be greater than 42.
   *   option (buf.validate.message).cel = {
   *     id: "my_message.value",
   *     message: "value must be greater than 42",
   *     expression: "this.foo > 42",
   *   };
   *   optional int32 foo = 1;
   * }
   * ```
   *
   * @generated from field: repeated buf.validate.Rule cel = 3;
   */
  cel: Rule[];

  /**
   * `oneof` is a repeated field of type MessageOneofRule that specifies a list of fields
   * of which at most one can be present. If `required` is also specified, then exactly one
   * of the specified fields _must_ be present.
   *
   * This will enforce oneof-like constraints with a few features not provided by
   * actual Protobuf oneof declarations:
   *   1. Repeated and map fields are allowed in this validation. In a Protobuf oneof,
   *      only scalar fields are allowed.
   *   2. Fields with implicit presence are allowed. In a Protobuf oneof, all member
   *      fields have explicit presence. This means that, for the purpose of determining
   *      how many fields are set, explicitly setting such a field to its zero value is
   *      effectively the same as not setting it at all.
   *   3. This will always generate validation errors for a message unmarshalled from
   *      serialized data that sets more than one field. With a Protobuf oneof, when
   *      multiple fields are present in the serialized form, earlier values are usually
   *      silently ignored when unmarshalling, with only the last field being set when
   *      unmarshalling completes.
   *
   * Note that adding a field to a `oneof` will also set the IGNORE_IF_UNPOPULATED on the fields. This means
   * only the field that is set will be validated and the unset fields are not validated according to the field rules.
   * This behavior can be overridden by setting `ignore` against a field.
   *
   * ```proto
   * message MyMessage {
   *   // Only one of `field1` or `field2` _can_ be present in this message.
   *   option (buf.validate.message).oneof = { fields: ["field1", "field2"] };
   *   // Exactly one of `field3` or `field4` _must_ be present in this message.
   *   option (buf.validate.message).oneof = { fields: ["field3", "field4"], required: true };
   *   string field1 = 1;
   *   bytes field2 = 2;
   *   bool field3 = 3;
   *   int32 field4 = 4;
   * }
   * ```
   *
   * @generated from field: repeated buf.validate.MessageOneofRule oneof = 4;
   */
  oneof: MessageOneofRule[];
};

/**
 * MessageRules represents validation rules that are applied to the entire message.
 * It includes disabling options and a list of Rule messages representing Common Expression Language (CEL) validation rules.
 *
 * @generated from message buf.validate.MessageRules
 */
export declare type MessageRulesJson = {
  /**
   * `disabled` is a boolean flag that, when set to true, nullifies any validation rules for this message.
   * This includes any fields within the message that would otherwise support validation.
   *
   * ```proto
   * message MyMessage {
   *   // validation will be bypassed for this message
   *   option (buf.validate.message).disabled = true;
   * }
   * ```
   *
   * @generated from field: optional bool disabled = 1;
   */
  disabled?: boolean;

  /**
   * `cel` is a repeated field of type Rule. Each Rule specifies a validation rule to be applied to this message.
   * These rules are written in Common Expression Language (CEL) syntax. For more information,
   * [see our documentation](https://buf.build/docs/protovalidate/schemas/custom-rules/).
   *
   *
   * ```proto
   * message MyMessage {
   *   // The field `foo` must be greater than 42.
   *   option (buf.validate.message).cel = {
   *     id: "my_message.value",
   *     message: "value must be greater than 42",
   *     expression: "this.foo > 42",
   *   };
   *   optional int32 foo = 1;
   * }
   * ```
   *
   * @generated from field: repeated buf.validate.Rule cel = 3;
   */
  cel?: RuleJson[];

  /**
   * `oneof` is a repeated field of type MessageOneofRule that specifies a list of fields
   * of which at most one can be present. If `required` is also specified, then exactly one
   * of the specified fields _must_ be present.
   *
   * This will enforce oneof-like constraints with a few features not provided by
   * actual Protobuf oneof declarations:
   *   1. Repeated and map fields are allowed in this validation. In a Protobuf oneof,
   *      only scalar fields are allowed.
   *   2. Fields with implicit presence are allowed. In a Protobuf oneof, all member
   *      fields have explicit presence. This means that, for the purpose of determining
   *      how many fields are set, explicitly setting such a field to its zero value is
   *      effectively the same as not setting it at all.
   *   3. This will always generate validation errors for a message unmarshalled from
   *      serialized data that sets more than one field. With a Protobuf oneof, when
   *      multiple fields are present in the serialized form, earlier values are usually
   *      silently ignored when unmarshalling, with only the last field being set when
   *      unmarshalling completes.
   *
   * Note that adding a field to a `oneof` will also set the IGNORE_IF_UNPOPULATED on the fields. This means
   * only the field that is set will be validated and the unset fields are not validated according to the field rules.
   * This behavior can be overridden by setting `ignore` against a field.
   *
   * ```proto
   * message MyMessage {
   *   // Only one of `field1` or `field2` _can_ be present in this message.
   *   option (buf.validate.message).oneof = { fields: ["field1", "field2"] };
   *   // Exactly one of `field3` or `field4` _must_ be present in this message.
   *   option (buf.validate.message).oneof = { fields: ["field3", "field4"], required: true };
   *   string field1 = 1;
   *   bytes field2 = 2;
   *   bool field3 = 3;
   *   int32 field4 = 4;
   * }
   * ```
   *
   * @generated from field: repeated buf.validate.MessageOneofRule oneof = 4;
   */
  oneof?: MessageOneofRuleJson[];
};

/**
 * Describes the message buf.validate.MessageRules.
 * Use `create(MessageRulesSchema)` to create a new message.
 */
export declare const MessageRulesSchema: GenMessage<MessageRules, {jsonType: MessageRulesJson}>;

/**
 * @generated from message buf.validate.MessageOneofRule
 */
export declare type MessageOneofRule = Message<"buf.validate.MessageOneofRule"> & {
  /**
   * A list of field names to include in the oneof. All field names must be
   * defined in the message. At least one field must be specified, and
   * duplicates are not permitted.
   *
   * @generated from field: repeated string fields = 1;
   */
  fields: string[];

  /**
   * If true, one of the fields specified _must_ be set.
   *
   * @generated from field: optional bool required = 2;
   */
  required: boolean;
};

/**
 * @generated from message buf.validate.MessageOneofRule
 */
export declare type MessageOneofRuleJson = {
  /**
   * A list of field names to include in the oneof. All field names must be
   * defined in the message. At least one field must be specified, and
   * duplicates are not permitted.
   *
   * @generated from field: repeated string fields = 1;
   */
  fields?: string[];

  /**
   * If true, one of the fields specified _must_ be set.
   *
   * @generated from field: optional bool required = 2;
   */
  required?: boolean;
};

/**
 * Describes the message buf.validate.MessageOneofRule.
 * Use `create(MessageOneofRuleSchema)` to create a new message.
 */
export declare const MessageOneofRuleSchema: GenMessage<MessageOneofRule, {jsonType: MessageOneofRuleJson}>;

/**
 * The `OneofRules` message type enables you to manage rules for
 * oneof fields in your protobuf messages.
 *
 * @generated from message buf.validate.OneofRules
 */
export declare type OneofRules = Message<"buf.validate.OneofRules"> & {
  /**
   * If `required` is true, exactly one field of the oneof must be set. A
   * validation error is returned if no fields in the oneof are set. Further rules
   * should be placed on the fields themselves to ensure they are valid values,
   * such as `min_len` or `gt`.
   *
   * ```proto
   * message MyMessage {
   *   oneof value {
   *     // Either `a` or `b` must be set. If `a` is set, it must also be
   *     // non-empty; whereas if `b` is set, it can still be an empty string.
   *     option (buf.validate.oneof).required = true;
   *     string a = 1 [(buf.validate.field).string.min_len = 1];
   *     string b = 2;
   *   }
   * }
   * ```
   *
   * @generated from field: optional bool required = 1;
   */
  required: boolean;
};

/**
 * The `OneofRules` message type enables you to manage rules for
 * oneof fields in your protobuf messages.
 *
 * @generated from message buf.validate.OneofRules
 */
export declare type OneofRulesJson = {
  /**
   * If `required` is true, exactly one field of the oneof must be set. A
   * validation error is returned if no fields in the oneof are set. Further rules
   * should be placed on the fields themselves to ensure they are valid values,
   * such as `min_len` or `gt`.
   *
   * ```proto
   * message MyMessage {
   *   oneof value {
   *     // Either `a` or `b` must be set. If `a` is set, it must also be
   *     // non-empty; whereas if `b` is set, it can still be an empty string.
   *     option (buf.validate.oneof).required = true;
   *     string a = 1 [(buf.validate.field).string.min_len = 1];
   *     string b = 2;
   *   }
   * }
   * ```
   *
   * @generated from field: optional bool required = 1;
   */
  required?: boolean;
};

/**
 * Describes the message buf.validate.OneofRules.
 * Use `create(OneofRulesSchema)` to create a new message.
 */
export declare const OneofRulesSchema: GenMessage<OneofRules, {jsonType: OneofRulesJson}>;

/**
 * FieldRules encapsulates the rules for each type of field. Depending on
 * the field, the correct set should be used to ensure proper validations.
 *
 * @generated from message buf.validate.FieldRules
 */
export declare type FieldRules = Message<"buf.validate.FieldRules"> & {
  /**
   * `cel` is a repeated field used to represent a textual expression
   * in the Common Expression Language (CEL) syntax. For more information,
   * [see our documentation](https://buf.build/docs/protovalidate/schemas/custom-rules/).
   *
   * ```proto
   * message MyMessage {
   *   // The field `value` must be greater than 42.
   *   optional int32 value = 1 [(buf.validate.field).cel = {
   *     id: "my_message.value",
   *     message: "value must be greater than 42",
   *     expression: "this > 42",
   *   }];
   * }
   * ```
   *
   * @generated from field: repeated buf.validate.Rule cel = 23;
   */
  cel: Rule[];

  /**
   * If `required` is true, the field must be set. A validation error is returned
   * if the field is not set.
   *
   * ```proto
   * syntax="proto3";
   *
   * message FieldsWithPresence {
   *   // Requires any string to be set, including the empty string.
   *   optional string link = 1 [
   *     (buf.validate.field).required = true
   *   ];
   *   // Requires true or false to be set.
   *   optional bool disabled = 2 [
   *     (buf.validate.field).required = true
   *   ];
   *   // Requires a message to be set, including the empty message.
   *   SomeMessage msg = 4 [
   *     (buf.validate.field).required = true
   *   ];
   * }
   * ```
   *
   * All fields in the example above track presence. By default, Protovalidate
   * ignores rules on those fields if no value is set. `required` ensures that
   * the fields are set and valid.
   *
   * Fields that don't track presence are always validated by Protovalidate,
   * whether they are set or not. It is not necessary to add `required`:
   *
   * ```proto
   * syntax="proto3";
   *
   * message FieldsWithoutPresence {
   *   // `string.email` always applies, even to an empty string.
   *   string link = 1 [
   *     (buf.validate.field).string.email = true
   *   ];
   *   // `repeated.min_items` always applies, even to an empty list.
   *   repeated string labels = 4 [
   *     (buf.validate.field).repeated.min_items = 1
   *   ];
   * }
   * ```
   *
   * To learn which fields track presence, see the
   * [Field Presence cheat sheet](https://protobuf.dev/programming-guides/field_presence/#cheat).
   *
   * Note: While field rules can be applied to repeated items, map keys, and map
   * values, the elements are always considered to be set. Consequently,
   * specifying `repeated.items.required` is redundant.
   *
   * @generated from field: optional bool required = 25;
   */
  required: boolean;

  /**
   * Ignore validation rules on the field if its value matches the specified
   * criteria. See the `Ignore` enum for details.
   *
   * ```proto
   * message UpdateRequest {
   *   // The uri rule only applies if the field is populated and not an empty
   *   // string.
   *   optional string url = 1 [
   *     (buf.validate.field).ignore = IGNORE_IF_DEFAULT_VALUE,
   *     (buf.validate.field).string.uri = true
   *   ];
   * }
   * ```
   *
   * @generated from field: optional buf.validate.Ignore ignore = 27;
   */
  ignore: Ignore;

  /**
   * @generated from oneof buf.validate.FieldRules.type
   */
  type: {
    /**
     * Scalar Field Types
     *
     * @generated from field: buf.validate.FloatRules float = 1;
     */
    value: FloatRules;
    case: "float";
  } | {
    /**
     * @generated from field: buf.validate.DoubleRules double = 2;
     */
    value: DoubleRules;
    case: "double";
  } | {
    /**
     * @generated from field: buf.validate.Int32Rules int32 = 3;
     */
    value: Int32Rules;
    case: "int32";
  } | {
    /**
     * @generated from field: buf.validate.Int64Rules int64 = 4;
     */
    value: Int64Rules;
    case: "int64";
  } | {
    /**
     * @generated from field: buf.validate.UInt32Rules uint32 = 5;
     */
    value: UInt32Rules;
    case: "uint32";
  } | {
    /**
     * @generated from field: buf.validate.UInt64Rules uint64 = 6;
     */
    value: UInt64Rules;
    case: "uint64";
  } | {
    /**
     * @generated from field: buf.validate.SInt32Rules sint32 = 7;
     */
    value: SInt32Rules;
    case: "sint32";
  } | {
    /**
     * @generated from field: buf.validate.SInt64Rules sint64 = 8;
     */
    value: SInt64Rules;
    case: "sint64";
  } | {
    /**
     * @generated from field: buf.validate.Fixed32Rules fixed32 = 9;
     */
    value: Fixed32Rules;
    case: "fixed32";
  } | {
    /**
     * @generated from field: buf.validate.Fixed64Rules fixed64 = 10;
     */
    value: Fixed64Rules;
    case: "fixed64";
  } | {
    /**
     * @generated from field: buf.validate.SFixed32Rules sfixed32 = 11;
     */
    value: SFixed32Rules;
    case: "sfixed32";
  } | {
    /**
     * @generated from field: buf.validate.SFixed64Rules sfixed64 = 12;
     */
    value: SFixed64Rules;
    case: "sfixed64";
  } | {
    /**
     * @generated from field: buf.validate.BoolRules bool = 13;
     */
    value: BoolRules;
    case: "bool";
  } | {
    /**
     * @generated from field: buf.validate.StringRules string = 14;
     */
    value: StringRules;
    case: "string";
  } | {
    /**
     * @generated from field: buf.validate.BytesRules bytes = 15;
     */
    value: BytesRules;
    case: "bytes";
  } | {
    /**
     * Complex Field Types
     *
     * @generated from field: buf.validate.EnumRules enum = 16;
     */
    value: EnumRules;
    case: "enum";
  } | {
    /**
     * @generated from field: buf.validate.RepeatedRules repeated = 18;
     */
    value: RepeatedRules;
    case: "repeated";
  } | {
    /**
     * @generated from field: buf.validate.MapRules map = 19;
     */
    value: MapRules;
    case: "map";
  } | {
    /**
     * Well-Known Field Types
     *
     * @generated from field: buf.validate.AnyRules any = 20;
     */
    value: AnyRules;
    case: "any";
  } | {
    /**
     * @generated from field: buf.validate.DurationRules duration = 21;
     */
    value: DurationRules;
    case: "duration";
  } | {
    /**
     * @generated from field: buf.validate.TimestampRules timestamp = 22;
     */
    value: TimestampRules;
    case: "timestamp";
  } | { case: undefined; value?: undefined };
};

/**
 * FieldRules encapsulates the rules for each type of field. Depending on
 * the field, the correct set should be used to ensure proper validations.
 *
 * @generated from message buf.validate.FieldRules
 */
export declare type FieldRulesJson = {
  /**
   * `cel` is a repeated field used to represent a textual expression
   * in the Common Expression Language (CEL) syntax. For more information,
   * [see our documentation](https://buf.build/docs/protovalidate/schemas/custom-rules/).
   *
   * ```proto
   * message MyMessage {
   *   // The field `value` must be greater than 42.
   *   optional int32 value = 1 [(buf.validate.field).cel = {
   *     id: "my_message.value",
   *     message: "value must be greater than 42",
   *     expression: "this > 42",
   *   }];
   * }
   * ```
   *
   * @generated from field: repeated buf.validate.Rule cel = 23;
   */
  cel?: RuleJson[];

  /**
   * If `required` is true, the field must be set. A validation error is returned
   * if the field is not set.
   *
   * ```proto
   * syntax="proto3";
   *
   * message FieldsWithPresence {
   *   // Requires any string to be set, including the empty string.
   *   optional string link = 1 [
   *     (buf.validate.field).required = true
   *   ];
   *   // Requires true or false to be set.
   *   optional bool disabled = 2 [
   *     (buf.validate.field).required = true
   *   ];
   *   // Requires a message to be set, including the empty message.
   *   SomeMessage msg = 4 [
   *     (buf.validate.field).required = true
   *   ];
   * }
   * ```
   *
   * All fields in the example above track presence. By default, Protovalidate
   * ignores rules on those fields if no value is set. `required` ensures that
   * the fields are set and valid.
   *
   * Fields that don't track presence are always validated by Protovalidate,
   * whether they are set or not. It is not necessary to add `required`:
   *
   * ```proto
   * syntax="proto3";
   *
   * message FieldsWithoutPresence {
   *   // `string.email` always applies, even to an empty string.
   *   string link = 1 [
   *     (buf.validate.field).string.email = true
   *   ];
   *   // `repeated.min_items` always applies, even to an empty list.
   *   repeated string labels = 4 [
   *     (buf.validate.field).repeated.min_items = 1
   *   ];
   * }
   * ```
   *
   * To learn which fields track presence, see the
   * [Field Presence cheat sheet](https://protobuf.dev/programming-guides/field_presence/#cheat).
   *
   * Note: While field rules can be applied to repeated items, map keys, and map
   * values, the elements are always considered to be set. Consequently,
   * specifying `repeated.items.required` is redundant.
   *
   * @generated from field: optional bool required = 25;
   */
  required?: boolean;

  /**
   * Ignore validation rules on the field if its value matches the specified
   * criteria. See the `Ignore` enum for details.
   *
   * ```proto
   * message UpdateRequest {
   *   // The uri rule only applies if the field is populated and not an empty
   *   // string.
   *   optional string url = 1 [
   *     (buf.validate.field).ignore = IGNORE_IF_DEFAULT_VALUE,
   *     (buf.validate.field).string.uri = true
   *   ];
   * }
   * ```
   *
   * @generated from field: optional buf.validate.Ignore ignore = 27;
   */
  ignore?: IgnoreJson;

  /**
   * Scalar Field Types
   *
   * @generated from field: buf.validate.FloatRules float = 1;
   */
  float?: FloatRulesJson;

  /**
   * @generated from field: buf.validate.DoubleRules double = 2;
   */
  double?: DoubleRulesJson;

  /**
   * @generated from field: buf.validate.Int32Rules int32 = 3;
   */
  int32?: Int32RulesJson;

  /**
   * @generated from field: buf.validate.Int64Rules int64 = 4;
   */
  int64?: Int64RulesJson;

  /**
   * @generated from field: buf.validate.UInt32Rules uint32 = 5;
   */
  uint32?: UInt32RulesJson;

  /**
   * @generated from field: buf.validate.UInt64Rules uint64 = 6;
   */
  uint64?: UInt64RulesJson;

  /**
   * @generated from field: buf.validate.SInt32Rules sint32 = 7;
   */
  sint32?: SInt32RulesJson;

  /**
   * @generated from field: buf.validate.SInt64Rules sint64 = 8;
   */
  sint64?: SInt64RulesJson;

  /**
   * @generated from field: buf.validate.Fixed32Rules fixed32 = 9;
   */
  fixed32?: Fixed32RulesJson;

  /**
   * @generated from field: buf.validate.Fixed64Rules fixed64 = 10;
   */
  fixed64?: Fixed64RulesJson;

  /**
   * @generated from field: buf.validate.SFixed32Rules sfixed32 = 11;
   */
  sfixed32?: SFixed32RulesJson;

  /**
   * @generated from field: buf.validate.SFixed64Rules sfixed64 = 12;
   */
  sfixed64?: SFixed64RulesJson;

  /**
   * @generated from field: buf.validate.BoolRules bool = 13;
   */
  bool?: BoolRulesJson;

  /**
   * @generated from field: buf.validate.StringRules string = 14;
   */
  string?: StringRulesJson;

  /**
   * @generated from field: buf.validate.BytesRules bytes = 15;
   */
  bytes?: BytesRulesJson;

  /**
   * Complex Field Types
   *
   * @generated from field: buf.validate.EnumRules enum = 16;
   */
  enum?: EnumRulesJson;

  /**
   * @generated from field: buf.validate.RepeatedRules repeated = 18;
   */
  repeated?: RepeatedRulesJson;

  /**
   * @generated from field: buf.validate.MapRules map = 19;
   */
  map?: MapRulesJson;

  /**
   * Well-Known Field Types
   *
   * @generated from field: buf.validate.AnyRules any = 20;
   */
  any?: AnyRulesJson;

  /**
   * @generated from field: buf.validate.DurationRules duration = 21;
   */
  duration?: DurationRulesJson;

  /**
   * @generated from field: buf.validate.TimestampRules timestamp = 22;
   */
  timestamp?: TimestampRulesJson;
};

/**
 * Describes the message buf.validate.FieldRules.
 * Use `create(FieldRulesSchema)` to create a new message.
 */
export declare const FieldRulesSchema: GenMessage<FieldRules, {jsonType: FieldRulesJson}>;

/**
 * PredefinedRules are custom rules that can be re-used with
 * multiple fields.
 *
 * @generated from message buf.validate.PredefinedRules
 */
export declare type PredefinedRules = Message<"buf.validate.PredefinedRules"> & {
  /**
   * `cel` is a repeated field used to represent a textual expression
   * in the Common Expression Language (CEL) syntax. For more information,
   * [see our documentation](https://buf.build/docs/protovalidate/schemas/predefined-rules/).
   *
   * ```proto
   * message MyMessage {
   *   // The field `value` must be greater than 42.
   *   optional int32 value = 1 [(buf.validate.predefined).cel = {
   *     id: "my_message.value",
   *     message: "value must be greater than 42",
   *     expression: "this > 42",
   *   }];
   * }
   * ```
   *
   * @generated from field: repeated buf.validate.Rule cel = 1;
   */
  cel: Rule[];
};

/**
 * PredefinedRules are custom rules that can be re-used with
 * multiple fields.
 *
 * @generated from message buf.validate.PredefinedRules
 */
export declare type PredefinedRulesJson = {
  /**
   * `cel` is a repeated field used to represent a textual expression
   * in the Common Expression Language (CEL) syntax. For more information,
   * [see our documentation](https://buf.build/docs/protovalidate/schemas/predefined-rules/).
   *
   * ```proto
   * message MyMessage {
   *   // The field `value` must be greater than 42.
   *   optional int32 value = 1 [(buf.validate.predefined).cel = {
   *     id: "my_message.value",
   *     message: "value must be greater than 42",
   *     expression: "this > 42",
   *   }];
   * }
   * ```
   *
   * @generated from field: repeated buf.validate.Rule cel = 1;
   */
  cel?: RuleJson[];
};

/**
 * Describes the message buf.validate.PredefinedRules.
 * Use `create(PredefinedRulesSchema)` to create a new message.
 */
export declare const PredefinedRulesSchema: GenMessage<PredefinedRules, {jsonType: PredefinedRulesJson}>;

/**
 * FloatRules describes the rules applied to `float` values. These
 * rules may also be applied to the `google.protobuf.FloatValue` Well-Known-Type.
 *
 * @generated from message buf.validate.FloatRules
 */
export declare type FloatRules = Message<"buf.validate.FloatRules"> & {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyFloat {
   *   // value must equal 42.0
   *   float value = 1 [(buf.validate.field).float.const = 42.0];
   * }
   * ```
   *
   * @generated from field: optional float const = 1;
   */
  const: number;

  /**
   * @generated from oneof buf.validate.FloatRules.less_than
   */
  lessThan: {
    /**
     * `lt` requires the field value to be less than the specified value (field <
     * value). If the field value is equal to or greater than the specified value,
     * an error message is generated.
     *
     * ```proto
     * message MyFloat {
     *   // value must be less than 10.0
     *   float value = 1 [(buf.validate.field).float.lt = 10.0];
     * }
     * ```
     *
     * @generated from field: float lt = 2;
     */
    value: number;
    case: "lt";
  } | {
    /**
     * `lte` requires the field value to be less than or equal to the specified
     * value (field <= value). If the field value is greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MyFloat {
     *   // value must be less than or equal to 10.0
     *   float value = 1 [(buf.validate.field).float.lte = 10.0];
     * }
     * ```
     *
     * @generated from field: float lte = 3;
     */
    value: number;
    case: "lte";
  } | { case: undefined; value?: undefined };

  /**
   * @generated from oneof buf.validate.FloatRules.greater_than
   */
  greaterThan: {
    /**
     * `gt` requires the field value to be greater than the specified value
     * (exclusive). If the value of `gt` is larger than a specified `lt` or
     * `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyFloat {
     *   // value must be greater than 5.0 [float.gt]
     *   float value = 1 [(buf.validate.field).float.gt = 5.0];
     *
     *   // value must be greater than 5 and less than 10.0 [float.gt_lt]
     *   float other_value = 2 [(buf.validate.field).float = { gt: 5.0, lt: 10.0 }];
     *
     *   // value must be greater than 10 or less than 5.0 [float.gt_lt_exclusive]
     *   float another_value = 3 [(buf.validate.field).float = { gt: 10.0, lt: 5.0 }];
     * }
     * ```
     *
     * @generated from field: float gt = 4;
     */
    value: number;
    case: "gt";
  } | {
    /**
     * `gte` requires the field value to be greater than or equal to the specified
     * value (exclusive). If the value of `gte` is larger than a specified `lt`
     * or `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyFloat {
     *   // value must be greater than or equal to 5.0 [float.gte]
     *   float value = 1 [(buf.validate.field).float.gte = 5.0];
     *
     *   // value must be greater than or equal to 5.0 and less than 10.0 [float.gte_lt]
     *   float other_value = 2 [(buf.validate.field).float = { gte: 5.0, lt: 10.0 }];
     *
     *   // value must be greater than or equal to 10.0 or less than 5.0 [float.gte_lt_exclusive]
     *   float another_value = 3 [(buf.validate.field).float = { gte: 10.0, lt: 5.0 }];
     * }
     * ```
     *
     * @generated from field: float gte = 5;
     */
    value: number;
    case: "gte";
  } | { case: undefined; value?: undefined };

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message
   * is generated.
   *
   * ```proto
   * message MyFloat {
   *   // value must be in list [1.0, 2.0, 3.0]
   *   float value = 1 [(buf.validate.field).float = { in: [1.0, 2.0, 3.0] }];
   * }
   * ```
   *
   * @generated from field: repeated float in = 6;
   */
  in: number[];

  /**
   * `in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyFloat {
   *   // value must not be in list [1.0, 2.0, 3.0]
   *   float value = 1 [(buf.validate.field).float = { not_in: [1.0, 2.0, 3.0] }];
   * }
   * ```
   *
   * @generated from field: repeated float not_in = 7;
   */
  notIn: number[];

  /**
   * `finite` requires the field value to be finite. If the field value is
   * infinite or NaN, an error message is generated.
   *
   * @generated from field: optional bool finite = 8;
   */
  finite: boolean;

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyFloat {
   *   float value = 1 [
   *     (buf.validate.field).float.example = 1.0,
   *     (buf.validate.field).float.example = inf
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated float example = 9;
   */
  example: number[];
};

/**
 * FloatRules describes the rules applied to `float` values. These
 * rules may also be applied to the `google.protobuf.FloatValue` Well-Known-Type.
 *
 * @generated from message buf.validate.FloatRules
 */
export declare type FloatRulesJson = {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyFloat {
   *   // value must equal 42.0
   *   float value = 1 [(buf.validate.field).float.const = 42.0];
   * }
   * ```
   *
   * @generated from field: optional float const = 1;
   */
  const?: number | "NaN" | "Infinity" | "-Infinity";

  /**
   * `lt` requires the field value to be less than the specified value (field <
   * value). If the field value is equal to or greater than the specified value,
   * an error message is generated.
   *
   * ```proto
   * message MyFloat {
   *   // value must be less than 10.0
   *   float value = 1 [(buf.validate.field).float.lt = 10.0];
   * }
   * ```
   *
   * @generated from field: float lt = 2;
   */
  lt?: number | "NaN" | "Infinity" | "-Infinity";

  /**
   * `lte` requires the field value to be less than or equal to the specified
   * value (field <= value). If the field value is greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MyFloat {
   *   // value must be less than or equal to 10.0
   *   float value = 1 [(buf.validate.field).float.lte = 10.0];
   * }
   * ```
   *
   * @generated from field: float lte = 3;
   */
  lte?: number | "NaN" | "Infinity" | "-Infinity";

  /**
   * `gt` requires the field value to be greater than the specified value
   * (exclusive). If the value of `gt` is larger than a specified `lt` or
   * `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyFloat {
   *   // value must be greater than 5.0 [float.gt]
   *   float value = 1 [(buf.validate.field).float.gt = 5.0];
   *
   *   // value must be greater than 5 and less than 10.0 [float.gt_lt]
   *   float other_value = 2 [(buf.validate.field).float = { gt: 5.0, lt: 10.0 }];
   *
   *   // value must be greater than 10 or less than 5.0 [float.gt_lt_exclusive]
   *   float another_value = 3 [(buf.validate.field).float = { gt: 10.0, lt: 5.0 }];
   * }
   * ```
   *
   * @generated from field: float gt = 4;
   */
  gt?: number | "NaN" | "Infinity" | "-Infinity";

  /**
   * `gte` requires the field value to be greater than or equal to the specified
   * value (exclusive). If the value of `gte` is larger than a specified `lt`
   * or `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyFloat {
   *   // value must be greater than or equal to 5.0 [float.gte]
   *   float value = 1 [(buf.validate.field).float.gte = 5.0];
   *
   *   // value must be greater than or equal to 5.0 and less than 10.0 [float.gte_lt]
   *   float other_value = 2 [(buf.validate.field).float = { gte: 5.0, lt: 10.0 }];
   *
   *   // value must be greater than or equal to 10.0 or less than 5.0 [float.gte_lt_exclusive]
   *   float another_value = 3 [(buf.validate.field).float = { gte: 10.0, lt: 5.0 }];
   * }
   * ```
   *
   * @generated from field: float gte = 5;
   */
  gte?: number | "NaN" | "Infinity" | "-Infinity";

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message
   * is generated.
   *
   * ```proto
   * message MyFloat {
   *   // value must be in list [1.0, 2.0, 3.0]
   *   float value = 1 [(buf.validate.field).float = { in: [1.0, 2.0, 3.0] }];
   * }
   * ```
   *
   * @generated from field: repeated float in = 6;
   */
  in?: (number | "NaN" | "Infinity" | "-Infinity")[];

  /**
   * `in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyFloat {
   *   // value must not be in list [1.0, 2.0, 3.0]
   *   float value = 1 [(buf.validate.field).float = { not_in: [1.0, 2.0, 3.0] }];
   * }
   * ```
   *
   * @generated from field: repeated float not_in = 7;
   */
  notIn?: (number | "NaN" | "Infinity" | "-Infinity")[];

  /**
   * `finite` requires the field value to be finite. If the field value is
   * infinite or NaN, an error message is generated.
   *
   * @generated from field: optional bool finite = 8;
   */
  finite?: boolean;

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyFloat {
   *   float value = 1 [
   *     (buf.validate.field).float.example = 1.0,
   *     (buf.validate.field).float.example = inf
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated float example = 9;
   */
  example?: (number | "NaN" | "Infinity" | "-Infinity")[];
};

/**
 * Describes the message buf.validate.FloatRules.
 * Use `create(FloatRulesSchema)` to create a new message.
 */
export declare const FloatRulesSchema: GenMessage<FloatRules, {jsonType: FloatRulesJson}>;

/**
 * DoubleRules describes the rules applied to `double` values. These
 * rules may also be applied to the `google.protobuf.DoubleValue` Well-Known-Type.
 *
 * @generated from message buf.validate.DoubleRules
 */
export declare type DoubleRules = Message<"buf.validate.DoubleRules"> & {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyDouble {
   *   // value must equal 42.0
   *   double value = 1 [(buf.validate.field).double.const = 42.0];
   * }
   * ```
   *
   * @generated from field: optional double const = 1;
   */
  const: number;

  /**
   * @generated from oneof buf.validate.DoubleRules.less_than
   */
  lessThan: {
    /**
     * `lt` requires the field value to be less than the specified value (field <
     * value). If the field value is equal to or greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MyDouble {
     *   // value must be less than 10.0
     *   double value = 1 [(buf.validate.field).double.lt = 10.0];
     * }
     * ```
     *
     * @generated from field: double lt = 2;
     */
    value: number;
    case: "lt";
  } | {
    /**
     * `lte` requires the field value to be less than or equal to the specified value
     * (field <= value). If the field value is greater than the specified value,
     * an error message is generated.
     *
     * ```proto
     * message MyDouble {
     *   // value must be less than or equal to 10.0
     *   double value = 1 [(buf.validate.field).double.lte = 10.0];
     * }
     * ```
     *
     * @generated from field: double lte = 3;
     */
    value: number;
    case: "lte";
  } | { case: undefined; value?: undefined };

  /**
   * @generated from oneof buf.validate.DoubleRules.greater_than
   */
  greaterThan: {
    /**
     * `gt` requires the field value to be greater than the specified value
     * (exclusive). If the value of `gt` is larger than a specified `lt` or `lte`,
     * the range is reversed, and the field value must be outside the specified
     * range. If the field value doesn't meet the required conditions, an error
     * message is generated.
     *
     * ```proto
     * message MyDouble {
     *   // value must be greater than 5.0 [double.gt]
     *   double value = 1 [(buf.validate.field).double.gt = 5.0];
     *
     *   // value must be greater than 5 and less than 10.0 [double.gt_lt]
     *   double other_value = 2 [(buf.validate.field).double = { gt: 5.0, lt: 10.0 }];
     *
     *   // value must be greater than 10 or less than 5.0 [double.gt_lt_exclusive]
     *   double another_value = 3 [(buf.validate.field).double = { gt: 10.0, lt: 5.0 }];
     * }
     * ```
     *
     * @generated from field: double gt = 4;
     */
    value: number;
    case: "gt";
  } | {
    /**
     * `gte` requires the field value to be greater than or equal to the specified
     * value (exclusive). If the value of `gte` is larger than a specified `lt` or
     * `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyDouble {
     *   // value must be greater than or equal to 5.0 [double.gte]
     *   double value = 1 [(buf.validate.field).double.gte = 5.0];
     *
     *   // value must be greater than or equal to 5.0 and less than 10.0 [double.gte_lt]
     *   double other_value = 2 [(buf.validate.field).double = { gte: 5.0, lt: 10.0 }];
     *
     *   // value must be greater than or equal to 10.0 or less than 5.0 [double.gte_lt_exclusive]
     *   double another_value = 3 [(buf.validate.field).double = { gte: 10.0, lt: 5.0 }];
     * }
     * ```
     *
     * @generated from field: double gte = 5;
     */
    value: number;
    case: "gte";
  } | { case: undefined; value?: undefined };

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MyDouble {
   *   // value must be in list [1.0, 2.0, 3.0]
   *   double value = 1 [(buf.validate.field).double = { in: [1.0, 2.0, 3.0] }];
   * }
   * ```
   *
   * @generated from field: repeated double in = 6;
   */
  in: number[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyDouble {
   *   // value must not be in list [1.0, 2.0, 3.0]
   *   double value = 1 [(buf.validate.field).double = { not_in: [1.0, 2.0, 3.0] }];
   * }
   * ```
   *
   * @generated from field: repeated double not_in = 7;
   */
  notIn: number[];

  /**
   * `finite` requires the field value to be finite. If the field value is
   * infinite or NaN, an error message is generated.
   *
   * @generated from field: optional bool finite = 8;
   */
  finite: boolean;

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyDouble {
   *   double value = 1 [
   *     (buf.validate.field).double.example = 1.0,
   *     (buf.validate.field).double.example = inf
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated double example = 9;
   */
  example: number[];
};

/**
 * DoubleRules describes the rules applied to `double` values. These
 * rules may also be applied to the `google.protobuf.DoubleValue` Well-Known-Type.
 *
 * @generated from message buf.validate.DoubleRules
 */
export declare type DoubleRulesJson = {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyDouble {
   *   // value must equal 42.0
   *   double value = 1 [(buf.validate.field).double.const = 42.0];
   * }
   * ```
   *
   * @generated from field: optional double const = 1;
   */
  const?: number | "NaN" | "Infinity" | "-Infinity";

  /**
   * `lt` requires the field value to be less than the specified value (field <
   * value). If the field value is equal to or greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MyDouble {
   *   // value must be less than 10.0
   *   double value = 1 [(buf.validate.field).double.lt = 10.0];
   * }
   * ```
   *
   * @generated from field: double lt = 2;
   */
  lt?: number | "NaN" | "Infinity" | "-Infinity";

  /**
   * `lte` requires the field value to be less than or equal to the specified value
   * (field <= value). If the field value is greater than the specified value,
   * an error message is generated.
   *
   * ```proto
   * message MyDouble {
   *   // value must be less than or equal to 10.0
   *   double value = 1 [(buf.validate.field).double.lte = 10.0];
   * }
   * ```
   *
   * @generated from field: double lte = 3;
   */
  lte?: number | "NaN" | "Infinity" | "-Infinity";

  /**
   * `gt` requires the field value to be greater than the specified value
   * (exclusive). If the value of `gt` is larger than a specified `lt` or `lte`,
   * the range is reversed, and the field value must be outside the specified
   * range. If the field value doesn't meet the required conditions, an error
   * message is generated.
   *
   * ```proto
   * message MyDouble {
   *   // value must be greater than 5.0 [double.gt]
   *   double value = 1 [(buf.validate.field).double.gt = 5.0];
   *
   *   // value must be greater than 5 and less than 10.0 [double.gt_lt]
   *   double other_value = 2 [(buf.validate.field).double = { gt: 5.0, lt: 10.0 }];
   *
   *   // value must be greater than 10 or less than 5.0 [double.gt_lt_exclusive]
   *   double another_value = 3 [(buf.validate.field).double = { gt: 10.0, lt: 5.0 }];
   * }
   * ```
   *
   * @generated from field: double gt = 4;
   */
  gt?: number | "NaN" | "Infinity" | "-Infinity";

  /**
   * `gte` requires the field value to be greater than or equal to the specified
   * value (exclusive). If the value of `gte` is larger than a specified `lt` or
   * `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyDouble {
   *   // value must be greater than or equal to 5.0 [double.gte]
   *   double value = 1 [(buf.validate.field).double.gte = 5.0];
   *
   *   // value must be greater than or equal to 5.0 and less than 10.0 [double.gte_lt]
   *   double other_value = 2 [(buf.validate.field).double = { gte: 5.0, lt: 10.0 }];
   *
   *   // value must be greater than or equal to 10.0 or less than 5.0 [double.gte_lt_exclusive]
   *   double another_value = 3 [(buf.validate.field).double = { gte: 10.0, lt: 5.0 }];
   * }
   * ```
   *
   * @generated from field: double gte = 5;
   */
  gte?: number | "NaN" | "Infinity" | "-Infinity";

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MyDouble {
   *   // value must be in list [1.0, 2.0, 3.0]
   *   double value = 1 [(buf.validate.field).double = { in: [1.0, 2.0, 3.0] }];
   * }
   * ```
   *
   * @generated from field: repeated double in = 6;
   */
  in?: (number | "NaN" | "Infinity" | "-Infinity")[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyDouble {
   *   // value must not be in list [1.0, 2.0, 3.0]
   *   double value = 1 [(buf.validate.field).double = { not_in: [1.0, 2.0, 3.0] }];
   * }
   * ```
   *
   * @generated from field: repeated double not_in = 7;
   */
  notIn?: (number | "NaN" | "Infinity" | "-Infinity")[];

  /**
   * `finite` requires the field value to be finite. If the field value is
   * infinite or NaN, an error message is generated.
   *
   * @generated from field: optional bool finite = 8;
   */
  finite?: boolean;

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyDouble {
   *   double value = 1 [
   *     (buf.validate.field).double.example = 1.0,
   *     (buf.validate.field).double.example = inf
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated double example = 9;
   */
  example?: (number | "NaN" | "Infinity" | "-Infinity")[];
};

/**
 * Describes the message buf.validate.DoubleRules.
 * Use `create(DoubleRulesSchema)` to create a new message.
 */
export declare const DoubleRulesSchema: GenMessage<DoubleRules, {jsonType: DoubleRulesJson}>;

/**
 * Int32Rules describes the rules applied to `int32` values. These
 * rules may also be applied to the `google.protobuf.Int32Value` Well-Known-Type.
 *
 * @generated from message buf.validate.Int32Rules
 */
export declare type Int32Rules = Message<"buf.validate.Int32Rules"> & {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyInt32 {
   *   // value must equal 42
   *   int32 value = 1 [(buf.validate.field).int32.const = 42];
   * }
   * ```
   *
   * @generated from field: optional int32 const = 1;
   */
  const: number;

  /**
   * @generated from oneof buf.validate.Int32Rules.less_than
   */
  lessThan: {
    /**
     * `lt` requires the field value to be less than the specified value (field
     * < value). If the field value is equal to or greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MyInt32 {
     *   // value must be less than 10
     *   int32 value = 1 [(buf.validate.field).int32.lt = 10];
     * }
     * ```
     *
     * @generated from field: int32 lt = 2;
     */
    value: number;
    case: "lt";
  } | {
    /**
     * `lte` requires the field value to be less than or equal to the specified
     * value (field <= value). If the field value is greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MyInt32 {
     *   // value must be less than or equal to 10
     *   int32 value = 1 [(buf.validate.field).int32.lte = 10];
     * }
     * ```
     *
     * @generated from field: int32 lte = 3;
     */
    value: number;
    case: "lte";
  } | { case: undefined; value?: undefined };

  /**
   * @generated from oneof buf.validate.Int32Rules.greater_than
   */
  greaterThan: {
    /**
     * `gt` requires the field value to be greater than the specified value
     * (exclusive). If the value of `gt` is larger than a specified `lt` or
     * `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyInt32 {
     *   // value must be greater than 5 [int32.gt]
     *   int32 value = 1 [(buf.validate.field).int32.gt = 5];
     *
     *   // value must be greater than 5 and less than 10 [int32.gt_lt]
     *   int32 other_value = 2 [(buf.validate.field).int32 = { gt: 5, lt: 10 }];
     *
     *   // value must be greater than 10 or less than 5 [int32.gt_lt_exclusive]
     *   int32 another_value = 3 [(buf.validate.field).int32 = { gt: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: int32 gt = 4;
     */
    value: number;
    case: "gt";
  } | {
    /**
     * `gte` requires the field value to be greater than or equal to the specified value
     * (exclusive). If the value of `gte` is larger than a specified `lt` or
     * `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyInt32 {
     *   // value must be greater than or equal to 5 [int32.gte]
     *   int32 value = 1 [(buf.validate.field).int32.gte = 5];
     *
     *   // value must be greater than or equal to 5 and less than 10 [int32.gte_lt]
     *   int32 other_value = 2 [(buf.validate.field).int32 = { gte: 5, lt: 10 }];
     *
     *   // value must be greater than or equal to 10 or less than 5 [int32.gte_lt_exclusive]
     *   int32 another_value = 3 [(buf.validate.field).int32 = { gte: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: int32 gte = 5;
     */
    value: number;
    case: "gte";
  } | { case: undefined; value?: undefined };

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MyInt32 {
   *   // value must be in list [1, 2, 3]
   *   int32 value = 1 [(buf.validate.field).int32 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated int32 in = 6;
   */
  in: number[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error message
   * is generated.
   *
   * ```proto
   * message MyInt32 {
   *   // value must not be in list [1, 2, 3]
   *   int32 value = 1 [(buf.validate.field).int32 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated int32 not_in = 7;
   */
  notIn: number[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyInt32 {
   *   int32 value = 1 [
   *     (buf.validate.field).int32.example = 1,
   *     (buf.validate.field).int32.example = -10
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated int32 example = 8;
   */
  example: number[];
};

/**
 * Int32Rules describes the rules applied to `int32` values. These
 * rules may also be applied to the `google.protobuf.Int32Value` Well-Known-Type.
 *
 * @generated from message buf.validate.Int32Rules
 */
export declare type Int32RulesJson = {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyInt32 {
   *   // value must equal 42
   *   int32 value = 1 [(buf.validate.field).int32.const = 42];
   * }
   * ```
   *
   * @generated from field: optional int32 const = 1;
   */
  const?: number;

  /**
   * `lt` requires the field value to be less than the specified value (field
   * < value). If the field value is equal to or greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MyInt32 {
   *   // value must be less than 10
   *   int32 value = 1 [(buf.validate.field).int32.lt = 10];
   * }
   * ```
   *
   * @generated from field: int32 lt = 2;
   */
  lt?: number;

  /**
   * `lte` requires the field value to be less than or equal to the specified
   * value (field <= value). If the field value is greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MyInt32 {
   *   // value must be less than or equal to 10
   *   int32 value = 1 [(buf.validate.field).int32.lte = 10];
   * }
   * ```
   *
   * @generated from field: int32 lte = 3;
   */
  lte?: number;

  /**
   * `gt` requires the field value to be greater than the specified value
   * (exclusive). If the value of `gt` is larger than a specified `lt` or
   * `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyInt32 {
   *   // value must be greater than 5 [int32.gt]
   *   int32 value = 1 [(buf.validate.field).int32.gt = 5];
   *
   *   // value must be greater than 5 and less than 10 [int32.gt_lt]
   *   int32 other_value = 2 [(buf.validate.field).int32 = { gt: 5, lt: 10 }];
   *
   *   // value must be greater than 10 or less than 5 [int32.gt_lt_exclusive]
   *   int32 another_value = 3 [(buf.validate.field).int32 = { gt: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: int32 gt = 4;
   */
  gt?: number;

  /**
   * `gte` requires the field value to be greater than or equal to the specified value
   * (exclusive). If the value of `gte` is larger than a specified `lt` or
   * `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyInt32 {
   *   // value must be greater than or equal to 5 [int32.gte]
   *   int32 value = 1 [(buf.validate.field).int32.gte = 5];
   *
   *   // value must be greater than or equal to 5 and less than 10 [int32.gte_lt]
   *   int32 other_value = 2 [(buf.validate.field).int32 = { gte: 5, lt: 10 }];
   *
   *   // value must be greater than or equal to 10 or less than 5 [int32.gte_lt_exclusive]
   *   int32 another_value = 3 [(buf.validate.field).int32 = { gte: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: int32 gte = 5;
   */
  gte?: number;

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MyInt32 {
   *   // value must be in list [1, 2, 3]
   *   int32 value = 1 [(buf.validate.field).int32 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated int32 in = 6;
   */
  in?: number[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error message
   * is generated.
   *
   * ```proto
   * message MyInt32 {
   *   // value must not be in list [1, 2, 3]
   *   int32 value = 1 [(buf.validate.field).int32 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated int32 not_in = 7;
   */
  notIn?: number[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyInt32 {
   *   int32 value = 1 [
   *     (buf.validate.field).int32.example = 1,
   *     (buf.validate.field).int32.example = -10
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated int32 example = 8;
   */
  example?: number[];
};

/**
 * Describes the message buf.validate.Int32Rules.
 * Use `create(Int32RulesSchema)` to create a new message.
 */
export declare const Int32RulesSchema: GenMessage<Int32Rules, {jsonType: Int32RulesJson}>;

/**
 * Int64Rules describes the rules applied to `int64` values. These
 * rules may also be applied to the `google.protobuf.Int64Value` Well-Known-Type.
 *
 * @generated from message buf.validate.Int64Rules
 */
export declare type Int64Rules = Message<"buf.validate.Int64Rules"> & {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyInt64 {
   *   // value must equal 42
   *   int64 value = 1 [(buf.validate.field).int64.const = 42];
   * }
   * ```
   *
   * @generated from field: optional int64 const = 1;
   */
  const: bigint;

  /**
   * @generated from oneof buf.validate.Int64Rules.less_than
   */
  lessThan: {
    /**
     * `lt` requires the field value to be less than the specified value (field <
     * value). If the field value is equal to or greater than the specified value,
     * an error message is generated.
     *
     * ```proto
     * message MyInt64 {
     *   // value must be less than 10
     *   int64 value = 1 [(buf.validate.field).int64.lt = 10];
     * }
     * ```
     *
     * @generated from field: int64 lt = 2;
     */
    value: bigint;
    case: "lt";
  } | {
    /**
     * `lte` requires the field value to be less than or equal to the specified
     * value (field <= value). If the field value is greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MyInt64 {
     *   // value must be less than or equal to 10
     *   int64 value = 1 [(buf.validate.field).int64.lte = 10];
     * }
     * ```
     *
     * @generated from field: int64 lte = 3;
     */
    value: bigint;
    case: "lte";
  } | { case: undefined; value?: undefined };

  /**
   * @generated from oneof buf.validate.Int64Rules.greater_than
   */
  greaterThan: {
    /**
     * `gt` requires the field value to be greater than the specified value
     * (exclusive). If the value of `gt` is larger than a specified `lt` or
     * `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyInt64 {
     *   // value must be greater than 5 [int64.gt]
     *   int64 value = 1 [(buf.validate.field).int64.gt = 5];
     *
     *   // value must be greater than 5 and less than 10 [int64.gt_lt]
     *   int64 other_value = 2 [(buf.validate.field).int64 = { gt: 5, lt: 10 }];
     *
     *   // value must be greater than 10 or less than 5 [int64.gt_lt_exclusive]
     *   int64 another_value = 3 [(buf.validate.field).int64 = { gt: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: int64 gt = 4;
     */
    value: bigint;
    case: "gt";
  } | {
    /**
     * `gte` requires the field value to be greater than or equal to the specified
     * value (exclusive). If the value of `gte` is larger than a specified `lt`
     * or `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyInt64 {
     *   // value must be greater than or equal to 5 [int64.gte]
     *   int64 value = 1 [(buf.validate.field).int64.gte = 5];
     *
     *   // value must be greater than or equal to 5 and less than 10 [int64.gte_lt]
     *   int64 other_value = 2 [(buf.validate.field).int64 = { gte: 5, lt: 10 }];
     *
     *   // value must be greater than or equal to 10 or less than 5 [int64.gte_lt_exclusive]
     *   int64 another_value = 3 [(buf.validate.field).int64 = { gte: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: int64 gte = 5;
     */
    value: bigint;
    case: "gte";
  } | { case: undefined; value?: undefined };

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MyInt64 {
   *   // value must be in list [1, 2, 3]
   *   int64 value = 1 [(buf.validate.field).int64 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated int64 in = 6;
   */
  in: bigint[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyInt64 {
   *   // value must not be in list [1, 2, 3]
   *   int64 value = 1 [(buf.validate.field).int64 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated int64 not_in = 7;
   */
  notIn: bigint[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyInt64 {
   *   int64 value = 1 [
   *     (buf.validate.field).int64.example = 1,
   *     (buf.validate.field).int64.example = -10
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated int64 example = 9;
   */
  example: bigint[];
};

/**
 * Int64Rules describes the rules applied to `int64` values. These
 * rules may also be applied to the `google.protobuf.Int64Value` Well-Known-Type.
 *
 * @generated from message buf.validate.Int64Rules
 */
export declare type Int64RulesJson = {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyInt64 {
   *   // value must equal 42
   *   int64 value = 1 [(buf.validate.field).int64.const = 42];
   * }
   * ```
   *
   * @generated from field: optional int64 const = 1;
   */
  const?: string;

  /**
   * `lt` requires the field value to be less than the specified value (field <
   * value). If the field value is equal to or greater than the specified value,
   * an error message is generated.
   *
   * ```proto
   * message MyInt64 {
   *   // value must be less than 10
   *   int64 value = 1 [(buf.validate.field).int64.lt = 10];
   * }
   * ```
   *
   * @generated from field: int64 lt = 2;
   */
  lt?: string;

  /**
   * `lte` requires the field value to be less than or equal to the specified
   * value (field <= value). If the field value is greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MyInt64 {
   *   // value must be less than or equal to 10
   *   int64 value = 1 [(buf.validate.field).int64.lte = 10];
   * }
   * ```
   *
   * @generated from field: int64 lte = 3;
   */
  lte?: string;

  /**
   * `gt` requires the field value to be greater than the specified value
   * (exclusive). If the value of `gt` is larger than a specified `lt` or
   * `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyInt64 {
   *   // value must be greater than 5 [int64.gt]
   *   int64 value = 1 [(buf.validate.field).int64.gt = 5];
   *
   *   // value must be greater than 5 and less than 10 [int64.gt_lt]
   *   int64 other_value = 2 [(buf.validate.field).int64 = { gt: 5, lt: 10 }];
   *
   *   // value must be greater than 10 or less than 5 [int64.gt_lt_exclusive]
   *   int64 another_value = 3 [(buf.validate.field).int64 = { gt: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: int64 gt = 4;
   */
  gt?: string;

  /**
   * `gte` requires the field value to be greater than or equal to the specified
   * value (exclusive). If the value of `gte` is larger than a specified `lt`
   * or `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyInt64 {
   *   // value must be greater than or equal to 5 [int64.gte]
   *   int64 value = 1 [(buf.validate.field).int64.gte = 5];
   *
   *   // value must be greater than or equal to 5 and less than 10 [int64.gte_lt]
   *   int64 other_value = 2 [(buf.validate.field).int64 = { gte: 5, lt: 10 }];
   *
   *   // value must be greater than or equal to 10 or less than 5 [int64.gte_lt_exclusive]
   *   int64 another_value = 3 [(buf.validate.field).int64 = { gte: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: int64 gte = 5;
   */
  gte?: string;

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MyInt64 {
   *   // value must be in list [1, 2, 3]
   *   int64 value = 1 [(buf.validate.field).int64 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated int64 in = 6;
   */
  in?: string[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyInt64 {
   *   // value must not be in list [1, 2, 3]
   *   int64 value = 1 [(buf.validate.field).int64 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated int64 not_in = 7;
   */
  notIn?: string[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyInt64 {
   *   int64 value = 1 [
   *     (buf.validate.field).int64.example = 1,
   *     (buf.validate.field).int64.example = -10
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated int64 example = 9;
   */
  example?: string[];
};

/**
 * Describes the message buf.validate.Int64Rules.
 * Use `create(Int64RulesSchema)` to create a new message.
 */
export declare const Int64RulesSchema: GenMessage<Int64Rules, {jsonType: Int64RulesJson}>;

/**
 * UInt32Rules describes the rules applied to `uint32` values. These
 * rules may also be applied to the `google.protobuf.UInt32Value` Well-Known-Type.
 *
 * @generated from message buf.validate.UInt32Rules
 */
export declare type UInt32Rules = Message<"buf.validate.UInt32Rules"> & {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyUInt32 {
   *   // value must equal 42
   *   uint32 value = 1 [(buf.validate.field).uint32.const = 42];
   * }
   * ```
   *
   * @generated from field: optional uint32 const = 1;
   */
  const: number;

  /**
   * @generated from oneof buf.validate.UInt32Rules.less_than
   */
  lessThan: {
    /**
     * `lt` requires the field value to be less than the specified value (field <
     * value). If the field value is equal to or greater than the specified value,
     * an error message is generated.
     *
     * ```proto
     * message MyUInt32 {
     *   // value must be less than 10
     *   uint32 value = 1 [(buf.validate.field).uint32.lt = 10];
     * }
     * ```
     *
     * @generated from field: uint32 lt = 2;
     */
    value: number;
    case: "lt";
  } | {
    /**
     * `lte` requires the field value to be less than or equal to the specified
     * value (field <= value). If the field value is greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MyUInt32 {
     *   // value must be less than or equal to 10
     *   uint32 value = 1 [(buf.validate.field).uint32.lte = 10];
     * }
     * ```
     *
     * @generated from field: uint32 lte = 3;
     */
    value: number;
    case: "lte";
  } | { case: undefined; value?: undefined };

  /**
   * @generated from oneof buf.validate.UInt32Rules.greater_than
   */
  greaterThan: {
    /**
     * `gt` requires the field value to be greater than the specified value
     * (exclusive). If the value of `gt` is larger than a specified `lt` or
     * `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyUInt32 {
     *   // value must be greater than 5 [uint32.gt]
     *   uint32 value = 1 [(buf.validate.field).uint32.gt = 5];
     *
     *   // value must be greater than 5 and less than 10 [uint32.gt_lt]
     *   uint32 other_value = 2 [(buf.validate.field).uint32 = { gt: 5, lt: 10 }];
     *
     *   // value must be greater than 10 or less than 5 [uint32.gt_lt_exclusive]
     *   uint32 another_value = 3 [(buf.validate.field).uint32 = { gt: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: uint32 gt = 4;
     */
    value: number;
    case: "gt";
  } | {
    /**
     * `gte` requires the field value to be greater than or equal to the specified
     * value (exclusive). If the value of `gte` is larger than a specified `lt`
     * or `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyUInt32 {
     *   // value must be greater than or equal to 5 [uint32.gte]
     *   uint32 value = 1 [(buf.validate.field).uint32.gte = 5];
     *
     *   // value must be greater than or equal to 5 and less than 10 [uint32.gte_lt]
     *   uint32 other_value = 2 [(buf.validate.field).uint32 = { gte: 5, lt: 10 }];
     *
     *   // value must be greater than or equal to 10 or less than 5 [uint32.gte_lt_exclusive]
     *   uint32 another_value = 3 [(buf.validate.field).uint32 = { gte: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: uint32 gte = 5;
     */
    value: number;
    case: "gte";
  } | { case: undefined; value?: undefined };

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MyUInt32 {
   *   // value must be in list [1, 2, 3]
   *   uint32 value = 1 [(buf.validate.field).uint32 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated uint32 in = 6;
   */
  in: number[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyUInt32 {
   *   // value must not be in list [1, 2, 3]
   *   uint32 value = 1 [(buf.validate.field).uint32 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated uint32 not_in = 7;
   */
  notIn: number[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyUInt32 {
   *   uint32 value = 1 [
   *     (buf.validate.field).uint32.example = 1,
   *     (buf.validate.field).uint32.example = 10
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated uint32 example = 8;
   */
  example: number[];
};

/**
 * UInt32Rules describes the rules applied to `uint32` values. These
 * rules may also be applied to the `google.protobuf.UInt32Value` Well-Known-Type.
 *
 * @generated from message buf.validate.UInt32Rules
 */
export declare type UInt32RulesJson = {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyUInt32 {
   *   // value must equal 42
   *   uint32 value = 1 [(buf.validate.field).uint32.const = 42];
   * }
   * ```
   *
   * @generated from field: optional uint32 const = 1;
   */
  const?: number;

  /**
   * `lt` requires the field value to be less than the specified value (field <
   * value). If the field value is equal to or greater than the specified value,
   * an error message is generated.
   *
   * ```proto
   * message MyUInt32 {
   *   // value must be less than 10
   *   uint32 value = 1 [(buf.validate.field).uint32.lt = 10];
   * }
   * ```
   *
   * @generated from field: uint32 lt = 2;
   */
  lt?: number;

  /**
   * `lte` requires the field value to be less than or equal to the specified
   * value (field <= value). If the field value is greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MyUInt32 {
   *   // value must be less than or equal to 10
   *   uint32 value = 1 [(buf.validate.field).uint32.lte = 10];
   * }
   * ```
   *
   * @generated from field: uint32 lte = 3;
   */
  lte?: number;

  /**
   * `gt` requires the field value to be greater than the specified value
   * (exclusive). If the value of `gt` is larger than a specified `lt` or
   * `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyUInt32 {
   *   // value must be greater than 5 [uint32.gt]
   *   uint32 value = 1 [(buf.validate.field).uint32.gt = 5];
   *
   *   // value must be greater than 5 and less than 10 [uint32.gt_lt]
   *   uint32 other_value = 2 [(buf.validate.field).uint32 = { gt: 5, lt: 10 }];
   *
   *   // value must be greater than 10 or less than 5 [uint32.gt_lt_exclusive]
   *   uint32 another_value = 3 [(buf.validate.field).uint32 = { gt: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: uint32 gt = 4;
   */
  gt?: number;

  /**
   * `gte` requires the field value to be greater than or equal to the specified
   * value (exclusive). If the value of `gte` is larger than a specified `lt`
   * or `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyUInt32 {
   *   // value must be greater than or equal to 5 [uint32.gte]
   *   uint32 value = 1 [(buf.validate.field).uint32.gte = 5];
   *
   *   // value must be greater than or equal to 5 and less than 10 [uint32.gte_lt]
   *   uint32 other_value = 2 [(buf.validate.field).uint32 = { gte: 5, lt: 10 }];
   *
   *   // value must be greater than or equal to 10 or less than 5 [uint32.gte_lt_exclusive]
   *   uint32 another_value = 3 [(buf.validate.field).uint32 = { gte: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: uint32 gte = 5;
   */
  gte?: number;

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MyUInt32 {
   *   // value must be in list [1, 2, 3]
   *   uint32 value = 1 [(buf.validate.field).uint32 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated uint32 in = 6;
   */
  in?: number[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyUInt32 {
   *   // value must not be in list [1, 2, 3]
   *   uint32 value = 1 [(buf.validate.field).uint32 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated uint32 not_in = 7;
   */
  notIn?: number[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyUInt32 {
   *   uint32 value = 1 [
   *     (buf.validate.field).uint32.example = 1,
   *     (buf.validate.field).uint32.example = 10
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated uint32 example = 8;
   */
  example?: number[];
};

/**
 * Describes the message buf.validate.UInt32Rules.
 * Use `create(UInt32RulesSchema)` to create a new message.
 */
export declare const UInt32RulesSchema: GenMessage<UInt32Rules, {jsonType: UInt32RulesJson}>;

/**
 * UInt64Rules describes the rules applied to `uint64` values. These
 * rules may also be applied to the `google.protobuf.UInt64Value` Well-Known-Type.
 *
 * @generated from message buf.validate.UInt64Rules
 */
export declare type UInt64Rules = Message<"buf.validate.UInt64Rules"> & {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyUInt64 {
   *   // value must equal 42
   *   uint64 value = 1 [(buf.validate.field).uint64.const = 42];
   * }
   * ```
   *
   * @generated from field: optional uint64 const = 1;
   */
  const: bigint;

  /**
   * @generated from oneof buf.validate.UInt64Rules.less_than
   */
  lessThan: {
    /**
     * `lt` requires the field value to be less than the specified value (field <
     * value). If the field value is equal to or greater than the specified value,
     * an error message is generated.
     *
     * ```proto
     * message MyUInt64 {
     *   // value must be less than 10
     *   uint64 value = 1 [(buf.validate.field).uint64.lt = 10];
     * }
     * ```
     *
     * @generated from field: uint64 lt = 2;
     */
    value: bigint;
    case: "lt";
  } | {
    /**
     * `lte` requires the field value to be less than or equal to the specified
     * value (field <= value). If the field value is greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MyUInt64 {
     *   // value must be less than or equal to 10
     *   uint64 value = 1 [(buf.validate.field).uint64.lte = 10];
     * }
     * ```
     *
     * @generated from field: uint64 lte = 3;
     */
    value: bigint;
    case: "lte";
  } | { case: undefined; value?: undefined };

  /**
   * @generated from oneof buf.validate.UInt64Rules.greater_than
   */
  greaterThan: {
    /**
     * `gt` requires the field value to be greater than the specified value
     * (exclusive). If the value of `gt` is larger than a specified `lt` or
     * `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyUInt64 {
     *   // value must be greater than 5 [uint64.gt]
     *   uint64 value = 1 [(buf.validate.field).uint64.gt = 5];
     *
     *   // value must be greater than 5 and less than 10 [uint64.gt_lt]
     *   uint64 other_value = 2 [(buf.validate.field).uint64 = { gt: 5, lt: 10 }];
     *
     *   // value must be greater than 10 or less than 5 [uint64.gt_lt_exclusive]
     *   uint64 another_value = 3 [(buf.validate.field).uint64 = { gt: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: uint64 gt = 4;
     */
    value: bigint;
    case: "gt";
  } | {
    /**
     * `gte` requires the field value to be greater than or equal to the specified
     * value (exclusive). If the value of `gte` is larger than a specified `lt`
     * or `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyUInt64 {
     *   // value must be greater than or equal to 5 [uint64.gte]
     *   uint64 value = 1 [(buf.validate.field).uint64.gte = 5];
     *
     *   // value must be greater than or equal to 5 and less than 10 [uint64.gte_lt]
     *   uint64 other_value = 2 [(buf.validate.field).uint64 = { gte: 5, lt: 10 }];
     *
     *   // value must be greater than or equal to 10 or less than 5 [uint64.gte_lt_exclusive]
     *   uint64 another_value = 3 [(buf.validate.field).uint64 = { gte: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: uint64 gte = 5;
     */
    value: bigint;
    case: "gte";
  } | { case: undefined; value?: undefined };

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MyUInt64 {
   *   // value must be in list [1, 2, 3]
   *   uint64 value = 1 [(buf.validate.field).uint64 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated uint64 in = 6;
   */
  in: bigint[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyUInt64 {
   *   // value must not be in list [1, 2, 3]
   *   uint64 value = 1 [(buf.validate.field).uint64 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated uint64 not_in = 7;
   */
  notIn: bigint[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyUInt64 {
   *   uint64 value = 1 [
   *     (buf.validate.field).uint64.example = 1,
   *     (buf.validate.field).uint64.example = -10
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated uint64 example = 8;
   */
  example: bigint[];
};

/**
 * UInt64Rules describes the rules applied to `uint64` values. These
 * rules may also be applied to the `google.protobuf.UInt64Value` Well-Known-Type.
 *
 * @generated from message buf.validate.UInt64Rules
 */
export declare type UInt64RulesJson = {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyUInt64 {
   *   // value must equal 42
   *   uint64 value = 1 [(buf.validate.field).uint64.const = 42];
   * }
   * ```
   *
   * @generated from field: optional uint64 const = 1;
   */
  const?: string;

  /**
   * `lt` requires the field value to be less than the specified value (field <
   * value). If the field value is equal to or greater than the specified value,
   * an error message is generated.
   *
   * ```proto
   * message MyUInt64 {
   *   // value must be less than 10
   *   uint64 value = 1 [(buf.validate.field).uint64.lt = 10];
   * }
   * ```
   *
   * @generated from field: uint64 lt = 2;
   */
  lt?: string;

  /**
   * `lte` requires the field value to be less than or equal to the specified
   * value (field <= value). If the field value is greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MyUInt64 {
   *   // value must be less than or equal to 10
   *   uint64 value = 1 [(buf.validate.field).uint64.lte = 10];
   * }
   * ```
   *
   * @generated from field: uint64 lte = 3;
   */
  lte?: string;

  /**
   * `gt` requires the field value to be greater than the specified value
   * (exclusive). If the value of `gt` is larger than a specified `lt` or
   * `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyUInt64 {
   *   // value must be greater than 5 [uint64.gt]
   *   uint64 value = 1 [(buf.validate.field).uint64.gt = 5];
   *
   *   // value must be greater than 5 and less than 10 [uint64.gt_lt]
   *   uint64 other_value = 2 [(buf.validate.field).uint64 = { gt: 5, lt: 10 }];
   *
   *   // value must be greater than 10 or less than 5 [uint64.gt_lt_exclusive]
   *   uint64 another_value = 3 [(buf.validate.field).uint64 = { gt: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: uint64 gt = 4;
   */
  gt?: string;

  /**
   * `gte` requires the field value to be greater than or equal to the specified
   * value (exclusive). If the value of `gte` is larger than a specified `lt`
   * or `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyUInt64 {
   *   // value must be greater than or equal to 5 [uint64.gte]
   *   uint64 value = 1 [(buf.validate.field).uint64.gte = 5];
   *
   *   // value must be greater than or equal to 5 and less than 10 [uint64.gte_lt]
   *   uint64 other_value = 2 [(buf.validate.field).uint64 = { gte: 5, lt: 10 }];
   *
   *   // value must be greater than or equal to 10 or less than 5 [uint64.gte_lt_exclusive]
   *   uint64 another_value = 3 [(buf.validate.field).uint64 = { gte: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: uint64 gte = 5;
   */
  gte?: string;

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MyUInt64 {
   *   // value must be in list [1, 2, 3]
   *   uint64 value = 1 [(buf.validate.field).uint64 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated uint64 in = 6;
   */
  in?: string[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyUInt64 {
   *   // value must not be in list [1, 2, 3]
   *   uint64 value = 1 [(buf.validate.field).uint64 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated uint64 not_in = 7;
   */
  notIn?: string[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyUInt64 {
   *   uint64 value = 1 [
   *     (buf.validate.field).uint64.example = 1,
   *     (buf.validate.field).uint64.example = -10
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated uint64 example = 8;
   */
  example?: string[];
};

/**
 * Describes the message buf.validate.UInt64Rules.
 * Use `create(UInt64RulesSchema)` to create a new message.
 */
export declare const UInt64RulesSchema: GenMessage<UInt64Rules, {jsonType: UInt64RulesJson}>;

/**
 * SInt32Rules describes the rules applied to `sint32` values.
 *
 * @generated from message buf.validate.SInt32Rules
 */
export declare type SInt32Rules = Message<"buf.validate.SInt32Rules"> & {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MySInt32 {
   *   // value must equal 42
   *   sint32 value = 1 [(buf.validate.field).sint32.const = 42];
   * }
   * ```
   *
   * @generated from field: optional sint32 const = 1;
   */
  const: number;

  /**
   * @generated from oneof buf.validate.SInt32Rules.less_than
   */
  lessThan: {
    /**
     * `lt` requires the field value to be less than the specified value (field
     * < value). If the field value is equal to or greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MySInt32 {
     *   // value must be less than 10
     *   sint32 value = 1 [(buf.validate.field).sint32.lt = 10];
     * }
     * ```
     *
     * @generated from field: sint32 lt = 2;
     */
    value: number;
    case: "lt";
  } | {
    /**
     * `lte` requires the field value to be less than or equal to the specified
     * value (field <= value). If the field value is greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MySInt32 {
     *   // value must be less than or equal to 10
     *   sint32 value = 1 [(buf.validate.field).sint32.lte = 10];
     * }
     * ```
     *
     * @generated from field: sint32 lte = 3;
     */
    value: number;
    case: "lte";
  } | { case: undefined; value?: undefined };

  /**
   * @generated from oneof buf.validate.SInt32Rules.greater_than
   */
  greaterThan: {
    /**
     * `gt` requires the field value to be greater than the specified value
     * (exclusive). If the value of `gt` is larger than a specified `lt` or
     * `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MySInt32 {
     *   // value must be greater than 5 [sint32.gt]
     *   sint32 value = 1 [(buf.validate.field).sint32.gt = 5];
     *
     *   // value must be greater than 5 and less than 10 [sint32.gt_lt]
     *   sint32 other_value = 2 [(buf.validate.field).sint32 = { gt: 5, lt: 10 }];
     *
     *   // value must be greater than 10 or less than 5 [sint32.gt_lt_exclusive]
     *   sint32 another_value = 3 [(buf.validate.field).sint32 = { gt: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: sint32 gt = 4;
     */
    value: number;
    case: "gt";
  } | {
    /**
     * `gte` requires the field value to be greater than or equal to the specified
     * value (exclusive). If the value of `gte` is larger than a specified `lt`
     * or `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MySInt32 {
     *  // value must be greater than or equal to 5 [sint32.gte]
     *  sint32 value = 1 [(buf.validate.field).sint32.gte = 5];
     *
     *  // value must be greater than or equal to 5 and less than 10 [sint32.gte_lt]
     *  sint32 other_value = 2 [(buf.validate.field).sint32 = { gte: 5, lt: 10 }];
     *
     *  // value must be greater than or equal to 10 or less than 5 [sint32.gte_lt_exclusive]
     *  sint32 another_value = 3 [(buf.validate.field).sint32 = { gte: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: sint32 gte = 5;
     */
    value: number;
    case: "gte";
  } | { case: undefined; value?: undefined };

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MySInt32 {
   *   // value must be in list [1, 2, 3]
   *   sint32 value = 1 [(buf.validate.field).sint32 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sint32 in = 6;
   */
  in: number[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MySInt32 {
   *   // value must not be in list [1, 2, 3]
   *   sint32 value = 1 [(buf.validate.field).sint32 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sint32 not_in = 7;
   */
  notIn: number[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MySInt32 {
   *   sint32 value = 1 [
   *     (buf.validate.field).sint32.example = 1,
   *     (buf.validate.field).sint32.example = -10
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated sint32 example = 8;
   */
  example: number[];
};

/**
 * SInt32Rules describes the rules applied to `sint32` values.
 *
 * @generated from message buf.validate.SInt32Rules
 */
export declare type SInt32RulesJson = {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MySInt32 {
   *   // value must equal 42
   *   sint32 value = 1 [(buf.validate.field).sint32.const = 42];
   * }
   * ```
   *
   * @generated from field: optional sint32 const = 1;
   */
  const?: number;

  /**
   * `lt` requires the field value to be less than the specified value (field
   * < value). If the field value is equal to or greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MySInt32 {
   *   // value must be less than 10
   *   sint32 value = 1 [(buf.validate.field).sint32.lt = 10];
   * }
   * ```
   *
   * @generated from field: sint32 lt = 2;
   */
  lt?: number;

  /**
   * `lte` requires the field value to be less than or equal to the specified
   * value (field <= value). If the field value is greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MySInt32 {
   *   // value must be less than or equal to 10
   *   sint32 value = 1 [(buf.validate.field).sint32.lte = 10];
   * }
   * ```
   *
   * @generated from field: sint32 lte = 3;
   */
  lte?: number;

  /**
   * `gt` requires the field value to be greater than the specified value
   * (exclusive). If the value of `gt` is larger than a specified `lt` or
   * `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MySInt32 {
   *   // value must be greater than 5 [sint32.gt]
   *   sint32 value = 1 [(buf.validate.field).sint32.gt = 5];
   *
   *   // value must be greater than 5 and less than 10 [sint32.gt_lt]
   *   sint32 other_value = 2 [(buf.validate.field).sint32 = { gt: 5, lt: 10 }];
   *
   *   // value must be greater than 10 or less than 5 [sint32.gt_lt_exclusive]
   *   sint32 another_value = 3 [(buf.validate.field).sint32 = { gt: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: sint32 gt = 4;
   */
  gt?: number;

  /**
   * `gte` requires the field value to be greater than or equal to the specified
   * value (exclusive). If the value of `gte` is larger than a specified `lt`
   * or `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MySInt32 {
   *  // value must be greater than or equal to 5 [sint32.gte]
   *  sint32 value = 1 [(buf.validate.field).sint32.gte = 5];
   *
   *  // value must be greater than or equal to 5 and less than 10 [sint32.gte_lt]
   *  sint32 other_value = 2 [(buf.validate.field).sint32 = { gte: 5, lt: 10 }];
   *
   *  // value must be greater than or equal to 10 or less than 5 [sint32.gte_lt_exclusive]
   *  sint32 another_value = 3 [(buf.validate.field).sint32 = { gte: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: sint32 gte = 5;
   */
  gte?: number;

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MySInt32 {
   *   // value must be in list [1, 2, 3]
   *   sint32 value = 1 [(buf.validate.field).sint32 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sint32 in = 6;
   */
  in?: number[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MySInt32 {
   *   // value must not be in list [1, 2, 3]
   *   sint32 value = 1 [(buf.validate.field).sint32 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sint32 not_in = 7;
   */
  notIn?: number[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MySInt32 {
   *   sint32 value = 1 [
   *     (buf.validate.field).sint32.example = 1,
   *     (buf.validate.field).sint32.example = -10
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated sint32 example = 8;
   */
  example?: number[];
};

/**
 * Describes the message buf.validate.SInt32Rules.
 * Use `create(SInt32RulesSchema)` to create a new message.
 */
export declare const SInt32RulesSchema: GenMessage<SInt32Rules, {jsonType: SInt32RulesJson}>;

/**
 * SInt64Rules describes the rules applied to `sint64` values.
 *
 * @generated from message buf.validate.SInt64Rules
 */
export declare type SInt64Rules = Message<"buf.validate.SInt64Rules"> & {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MySInt64 {
   *   // value must equal 42
   *   sint64 value = 1 [(buf.validate.field).sint64.const = 42];
   * }
   * ```
   *
   * @generated from field: optional sint64 const = 1;
   */
  const: bigint;

  /**
   * @generated from oneof buf.validate.SInt64Rules.less_than
   */
  lessThan: {
    /**
     * `lt` requires the field value to be less than the specified value (field
     * < value). If the field value is equal to or greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MySInt64 {
     *   // value must be less than 10
     *   sint64 value = 1 [(buf.validate.field).sint64.lt = 10];
     * }
     * ```
     *
     * @generated from field: sint64 lt = 2;
     */
    value: bigint;
    case: "lt";
  } | {
    /**
     * `lte` requires the field value to be less than or equal to the specified
     * value (field <= value). If the field value is greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MySInt64 {
     *   // value must be less than or equal to 10
     *   sint64 value = 1 [(buf.validate.field).sint64.lte = 10];
     * }
     * ```
     *
     * @generated from field: sint64 lte = 3;
     */
    value: bigint;
    case: "lte";
  } | { case: undefined; value?: undefined };

  /**
   * @generated from oneof buf.validate.SInt64Rules.greater_than
   */
  greaterThan: {
    /**
     * `gt` requires the field value to be greater than the specified value
     * (exclusive). If the value of `gt` is larger than a specified `lt` or
     * `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MySInt64 {
     *   // value must be greater than 5 [sint64.gt]
     *   sint64 value = 1 [(buf.validate.field).sint64.gt = 5];
     *
     *   // value must be greater than 5 and less than 10 [sint64.gt_lt]
     *   sint64 other_value = 2 [(buf.validate.field).sint64 = { gt: 5, lt: 10 }];
     *
     *   // value must be greater than 10 or less than 5 [sint64.gt_lt_exclusive]
     *   sint64 another_value = 3 [(buf.validate.field).sint64 = { gt: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: sint64 gt = 4;
     */
    value: bigint;
    case: "gt";
  } | {
    /**
     * `gte` requires the field value to be greater than or equal to the specified
     * value (exclusive). If the value of `gte` is larger than a specified `lt`
     * or `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MySInt64 {
     *   // value must be greater than or equal to 5 [sint64.gte]
     *   sint64 value = 1 [(buf.validate.field).sint64.gte = 5];
     *
     *   // value must be greater than or equal to 5 and less than 10 [sint64.gte_lt]
     *   sint64 other_value = 2 [(buf.validate.field).sint64 = { gte: 5, lt: 10 }];
     *
     *   // value must be greater than or equal to 10 or less than 5 [sint64.gte_lt_exclusive]
     *   sint64 another_value = 3 [(buf.validate.field).sint64 = { gte: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: sint64 gte = 5;
     */
    value: bigint;
    case: "gte";
  } | { case: undefined; value?: undefined };

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message
   * is generated.
   *
   * ```proto
   * message MySInt64 {
   *   // value must be in list [1, 2, 3]
   *   sint64 value = 1 [(buf.validate.field).sint64 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sint64 in = 6;
   */
  in: bigint[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MySInt64 {
   *   // value must not be in list [1, 2, 3]
   *   sint64 value = 1 [(buf.validate.field).sint64 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sint64 not_in = 7;
   */
  notIn: bigint[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MySInt64 {
   *   sint64 value = 1 [
   *     (buf.validate.field).sint64.example = 1,
   *     (buf.validate.field).sint64.example = -10
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated sint64 example = 8;
   */
  example: bigint[];
};

/**
 * SInt64Rules describes the rules applied to `sint64` values.
 *
 * @generated from message buf.validate.SInt64Rules
 */
export declare type SInt64RulesJson = {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MySInt64 {
   *   // value must equal 42
   *   sint64 value = 1 [(buf.validate.field).sint64.const = 42];
   * }
   * ```
   *
   * @generated from field: optional sint64 const = 1;
   */
  const?: string;

  /**
   * `lt` requires the field value to be less than the specified value (field
   * < value). If the field value is equal to or greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MySInt64 {
   *   // value must be less than 10
   *   sint64 value = 1 [(buf.validate.field).sint64.lt = 10];
   * }
   * ```
   *
   * @generated from field: sint64 lt = 2;
   */
  lt?: string;

  /**
   * `lte` requires the field value to be less than or equal to the specified
   * value (field <= value). If the field value is greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MySInt64 {
   *   // value must be less than or equal to 10
   *   sint64 value = 1 [(buf.validate.field).sint64.lte = 10];
   * }
   * ```
   *
   * @generated from field: sint64 lte = 3;
   */
  lte?: string;

  /**
   * `gt` requires the field value to be greater than the specified value
   * (exclusive). If the value of `gt` is larger than a specified `lt` or
   * `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MySInt64 {
   *   // value must be greater than 5 [sint64.gt]
   *   sint64 value = 1 [(buf.validate.field).sint64.gt = 5];
   *
   *   // value must be greater than 5 and less than 10 [sint64.gt_lt]
   *   sint64 other_value = 2 [(buf.validate.field).sint64 = { gt: 5, lt: 10 }];
   *
   *   // value must be greater than 10 or less than 5 [sint64.gt_lt_exclusive]
   *   sint64 another_value = 3 [(buf.validate.field).sint64 = { gt: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: sint64 gt = 4;
   */
  gt?: string;

  /**
   * `gte` requires the field value to be greater than or equal to the specified
   * value (exclusive). If the value of `gte` is larger than a specified `lt`
   * or `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MySInt64 {
   *   // value must be greater than or equal to 5 [sint64.gte]
   *   sint64 value = 1 [(buf.validate.field).sint64.gte = 5];
   *
   *   // value must be greater than or equal to 5 and less than 10 [sint64.gte_lt]
   *   sint64 other_value = 2 [(buf.validate.field).sint64 = { gte: 5, lt: 10 }];
   *
   *   // value must be greater than or equal to 10 or less than 5 [sint64.gte_lt_exclusive]
   *   sint64 another_value = 3 [(buf.validate.field).sint64 = { gte: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: sint64 gte = 5;
   */
  gte?: string;

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message
   * is generated.
   *
   * ```proto
   * message MySInt64 {
   *   // value must be in list [1, 2, 3]
   *   sint64 value = 1 [(buf.validate.field).sint64 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sint64 in = 6;
   */
  in?: string[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MySInt64 {
   *   // value must not be in list [1, 2, 3]
   *   sint64 value = 1 [(buf.validate.field).sint64 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sint64 not_in = 7;
   */
  notIn?: string[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MySInt64 {
   *   sint64 value = 1 [
   *     (buf.validate.field).sint64.example = 1,
   *     (buf.validate.field).sint64.example = -10
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated sint64 example = 8;
   */
  example?: string[];
};

/**
 * Describes the message buf.validate.SInt64Rules.
 * Use `create(SInt64RulesSchema)` to create a new message.
 */
export declare const SInt64RulesSchema: GenMessage<SInt64Rules, {jsonType: SInt64RulesJson}>;

/**
 * Fixed32Rules describes the rules applied to `fixed32` values.
 *
 * @generated from message buf.validate.Fixed32Rules
 */
export declare type Fixed32Rules = Message<"buf.validate.Fixed32Rules"> & {
  /**
   * `const` requires the field value to exactly match the specified value.
   * If the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyFixed32 {
   *   // value must equal 42
   *   fixed32 value = 1 [(buf.validate.field).fixed32.const = 42];
   * }
   * ```
   *
   * @generated from field: optional fixed32 const = 1;
   */
  const: number;

  /**
   * @generated from oneof buf.validate.Fixed32Rules.less_than
   */
  lessThan: {
    /**
     * `lt` requires the field value to be less than the specified value (field <
     * value). If the field value is equal to or greater than the specified value,
     * an error message is generated.
     *
     * ```proto
     * message MyFixed32 {
     *   // value must be less than 10
     *   fixed32 value = 1 [(buf.validate.field).fixed32.lt = 10];
     * }
     * ```
     *
     * @generated from field: fixed32 lt = 2;
     */
    value: number;
    case: "lt";
  } | {
    /**
     * `lte` requires the field value to be less than or equal to the specified
     * value (field <= value). If the field value is greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MyFixed32 {
     *   // value must be less than or equal to 10
     *   fixed32 value = 1 [(buf.validate.field).fixed32.lte = 10];
     * }
     * ```
     *
     * @generated from field: fixed32 lte = 3;
     */
    value: number;
    case: "lte";
  } | { case: undefined; value?: undefined };

  /**
   * @generated from oneof buf.validate.Fixed32Rules.greater_than
   */
  greaterThan: {
    /**
     * `gt` requires the field value to be greater than the specified value
     * (exclusive). If the value of `gt` is larger than a specified `lt` or
     * `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyFixed32 {
     *   // value must be greater than 5 [fixed32.gt]
     *   fixed32 value = 1 [(buf.validate.field).fixed32.gt = 5];
     *
     *   // value must be greater than 5 and less than 10 [fixed32.gt_lt]
     *   fixed32 other_value = 2 [(buf.validate.field).fixed32 = { gt: 5, lt: 10 }];
     *
     *   // value must be greater than 10 or less than 5 [fixed32.gt_lt_exclusive]
     *   fixed32 another_value = 3 [(buf.validate.field).fixed32 = { gt: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: fixed32 gt = 4;
     */
    value: number;
    case: "gt";
  } | {
    /**
     * `gte` requires the field value to be greater than or equal to the specified
     * value (exclusive). If the value of `gte` is larger than a specified `lt`
     * or `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyFixed32 {
     *   // value must be greater than or equal to 5 [fixed32.gte]
     *   fixed32 value = 1 [(buf.validate.field).fixed32.gte = 5];
     *
     *   // value must be greater than or equal to 5 and less than 10 [fixed32.gte_lt]
     *   fixed32 other_value = 2 [(buf.validate.field).fixed32 = { gte: 5, lt: 10 }];
     *
     *   // value must be greater than or equal to 10 or less than 5 [fixed32.gte_lt_exclusive]
     *   fixed32 another_value = 3 [(buf.validate.field).fixed32 = { gte: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: fixed32 gte = 5;
     */
    value: number;
    case: "gte";
  } | { case: undefined; value?: undefined };

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message
   * is generated.
   *
   * ```proto
   * message MyFixed32 {
   *   // value must be in list [1, 2, 3]
   *   fixed32 value = 1 [(buf.validate.field).fixed32 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated fixed32 in = 6;
   */
  in: number[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyFixed32 {
   *   // value must not be in list [1, 2, 3]
   *   fixed32 value = 1 [(buf.validate.field).fixed32 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated fixed32 not_in = 7;
   */
  notIn: number[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyFixed32 {
   *   fixed32 value = 1 [
   *     (buf.validate.field).fixed32.example = 1,
   *     (buf.validate.field).fixed32.example = 2
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated fixed32 example = 8;
   */
  example: number[];
};

/**
 * Fixed32Rules describes the rules applied to `fixed32` values.
 *
 * @generated from message buf.validate.Fixed32Rules
 */
export declare type Fixed32RulesJson = {
  /**
   * `const` requires the field value to exactly match the specified value.
   * If the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyFixed32 {
   *   // value must equal 42
   *   fixed32 value = 1 [(buf.validate.field).fixed32.const = 42];
   * }
   * ```
   *
   * @generated from field: optional fixed32 const = 1;
   */
  const?: number;

  /**
   * `lt` requires the field value to be less than the specified value (field <
   * value). If the field value is equal to or greater than the specified value,
   * an error message is generated.
   *
   * ```proto
   * message MyFixed32 {
   *   // value must be less than 10
   *   fixed32 value = 1 [(buf.validate.field).fixed32.lt = 10];
   * }
   * ```
   *
   * @generated from field: fixed32 lt = 2;
   */
  lt?: number;

  /**
   * `lte` requires the field value to be less than or equal to the specified
   * value (field <= value). If the field value is greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MyFixed32 {
   *   // value must be less than or equal to 10
   *   fixed32 value = 1 [(buf.validate.field).fixed32.lte = 10];
   * }
   * ```
   *
   * @generated from field: fixed32 lte = 3;
   */
  lte?: number;

  /**
   * `gt` requires the field value to be greater than the specified value
   * (exclusive). If the value of `gt` is larger than a specified `lt` or
   * `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyFixed32 {
   *   // value must be greater than 5 [fixed32.gt]
   *   fixed32 value = 1 [(buf.validate.field).fixed32.gt = 5];
   *
   *   // value must be greater than 5 and less than 10 [fixed32.gt_lt]
   *   fixed32 other_value = 2 [(buf.validate.field).fixed32 = { gt: 5, lt: 10 }];
   *
   *   // value must be greater than 10 or less than 5 [fixed32.gt_lt_exclusive]
   *   fixed32 another_value = 3 [(buf.validate.field).fixed32 = { gt: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: fixed32 gt = 4;
   */
  gt?: number;

  /**
   * `gte` requires the field value to be greater than or equal to the specified
   * value (exclusive). If the value of `gte` is larger than a specified `lt`
   * or `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyFixed32 {
   *   // value must be greater than or equal to 5 [fixed32.gte]
   *   fixed32 value = 1 [(buf.validate.field).fixed32.gte = 5];
   *
   *   // value must be greater than or equal to 5 and less than 10 [fixed32.gte_lt]
   *   fixed32 other_value = 2 [(buf.validate.field).fixed32 = { gte: 5, lt: 10 }];
   *
   *   // value must be greater than or equal to 10 or less than 5 [fixed32.gte_lt_exclusive]
   *   fixed32 another_value = 3 [(buf.validate.field).fixed32 = { gte: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: fixed32 gte = 5;
   */
  gte?: number;

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message
   * is generated.
   *
   * ```proto
   * message MyFixed32 {
   *   // value must be in list [1, 2, 3]
   *   fixed32 value = 1 [(buf.validate.field).fixed32 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated fixed32 in = 6;
   */
  in?: number[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyFixed32 {
   *   // value must not be in list [1, 2, 3]
   *   fixed32 value = 1 [(buf.validate.field).fixed32 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated fixed32 not_in = 7;
   */
  notIn?: number[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyFixed32 {
   *   fixed32 value = 1 [
   *     (buf.validate.field).fixed32.example = 1,
   *     (buf.validate.field).fixed32.example = 2
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated fixed32 example = 8;
   */
  example?: number[];
};

/**
 * Describes the message buf.validate.Fixed32Rules.
 * Use `create(Fixed32RulesSchema)` to create a new message.
 */
export declare const Fixed32RulesSchema: GenMessage<Fixed32Rules, {jsonType: Fixed32RulesJson}>;

/**
 * Fixed64Rules describes the rules applied to `fixed64` values.
 *
 * @generated from message buf.validate.Fixed64Rules
 */
export declare type Fixed64Rules = Message<"buf.validate.Fixed64Rules"> & {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyFixed64 {
   *   // value must equal 42
   *   fixed64 value = 1 [(buf.validate.field).fixed64.const = 42];
   * }
   * ```
   *
   * @generated from field: optional fixed64 const = 1;
   */
  const: bigint;

  /**
   * @generated from oneof buf.validate.Fixed64Rules.less_than
   */
  lessThan: {
    /**
     * `lt` requires the field value to be less than the specified value (field <
     * value). If the field value is equal to or greater than the specified value,
     * an error message is generated.
     *
     * ```proto
     * message MyFixed64 {
     *   // value must be less than 10
     *   fixed64 value = 1 [(buf.validate.field).fixed64.lt = 10];
     * }
     * ```
     *
     * @generated from field: fixed64 lt = 2;
     */
    value: bigint;
    case: "lt";
  } | {
    /**
     * `lte` requires the field value to be less than or equal to the specified
     * value (field <= value). If the field value is greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MyFixed64 {
     *   // value must be less than or equal to 10
     *   fixed64 value = 1 [(buf.validate.field).fixed64.lte = 10];
     * }
     * ```
     *
     * @generated from field: fixed64 lte = 3;
     */
    value: bigint;
    case: "lte";
  } | { case: undefined; value?: undefined };

  /**
   * @generated from oneof buf.validate.Fixed64Rules.greater_than
   */
  greaterThan: {
    /**
     * `gt` requires the field value to be greater than the specified value
     * (exclusive). If the value of `gt` is larger than a specified `lt` or
     * `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyFixed64 {
     *   // value must be greater than 5 [fixed64.gt]
     *   fixed64 value = 1 [(buf.validate.field).fixed64.gt = 5];
     *
     *   // value must be greater than 5 and less than 10 [fixed64.gt_lt]
     *   fixed64 other_value = 2 [(buf.validate.field).fixed64 = { gt: 5, lt: 10 }];
     *
     *   // value must be greater than 10 or less than 5 [fixed64.gt_lt_exclusive]
     *   fixed64 another_value = 3 [(buf.validate.field).fixed64 = { gt: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: fixed64 gt = 4;
     */
    value: bigint;
    case: "gt";
  } | {
    /**
     * `gte` requires the field value to be greater than or equal to the specified
     * value (exclusive). If the value of `gte` is larger than a specified `lt`
     * or `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyFixed64 {
     *   // value must be greater than or equal to 5 [fixed64.gte]
     *   fixed64 value = 1 [(buf.validate.field).fixed64.gte = 5];
     *
     *   // value must be greater than or equal to 5 and less than 10 [fixed64.gte_lt]
     *   fixed64 other_value = 2 [(buf.validate.field).fixed64 = { gte: 5, lt: 10 }];
     *
     *   // value must be greater than or equal to 10 or less than 5 [fixed64.gte_lt_exclusive]
     *   fixed64 another_value = 3 [(buf.validate.field).fixed64 = { gte: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: fixed64 gte = 5;
     */
    value: bigint;
    case: "gte";
  } | { case: undefined; value?: undefined };

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MyFixed64 {
   *   // value must be in list [1, 2, 3]
   *   fixed64 value = 1 [(buf.validate.field).fixed64 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated fixed64 in = 6;
   */
  in: bigint[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyFixed64 {
   *   // value must not be in list [1, 2, 3]
   *   fixed64 value = 1 [(buf.validate.field).fixed64 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated fixed64 not_in = 7;
   */
  notIn: bigint[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyFixed64 {
   *   fixed64 value = 1 [
   *     (buf.validate.field).fixed64.example = 1,
   *     (buf.validate.field).fixed64.example = 2
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated fixed64 example = 8;
   */
  example: bigint[];
};

/**
 * Fixed64Rules describes the rules applied to `fixed64` values.
 *
 * @generated from message buf.validate.Fixed64Rules
 */
export declare type Fixed64RulesJson = {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyFixed64 {
   *   // value must equal 42
   *   fixed64 value = 1 [(buf.validate.field).fixed64.const = 42];
   * }
   * ```
   *
   * @generated from field: optional fixed64 const = 1;
   */
  const?: string;

  /**
   * `lt` requires the field value to be less than the specified value (field <
   * value). If the field value is equal to or greater than the specified value,
   * an error message is generated.
   *
   * ```proto
   * message MyFixed64 {
   *   // value must be less than 10
   *   fixed64 value = 1 [(buf.validate.field).fixed64.lt = 10];
   * }
   * ```
   *
   * @generated from field: fixed64 lt = 2;
   */
  lt?: string;

  /**
   * `lte` requires the field value to be less than or equal to the specified
   * value (field <= value). If the field value is greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MyFixed64 {
   *   // value must be less than or equal to 10
   *   fixed64 value = 1 [(buf.validate.field).fixed64.lte = 10];
   * }
   * ```
   *
   * @generated from field: fixed64 lte = 3;
   */
  lte?: string;

  /**
   * `gt` requires the field value to be greater than the specified value
   * (exclusive). If the value of `gt` is larger than a specified `lt` or
   * `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyFixed64 {
   *   // value must be greater than 5 [fixed64.gt]
   *   fixed64 value = 1 [(buf.validate.field).fixed64.gt = 5];
   *
   *   // value must be greater than 5 and less than 10 [fixed64.gt_lt]
   *   fixed64 other_value = 2 [(buf.validate.field).fixed64 = { gt: 5, lt: 10 }];
   *
   *   // value must be greater than 10 or less than 5 [fixed64.gt_lt_exclusive]
   *   fixed64 another_value = 3 [(buf.validate.field).fixed64 = { gt: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: fixed64 gt = 4;
   */
  gt?: string;

  /**
   * `gte` requires the field value to be greater than or equal to the specified
   * value (exclusive). If the value of `gte` is larger than a specified `lt`
   * or `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyFixed64 {
   *   // value must be greater than or equal to 5 [fixed64.gte]
   *   fixed64 value = 1 [(buf.validate.field).fixed64.gte = 5];
   *
   *   // value must be greater than or equal to 5 and less than 10 [fixed64.gte_lt]
   *   fixed64 other_value = 2 [(buf.validate.field).fixed64 = { gte: 5, lt: 10 }];
   *
   *   // value must be greater than or equal to 10 or less than 5 [fixed64.gte_lt_exclusive]
   *   fixed64 another_value = 3 [(buf.validate.field).fixed64 = { gte: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: fixed64 gte = 5;
   */
  gte?: string;

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MyFixed64 {
   *   // value must be in list [1, 2, 3]
   *   fixed64 value = 1 [(buf.validate.field).fixed64 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated fixed64 in = 6;
   */
  in?: string[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyFixed64 {
   *   // value must not be in list [1, 2, 3]
   *   fixed64 value = 1 [(buf.validate.field).fixed64 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated fixed64 not_in = 7;
   */
  notIn?: string[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyFixed64 {
   *   fixed64 value = 1 [
   *     (buf.validate.field).fixed64.example = 1,
   *     (buf.validate.field).fixed64.example = 2
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated fixed64 example = 8;
   */
  example?: string[];
};

/**
 * Describes the message buf.validate.Fixed64Rules.
 * Use `create(Fixed64RulesSchema)` to create a new message.
 */
export declare const Fixed64RulesSchema: GenMessage<Fixed64Rules, {jsonType: Fixed64RulesJson}>;

/**
 * SFixed32Rules describes the rules applied to `fixed32` values.
 *
 * @generated from message buf.validate.SFixed32Rules
 */
export declare type SFixed32Rules = Message<"buf.validate.SFixed32Rules"> & {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MySFixed32 {
   *   // value must equal 42
   *   sfixed32 value = 1 [(buf.validate.field).sfixed32.const = 42];
   * }
   * ```
   *
   * @generated from field: optional sfixed32 const = 1;
   */
  const: number;

  /**
   * @generated from oneof buf.validate.SFixed32Rules.less_than
   */
  lessThan: {
    /**
     * `lt` requires the field value to be less than the specified value (field <
     * value). If the field value is equal to or greater than the specified value,
     * an error message is generated.
     *
     * ```proto
     * message MySFixed32 {
     *   // value must be less than 10
     *   sfixed32 value = 1 [(buf.validate.field).sfixed32.lt = 10];
     * }
     * ```
     *
     * @generated from field: sfixed32 lt = 2;
     */
    value: number;
    case: "lt";
  } | {
    /**
     * `lte` requires the field value to be less than or equal to the specified
     * value (field <= value). If the field value is greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MySFixed32 {
     *   // value must be less than or equal to 10
     *   sfixed32 value = 1 [(buf.validate.field).sfixed32.lte = 10];
     * }
     * ```
     *
     * @generated from field: sfixed32 lte = 3;
     */
    value: number;
    case: "lte";
  } | { case: undefined; value?: undefined };

  /**
   * @generated from oneof buf.validate.SFixed32Rules.greater_than
   */
  greaterThan: {
    /**
     * `gt` requires the field value to be greater than the specified value
     * (exclusive). If the value of `gt` is larger than a specified `lt` or
     * `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MySFixed32 {
     *   // value must be greater than 5 [sfixed32.gt]
     *   sfixed32 value = 1 [(buf.validate.field).sfixed32.gt = 5];
     *
     *   // value must be greater than 5 and less than 10 [sfixed32.gt_lt]
     *   sfixed32 other_value = 2 [(buf.validate.field).sfixed32 = { gt: 5, lt: 10 }];
     *
     *   // value must be greater than 10 or less than 5 [sfixed32.gt_lt_exclusive]
     *   sfixed32 another_value = 3 [(buf.validate.field).sfixed32 = { gt: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: sfixed32 gt = 4;
     */
    value: number;
    case: "gt";
  } | {
    /**
     * `gte` requires the field value to be greater than or equal to the specified
     * value (exclusive). If the value of `gte` is larger than a specified `lt`
     * or `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MySFixed32 {
     *   // value must be greater than or equal to 5 [sfixed32.gte]
     *   sfixed32 value = 1 [(buf.validate.field).sfixed32.gte = 5];
     *
     *   // value must be greater than or equal to 5 and less than 10 [sfixed32.gte_lt]
     *   sfixed32 other_value = 2 [(buf.validate.field).sfixed32 = { gte: 5, lt: 10 }];
     *
     *   // value must be greater than or equal to 10 or less than 5 [sfixed32.gte_lt_exclusive]
     *   sfixed32 another_value = 3 [(buf.validate.field).sfixed32 = { gte: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: sfixed32 gte = 5;
     */
    value: number;
    case: "gte";
  } | { case: undefined; value?: undefined };

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MySFixed32 {
   *   // value must be in list [1, 2, 3]
   *   sfixed32 value = 1 [(buf.validate.field).sfixed32 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sfixed32 in = 6;
   */
  in: number[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MySFixed32 {
   *   // value must not be in list [1, 2, 3]
   *   sfixed32 value = 1 [(buf.validate.field).sfixed32 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sfixed32 not_in = 7;
   */
  notIn: number[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MySFixed32 {
   *   sfixed32 value = 1 [
   *     (buf.validate.field).sfixed32.example = 1,
   *     (buf.validate.field).sfixed32.example = 2
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated sfixed32 example = 8;
   */
  example: number[];
};

/**
 * SFixed32Rules describes the rules applied to `fixed32` values.
 *
 * @generated from message buf.validate.SFixed32Rules
 */
export declare type SFixed32RulesJson = {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MySFixed32 {
   *   // value must equal 42
   *   sfixed32 value = 1 [(buf.validate.field).sfixed32.const = 42];
   * }
   * ```
   *
   * @generated from field: optional sfixed32 const = 1;
   */
  const?: number;

  /**
   * `lt` requires the field value to be less than the specified value (field <
   * value). If the field value is equal to or greater than the specified value,
   * an error message is generated.
   *
   * ```proto
   * message MySFixed32 {
   *   // value must be less than 10
   *   sfixed32 value = 1 [(buf.validate.field).sfixed32.lt = 10];
   * }
   * ```
   *
   * @generated from field: sfixed32 lt = 2;
   */
  lt?: number;

  /**
   * `lte` requires the field value to be less than or equal to the specified
   * value (field <= value). If the field value is greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MySFixed32 {
   *   // value must be less than or equal to 10
   *   sfixed32 value = 1 [(buf.validate.field).sfixed32.lte = 10];
   * }
   * ```
   *
   * @generated from field: sfixed32 lte = 3;
   */
  lte?: number;

  /**
   * `gt` requires the field value to be greater than the specified value
   * (exclusive). If the value of `gt` is larger than a specified `lt` or
   * `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MySFixed32 {
   *   // value must be greater than 5 [sfixed32.gt]
   *   sfixed32 value = 1 [(buf.validate.field).sfixed32.gt = 5];
   *
   *   // value must be greater than 5 and less than 10 [sfixed32.gt_lt]
   *   sfixed32 other_value = 2 [(buf.validate.field).sfixed32 = { gt: 5, lt: 10 }];
   *
   *   // value must be greater than 10 or less than 5 [sfixed32.gt_lt_exclusive]
   *   sfixed32 another_value = 3 [(buf.validate.field).sfixed32 = { gt: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: sfixed32 gt = 4;
   */
  gt?: number;

  /**
   * `gte` requires the field value to be greater than or equal to the specified
   * value (exclusive). If the value of `gte` is larger than a specified `lt`
   * or `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MySFixed32 {
   *   // value must be greater than or equal to 5 [sfixed32.gte]
   *   sfixed32 value = 1 [(buf.validate.field).sfixed32.gte = 5];
   *
   *   // value must be greater than or equal to 5 and less than 10 [sfixed32.gte_lt]
   *   sfixed32 other_value = 2 [(buf.validate.field).sfixed32 = { gte: 5, lt: 10 }];
   *
   *   // value must be greater than or equal to 10 or less than 5 [sfixed32.gte_lt_exclusive]
   *   sfixed32 another_value = 3 [(buf.validate.field).sfixed32 = { gte: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: sfixed32 gte = 5;
   */
  gte?: number;

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MySFixed32 {
   *   // value must be in list [1, 2, 3]
   *   sfixed32 value = 1 [(buf.validate.field).sfixed32 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sfixed32 in = 6;
   */
  in?: number[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MySFixed32 {
   *   // value must not be in list [1, 2, 3]
   *   sfixed32 value = 1 [(buf.validate.field).sfixed32 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sfixed32 not_in = 7;
   */
  notIn?: number[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MySFixed32 {
   *   sfixed32 value = 1 [
   *     (buf.validate.field).sfixed32.example = 1,
   *     (buf.validate.field).sfixed32.example = 2
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated sfixed32 example = 8;
   */
  example?: number[];
};

/**
 * Describes the message buf.validate.SFixed32Rules.
 * Use `create(SFixed32RulesSchema)` to create a new message.
 */
export declare const SFixed32RulesSchema: GenMessage<SFixed32Rules, {jsonType: SFixed32RulesJson}>;

/**
 * SFixed64Rules describes the rules applied to `fixed64` values.
 *
 * @generated from message buf.validate.SFixed64Rules
 */
export declare type SFixed64Rules = Message<"buf.validate.SFixed64Rules"> & {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MySFixed64 {
   *   // value must equal 42
   *   sfixed64 value = 1 [(buf.validate.field).sfixed64.const = 42];
   * }
   * ```
   *
   * @generated from field: optional sfixed64 const = 1;
   */
  const: bigint;

  /**
   * @generated from oneof buf.validate.SFixed64Rules.less_than
   */
  lessThan: {
    /**
     * `lt` requires the field value to be less than the specified value (field <
     * value). If the field value is equal to or greater than the specified value,
     * an error message is generated.
     *
     * ```proto
     * message MySFixed64 {
     *   // value must be less than 10
     *   sfixed64 value = 1 [(buf.validate.field).sfixed64.lt = 10];
     * }
     * ```
     *
     * @generated from field: sfixed64 lt = 2;
     */
    value: bigint;
    case: "lt";
  } | {
    /**
     * `lte` requires the field value to be less than or equal to the specified
     * value (field <= value). If the field value is greater than the specified
     * value, an error message is generated.
     *
     * ```proto
     * message MySFixed64 {
     *   // value must be less than or equal to 10
     *   sfixed64 value = 1 [(buf.validate.field).sfixed64.lte = 10];
     * }
     * ```
     *
     * @generated from field: sfixed64 lte = 3;
     */
    value: bigint;
    case: "lte";
  } | { case: undefined; value?: undefined };

  /**
   * @generated from oneof buf.validate.SFixed64Rules.greater_than
   */
  greaterThan: {
    /**
     * `gt` requires the field value to be greater than the specified value
     * (exclusive). If the value of `gt` is larger than a specified `lt` or
     * `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MySFixed64 {
     *   // value must be greater than 5 [sfixed64.gt]
     *   sfixed64 value = 1 [(buf.validate.field).sfixed64.gt = 5];
     *
     *   // value must be greater than 5 and less than 10 [sfixed64.gt_lt]
     *   sfixed64 other_value = 2 [(buf.validate.field).sfixed64 = { gt: 5, lt: 10 }];
     *
     *   // value must be greater than 10 or less than 5 [sfixed64.gt_lt_exclusive]
     *   sfixed64 another_value = 3 [(buf.validate.field).sfixed64 = { gt: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: sfixed64 gt = 4;
     */
    value: bigint;
    case: "gt";
  } | {
    /**
     * `gte` requires the field value to be greater than or equal to the specified
     * value (exclusive). If the value of `gte` is larger than a specified `lt`
     * or `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MySFixed64 {
     *   // value must be greater than or equal to 5 [sfixed64.gte]
     *   sfixed64 value = 1 [(buf.validate.field).sfixed64.gte = 5];
     *
     *   // value must be greater than or equal to 5 and less than 10 [sfixed64.gte_lt]
     *   sfixed64 other_value = 2 [(buf.validate.field).sfixed64 = { gte: 5, lt: 10 }];
     *
     *   // value must be greater than or equal to 10 or less than 5 [sfixed64.gte_lt_exclusive]
     *   sfixed64 another_value = 3 [(buf.validate.field).sfixed64 = { gte: 10, lt: 5 }];
     * }
     * ```
     *
     * @generated from field: sfixed64 gte = 5;
     */
    value: bigint;
    case: "gte";
  } | { case: undefined; value?: undefined };

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MySFixed64 {
   *   // value must be in list [1, 2, 3]
   *   sfixed64 value = 1 [(buf.validate.field).sfixed64 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sfixed64 in = 6;
   */
  in: bigint[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MySFixed64 {
   *   // value must not be in list [1, 2, 3]
   *   sfixed64 value = 1 [(buf.validate.field).sfixed64 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sfixed64 not_in = 7;
   */
  notIn: bigint[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MySFixed64 {
   *   sfixed64 value = 1 [
   *     (buf.validate.field).sfixed64.example = 1,
   *     (buf.validate.field).sfixed64.example = 2
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated sfixed64 example = 8;
   */
  example: bigint[];
};

/**
 * SFixed64Rules describes the rules applied to `fixed64` values.
 *
 * @generated from message buf.validate.SFixed64Rules
 */
export declare type SFixed64RulesJson = {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MySFixed64 {
   *   // value must equal 42
   *   sfixed64 value = 1 [(buf.validate.field).sfixed64.const = 42];
   * }
   * ```
   *
   * @generated from field: optional sfixed64 const = 1;
   */
  const?: string;

  /**
   * `lt` requires the field value to be less than the specified value (field <
   * value). If the field value is equal to or greater than the specified value,
   * an error message is generated.
   *
   * ```proto
   * message MySFixed64 {
   *   // value must be less than 10
   *   sfixed64 value = 1 [(buf.validate.field).sfixed64.lt = 10];
   * }
   * ```
   *
   * @generated from field: sfixed64 lt = 2;
   */
  lt?: string;

  /**
   * `lte` requires the field value to be less than or equal to the specified
   * value (field <= value). If the field value is greater than the specified
   * value, an error message is generated.
   *
   * ```proto
   * message MySFixed64 {
   *   // value must be less than or equal to 10
   *   sfixed64 value = 1 [(buf.validate.field).sfixed64.lte = 10];
   * }
   * ```
   *
   * @generated from field: sfixed64 lte = 3;
   */
  lte?: string;

  /**
   * `gt` requires the field value to be greater than the specified value
   * (exclusive). If the value of `gt` is larger than a specified `lt` or
   * `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MySFixed64 {
   *   // value must be greater than 5 [sfixed64.gt]
   *   sfixed64 value = 1 [(buf.validate.field).sfixed64.gt = 5];
   *
   *   // value must be greater than 5 and less than 10 [sfixed64.gt_lt]
   *   sfixed64 other_value = 2 [(buf.validate.field).sfixed64 = { gt: 5, lt: 10 }];
   *
   *   // value must be greater than 10 or less than 5 [sfixed64.gt_lt_exclusive]
   *   sfixed64 another_value = 3 [(buf.validate.field).sfixed64 = { gt: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: sfixed64 gt = 4;
   */
  gt?: string;

  /**
   * `gte` requires the field value to be greater than or equal to the specified
   * value (exclusive). If the value of `gte` is larger than a specified `lt`
   * or `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MySFixed64 {
   *   // value must be greater than or equal to 5 [sfixed64.gte]
   *   sfixed64 value = 1 [(buf.validate.field).sfixed64.gte = 5];
   *
   *   // value must be greater than or equal to 5 and less than 10 [sfixed64.gte_lt]
   *   sfixed64 other_value = 2 [(buf.validate.field).sfixed64 = { gte: 5, lt: 10 }];
   *
   *   // value must be greater than or equal to 10 or less than 5 [sfixed64.gte_lt_exclusive]
   *   sfixed64 another_value = 3 [(buf.validate.field).sfixed64 = { gte: 10, lt: 5 }];
   * }
   * ```
   *
   * @generated from field: sfixed64 gte = 5;
   */
  gte?: string;

  /**
   * `in` requires the field value to be equal to one of the specified values.
   * If the field value isn't one of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MySFixed64 {
   *   // value must be in list [1, 2, 3]
   *   sfixed64 value = 1 [(buf.validate.field).sfixed64 = { in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sfixed64 in = 6;
   */
  in?: string[];

  /**
   * `not_in` requires the field value to not be equal to any of the specified
   * values. If the field value is one of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MySFixed64 {
   *   // value must not be in list [1, 2, 3]
   *   sfixed64 value = 1 [(buf.validate.field).sfixed64 = { not_in: [1, 2, 3] }];
   * }
   * ```
   *
   * @generated from field: repeated sfixed64 not_in = 7;
   */
  notIn?: string[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MySFixed64 {
   *   sfixed64 value = 1 [
   *     (buf.validate.field).sfixed64.example = 1,
   *     (buf.validate.field).sfixed64.example = 2
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated sfixed64 example = 8;
   */
  example?: string[];
};

/**
 * Describes the message buf.validate.SFixed64Rules.
 * Use `create(SFixed64RulesSchema)` to create a new message.
 */
export declare const SFixed64RulesSchema: GenMessage<SFixed64Rules, {jsonType: SFixed64RulesJson}>;

/**
 * BoolRules describes the rules applied to `bool` values. These rules
 * may also be applied to the `google.protobuf.BoolValue` Well-Known-Type.
 *
 * @generated from message buf.validate.BoolRules
 */
export declare type BoolRules = Message<"buf.validate.BoolRules"> & {
  /**
   * `const` requires the field value to exactly match the specified boolean value.
   * If the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyBool {
   *   // value must equal true
   *   bool value = 1 [(buf.validate.field).bool.const = true];
   * }
   * ```
   *
   * @generated from field: optional bool const = 1;
   */
  const: boolean;

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyBool {
   *   bool value = 1 [
   *     (buf.validate.field).bool.example = 1,
   *     (buf.validate.field).bool.example = 2
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated bool example = 2;
   */
  example: boolean[];
};

/**
 * BoolRules describes the rules applied to `bool` values. These rules
 * may also be applied to the `google.protobuf.BoolValue` Well-Known-Type.
 *
 * @generated from message buf.validate.BoolRules
 */
export declare type BoolRulesJson = {
  /**
   * `const` requires the field value to exactly match the specified boolean value.
   * If the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyBool {
   *   // value must equal true
   *   bool value = 1 [(buf.validate.field).bool.const = true];
   * }
   * ```
   *
   * @generated from field: optional bool const = 1;
   */
  const?: boolean;

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyBool {
   *   bool value = 1 [
   *     (buf.validate.field).bool.example = 1,
   *     (buf.validate.field).bool.example = 2
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated bool example = 2;
   */
  example?: boolean[];
};

/**
 * Describes the message buf.validate.BoolRules.
 * Use `create(BoolRulesSchema)` to create a new message.
 */
export declare const BoolRulesSchema: GenMessage<BoolRules, {jsonType: BoolRulesJson}>;

/**
 * StringRules describes the rules applied to `string` values These
 * rules may also be applied to the `google.protobuf.StringValue` Well-Known-Type.
 *
 * @generated from message buf.validate.StringRules
 */
export declare type StringRules = Message<"buf.validate.StringRules"> & {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyString {
   *   // value must equal `hello`
   *   string value = 1 [(buf.validate.field).string.const = "hello"];
   * }
   * ```
   *
   * @generated from field: optional string const = 1;
   */
  const: string;

  /**
   * `len` dictates that the field value must have the specified
   * number of characters (Unicode code points), which may differ from the number
   * of bytes in the string. If the field value does not meet the specified
   * length, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value length must be 5 characters
   *   string value = 1 [(buf.validate.field).string.len = 5];
   * }
   * ```
   *
   * @generated from field: optional uint64 len = 19;
   */
  len: bigint;

  /**
   * `min_len` specifies that the field value must have at least the specified
   * number of characters (Unicode code points), which may differ from the number
   * of bytes in the string. If the field value contains fewer characters, an error
   * message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value length must be at least 3 characters
   *   string value = 1 [(buf.validate.field).string.min_len = 3];
   * }
   * ```
   *
   * @generated from field: optional uint64 min_len = 2;
   */
  minLen: bigint;

  /**
   * `max_len` specifies that the field value must have no more than the specified
   * number of characters (Unicode code points), which may differ from the
   * number of bytes in the string. If the field value contains more characters,
   * an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value length must be at most 10 characters
   *   string value = 1 [(buf.validate.field).string.max_len = 10];
   * }
   * ```
   *
   * @generated from field: optional uint64 max_len = 3;
   */
  maxLen: bigint;

  /**
   * `len_bytes` dictates that the field value must have the specified number of
   * bytes. If the field value does not match the specified length in bytes,
   * an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value length must be 6 bytes
   *   string value = 1 [(buf.validate.field).string.len_bytes = 6];
   * }
   * ```
   *
   * @generated from field: optional uint64 len_bytes = 20;
   */
  lenBytes: bigint;

  /**
   * `min_bytes` specifies that the field value must have at least the specified
   * number of bytes. If the field value contains fewer bytes, an error message
   * will be generated.
   *
   * ```proto
   * message MyString {
   *   // value length must be at least 4 bytes
   *   string value = 1 [(buf.validate.field).string.min_bytes = 4];
   * }
   *
   * ```
   *
   * @generated from field: optional uint64 min_bytes = 4;
   */
  minBytes: bigint;

  /**
   * `max_bytes` specifies that the field value must have no more than the
   * specified number of bytes. If the field value contains more bytes, an
   * error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value length must be at most 8 bytes
   *   string value = 1 [(buf.validate.field).string.max_bytes = 8];
   * }
   * ```
   *
   * @generated from field: optional uint64 max_bytes = 5;
   */
  maxBytes: bigint;

  /**
   * `pattern` specifies that the field value must match the specified
   * regular expression (RE2 syntax), with the expression provided without any
   * delimiters. If the field value doesn't match the regular expression, an
   * error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value does not match regex pattern `^[a-zA-Z]//$`
   *   string value = 1 [(buf.validate.field).string.pattern = "^[a-zA-Z]//$"];
   * }
   * ```
   *
   * @generated from field: optional string pattern = 6;
   */
  pattern: string;

  /**
   * `prefix` specifies that the field value must have the
   * specified substring at the beginning of the string. If the field value
   * doesn't start with the specified prefix, an error message will be
   * generated.
   *
   * ```proto
   * message MyString {
   *   // value does not have prefix `pre`
   *   string value = 1 [(buf.validate.field).string.prefix = "pre"];
   * }
   * ```
   *
   * @generated from field: optional string prefix = 7;
   */
  prefix: string;

  /**
   * `suffix` specifies that the field value must have the
   * specified substring at the end of the string. If the field value doesn't
   * end with the specified suffix, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value does not have suffix `post`
   *   string value = 1 [(buf.validate.field).string.suffix = "post"];
   * }
   * ```
   *
   * @generated from field: optional string suffix = 8;
   */
  suffix: string;

  /**
   * `contains` specifies that the field value must have the
   * specified substring anywhere in the string. If the field value doesn't
   * contain the specified substring, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value does not contain substring `inside`.
   *   string value = 1 [(buf.validate.field).string.contains = "inside"];
   * }
   * ```
   *
   * @generated from field: optional string contains = 9;
   */
  contains: string;

  /**
   * `not_contains` specifies that the field value must not have the
   * specified substring anywhere in the string. If the field value contains
   * the specified substring, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value contains substring `inside`.
   *   string value = 1 [(buf.validate.field).string.not_contains = "inside"];
   * }
   * ```
   *
   * @generated from field: optional string not_contains = 23;
   */
  notContains: string;

  /**
   * `in` specifies that the field value must be equal to one of the specified
   * values. If the field value isn't one of the specified values, an error
   * message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be in list ["apple", "banana"]
   *   string value = 1 [(buf.validate.field).string.in = "apple", (buf.validate.field).string.in = "banana"];
   * }
   * ```
   *
   * @generated from field: repeated string in = 10;
   */
  in: string[];

  /**
   * `not_in` specifies that the field value cannot be equal to any
   * of the specified values. If the field value is one of the specified values,
   * an error message will be generated.
   * ```proto
   * message MyString {
   *   // value must not be in list ["orange", "grape"]
   *   string value = 1 [(buf.validate.field).string.not_in = "orange", (buf.validate.field).string.not_in = "grape"];
   * }
   * ```
   *
   * @generated from field: repeated string not_in = 11;
   */
  notIn: string[];

  /**
   * `WellKnown` rules provide advanced rules against common string
   * patterns.
   *
   * @generated from oneof buf.validate.StringRules.well_known
   */
  wellKnown: {
    /**
     * `email` specifies that the field value must be a valid email address, for
     * example "foo@example.com".
     *
     * Conforms to the definition for a valid email address from the [HTML standard](https://html.spec.whatwg.org/multipage/input.html#valid-e-mail-address).
     * Note that this standard willfully deviates from [RFC 5322](https://datatracker.ietf.org/doc/html/rfc5322),
     * which allows many unexpected forms of email addresses and will easily match
     * a typographical error.
     *
     * If the field value isn't a valid email address, an error message will be generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid email address
     *   string value = 1 [(buf.validate.field).string.email = true];
     * }
     * ```
     *
     * @generated from field: bool email = 12;
     */
    value: boolean;
    case: "email";
  } | {
    /**
     * `hostname` specifies that the field value must be a valid hostname, for
     * example "foo.example.com".
     *
     * A valid hostname follows the rules below:
     * - The name consists of one or more labels, separated by a dot (".").
     * - Each label can be 1 to 63 alphanumeric characters.
     * - A label can contain hyphens ("-"), but must not start or end with a hyphen.
     * - The right-most label must not be digits only.
     * - The name can have a trailing dot—for example, "foo.example.com.".
     * - The name can be 253 characters at most, excluding the optional trailing dot.
     *
     * If the field value isn't a valid hostname, an error message will be generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid hostname
     *   string value = 1 [(buf.validate.field).string.hostname = true];
     * }
     * ```
     *
     * @generated from field: bool hostname = 13;
     */
    value: boolean;
    case: "hostname";
  } | {
    /**
     * `ip` specifies that the field value must be a valid IP (v4 or v6) address.
     *
     * IPv4 addresses are expected in the dotted decimal format—for example, "192.168.5.21".
     * IPv6 addresses are expected in their text representation—for example, "::1",
     * or "2001:0DB8:ABCD:0012::0".
     *
     * Both formats are well-defined in the internet standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986).
     * Zone identifiers for IPv6 addresses (for example, "fe80::a%en1") are supported.
     *
     * If the field value isn't a valid IP address, an error message will be
     * generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid IP address
     *   string value = 1 [(buf.validate.field).string.ip = true];
     * }
     * ```
     *
     * @generated from field: bool ip = 14;
     */
    value: boolean;
    case: "ip";
  } | {
    /**
     * `ipv4` specifies that the field value must be a valid IPv4 address—for
     * example "192.168.5.21". If the field value isn't a valid IPv4 address, an
     * error message will be generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid IPv4 address
     *   string value = 1 [(buf.validate.field).string.ipv4 = true];
     * }
     * ```
     *
     * @generated from field: bool ipv4 = 15;
     */
    value: boolean;
    case: "ipv4";
  } | {
    /**
     * `ipv6` specifies that the field value must be a valid IPv6 address—for
     * example "::1", or "d7a:115c:a1e0:ab12:4843:cd96:626b:430b". If the field
     * value is not a valid IPv6 address, an error message will be generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid IPv6 address
     *   string value = 1 [(buf.validate.field).string.ipv6 = true];
     * }
     * ```
     *
     * @generated from field: bool ipv6 = 16;
     */
    value: boolean;
    case: "ipv6";
  } | {
    /**
     * `uri` specifies that the field value must be a valid URI, for example
     * "https://example.com/foo/bar?baz=quux#frag".
     *
     * URI is defined in the internet standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986).
     * Zone Identifiers in IPv6 address literals are supported ([RFC 6874](https://datatracker.ietf.org/doc/html/rfc6874)).
     *
     * If the field value isn't a valid URI, an error message will be generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid URI
     *   string value = 1 [(buf.validate.field).string.uri = true];
     * }
     * ```
     *
     * @generated from field: bool uri = 17;
     */
    value: boolean;
    case: "uri";
  } | {
    /**
     * `uri_ref` specifies that the field value must be a valid URI Reference—either
     * a URI such as "https://example.com/foo/bar?baz=quux#frag", or a Relative
     * Reference such as "./foo/bar?query".
     *
     * URI, URI Reference, and Relative Reference are defined in the internet
     * standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986). Zone
     * Identifiers in IPv6 address literals are supported ([RFC 6874](https://datatracker.ietf.org/doc/html/rfc6874)).
     *
     * If the field value isn't a valid URI Reference, an error message will be
     * generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid URI Reference
     *   string value = 1 [(buf.validate.field).string.uri_ref = true];
     * }
     * ```
     *
     * @generated from field: bool uri_ref = 18;
     */
    value: boolean;
    case: "uriRef";
  } | {
    /**
     * `address` specifies that the field value must be either a valid hostname
     * (for example, "example.com"), or a valid IP (v4 or v6) address (for example,
     * "192.168.0.1", or "::1"). If the field value isn't a valid hostname or IP,
     * an error message will be generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid hostname, or ip address
     *   string value = 1 [(buf.validate.field).string.address = true];
     * }
     * ```
     *
     * @generated from field: bool address = 21;
     */
    value: boolean;
    case: "address";
  } | {
    /**
     * `uuid` specifies that the field value must be a valid UUID as defined by
     * [RFC 4122](https://datatracker.ietf.org/doc/html/rfc4122#section-4.1.2). If the
     * field value isn't a valid UUID, an error message will be generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid UUID
     *   string value = 1 [(buf.validate.field).string.uuid = true];
     * }
     * ```
     *
     * @generated from field: bool uuid = 22;
     */
    value: boolean;
    case: "uuid";
  } | {
    /**
     * `tuuid` (trimmed UUID) specifies that the field value must be a valid UUID as
     * defined by [RFC 4122](https://datatracker.ietf.org/doc/html/rfc4122#section-4.1.2) with all dashes
     * omitted. If the field value isn't a valid UUID without dashes, an error message
     * will be generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid trimmed UUID
     *   string value = 1 [(buf.validate.field).string.tuuid = true];
     * }
     * ```
     *
     * @generated from field: bool tuuid = 33;
     */
    value: boolean;
    case: "tuuid";
  } | {
    /**
     * `ip_with_prefixlen` specifies that the field value must be a valid IP
     * (v4 or v6) address with prefix length—for example, "192.168.5.21/16" or
     * "2001:0DB8:ABCD:0012::F1/64". If the field value isn't a valid IP with
     * prefix length, an error message will be generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid IP with prefix length
     *    string value = 1 [(buf.validate.field).string.ip_with_prefixlen = true];
     * }
     * ```
     *
     * @generated from field: bool ip_with_prefixlen = 26;
     */
    value: boolean;
    case: "ipWithPrefixlen";
  } | {
    /**
     * `ipv4_with_prefixlen` specifies that the field value must be a valid
     * IPv4 address with prefix length—for example, "192.168.5.21/16". If the
     * field value isn't a valid IPv4 address with prefix length, an error
     * message will be generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid IPv4 address with prefix length
     *    string value = 1 [(buf.validate.field).string.ipv4_with_prefixlen = true];
     * }
     * ```
     *
     * @generated from field: bool ipv4_with_prefixlen = 27;
     */
    value: boolean;
    case: "ipv4WithPrefixlen";
  } | {
    /**
     * `ipv6_with_prefixlen` specifies that the field value must be a valid
     * IPv6 address with prefix length—for example, "2001:0DB8:ABCD:0012::F1/64".
     * If the field value is not a valid IPv6 address with prefix length,
     * an error message will be generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid IPv6 address prefix length
     *    string value = 1 [(buf.validate.field).string.ipv6_with_prefixlen = true];
     * }
     * ```
     *
     * @generated from field: bool ipv6_with_prefixlen = 28;
     */
    value: boolean;
    case: "ipv6WithPrefixlen";
  } | {
    /**
     * `ip_prefix` specifies that the field value must be a valid IP (v4 or v6)
     * prefix—for example, "192.168.0.0/16" or "2001:0DB8:ABCD:0012::0/64".
     *
     * The prefix must have all zeros for the unmasked bits. For example,
     * "2001:0DB8:ABCD:0012::0/64" designates the left-most 64 bits for the
     * prefix, and the remaining 64 bits must be zero.
     *
     * If the field value isn't a valid IP prefix, an error message will be
     * generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid IP prefix
     *    string value = 1 [(buf.validate.field).string.ip_prefix = true];
     * }
     * ```
     *
     * @generated from field: bool ip_prefix = 29;
     */
    value: boolean;
    case: "ipPrefix";
  } | {
    /**
     * `ipv4_prefix` specifies that the field value must be a valid IPv4
     * prefix, for example "192.168.0.0/16".
     *
     * The prefix must have all zeros for the unmasked bits. For example,
     * "192.168.0.0/16" designates the left-most 16 bits for the prefix,
     * and the remaining 16 bits must be zero.
     *
     * If the field value isn't a valid IPv4 prefix, an error message
     * will be generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid IPv4 prefix
     *    string value = 1 [(buf.validate.field).string.ipv4_prefix = true];
     * }
     * ```
     *
     * @generated from field: bool ipv4_prefix = 30;
     */
    value: boolean;
    case: "ipv4Prefix";
  } | {
    /**
     * `ipv6_prefix` specifies that the field value must be a valid IPv6 prefix—for
     * example, "2001:0DB8:ABCD:0012::0/64".
     *
     * The prefix must have all zeros for the unmasked bits. For example,
     * "2001:0DB8:ABCD:0012::0/64" designates the left-most 64 bits for the
     * prefix, and the remaining 64 bits must be zero.
     *
     * If the field value is not a valid IPv6 prefix, an error message will be
     * generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid IPv6 prefix
     *    string value = 1 [(buf.validate.field).string.ipv6_prefix = true];
     * }
     * ```
     *
     * @generated from field: bool ipv6_prefix = 31;
     */
    value: boolean;
    case: "ipv6Prefix";
  } | {
    /**
     * `host_and_port` specifies that the field value must be valid host/port
     * pair—for example, "example.com:8080".
     *
     * The host can be one of:
     * - An IPv4 address in dotted decimal format—for example, "192.168.5.21".
     * - An IPv6 address enclosed in square brackets—for example, "[2001:0DB8:ABCD:0012::F1]".
     * - A hostname—for example, "example.com".
     *
     * The port is separated by a colon. It must be non-empty, with a decimal number
     * in the range of 0-65535, inclusive.
     *
     * @generated from field: bool host_and_port = 32;
     */
    value: boolean;
    case: "hostAndPort";
  } | {
    /**
     * `well_known_regex` specifies a common well-known pattern
     * defined as a regex. If the field value doesn't match the well-known
     * regex, an error message will be generated.
     *
     * ```proto
     * message MyString {
     *   // value must be a valid HTTP header value
     *   string value = 1 [(buf.validate.field).string.well_known_regex = KNOWN_REGEX_HTTP_HEADER_VALUE];
     * }
     * ```
     *
     * #### KnownRegex
     *
     * `well_known_regex` contains some well-known patterns.
     *
     * | Name                          | Number | Description                               |
     * |-------------------------------|--------|-------------------------------------------|
     * | KNOWN_REGEX_UNSPECIFIED       | 0      |                                           |
     * | KNOWN_REGEX_HTTP_HEADER_NAME  | 1      | HTTP header name as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2)  |
     * | KNOWN_REGEX_HTTP_HEADER_VALUE | 2      | HTTP header value as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.4) |
     *
     * @generated from field: buf.validate.KnownRegex well_known_regex = 24;
     */
    value: KnownRegex;
    case: "wellKnownRegex";
  } | { case: undefined; value?: undefined };

  /**
   * This applies to regexes `HTTP_HEADER_NAME` and `HTTP_HEADER_VALUE` to
   * enable strict header validation. By default, this is true, and HTTP header
   * validations are [RFC-compliant](https://datatracker.ietf.org/doc/html/rfc7230#section-3). Setting to false will enable looser
   * validations that only disallow `\r\n\0` characters, which can be used to
   * bypass header matching rules.
   *
   * ```proto
   * message MyString {
   *   // The field `value` must have be a valid HTTP headers, but not enforced with strict rules.
   *   string value = 1 [(buf.validate.field).string.strict = false];
   * }
   * ```
   *
   * @generated from field: optional bool strict = 25;
   */
  strict: boolean;

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyString {
   *   string value = 1 [
   *     (buf.validate.field).string.example = "hello",
   *     (buf.validate.field).string.example = "world"
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated string example = 34;
   */
  example: string[];
};

/**
 * StringRules describes the rules applied to `string` values These
 * rules may also be applied to the `google.protobuf.StringValue` Well-Known-Type.
 *
 * @generated from message buf.validate.StringRules
 */
export declare type StringRulesJson = {
  /**
   * `const` requires the field value to exactly match the specified value. If
   * the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyString {
   *   // value must equal `hello`
   *   string value = 1 [(buf.validate.field).string.const = "hello"];
   * }
   * ```
   *
   * @generated from field: optional string const = 1;
   */
  const?: string;

  /**
   * `len` dictates that the field value must have the specified
   * number of characters (Unicode code points), which may differ from the number
   * of bytes in the string. If the field value does not meet the specified
   * length, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value length must be 5 characters
   *   string value = 1 [(buf.validate.field).string.len = 5];
   * }
   * ```
   *
   * @generated from field: optional uint64 len = 19;
   */
  len?: string;

  /**
   * `min_len` specifies that the field value must have at least the specified
   * number of characters (Unicode code points), which may differ from the number
   * of bytes in the string. If the field value contains fewer characters, an error
   * message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value length must be at least 3 characters
   *   string value = 1 [(buf.validate.field).string.min_len = 3];
   * }
   * ```
   *
   * @generated from field: optional uint64 min_len = 2;
   */
  minLen?: string;

  /**
   * `max_len` specifies that the field value must have no more than the specified
   * number of characters (Unicode code points), which may differ from the
   * number of bytes in the string. If the field value contains more characters,
   * an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value length must be at most 10 characters
   *   string value = 1 [(buf.validate.field).string.max_len = 10];
   * }
   * ```
   *
   * @generated from field: optional uint64 max_len = 3;
   */
  maxLen?: string;

  /**
   * `len_bytes` dictates that the field value must have the specified number of
   * bytes. If the field value does not match the specified length in bytes,
   * an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value length must be 6 bytes
   *   string value = 1 [(buf.validate.field).string.len_bytes = 6];
   * }
   * ```
   *
   * @generated from field: optional uint64 len_bytes = 20;
   */
  lenBytes?: string;

  /**
   * `min_bytes` specifies that the field value must have at least the specified
   * number of bytes. If the field value contains fewer bytes, an error message
   * will be generated.
   *
   * ```proto
   * message MyString {
   *   // value length must be at least 4 bytes
   *   string value = 1 [(buf.validate.field).string.min_bytes = 4];
   * }
   *
   * ```
   *
   * @generated from field: optional uint64 min_bytes = 4;
   */
  minBytes?: string;

  /**
   * `max_bytes` specifies that the field value must have no more than the
   * specified number of bytes. If the field value contains more bytes, an
   * error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value length must be at most 8 bytes
   *   string value = 1 [(buf.validate.field).string.max_bytes = 8];
   * }
   * ```
   *
   * @generated from field: optional uint64 max_bytes = 5;
   */
  maxBytes?: string;

  /**
   * `pattern` specifies that the field value must match the specified
   * regular expression (RE2 syntax), with the expression provided without any
   * delimiters. If the field value doesn't match the regular expression, an
   * error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value does not match regex pattern `^[a-zA-Z]//$`
   *   string value = 1 [(buf.validate.field).string.pattern = "^[a-zA-Z]//$"];
   * }
   * ```
   *
   * @generated from field: optional string pattern = 6;
   */
  pattern?: string;

  /**
   * `prefix` specifies that the field value must have the
   * specified substring at the beginning of the string. If the field value
   * doesn't start with the specified prefix, an error message will be
   * generated.
   *
   * ```proto
   * message MyString {
   *   // value does not have prefix `pre`
   *   string value = 1 [(buf.validate.field).string.prefix = "pre"];
   * }
   * ```
   *
   * @generated from field: optional string prefix = 7;
   */
  prefix?: string;

  /**
   * `suffix` specifies that the field value must have the
   * specified substring at the end of the string. If the field value doesn't
   * end with the specified suffix, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value does not have suffix `post`
   *   string value = 1 [(buf.validate.field).string.suffix = "post"];
   * }
   * ```
   *
   * @generated from field: optional string suffix = 8;
   */
  suffix?: string;

  /**
   * `contains` specifies that the field value must have the
   * specified substring anywhere in the string. If the field value doesn't
   * contain the specified substring, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value does not contain substring `inside`.
   *   string value = 1 [(buf.validate.field).string.contains = "inside"];
   * }
   * ```
   *
   * @generated from field: optional string contains = 9;
   */
  contains?: string;

  /**
   * `not_contains` specifies that the field value must not have the
   * specified substring anywhere in the string. If the field value contains
   * the specified substring, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value contains substring `inside`.
   *   string value = 1 [(buf.validate.field).string.not_contains = "inside"];
   * }
   * ```
   *
   * @generated from field: optional string not_contains = 23;
   */
  notContains?: string;

  /**
   * `in` specifies that the field value must be equal to one of the specified
   * values. If the field value isn't one of the specified values, an error
   * message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be in list ["apple", "banana"]
   *   string value = 1 [(buf.validate.field).string.in = "apple", (buf.validate.field).string.in = "banana"];
   * }
   * ```
   *
   * @generated from field: repeated string in = 10;
   */
  in?: string[];

  /**
   * `not_in` specifies that the field value cannot be equal to any
   * of the specified values. If the field value is one of the specified values,
   * an error message will be generated.
   * ```proto
   * message MyString {
   *   // value must not be in list ["orange", "grape"]
   *   string value = 1 [(buf.validate.field).string.not_in = "orange", (buf.validate.field).string.not_in = "grape"];
   * }
   * ```
   *
   * @generated from field: repeated string not_in = 11;
   */
  notIn?: string[];

  /**
   * `email` specifies that the field value must be a valid email address, for
   * example "foo@example.com".
   *
   * Conforms to the definition for a valid email address from the [HTML standard](https://html.spec.whatwg.org/multipage/input.html#valid-e-mail-address).
   * Note that this standard willfully deviates from [RFC 5322](https://datatracker.ietf.org/doc/html/rfc5322),
   * which allows many unexpected forms of email addresses and will easily match
   * a typographical error.
   *
   * If the field value isn't a valid email address, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid email address
   *   string value = 1 [(buf.validate.field).string.email = true];
   * }
   * ```
   *
   * @generated from field: bool email = 12;
   */
  email?: boolean;

  /**
   * `hostname` specifies that the field value must be a valid hostname, for
   * example "foo.example.com".
   *
   * A valid hostname follows the rules below:
   * - The name consists of one or more labels, separated by a dot (".").
   * - Each label can be 1 to 63 alphanumeric characters.
   * - A label can contain hyphens ("-"), but must not start or end with a hyphen.
   * - The right-most label must not be digits only.
   * - The name can have a trailing dot—for example, "foo.example.com.".
   * - The name can be 253 characters at most, excluding the optional trailing dot.
   *
   * If the field value isn't a valid hostname, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid hostname
   *   string value = 1 [(buf.validate.field).string.hostname = true];
   * }
   * ```
   *
   * @generated from field: bool hostname = 13;
   */
  hostname?: boolean;

  /**
   * `ip` specifies that the field value must be a valid IP (v4 or v6) address.
   *
   * IPv4 addresses are expected in the dotted decimal format—for example, "192.168.5.21".
   * IPv6 addresses are expected in their text representation—for example, "::1",
   * or "2001:0DB8:ABCD:0012::0".
   *
   * Both formats are well-defined in the internet standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986).
   * Zone identifiers for IPv6 addresses (for example, "fe80::a%en1") are supported.
   *
   * If the field value isn't a valid IP address, an error message will be
   * generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid IP address
   *   string value = 1 [(buf.validate.field).string.ip = true];
   * }
   * ```
   *
   * @generated from field: bool ip = 14;
   */
  ip?: boolean;

  /**
   * `ipv4` specifies that the field value must be a valid IPv4 address—for
   * example "192.168.5.21". If the field value isn't a valid IPv4 address, an
   * error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid IPv4 address
   *   string value = 1 [(buf.validate.field).string.ipv4 = true];
   * }
   * ```
   *
   * @generated from field: bool ipv4 = 15;
   */
  ipv4?: boolean;

  /**
   * `ipv6` specifies that the field value must be a valid IPv6 address—for
   * example "::1", or "d7a:115c:a1e0:ab12:4843:cd96:626b:430b". If the field
   * value is not a valid IPv6 address, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid IPv6 address
   *   string value = 1 [(buf.validate.field).string.ipv6 = true];
   * }
   * ```
   *
   * @generated from field: bool ipv6 = 16;
   */
  ipv6?: boolean;

  /**
   * `uri` specifies that the field value must be a valid URI, for example
   * "https://example.com/foo/bar?baz=quux#frag".
   *
   * URI is defined in the internet standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986).
   * Zone Identifiers in IPv6 address literals are supported ([RFC 6874](https://datatracker.ietf.org/doc/html/rfc6874)).
   *
   * If the field value isn't a valid URI, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid URI
   *   string value = 1 [(buf.validate.field).string.uri = true];
   * }
   * ```
   *
   * @generated from field: bool uri = 17;
   */
  uri?: boolean;

  /**
   * `uri_ref` specifies that the field value must be a valid URI Reference—either
   * a URI such as "https://example.com/foo/bar?baz=quux#frag", or a Relative
   * Reference such as "./foo/bar?query".
   *
   * URI, URI Reference, and Relative Reference are defined in the internet
   * standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986). Zone
   * Identifiers in IPv6 address literals are supported ([RFC 6874](https://datatracker.ietf.org/doc/html/rfc6874)).
   *
   * If the field value isn't a valid URI Reference, an error message will be
   * generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid URI Reference
   *   string value = 1 [(buf.validate.field).string.uri_ref = true];
   * }
   * ```
   *
   * @generated from field: bool uri_ref = 18;
   */
  uriRef?: boolean;

  /**
   * `address` specifies that the field value must be either a valid hostname
   * (for example, "example.com"), or a valid IP (v4 or v6) address (for example,
   * "192.168.0.1", or "::1"). If the field value isn't a valid hostname or IP,
   * an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid hostname, or ip address
   *   string value = 1 [(buf.validate.field).string.address = true];
   * }
   * ```
   *
   * @generated from field: bool address = 21;
   */
  address?: boolean;

  /**
   * `uuid` specifies that the field value must be a valid UUID as defined by
   * [RFC 4122](https://datatracker.ietf.org/doc/html/rfc4122#section-4.1.2). If the
   * field value isn't a valid UUID, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid UUID
   *   string value = 1 [(buf.validate.field).string.uuid = true];
   * }
   * ```
   *
   * @generated from field: bool uuid = 22;
   */
  uuid?: boolean;

  /**
   * `tuuid` (trimmed UUID) specifies that the field value must be a valid UUID as
   * defined by [RFC 4122](https://datatracker.ietf.org/doc/html/rfc4122#section-4.1.2) with all dashes
   * omitted. If the field value isn't a valid UUID without dashes, an error message
   * will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid trimmed UUID
   *   string value = 1 [(buf.validate.field).string.tuuid = true];
   * }
   * ```
   *
   * @generated from field: bool tuuid = 33;
   */
  tuuid?: boolean;

  /**
   * `ip_with_prefixlen` specifies that the field value must be a valid IP
   * (v4 or v6) address with prefix length—for example, "192.168.5.21/16" or
   * "2001:0DB8:ABCD:0012::F1/64". If the field value isn't a valid IP with
   * prefix length, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid IP with prefix length
   *    string value = 1 [(buf.validate.field).string.ip_with_prefixlen = true];
   * }
   * ```
   *
   * @generated from field: bool ip_with_prefixlen = 26;
   */
  ipWithPrefixlen?: boolean;

  /**
   * `ipv4_with_prefixlen` specifies that the field value must be a valid
   * IPv4 address with prefix length—for example, "192.168.5.21/16". If the
   * field value isn't a valid IPv4 address with prefix length, an error
   * message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid IPv4 address with prefix length
   *    string value = 1 [(buf.validate.field).string.ipv4_with_prefixlen = true];
   * }
   * ```
   *
   * @generated from field: bool ipv4_with_prefixlen = 27;
   */
  ipv4WithPrefixlen?: boolean;

  /**
   * `ipv6_with_prefixlen` specifies that the field value must be a valid
   * IPv6 address with prefix length—for example, "2001:0DB8:ABCD:0012::F1/64".
   * If the field value is not a valid IPv6 address with prefix length,
   * an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid IPv6 address prefix length
   *    string value = 1 [(buf.validate.field).string.ipv6_with_prefixlen = true];
   * }
   * ```
   *
   * @generated from field: bool ipv6_with_prefixlen = 28;
   */
  ipv6WithPrefixlen?: boolean;

  /**
   * `ip_prefix` specifies that the field value must be a valid IP (v4 or v6)
   * prefix—for example, "192.168.0.0/16" or "2001:0DB8:ABCD:0012::0/64".
   *
   * The prefix must have all zeros for the unmasked bits. For example,
   * "2001:0DB8:ABCD:0012::0/64" designates the left-most 64 bits for the
   * prefix, and the remaining 64 bits must be zero.
   *
   * If the field value isn't a valid IP prefix, an error message will be
   * generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid IP prefix
   *    string value = 1 [(buf.validate.field).string.ip_prefix = true];
   * }
   * ```
   *
   * @generated from field: bool ip_prefix = 29;
   */
  ipPrefix?: boolean;

  /**
   * `ipv4_prefix` specifies that the field value must be a valid IPv4
   * prefix, for example "192.168.0.0/16".
   *
   * The prefix must have all zeros for the unmasked bits. For example,
   * "192.168.0.0/16" designates the left-most 16 bits for the prefix,
   * and the remaining 16 bits must be zero.
   *
   * If the field value isn't a valid IPv4 prefix, an error message
   * will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid IPv4 prefix
   *    string value = 1 [(buf.validate.field).string.ipv4_prefix = true];
   * }
   * ```
   *
   * @generated from field: bool ipv4_prefix = 30;
   */
  ipv4Prefix?: boolean;

  /**
   * `ipv6_prefix` specifies that the field value must be a valid IPv6 prefix—for
   * example, "2001:0DB8:ABCD:0012::0/64".
   *
   * The prefix must have all zeros for the unmasked bits. For example,
   * "2001:0DB8:ABCD:0012::0/64" designates the left-most 64 bits for the
   * prefix, and the remaining 64 bits must be zero.
   *
   * If the field value is not a valid IPv6 prefix, an error message will be
   * generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid IPv6 prefix
   *    string value = 1 [(buf.validate.field).string.ipv6_prefix = true];
   * }
   * ```
   *
   * @generated from field: bool ipv6_prefix = 31;
   */
  ipv6Prefix?: boolean;

  /**
   * `host_and_port` specifies that the field value must be valid host/port
   * pair—for example, "example.com:8080".
   *
   * The host can be one of:
   * - An IPv4 address in dotted decimal format—for example, "192.168.5.21".
   * - An IPv6 address enclosed in square brackets—for example, "[2001:0DB8:ABCD:0012::F1]".
   * - A hostname—for example, "example.com".
   *
   * The port is separated by a colon. It must be non-empty, with a decimal number
   * in the range of 0-65535, inclusive.
   *
   * @generated from field: bool host_and_port = 32;
   */
  hostAndPort?: boolean;

  /**
   * `well_known_regex` specifies a common well-known pattern
   * defined as a regex. If the field value doesn't match the well-known
   * regex, an error message will be generated.
   *
   * ```proto
   * message MyString {
   *   // value must be a valid HTTP header value
   *   string value = 1 [(buf.validate.field).string.well_known_regex = KNOWN_REGEX_HTTP_HEADER_VALUE];
   * }
   * ```
   *
   * #### KnownRegex
   *
   * `well_known_regex` contains some well-known patterns.
   *
   * | Name                          | Number | Description                               |
   * |-------------------------------|--------|-------------------------------------------|
   * | KNOWN_REGEX_UNSPECIFIED       | 0      |                                           |
   * | KNOWN_REGEX_HTTP_HEADER_NAME  | 1      | HTTP header name as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2)  |
   * | KNOWN_REGEX_HTTP_HEADER_VALUE | 2      | HTTP header value as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.4) |
   *
   * @generated from field: buf.validate.KnownRegex well_known_regex = 24;
   */
  wellKnownRegex?: KnownRegexJson;

  /**
   * This applies to regexes `HTTP_HEADER_NAME` and `HTTP_HEADER_VALUE` to
   * enable strict header validation. By default, this is true, and HTTP header
   * validations are [RFC-compliant](https://datatracker.ietf.org/doc/html/rfc7230#section-3). Setting to false will enable looser
   * validations that only disallow `\r\n\0` characters, which can be used to
   * bypass header matching rules.
   *
   * ```proto
   * message MyString {
   *   // The field `value` must have be a valid HTTP headers, but not enforced with strict rules.
   *   string value = 1 [(buf.validate.field).string.strict = false];
   * }
   * ```
   *
   * @generated from field: optional bool strict = 25;
   */
  strict?: boolean;

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyString {
   *   string value = 1 [
   *     (buf.validate.field).string.example = "hello",
   *     (buf.validate.field).string.example = "world"
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated string example = 34;
   */
  example?: string[];
};

/**
 * Describes the message buf.validate.StringRules.
 * Use `create(StringRulesSchema)` to create a new message.
 */
export declare const StringRulesSchema: GenMessage<StringRules, {jsonType: StringRulesJson}>;

/**
 * BytesRules describe the rules applied to `bytes` values. These rules
 * may also be applied to the `google.protobuf.BytesValue` Well-Known-Type.
 *
 * @generated from message buf.validate.BytesRules
 */
export declare type BytesRules = Message<"buf.validate.BytesRules"> & {
  /**
   * `const` requires the field value to exactly match the specified bytes
   * value. If the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value must be "\x01\x02\x03\x04"
   *   bytes value = 1 [(buf.validate.field).bytes.const = "\x01\x02\x03\x04"];
   * }
   * ```
   *
   * @generated from field: optional bytes const = 1;
   */
  const: Uint8Array;

  /**
   * `len` requires the field value to have the specified length in bytes.
   * If the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value length must be 4 bytes.
   *   optional bytes value = 1 [(buf.validate.field).bytes.len = 4];
   * }
   * ```
   *
   * @generated from field: optional uint64 len = 13;
   */
  len: bigint;

  /**
   * `min_len` requires the field value to have at least the specified minimum
   * length in bytes.
   * If the field value doesn't meet the requirement, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value length must be at least 2 bytes.
   *   optional bytes value = 1 [(buf.validate.field).bytes.min_len = 2];
   * }
   * ```
   *
   * @generated from field: optional uint64 min_len = 2;
   */
  minLen: bigint;

  /**
   * `max_len` requires the field value to have at most the specified maximum
   * length in bytes.
   * If the field value exceeds the requirement, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value must be at most 6 bytes.
   *   optional bytes value = 1 [(buf.validate.field).bytes.max_len = 6];
   * }
   * ```
   *
   * @generated from field: optional uint64 max_len = 3;
   */
  maxLen: bigint;

  /**
   * `pattern` requires the field value to match the specified regular
   * expression ([RE2 syntax](https://github.com/google/re2/wiki/Syntax)).
   * The value of the field must be valid UTF-8 or validation will fail with a
   * runtime error.
   * If the field value doesn't match the pattern, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value must match regex pattern "^[a-zA-Z0-9]+$".
   *   optional bytes value = 1 [(buf.validate.field).bytes.pattern = "^[a-zA-Z0-9]+$"];
   * }
   * ```
   *
   * @generated from field: optional string pattern = 4;
   */
  pattern: string;

  /**
   * `prefix` requires the field value to have the specified bytes at the
   * beginning of the string.
   * If the field value doesn't meet the requirement, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value does not have prefix \x01\x02
   *   optional bytes value = 1 [(buf.validate.field).bytes.prefix = "\x01\x02"];
   * }
   * ```
   *
   * @generated from field: optional bytes prefix = 5;
   */
  prefix: Uint8Array;

  /**
   * `suffix` requires the field value to have the specified bytes at the end
   * of the string.
   * If the field value doesn't meet the requirement, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value does not have suffix \x03\x04
   *   optional bytes value = 1 [(buf.validate.field).bytes.suffix = "\x03\x04"];
   * }
   * ```
   *
   * @generated from field: optional bytes suffix = 6;
   */
  suffix: Uint8Array;

  /**
   * `contains` requires the field value to have the specified bytes anywhere in
   * the string.
   * If the field value doesn't meet the requirement, an error message is generated.
   *
   * ```protobuf
   * message MyBytes {
   *   // value does not contain \x02\x03
   *   optional bytes value = 1 [(buf.validate.field).bytes.contains = "\x02\x03"];
   * }
   * ```
   *
   * @generated from field: optional bytes contains = 7;
   */
  contains: Uint8Array;

  /**
   * `in` requires the field value to be equal to one of the specified
   * values. If the field value doesn't match any of the specified values, an
   * error message is generated.
   *
   * ```protobuf
   * message MyBytes {
   *   // value must in ["\x01\x02", "\x02\x03", "\x03\x04"]
   *   optional bytes value = 1 [(buf.validate.field).bytes.in = {"\x01\x02", "\x02\x03", "\x03\x04"}];
   * }
   * ```
   *
   * @generated from field: repeated bytes in = 8;
   */
  in: Uint8Array[];

  /**
   * `not_in` requires the field value to be not equal to any of the specified
   * values.
   * If the field value matches any of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MyBytes {
   *   // value must not in ["\x01\x02", "\x02\x03", "\x03\x04"]
   *   optional bytes value = 1 [(buf.validate.field).bytes.not_in = {"\x01\x02", "\x02\x03", "\x03\x04"}];
   * }
   * ```
   *
   * @generated from field: repeated bytes not_in = 9;
   */
  notIn: Uint8Array[];

  /**
   * WellKnown rules provide advanced rules against common byte
   * patterns
   *
   * @generated from oneof buf.validate.BytesRules.well_known
   */
  wellKnown: {
    /**
     * `ip` ensures that the field `value` is a valid IP address (v4 or v6) in byte format.
     * If the field value doesn't meet this rule, an error message is generated.
     *
     * ```proto
     * message MyBytes {
     *   // value must be a valid IP address
     *   optional bytes value = 1 [(buf.validate.field).bytes.ip = true];
     * }
     * ```
     *
     * @generated from field: bool ip = 10;
     */
    value: boolean;
    case: "ip";
  } | {
    /**
     * `ipv4` ensures that the field `value` is a valid IPv4 address in byte format.
     * If the field value doesn't meet this rule, an error message is generated.
     *
     * ```proto
     * message MyBytes {
     *   // value must be a valid IPv4 address
     *   optional bytes value = 1 [(buf.validate.field).bytes.ipv4 = true];
     * }
     * ```
     *
     * @generated from field: bool ipv4 = 11;
     */
    value: boolean;
    case: "ipv4";
  } | {
    /**
     * `ipv6` ensures that the field `value` is a valid IPv6 address in byte format.
     * If the field value doesn't meet this rule, an error message is generated.
     * ```proto
     * message MyBytes {
     *   // value must be a valid IPv6 address
     *   optional bytes value = 1 [(buf.validate.field).bytes.ipv6 = true];
     * }
     * ```
     *
     * @generated from field: bool ipv6 = 12;
     */
    value: boolean;
    case: "ipv6";
  } | { case: undefined; value?: undefined };

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyBytes {
   *   bytes value = 1 [
   *     (buf.validate.field).bytes.example = "\x01\x02",
   *     (buf.validate.field).bytes.example = "\x02\x03"
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated bytes example = 14;
   */
  example: Uint8Array[];
};

/**
 * BytesRules describe the rules applied to `bytes` values. These rules
 * may also be applied to the `google.protobuf.BytesValue` Well-Known-Type.
 *
 * @generated from message buf.validate.BytesRules
 */
export declare type BytesRulesJson = {
  /**
   * `const` requires the field value to exactly match the specified bytes
   * value. If the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value must be "\x01\x02\x03\x04"
   *   bytes value = 1 [(buf.validate.field).bytes.const = "\x01\x02\x03\x04"];
   * }
   * ```
   *
   * @generated from field: optional bytes const = 1;
   */
  const?: string;

  /**
   * `len` requires the field value to have the specified length in bytes.
   * If the field value doesn't match, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value length must be 4 bytes.
   *   optional bytes value = 1 [(buf.validate.field).bytes.len = 4];
   * }
   * ```
   *
   * @generated from field: optional uint64 len = 13;
   */
  len?: string;

  /**
   * `min_len` requires the field value to have at least the specified minimum
   * length in bytes.
   * If the field value doesn't meet the requirement, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value length must be at least 2 bytes.
   *   optional bytes value = 1 [(buf.validate.field).bytes.min_len = 2];
   * }
   * ```
   *
   * @generated from field: optional uint64 min_len = 2;
   */
  minLen?: string;

  /**
   * `max_len` requires the field value to have at most the specified maximum
   * length in bytes.
   * If the field value exceeds the requirement, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value must be at most 6 bytes.
   *   optional bytes value = 1 [(buf.validate.field).bytes.max_len = 6];
   * }
   * ```
   *
   * @generated from field: optional uint64 max_len = 3;
   */
  maxLen?: string;

  /**
   * `pattern` requires the field value to match the specified regular
   * expression ([RE2 syntax](https://github.com/google/re2/wiki/Syntax)).
   * The value of the field must be valid UTF-8 or validation will fail with a
   * runtime error.
   * If the field value doesn't match the pattern, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value must match regex pattern "^[a-zA-Z0-9]+$".
   *   optional bytes value = 1 [(buf.validate.field).bytes.pattern = "^[a-zA-Z0-9]+$"];
   * }
   * ```
   *
   * @generated from field: optional string pattern = 4;
   */
  pattern?: string;

  /**
   * `prefix` requires the field value to have the specified bytes at the
   * beginning of the string.
   * If the field value doesn't meet the requirement, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value does not have prefix \x01\x02
   *   optional bytes value = 1 [(buf.validate.field).bytes.prefix = "\x01\x02"];
   * }
   * ```
   *
   * @generated from field: optional bytes prefix = 5;
   */
  prefix?: string;

  /**
   * `suffix` requires the field value to have the specified bytes at the end
   * of the string.
   * If the field value doesn't meet the requirement, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value does not have suffix \x03\x04
   *   optional bytes value = 1 [(buf.validate.field).bytes.suffix = "\x03\x04"];
   * }
   * ```
   *
   * @generated from field: optional bytes suffix = 6;
   */
  suffix?: string;

  /**
   * `contains` requires the field value to have the specified bytes anywhere in
   * the string.
   * If the field value doesn't meet the requirement, an error message is generated.
   *
   * ```protobuf
   * message MyBytes {
   *   // value does not contain \x02\x03
   *   optional bytes value = 1 [(buf.validate.field).bytes.contains = "\x02\x03"];
   * }
   * ```
   *
   * @generated from field: optional bytes contains = 7;
   */
  contains?: string;

  /**
   * `in` requires the field value to be equal to one of the specified
   * values. If the field value doesn't match any of the specified values, an
   * error message is generated.
   *
   * ```protobuf
   * message MyBytes {
   *   // value must in ["\x01\x02", "\x02\x03", "\x03\x04"]
   *   optional bytes value = 1 [(buf.validate.field).bytes.in = {"\x01\x02", "\x02\x03", "\x03\x04"}];
   * }
   * ```
   *
   * @generated from field: repeated bytes in = 8;
   */
  in?: string[];

  /**
   * `not_in` requires the field value to be not equal to any of the specified
   * values.
   * If the field value matches any of the specified values, an error message is
   * generated.
   *
   * ```proto
   * message MyBytes {
   *   // value must not in ["\x01\x02", "\x02\x03", "\x03\x04"]
   *   optional bytes value = 1 [(buf.validate.field).bytes.not_in = {"\x01\x02", "\x02\x03", "\x03\x04"}];
   * }
   * ```
   *
   * @generated from field: repeated bytes not_in = 9;
   */
  notIn?: string[];

  /**
   * `ip` ensures that the field `value` is a valid IP address (v4 or v6) in byte format.
   * If the field value doesn't meet this rule, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value must be a valid IP address
   *   optional bytes value = 1 [(buf.validate.field).bytes.ip = true];
   * }
   * ```
   *
   * @generated from field: bool ip = 10;
   */
  ip?: boolean;

  /**
   * `ipv4` ensures that the field `value` is a valid IPv4 address in byte format.
   * If the field value doesn't meet this rule, an error message is generated.
   *
   * ```proto
   * message MyBytes {
   *   // value must be a valid IPv4 address
   *   optional bytes value = 1 [(buf.validate.field).bytes.ipv4 = true];
   * }
   * ```
   *
   * @generated from field: bool ipv4 = 11;
   */
  ipv4?: boolean;

  /**
   * `ipv6` ensures that the field `value` is a valid IPv6 address in byte format.
   * If the field value doesn't meet this rule, an error message is generated.
   * ```proto
   * message MyBytes {
   *   // value must be a valid IPv6 address
   *   optional bytes value = 1 [(buf.validate.field).bytes.ipv6 = true];
   * }
   * ```
   *
   * @generated from field: bool ipv6 = 12;
   */
  ipv6?: boolean;

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyBytes {
   *   bytes value = 1 [
   *     (buf.validate.field).bytes.example = "\x01\x02",
   *     (buf.validate.field).bytes.example = "\x02\x03"
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated bytes example = 14;
   */
  example?: string[];
};

/**
 * Describes the message buf.validate.BytesRules.
 * Use `create(BytesRulesSchema)` to create a new message.
 */
export declare const BytesRulesSchema: GenMessage<BytesRules, {jsonType: BytesRulesJson}>;

/**
 * EnumRules describe the rules applied to `enum` values.
 *
 * @generated from message buf.validate.EnumRules
 */
export declare type EnumRules = Message<"buf.validate.EnumRules"> & {
  /**
   * `const` requires the field value to exactly match the specified enum value.
   * If the field value doesn't match, an error message is generated.
   *
   * ```proto
   * enum MyEnum {
   *   MY_ENUM_UNSPECIFIED = 0;
   *   MY_ENUM_VALUE1 = 1;
   *   MY_ENUM_VALUE2 = 2;
   * }
   *
   * message MyMessage {
   *   // The field `value` must be exactly MY_ENUM_VALUE1.
   *   MyEnum value = 1 [(buf.validate.field).enum.const = 1];
   * }
   * ```
   *
   * @generated from field: optional int32 const = 1;
   */
  const: number;

  /**
   * `defined_only` requires the field value to be one of the defined values for
   * this enum, failing on any undefined value.
   *
   * ```proto
   * enum MyEnum {
   *   MY_ENUM_UNSPECIFIED = 0;
   *   MY_ENUM_VALUE1 = 1;
   *   MY_ENUM_VALUE2 = 2;
   * }
   *
   * message MyMessage {
   *   // The field `value` must be a defined value of MyEnum.
   *   MyEnum value = 1 [(buf.validate.field).enum.defined_only = true];
   * }
   * ```
   *
   * @generated from field: optional bool defined_only = 2;
   */
  definedOnly: boolean;

  /**
   * `in` requires the field value to be equal to one of the
   * specified enum values. If the field value doesn't match any of the
   * specified values, an error message is generated.
   *
   * ```proto
   * enum MyEnum {
   *   MY_ENUM_UNSPECIFIED = 0;
   *   MY_ENUM_VALUE1 = 1;
   *   MY_ENUM_VALUE2 = 2;
   * }
   *
   * message MyMessage {
   *   // The field `value` must be equal to one of the specified values.
   *   MyEnum value = 1 [(buf.validate.field).enum = { in: [1, 2]}];
   * }
   * ```
   *
   * @generated from field: repeated int32 in = 3;
   */
  in: number[];

  /**
   * `not_in` requires the field value to be not equal to any of the
   * specified enum values. If the field value matches one of the specified
   * values, an error message is generated.
   *
   * ```proto
   * enum MyEnum {
   *   MY_ENUM_UNSPECIFIED = 0;
   *   MY_ENUM_VALUE1 = 1;
   *   MY_ENUM_VALUE2 = 2;
   * }
   *
   * message MyMessage {
   *   // The field `value` must not be equal to any of the specified values.
   *   MyEnum value = 1 [(buf.validate.field).enum = { not_in: [1, 2]}];
   * }
   * ```
   *
   * @generated from field: repeated int32 not_in = 4;
   */
  notIn: number[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * enum MyEnum {
   *   MY_ENUM_UNSPECIFIED = 0;
   *   MY_ENUM_VALUE1 = 1;
   *   MY_ENUM_VALUE2 = 2;
   * }
   *
   * message MyMessage {
   *     (buf.validate.field).enum.example = 1,
   *     (buf.validate.field).enum.example = 2
   * }
   * ```
   *
   * @generated from field: repeated int32 example = 5;
   */
  example: number[];
};

/**
 * EnumRules describe the rules applied to `enum` values.
 *
 * @generated from message buf.validate.EnumRules
 */
export declare type EnumRulesJson = {
  /**
   * `const` requires the field value to exactly match the specified enum value.
   * If the field value doesn't match, an error message is generated.
   *
   * ```proto
   * enum MyEnum {
   *   MY_ENUM_UNSPECIFIED = 0;
   *   MY_ENUM_VALUE1 = 1;
   *   MY_ENUM_VALUE2 = 2;
   * }
   *
   * message MyMessage {
   *   // The field `value` must be exactly MY_ENUM_VALUE1.
   *   MyEnum value = 1 [(buf.validate.field).enum.const = 1];
   * }
   * ```
   *
   * @generated from field: optional int32 const = 1;
   */
  const?: number;

  /**
   * `defined_only` requires the field value to be one of the defined values for
   * this enum, failing on any undefined value.
   *
   * ```proto
   * enum MyEnum {
   *   MY_ENUM_UNSPECIFIED = 0;
   *   MY_ENUM_VALUE1 = 1;
   *   MY_ENUM_VALUE2 = 2;
   * }
   *
   * message MyMessage {
   *   // The field `value` must be a defined value of MyEnum.
   *   MyEnum value = 1 [(buf.validate.field).enum.defined_only = true];
   * }
   * ```
   *
   * @generated from field: optional bool defined_only = 2;
   */
  definedOnly?: boolean;

  /**
   * `in` requires the field value to be equal to one of the
   * specified enum values. If the field value doesn't match any of the
   * specified values, an error message is generated.
   *
   * ```proto
   * enum MyEnum {
   *   MY_ENUM_UNSPECIFIED = 0;
   *   MY_ENUM_VALUE1 = 1;
   *   MY_ENUM_VALUE2 = 2;
   * }
   *
   * message MyMessage {
   *   // The field `value` must be equal to one of the specified values.
   *   MyEnum value = 1 [(buf.validate.field).enum = { in: [1, 2]}];
   * }
   * ```
   *
   * @generated from field: repeated int32 in = 3;
   */
  in?: number[];

  /**
   * `not_in` requires the field value to be not equal to any of the
   * specified enum values. If the field value matches one of the specified
   * values, an error message is generated.
   *
   * ```proto
   * enum MyEnum {
   *   MY_ENUM_UNSPECIFIED = 0;
   *   MY_ENUM_VALUE1 = 1;
   *   MY_ENUM_VALUE2 = 2;
   * }
   *
   * message MyMessage {
   *   // The field `value` must not be equal to any of the specified values.
   *   MyEnum value = 1 [(buf.validate.field).enum = { not_in: [1, 2]}];
   * }
   * ```
   *
   * @generated from field: repeated int32 not_in = 4;
   */
  notIn?: number[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * enum MyEnum {
   *   MY_ENUM_UNSPECIFIED = 0;
   *   MY_ENUM_VALUE1 = 1;
   *   MY_ENUM_VALUE2 = 2;
   * }
   *
   * message MyMessage {
   *     (buf.validate.field).enum.example = 1,
   *     (buf.validate.field).enum.example = 2
   * }
   * ```
   *
   * @generated from field: repeated int32 example = 5;
   */
  example?: number[];
};

/**
 * Describes the message buf.validate.EnumRules.
 * Use `create(EnumRulesSchema)` to create a new message.
 */
export declare const EnumRulesSchema: GenMessage<EnumRules, {jsonType: EnumRulesJson}>;

/**
 * RepeatedRules describe the rules applied to `repeated` values.
 *
 * @generated from message buf.validate.RepeatedRules
 */
export declare type RepeatedRules = Message<"buf.validate.RepeatedRules"> & {
  /**
   * `min_items` requires that this field must contain at least the specified
   * minimum number of items.
   *
   * Note that `min_items = 1` is equivalent to setting a field as `required`.
   *
   * ```proto
   * message MyRepeated {
   *   // value must contain at least  2 items
   *   repeated string value = 1 [(buf.validate.field).repeated.min_items = 2];
   * }
   * ```
   *
   * @generated from field: optional uint64 min_items = 1;
   */
  minItems: bigint;

  /**
   * `max_items` denotes that this field must not exceed a
   * certain number of items as the upper limit. If the field contains more
   * items than specified, an error message will be generated, requiring the
   * field to maintain no more than the specified number of items.
   *
   * ```proto
   * message MyRepeated {
   *   // value must contain no more than 3 item(s)
   *   repeated string value = 1 [(buf.validate.field).repeated.max_items = 3];
   * }
   * ```
   *
   * @generated from field: optional uint64 max_items = 2;
   */
  maxItems: bigint;

  /**
   * `unique` indicates that all elements in this field must
   * be unique. This rule is strictly applicable to scalar and enum
   * types, with message types not being supported.
   *
   * ```proto
   * message MyRepeated {
   *   // repeated value must contain unique items
   *   repeated string value = 1 [(buf.validate.field).repeated.unique = true];
   * }
   * ```
   *
   * @generated from field: optional bool unique = 3;
   */
  unique: boolean;

  /**
   * `items` details the rules to be applied to each item
   * in the field. Even for repeated message fields, validation is executed
   * against each item unless `ignore` is specified.
   *
   * ```proto
   * message MyRepeated {
   *   // The items in the field `value` must follow the specified rules.
   *   repeated string value = 1 [(buf.validate.field).repeated.items = {
   *     string: {
   *       min_len: 3
   *       max_len: 10
   *     }
   *   }];
   * }
   * ```
   *
   * Note that the `required` rule does not apply. Repeated items
   * cannot be unset.
   *
   * @generated from field: optional buf.validate.FieldRules items = 4;
   */
  items?: FieldRules;
};

/**
 * RepeatedRules describe the rules applied to `repeated` values.
 *
 * @generated from message buf.validate.RepeatedRules
 */
export declare type RepeatedRulesJson = {
  /**
   * `min_items` requires that this field must contain at least the specified
   * minimum number of items.
   *
   * Note that `min_items = 1` is equivalent to setting a field as `required`.
   *
   * ```proto
   * message MyRepeated {
   *   // value must contain at least  2 items
   *   repeated string value = 1 [(buf.validate.field).repeated.min_items = 2];
   * }
   * ```
   *
   * @generated from field: optional uint64 min_items = 1;
   */
  minItems?: string;

  /**
   * `max_items` denotes that this field must not exceed a
   * certain number of items as the upper limit. If the field contains more
   * items than specified, an error message will be generated, requiring the
   * field to maintain no more than the specified number of items.
   *
   * ```proto
   * message MyRepeated {
   *   // value must contain no more than 3 item(s)
   *   repeated string value = 1 [(buf.validate.field).repeated.max_items = 3];
   * }
   * ```
   *
   * @generated from field: optional uint64 max_items = 2;
   */
  maxItems?: string;

  /**
   * `unique` indicates that all elements in this field must
   * be unique. This rule is strictly applicable to scalar and enum
   * types, with message types not being supported.
   *
   * ```proto
   * message MyRepeated {
   *   // repeated value must contain unique items
   *   repeated string value = 1 [(buf.validate.field).repeated.unique = true];
   * }
   * ```
   *
   * @generated from field: optional bool unique = 3;
   */
  unique?: boolean;

  /**
   * `items` details the rules to be applied to each item
   * in the field. Even for repeated message fields, validation is executed
   * against each item unless `ignore` is specified.
   *
   * ```proto
   * message MyRepeated {
   *   // The items in the field `value` must follow the specified rules.
   *   repeated string value = 1 [(buf.validate.field).repeated.items = {
   *     string: {
   *       min_len: 3
   *       max_len: 10
   *     }
   *   }];
   * }
   * ```
   *
   * Note that the `required` rule does not apply. Repeated items
   * cannot be unset.
   *
   * @generated from field: optional buf.validate.FieldRules items = 4;
   */
  items?: FieldRulesJson;
};

/**
 * Describes the message buf.validate.RepeatedRules.
 * Use `create(RepeatedRulesSchema)` to create a new message.
 */
export declare const RepeatedRulesSchema: GenMessage<RepeatedRules, {jsonType: RepeatedRulesJson}>;

/**
 * MapRules describe the rules applied to `map` values.
 *
 * @generated from message buf.validate.MapRules
 */
export declare type MapRules = Message<"buf.validate.MapRules"> & {
  /**
   * Specifies the minimum number of key-value pairs allowed. If the field has
   * fewer key-value pairs than specified, an error message is generated.
   *
   * ```proto
   * message MyMap {
   *   // The field `value` must have at least 2 key-value pairs.
   *   map<string, string> value = 1 [(buf.validate.field).map.min_pairs = 2];
   * }
   * ```
   *
   * @generated from field: optional uint64 min_pairs = 1;
   */
  minPairs: bigint;

  /**
   * Specifies the maximum number of key-value pairs allowed. If the field has
   * more key-value pairs than specified, an error message is generated.
   *
   * ```proto
   * message MyMap {
   *   // The field `value` must have at most 3 key-value pairs.
   *   map<string, string> value = 1 [(buf.validate.field).map.max_pairs = 3];
   * }
   * ```
   *
   * @generated from field: optional uint64 max_pairs = 2;
   */
  maxPairs: bigint;

  /**
   * Specifies the rules to be applied to each key in the field.
   *
   * ```proto
   * message MyMap {
   *   // The keys in the field `value` must follow the specified rules.
   *   map<string, string> value = 1 [(buf.validate.field).map.keys = {
   *     string: {
   *       min_len: 3
   *       max_len: 10
   *     }
   *   }];
   * }
   * ```
   *
   * Note that the `required` rule does not apply. Map keys cannot be unset.
   *
   * @generated from field: optional buf.validate.FieldRules keys = 4;
   */
  keys?: FieldRules;

  /**
   * Specifies the rules to be applied to the value of each key in the
   * field. Message values will still have their validations evaluated unless
   * `ignore` is specified.
   *
   * ```proto
   * message MyMap {
   *   // The values in the field `value` must follow the specified rules.
   *   map<string, string> value = 1 [(buf.validate.field).map.values = {
   *     string: {
   *       min_len: 5
   *       max_len: 20
   *     }
   *   }];
   * }
   * ```
   * Note that the `required` rule does not apply. Map values cannot be unset.
   *
   * @generated from field: optional buf.validate.FieldRules values = 5;
   */
  values?: FieldRules;
};

/**
 * MapRules describe the rules applied to `map` values.
 *
 * @generated from message buf.validate.MapRules
 */
export declare type MapRulesJson = {
  /**
   * Specifies the minimum number of key-value pairs allowed. If the field has
   * fewer key-value pairs than specified, an error message is generated.
   *
   * ```proto
   * message MyMap {
   *   // The field `value` must have at least 2 key-value pairs.
   *   map<string, string> value = 1 [(buf.validate.field).map.min_pairs = 2];
   * }
   * ```
   *
   * @generated from field: optional uint64 min_pairs = 1;
   */
  minPairs?: string;

  /**
   * Specifies the maximum number of key-value pairs allowed. If the field has
   * more key-value pairs than specified, an error message is generated.
   *
   * ```proto
   * message MyMap {
   *   // The field `value` must have at most 3 key-value pairs.
   *   map<string, string> value = 1 [(buf.validate.field).map.max_pairs = 3];
   * }
   * ```
   *
   * @generated from field: optional uint64 max_pairs = 2;
   */
  maxPairs?: string;

  /**
   * Specifies the rules to be applied to each key in the field.
   *
   * ```proto
   * message MyMap {
   *   // The keys in the field `value` must follow the specified rules.
   *   map<string, string> value = 1 [(buf.validate.field).map.keys = {
   *     string: {
   *       min_len: 3
   *       max_len: 10
   *     }
   *   }];
   * }
   * ```
   *
   * Note that the `required` rule does not apply. Map keys cannot be unset.
   *
   * @generated from field: optional buf.validate.FieldRules keys = 4;
   */
  keys?: FieldRulesJson;

  /**
   * Specifies the rules to be applied to the value of each key in the
   * field. Message values will still have their validations evaluated unless
   * `ignore` is specified.
   *
   * ```proto
   * message MyMap {
   *   // The values in the field `value` must follow the specified rules.
   *   map<string, string> value = 1 [(buf.validate.field).map.values = {
   *     string: {
   *       min_len: 5
   *       max_len: 20
   *     }
   *   }];
   * }
   * ```
   * Note that the `required` rule does not apply. Map values cannot be unset.
   *
   * @generated from field: optional buf.validate.FieldRules values = 5;
   */
  values?: FieldRulesJson;
};

/**
 * Describes the message buf.validate.MapRules.
 * Use `create(MapRulesSchema)` to create a new message.
 */
export declare const MapRulesSchema: GenMessage<MapRules, {jsonType: MapRulesJson}>;

/**
 * AnyRules describe rules applied exclusively to the `google.protobuf.Any` well-known type.
 *
 * @generated from message buf.validate.AnyRules
 */
export declare type AnyRules = Message<"buf.validate.AnyRules"> & {
  /**
   * `in` requires the field's `type_url` to be equal to one of the
   * specified values. If it doesn't match any of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyAny {
   *   //  The `value` field must have a `type_url` equal to one of the specified values.
   *   google.protobuf.Any value = 1 [(buf.validate.field).any = {
   *       in: ["type.googleapis.com/MyType1", "type.googleapis.com/MyType2"]
   *   }];
   * }
   * ```
   *
   * @generated from field: repeated string in = 2;
   */
  in: string[];

  /**
   * requires the field's type_url to be not equal to any of the specified values. If it matches any of the specified values, an error message is generated.
   *
   * ```proto
   * message MyAny {
   *   //  The `value` field must not have a `type_url` equal to any of the specified values.
   *   google.protobuf.Any value = 1 [(buf.validate.field).any = {
   *       not_in: ["type.googleapis.com/ForbiddenType1", "type.googleapis.com/ForbiddenType2"]
   *   }];
   * }
   * ```
   *
   * @generated from field: repeated string not_in = 3;
   */
  notIn: string[];
};

/**
 * AnyRules describe rules applied exclusively to the `google.protobuf.Any` well-known type.
 *
 * @generated from message buf.validate.AnyRules
 */
export declare type AnyRulesJson = {
  /**
   * `in` requires the field's `type_url` to be equal to one of the
   * specified values. If it doesn't match any of the specified values, an error
   * message is generated.
   *
   * ```proto
   * message MyAny {
   *   //  The `value` field must have a `type_url` equal to one of the specified values.
   *   google.protobuf.Any value = 1 [(buf.validate.field).any = {
   *       in: ["type.googleapis.com/MyType1", "type.googleapis.com/MyType2"]
   *   }];
   * }
   * ```
   *
   * @generated from field: repeated string in = 2;
   */
  in?: string[];

  /**
   * requires the field's type_url to be not equal to any of the specified values. If it matches any of the specified values, an error message is generated.
   *
   * ```proto
   * message MyAny {
   *   //  The `value` field must not have a `type_url` equal to any of the specified values.
   *   google.protobuf.Any value = 1 [(buf.validate.field).any = {
   *       not_in: ["type.googleapis.com/ForbiddenType1", "type.googleapis.com/ForbiddenType2"]
   *   }];
   * }
   * ```
   *
   * @generated from field: repeated string not_in = 3;
   */
  notIn?: string[];
};

/**
 * Describes the message buf.validate.AnyRules.
 * Use `create(AnyRulesSchema)` to create a new message.
 */
export declare const AnyRulesSchema: GenMessage<AnyRules, {jsonType: AnyRulesJson}>;

/**
 * DurationRules describe the rules applied exclusively to the `google.protobuf.Duration` well-known type.
 *
 * @generated from message buf.validate.DurationRules
 */
export declare type DurationRules = Message<"buf.validate.DurationRules"> & {
  /**
   * `const` dictates that the field must match the specified value of the `google.protobuf.Duration` type exactly.
   * If the field's value deviates from the specified value, an error message
   * will be generated.
   *
   * ```proto
   * message MyDuration {
   *   // value must equal 5s
   *   google.protobuf.Duration value = 1 [(buf.validate.field).duration.const = "5s"];
   * }
   * ```
   *
   * @generated from field: optional google.protobuf.Duration const = 2;
   */
  const?: Duration;

  /**
   * @generated from oneof buf.validate.DurationRules.less_than
   */
  lessThan: {
    /**
     * `lt` stipulates that the field must be less than the specified value of the `google.protobuf.Duration` type,
     * exclusive. If the field's value is greater than or equal to the specified
     * value, an error message will be generated.
     *
     * ```proto
     * message MyDuration {
     *   // value must be less than 5s
     *   google.protobuf.Duration value = 1 [(buf.validate.field).duration.lt = "5s"];
     * }
     * ```
     *
     * @generated from field: google.protobuf.Duration lt = 3;
     */
    value: Duration;
    case: "lt";
  } | {
    /**
     * `lte` indicates that the field must be less than or equal to the specified
     * value of the `google.protobuf.Duration` type, inclusive. If the field's value is greater than the specified value,
     * an error message will be generated.
     *
     * ```proto
     * message MyDuration {
     *   // value must be less than or equal to 10s
     *   google.protobuf.Duration value = 1 [(buf.validate.field).duration.lte = "10s"];
     * }
     * ```
     *
     * @generated from field: google.protobuf.Duration lte = 4;
     */
    value: Duration;
    case: "lte";
  } | { case: undefined; value?: undefined };

  /**
   * @generated from oneof buf.validate.DurationRules.greater_than
   */
  greaterThan: {
    /**
     * `gt` requires the duration field value to be greater than the specified
     * value (exclusive). If the value of `gt` is larger than a specified `lt`
     * or `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyDuration {
     *   // duration must be greater than 5s [duration.gt]
     *   google.protobuf.Duration value = 1 [(buf.validate.field).duration.gt = { seconds: 5 }];
     *
     *   // duration must be greater than 5s and less than 10s [duration.gt_lt]
     *   google.protobuf.Duration another_value = 2 [(buf.validate.field).duration = { gt: { seconds: 5 }, lt: { seconds: 10 } }];
     *
     *   // duration must be greater than 10s or less than 5s [duration.gt_lt_exclusive]
     *   google.protobuf.Duration other_value = 3 [(buf.validate.field).duration = { gt: { seconds: 10 }, lt: { seconds: 5 } }];
     * }
     * ```
     *
     * @generated from field: google.protobuf.Duration gt = 5;
     */
    value: Duration;
    case: "gt";
  } | {
    /**
     * `gte` requires the duration field value to be greater than or equal to the
     * specified value (exclusive). If the value of `gte` is larger than a
     * specified `lt` or `lte`, the range is reversed, and the field value must
     * be outside the specified range. If the field value doesn't meet the
     * required conditions, an error message is generated.
     *
     * ```proto
     * message MyDuration {
     *  // duration must be greater than or equal to 5s [duration.gte]
     *  google.protobuf.Duration value = 1 [(buf.validate.field).duration.gte = { seconds: 5 }];
     *
     *  // duration must be greater than or equal to 5s and less than 10s [duration.gte_lt]
     *  google.protobuf.Duration another_value = 2 [(buf.validate.field).duration = { gte: { seconds: 5 }, lt: { seconds: 10 } }];
     *
     *  // duration must be greater than or equal to 10s or less than 5s [duration.gte_lt_exclusive]
     *  google.protobuf.Duration other_value = 3 [(buf.validate.field).duration = { gte: { seconds: 10 }, lt: { seconds: 5 } }];
     * }
     * ```
     *
     * @generated from field: google.protobuf.Duration gte = 6;
     */
    value: Duration;
    case: "gte";
  } | { case: undefined; value?: undefined };

  /**
   * `in` asserts that the field must be equal to one of the specified values of the `google.protobuf.Duration` type.
   * If the field's value doesn't correspond to any of the specified values,
   * an error message will be generated.
   *
   * ```proto
   * message MyDuration {
   *   // value must be in list [1s, 2s, 3s]
   *   google.protobuf.Duration value = 1 [(buf.validate.field).duration.in = ["1s", "2s", "3s"]];
   * }
   * ```
   *
   * @generated from field: repeated google.protobuf.Duration in = 7;
   */
  in: Duration[];

  /**
   * `not_in` denotes that the field must not be equal to
   * any of the specified values of the `google.protobuf.Duration` type.
   * If the field's value matches any of these values, an error message will be
   * generated.
   *
   * ```proto
   * message MyDuration {
   *   // value must not be in list [1s, 2s, 3s]
   *   google.protobuf.Duration value = 1 [(buf.validate.field).duration.not_in = ["1s", "2s", "3s"]];
   * }
   * ```
   *
   * @generated from field: repeated google.protobuf.Duration not_in = 8;
   */
  notIn: Duration[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyDuration {
   *   google.protobuf.Duration value = 1 [
   *     (buf.validate.field).duration.example = { seconds: 1 },
   *     (buf.validate.field).duration.example = { seconds: 2 },
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated google.protobuf.Duration example = 9;
   */
  example: Duration[];
};

/**
 * DurationRules describe the rules applied exclusively to the `google.protobuf.Duration` well-known type.
 *
 * @generated from message buf.validate.DurationRules
 */
export declare type DurationRulesJson = {
  /**
   * `const` dictates that the field must match the specified value of the `google.protobuf.Duration` type exactly.
   * If the field's value deviates from the specified value, an error message
   * will be generated.
   *
   * ```proto
   * message MyDuration {
   *   // value must equal 5s
   *   google.protobuf.Duration value = 1 [(buf.validate.field).duration.const = "5s"];
   * }
   * ```
   *
   * @generated from field: optional google.protobuf.Duration const = 2;
   */
  const?: DurationJson;

  /**
   * `lt` stipulates that the field must be less than the specified value of the `google.protobuf.Duration` type,
   * exclusive. If the field's value is greater than or equal to the specified
   * value, an error message will be generated.
   *
   * ```proto
   * message MyDuration {
   *   // value must be less than 5s
   *   google.protobuf.Duration value = 1 [(buf.validate.field).duration.lt = "5s"];
   * }
   * ```
   *
   * @generated from field: google.protobuf.Duration lt = 3;
   */
  lt?: DurationJson;

  /**
   * `lte` indicates that the field must be less than or equal to the specified
   * value of the `google.protobuf.Duration` type, inclusive. If the field's value is greater than the specified value,
   * an error message will be generated.
   *
   * ```proto
   * message MyDuration {
   *   // value must be less than or equal to 10s
   *   google.protobuf.Duration value = 1 [(buf.validate.field).duration.lte = "10s"];
   * }
   * ```
   *
   * @generated from field: google.protobuf.Duration lte = 4;
   */
  lte?: DurationJson;

  /**
   * `gt` requires the duration field value to be greater than the specified
   * value (exclusive). If the value of `gt` is larger than a specified `lt`
   * or `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyDuration {
   *   // duration must be greater than 5s [duration.gt]
   *   google.protobuf.Duration value = 1 [(buf.validate.field).duration.gt = { seconds: 5 }];
   *
   *   // duration must be greater than 5s and less than 10s [duration.gt_lt]
   *   google.protobuf.Duration another_value = 2 [(buf.validate.field).duration = { gt: { seconds: 5 }, lt: { seconds: 10 } }];
   *
   *   // duration must be greater than 10s or less than 5s [duration.gt_lt_exclusive]
   *   google.protobuf.Duration other_value = 3 [(buf.validate.field).duration = { gt: { seconds: 10 }, lt: { seconds: 5 } }];
   * }
   * ```
   *
   * @generated from field: google.protobuf.Duration gt = 5;
   */
  gt?: DurationJson;

  /**
   * `gte` requires the duration field value to be greater than or equal to the
   * specified value (exclusive). If the value of `gte` is larger than a
   * specified `lt` or `lte`, the range is reversed, and the field value must
   * be outside the specified range. If the field value doesn't meet the
   * required conditions, an error message is generated.
   *
   * ```proto
   * message MyDuration {
   *  // duration must be greater than or equal to 5s [duration.gte]
   *  google.protobuf.Duration value = 1 [(buf.validate.field).duration.gte = { seconds: 5 }];
   *
   *  // duration must be greater than or equal to 5s and less than 10s [duration.gte_lt]
   *  google.protobuf.Duration another_value = 2 [(buf.validate.field).duration = { gte: { seconds: 5 }, lt: { seconds: 10 } }];
   *
   *  // duration must be greater than or equal to 10s or less than 5s [duration.gte_lt_exclusive]
   *  google.protobuf.Duration other_value = 3 [(buf.validate.field).duration = { gte: { seconds: 10 }, lt: { seconds: 5 } }];
   * }
   * ```
   *
   * @generated from field: google.protobuf.Duration gte = 6;
   */
  gte?: DurationJson;

  /**
   * `in` asserts that the field must be equal to one of the specified values of the `google.protobuf.Duration` type.
   * If the field's value doesn't correspond to any of the specified values,
   * an error message will be generated.
   *
   * ```proto
   * message MyDuration {
   *   // value must be in list [1s, 2s, 3s]
   *   google.protobuf.Duration value = 1 [(buf.validate.field).duration.in = ["1s", "2s", "3s"]];
   * }
   * ```
   *
   * @generated from field: repeated google.protobuf.Duration in = 7;
   */
  in?: DurationJson[];

  /**
   * `not_in` denotes that the field must not be equal to
   * any of the specified values of the `google.protobuf.Duration` type.
   * If the field's value matches any of these values, an error message will be
   * generated.
   *
   * ```proto
   * message MyDuration {
   *   // value must not be in list [1s, 2s, 3s]
   *   google.protobuf.Duration value = 1 [(buf.validate.field).duration.not_in = ["1s", "2s", "3s"]];
   * }
   * ```
   *
   * @generated from field: repeated google.protobuf.Duration not_in = 8;
   */
  notIn?: DurationJson[];

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyDuration {
   *   google.protobuf.Duration value = 1 [
   *     (buf.validate.field).duration.example = { seconds: 1 },
   *     (buf.validate.field).duration.example = { seconds: 2 },
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated google.protobuf.Duration example = 9;
   */
  example?: DurationJson[];
};

/**
 * Describes the message buf.validate.DurationRules.
 * Use `create(DurationRulesSchema)` to create a new message.
 */
export declare const DurationRulesSchema: GenMessage<DurationRules, {jsonType: DurationRulesJson}>;

/**
 * TimestampRules describe the rules applied exclusively to the `google.protobuf.Timestamp` well-known type.
 *
 * @generated from message buf.validate.TimestampRules
 */
export declare type TimestampRules = Message<"buf.validate.TimestampRules"> & {
  /**
   * `const` dictates that this field, of the `google.protobuf.Timestamp` type, must exactly match the specified value. If the field value doesn't correspond to the specified timestamp, an error message will be generated.
   *
   * ```proto
   * message MyTimestamp {
   *   // value must equal 2023-05-03T10:00:00Z
   *   google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.const = {seconds: 1727998800}];
   * }
   * ```
   *
   * @generated from field: optional google.protobuf.Timestamp const = 2;
   */
  const?: Timestamp;

  /**
   * @generated from oneof buf.validate.TimestampRules.less_than
   */
  lessThan: {
    /**
     * requires the duration field value to be less than the specified value (field < value). If the field value doesn't meet the required conditions, an error message is generated.
     *
     * ```proto
     * message MyDuration {
     *   // duration must be less than 'P3D' [duration.lt]
     *   google.protobuf.Duration value = 1 [(buf.validate.field).duration.lt = { seconds: 259200 }];
     * }
     * ```
     *
     * @generated from field: google.protobuf.Timestamp lt = 3;
     */
    value: Timestamp;
    case: "lt";
  } | {
    /**
     * requires the timestamp field value to be less than or equal to the specified value (field <= value). If the field value doesn't meet the required conditions, an error message is generated.
     *
     * ```proto
     * message MyTimestamp {
     *   // timestamp must be less than or equal to '2023-05-14T00:00:00Z' [timestamp.lte]
     *   google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.lte = { seconds: 1678867200 }];
     * }
     * ```
     *
     * @generated from field: google.protobuf.Timestamp lte = 4;
     */
    value: Timestamp;
    case: "lte";
  } | {
    /**
     * `lt_now` specifies that this field, of the `google.protobuf.Timestamp` type, must be less than the current time. `lt_now` can only be used with the `within` rule.
     *
     * ```proto
     * message MyTimestamp {
     *  // value must be less than now
     *   google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.lt_now = true];
     * }
     * ```
     *
     * @generated from field: bool lt_now = 7;
     */
    value: boolean;
    case: "ltNow";
  } | { case: undefined; value?: undefined };

  /**
   * @generated from oneof buf.validate.TimestampRules.greater_than
   */
  greaterThan: {
    /**
     * `gt` requires the timestamp field value to be greater than the specified
     * value (exclusive). If the value of `gt` is larger than a specified `lt`
     * or `lte`, the range is reversed, and the field value must be outside the
     * specified range. If the field value doesn't meet the required conditions,
     * an error message is generated.
     *
     * ```proto
     * message MyTimestamp {
     *   // timestamp must be greater than '2023-01-01T00:00:00Z' [timestamp.gt]
     *   google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.gt = { seconds: 1672444800 }];
     *
     *   // timestamp must be greater than '2023-01-01T00:00:00Z' and less than '2023-01-02T00:00:00Z' [timestamp.gt_lt]
     *   google.protobuf.Timestamp another_value = 2 [(buf.validate.field).timestamp = { gt: { seconds: 1672444800 }, lt: { seconds: 1672531200 } }];
     *
     *   // timestamp must be greater than '2023-01-02T00:00:00Z' or less than '2023-01-01T00:00:00Z' [timestamp.gt_lt_exclusive]
     *   google.protobuf.Timestamp other_value = 3 [(buf.validate.field).timestamp = { gt: { seconds: 1672531200 }, lt: { seconds: 1672444800 } }];
     * }
     * ```
     *
     * @generated from field: google.protobuf.Timestamp gt = 5;
     */
    value: Timestamp;
    case: "gt";
  } | {
    /**
     * `gte` requires the timestamp field value to be greater than or equal to the
     * specified value (exclusive). If the value of `gte` is larger than a
     * specified `lt` or `lte`, the range is reversed, and the field value
     * must be outside the specified range. If the field value doesn't meet
     * the required conditions, an error message is generated.
     *
     * ```proto
     * message MyTimestamp {
     *   // timestamp must be greater than or equal to '2023-01-01T00:00:00Z' [timestamp.gte]
     *   google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.gte = { seconds: 1672444800 }];
     *
     *   // timestamp must be greater than or equal to '2023-01-01T00:00:00Z' and less than '2023-01-02T00:00:00Z' [timestamp.gte_lt]
     *   google.protobuf.Timestamp another_value = 2 [(buf.validate.field).timestamp = { gte: { seconds: 1672444800 }, lt: { seconds: 1672531200 } }];
     *
     *   // timestamp must be greater than or equal to '2023-01-02T00:00:00Z' or less than '2023-01-01T00:00:00Z' [timestamp.gte_lt_exclusive]
     *   google.protobuf.Timestamp other_value = 3 [(buf.validate.field).timestamp = { gte: { seconds: 1672531200 }, lt: { seconds: 1672444800 } }];
     * }
     * ```
     *
     * @generated from field: google.protobuf.Timestamp gte = 6;
     */
    value: Timestamp;
    case: "gte";
  } | {
    /**
     * `gt_now` specifies that this field, of the `google.protobuf.Timestamp` type, must be greater than the current time. `gt_now` can only be used with the `within` rule.
     *
     * ```proto
     * message MyTimestamp {
     *   // value must be greater than now
     *   google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.gt_now = true];
     * }
     * ```
     *
     * @generated from field: bool gt_now = 8;
     */
    value: boolean;
    case: "gtNow";
  } | { case: undefined; value?: undefined };

  /**
   * `within` specifies that this field, of the `google.protobuf.Timestamp` type, must be within the specified duration of the current time. If the field value isn't within the duration, an error message is generated.
   *
   * ```proto
   * message MyTimestamp {
   *   // value must be within 1 hour of now
   *   google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.within = {seconds: 3600}];
   * }
   * ```
   *
   * @generated from field: optional google.protobuf.Duration within = 9;
   */
  within?: Duration;

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyTimestamp {
   *   google.protobuf.Timestamp value = 1 [
   *     (buf.validate.field).timestamp.example = { seconds: 1672444800 },
   *     (buf.validate.field).timestamp.example = { seconds: 1672531200 },
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated google.protobuf.Timestamp example = 10;
   */
  example: Timestamp[];
};

/**
 * TimestampRules describe the rules applied exclusively to the `google.protobuf.Timestamp` well-known type.
 *
 * @generated from message buf.validate.TimestampRules
 */
export declare type TimestampRulesJson = {
  /**
   * `const` dictates that this field, of the `google.protobuf.Timestamp` type, must exactly match the specified value. If the field value doesn't correspond to the specified timestamp, an error message will be generated.
   *
   * ```proto
   * message MyTimestamp {
   *   // value must equal 2023-05-03T10:00:00Z
   *   google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.const = {seconds: 1727998800}];
   * }
   * ```
   *
   * @generated from field: optional google.protobuf.Timestamp const = 2;
   */
  const?: TimestampJson;

  /**
   * requires the duration field value to be less than the specified value (field < value). If the field value doesn't meet the required conditions, an error message is generated.
   *
   * ```proto
   * message MyDuration {
   *   // duration must be less than 'P3D' [duration.lt]
   *   google.protobuf.Duration value = 1 [(buf.validate.field).duration.lt = { seconds: 259200 }];
   * }
   * ```
   *
   * @generated from field: google.protobuf.Timestamp lt = 3;
   */
  lt?: TimestampJson;

  /**
   * requires the timestamp field value to be less than or equal to the specified value (field <= value). If the field value doesn't meet the required conditions, an error message is generated.
   *
   * ```proto
   * message MyTimestamp {
   *   // timestamp must be less than or equal to '2023-05-14T00:00:00Z' [timestamp.lte]
   *   google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.lte = { seconds: 1678867200 }];
   * }
   * ```
   *
   * @generated from field: google.protobuf.Timestamp lte = 4;
   */
  lte?: TimestampJson;

  /**
   * `lt_now` specifies that this field, of the `google.protobuf.Timestamp` type, must be less than the current time. `lt_now` can only be used with the `within` rule.
   *
   * ```proto
   * message MyTimestamp {
   *  // value must be less than now
   *   google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.lt_now = true];
   * }
   * ```
   *
   * @generated from field: bool lt_now = 7;
   */
  ltNow?: boolean;

  /**
   * `gt` requires the timestamp field value to be greater than the specified
   * value (exclusive). If the value of `gt` is larger than a specified `lt`
   * or `lte`, the range is reversed, and the field value must be outside the
   * specified range. If the field value doesn't meet the required conditions,
   * an error message is generated.
   *
   * ```proto
   * message MyTimestamp {
   *   // timestamp must be greater than '2023-01-01T00:00:00Z' [timestamp.gt]
   *   google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.gt = { seconds: 1672444800 }];
   *
   *   // timestamp must be greater than '2023-01-01T00:00:00Z' and less than '2023-01-02T00:00:00Z' [timestamp.gt_lt]
   *   google.protobuf.Timestamp another_value = 2 [(buf.validate.field).timestamp = { gt: { seconds: 1672444800 }, lt: { seconds: 1672531200 } }];
   *
   *   // timestamp must be greater than '2023-01-02T00:00:00Z' or less than '2023-01-01T00:00:00Z' [timestamp.gt_lt_exclusive]
   *   google.protobuf.Timestamp other_value = 3 [(buf.validate.field).timestamp = { gt: { seconds: 1672531200 }, lt: { seconds: 1672444800 } }];
   * }
   * ```
   *
   * @generated from field: google.protobuf.Timestamp gt = 5;
   */
  gt?: TimestampJson;

  /**
   * `gte` requires the timestamp field value to be greater than or equal to the
   * specified value (exclusive). If the value of `gte` is larger than a
   * specified `lt` or `lte`, the range is reversed, and the field value
   * must be outside the specified range. If the field value doesn't meet
   * the required conditions, an error message is generated.
   *
   * ```proto
   * message MyTimestamp {
   *   // timestamp must be greater than or equal to '2023-01-01T00:00:00Z' [timestamp.gte]
   *   google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.gte = { seconds: 1672444800 }];
   *
   *   // timestamp must be greater than or equal to '2023-01-01T00:00:00Z' and less than '2023-01-02T00:00:00Z' [timestamp.gte_lt]
   *   google.protobuf.Timestamp another_value = 2 [(buf.validate.field).timestamp = { gte: { seconds: 1672444800 }, lt: { seconds: 1672531200 } }];
   *
   *   // timestamp must be greater than or equal to '2023-01-02T00:00:00Z' or less than '2023-01-01T00:00:00Z' [timestamp.gte_lt_exclusive]
   *   google.protobuf.Timestamp other_value = 3 [(buf.validate.field).timestamp = { gte: { seconds: 1672531200 }, lt: { seconds: 1672444800 } }];
   * }
   * ```
   *
   * @generated from field: google.protobuf.Timestamp gte = 6;
   */
  gte?: TimestampJson;

  /**
   * `gt_now` specifies that this field, of the `google.protobuf.Timestamp` type, must be greater than the current time. `gt_now` can only be used with the `within` rule.
   *
   * ```proto
   * message MyTimestamp {
   *   // value must be greater than now
   *   google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.gt_now = true];
   * }
   * ```
   *
   * @generated from field: bool gt_now = 8;
   */
  gtNow?: boolean;

  /**
   * `within` specifies that this field, of the `google.protobuf.Timestamp` type, must be within the specified duration of the current time. If the field value isn't within the duration, an error message is generated.
   *
   * ```proto
   * message MyTimestamp {
   *   // value must be within 1 hour of now
   *   google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.within = {seconds: 3600}];
   * }
   * ```
   *
   * @generated from field: optional google.protobuf.Duration within = 9;
   */
  within?: DurationJson;

  /**
   * `example` specifies values that the field may have. These values SHOULD
   * conform to other rules. `example` values will not impact validation
   * but may be used as helpful guidance on how to populate the given field.
   *
   * ```proto
   * message MyTimestamp {
   *   google.protobuf.Timestamp value = 1 [
   *     (buf.validate.field).timestamp.example = { seconds: 1672444800 },
   *     (buf.validate.field).timestamp.example = { seconds: 1672531200 },
   *   ];
   * }
   * ```
   *
   * @generated from field: repeated google.protobuf.Timestamp example = 10;
   */
  example?: TimestampJson[];
};

/**
 * Describes the message buf.validate.TimestampRules.
 * Use `create(TimestampRulesSchema)` to create a new message.
 */
export declare const TimestampRulesSchema: GenMessage<TimestampRules, {jsonType: TimestampRulesJson}>;

/**
 * `Violations` is a collection of `Violation` messages. This message type is returned by
 * Protovalidate when a proto message fails to meet the requirements set by the `Rule` validation rules.
 * Each individual violation is represented by a `Violation` message.
 *
 * @generated from message buf.validate.Violations
 */
export declare type Violations = Message<"buf.validate.Violations"> & {
  /**
   * `violations` is a repeated field that contains all the `Violation` messages corresponding to the violations detected.
   *
   * @generated from field: repeated buf.validate.Violation violations = 1;
   */
  violations: Violation[];
};

/**
 * `Violations` is a collection of `Violation` messages. This message type is returned by
 * Protovalidate when a proto message fails to meet the requirements set by the `Rule` validation rules.
 * Each individual violation is represented by a `Violation` message.
 *
 * @generated from message buf.validate.Violations
 */
export declare type ViolationsJson = {
  /**
   * `violations` is a repeated field that contains all the `Violation` messages corresponding to the violations detected.
   *
   * @generated from field: repeated buf.validate.Violation violations = 1;
   */
  violations?: ViolationJson[];
};

/**
 * Describes the message buf.validate.Violations.
 * Use `create(ViolationsSchema)` to create a new message.
 */
export declare const ViolationsSchema: GenMessage<Violations, {jsonType: ViolationsJson}>;

/**
 * `Violation` represents a single instance where a validation rule, expressed
 * as a `Rule`, was not met. It provides information about the field that
 * caused the violation, the specific rule that wasn't fulfilled, and a
 * human-readable error message.
 *
 * For example, consider the following message:
 *
 * ```proto
 * message User {
 *     int32 age = 1 [(buf.validate.field).cel = {
 *         id: "user.age",
 *         expression: "this < 18 ? 'User must be at least 18 years old' : ''",
 *     }];
 * }
 * ```
 *
 * It could produce the following violation:
 *
 * ```json
 * {
 *   "ruleId": "user.age",
 *   "message": "User must be at least 18 years old",
 *   "field": {
 *     "elements": [
 *       {
 *         "fieldNumber": 1,
 *         "fieldName": "age",
 *         "fieldType": "TYPE_INT32"
 *       }
 *     ]
 *   },
 *   "rule": {
 *     "elements": [
 *       {
 *         "fieldNumber": 23,
 *         "fieldName": "cel",
 *         "fieldType": "TYPE_MESSAGE",
 *         "index": "0"
 *       }
 *     ]
 *   }
 * }
 * ```
 *
 * @generated from message buf.validate.Violation
 */
export declare type Violation = Message<"buf.validate.Violation"> & {
  /**
   * `field` is a machine-readable path to the field that failed validation.
   * This could be a nested field, in which case the path will include all the parent fields leading to the actual field that caused the violation.
   *
   * For example, consider the following message:
   *
   * ```proto
   * message Message {
   *   bool a = 1 [(buf.validate.field).required = true];
   * }
   * ```
   *
   * It could produce the following violation:
   *
   * ```textproto
   * violation {
   *   field { element { field_number: 1, field_name: "a", field_type: 8 } }
   *   ...
   * }
   * ```
   *
   * @generated from field: optional buf.validate.FieldPath field = 5;
   */
  field?: FieldPath;

  /**
   * `rule` is a machine-readable path that points to the specific rule that failed validation.
   * This will be a nested field starting from the FieldRules of the field that failed validation.
   * For custom rules, this will provide the path of the rule, e.g. `cel[0]`.
   *
   * For example, consider the following message:
   *
   * ```proto
   * message Message {
   *   bool a = 1 [(buf.validate.field).required = true];
   *   bool b = 2 [(buf.validate.field).cel = {
   *     id: "custom_rule",
   *     expression: "!this ? 'b must be true': ''"
   *   }]
   * }
   * ```
   *
   * It could produce the following violations:
   *
   * ```textproto
   * violation {
   *   rule { element { field_number: 25, field_name: "required", field_type: 8 } }
   *   ...
   * }
   * violation {
   *   rule { element { field_number: 23, field_name: "cel", field_type: 11, index: 0 } }
   *   ...
   * }
   * ```
   *
   * @generated from field: optional buf.validate.FieldPath rule = 6;
   */
  rule?: FieldPath;

  /**
   * `rule_id` is the unique identifier of the `Rule` that was not fulfilled.
   * This is the same `id` that was specified in the `Rule` message, allowing easy tracing of which rule was violated.
   *
   * @generated from field: optional string rule_id = 2;
   */
  ruleId: string;

  /**
   * `message` is a human-readable error message that describes the nature of the violation.
   * This can be the default error message from the violated `Rule`, or it can be a custom message that gives more context about the violation.
   *
   * @generated from field: optional string message = 3;
   */
  message: string;

  /**
   * `for_key` indicates whether the violation was caused by a map key, rather than a value.
   *
   * @generated from field: optional bool for_key = 4;
   */
  forKey: boolean;
};

/**
 * `Violation` represents a single instance where a validation rule, expressed
 * as a `Rule`, was not met. It provides information about the field that
 * caused the violation, the specific rule that wasn't fulfilled, and a
 * human-readable error message.
 *
 * For example, consider the following message:
 *
 * ```proto
 * message User {
 *     int32 age = 1 [(buf.validate.field).cel = {
 *         id: "user.age",
 *         expression: "this < 18 ? 'User must be at least 18 years old' : ''",
 *     }];
 * }
 * ```
 *
 * It could produce the following violation:
 *
 * ```json
 * {
 *   "ruleId": "user.age",
 *   "message": "User must be at least 18 years old",
 *   "field": {
 *     "elements": [
 *       {
 *         "fieldNumber": 1,
 *         "fieldName": "age",
 *         "fieldType": "TYPE_INT32"
 *       }
 *     ]
 *   },
 *   "rule": {
 *     "elements": [
 *       {
 *         "fieldNumber": 23,
 *         "fieldName": "cel",
 *         "fieldType": "TYPE_MESSAGE",
 *         "index": "0"
 *       }
 *     ]
 *   }
 * }
 * ```
 *
 * @generated from message buf.validate.Violation
 */
export declare type ViolationJson = {
  /**
   * `field` is a machine-readable path to the field that failed validation.
   * This could be a nested field, in which case the path will include all the parent fields leading to the actual field that caused the violation.
   *
   * For example, consider the following message:
   *
   * ```proto
   * message Message {
   *   bool a = 1 [(buf.validate.field).required = true];
   * }
   * ```
   *
   * It could produce the following violation:
   *
   * ```textproto
   * violation {
   *   field { element { field_number: 1, field_name: "a", field_type: 8 } }
   *   ...
   * }
   * ```
   *
   * @generated from field: optional buf.validate.FieldPath field = 5;
   */
  field?: FieldPathJson;

  /**
   * `rule` is a machine-readable path that points to the specific rule that failed validation.
   * This will be a nested field starting from the FieldRules of the field that failed validation.
   * For custom rules, this will provide the path of the rule, e.g. `cel[0]`.
   *
   * For example, consider the following message:
   *
   * ```proto
   * message Message {
   *   bool a = 1 [(buf.validate.field).required = true];
   *   bool b = 2 [(buf.validate.field).cel = {
   *     id: "custom_rule",
   *     expression: "!this ? 'b must be true': ''"
   *   }]
   * }
   * ```
   *
   * It could produce the following violations:
   *
   * ```textproto
   * violation {
   *   rule { element { field_number: 25, field_name: "required", field_type: 8 } }
   *   ...
   * }
   * violation {
   *   rule { element { field_number: 23, field_name: "cel", field_type: 11, index: 0 } }
   *   ...
   * }
   * ```
   *
   * @generated from field: optional buf.validate.FieldPath rule = 6;
   */
  rule?: FieldPathJson;

  /**
   * `rule_id` is the unique identifier of the `Rule` that was not fulfilled.
   * This is the same `id` that was specified in the `Rule` message, allowing easy tracing of which rule was violated.
   *
   * @generated from field: optional string rule_id = 2;
   */
  ruleId?: string;

  /**
   * `message` is a human-readable error message that describes the nature of the violation.
   * This can be the default error message from the violated `Rule`, or it can be a custom message that gives more context about the violation.
   *
   * @generated from field: optional string message = 3;
   */
  message?: string;

  /**
   * `for_key` indicates whether the violation was caused by a map key, rather than a value.
   *
   * @generated from field: optional bool for_key = 4;
   */
  forKey?: boolean;
};

/**
 * Describes the message buf.validate.Violation.
 * Use `create(ViolationSchema)` to create a new message.
 */
export declare const ViolationSchema: GenMessage<Violation, {jsonType: ViolationJson}>;

/**
 * `FieldPath` provides a path to a nested protobuf field.
 *
 * This message provides enough information to render a dotted field path even without protobuf descriptors.
 * It also provides enough information to resolve a nested field through unknown wire data.
 *
 * @generated from message buf.validate.FieldPath
 */
export declare type FieldPath = Message<"buf.validate.FieldPath"> & {
  /**
   * `elements` contains each element of the path, starting from the root and recursing downward.
   *
   * @generated from field: repeated buf.validate.FieldPathElement elements = 1;
   */
  elements: FieldPathElement[];
};

/**
 * `FieldPath` provides a path to a nested protobuf field.
 *
 * This message provides enough information to render a dotted field path even without protobuf descriptors.
 * It also provides enough information to resolve a nested field through unknown wire data.
 *
 * @generated from message buf.validate.FieldPath
 */
export declare type FieldPathJson = {
  /**
   * `elements` contains each element of the path, starting from the root and recursing downward.
   *
   * @generated from field: repeated buf.validate.FieldPathElement elements = 1;
   */
  elements?: FieldPathElementJson[];
};

/**
 * Describes the message buf.validate.FieldPath.
 * Use `create(FieldPathSchema)` to create a new message.
 */
export declare const FieldPathSchema: GenMessage<FieldPath, {jsonType: FieldPathJson}>;

/**
 * `FieldPathElement` provides enough information to nest through a single protobuf field.
 *
 * If the selected field is a map or repeated field, the `subscript` value selects a specific element from it.
 * A path that refers to a value nested under a map key or repeated field index will have a `subscript` value.
 * The `field_type` field allows unambiguous resolution of a field even if descriptors are not available.
 *
 * @generated from message buf.validate.FieldPathElement
 */
export declare type FieldPathElement = Message<"buf.validate.FieldPathElement"> & {
  /**
   * `field_number` is the field number this path element refers to.
   *
   * @generated from field: optional int32 field_number = 1;
   */
  fieldNumber: number;

  /**
   * `field_name` contains the field name this path element refers to.
   * This can be used to display a human-readable path even if the field number is unknown.
   *
   * @generated from field: optional string field_name = 2;
   */
  fieldName: string;

  /**
   * `field_type` specifies the type of this field. When using reflection, this value is not needed.
   *
   * This value is provided to make it possible to traverse unknown fields through wire data.
   * When traversing wire data, be mindful of both packed[1] and delimited[2] encoding schemes.
   *
   * [1]: https://protobuf.dev/programming-guides/encoding/#packed
   * [2]: https://protobuf.dev/programming-guides/encoding/#groups
   *
   * N.B.: Although groups are deprecated, the corresponding delimited encoding scheme is not, and
   * can be explicitly used in Protocol Buffers 2023 Edition.
   *
   * @generated from field: optional google.protobuf.FieldDescriptorProto.Type field_type = 3;
   */
  fieldType: FieldDescriptorProto_Type;

  /**
   * `key_type` specifies the map key type of this field. This value is useful when traversing
   * unknown fields through wire data: specifically, it allows handling the differences between
   * different integer encodings.
   *
   * @generated from field: optional google.protobuf.FieldDescriptorProto.Type key_type = 4;
   */
  keyType: FieldDescriptorProto_Type;

  /**
   * `value_type` specifies map value type of this field. This is useful if you want to display a
   * value inside unknown fields through wire data.
   *
   * @generated from field: optional google.protobuf.FieldDescriptorProto.Type value_type = 5;
   */
  valueType: FieldDescriptorProto_Type;

  /**
   * `subscript` contains a repeated index or map key, if this path element nests into a repeated or map field.
   *
   * @generated from oneof buf.validate.FieldPathElement.subscript
   */
  subscript: {
    /**
     * `index` specifies a 0-based index into a repeated field.
     *
     * @generated from field: uint64 index = 6;
     */
    value: bigint;
    case: "index";
  } | {
    /**
     * `bool_key` specifies a map key of type bool.
     *
     * @generated from field: bool bool_key = 7;
     */
    value: boolean;
    case: "boolKey";
  } | {
    /**
     * `int_key` specifies a map key of type int32, int64, sint32, sint64, sfixed32 or sfixed64.
     *
     * @generated from field: int64 int_key = 8;
     */
    value: bigint;
    case: "intKey";
  } | {
    /**
     * `uint_key` specifies a map key of type uint32, uint64, fixed32 or fixed64.
     *
     * @generated from field: uint64 uint_key = 9;
     */
    value: bigint;
    case: "uintKey";
  } | {
    /**
     * `string_key` specifies a map key of type string.
     *
     * @generated from field: string string_key = 10;
     */
    value: string;
    case: "stringKey";
  } | { case: undefined; value?: undefined };
};

/**
 * `FieldPathElement` provides enough information to nest through a single protobuf field.
 *
 * If the selected field is a map or repeated field, the `subscript` value selects a specific element from it.
 * A path that refers to a value nested under a map key or repeated field index will have a `subscript` value.
 * The `field_type` field allows unambiguous resolution of a field even if descriptors are not available.
 *
 * @generated from message buf.validate.FieldPathElement
 */
export declare type FieldPathElementJson = {
  /**
   * `field_number` is the field number this path element refers to.
   *
   * @generated from field: optional int32 field_number = 1;
   */
  fieldNumber?: number;

  /**
   * `field_name` contains the field name this path element refers to.
   * This can be used to display a human-readable path even if the field number is unknown.
   *
   * @generated from field: optional string field_name = 2;
   */
  fieldName?: string;

  /**
   * `field_type` specifies the type of this field. When using reflection, this value is not needed.
   *
   * This value is provided to make it possible to traverse unknown fields through wire data.
   * When traversing wire data, be mindful of both packed[1] and delimited[2] encoding schemes.
   *
   * [1]: https://protobuf.dev/programming-guides/encoding/#packed
   * [2]: https://protobuf.dev/programming-guides/encoding/#groups
   *
   * N.B.: Although groups are deprecated, the corresponding delimited encoding scheme is not, and
   * can be explicitly used in Protocol Buffers 2023 Edition.
   *
   * @generated from field: optional google.protobuf.FieldDescriptorProto.Type field_type = 3;
   */
  fieldType?: FieldDescriptorProto_TypeJson;

  /**
   * `key_type` specifies the map key type of this field. This value is useful when traversing
   * unknown fields through wire data: specifically, it allows handling the differences between
   * different integer encodings.
   *
   * @generated from field: optional google.protobuf.FieldDescriptorProto.Type key_type = 4;
   */
  keyType?: FieldDescriptorProto_TypeJson;

  /**
   * `value_type` specifies map value type of this field. This is useful if you want to display a
   * value inside unknown fields through wire data.
   *
   * @generated from field: optional google.protobuf.FieldDescriptorProto.Type value_type = 5;
   */
  valueType?: FieldDescriptorProto_TypeJson;

  /**
   * `index` specifies a 0-based index into a repeated field.
   *
   * @generated from field: uint64 index = 6;
   */
  index?: string;

  /**
   * `bool_key` specifies a map key of type bool.
   *
   * @generated from field: bool bool_key = 7;
   */
  boolKey?: boolean;

  /**
   * `int_key` specifies a map key of type int32, int64, sint32, sint64, sfixed32 or sfixed64.
   *
   * @generated from field: int64 int_key = 8;
   */
  intKey?: string;

  /**
   * `uint_key` specifies a map key of type uint32, uint64, fixed32 or fixed64.
   *
   * @generated from field: uint64 uint_key = 9;
   */
  uintKey?: string;

  /**
   * `string_key` specifies a map key of type string.
   *
   * @generated from field: string string_key = 10;
   */
  stringKey?: string;
};

/**
 * Describes the message buf.validate.FieldPathElement.
 * Use `create(FieldPathElementSchema)` to create a new message.
 */
export declare const FieldPathElementSchema: GenMessage<FieldPathElement, {jsonType: FieldPathElementJson}>;

/**
 * Specifies how `FieldRules.ignore` behaves, depending on the field's value, and
 * whether the field tracks presence.
 *
 * @generated from enum buf.validate.Ignore
 */
export enum Ignore {
  /**
   * Ignore rules if the field tracks presence and is unset. This is the default
   * behavior.
   *
   * In proto3, only message fields, members of a Protobuf `oneof`, and fields
   * with the `optional` label track presence. Consequently, the following fields
   * are always validated, whether a value is set or not:
   *
   * ```proto
   * syntax="proto3";
   *
   * message RulesApply {
   *   string email = 1 [
   *     (buf.validate.field).string.email = true
   *   ];
   *   int32 age = 2 [
   *     (buf.validate.field).int32.gt = 0
   *   ];
   *   repeated string labels = 3 [
   *     (buf.validate.field).repeated.min_items = 1
   *   ];
   * }
   * ```
   *
   * In contrast, the following fields track presence, and are only validated if
   * a value is set:
   *
   * ```proto
   * syntax="proto3";
   *
   * message RulesApplyIfSet {
   *   optional string email = 1 [
   *     (buf.validate.field).string.email = true
   *   ];
   *   oneof ref {
   *     string reference = 2 [
   *       (buf.validate.field).string.uuid = true
   *     ];
   *     string name = 3 [
   *       (buf.validate.field).string.min_len = 4
   *     ];
   *   }
   *   SomeMessage msg = 4 [
   *     (buf.validate.field).cel = {/* ... *\/}
   *   ];
   * }
   * ```
   *
   * To ensure that such a field is set, add the `required` rule.
   *
   * To learn which fields track presence, see the
   * [Field Presence cheat sheet](https://protobuf.dev/programming-guides/field_presence/#cheat).
   *
   * @generated from enum value: IGNORE_UNSPECIFIED = 0;
   */
  UNSPECIFIED = 0,

  /**
   * Ignore rules if the field is unset, also for fields that don't track
   * presence.
   *
   * In proto3, repeated fields, map fields, and fields with scalar types don't
   * track presence. Consequently, the following fields are only validated if
   * they are set:
   *
   * ```proto
   * syntax="proto3";
   *
   * message RulesApplyIfSet {
   *   // `string.email` is ignored for the empty string.
   *   string link = 1 [
   *     (buf.validate.field).string.email = true,
   *     (buf.validate.field).ignore = IGNORE_IF_UNPOPULATED
   *   ];
   *   // `int32.gte` is ignored for the zero value.
   *   int32 age = 2 [
   *     (buf.validate.field).int32.gte = 21,
   *     (buf.validate.field).ignore = IGNORE_IF_UNPOPULATED
   *   ];
   *   // `repeated.min_items` is ignored if the list is empty.
   *   repeated string labels = 3 [
   *     (buf.validate.field).repeated.min_items = 3,
   *     (buf.validate.field).ignore = IGNORE_IF_UNPOPULATED
   *   ];
   * }
   * ```
   *
   * For fields that don't track presence, the field's value determines
   * whether the field is set and rules apply:
   *
   * - For string and bytes, an empty value is ignored.
   * - For bool, false is ignored.
   * - For numeric types, zero is ignored.
   * - For enums, the first defined enum value is ignored.
   * - For repeated fields, an empty list is ignored.
   * - For map fields, an empty map is ignored.
   * - For message fields, absence of the message (typically a null-value) is
   *   ignored.
   *
   * For fields that track presence (e.g. adding the `optional` label in proto3),
   * behavior is the same as the default `IGNORE_UNSPECIFIED`.
   *
   * To learn which fields track presence, see the
   * [Field Presence cheat sheet](https://protobuf.dev/programming-guides/field_presence/#cheat).
   *
   * @generated from enum value: IGNORE_IF_UNPOPULATED = 1;
   */
  IF_UNPOPULATED = 1,

  /**
   * Ignore rules if the field is unset, or set to the default value.
   *
   * The default value depends on the field type:
   * - For strings, the default value is the empty string.
   * - For bytes, the default value is empty bytes.
   * - For bool, the default value is false.
   * - For numeric types, the default value is zero.
   * - For enums, the default value is the first defined enum value.
   * - For repeated fields, the default is an empty list.
   * - For map fields, the default is an empty map.
   * - For message fields, Protovalidate treats the empty message as the
   *   default value. All rules of the referenced message are ignored as well.
   *
   * For some fields, the default value can be overridden with the Protobuf
   * `default` option.
   *
   * For fields that don't track presence and don't have the `default` option,
   * behavior is the same as the default `IGNORE_UNSPECIFIED`.
   *
   * @generated from enum value: IGNORE_IF_DEFAULT_VALUE = 2;
   */
  IF_DEFAULT_VALUE = 2,

  /**
   * Always ignore rules, including the `required` rule.
   *
   * This is useful for ignoring the rules of a referenced message, or to
   * temporarily ignore rules during development.
   *
   * ```proto
   * message MyMessage {
   *   // The field's rules will always be ignored, including any validation's
   *   // on value's fields.
   *   MyOtherMessage value = 1 [
   *     (buf.validate.field).ignore = IGNORE_ALWAYS];
   * }
   * ```
   *
   * @generated from enum value: IGNORE_ALWAYS = 3;
   */
  ALWAYS = 3,
}

/**
 * Specifies how `FieldRules.ignore` behaves, depending on the field's value, and
 * whether the field tracks presence.
 *
 * @generated from enum buf.validate.Ignore
 */
export declare type IgnoreJson = "IGNORE_UNSPECIFIED" | "IGNORE_IF_UNPOPULATED" | "IGNORE_IF_DEFAULT_VALUE" | "IGNORE_ALWAYS";

/**
 * Describes the enum buf.validate.Ignore.
 */
export declare const IgnoreSchema: GenEnum<Ignore, IgnoreJson>;

/**
 * KnownRegex contains some well-known patterns.
 *
 * @generated from enum buf.validate.KnownRegex
 */
export enum KnownRegex {
  /**
   * @generated from enum value: KNOWN_REGEX_UNSPECIFIED = 0;
   */
  UNSPECIFIED = 0,

  /**
   * HTTP header name as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2).
   *
   * @generated from enum value: KNOWN_REGEX_HTTP_HEADER_NAME = 1;
   */
  HTTP_HEADER_NAME = 1,

  /**
   * HTTP header value as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.4).
   *
   * @generated from enum value: KNOWN_REGEX_HTTP_HEADER_VALUE = 2;
   */
  HTTP_HEADER_VALUE = 2,
}

/**
 * KnownRegex contains some well-known patterns.
 *
 * @generated from enum buf.validate.KnownRegex
 */
export declare type KnownRegexJson = "KNOWN_REGEX_UNSPECIFIED" | "KNOWN_REGEX_HTTP_HEADER_NAME" | "KNOWN_REGEX_HTTP_HEADER_VALUE";

/**
 * Describes the enum buf.validate.KnownRegex.
 */
export declare const KnownRegexSchema: GenEnum<KnownRegex, KnownRegexJson>;

/**
 * Rules specify the validations to be performed on this message. By default,
 * no validation is performed against a message.
 *
 * @generated from extension: optional buf.validate.MessageRules message = 1159;
 */
export declare const message: GenExtension<MessageOptions, MessageRules>;

/**
 * Rules specify the validations to be performed on this oneof. By default,
 * no validation is performed against a oneof.
 *
 * @generated from extension: optional buf.validate.OneofRules oneof = 1159;
 */
export declare const oneof: GenExtension<OneofOptions, OneofRules>;

/**
 * Rules specify the validations to be performed on this field. By default,
 * no validation is performed against a field.
 *
 * @generated from extension: optional buf.validate.FieldRules field = 1159;
 */
export declare const field: GenExtension<FieldOptions, FieldRules>;

/**
 * Specifies predefined rules. When extending a standard rule message,
 * this adds additional CEL expressions that apply when the extension is used.
 *
 * ```proto
 * extend buf.validate.Int32Rules {
 *   bool is_zero [(buf.validate.predefined).cel = {
 *     id: "int32.is_zero",
 *     message: "value must be zero",
 *     expression: "!rule || this == 0",
 *   }];
 * }
 *
 * message Foo {
 *   int32 reserved = 1 [(buf.validate.field).int32.(is_zero) = true];
 * }
 * ```
 *
 * @generated from extension: optional buf.validate.PredefinedRules predefined = 1160;
 */
export declare const predefined: GenExtension<FieldOptions, PredefinedRules>;
