/* SPDX-FileCopyrightText: 2009 Blender Authors
 *
 * SPDX-License-Identifier: GPL-2.0-or-later */

/** \file
 * \ingroup editorui
 */

/* NOTE: this is included multiple times with different #defines for DEF_ICON. */

/* Auto define more specific types for places that do not need the distinction. */
#ifndef DEF_ICON_SCENE
#  define DEF_ICON_SCENE DEF_ICON
#endif
#ifndef DEF_ICON_COLLECTION
#  define DEF_ICON_COLLECTION DEF_ICON
#endif
#ifndef DEF_ICON_OBJECT
#  define DEF_ICON_OBJECT DEF_ICON
#endif
#ifndef DEF_ICON_OBJECT_DATA
#  define DEF_ICON_OBJECT_DATA DEF_ICON
#endif
#ifndef DEF_ICON_MODIFIER
#  define DEF_ICON_MODIFIER DEF_ICON
#endif
#ifndef DEF_ICON_SHADING
#  define DEF_ICON_SHADING DEF_ICON
#endif
#ifndef DEF_ICON_FOLDER
#  define DEF_ICON_FOLDER DEF_ICON
#endif
#ifndef DEF_ICON_COLOR
#  define DEF_ICON_COLOR DEF_ICON
#endif
#ifndef DEF_ICON_FUND
#  define DEF_ICON_FUND DEF_ICON
#endif

/* ICON_NONE has to be the first item here because it is hard-coded in places as 0. */
DEF_ICON(NONE)

/* Keep these here, in this order. Their IDs should be static. */
DEF_ICON(CHAR_NOTDEF)
DEF_ICON(CHAR_REPLACEMENT)
DEF_ICON(NOT_FOUND)

/* Blank is no real icon, but used as placeholder or spacers,
 * it takes the space of an icon but is empty. */
DEF_ICON(BLANK1)

/* Keep the order among the pairs because these icons
 * are used for toggles that require a consecutive order. */
/* TOGGLES */
DEF_ICON(AUTOMERGE_OFF)
DEF_ICON(AUTOMERGE_ON)
DEF_ICON(CHECKBOX_DEHLT) /* de-Highlight - Checkbox OFF */
DEF_ICON(CHECKBOX_HLT)   /* Highlight - Checkbox ON */
DEF_ICON(CLIPUV_DEHLT)
DEF_ICON(CLIPUV_HLT)
DEF_ICON(DECORATE_UNLOCKED)
DEF_ICON(DECORATE_LOCKED)
DEF_ICON(FAKE_USER_OFF)
DEF_ICON(FAKE_USER_ON)
DEF_ICON(HIDE_ON)
DEF_ICON(HIDE_OFF)
DEF_ICON(INDIRECT_ONLY_OFF)
DEF_ICON(INDIRECT_ONLY_ON)
DEF_ICON(ONIONSKIN_OFF)
DEF_ICON(ONIONSKIN_ON)
DEF_ICON(UNPINNED)
DEF_ICON(PINNED)
DEF_ICON(RADIOBUT_OFF)
DEF_ICON(RADIOBUT_ON)
DEF_ICON(RECORD_OFF)
DEF_ICON_COLOR(RECORD_ON)
DEF_ICON(RESTRICT_RENDER_ON)
DEF_ICON(RESTRICT_RENDER_OFF)
DEF_ICON(RESTRICT_SELECT_ON)
DEF_ICON(RESTRICT_SELECT_OFF)
DEF_ICON(RESTRICT_VIEW_ON)
DEF_ICON(RESTRICT_VIEW_OFF)
DEF_ICON(RIGHTARROW)
DEF_ICON(DOWNARROW_HLT)
DEF_ICON(SELECT_INTERSECT)
DEF_ICON(SELECT_DIFFERENCE)
DEF_ICON(SNAP_OFF)
DEF_ICON(SNAP_ON)
DEF_ICON(UNLOCKED)
DEF_ICON(LOCKED)
DEF_ICON(VIS_SEL_11)
DEF_ICON(VIS_SEL_10)
DEF_ICON(VIS_SEL_01)
DEF_ICON(VIS_SEL_00)

/* DIALOGS */
DEF_ICON(CANCEL)
DEF_ICON(ERROR)
DEF_ICON(QUESTION)

/* UI */
DEF_ICON(ADD)
DEF_ICON(ARROW_LEFTRIGHT)
DEF_ICON(AUTO)
DEF_ICON(BLENDER)
DEF_ICON(BORDERMOVE)
DEF_ICON(BRUSHES_ALL)
DEF_ICON(CHECKMARK)
DEF_ICON(COLLAPSEMENU)
DEF_ICON(COLLECTION_NEW)
DEF_ICON(COLOR) /* see COLOR_RED/GREEN/BLUE */
DEF_ICON(COPY_ID)
DEF_ICON(DISCLOSURE_TRI_DOWN)
DEF_ICON(DISCLOSURE_TRI_RIGHT)
DEF_ICON(DOT)
DEF_ICON(DRIVER_DISTANCE)
DEF_ICON(DRIVER_ROTATIONAL_DIFFERENCE)
DEF_ICON(DRIVER_TRANSFORM)
DEF_ICON(DUPLICATE)
DEF_ICON(EYEDROPPER)
DEF_ICON(FCURVE_SNAPSHOT)
DEF_ICON(FILE_NEW)
DEF_ICON(FILE_TICK)
DEF_ICON(FREEZE)
DEF_ICON(FULLSCREEN_ENTER)
DEF_ICON(FULLSCREEN_EXIT)
DEF_ICON(GHOST_DISABLED)
DEF_ICON(GHOST_ENABLED)
DEF_ICON(GRIP)
DEF_ICON(GRIP_V)
DEF_ICON(HAND)
DEF_ICON(HELP)
DEF_ICON(LINKED)
DEF_ICON(MENU_PANEL)
DEF_ICON(NODE_SEL)
DEF_ICON(NODE)
DEF_ICON(OBJECT_HIDDEN)
DEF_ICON(OPTIONS)
DEF_ICON(PANEL_CLOSE)
DEF_ICON(PLUGIN)
DEF_ICON(PLUS)
DEF_ICON(PRESET_NEW)
DEF_ICON(QUIT)
DEF_ICON(RECOVER_LAST)
DEF_ICON(REMOVE)
DEF_ICON(RIGHTARROW_THIN)
DEF_ICON(SCREEN_BACK)
DEF_ICON(STATUSBAR)
DEF_ICON(STYLUS_PRESSURE)
DEF_ICON(THREE_DOTS)
DEF_ICON(TOPBAR)
DEF_ICON(TRASH)
DEF_ICON(TRIA_DOWN)
DEF_ICON(TRIA_LEFT)
DEF_ICON(TRIA_RIGHT)
DEF_ICON(TRIA_UP)
DEF_ICON(UNLINKED)
DEF_ICON(URL)
DEF_ICON(VIEWZOOM)
DEF_ICON(WINDOW)
DEF_ICON(WORKSPACE)
DEF_ICON(X)
DEF_ICON(ZOOM_ALL)
DEF_ICON(ZOOM_IN)
DEF_ICON(ZOOM_OUT)
DEF_ICON(ZOOM_PREVIOUS)
DEF_ICON(ZOOM_SELECTED)

/* PROPERTIES */
DEF_ICON_MODIFIER(MODIFIER)
DEF_ICON_MODIFIER(PARTICLES)
DEF_ICON_MODIFIER(PHYSICS)
DEF_ICON_MODIFIER(SHADERFX)
DEF_ICON_OBJECT_DATA(SPEAKER)
DEF_ICON_SCENE(OUTPUT)
DEF_ICON_SCENE(SCENE)
DEF_ICON_SCENE(TOOL_SETTINGS)
DEF_ICON_SHADING(LIGHT)
DEF_ICON_SHADING(MATERIAL)
DEF_ICON_SHADING(TEXTURE)
DEF_ICON_SHADING(WORLD)
DEF_ICON(ANIM)
DEF_ICON(SCRIPT)

/* EDITORS */
DEF_ICON_MODIFIER(GEOMETRY_NODES)
DEF_ICON_OBJECT_DATA(TEXT)
DEF_ICON(ACTION)
DEF_ICON(ASSET_MANAGER)
DEF_ICON(CONSOLE)
DEF_ICON(FILEBROWSER)
DEF_ICON(GEOMETRY_SET)
DEF_ICON(GRAPH)
DEF_ICON(IMAGE)
DEF_ICON(INFO)
DEF_ICON(NLA)
DEF_ICON(NODE_COMPOSITING)
DEF_ICON(NODE_MATERIAL)
DEF_ICON(NODE_TEXTURE)
DEF_ICON(NODETREE)
DEF_ICON(OUTLINER)
DEF_ICON(PREFERENCES)
DEF_ICON(PROPERTIES)
DEF_ICON(SEQUENCE)
DEF_ICON(SOUND)
DEF_ICON(SPREADSHEET)
DEF_ICON(TIME)
DEF_ICON(TRACKER)
DEF_ICON(UV)
DEF_ICON(VIEW3D)

/* MODES */
DEF_ICON(EDITMODE_HLT)
DEF_ICON(OBJECT_DATAMODE) /* XXX fix this up */
DEF_ICON(PARTICLEMODE)
DEF_ICON(POSE_HLT)
DEF_ICON(SCULPTMODE_HLT)
DEF_ICON(TPAINT_HLT)
DEF_ICON(UV_DATA)
DEF_ICON(VPAINT_HLT)
DEF_ICON(WPAINT_HLT)

/* TRACKING */
DEF_ICON(TRACKER_DATA)
DEF_ICON(TRACKING_BACKWARDS_SINGLE)
DEF_ICON(TRACKING_BACKWARDS)
DEF_ICON(TRACKING_CLEAR_BACKWARDS)
DEF_ICON(TRACKING_CLEAR_FORWARDS)
DEF_ICON(TRACKING_FORWARDS_SINGLE)
DEF_ICON(TRACKING_FORWARDS)
DEF_ICON(TRACKING_REFINE_BACKWARDS)
DEF_ICON(TRACKING_REFINE_FORWARDS)
DEF_ICON(TRACKING)

/* DATA */
DEF_ICON_COLLECTION(GROUP)
DEF_ICON_MODIFIER(CONSTRAINT_BONE)
DEF_ICON_MODIFIER(CONSTRAINT)
DEF_ICON_OBJECT_DATA(ARMATURE_DATA)
DEF_ICON_OBJECT_DATA(BONE_DATA)
DEF_ICON_OBJECT_DATA(CAMERA_DATA)
DEF_ICON_OBJECT_DATA(CURVE_DATA)
DEF_ICON_OBJECT_DATA(EMPTY_DATA)
DEF_ICON_OBJECT_DATA(FONT_DATA)
DEF_ICON_OBJECT_DATA(LATTICE_DATA)
DEF_ICON_OBJECT_DATA(LIGHT_DATA)
DEF_ICON_OBJECT_DATA(MESH_DATA)
DEF_ICON_OBJECT_DATA(META_DATA)
DEF_ICON_OBJECT_DATA(PARTICLE_DATA)
DEF_ICON_OBJECT_DATA(SHAPEKEY_DATA)
DEF_ICON_OBJECT_DATA(SURFACE_DATA)
DEF_ICON_OBJECT(OBJECT_DATA)
DEF_ICON_SCENE(RENDER_RESULT)
DEF_ICON_SCENE(RENDERLAYERS)
DEF_ICON_SCENE(SCENE_DATA)
DEF_ICON_SHADING(BRUSH_DATA)
DEF_ICON_SHADING(IMAGE_DATA)
DEF_ICON_SHADING(LINE_DATA)
DEF_ICON_SHADING(MATERIAL_DATA)
DEF_ICON_SHADING(TEXTURE_DATA)
DEF_ICON_SHADING(WORLD_DATA)
DEF_ICON(ANIM_DATA)
DEF_ICON(BOIDS)
DEF_ICON(CAMERA_STEREO)
DEF_ICON(COMMUNITY)
DEF_ICON(FACE_MAPS)
DEF_ICON(FCURVE)
DEF_ICON(FILE)
DEF_ICON(GREASEPENCIL)
DEF_ICON(GREASEPENCIL_LAYER_GROUP)
DEF_ICON(GROUP_BONE)
DEF_ICON(GROUP_UVS)
DEF_ICON(GROUP_VCOL)
DEF_ICON(GROUP_VERTEX)
DEF_ICON(LIBRARY_DATA_BROKEN)
DEF_ICON(LIBRARY_DATA_DIRECT)
DEF_ICON(LIBRARY_DATA_OVERRIDE)
DEF_ICON(ORPHAN_DATA)
DEF_ICON(PACKAGE)
DEF_ICON(PRESET)
DEF_ICON(RENDER_ANIMATION)
DEF_ICON(RENDER_STILL)
DEF_ICON(RNA_ADD)
DEF_ICON(RNA)
DEF_ICON(STRANDS)
DEF_ICON(UGLYPACKAGE)

/* Careful, order is narrow to wide. */
/* INPUT */
DEF_ICON(MOUSE_LMB)
DEF_ICON(MOUSE_MMB)
DEF_ICON(MOUSE_RMB)
DEF_ICON(MOUSE_MMB_SCROLL)
DEF_ICON(MOUSE_LMB_2X)
DEF_ICON(MOUSE_MOVE)
DEF_ICON(MOUSE_LMB_DRAG)
DEF_ICON(MOUSE_MMB_DRAG)
DEF_ICON(MOUSE_RMB_DRAG)

/* DECORATE */
DEF_ICON(DECORATE_ANIMATE)
DEF_ICON(DECORATE_DRIVER)
DEF_ICON(DECORATE_KEYFRAME)
DEF_ICON(DECORATE_LIBRARY_OVERRIDE)
DEF_ICON(DECORATE_LINKED)
DEF_ICON(DECORATE_OVERRIDE)
DEF_ICON(DECORATE)

/* OUTLINER */
DEF_ICON_COLLECTION(OUTLINER_COLLECTION)
DEF_ICON_OBJECT_DATA(CURVES_DATA)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_ARMATURE)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_CAMERA)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_CURVE)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_CURVES)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_EMPTY)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_FONT)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_GP_LAYER)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_GREASEPENCIL)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_LATTICE)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_LIGHT)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_LIGHTPROBE)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_MESH)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_META)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_POINTCLOUD)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_SPEAKER)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_SURFACE)
DEF_ICON_OBJECT_DATA(OUTLINER_DATA_VOLUME)
DEF_ICON_OBJECT_DATA(POINTCLOUD_DATA)
DEF_ICON_OBJECT_DATA(POINTCLOUD_POINT)
DEF_ICON_OBJECT_DATA(VOLUME_DATA)
DEF_ICON_OBJECT(OUTLINER_OB_ARMATURE)
DEF_ICON_OBJECT(OUTLINER_OB_CAMERA)
DEF_ICON_OBJECT(OUTLINER_OB_CURVE)
DEF_ICON_OBJECT(OUTLINER_OB_CURVES)
DEF_ICON_OBJECT(OUTLINER_OB_EMPTY)
DEF_ICON_OBJECT(OUTLINER_OB_FONT)
DEF_ICON_OBJECT(OUTLINER_OB_FORCE_FIELD)
DEF_ICON_OBJECT(OUTLINER_OB_GREASEPENCIL)
DEF_ICON_OBJECT(OUTLINER_OB_GROUP_INSTANCE)
DEF_ICON_OBJECT(OUTLINER_OB_IMAGE)
DEF_ICON_OBJECT(OUTLINER_OB_LATTICE)
DEF_ICON_OBJECT(OUTLINER_OB_LIGHT)
DEF_ICON_OBJECT(OUTLINER_OB_LIGHTPROBE)
DEF_ICON_OBJECT(OUTLINER_OB_MESH)
DEF_ICON_OBJECT(OUTLINER_OB_META)
DEF_ICON_OBJECT(OUTLINER_OB_POINTCLOUD)
DEF_ICON_OBJECT(OUTLINER_OB_SPEAKER)
DEF_ICON_OBJECT(OUTLINER_OB_SURFACE)
DEF_ICON_OBJECT(OUTLINER_OB_VOLUME)
DEF_ICON(GP_MULTIFRAME_EDITING)
DEF_ICON(GP_ONLY_SELECTED)
DEF_ICON(GP_SELECT_BETWEEN_STROKES)
DEF_ICON(GP_SELECT_POINTS)
DEF_ICON(GP_SELECT_STROKES)
DEF_ICON(HOLDOUT_OFF)
DEF_ICON(HOLDOUT_ON)
DEF_ICON(MODIFIER_OFF)
DEF_ICON(MODIFIER_ON)
DEF_ICON(RESTRICT_COLOR_OFF)
DEF_ICON(RESTRICT_COLOR_ON)
DEF_ICON(RESTRICT_INSTANCED_OFF)
DEF_ICON(RESTRICT_INSTANCED_ON)

/* PRIMITIVES */
DEF_ICON_OBJECT_DATA(LIGHT_AREA)
DEF_ICON_OBJECT_DATA(LIGHT_HEMI)
DEF_ICON_OBJECT_DATA(LIGHT_POINT)
DEF_ICON_OBJECT_DATA(LIGHT_SPOT)
DEF_ICON_OBJECT_DATA(LIGHT_SUN)
DEF_ICON_OBJECT_DATA(LIGHTPROBE_PLANE)
DEF_ICON_OBJECT_DATA(LIGHTPROBE_SPHERE)
DEF_ICON_OBJECT_DATA(LIGHTPROBE_VOLUME)
DEF_ICON(COLOR_BLUE)
DEF_ICON(COLOR_GREEN)
DEF_ICON(COLOR_RED)
DEF_ICON(CONE)
DEF_ICON(CUBE)
DEF_ICON(CURVE_BEZCIRCLE)
DEF_ICON(CURVE_BEZCURVE)
DEF_ICON(CURVE_NCIRCLE)
DEF_ICON(CURVE_NCURVE)
DEF_ICON(CURVE_PATH)
DEF_ICON(CURVES)
DEF_ICON(EMPTY_ARROWS)
DEF_ICON(EMPTY_AXIS)
DEF_ICON(EMPTY_SINGLE_ARROW)
DEF_ICON(MESH_CAPSULE)
DEF_ICON(MESH_CIRCLE)
DEF_ICON(MESH_CONE)
DEF_ICON(MESH_CUBE)
DEF_ICON(MESH_CYLINDER)
DEF_ICON(MESH_GRID)
DEF_ICON(MESH_ICOSPHERE)
DEF_ICON(MESH_MONKEY)
DEF_ICON(MESH_PLANE)
DEF_ICON(MESH_TORUS)
DEF_ICON(MESH_UVSPHERE)
DEF_ICON(META_BALL)
DEF_ICON(META_CAPSULE)
DEF_ICON(META_CUBE)
DEF_ICON(META_ELLIPSOID)
DEF_ICON(META_PLANE)
DEF_ICON(MONKEY)
DEF_ICON(SPHERE)
DEF_ICON(STROKE)
DEF_ICON(SURFACE_NCIRCLE)
DEF_ICON(SURFACE_NCURVE)
DEF_ICON(SURFACE_NCYLINDER)
DEF_ICON(SURFACE_NSPHERE)
DEF_ICON(SURFACE_NSURFACE)
DEF_ICON(SURFACE_NTORUS)
DEF_ICON(TRIA_DOWN_BAR)
DEF_ICON(TRIA_LEFT_BAR)
DEF_ICON(TRIA_RIGHT_BAR)
DEF_ICON(TRIA_UP_BAR)

/* EMPTY */
DEF_ICON(AREA_DOCK)
DEF_ICON(AREA_JOIN_DOWN)
DEF_ICON(AREA_JOIN_LEFT)
DEF_ICON(AREA_JOIN_UP)
DEF_ICON(AREA_JOIN)
DEF_ICON(AREA_SWAP)
DEF_ICON(FORCE_BOID)
DEF_ICON(FORCE_CHARGE)
DEF_ICON(FORCE_CURVE)
DEF_ICON(FORCE_DRAG)
DEF_ICON(FORCE_FLUIDFLOW)
DEF_ICON(FORCE_FORCE)
DEF_ICON(FORCE_HARMONIC)
DEF_ICON(FORCE_LENNARDJONES)
DEF_ICON(FORCE_MAGNETIC)
DEF_ICON(FORCE_TEXTURE)
DEF_ICON(FORCE_TURBULENCE)
DEF_ICON(FORCE_VORTEX)
DEF_ICON(FORCE_WIND)
DEF_ICON(IMAGE_BACKGROUND)
DEF_ICON(IMAGE_PLANE)
DEF_ICON(IMAGE_REFERENCE)
DEF_ICON(RIGID_BODY_CONSTRAINT)
DEF_ICON(RIGID_BODY)
DEF_ICON(SPLIT_HORIZONTAL)
DEF_ICON(SPLIT_VERTICAL)

/* ALIGNMENT */
DEF_ICON(ANCHOR_BOTTOM)
DEF_ICON(ANCHOR_CENTER)
DEF_ICON(ANCHOR_LEFT)
DEF_ICON(ANCHOR_RIGHT)
DEF_ICON(ANCHOR_TOP)
DEF_ICON(NODE_CORNER)
DEF_ICON(NODE_INSERT_OFF)
DEF_ICON(NODE_INSERT_ON)
DEF_ICON(NODE_SIDE)
DEF_ICON(NODE_TOP)

/* SELECTION */
DEF_ICON(SELECT_EXTEND)
DEF_ICON(SELECT_SET)
DEF_ICON(SELECT_SUBTRACT)

/* TEXT */
DEF_ICON(ALIGN_BOTTOM)
DEF_ICON(ALIGN_CENTER)
DEF_ICON(ALIGN_FLUSH)
DEF_ICON(ALIGN_JUSTIFY)
DEF_ICON(ALIGN_LEFT)
DEF_ICON(ALIGN_MIDDLE)
DEF_ICON(ALIGN_RIGHT)
DEF_ICON(ALIGN_TOP)
DEF_ICON(BOLD)
DEF_ICON(ITALIC)
DEF_ICON(LINENUMBERS_OFF)
DEF_ICON(LINENUMBERS_ON)
DEF_ICON(SCRIPTPLUGINS)
DEF_ICON(SMALL_CAPS)
DEF_ICON(SYNTAX_OFF)
DEF_ICON(SYNTAX_ON)
DEF_ICON(UNDERLINE)
DEF_ICON(WORDWRAP_OFF)
DEF_ICON(WORDWRAP_ON)

/* CONSTRAINTS */
DEF_ICON_MODIFIER(CON_ACTION)
DEF_ICON_MODIFIER(CON_ARMATURE)
DEF_ICON_MODIFIER(CON_CAMERASOLVER)
DEF_ICON_MODIFIER(CON_CHILDOF)
DEF_ICON_MODIFIER(CON_CLAMPTO)
DEF_ICON_MODIFIER(CON_DISTLIMIT)
DEF_ICON_MODIFIER(CON_FLOOR)
DEF_ICON_MODIFIER(CON_FOLLOWPATH)
DEF_ICON_MODIFIER(CON_FOLLOWTRACK)
DEF_ICON_MODIFIER(CON_KINEMATIC)
DEF_ICON_MODIFIER(CON_LOCKTRACK)
DEF_ICON_MODIFIER(CON_LOCLIKE)
DEF_ICON_MODIFIER(CON_LOCLIMIT)
DEF_ICON_MODIFIER(CON_OBJECTSOLVER)
DEF_ICON_MODIFIER(CON_PIVOT)
DEF_ICON_MODIFIER(CON_ROTLIKE)
DEF_ICON_MODIFIER(CON_ROTLIMIT)
DEF_ICON_MODIFIER(CON_SAMEVOL)
DEF_ICON_MODIFIER(CON_SHRINKWRAP)
DEF_ICON_MODIFIER(CON_SIZELIKE)
DEF_ICON_MODIFIER(CON_SIZELIMIT)
DEF_ICON_MODIFIER(CON_SPLINEIK)
DEF_ICON_MODIFIER(CON_STRETCHTO)
DEF_ICON_MODIFIER(CON_TRACKTO)
DEF_ICON_MODIFIER(CON_TRANSFORM_CACHE)
DEF_ICON_MODIFIER(CON_TRANSFORM)
DEF_ICON_MODIFIER(CON_TRANSLIKE)

/* MODIFIERS */
DEF_ICON_MODIFIER(HOOK)
DEF_ICON_MODIFIER(MOD_ARMATURE)
DEF_ICON_MODIFIER(MOD_ARRAY)
DEF_ICON_MODIFIER(MOD_BEVEL)
DEF_ICON_MODIFIER(MOD_BOOLEAN)
DEF_ICON_MODIFIER(MOD_BUILD)
DEF_ICON_MODIFIER(MOD_CAST)
DEF_ICON_MODIFIER(MOD_CLOTH)
DEF_ICON_MODIFIER(MOD_CURVE)
DEF_ICON_MODIFIER(MOD_DASH)
DEF_ICON_MODIFIER(MOD_DATA_TRANSFER)
DEF_ICON_MODIFIER(MOD_DECIM)
DEF_ICON_MODIFIER(MOD_DISPLACE)
DEF_ICON_MODIFIER(MOD_DYNAMICPAINT)
DEF_ICON_MODIFIER(MOD_EDGESPLIT)
DEF_ICON_MODIFIER(MOD_ENVELOPE)
DEF_ICON_MODIFIER(MOD_EXPLODE)
DEF_ICON_MODIFIER(MOD_FLUID)
DEF_ICON_MODIFIER(MOD_FLUIDSIM)
DEF_ICON_MODIFIER(MOD_HUE_SATURATION)
DEF_ICON_MODIFIER(MOD_INSTANCE)
DEF_ICON_MODIFIER(MOD_LATTICE)
DEF_ICON_MODIFIER(MOD_LENGTH)
DEF_ICON_MODIFIER(MOD_LINEART)
DEF_ICON_MODIFIER(MOD_MASK)
DEF_ICON_MODIFIER(MOD_MESHDEFORM)
DEF_ICON_MODIFIER(MOD_MIRROR)
DEF_ICON_MODIFIER(MOD_MULTIRES)
DEF_ICON_MODIFIER(MOD_NOISE)
DEF_ICON_MODIFIER(MOD_NORMALEDIT)
DEF_ICON_MODIFIER(MOD_OCEAN)
DEF_ICON_MODIFIER(MOD_OFFSET)
DEF_ICON_MODIFIER(MOD_OPACITY)
DEF_ICON_MODIFIER(MOD_OUTLINE)
DEF_ICON_MODIFIER(MOD_PARTICLE_INSTANCE)
DEF_ICON_MODIFIER(MOD_PARTICLES)
DEF_ICON_MODIFIER(MOD_PHYSICS)
DEF_ICON_MODIFIER(MOD_REMESH)
DEF_ICON_MODIFIER(MOD_SCREW)
DEF_ICON_MODIFIER(MOD_SHRINKWRAP)
DEF_ICON_MODIFIER(MOD_SIMPLEDEFORM)
DEF_ICON_MODIFIER(MOD_SIMPLIFY)
DEF_ICON_MODIFIER(MOD_SKIN)
DEF_ICON_MODIFIER(MOD_SMOOTH)
DEF_ICON_MODIFIER(MOD_SOFT)
DEF_ICON_MODIFIER(MOD_SOLIDIFY)
DEF_ICON_MODIFIER(MOD_SUBSURF)
DEF_ICON_MODIFIER(MOD_THICKNESS)
DEF_ICON_MODIFIER(MOD_TIME)
DEF_ICON_MODIFIER(MOD_TINT)
DEF_ICON_MODIFIER(MOD_TRIANGULATE)
DEF_ICON_MODIFIER(MOD_UVPROJECT)
DEF_ICON_MODIFIER(MOD_VERTEX_WEIGHT)
DEF_ICON_MODIFIER(MOD_WARP)
DEF_ICON_MODIFIER(MOD_WAVE)
DEF_ICON_MODIFIER(MOD_WIREFRAME)
DEF_ICON_MODIFIER(MODIFIER_DATA)

/* ANIMATION */
DEF_ICON(ACTION_SLOT)
DEF_ICON(ACTION_TWEAK)
DEF_ICON(DRIVER)
DEF_ICON(FF)
DEF_ICON(FRAME_NEXT)
DEF_ICON(FRAME_PREV)
DEF_ICON(HANDLE_ALIGNED)
DEF_ICON(HANDLE_AUTO)
DEF_ICON(HANDLE_AUTOCLAMPED)
DEF_ICON(HANDLE_FREE)
DEF_ICON(HANDLE_VECTOR)
DEF_ICON(IPO_BACK)
DEF_ICON(IPO_BEZIER)
DEF_ICON(IPO_BOUNCE)
DEF_ICON(IPO_CIRC)
DEF_ICON(IPO_CONSTANT)
DEF_ICON(IPO_CUBIC)
DEF_ICON(IPO_EASE_IN_OUT)
DEF_ICON(IPO_EASE_IN)
DEF_ICON(IPO_EASE_OUT)
DEF_ICON(IPO_ELASTIC)
DEF_ICON(IPO_EXPO)
DEF_ICON(IPO_LINEAR)
DEF_ICON(IPO_QUAD)
DEF_ICON(IPO_QUART)
DEF_ICON(IPO_QUINT)
DEF_ICON(IPO_SINE)
DEF_ICON(KEY_DEHLT)
DEF_ICON(KEY_HLT)
DEF_ICON(KEYFRAME_HLT)
DEF_ICON(KEYFRAME)
DEF_ICON(KEYINGSET)
DEF_ICON(MARKER_HLT)
DEF_ICON(MARKER)
DEF_ICON(MUTE_IPO_OFF)
DEF_ICON(MUTE_IPO_ON)
DEF_ICON(NEXT_KEYFRAME)
DEF_ICON(NLA_PUSHDOWN)
DEF_ICON(NORMALIZE_FCURVES)
DEF_ICON(ORIENTATION_PARENT)
DEF_ICON(PAUSE)
DEF_ICON(PLAY_REVERSE)
DEF_ICON(PLAY_SOUND)
DEF_ICON(PLAY)
DEF_ICON(PMARKER_ACT)
DEF_ICON(PMARKER_SEL)
DEF_ICON(PMARKER)
DEF_ICON(PREV_KEYFRAME)
DEF_ICON(PREVIEW_RANGE)
DEF_ICON(REC)
DEF_ICON(REW)
DEF_ICON(SOLO_OFF)
DEF_ICON(SOLO_ON)

/* EDITING */
DEF_ICON(CENTER_ONLY)
DEF_ICON(CURSOR)
DEF_ICON(EDGESEL)
DEF_ICON(FACE_CORNER)
DEF_ICON(FACESEL)
DEF_ICON(INVERSESQUARECURVE)
DEF_ICON(LINCURVE)
DEF_ICON(NOCURVE)
DEF_ICON(PARTICLE_PATH)
DEF_ICON(PARTICLE_POINT)
DEF_ICON(PARTICLE_TIP)
DEF_ICON(PIVOT_ACTIVE)
DEF_ICON(PIVOT_BOUNDBOX)
DEF_ICON(PIVOT_CURSOR)
DEF_ICON(PIVOT_INDIVIDUAL)
DEF_ICON(PIVOT_MEDIAN)
DEF_ICON(PROP_CON)
DEF_ICON(PROP_OFF)
DEF_ICON(PROP_ON)
DEF_ICON(PROP_PROJECTED)
DEF_ICON(RNDCURVE)
DEF_ICON(ROOTCURVE)
DEF_ICON(SHARPCURVE)
DEF_ICON(SMOOTHCURVE)
DEF_ICON(SPHERECURVE)
DEF_ICON(VERTEXSEL)

/* SNAPPING */
DEF_ICON(SNAP_EDGE)
DEF_ICON(SNAP_FACE_CENTER)
DEF_ICON(SNAP_FACE_NEAREST)
DEF_ICON(SNAP_FACE)
DEF_ICON(SNAP_GRID)
DEF_ICON(SNAP_INCREMENT)
DEF_ICON(SNAP_MIDPOINT)
DEF_ICON(SNAP_NORMAL)
DEF_ICON(SNAP_PEEL_OBJECT)
DEF_ICON(SNAP_PERPENDICULAR)
DEF_ICON(SNAP_VERTEX)
DEF_ICON(SNAP_VOLUME)
DEF_ICON(STICKY_UVS_DISABLE)
DEF_ICON(STICKY_UVS_LOC)
DEF_ICON(STICKY_UVS_VERT)

/* ORIENTATION */
DEF_ICON(ORIENTATION_GIMBAL)
DEF_ICON(ORIENTATION_GLOBAL)
DEF_ICON(ORIENTATION_LOCAL)
DEF_ICON(ORIENTATION_NORMAL)
DEF_ICON(ORIENTATION_VIEW)

/* EDITING */
DEF_ICON(COPYDOWN)
DEF_ICON(FIXED_SIZE)
DEF_ICON(GIZMO)
DEF_ICON(GP_CAPS_FLAT)
DEF_ICON(GP_CAPS_ROUND)
DEF_ICON(NORMALS_FACE)
DEF_ICON(NORMALS_VERTEX_FACE)
DEF_ICON(NORMALS_VERTEX)
DEF_ICON(OBJECT_ORIGIN)
DEF_ICON(ORIENTATION_CURSOR)
DEF_ICON(PASTEDOWN)
DEF_ICON(PASTEFLIPDOWN)
DEF_ICON(PASTEFLIPUP)
DEF_ICON(TRANSFORM_ORIGINS)
DEF_ICON(UV_EDGESEL)
DEF_ICON(UV_FACESEL)
DEF_ICON(UV_ISLANDSEL)
DEF_ICON(UV_SYNC_SELECT)
DEF_ICON(UV_VERTEXSEL)

/* 3D VIEW */
DEF_ICON(AXIS_FRONT)
DEF_ICON(AXIS_SIDE)
DEF_ICON(AXIS_TOP)
DEF_ICON(GRID)
DEF_ICON(LAYER_ACTIVE)
DEF_ICON(LAYER_USED)
DEF_ICON(LOCKVIEW_OFF)
DEF_ICON(LOCKVIEW_ON)
DEF_ICON(OVERLAY)
DEF_ICON(SHADING_BBOX)
DEF_ICON(SHADING_RENDERED)
DEF_ICON(SHADING_SOLID)
DEF_ICON(SHADING_TEXTURE)
DEF_ICON(SHADING_WIRE)
DEF_ICON(XRAY)

/* VIEW */
DEF_ICON(VIEW_CAMERA_UNSELECTED)
DEF_ICON(VIEW_CAMERA)
DEF_ICON(VIEW_LOCKED)
DEF_ICON(VIEW_ORTHO)
DEF_ICON(VIEW_PAN)
DEF_ICON(VIEW_PERSPECTIVE)
DEF_ICON(VIEW_UNLOCKED)
DEF_ICON(VIEW_ZOOM)

/* FILE */
DEF_ICON_COLOR(FILE_ALIAS)
DEF_ICON_FOLDER(FILE_FOLDER)
DEF_ICON_FOLDER(FOLDER_REDIRECT)
DEF_ICON(APPEND_BLEND)
DEF_ICON(BACK)
DEF_ICON(BOOKMARKS)
DEF_ICON(CURRENT_FILE)
DEF_ICON(DESKTOP)
DEF_ICON(DISC)
DEF_ICON(DISK_DRIVE)
DEF_ICON(DOCUMENTS)
DEF_ICON(EXPORT)
DEF_ICON(EXTERNAL_DRIVE)
DEF_ICON(FILE_3D)
DEF_ICON(FILE_ARCHIVE)
DEF_ICON(FILE_BACKUP)
DEF_ICON(FILE_BLANK)
DEF_ICON(FILE_BLEND)
DEF_ICON(FILE_CACHE)
DEF_ICON(FILE_FONT)
DEF_ICON(FILE_HIDDEN)
DEF_ICON(FILE_IMAGE)
DEF_ICON(FILE_MOVIE)
DEF_ICON(FILE_PARENT)
DEF_ICON(FILE_REFRESH)
DEF_ICON(FILE_SCRIPT)
DEF_ICON(FILE_SOUND)
DEF_ICON(FILE_TEXT)
DEF_ICON(FILE_VOLUME)
DEF_ICON(FILTER)
DEF_ICON(FONTPREVIEW)
DEF_ICON(FORWARD)
DEF_ICON(HOME)
DEF_ICON(IMGDISPLAY)
DEF_ICON(IMPORT)
DEF_ICON(LINK_BLEND)
DEF_ICON(LONGDISPLAY)
DEF_ICON(LOOP_BACK)
DEF_ICON(LOOP_FORWARDS)
DEF_ICON(NETWORK_DRIVE)
DEF_ICON(NEWFOLDER)
DEF_ICON(PREVIEW_LOADING)
DEF_ICON(SETTINGS)
DEF_ICON(SHORTDISPLAY)
DEF_ICON(SORT_ASC)
DEF_ICON(SORT_DESC)
DEF_ICON(SORTALPHA)
DEF_ICON(SORTBYEXT)
DEF_ICON(SORTSIZE)
DEF_ICON(SORTTIME)
DEF_ICON(SYSTEM)
DEF_ICON(TAG)
DEF_ICON(TEMP)

/* SHADING */
DEF_ICON(ALIASED)
DEF_ICON(ANTIALIASED)
DEF_ICON(MAT_SPHERE_SKY)
DEF_ICON(MATCLOTH)
DEF_ICON(MATCUBE)
DEF_ICON(MATFLUID)
DEF_ICON(MATPLANE)
DEF_ICON(MATSHADERBALL)
DEF_ICON(MATSPHERE)

/* SEQUENCER */
DEF_ICON(SEQ_CHROMA_SCOPE)
DEF_ICON(SEQ_HISTOGRAM)
DEF_ICON(SEQ_LUMA_WAVEFORM)
DEF_ICON(SEQ_PREVIEW)
DEF_ICON(SEQ_SEQUENCER)
DEF_ICON(SEQ_SPLITVIEW)
DEF_ICON(SEQ_STRIP_DUPLICATE)
DEF_ICON(SEQ_STRIP_META)

/* IMAGE EDITOR */
DEF_ICON(IMAGE_ALPHA)
DEF_ICON(IMAGE_RGB_ALPHA)
DEF_ICON(IMAGE_RGB) /* XXX CHANGE TO STRAIGHT ALPHA, Z ETC */
DEF_ICON(IMAGE_ZDEPTH)

/* For larger use, mostly used for the file browser */
/* LARGE */
DEF_ICON(BLENDER_LOGO_LARGE)
DEF_ICON(CANCEL_LARGE)
DEF_ICON(DISC_LARGE)
DEF_ICON(DISK_DRIVE_LARGE)
DEF_ICON(EXTERNAL_DRIVE_LARGE)
DEF_ICON(FILE_FOLDER_LARGE)
DEF_ICON(FILE_LARGE)
DEF_ICON(FILE_PARENT_LARGE)
DEF_ICON(INFO_LARGE)
DEF_ICON(NETWORK_DRIVE_LARGE)
DEF_ICON(QUESTION_LARGE)
DEF_ICON(WARNING_LARGE)

/* The following are used when creating the Event Icons. */
/* STATUSBAR */
DEF_ICON(KEY_BACKSPACE_FILLED)
DEF_ICON(KEY_BACKSPACE)
DEF_ICON(KEY_COMMAND_FILLED)
DEF_ICON(KEY_COMMAND)
DEF_ICON(KEY_CONTROL_FILLED)
DEF_ICON(KEY_CONTROL)
DEF_ICON(KEY_EMPTY1_FILLED)
DEF_ICON(KEY_EMPTY1)
DEF_ICON(KEY_EMPTY2_FILLED)
DEF_ICON(KEY_EMPTY2)
DEF_ICON(KEY_EMPTY3_FILLED)
DEF_ICON(KEY_EMPTY3)
DEF_ICON(KEY_MENU_FILLED)
DEF_ICON(KEY_MENU)
DEF_ICON(KEY_OPTION_FILLED)
DEF_ICON(KEY_OPTION)
DEF_ICON(KEY_RETURN_FILLED)
DEF_ICON(KEY_RETURN)
DEF_ICON(KEY_RING_FILLED)
DEF_ICON(KEY_RING)
DEF_ICON(KEY_SHIFT_FILLED)
DEF_ICON(KEY_SHIFT)
DEF_ICON(KEY_TAB_FILLED)
DEF_ICON(KEY_TAB)
DEF_ICON(KEY_WINDOWS_FILLED)
DEF_ICON(KEY_WINDOWS)
DEF_ICON(GESTURE_PAN)
DEF_ICON(GESTURE_ROTATE)
DEF_ICON(GESTURE_ZOOM)

/* INTERNET */
DEF_ICON_FUND(FUND)
DEF_ICON(HEART)
DEF_ICON(INTERNET_OFFLINE)
DEF_ICON(INTERNET)
DEF_ICON(USER)

/* OTHER */
DEF_ICON(EXPERIMENTAL)
DEF_ICON(MEMORY)

/* The items above are initiated sequentially while the ones that
 * follow are initiated individually. Therefore this item marks
 * the boundary. Add regular SVG icons above this one. */

DEF_ICON_BLANK(LAST_SVG_ITEM)

/* Vector icons. */
DEF_ICON_VECTOR(RGB_RED)
DEF_ICON_VECTOR(RGB_GREEN)
DEF_ICON_VECTOR(RGB_BLUE)

DEF_ICON_VECTOR(KEYTYPE_KEYFRAME_VEC)
DEF_ICON_VECTOR(KEYTYPE_BREAKDOWN_VEC)
DEF_ICON_VECTOR(KEYTYPE_EXTREME_VEC)
DEF_ICON_VECTOR(KEYTYPE_JITTER_VEC)
DEF_ICON_VECTOR(KEYTYPE_MOVING_HOLD_VEC)
DEF_ICON_VECTOR(KEYTYPE_GENERATED_VEC)

DEF_ICON_VECTOR(HANDLETYPE_FREE_VEC)
DEF_ICON_VECTOR(HANDLETYPE_ALIGNED_VEC)
DEF_ICON_VECTOR(HANDLETYPE_VECTOR_VEC)
DEF_ICON_VECTOR(HANDLETYPE_AUTO_VEC)
DEF_ICON_VECTOR(HANDLETYPE_AUTO_CLAMP_VEC)

DEF_ICON_VECTOR(COLORSET_01_VEC)
DEF_ICON_VECTOR(COLORSET_02_VEC)
DEF_ICON_VECTOR(COLORSET_03_VEC)
DEF_ICON_VECTOR(COLORSET_04_VEC)
DEF_ICON_VECTOR(COLORSET_05_VEC)
DEF_ICON_VECTOR(COLORSET_06_VEC)
DEF_ICON_VECTOR(COLORSET_07_VEC)
DEF_ICON_VECTOR(COLORSET_08_VEC)
DEF_ICON_VECTOR(COLORSET_09_VEC)
DEF_ICON_VECTOR(COLORSET_10_VEC)
DEF_ICON_VECTOR(COLORSET_11_VEC)
DEF_ICON_VECTOR(COLORSET_12_VEC)
DEF_ICON_VECTOR(COLORSET_13_VEC)
DEF_ICON_VECTOR(COLORSET_14_VEC)
DEF_ICON_VECTOR(COLORSET_15_VEC)
DEF_ICON_VECTOR(COLORSET_16_VEC)
DEF_ICON_VECTOR(COLORSET_17_VEC)
DEF_ICON_VECTOR(COLORSET_18_VEC)
DEF_ICON_VECTOR(COLORSET_19_VEC)
DEF_ICON_VECTOR(COLORSET_20_VEC)

DEF_ICON_VECTOR(COLLECTION_COLOR_01)
DEF_ICON_VECTOR(COLLECTION_COLOR_02)
DEF_ICON_VECTOR(COLLECTION_COLOR_03)
DEF_ICON_VECTOR(COLLECTION_COLOR_04)
DEF_ICON_VECTOR(COLLECTION_COLOR_05)
DEF_ICON_VECTOR(COLLECTION_COLOR_06)
DEF_ICON_VECTOR(COLLECTION_COLOR_07)
DEF_ICON_VECTOR(COLLECTION_COLOR_08)

DEF_ICON_VECTOR(STRIP_COLOR_01)
DEF_ICON_VECTOR(STRIP_COLOR_02)
DEF_ICON_VECTOR(STRIP_COLOR_03)
DEF_ICON_VECTOR(STRIP_COLOR_04)
DEF_ICON_VECTOR(STRIP_COLOR_05)
DEF_ICON_VECTOR(STRIP_COLOR_06)
DEF_ICON_VECTOR(STRIP_COLOR_07)
DEF_ICON_VECTOR(STRIP_COLOR_08)
DEF_ICON_VECTOR(STRIP_COLOR_09)

DEF_ICON_VECTOR(LIBRARY_DATA_INDIRECT)
DEF_ICON_VECTOR(LIBRARY_DATA_OVERRIDE_NONEDITABLE)

DEF_ICON_VECTOR(LAYERGROUP_COLOR_01)
DEF_ICON_VECTOR(LAYERGROUP_COLOR_02)
DEF_ICON_VECTOR(LAYERGROUP_COLOR_03)
DEF_ICON_VECTOR(LAYERGROUP_COLOR_04)
DEF_ICON_VECTOR(LAYERGROUP_COLOR_05)
DEF_ICON_VECTOR(LAYERGROUP_COLOR_06)
DEF_ICON_VECTOR(LAYERGROUP_COLOR_07)
DEF_ICON_VECTOR(LAYERGROUP_COLOR_08)

/* Events. */
DEF_ICON_COLOR(EVENT_A)
DEF_ICON_COLOR(EVENT_B)
DEF_ICON_COLOR(EVENT_C)
DEF_ICON_COLOR(EVENT_D)
DEF_ICON_COLOR(EVENT_E)
DEF_ICON_COLOR(EVENT_F)
DEF_ICON_COLOR(EVENT_G)
DEF_ICON_COLOR(EVENT_H)
DEF_ICON_COLOR(EVENT_I)
DEF_ICON_COLOR(EVENT_J)
DEF_ICON_COLOR(EVENT_K)
DEF_ICON_COLOR(EVENT_L)
DEF_ICON_COLOR(EVENT_M)
DEF_ICON_COLOR(EVENT_N)
DEF_ICON_COLOR(EVENT_O)
DEF_ICON_COLOR(EVENT_P)
DEF_ICON_COLOR(EVENT_Q)
DEF_ICON_COLOR(EVENT_R)
DEF_ICON_COLOR(EVENT_S)
DEF_ICON_COLOR(EVENT_T)
DEF_ICON_COLOR(EVENT_U)
DEF_ICON_COLOR(EVENT_V)
DEF_ICON_COLOR(EVENT_W)
DEF_ICON_COLOR(EVENT_X)
DEF_ICON_COLOR(EVENT_Y)
DEF_ICON_COLOR(EVENT_Z)
DEF_ICON_COLOR(EVENT_SHIFT)
DEF_ICON_COLOR(EVENT_CTRL)
DEF_ICON_COLOR(EVENT_ALT)
DEF_ICON_COLOR(EVENT_OS)
DEF_ICON_COLOR(EVENT_HYPER)

DEF_ICON_COLOR(EVENT_F1)
DEF_ICON_COLOR(EVENT_F2)
DEF_ICON_COLOR(EVENT_F3)
DEF_ICON_COLOR(EVENT_F4)
DEF_ICON_COLOR(EVENT_F5)
DEF_ICON_COLOR(EVENT_F6)
DEF_ICON_COLOR(EVENT_F7)
DEF_ICON_COLOR(EVENT_F8)
DEF_ICON_COLOR(EVENT_F9)
DEF_ICON_COLOR(EVENT_F10)
DEF_ICON_COLOR(EVENT_F11)
DEF_ICON_COLOR(EVENT_F12)
DEF_ICON_COLOR(EVENT_F13)
DEF_ICON_COLOR(EVENT_F14)
DEF_ICON_COLOR(EVENT_F15)
DEF_ICON_COLOR(EVENT_F16)
DEF_ICON_COLOR(EVENT_F17)
DEF_ICON_COLOR(EVENT_F18)
DEF_ICON_COLOR(EVENT_F19)
DEF_ICON_COLOR(EVENT_F20)
DEF_ICON_COLOR(EVENT_F21)
DEF_ICON_COLOR(EVENT_F22)
DEF_ICON_COLOR(EVENT_F23)
DEF_ICON_COLOR(EVENT_F24)

DEF_ICON_COLOR(EVENT_ESC)
DEF_ICON_COLOR(EVENT_TAB)
DEF_ICON_COLOR(EVENT_PAGEUP)
DEF_ICON_COLOR(EVENT_PAGEDOWN)
DEF_ICON_COLOR(EVENT_RETURN)
DEF_ICON_COLOR(EVENT_SPACEKEY)

DEF_ICON_COLOR(EVENT_ZEROKEY)
DEF_ICON_COLOR(EVENT_ONEKEY)
DEF_ICON_COLOR(EVENT_TWOKEY)
DEF_ICON_COLOR(EVENT_THREEKEY)
DEF_ICON_COLOR(EVENT_FOURKEY)
DEF_ICON_COLOR(EVENT_FIVEKEY)
DEF_ICON_COLOR(EVENT_SIXKEY)
DEF_ICON_COLOR(EVENT_SEVENKEY)
DEF_ICON_COLOR(EVENT_EIGHTKEY)
DEF_ICON_COLOR(EVENT_NINEKEY)

DEF_ICON_COLOR(EVENT_PAD0)
DEF_ICON_COLOR(EVENT_PAD1)
DEF_ICON_COLOR(EVENT_PAD2)
DEF_ICON_COLOR(EVENT_PAD3)
DEF_ICON_COLOR(EVENT_PAD4)
DEF_ICON_COLOR(EVENT_PAD5)
DEF_ICON_COLOR(EVENT_PAD6)
DEF_ICON_COLOR(EVENT_PAD7)
DEF_ICON_COLOR(EVENT_PAD8)
DEF_ICON_COLOR(EVENT_PAD9)
DEF_ICON_COLOR(EVENT_PADASTER)
DEF_ICON_COLOR(EVENT_PADSLASH)
DEF_ICON_COLOR(EVENT_PADMINUS)
DEF_ICON_COLOR(EVENT_PADENTER)
DEF_ICON_COLOR(EVENT_PADPLUS)
DEF_ICON_COLOR(EVENT_PADPERIOD)

DEF_ICON_COLOR(EVENT_MOUSE_4)
DEF_ICON_COLOR(EVENT_MOUSE_5)
DEF_ICON_COLOR(EVENT_MOUSE_6)
DEF_ICON_COLOR(EVENT_MOUSE_7)
DEF_ICON_COLOR(EVENT_TABLET_STYLUS)
DEF_ICON_COLOR(EVENT_TABLET_ERASER)
DEF_ICON_COLOR(EVENT_LEFT_ARROW)
DEF_ICON_COLOR(EVENT_DOWN_ARROW)
DEF_ICON_COLOR(EVENT_RIGHT_ARROW)
DEF_ICON_COLOR(EVENT_UP_ARROW)
DEF_ICON_COLOR(EVENT_PAUSE)
DEF_ICON_COLOR(EVENT_INSERT)
DEF_ICON_COLOR(EVENT_HOME)
DEF_ICON_COLOR(EVENT_END)
DEF_ICON_COLOR(EVENT_UNKNOWN)
DEF_ICON_COLOR(EVENT_GRLESS)
DEF_ICON_COLOR(EVENT_MEDIAPLAY)
DEF_ICON_COLOR(EVENT_MEDIASTOP)
DEF_ICON_COLOR(EVENT_MEDIAFIRST)
DEF_ICON_COLOR(EVENT_MEDIALAST)
DEF_ICON_COLOR(EVENT_APP)
DEF_ICON_COLOR(EVENT_CAPSLOCK)
DEF_ICON_COLOR(EVENT_BACKSPACE)
DEF_ICON_COLOR(EVENT_DEL)
DEF_ICON_COLOR(EVENT_SEMICOLON)
DEF_ICON_COLOR(EVENT_PERIOD)
DEF_ICON_COLOR(EVENT_COMMA)
DEF_ICON_COLOR(EVENT_QUOTE)
DEF_ICON_COLOR(EVENT_ACCENTGRAVE)
DEF_ICON_COLOR(EVENT_MINUS)
DEF_ICON_COLOR(EVENT_PLUS)
DEF_ICON_COLOR(EVENT_SLASH)
DEF_ICON_COLOR(EVENT_BACKSLASH)
DEF_ICON_COLOR(EVENT_EQUAL)
DEF_ICON_COLOR(EVENT_LEFTBRACKET)
DEF_ICON_COLOR(EVENT_RIGHTBRACKET)

DEF_ICON_COLOR(EVENT_PAD_PAN)
DEF_ICON_COLOR(EVENT_PAD_ROTATE)
DEF_ICON_COLOR(EVENT_PAD_ZOOM)

DEF_ICON_COLOR(EVENT_NDOF_BUTTON_V1)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_V2)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_V3)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_SAVE_V1)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_SAVE_V2)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_SAVE_V3)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_1)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_2)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_3)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_4)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_5)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_6)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_7)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_8)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_9)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_10)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_11)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_12)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_MENU)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_FIT)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_TOP)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_BOTTOM)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_LEFT)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_RIGHT)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_FRONT)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_BACK)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_ISO1)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_ISO2)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_ROLL_CW)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_ROLL_CCW)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_SPIN_CW)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_SPIN_CCW)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_TILT_CW)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_TILT_CCW)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_ROTATE)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_PANZOOM)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_DOMINANT)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_PLUS)
DEF_ICON_COLOR(EVENT_NDOF_BUTTON_MINUS)

/* Node Sockets */
DEF_ICON_VECTOR(NODE_SOCKET_FLOAT)
DEF_ICON_VECTOR(NODE_SOCKET_VECTOR)
DEF_ICON_VECTOR(NODE_SOCKET_RGBA)
DEF_ICON_VECTOR(NODE_SOCKET_SHADER)
DEF_ICON_VECTOR(NODE_SOCKET_BOOLEAN)
DEF_ICON_VECTOR(NODE_SOCKET_INT)
DEF_ICON_VECTOR(NODE_SOCKET_STRING)
DEF_ICON_VECTOR(NODE_SOCKET_OBJECT)
DEF_ICON_VECTOR(NODE_SOCKET_IMAGE)
DEF_ICON_VECTOR(NODE_SOCKET_GEOMETRY)
DEF_ICON_VECTOR(NODE_SOCKET_COLLECTION)
DEF_ICON_VECTOR(NODE_SOCKET_TEXTURE)
DEF_ICON_VECTOR(NODE_SOCKET_MATERIAL)
DEF_ICON_VECTOR(NODE_SOCKET_ROTATION)
DEF_ICON_VECTOR(NODE_SOCKET_MENU)
DEF_ICON_VECTOR(NODE_SOCKET_MATRIX)
DEF_ICON_VECTOR(NODE_SOCKET_BUNDLE)
DEF_ICON_VECTOR(NODE_SOCKET_CLOSURE)

/* add as needed. */

/* Undefine all types. */

#undef DEF_ICON
#undef DEF_ICON_ERROR
#undef DEF_ICON_SCENE
#undef DEF_ICON_COLLECTION
#undef DEF_ICON_OBJECT
#undef DEF_ICON_OBJECT_DATA
#undef DEF_ICON_MODIFIER
#undef DEF_ICON_SHADING
#undef DEF_ICON_FOLDER
#undef DEF_ICON_VECTOR
#undef DEF_ICON_COLOR
#undef DEF_ICON_FUND
#undef DEF_ICON_BLANK
