/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.net.URI;
import java.util.List;
import org.dita.dost.util.Constants;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class ResourceInsertFilter
extends AbstractXMLFilter {
    private boolean added = false;
    private List<URI> resources;

    public void setResources(List<URI> resources) {
        this.resources = resources;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(uri, localName, qName, atts);
        if (!this.added) {
            for (URI resource : this.resources) {
                this.logger.info("add resource " + String.valueOf(resource));
                super.startElement("", Constants.MAP_TOPICREF.localName, Constants.MAP_TOPICREF.localName, this.getAttributes().add("href", this.currentFile.resolve(".").relativize(resource).toString()).add("processing-role", "resource-only").build());
                super.endElement("", Constants.MAP_TOPICREF.localName, Constants.MAP_TOPICREF.localName);
            }
            this.added = true;
        }
    }

    private XMLUtils.AttributesBuilder getAttributes() {
        return new XMLUtils.AttributesBuilder().add("class", Constants.MAP_TOPICREF.toString());
    }
}

