/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.yaml.front.matter.internal;

import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterBlock;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterNode;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.DocumentBlockParser;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlFrontMatterBlockParser
extends AbstractBlockParser {
    private static final Pattern REGEX_METADATA = Pattern.compile("^[ ]{0,3}([A-Za-z0-9_\\-.]+):\\s*(.*)");
    private static final Pattern REGEX_METADATA_LIST = Pattern.compile("^[ ]+-\\s*(.*)");
    private static final Pattern REGEX_METADATA_LITERAL = Pattern.compile("^\\s*(.*)");
    private static final Pattern REGEX_BEGIN = Pattern.compile("^-{3}(\\s.*)?");
    private static final Pattern REGEX_END = Pattern.compile("^(-{3}|\\.{3})(\\s.*)?");
    private boolean inYAMLBlock = true;
    private boolean inLiteral = false;
    private BasedSequence currentKey = null;
    private List<BasedSequence> currentValues = new ArrayList<BasedSequence>();
    private YamlFrontMatterBlock block = new YamlFrontMatterBlock();
    private BlockContent content = new BlockContent();

    public Block getBlock() {
        return this.block;
    }

    public boolean isContainer() {
        return false;
    }

    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    public void closeBlock(ParserState state) {
        this.block.setContent(this.content.getLines().subList(0, this.content.getLineCount()));
        this.block.setCharsFromContent();
        this.content = null;
    }

    public BlockContinue tryContinue(ParserState state) {
        BasedSequence line = state.getLine();
        if (this.inYAMLBlock) {
            if (REGEX_END.matcher((CharSequence)line).matches()) {
                if (this.currentKey != null) {
                    YamlFrontMatterNode child = new YamlFrontMatterNode(this.currentKey, this.currentValues);
                    child.setCharsFromContent();
                    this.block.appendChild(child);
                }
                this.addLine(state, line);
                return BlockContinue.finished();
            }
            Matcher matcher = REGEX_METADATA.matcher((CharSequence)line);
            if (matcher.matches()) {
                if (this.currentKey != null) {
                    YamlFrontMatterNode child = new YamlFrontMatterNode(this.currentKey, this.currentValues);
                    child.setCharsFromContent();
                    this.block.appendChild(child);
                }
                this.inLiteral = false;
                this.currentKey = line.subSequence(matcher.start(1), matcher.end(1));
                this.currentValues = new ArrayList<BasedSequence>();
                if ("|".equals(matcher.group(2))) {
                    this.inLiteral = true;
                } else if (!"".equals(matcher.group(2))) {
                    this.currentValues.add(line.subSequence(matcher.start(2), matcher.end(2)));
                }
                return BlockContinue.atIndex((int)state.getIndex());
            }
            if (this.inLiteral) {
                matcher = REGEX_METADATA_LITERAL.matcher((CharSequence)line);
                if (matcher.matches()) {
                    if (this.currentValues.size() == 1) {
                        BasedSequence combined = SegmentedSequence.create((BasedSequence[])new BasedSequence[]{this.currentValues.get(0), PrefixedSubSequence.prefixOf((CharSequence)"\n", (BasedSequence)((BasedSequence)line.subSequence(matcher.start(1), matcher.end(1)).trim()))});
                        this.currentValues.set(0, combined);
                    } else {
                        this.currentValues.add((BasedSequence)line.subSequence(matcher.start(1), matcher.end(1)).trim());
                    }
                }
            } else {
                matcher = REGEX_METADATA_LIST.matcher((CharSequence)line);
                if (matcher.matches()) {
                    this.currentValues.add(line.subSequence(matcher.start(1), matcher.end(1)));
                }
            }
            return BlockContinue.atIndex((int)state.getIndex());
        }
        if (REGEX_BEGIN.matcher((CharSequence)line).matches()) {
            this.inYAMLBlock = true;
            return BlockContinue.atIndex((int)state.getIndex());
        }
        return BlockContinue.none();
    }

    public void parseInlines(InlineParser inlineParser) {
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private BlockFactory(DataHolder options) {
            super(options);
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BasedSequence line = state.getLine();
            BlockParser parentParser = matchedBlockParser.getBlockParser();
            if (parentParser instanceof DocumentBlockParser && parentParser.getBlock().getFirstChild() == null && REGEX_BEGIN.matcher((CharSequence)line).matches()) {
                return BlockStart.of((BlockParser[])new BlockParser[]{new YamlFrontMatterBlockParser()}).atIndex(state.getNextNonSpaceIndex());
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        @NotNull
        public BlockParserFactory apply(@NotNull DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

