/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.xpath.XpathQueryGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class SuppressionsStringPrinter {
    private static final Pattern VALID_SUPPRESSION_LINE_COLUMN_NUMBER_REGEX = Pattern.compile("^([0-9]+):([0-9]+)$");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private SuppressionsStringPrinter() {
    }

    public static String printSuppressions(File file, String suppressionLineColumnNumber, int tabWidth) throws IOException, CheckstyleException {
        Matcher matcher = VALID_SUPPRESSION_LINE_COLUMN_NUMBER_REGEX.matcher(suppressionLineColumnNumber);
        if (matcher.matches()) {
            FileText fileText = new FileText(file.getAbsoluteFile(), System.getProperty("file.encoding", StandardCharsets.UTF_8.name()));
            DetailAST detailAST = JavaParser.parseFileText(fileText, JavaParser.Options.WITH_COMMENTS);
            int lineNumber = Integer.parseInt(matcher.group(1));
            int columnNumber = Integer.parseInt(matcher.group(2));
            return SuppressionsStringPrinter.generate(fileText, detailAST, lineNumber, columnNumber, tabWidth);
        }
        String exceptionMsg = String.format(Locale.ROOT, "%s does not match valid format 'line:column'.", suppressionLineColumnNumber);
        throw new IllegalStateException(exceptionMsg);
    }

    private static String generate(FileText fileText, DetailAST detailAST, int lineNumber, int columnNumber, int tabWidth) {
        XpathQueryGenerator queryGenerator = new XpathQueryGenerator(detailAST, lineNumber, columnNumber, fileText, tabWidth);
        List<String> suppressions = queryGenerator.generate();
        return suppressions.stream().collect(Collectors.joining(LINE_SEPARATOR, "", LINE_SEPARATOR));
    }
}

