/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ditaa.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.ArrayList;
import java.util.Collections;
import org.stathissideris.ditaa.core.RenderingOptions;
import org.stathissideris.ditaa.core.Shape3DOrderingComparator;
import org.stathissideris.ditaa.core.ShapeAreaComparator;
import org.stathissideris.ditaa.graphics.CustomShapeDefinition;
import org.stathissideris.ditaa.graphics.Diagram;
import org.stathissideris.ditaa.graphics.DiagramShape;
import org.stathissideris.ditaa.graphics.DiagramText;
import org.stathissideris.ditaa.graphics.ImageHandler;

public class BitmapRenderer {
    private static final boolean DEBUG = false;
    Stroke normalStroke;
    Stroke dashStroke;

    public BufferedImage renderToImage(Diagram diagram, RenderingOptions options) {
        BufferedImage image = options.needsTransparency() ? new BufferedImage(diagram.getWidth(), diagram.getHeight(), 2) : new BufferedImage(diagram.getWidth(), diagram.getHeight(), 1);
        return this.render(diagram, image, options);
    }

    /*
     * WARNING - void declaration
     */
    public BufferedImage render(Diagram diagram, BufferedImage image, RenderingOptions options) {
        GeneralPath path;
        Object elements;
        BufferedImage renderedImage = image;
        Graphics2D g2 = image.createGraphics();
        Object antialiasSetting = RenderingHints.VALUE_ANTIALIAS_OFF;
        if (options.performAntialias()) {
            antialiasSetting = RenderingHints.VALUE_ANTIALIAS_ON;
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasSetting);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setColor(options.getBackgroundColor());
        g2.fillRect(0, 0, image.getWidth() + 10, image.getHeight() + 10);
        g2.setStroke(new BasicStroke(1.0f, 2, 1));
        ArrayList<DiagramShape> shapes = diagram.getAllDiagramShapes();
        if (options.dropShadows()) {
            void var12_21;
            for (DiagramShape shape : shapes) {
                if (shape.getPoints().isEmpty()) continue;
                GeneralPath path2 = shape.makeIntoRenderPath(diagram, options);
                float offset = diagram.getMinimumOfCellDimension() / 3.333f;
                if (path2 == null || !shape.dropsShadow() || shape.getType() == 9999) continue;
                GeneralPath generalPath = new GeneralPath(path2);
                AffineTransform translate = new AffineTransform();
                translate.setToTranslation(offset, offset);
                generalPath.transform(translate);
                g2.setColor(new Color(150, 150, 150));
                g2.fill(generalPath);
            }
            int blurRadius = 6;
            int blurRadius2 = blurRadius * blurRadius;
            float weight = 1.0f / (float)blurRadius2;
            elements = new float[blurRadius2];
            boolean bl = false;
            while (var12_21 < blurRadius2) {
                elements[var12_21] = weight;
                ++var12_21;
            }
            Kernel kernel = new Kernel(blurRadius, blurRadius, (float[])elements);
            ConvolveOp simpleBlur = new ConvolveOp(kernel, 1, null);
            BufferedImage destination = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
            simpleBlur.filter(image, destination);
            g2 = (Graphics2D)destination.getGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasSetting);
            renderedImage = destination;
        }
        float dashInterval = Math.min(diagram.getCellWidth(), diagram.getCellHeight()) / 2;
        float strokeWeight = diagram.getMinimumOfCellDimension() / 10.0f;
        this.normalStroke = new BasicStroke(strokeWeight, 1, 1);
        this.dashStroke = new BasicStroke(strokeWeight, 0, 1, 0.0f, new float[]{dashInterval}, 0.0f);
        ArrayList<DiagramShape> storageShapes = new ArrayList<DiagramShape>();
        elements = shapes.iterator();
        while (elements.hasNext()) {
            DiagramShape diagramShape = (DiagramShape)elements.next();
            if (diagramShape.getType() != 4) continue;
            storageShapes.add(diagramShape);
        }
        Collections.sort(storageShapes, new Shape3DOrderingComparator());
        g2.setStroke(this.normalStroke);
        for (DiagramShape diagramShape : storageShapes) {
            GeneralPath path3 = diagramShape.makeIntoRenderPath(diagram, options);
            if (!diagramShape.isStrokeDashed()) {
                if (diagramShape.getFillColor() != null) {
                    g2.setColor(diagramShape.getFillColor());
                } else {
                    g2.setColor(Color.white);
                }
                g2.fill(path3);
            }
            if (diagramShape.isStrokeDashed()) {
                g2.setStroke(this.dashStroke);
            } else {
                g2.setStroke(this.normalStroke);
            }
            g2.setColor(diagramShape.getStrokeColor());
            g2.draw(path3);
        }
        Collections.sort(shapes, new ShapeAreaComparator());
        ArrayList<DiagramShape> pointMarkers = new ArrayList<DiagramShape>();
        for (DiagramShape shape : shapes) {
            if (shape.getType() == 2) {
                pointMarkers.add(shape);
                continue;
            }
            if (shape.getType() == 4) continue;
            if (shape.getType() == 9999) {
                this.renderCustomShape(shape, g2);
                continue;
            }
            if (shape.getPoints().isEmpty()) continue;
            path = shape.makeIntoRenderPath(diagram, options);
            if (path != null && shape.isClosed() && !shape.isStrokeDashed()) {
                if (shape.getFillColor() != null) {
                    g2.setColor(shape.getFillColor());
                } else {
                    g2.setColor(Color.white);
                }
                g2.fill(path);
            }
            if (shape.getType() == 1) continue;
            g2.setColor(shape.getStrokeColor());
            if (shape.isStrokeDashed()) {
                g2.setStroke(this.dashStroke);
            } else {
                g2.setStroke(this.normalStroke);
            }
            g2.draw(path);
        }
        g2.setStroke(this.normalStroke);
        for (DiagramShape pointMarker : pointMarkers) {
            path = pointMarker.makeIntoRenderPath(diagram, options);
            g2.setColor(Color.white);
            g2.fill(path);
            g2.setColor(pointMarker.getStrokeColor());
            g2.draw(path);
        }
        for (DiagramText text : diagram.getTextObjects()) {
            g2.setFont(text.getFont());
            if (text.hasOutline()) {
                g2.setColor(text.getOutlineColor());
                g2.drawString(text.getText(), text.getXPos() + 1, text.getYPos());
                g2.drawString(text.getText(), text.getXPos() - 1, text.getYPos());
                g2.drawString(text.getText(), text.getXPos(), text.getYPos() + 1);
                g2.drawString(text.getText(), text.getXPos(), text.getYPos() - 1);
            }
            g2.setColor(text.getColor());
            g2.drawString(text.getText(), text.getXPos(), text.getYPos());
        }
        if (options.renderDebugLines()) {
            BasicStroke basicStroke = new BasicStroke(1.0f, 1, 1);
            g2.setStroke(basicStroke);
            g2.setColor(new Color(170, 170, 170));
            g2.setXORMode(Color.white);
            for (int x = 0; x < diagram.getWidth(); x += diagram.getCellWidth()) {
                g2.drawLine(x, 0, x, diagram.getHeight());
            }
            for (int y = 0; y < diagram.getHeight(); y += diagram.getCellHeight()) {
                g2.drawLine(0, y, diagram.getWidth(), y);
            }
        }
        g2.dispose();
        return renderedImage;
    }

    private void renderCustomShape(DiagramShape shape, Graphics2D g2) {
        CustomShapeDefinition definition = shape.getDefinition();
        Rectangle bounds = shape.getBounds();
        if (definition.hasBorder()) {
            g2.setColor(shape.getStrokeColor());
            if (shape.isStrokeDashed()) {
                g2.setStroke(this.dashStroke);
            } else {
                g2.setStroke(this.normalStroke);
            }
            g2.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
            g2.drawLine(bounds.x + bounds.width, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height);
            g2.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y + bounds.height);
            g2.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
        }
        if (definition.getFilename().endsWith(".png")) {
            this.renderCustomPNGShape(shape, g2);
        }
    }

    private void renderCustomPNGShape(DiagramShape shape, Graphics2D g2) {
        int height;
        int width;
        int yPos;
        int xPos;
        CustomShapeDefinition definition = shape.getDefinition();
        Rectangle bounds = shape.getBounds();
        Image graphic = ImageHandler.instance().loadImage(definition.getFilename());
        if (definition.stretches()) {
            xPos = bounds.x;
            yPos = bounds.y;
            width = bounds.width;
            height = bounds.height;
        } else {
            int newHeight = bounds.width * graphic.getHeight(null) / graphic.getWidth(null);
            if (newHeight < bounds.height) {
                height = newHeight;
                width = bounds.width;
                xPos = bounds.x;
                yPos = bounds.y + bounds.height / 2 - graphic.getHeight(null) / 2;
            } else {
                width = graphic.getWidth(null) * bounds.height / graphic.getHeight(null);
                height = bounds.height;
                xPos = bounds.x + bounds.width / 2 - graphic.getWidth(null) / 2;
                yPos = bounds.y;
            }
        }
        g2.drawImage(graphic, xPos, yPos, width, height, null);
    }

    public static boolean isColorDark(Color color) {
        int brightness = Math.max(color.getRed(), color.getGreen());
        brightness = Math.max(color.getBlue(), brightness);
        return brightness < 200;
    }
}

