/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ditaa.core;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import org.stathissideris.ditaa.graphics.CustomShapeDefinition;

public class RenderingOptions {
    private boolean fixedFontSize;
    private HashMap<String, CustomShapeDefinition> customShapes;
    private boolean dropShadows = true;
    private boolean renderDebugLines = false;
    private boolean antialias = true;
    private boolean fixedSlope = false;
    private int cellWidth = 10;
    private int cellHeight = 14;
    private float scale = 1.0f;
    private Color backgroundColor = Color.white;
    private Font font = new Font("Dialog", 1, 12);
    private String fontFamily = "sans-serif";
    private String fontURL = null;
    private ImageType imageType = ImageType.PNG;

    public ImageType getImageType() {
        return this.imageType;
    }

    public void setImageType(ImageType type) {
        this.imageType = type;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public String getFontURL() {
        return this.fontURL;
    }

    public void setFontURL(String url) {
        this.fontFamily = "Custom";
        this.fontURL = url;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public boolean dropShadows() {
        return this.dropShadows;
    }

    public boolean renderDebugLines() {
        return this.renderDebugLines;
    }

    public float getScale() {
        return this.scale;
    }

    public void setDropShadows(boolean b) {
        this.dropShadows = b;
    }

    public void setRenderDebugLines(boolean b) {
        this.renderDebugLines = b;
    }

    public void setScale(float f) {
        this.scale = f;
        this.cellWidth = (int)((float)this.cellWidth * this.scale);
        this.cellHeight = (int)((float)this.cellHeight * this.scale);
    }

    public boolean performAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean b) {
        this.antialias = b;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean needsTransparency() {
        return this.backgroundColor.getAlpha() < 255;
    }

    public boolean isFixedSlope() {
        return this.fixedSlope;
    }

    public void setFixedSlope(boolean b) {
        this.fixedSlope = b;
    }

    public String getFontName() {
        return this.font.getFontName();
    }

    public void setFontName(String fontName) {
        this.setFont(new Font(fontName, this.getFontStyle(), this.getFontSize()));
    }

    public int getFontStyle() {
        return this.font.getStyle();
    }

    public void setFontStyle(int fontStyle) {
        this.setFont(this.font.deriveFont(fontStyle));
    }

    public int getFontSize() {
        return this.font.getSize();
    }

    public void setFontSize(int fontSize) {
        this.setFont(this.font.deriveFont((float)fontSize));
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public boolean isFixedFontSize() {
        return this.fixedFontSize;
    }

    public void setFixedFontSize(boolean fixedFontSize) {
        this.fixedFontSize = fixedFontSize;
    }

    public static enum ImageType {
        PNG("png", "png"),
        SVG("svg", null);

        private String extension;
        private String formatName;

        private ImageType(String extension, String formatName) {
            this.extension = extension;
            this.formatName = formatName;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getFormatName() {
            return this.formatName;
        }
    }
}

