// Copyright 2021 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "src/execution/riscv/frame-constants-riscv.h"

#include "src/execution/frame-constants.h"
#include "src/execution/frames.h"

namespace v8 {
namespace internal {

Register JavaScriptFrame::fp_register() { return v8::internal::fp; }
Register JavaScriptFrame::context_register() { return cp; }
Register JavaScriptFrame::constant_pool_pointer_register() { UNREACHABLE(); }

int UnoptimizedFrameConstants::RegisterStackSlotCount(int register_count) {
  return register_count;
}

int BuiltinContinuationFrameConstants::PaddingSlotCount(int register_count) {
  USE(register_count);
  return 0;
}

// static
intptr_t MaglevFrame::StackGuardFrameSize(int register_input_count) {
  USE(register_input_count);
  UNREACHABLE();
}

}  // namespace internal
}  // namespace v8
