// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceTCPResponseRuleBackendOKCode is the HTTP code returned for type ReplaceTCPResponseRuleBackendOK
const ReplaceTCPResponseRuleBackendOKCode int = 200

/*
ReplaceTCPResponseRuleBackendOK TCP Response Rule replaced

swagger:response replaceTcpResponseRuleBackendOK
*/
type ReplaceTCPResponseRuleBackendOK struct {

	/*
	  In: Body
	*/
	Payload *models.TCPResponseRule `json:"body,omitempty"`
}

// NewReplaceTCPResponseRuleBackendOK creates ReplaceTCPResponseRuleBackendOK with default headers values
func NewReplaceTCPResponseRuleBackendOK() *ReplaceTCPResponseRuleBackendOK {

	return &ReplaceTCPResponseRuleBackendOK{}
}

// WithPayload adds the payload to the replace Tcp response rule backend o k response
func (o *ReplaceTCPResponseRuleBackendOK) WithPayload(payload *models.TCPResponseRule) *ReplaceTCPResponseRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp response rule backend o k response
func (o *ReplaceTCPResponseRuleBackendOK) SetPayload(payload *models.TCPResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPResponseRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTCPResponseRuleBackendAcceptedCode is the HTTP code returned for type ReplaceTCPResponseRuleBackendAccepted
const ReplaceTCPResponseRuleBackendAcceptedCode int = 202

/*
ReplaceTCPResponseRuleBackendAccepted Configuration change accepted and reload requested

swagger:response replaceTcpResponseRuleBackendAccepted
*/
type ReplaceTCPResponseRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.TCPResponseRule `json:"body,omitempty"`
}

// NewReplaceTCPResponseRuleBackendAccepted creates ReplaceTCPResponseRuleBackendAccepted with default headers values
func NewReplaceTCPResponseRuleBackendAccepted() *ReplaceTCPResponseRuleBackendAccepted {

	return &ReplaceTCPResponseRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace Tcp response rule backend accepted response
func (o *ReplaceTCPResponseRuleBackendAccepted) WithReloadID(reloadID string) *ReplaceTCPResponseRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Tcp response rule backend accepted response
func (o *ReplaceTCPResponseRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Tcp response rule backend accepted response
func (o *ReplaceTCPResponseRuleBackendAccepted) WithPayload(payload *models.TCPResponseRule) *ReplaceTCPResponseRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp response rule backend accepted response
func (o *ReplaceTCPResponseRuleBackendAccepted) SetPayload(payload *models.TCPResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPResponseRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTCPResponseRuleBackendBadRequestCode is the HTTP code returned for type ReplaceTCPResponseRuleBackendBadRequest
const ReplaceTCPResponseRuleBackendBadRequestCode int = 400

/*
ReplaceTCPResponseRuleBackendBadRequest Bad request

swagger:response replaceTcpResponseRuleBackendBadRequest
*/
type ReplaceTCPResponseRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTCPResponseRuleBackendBadRequest creates ReplaceTCPResponseRuleBackendBadRequest with default headers values
func NewReplaceTCPResponseRuleBackendBadRequest() *ReplaceTCPResponseRuleBackendBadRequest {

	return &ReplaceTCPResponseRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Tcp response rule backend bad request response
func (o *ReplaceTCPResponseRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceTCPResponseRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Tcp response rule backend bad request response
func (o *ReplaceTCPResponseRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Tcp response rule backend bad request response
func (o *ReplaceTCPResponseRuleBackendBadRequest) WithPayload(payload *models.Error) *ReplaceTCPResponseRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp response rule backend bad request response
func (o *ReplaceTCPResponseRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPResponseRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTCPResponseRuleBackendNotFoundCode is the HTTP code returned for type ReplaceTCPResponseRuleBackendNotFound
const ReplaceTCPResponseRuleBackendNotFoundCode int = 404

/*
ReplaceTCPResponseRuleBackendNotFound The specified resource was not found

swagger:response replaceTcpResponseRuleBackendNotFound
*/
type ReplaceTCPResponseRuleBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTCPResponseRuleBackendNotFound creates ReplaceTCPResponseRuleBackendNotFound with default headers values
func NewReplaceTCPResponseRuleBackendNotFound() *ReplaceTCPResponseRuleBackendNotFound {

	return &ReplaceTCPResponseRuleBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Tcp response rule backend not found response
func (o *ReplaceTCPResponseRuleBackendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceTCPResponseRuleBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Tcp response rule backend not found response
func (o *ReplaceTCPResponseRuleBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Tcp response rule backend not found response
func (o *ReplaceTCPResponseRuleBackendNotFound) WithPayload(payload *models.Error) *ReplaceTCPResponseRuleBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp response rule backend not found response
func (o *ReplaceTCPResponseRuleBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPResponseRuleBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceTCPResponseRuleBackendDefault General Error

swagger:response replaceTcpResponseRuleBackendDefault
*/
type ReplaceTCPResponseRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTCPResponseRuleBackendDefault creates ReplaceTCPResponseRuleBackendDefault with default headers values
func NewReplaceTCPResponseRuleBackendDefault(code int) *ReplaceTCPResponseRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceTCPResponseRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace TCP response rule backend default response
func (o *ReplaceTCPResponseRuleBackendDefault) WithStatusCode(code int) *ReplaceTCPResponseRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace TCP response rule backend default response
func (o *ReplaceTCPResponseRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace TCP response rule backend default response
func (o *ReplaceTCPResponseRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceTCPResponseRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace TCP response rule backend default response
func (o *ReplaceTCPResponseRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace TCP response rule backend default response
func (o *ReplaceTCPResponseRuleBackendDefault) WithPayload(payload *models.Error) *ReplaceTCPResponseRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace TCP response rule backend default response
func (o *ReplaceTCPResponseRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPResponseRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
