// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetSpoeGroupOKCode is the HTTP code returned for type GetSpoeGroupOK
const GetSpoeGroupOKCode int = 200

/*
GetSpoeGroupOK Successful operation

swagger:response getSpoeGroupOK
*/
type GetSpoeGroupOK struct {
	/*Spoe configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.SpoeGroup `json:"body,omitempty"`
}

// NewGetSpoeGroupOK creates GetSpoeGroupOK with default headers values
func NewGetSpoeGroupOK() *GetSpoeGroupOK {

	return &GetSpoeGroupOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get spoe group o k response
func (o *GetSpoeGroupOK) WithConfigurationVersion(configurationVersion string) *GetSpoeGroupOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get spoe group o k response
func (o *GetSpoeGroupOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get spoe group o k response
func (o *GetSpoeGroupOK) WithPayload(payload *models.SpoeGroup) *GetSpoeGroupOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get spoe group o k response
func (o *GetSpoeGroupOK) SetPayload(payload *models.SpoeGroup) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetSpoeGroupOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetSpoeGroupNotFoundCode is the HTTP code returned for type GetSpoeGroupNotFound
const GetSpoeGroupNotFoundCode int = 404

/*
GetSpoeGroupNotFound The specified resource was not found

swagger:response getSpoeGroupNotFound
*/
type GetSpoeGroupNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetSpoeGroupNotFound creates GetSpoeGroupNotFound with default headers values
func NewGetSpoeGroupNotFound() *GetSpoeGroupNotFound {

	return &GetSpoeGroupNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get spoe group not found response
func (o *GetSpoeGroupNotFound) WithConfigurationVersion(configurationVersion string) *GetSpoeGroupNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get spoe group not found response
func (o *GetSpoeGroupNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get spoe group not found response
func (o *GetSpoeGroupNotFound) WithPayload(payload *models.Error) *GetSpoeGroupNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get spoe group not found response
func (o *GetSpoeGroupNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetSpoeGroupNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetSpoeGroupDefault General Error

swagger:response getSpoeGroupDefault
*/
type GetSpoeGroupDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetSpoeGroupDefault creates GetSpoeGroupDefault with default headers values
func NewGetSpoeGroupDefault(code int) *GetSpoeGroupDefault {
	if code <= 0 {
		code = 500
	}

	return &GetSpoeGroupDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get spoe group default response
func (o *GetSpoeGroupDefault) WithStatusCode(code int) *GetSpoeGroupDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get spoe group default response
func (o *GetSpoeGroupDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get spoe group default response
func (o *GetSpoeGroupDefault) WithConfigurationVersion(configurationVersion string) *GetSpoeGroupDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get spoe group default response
func (o *GetSpoeGroupDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get spoe group default response
func (o *GetSpoeGroupDefault) WithPayload(payload *models.Error) *GetSpoeGroupDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get spoe group default response
func (o *GetSpoeGroupDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetSpoeGroupDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
