// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package resolver

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateResolverCreatedCode is the HTTP code returned for type CreateResolverCreated
const CreateResolverCreatedCode int = 201

/*
CreateResolverCreated Resolver created

swagger:response createResolverCreated
*/
type CreateResolverCreated struct {

	/*
	  In: Body
	*/
	Payload *models.Resolver `json:"body,omitempty"`
}

// NewCreateResolverCreated creates CreateResolverCreated with default headers values
func NewCreateResolverCreated() *CreateResolverCreated {

	return &CreateResolverCreated{}
}

// WithPayload adds the payload to the create resolver created response
func (o *CreateResolverCreated) WithPayload(payload *models.Resolver) *CreateResolverCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create resolver created response
func (o *CreateResolverCreated) SetPayload(payload *models.Resolver) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateResolverCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateResolverAcceptedCode is the HTTP code returned for type CreateResolverAccepted
const CreateResolverAcceptedCode int = 202

/*
CreateResolverAccepted Configuration change accepted and reload requested

swagger:response createResolverAccepted
*/
type CreateResolverAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Resolver `json:"body,omitempty"`
}

// NewCreateResolverAccepted creates CreateResolverAccepted with default headers values
func NewCreateResolverAccepted() *CreateResolverAccepted {

	return &CreateResolverAccepted{}
}

// WithReloadID adds the reloadId to the create resolver accepted response
func (o *CreateResolverAccepted) WithReloadID(reloadID string) *CreateResolverAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create resolver accepted response
func (o *CreateResolverAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create resolver accepted response
func (o *CreateResolverAccepted) WithPayload(payload *models.Resolver) *CreateResolverAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create resolver accepted response
func (o *CreateResolverAccepted) SetPayload(payload *models.Resolver) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateResolverAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateResolverBadRequestCode is the HTTP code returned for type CreateResolverBadRequest
const CreateResolverBadRequestCode int = 400

/*
CreateResolverBadRequest Bad request

swagger:response createResolverBadRequest
*/
type CreateResolverBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateResolverBadRequest creates CreateResolverBadRequest with default headers values
func NewCreateResolverBadRequest() *CreateResolverBadRequest {

	return &CreateResolverBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create resolver bad request response
func (o *CreateResolverBadRequest) WithConfigurationVersion(configurationVersion string) *CreateResolverBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create resolver bad request response
func (o *CreateResolverBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create resolver bad request response
func (o *CreateResolverBadRequest) WithPayload(payload *models.Error) *CreateResolverBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create resolver bad request response
func (o *CreateResolverBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateResolverBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateResolverConflictCode is the HTTP code returned for type CreateResolverConflict
const CreateResolverConflictCode int = 409

/*
CreateResolverConflict The specified resource already exists

swagger:response createResolverConflict
*/
type CreateResolverConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateResolverConflict creates CreateResolverConflict with default headers values
func NewCreateResolverConflict() *CreateResolverConflict {

	return &CreateResolverConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create resolver conflict response
func (o *CreateResolverConflict) WithConfigurationVersion(configurationVersion string) *CreateResolverConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create resolver conflict response
func (o *CreateResolverConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create resolver conflict response
func (o *CreateResolverConflict) WithPayload(payload *models.Error) *CreateResolverConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create resolver conflict response
func (o *CreateResolverConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateResolverConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateResolverDefault General Error

swagger:response createResolverDefault
*/
type CreateResolverDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateResolverDefault creates CreateResolverDefault with default headers values
func NewCreateResolverDefault(code int) *CreateResolverDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateResolverDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create resolver default response
func (o *CreateResolverDefault) WithStatusCode(code int) *CreateResolverDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create resolver default response
func (o *CreateResolverDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create resolver default response
func (o *CreateResolverDefault) WithConfigurationVersion(configurationVersion string) *CreateResolverDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create resolver default response
func (o *CreateResolverDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create resolver default response
func (o *CreateResolverDefault) WithPayload(payload *models.Error) *CreateResolverDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create resolver default response
func (o *CreateResolverDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateResolverDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
