// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package maps

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ShowRuntimeMapOKCode is the HTTP code returned for type ShowRuntimeMapOK
const ShowRuntimeMapOKCode int = 200

/*
ShowRuntimeMapOK Successful operation

swagger:response showRuntimeMapOK
*/
type ShowRuntimeMapOK struct {

	/*
	  In: Body
	*/
	Payload models.MapEntries `json:"body,omitempty"`
}

// NewShowRuntimeMapOK creates ShowRuntimeMapOK with default headers values
func NewShowRuntimeMapOK() *ShowRuntimeMapOK {

	return &ShowRuntimeMapOK{}
}

// WithPayload adds the payload to the show runtime map o k response
func (o *ShowRuntimeMapOK) WithPayload(payload models.MapEntries) *ShowRuntimeMapOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the show runtime map o k response
func (o *ShowRuntimeMapOK) SetPayload(payload models.MapEntries) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ShowRuntimeMapOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.MapEntries{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ShowRuntimeMapNotFoundCode is the HTTP code returned for type ShowRuntimeMapNotFound
const ShowRuntimeMapNotFoundCode int = 404

/*
ShowRuntimeMapNotFound The specified resource was not found

swagger:response showRuntimeMapNotFound
*/
type ShowRuntimeMapNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewShowRuntimeMapNotFound creates ShowRuntimeMapNotFound with default headers values
func NewShowRuntimeMapNotFound() *ShowRuntimeMapNotFound {

	return &ShowRuntimeMapNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the show runtime map not found response
func (o *ShowRuntimeMapNotFound) WithConfigurationVersion(configurationVersion string) *ShowRuntimeMapNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the show runtime map not found response
func (o *ShowRuntimeMapNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the show runtime map not found response
func (o *ShowRuntimeMapNotFound) WithPayload(payload *models.Error) *ShowRuntimeMapNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the show runtime map not found response
func (o *ShowRuntimeMapNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ShowRuntimeMapNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ShowRuntimeMapDefault General Error

swagger:response showRuntimeMapDefault
*/
type ShowRuntimeMapDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewShowRuntimeMapDefault creates ShowRuntimeMapDefault with default headers values
func NewShowRuntimeMapDefault(code int) *ShowRuntimeMapDefault {
	if code <= 0 {
		code = 500
	}

	return &ShowRuntimeMapDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the show runtime map default response
func (o *ShowRuntimeMapDefault) WithStatusCode(code int) *ShowRuntimeMapDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the show runtime map default response
func (o *ShowRuntimeMapDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the show runtime map default response
func (o *ShowRuntimeMapDefault) WithConfigurationVersion(configurationVersion string) *ShowRuntimeMapDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the show runtime map default response
func (o *ShowRuntimeMapDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the show runtime map default response
func (o *ShowRuntimeMapDefault) WithPayload(payload *models.Error) *ShowRuntimeMapDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the show runtime map default response
func (o *ShowRuntimeMapDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ShowRuntimeMapDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
