// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_errors

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetHTTPErrorsSectionOKCode is the HTTP code returned for type GetHTTPErrorsSectionOK
const GetHTTPErrorsSectionOKCode int = 200

/*
GetHTTPErrorsSectionOK Successful operation

swagger:response getHttpErrorsSectionOK
*/
type GetHTTPErrorsSectionOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorsSection `json:"body,omitempty"`
}

// NewGetHTTPErrorsSectionOK creates GetHTTPErrorsSectionOK with default headers values
func NewGetHTTPErrorsSectionOK() *GetHTTPErrorsSectionOK {

	return &GetHTTPErrorsSectionOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http errors section o k response
func (o *GetHTTPErrorsSectionOK) WithConfigurationVersion(configurationVersion string) *GetHTTPErrorsSectionOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http errors section o k response
func (o *GetHTTPErrorsSectionOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http errors section o k response
func (o *GetHTTPErrorsSectionOK) WithPayload(payload *models.HTTPErrorsSection) *GetHTTPErrorsSectionOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http errors section o k response
func (o *GetHTTPErrorsSectionOK) SetPayload(payload *models.HTTPErrorsSection) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPErrorsSectionOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetHTTPErrorsSectionNotFoundCode is the HTTP code returned for type GetHTTPErrorsSectionNotFound
const GetHTTPErrorsSectionNotFoundCode int = 404

/*
GetHTTPErrorsSectionNotFound The specified resource was not found

swagger:response getHttpErrorsSectionNotFound
*/
type GetHTTPErrorsSectionNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPErrorsSectionNotFound creates GetHTTPErrorsSectionNotFound with default headers values
func NewGetHTTPErrorsSectionNotFound() *GetHTTPErrorsSectionNotFound {

	return &GetHTTPErrorsSectionNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http errors section not found response
func (o *GetHTTPErrorsSectionNotFound) WithConfigurationVersion(configurationVersion string) *GetHTTPErrorsSectionNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http errors section not found response
func (o *GetHTTPErrorsSectionNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http errors section not found response
func (o *GetHTTPErrorsSectionNotFound) WithPayload(payload *models.Error) *GetHTTPErrorsSectionNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http errors section not found response
func (o *GetHTTPErrorsSectionNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPErrorsSectionNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetHTTPErrorsSectionDefault General Error

swagger:response getHttpErrorsSectionDefault
*/
type GetHTTPErrorsSectionDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPErrorsSectionDefault creates GetHTTPErrorsSectionDefault with default headers values
func NewGetHTTPErrorsSectionDefault(code int) *GetHTTPErrorsSectionDefault {
	if code <= 0 {
		code = 500
	}

	return &GetHTTPErrorsSectionDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get HTTP errors section default response
func (o *GetHTTPErrorsSectionDefault) WithStatusCode(code int) *GetHTTPErrorsSectionDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get HTTP errors section default response
func (o *GetHTTPErrorsSectionDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get HTTP errors section default response
func (o *GetHTTPErrorsSectionDefault) WithConfigurationVersion(configurationVersion string) *GetHTTPErrorsSectionDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get HTTP errors section default response
func (o *GetHTTPErrorsSectionDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get HTTP errors section default response
func (o *GetHTTPErrorsSectionDefault) WithPayload(payload *models.Error) *GetHTTPErrorsSectionDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get HTTP errors section default response
func (o *GetHTTPErrorsSectionDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPErrorsSectionDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
