// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteHTTPCheckBackendAcceptedCode is the HTTP code returned for type DeleteHTTPCheckBackendAccepted
const DeleteHTTPCheckBackendAcceptedCode int = 202

/*
DeleteHTTPCheckBackendAccepted Configuration change accepted and reload requested

swagger:response deleteHttpCheckBackendAccepted
*/
type DeleteHTTPCheckBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteHTTPCheckBackendAccepted creates DeleteHTTPCheckBackendAccepted with default headers values
func NewDeleteHTTPCheckBackendAccepted() *DeleteHTTPCheckBackendAccepted {

	return &DeleteHTTPCheckBackendAccepted{}
}

// WithReloadID adds the reloadId to the delete Http check backend accepted response
func (o *DeleteHTTPCheckBackendAccepted) WithReloadID(reloadID string) *DeleteHTTPCheckBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Http check backend accepted response
func (o *DeleteHTTPCheckBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteHTTPCheckBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteHTTPCheckBackendNoContentCode is the HTTP code returned for type DeleteHTTPCheckBackendNoContent
const DeleteHTTPCheckBackendNoContentCode int = 204

/*
DeleteHTTPCheckBackendNoContent HTTP check deleted

swagger:response deleteHttpCheckBackendNoContent
*/
type DeleteHTTPCheckBackendNoContent struct {
}

// NewDeleteHTTPCheckBackendNoContent creates DeleteHTTPCheckBackendNoContent with default headers values
func NewDeleteHTTPCheckBackendNoContent() *DeleteHTTPCheckBackendNoContent {

	return &DeleteHTTPCheckBackendNoContent{}
}

// WriteResponse to the client
func (o *DeleteHTTPCheckBackendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteHTTPCheckBackendNotFoundCode is the HTTP code returned for type DeleteHTTPCheckBackendNotFound
const DeleteHTTPCheckBackendNotFoundCode int = 404

/*
DeleteHTTPCheckBackendNotFound The specified resource was not found

swagger:response deleteHttpCheckBackendNotFound
*/
type DeleteHTTPCheckBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPCheckBackendNotFound creates DeleteHTTPCheckBackendNotFound with default headers values
func NewDeleteHTTPCheckBackendNotFound() *DeleteHTTPCheckBackendNotFound {

	return &DeleteHTTPCheckBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Http check backend not found response
func (o *DeleteHTTPCheckBackendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteHTTPCheckBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Http check backend not found response
func (o *DeleteHTTPCheckBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Http check backend not found response
func (o *DeleteHTTPCheckBackendNotFound) WithPayload(payload *models.Error) *DeleteHTTPCheckBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Http check backend not found response
func (o *DeleteHTTPCheckBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPCheckBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteHTTPCheckBackendDefault General Error

swagger:response deleteHttpCheckBackendDefault
*/
type DeleteHTTPCheckBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPCheckBackendDefault creates DeleteHTTPCheckBackendDefault with default headers values
func NewDeleteHTTPCheckBackendDefault(code int) *DeleteHTTPCheckBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteHTTPCheckBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete HTTP check backend default response
func (o *DeleteHTTPCheckBackendDefault) WithStatusCode(code int) *DeleteHTTPCheckBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete HTTP check backend default response
func (o *DeleteHTTPCheckBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete HTTP check backend default response
func (o *DeleteHTTPCheckBackendDefault) WithConfigurationVersion(configurationVersion string) *DeleteHTTPCheckBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete HTTP check backend default response
func (o *DeleteHTTPCheckBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete HTTP check backend default response
func (o *DeleteHTTPCheckBackendDefault) WithPayload(payload *models.Error) *DeleteHTTPCheckBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete HTTP check backend default response
func (o *DeleteHTTPCheckBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPCheckBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
