// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl_runtime

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// PostServicesHaproxyRuntimeAclsParentNameEntriesCreatedCode is the HTTP code returned for type PostServicesHaproxyRuntimeAclsParentNameEntriesCreated
const PostServicesHaproxyRuntimeAclsParentNameEntriesCreatedCode int = 201

/*
PostServicesHaproxyRuntimeAclsParentNameEntriesCreated ACL entry created

swagger:response postServicesHaproxyRuntimeAclsParentNameEntriesCreated
*/
type PostServicesHaproxyRuntimeAclsParentNameEntriesCreated struct {

	/*
	  In: Body
	*/
	Payload *models.ACLFileEntry `json:"body,omitempty"`
}

// NewPostServicesHaproxyRuntimeAclsParentNameEntriesCreated creates PostServicesHaproxyRuntimeAclsParentNameEntriesCreated with default headers values
func NewPostServicesHaproxyRuntimeAclsParentNameEntriesCreated() *PostServicesHaproxyRuntimeAclsParentNameEntriesCreated {

	return &PostServicesHaproxyRuntimeAclsParentNameEntriesCreated{}
}

// WithPayload adds the payload to the post services haproxy runtime acls parent name entries created response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesCreated) WithPayload(payload *models.ACLFileEntry) *PostServicesHaproxyRuntimeAclsParentNameEntriesCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the post services haproxy runtime acls parent name entries created response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesCreated) SetPayload(payload *models.ACLFileEntry) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequestCode is the HTTP code returned for type PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest
const PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequestCode int = 400

/*
PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest Bad request

swagger:response postServicesHaproxyRuntimeAclsParentNameEntriesBadRequest
*/
type PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewPostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest creates PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest with default headers values
func NewPostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest() *PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest {

	return &PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the post services haproxy runtime acls parent name entries bad request response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest) WithConfigurationVersion(configurationVersion string) *PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the post services haproxy runtime acls parent name entries bad request response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the post services haproxy runtime acls parent name entries bad request response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest) WithPayload(payload *models.Error) *PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the post services haproxy runtime acls parent name entries bad request response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// PostServicesHaproxyRuntimeAclsParentNameEntriesConflictCode is the HTTP code returned for type PostServicesHaproxyRuntimeAclsParentNameEntriesConflict
const PostServicesHaproxyRuntimeAclsParentNameEntriesConflictCode int = 409

/*
PostServicesHaproxyRuntimeAclsParentNameEntriesConflict The specified resource already exists

swagger:response postServicesHaproxyRuntimeAclsParentNameEntriesConflict
*/
type PostServicesHaproxyRuntimeAclsParentNameEntriesConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewPostServicesHaproxyRuntimeAclsParentNameEntriesConflict creates PostServicesHaproxyRuntimeAclsParentNameEntriesConflict with default headers values
func NewPostServicesHaproxyRuntimeAclsParentNameEntriesConflict() *PostServicesHaproxyRuntimeAclsParentNameEntriesConflict {

	return &PostServicesHaproxyRuntimeAclsParentNameEntriesConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the post services haproxy runtime acls parent name entries conflict response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesConflict) WithConfigurationVersion(configurationVersion string) *PostServicesHaproxyRuntimeAclsParentNameEntriesConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the post services haproxy runtime acls parent name entries conflict response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the post services haproxy runtime acls parent name entries conflict response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesConflict) WithPayload(payload *models.Error) *PostServicesHaproxyRuntimeAclsParentNameEntriesConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the post services haproxy runtime acls parent name entries conflict response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
PostServicesHaproxyRuntimeAclsParentNameEntriesDefault General Error

swagger:response postServicesHaproxyRuntimeAclsParentNameEntriesDefault
*/
type PostServicesHaproxyRuntimeAclsParentNameEntriesDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewPostServicesHaproxyRuntimeAclsParentNameEntriesDefault creates PostServicesHaproxyRuntimeAclsParentNameEntriesDefault with default headers values
func NewPostServicesHaproxyRuntimeAclsParentNameEntriesDefault(code int) *PostServicesHaproxyRuntimeAclsParentNameEntriesDefault {
	if code <= 0 {
		code = 500
	}

	return &PostServicesHaproxyRuntimeAclsParentNameEntriesDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the post services haproxy runtime acls parent name entries default response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesDefault) WithStatusCode(code int) *PostServicesHaproxyRuntimeAclsParentNameEntriesDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the post services haproxy runtime acls parent name entries default response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the post services haproxy runtime acls parent name entries default response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesDefault) WithConfigurationVersion(configurationVersion string) *PostServicesHaproxyRuntimeAclsParentNameEntriesDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the post services haproxy runtime acls parent name entries default response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the post services haproxy runtime acls parent name entries default response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesDefault) WithPayload(payload *models.Error) *PostServicesHaproxyRuntimeAclsParentNameEntriesDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the post services haproxy runtime acls parent name entries default response
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *PostServicesHaproxyRuntimeAclsParentNameEntriesDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
