// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceACLFCGIAppOKCode is the HTTP code returned for type ReplaceACLFCGIAppOK
const ReplaceACLFCGIAppOKCode int = 200

/*
ReplaceACLFCGIAppOK ACL line replaced

swagger:response replaceAclFcgiAppOK
*/
type ReplaceACLFCGIAppOK struct {

	/*
	  In: Body
	*/
	Payload *models.ACL `json:"body,omitempty"`
}

// NewReplaceACLFCGIAppOK creates ReplaceACLFCGIAppOK with default headers values
func NewReplaceACLFCGIAppOK() *ReplaceACLFCGIAppOK {

	return &ReplaceACLFCGIAppOK{}
}

// WithPayload adds the payload to the replace Acl Fcgi app o k response
func (o *ReplaceACLFCGIAppOK) WithPayload(payload *models.ACL) *ReplaceACLFCGIAppOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl Fcgi app o k response
func (o *ReplaceACLFCGIAppOK) SetPayload(payload *models.ACL) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLFCGIAppOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceACLFCGIAppAcceptedCode is the HTTP code returned for type ReplaceACLFCGIAppAccepted
const ReplaceACLFCGIAppAcceptedCode int = 202

/*
ReplaceACLFCGIAppAccepted Configuration change accepted and reload requested

swagger:response replaceAclFcgiAppAccepted
*/
type ReplaceACLFCGIAppAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.ACL `json:"body,omitempty"`
}

// NewReplaceACLFCGIAppAccepted creates ReplaceACLFCGIAppAccepted with default headers values
func NewReplaceACLFCGIAppAccepted() *ReplaceACLFCGIAppAccepted {

	return &ReplaceACLFCGIAppAccepted{}
}

// WithReloadID adds the reloadId to the replace Acl Fcgi app accepted response
func (o *ReplaceACLFCGIAppAccepted) WithReloadID(reloadID string) *ReplaceACLFCGIAppAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Acl Fcgi app accepted response
func (o *ReplaceACLFCGIAppAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Acl Fcgi app accepted response
func (o *ReplaceACLFCGIAppAccepted) WithPayload(payload *models.ACL) *ReplaceACLFCGIAppAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl Fcgi app accepted response
func (o *ReplaceACLFCGIAppAccepted) SetPayload(payload *models.ACL) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLFCGIAppAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceACLFCGIAppBadRequestCode is the HTTP code returned for type ReplaceACLFCGIAppBadRequest
const ReplaceACLFCGIAppBadRequestCode int = 400

/*
ReplaceACLFCGIAppBadRequest Bad request

swagger:response replaceAclFcgiAppBadRequest
*/
type ReplaceACLFCGIAppBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceACLFCGIAppBadRequest creates ReplaceACLFCGIAppBadRequest with default headers values
func NewReplaceACLFCGIAppBadRequest() *ReplaceACLFCGIAppBadRequest {

	return &ReplaceACLFCGIAppBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Acl Fcgi app bad request response
func (o *ReplaceACLFCGIAppBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceACLFCGIAppBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Acl Fcgi app bad request response
func (o *ReplaceACLFCGIAppBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Acl Fcgi app bad request response
func (o *ReplaceACLFCGIAppBadRequest) WithPayload(payload *models.Error) *ReplaceACLFCGIAppBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl Fcgi app bad request response
func (o *ReplaceACLFCGIAppBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLFCGIAppBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceACLFCGIAppNotFoundCode is the HTTP code returned for type ReplaceACLFCGIAppNotFound
const ReplaceACLFCGIAppNotFoundCode int = 404

/*
ReplaceACLFCGIAppNotFound The specified resource was not found

swagger:response replaceAclFcgiAppNotFound
*/
type ReplaceACLFCGIAppNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceACLFCGIAppNotFound creates ReplaceACLFCGIAppNotFound with default headers values
func NewReplaceACLFCGIAppNotFound() *ReplaceACLFCGIAppNotFound {

	return &ReplaceACLFCGIAppNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Acl Fcgi app not found response
func (o *ReplaceACLFCGIAppNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceACLFCGIAppNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Acl Fcgi app not found response
func (o *ReplaceACLFCGIAppNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Acl Fcgi app not found response
func (o *ReplaceACLFCGIAppNotFound) WithPayload(payload *models.Error) *ReplaceACLFCGIAppNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl Fcgi app not found response
func (o *ReplaceACLFCGIAppNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLFCGIAppNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceACLFCGIAppDefault General Error

swagger:response replaceAclFcgiAppDefault
*/
type ReplaceACLFCGIAppDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceACLFCGIAppDefault creates ReplaceACLFCGIAppDefault with default headers values
func NewReplaceACLFCGIAppDefault(code int) *ReplaceACLFCGIAppDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceACLFCGIAppDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace Acl FCGI app default response
func (o *ReplaceACLFCGIAppDefault) WithStatusCode(code int) *ReplaceACLFCGIAppDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace Acl FCGI app default response
func (o *ReplaceACLFCGIAppDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace Acl FCGI app default response
func (o *ReplaceACLFCGIAppDefault) WithConfigurationVersion(configurationVersion string) *ReplaceACLFCGIAppDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Acl FCGI app default response
func (o *ReplaceACLFCGIAppDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Acl FCGI app default response
func (o *ReplaceACLFCGIAppDefault) WithPayload(payload *models.Error) *ReplaceACLFCGIAppDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl FCGI app default response
func (o *ReplaceACLFCGIAppDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLFCGIAppDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
